// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/radius/radius.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/radius/radius_pac.h"

namespace binpac {






namespace RADIUS {
ContextRADIUS::ContextRADIUS(RADIUS_Conn* connection, RADIUS_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextRADIUS::~ContextRADIUS() {
}

RADIUS_Conn::RADIUS_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new RADIUS_Flow(this, true);
    downflow_ = new RADIUS_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

RADIUS_Conn::~RADIUS_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void RADIUS_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void RADIUS_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void RADIUS_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

RADIUS_PDU::RADIUS_PDU(bool is_orig) {
    code_ = 0;
    trans_id_ = 0;
    length_ = 0;
    attributes_ = nullptr;
    attributes__elem_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    proc_ = false;
}

RADIUS_PDU::~RADIUS_PDU() {
    authenticator_.free();
    delete attributes__elem_;
    attributes__elem_ = nullptr;
    if ( attributes() ) {
        for ( auto* attributes__elem_ : *attributes() ) {
            delete attributes__elem_;
            attributes__elem_ = nullptr;
        }
    }
    delete attributes_;
}

int RADIUS_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRADIUS* t_context) {
    // Checking out-of-bound for "RADIUS_PDU:length"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RADIUS_PDU:length",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "trans_id"
    trans_id_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "authenticator"
    // Checking out-of-bound for "RADIUS_PDU:authenticator"
    if ( (t_begin_of_data + 4) + (16) > t_end_of_data || (t_begin_of_data + 4) + (16) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RADIUS_PDU:authenticator",
        	(4) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + 16;
        int t_authenticator_string_length;
        t_authenticator_string_length = 16;
        int t_authenticator__size;
        t_authenticator__size = t_authenticator_string_length;
        authenticator_.init((t_begin_of_data + 4), t_authenticator_string_length);
    }

    const_byteptr const t_dataptr_after_authenticator = (t_begin_of_data + 4) + (16);
    BINPAC_ASSERT(t_dataptr_after_authenticator <= t_end_of_data);
    // Parse "attributes"
    int t_attributes__arraylength;
    t_attributes__arraylength = 0;
    attributes__elem_ = nullptr;
    int t_attributes__elem__it;
    t_attributes__elem__it = 0;
    int t_attributes__size;
    attributes_ = new vector<RADIUS_Attribute*>;
    const_byteptr t_attributes__elem__dataptr = t_dataptr_after_authenticator;
    for (; /* forever */; ++t_attributes__elem__it) {
        // Check &until(attributes__elem__dataptr >= end_of_data)
        if ( t_attributes__elem__dataptr >= t_end_of_data ) {
            attributes__elem_ = nullptr;
            goto end_of_attributes;
        }
        attributes__elem_ = new RADIUS_Attribute(trans_id());
        int t_attributes__elem__size;
        t_attributes__elem__size = attributes__elem_->Parse(t_attributes__elem__dataptr, t_end_of_data, t_context);
        attributes_->push_back(attributes__elem_);
        t_attributes__elem__dataptr += t_attributes__elem__size;
        BINPAC_ASSERT(t_attributes__elem__dataptr <= t_end_of_data);
        attributes__elem_ = nullptr;
    }
end_of_attributes: ;
    t_attributes__size = t_attributes__elem__dataptr - (t_dataptr_after_authenticator);
    // Evaluate 'let' and 'withinput' fields

    int t_RADIUS_PDU__size;
    const_byteptr const t_dataptr_after_attributes = t_dataptr_after_authenticator + (t_attributes__size);
    BINPAC_ASSERT(t_dataptr_after_attributes <= t_end_of_data);
    t_RADIUS_PDU__size = t_dataptr_after_attributes - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_radius_message(this);
    BINPAC_ASSERT(t_begin_of_data + (t_RADIUS_PDU__size) <= t_end_of_data);
    return t_RADIUS_PDU__size;
}

RADIUS_Attribute::RADIUS_Attribute(uint8 trans_id) {
    code_ = 0;
    length_ = 0;
    trans_id_ = trans_id;
    proc_ = false;
}

RADIUS_Attribute::~RADIUS_Attribute() {
    value_.free();
}

int RADIUS_Attribute::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRADIUS* t_context) {
    // Checking out-of-bound for "RADIUS_Attribute:length"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RADIUS_Attribute:length",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "value"
    int t_value__size;
    t_value__size = length() - 2;
    // Checking out-of-bound for "RADIUS_Attribute:value"
    if ( (t_begin_of_data + 2) + (t_value__size) > t_end_of_data || (t_begin_of_data + 2) + (t_value__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RADIUS_Attribute:value",
        	(2) + (t_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_value__size;
        int t_value_string_length;
        t_value_string_length = length() - 2;
        // check for negative sizes
        if ( t_value_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/radius/radius-protocol.pac:13", t_value_string_length);
        value_.init((t_begin_of_data + 2), t_value_string_length);
    }

    int t_RADIUS_Attribute__size;
    const_byteptr const t_dataptr_after_value = (t_begin_of_data + 2) + (t_value__size);
    BINPAC_ASSERT(t_dataptr_after_value <= t_end_of_data);
    t_RADIUS_Attribute__size = t_dataptr_after_value - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_radius_attribute(this);
    BINPAC_ASSERT(t_begin_of_data + (t_RADIUS_Attribute__size) <= t_end_of_data);
    return t_RADIUS_Attribute__size;
}

RADIUS_Flow::RADIUS_Flow(RADIUS_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

RADIUS_Flow::~RADIUS_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void RADIUS_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new RADIUS_PDU(is_orig());
        context_ = new ContextRADIUS(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void RADIUS_Flow::NewGap(int gap_length) {
}
void RADIUS_Flow::FlowEOF() {
}
bool RADIUS_Flow::proc_radius_message(RADIUS_PDU* msg) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();

		if ( ! radius_message )
			return false;

		auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::RADIUS::Message);
		result->Assign(0, msg->code());
		result->Assign(1, msg->trans_id());
		result->Assign(2, to_stringval(msg->authenticator()));

		if ( ! msg->attributes()->empty() )
			{
			auto attributes = zeek::make_intrusive<zeek::TableVal>(zeek::BifType::Table::RADIUS::Attributes);

			for ( const auto& attr : *(msg->attributes()) )
				{
				auto index = zeek::val_mgr->Count(attr->code());

				// Do we already have a vector of attributes for this type?
				auto current = attributes->FindOrDefault(index);
				zeek::ValPtr val = to_stringval(attr->value());

				if ( current )
					{
					zeek::VectorVal* vcurrent = current->AsVectorVal();
					vcurrent->Assign(vcurrent->Size(), std::move(val));
					}

				else
					{
					auto attribute_list = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::RADIUS::AttributeList);
					attribute_list->Assign((unsigned int)0, std::move(val));
					attributes->Assign(std::move(index), std::move(attribute_list));
					}
				}

			result->Assign(3, std::move(attributes));
			}

		zeek::BifEvent::enqueue_radius_message(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), std::move(result));
		return true;
		
}

bool RADIUS_Flow::proc_radius_attribute(RADIUS_Attribute* attr) {

		if ( ! radius_attribute )
			return false;

		zeek::BifEvent::enqueue_radius_attribute(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
		                                    attr->code(), to_stringval(attr->value()));
		return true;
		
}

} // namespace RADIUS
}  // namespace binpac
