// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/rdp/rdp_pac.h"

namespace binpac {






namespace RDP {
ContextRDP::ContextRDP(RDP_Conn* connection, RDP_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextRDP::~ContextRDP() {
}

RDP_Conn::RDP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new RDP_Flow(this, true);
    downflow_ = new RDP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		is_encrypted_ = false;
		encryption_method_ = 0;
	
}

RDP_Conn::~RDP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void RDP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void RDP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void RDP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool RDP_Conn::go_encrypted(uint32 method) {

		is_encrypted_ = true;
		encryption_method_ = method;

		if ( rdp_begin_encryption )
			{
			zeek::BifEvent::enqueue_rdp_begin_encryption(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       method);
			}

		return is_encrypted_;
		
}

bool RDP_Conn::is_encrypted() {

		return is_encrypted_;
		
}

uint32 RDP_Conn::encryption_method() {

		return encryption_method_;
		
}

ASN1Encoding::ASN1Encoding() {
    meta_ = nullptr;
}

ASN1Encoding::~ASN1Encoding() {
    delete meta_;
    meta_ = nullptr;
    content_.free();
}

int ASN1Encoding::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "meta"
    meta_ = new ASN1EncodingMeta();
    int t_meta__size;
    t_meta__size = meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_meta = t_begin_of_data + (t_meta__size);
    BINPAC_ASSERT(t_dataptr_after_meta <= t_end_of_data);
    // Parse "content"
    int t_content__size;
    t_content__size = meta()->length();
    // Checking out-of-bound for "ASN1Encoding:content"
    if ( t_dataptr_after_meta + (t_content__size) > t_end_of_data || t_dataptr_after_meta + (t_content__size) < t_dataptr_after_meta ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1Encoding:content",
        	((t_dataptr_after_meta - t_begin_of_data)) + (t_content__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_meta + t_content__size;
        int t_content_string_length;
        t_content_string_length = meta()->length();
        // check for negative sizes
        if ( t_content_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/../asn1/asn1.pac:28", t_content_string_length);
        content_.init(t_dataptr_after_meta, t_content_string_length);
    }

    int t_ASN1Encoding__size;
    const_byteptr const t_dataptr_after_content = t_dataptr_after_meta + (t_content__size);
    BINPAC_ASSERT(t_dataptr_after_content <= t_end_of_data);
    t_ASN1Encoding__size = t_dataptr_after_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Encoding__size) <= t_end_of_data);
    return t_ASN1Encoding__size;
}

ASN1EncodingMeta::ASN1EncodingMeta() {
    tag_ = 0;
    len_ = 0;
    long_len_ = false;
    length_ = 0;
    index_ = 0;
}

ASN1EncodingMeta::~ASN1EncodingMeta() {
    more_len_.free();
}

int ASN1EncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ASN1EncodingMeta:len"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:len",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tag"
    tag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "more_len"
    int t_more_len__size;
    long_len_ =  ( len() & 0x80 )  > 0;
    t_more_len__size = long_len() ? len() & 0x7f : 0;
    // Checking out-of-bound for "ASN1EncodingMeta:more_len"
    if ( (t_begin_of_data + 2) + (t_more_len__size) > t_end_of_data || (t_begin_of_data + 2) + (t_more_len__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ASN1EncodingMeta:more_len",
        	(2) + (t_more_len__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_more_len__size;
        int t_more_len_string_length;
        t_more_len_string_length = long_len() ? len() & 0x7f : 0;
        // check for negative sizes
        if ( t_more_len_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/../asn1/asn1.pac:34", t_more_len_string_length);
        more_len_.init((t_begin_of_data + 2), t_more_len_string_length);
    }

    int t_ASN1EncodingMeta__size;
    const_byteptr const t_dataptr_after_more_len = (t_begin_of_data + 2) + (t_more_len__size);
    BINPAC_ASSERT(t_dataptr_after_more_len <= t_end_of_data);
    t_ASN1EncodingMeta__size = t_dataptr_after_more_len - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    length_ = long_len() ? binary_to_int64(more_len()) : len();
    index_ = tag() - ASN1_INDEX_TAG_OFFSET;
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1EncodingMeta__size) <= t_end_of_data);
    return t_ASN1EncodingMeta__size;
}

ASN1OptionalEncodingMeta::ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata) {
    val_case_index_ = -1;
    data_ = nullptr;
    is_present_ = is_present;
    previous_metadata_ = previous_metadata;
    length_ = 0;
}

ASN1OptionalEncodingMeta::~ASN1OptionalEncodingMeta() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ASN1OptionalEncodingMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__size;
    val_case_index_ = is_present();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1EncodingMeta();
                int t_data__size;
                t_data__size = data_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_data__size;
            }
            break;
        case false:
            // Parse "none"
            {
                t_val__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ASN1OptionalEncodingMeta", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    length_ = is_present() ? data()->length() : previous_metadata()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ASN1SequenceMeta::ASN1SequenceMeta() {
    encoding_ = nullptr;
}

ASN1SequenceMeta::~ASN1SequenceMeta() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1SequenceMeta::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1EncodingMeta();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1SequenceMeta__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1SequenceMeta__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1SequenceMeta__size) <= t_end_of_data);
    return t_ASN1SequenceMeta__size;
}

ASN1Integer::ASN1Integer() {
    encoding_ = nullptr;
}

ASN1Integer::~ASN1Integer() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Integer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Integer__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Integer__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Integer__size) <= t_end_of_data);
    return t_ASN1Integer__size;
}

ASN1OctetString::ASN1OctetString() {
    encoding_ = nullptr;
}

ASN1OctetString::~ASN1OctetString() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1OctetString::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1OctetString__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1OctetString__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1OctetString__size) <= t_end_of_data);
    return t_ASN1OctetString__size;
}

ASN1ObjectIdentifier::ASN1ObjectIdentifier() {
    encoding_ = nullptr;
}

ASN1ObjectIdentifier::~ASN1ObjectIdentifier() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1ObjectIdentifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1ObjectIdentifier__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1ObjectIdentifier__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1ObjectIdentifier__size) <= t_end_of_data);
    return t_ASN1ObjectIdentifier__size;
}

ASN1Boolean::ASN1Boolean() {
    encoding_ = nullptr;
}

ASN1Boolean::~ASN1Boolean() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Boolean::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Boolean__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Boolean__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Boolean__size) <= t_end_of_data);
    return t_ASN1Boolean__size;
}

ASN1Enumerated::ASN1Enumerated() {
    encoding_ = nullptr;
}

ASN1Enumerated::~ASN1Enumerated() {
    delete encoding_;
    encoding_ = nullptr;
}

int ASN1Enumerated::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "encoding"
    encoding_ = new ASN1Encoding();
    int t_encoding__size;
    t_encoding__size = encoding_->Parse(t_begin_of_data, t_end_of_data);

    int t_ASN1Enumerated__size;
    const_byteptr const t_dataptr_after_encoding = t_begin_of_data + (t_encoding__size);
    BINPAC_ASSERT(t_dataptr_after_encoding <= t_end_of_data);
    t_ASN1Enumerated__size = t_dataptr_after_encoding - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ASN1Enumerated__size) <= t_end_of_data);
    return t_ASN1Enumerated__size;
}

SequenceElement::SequenceElement(bool grab_content) {
    index_meta_ = nullptr;
    have_content_case_index_ = -1;
    data_ = nullptr;
    meta_ = nullptr;
    grab_content_ = grab_content;
    index_ = 0;
    length_ = 0;
}

SequenceElement::~SequenceElement() {
    delete index_meta_;
    index_meta_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        case false:
            // Clean up "meta"
            {
                delete meta_;
                meta_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SequenceElement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "index_meta"
    index_meta_ = new ASN1EncodingMeta();
    int t_index_meta__size;
    t_index_meta__size = index_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_index_meta = t_begin_of_data + (t_index_meta__size);
    BINPAC_ASSERT(t_dataptr_after_index_meta <= t_end_of_data);
    // Parse "have_content"
    int t_have_content__size;
    have_content_case_index_ = grab_content();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_content_case_index() ) {
        case true:
            // Parse "data"
            {
                data_ = new ASN1Encoding();
                int t_data__size;
                t_data__size = data_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_data__size;
            }
            break;
        case false:
            // Parse "meta"
            {
                meta_ = new ASN1EncodingMeta();
                int t_meta__size;
                t_meta__size = meta_->Parse(t_dataptr_after_index_meta, t_end_of_data);
                t_have_content__size = t_meta__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SequenceElement", (int64)have_content_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SequenceElement__size;
    const_byteptr const t_dataptr_after_have_content = t_dataptr_after_index_meta + (t_have_content__size);
    BINPAC_ASSERT(t_dataptr_after_have_content <= t_end_of_data);
    t_SequenceElement__size = t_dataptr_after_have_content - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    index_ = index_meta()->index();
    length_ = index_meta()->length();
    BINPAC_ASSERT(t_begin_of_data + (t_SequenceElement__size) <= t_end_of_data);
    return t_SequenceElement__size;
}

Array::Array() {
    array_meta_ = nullptr;
    data_ = nullptr;
    data__elem_ = nullptr;
}

Array::~Array() {
    delete array_meta_;
    array_meta_ = nullptr;
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int Array::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "array_meta"
    array_meta_ = new ASN1EncodingMeta();
    int t_array_meta__size;
    t_array_meta__size = array_meta_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_array_meta = t_begin_of_data + (t_array_meta__size);
    BINPAC_ASSERT(t_dataptr_after_array_meta <= t_end_of_data);
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = 0;
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<ASN1Encoding*>;
    const_byteptr t_data__elem__dataptr = t_dataptr_after_array_meta;
    for (; /* forever */; ++t_data__elem__it) {
        // Check &until(data__elem__dataptr >= end_of_data)
        if ( t_data__elem__dataptr >= t_end_of_data ) {
            data__elem_ = nullptr;
            goto end_of_data;
        }
        data__elem_ = new ASN1Encoding();
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_array_meta);
    // Evaluate 'let' and 'withinput' fields

    int t_Array__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_array_meta + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Array__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Array__size) <= t_end_of_data);
    return t_Array__size;
}

int64 binary_to_int64(bytestring const& bs) {

	int64 rval = 0;

	if ( bs.length() > 8 )
		{
		zeek::reporter->Weird("asn_binary_to_int64_shift_too_large", zeek::util::fmt("%d", bs.length()));
		return 0;
		}

	for ( int i = 0; i < bs.length(); ++i )
		{
		uint64 byte = bs[i];
		rval |= byte << (8 * (bs.length() - (i + 1)));
		}

	return rval;
	
}



zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t)
	{
	return asn1_integer_to_val(i->encoding(), t);
	}

zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t)
	{
	auto v = binary_to_int64(i->content());

	switch ( t ) {
	case zeek::TYPE_BOOL:
		return zeek::val_mgr->Bool(v);
	case zeek::TYPE_INT:
		return zeek::val_mgr->Int(v);
	case zeek::TYPE_COUNT:
		return zeek::val_mgr->Count(v);
	default:
		zeek::reporter->Error("bad asn1_integer_to_val tag: %s", zeek::type_name(t));
		return zeek::val_mgr->Count(v);
	}
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid)
	{
	return asn1_oid_to_val(oid->encoding());
	}

zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid)
	{
	vector<uint64> oid_components;
	vector<vector<uint8> > subidentifiers;
	vector<uint64> subidentifier_values;
	vector<uint8> subidentifier;
	bytestring const& bs = oid->content();

	for ( int i = 0; i < bs.length(); ++i )
		{
		if ( bs[i] & 0x80 )
			subidentifier.push_back(bs[i] & 0x7f);
		else
			{
			subidentifier.push_back(bs[i]);
			subidentifiers.push_back(subidentifier);
			subidentifier.clear();
			}
		}

	if ( ! subidentifier.empty() || subidentifiers.size() < 1 )
		// Underflow.
		return zeek::val_mgr->EmptyString();

	for ( const auto& subidentifier : subidentifiers )
		{
		uint64 value = 0;

		for ( size_t j = 0; j < subidentifier.size(); ++j )
			{
			uint64 byte = subidentifier[j];
			value |= byte << (7 * (subidentifier.size() - (j + 1)));
			}

		subidentifier_values.push_back(value);
		}

	string rval;

	for ( size_t i = 0; i < subidentifier_values.size(); ++i )
		{
		char tmp[32];

		if ( i > 0 )
			{
			snprintf(tmp, sizeof(tmp), ".%" PRIu64, subidentifier_values[i]);
			rval += tmp;
			}
		else
			{
			std::div_t result = std::div(subidentifier_values[i], 40);
			snprintf(tmp, sizeof(tmp), "%d.%d", result.quot, result.rem);
			rval += tmp;
			}
		}

	return zeek::make_intrusive<zeek::StringVal>(rval);
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s)
	{
	return asn1_octet_string_to_val(s->encoding());
	}

zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s)
	{
	bytestring const& bs = s->content();
	return zeek::make_intrusive<zeek::StringVal>(bs.length(), reinterpret_cast<const char*>(bs.data()));
	}

TPKT::TPKT(bool is_orig) {
    version_ = 0;
    reserved_ = 0;
    tpkt_len_ = 0;
    cotp_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

TPKT::~TPKT() {
    delete cotp_;
    cotp_ = nullptr;
}

bool TPKT::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRDP* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "tpkt_len"
            // Checking out-of-bound for "TPKT:tpkt_len"
            if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("TPKT:tpkt_len",
                	(2) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            tpkt_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
            t_flow_buffer->GrowFrame(tpkt_len());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "version"
                // Checking out-of-bound for "TPKT:version"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("TPKT:version",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                // Parse "reserved"
                // Checking out-of-bound for "TPKT:reserved"
                if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("TPKT:reserved",
                    	(1) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));


                // Parse "cotp"
                cotp_ = new COTP(this);
                int t_cotp__size;
                t_cotp__size = cotp_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

COTP::COTP(TPKT* tpkt) {
    cotp_len_ = 0;
    pdu_ = 0;
    switch_case_index_ = -1;
    connect_confirm_ = nullptr;
    client_request_ = nullptr;
    data_ = nullptr;
    tpkt_ = tpkt;
    byteorder_ = littleendian;
}

COTP::~COTP() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch_case_index() ) {
        case ((uint8)208):
            // Clean up "connect_confirm"
            {
                delete connect_confirm_;
                connect_confirm_ = nullptr;
            }
            break;
        case ((uint8)224):
            // Clean up "client_request"
            {
                delete client_request_;
                client_request_ = nullptr;
            }
            break;
        case ((uint8)240):
            // Clean up "data"
            {
                delete data_;
                data_ = nullptr;
            }
            break;
        default:
            // Clean up "not_done"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int COTP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "COTP:pdu"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("COTP:pdu",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cotp_len"
    cotp_len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "pdu"
    pdu_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "switch"
    int t_switch__size;
    switch_case_index_ = pdu();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch_case_index() ) {
        case ((uint8)208):
            // Parse "connect_confirm"
            {
                connect_confirm_ = new Connect_Confirm(this);
                int t_connect_confirm__size;
                t_connect_confirm__size = connect_confirm_->Parse((t_begin_of_data + 2), t_end_of_data, t_context, byteorder());
                t_switch__size = t_connect_confirm__size;
            }
            break;
        case ((uint8)224):
            // Parse "client_request"
            {
                client_request_ = new Connect_Request(this);
                int t_client_request__size;
                t_client_request__size = client_request_->Parse((t_begin_of_data + 2), t_end_of_data, t_context);
                t_switch__size = t_client_request__size;
            }
            break;
        case ((uint8)240):
            // Parse "data"
            {
                data_ = new DT_Data();
                int t_data__size;
                t_data__size = data_->Parse((t_begin_of_data + 2), t_end_of_data, t_context);
                t_switch__size = t_data__size;
            }
            break;
        default:
            // Parse "not_done"
            {
                int t_not_done_string_length;
                t_not_done_string_length = (t_end_of_data) - ((t_begin_of_data + 2));
                int t_not_done__size;
                t_not_done__size = t_not_done_string_length;
                // check for negative sizes
                if ( t_not_done_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:25", t_not_done_string_length);
                not_done_.init((t_begin_of_data + 2), t_not_done_string_length);
                t_switch__size = t_not_done__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_COTP__size;
    const_byteptr const t_dataptr_after_switch = (t_begin_of_data + 2) + (t_switch__size);
    BINPAC_ASSERT(t_dataptr_after_switch <= t_end_of_data);
    t_COTP__size = t_dataptr_after_switch - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_COTP__size) <= t_end_of_data);
    return t_COTP__size;
}

DT_Data::DT_Data() {
    tpdu_number_ = 0;
    application_defined_type_ = 0;
    application_type_ = 0;
    data_case_index_ = -1;
    client_ = nullptr;
    server_ = nullptr;
    byteorder_ = littleendian;
}

DT_Data::~DT_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)101):
            // Clean up "client"
            {
                delete client_;
                client_ = nullptr;
            }
            break;
        case ((uint8)102):
            // Clean up "server"
            {
                delete server_;
                server_ = nullptr;
            }
            break;
        default:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int DT_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "DT_Data:application_type"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DT_Data:application_type",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tpdu_number"
    tpdu_number_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "application_defined_type"
    application_defined_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "application_type"
    application_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "data"
    int t_data__size;
    data_case_index_ = application_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)101):
            // Parse "client"
            {
                client_ = new Client_Header();
                int t_client__size;
                t_client__size = client_->Parse((t_begin_of_data + 3), t_end_of_data, t_context, byteorder());
                t_data__size = t_client__size;
            }
            break;
        case ((uint8)102):
            // Parse "server"
            {
                server_ = new Server_Header();
                int t_server__size;
                t_server__size = server_->Parse((t_begin_of_data + 3), t_end_of_data, t_context);
                t_data__size = t_server__size;
            }
            break;
        default:
            // Parse "none"
            {
                t_data__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_DT_Data__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 3) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_DT_Data__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_DT_Data__size) <= t_end_of_data);
    return t_DT_Data__size;
}

Data_Header::Data_Header() {
    type_ = 0;
    length_ = 0;
    byteorder_ = littleendian;
}

Data_Header::~Data_Header() {
}

int Data_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Data_Header"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Data_Header",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

Data_Block::Data_Block() {
    header_ = nullptr;
    block_case_index_ = -1;
    client_core_ = nullptr;
    client_security_ = nullptr;
    client_network_ = nullptr;
    client_cluster_ = nullptr;
    server_core_ = nullptr;
    server_security_ = nullptr;
    server_network_ = nullptr;
    byteorder_ = littleendian;
}

Data_Block::~Data_Block() {
    delete header_;
    header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( block_case_index() ) {
        case ((uint16)49153):
            // Clean up "client_core"
            {
                delete client_core_;
                client_core_ = nullptr;
            }
            break;
        case ((uint16)49154):
            // Clean up "client_security"
            {
                delete client_security_;
                client_security_ = nullptr;
            }
            break;
        case ((uint16)49155):
            // Clean up "client_network"
            {
                delete client_network_;
                client_network_ = nullptr;
            }
            break;
        case ((uint16)49156):
            // Clean up "client_cluster"
            {
                delete client_cluster_;
                client_cluster_ = nullptr;
            }
            break;
        case ((uint16)3073):
            // Clean up "server_core"
            {
                delete server_core_;
                server_core_ = nullptr;
            }
            break;
        case ((uint16)3074):
            // Clean up "server_security"
            {
                delete server_security_;
                server_security_ = nullptr;
            }
            break;
        case ((uint16)3075):
            // Clean up "server_network"
            {
                delete server_network_;
                server_network_ = nullptr;
            }
            break;
        default:
            // Clean up "unhandled"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Data_Block::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Data_Block:header"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Data_Block:header",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "header"
    header_ = new Data_Header();
    header_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "block"
    int t_block__size;
    t_block__size = header()->length() - 4;
    // Checking out-of-bound for "Data_Block:block"
    if ( (t_begin_of_data + 4) + (t_block__size) > t_end_of_data || (t_begin_of_data + 4) + (t_block__size) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Data_Block:block",
        	(4) + (t_block__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_block__size;
        block_case_index_ = header()->type();
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( block_case_index() ) {
            case ((uint16)49153):
                // Parse "client_core"
                {
                    client_core_ = new Client_Core_Data();
                    int t_client_core__size;
                    t_client_core__size = client_core_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                }
                break;
            case ((uint16)49154):
                // Parse "client_security"
                {
                    client_security_ = new Client_Security_Data();
                    client_security_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                }
                break;
            case ((uint16)49155):
                // Parse "client_network"
                {
                    client_network_ = new Client_Network_Data();
                    int t_client_network__size;
                    t_client_network__size = client_network_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                }
                break;
            case ((uint16)49156):
                // Parse "client_cluster"
                {
                    client_cluster_ = new Client_Cluster_Data();
                    client_cluster_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                }
                break;
            case ((uint16)3073):
                // Parse "server_core"
                {
                    server_core_ = new Server_Core_Data(header());
                    int t_server_core__size;
                    t_server_core__size = server_core_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                break;
            case ((uint16)3074):
                // Parse "server_security"
                {
                    server_security_ = new Server_Security_Data();
                    int t_server_security__size;
                    t_server_security__size = server_security_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                }
                break;
            case ((uint16)3075):
                // Parse "server_network"
                {
                    server_network_ = new Server_Network_Data();
                    server_network_->Parse((t_begin_of_data + 4), t_end_of_data);
                }
                break;
            default:
                // Parse "unhandled"
                {
                    int t_unhandled_string_length;
                    t_unhandled_string_length = (t_end_of_data) - ((t_begin_of_data + 4));
                    int t_unhandled__size;
                    t_unhandled__size = t_unhandled_string_length;
                    // check for negative sizes
                    if ( t_unhandled_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:69", t_unhandled_string_length);
                    unhandled_.init((t_begin_of_data + 4), t_unhandled_string_length);
                }
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        // Evaluate 'let' and 'withinput' fields
    }

    int t_Data_Block__size;
    const_byteptr const t_dataptr_after_block = (t_begin_of_data + 4) + (t_block__size);
    BINPAC_ASSERT(t_dataptr_after_block <= t_end_of_data);
    t_Data_Block__size = t_dataptr_after_block - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Data_Block__size) <= t_end_of_data);
    return t_Data_Block__size;
}

RegExMatcher RDP_Connect_Request_cookie_re_001("[^\\x0d]*");

RegExMatcher RDP_Connect_Request_cookie_re_002("\\x0d\\x0a");

RDP_Connect_Request_cookie::RDP_Connect_Request_cookie() {
    byteorder_ = littleendian;
}

RDP_Connect_Request_cookie::~RDP_Connect_Request_cookie() {
    cookie_value_.free();
    cookie_terminator_.free();
}

int RDP_Connect_Request_cookie::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "cookie_value"
    int t_cookie_value_string_length;
    t_cookie_value_string_length = 
        RDP_Connect_Request_cookie_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_cookie_value_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:78", "[^\\x0d]*", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_cookie_value__size;
    t_cookie_value__size = t_cookie_value_string_length;
    // check for negative sizes
    if ( t_cookie_value_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:78", t_cookie_value_string_length);
    cookie_value_.init(t_begin_of_data, t_cookie_value_string_length);

    const_byteptr const t_dataptr_after_cookie_value = t_begin_of_data + (t_cookie_value__size);
    BINPAC_ASSERT(t_dataptr_after_cookie_value <= t_end_of_data);
    // Parse "cookie_terminator"
    int t_cookie_terminator_string_length;
    t_cookie_terminator_string_length = 
        RDP_Connect_Request_cookie_re_002.MatchPrefix(
            t_dataptr_after_cookie_value,
            t_end_of_data - t_dataptr_after_cookie_value);
    if ( t_cookie_terminator_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:79", "\\x0d\\x0a", string(reinterpret_cast<const char*>(t_dataptr_after_cookie_value), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_cookie_terminator__size;
    t_cookie_terminator__size = t_cookie_terminator_string_length;
    // check for negative sizes
    if ( t_cookie_terminator_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:79", t_cookie_terminator_string_length);
    cookie_terminator_.init(t_dataptr_after_cookie_value, t_cookie_terminator_string_length);

    int t_RDP_Connect_Request_cookie__size;
    const_byteptr const t_dataptr_after_cookie_terminator = t_dataptr_after_cookie_value + (t_cookie_terminator__size);
    BINPAC_ASSERT(t_dataptr_after_cookie_terminator <= t_end_of_data);
    t_RDP_Connect_Request_cookie__size = t_dataptr_after_cookie_terminator - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDP_Connect_Request_cookie__size) <= t_end_of_data);
    return t_RDP_Connect_Request_cookie__size;
}

RegExMatcher Connect_Request_re_003("(Cookie: mstshash\\=)?");

Connect_Request::Connect_Request(COTP* cotp) {
    destination_reference_ = 0;
    source_reference_ = 0;
    flow_control_ = 0;
    switch1_case_index_ = -1;
    cookie_ = nullptr;
    switch2_case_index_ = -1;
    rdp_neg_req_ = nullptr;
    cotp_ = cotp;
    byteorder_ = littleendian;
    proc_ = false;
}

Connect_Request::~Connect_Request() {
    cookie_mstshash_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((int)0):
            // Clean up "none1"
            {
            }
            break;
        default:
            // Clean up "cookie"
            {
                delete cookie_;
                cookie_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch2_case_index() ) {
        case ((int)0):
            // Clean up "none2"
            {
            }
            break;
        default:
            // Clean up "rdp_neg_req"
            {
                delete rdp_neg_req_;
                rdp_neg_req_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Connect_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Connect_Request:flow_control"
    if ( (t_begin_of_data + 4) + (1) > t_end_of_data || (t_begin_of_data + 4) + (1) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Connect_Request:flow_control",
        	(4) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "destination_reference"
    destination_reference_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "source_reference"
    source_reference_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "flow_control"
    flow_control_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "cookie_mstshash"
    int t_cookie_mstshash_string_length;
    t_cookie_mstshash_string_length = 
        Connect_Request_re_003.MatchPrefix(
            (t_begin_of_data + 5),
            t_end_of_data - (t_begin_of_data + 5));
    if ( t_cookie_mstshash_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:86", "(Cookie: mstshash\\=)?", string(reinterpret_cast<const char*>((t_begin_of_data + 5)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_cookie_mstshash__size;
    t_cookie_mstshash__size = t_cookie_mstshash_string_length;
    // check for negative sizes
    if ( t_cookie_mstshash_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:86", t_cookie_mstshash_string_length);
    cookie_mstshash_.init((t_begin_of_data + 5), t_cookie_mstshash_string_length);

    const_byteptr const t_dataptr_after_cookie_mstshash = (t_begin_of_data + 5) + (t_cookie_mstshash__size);
    BINPAC_ASSERT(t_dataptr_after_cookie_mstshash <= t_end_of_data);
    // Parse "switch1"
    int t_switch1__size;
    switch1_case_index_ =  ( (t_dataptr_after_cookie_mstshash - (t_begin_of_data + 5)) > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((int)0):
            // Parse "none1"
            {
                t_switch1__size = 0;
            }
            break;
        default:
            // Parse "cookie"
            {
                cookie_ = new RDP_Connect_Request_cookie();
                int t_cookie__size;
                t_cookie__size = cookie_->Parse(t_dataptr_after_cookie_mstshash, t_end_of_data);
                t_switch1__size = t_cookie__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_switch1 = t_dataptr_after_cookie_mstshash + (t_switch1__size);
    BINPAC_ASSERT(t_dataptr_after_switch1 <= t_end_of_data);
    // Parse "switch2"
    int t_switch2__size;
    switch2_case_index_ =  ( (t_dataptr_after_switch1 - t_begin_of_data) + 2 - cotp()->cotp_len() - 1 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch2_case_index() ) {
        case ((int)0):
            // Parse "none2"
            {
                t_switch2__size = 0;
            }
            break;
        default:
            // Parse "rdp_neg_req"
            {
                rdp_neg_req_ = new RDP_Negotiation_Request();
                rdp_neg_req_->Parse(t_dataptr_after_switch1, t_end_of_data);
                t_switch2__size = 8;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Connect_Request__size;
    const_byteptr const t_dataptr_after_switch2 = t_dataptr_after_switch1 + (t_switch2__size);
    BINPAC_ASSERT(t_dataptr_after_switch2 <= t_end_of_data);
    t_Connect_Request__size = t_dataptr_after_switch2 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_rdp_connect_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Connect_Request__size) <= t_end_of_data);
    return t_Connect_Request__size;
}

RDP_Negotiation_Request::RDP_Negotiation_Request() {
    type_ = 0;
    flags_ = 0;
    length_ = 0;
    requested_protocols_ = 0;
    byteorder_ = littleendian;
    PROTOCOL_RDP_ = false;
    PROTOCOL_SSL_ = false;
    PROTOCOL_HYBRID_ = false;
    PROTOCOL_HYBRID_EX_ = false;
}

RDP_Negotiation_Request::~RDP_Negotiation_Request() {
}

int RDP_Negotiation_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RDP_Negotiation_Request"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDP_Negotiation_Request",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
    // Evaluate '&enforce' attribute
    if (! ( length() == 8 ) ) {
        throw binpac::ExceptionEnforceViolation("RDP_Negotiation_Request:length");
    }

    // Parse "requested_protocols"
    requested_protocols_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    PROTOCOL_RDP_ = requested_protocols() & 0x00;
    PROTOCOL_SSL_ = requested_protocols() & 0x01;
    PROTOCOL_HYBRID_ = requested_protocols() & 0x02;
    PROTOCOL_HYBRID_EX_ = requested_protocols() & 0x08;
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

Connect_Confirm::Connect_Confirm(COTP* cotp) {
    destination_reference_ = 0;
    source_reference_ = 0;
    flags_ = 0;
    switch1_case_index_ = -1;
    response_ = nullptr;
    cotp_ = cotp;
}

Connect_Confirm::~Connect_Confirm() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((int)0):
            // Clean up "none1"
            {
            }
            break;
        default:
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Connect_Confirm::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context, int t_byteorder) {
    // Checking out-of-bound for "Connect_Confirm:flags"
    if ( (t_begin_of_data + 4) + (1) > t_end_of_data || (t_begin_of_data + 4) + (1) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Connect_Confirm:flags",
        	(4) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "destination_reference"
    destination_reference_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "source_reference"
    source_reference_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "switch1"
    int t_switch1__size;
    switch1_case_index_ =  ( 5 + 2 - cotp()->cotp_len() - 1 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((int)0):
            // Parse "none1"
            {
                t_switch1__size = 0;
            }
            break;
        default:
            // Parse "response"
            {
                response_ = new Connect_Confirm_Record();
                response_->Parse((t_begin_of_data + 5), t_end_of_data, t_context);
                t_switch1__size = 8;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Connect_Confirm__size;
    const_byteptr const t_dataptr_after_switch1 = (t_begin_of_data + 5) + (t_switch1__size);
    BINPAC_ASSERT(t_dataptr_after_switch1 <= t_end_of_data);
    t_Connect_Confirm__size = t_dataptr_after_switch1 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Connect_Confirm__size) <= t_end_of_data);
    return t_Connect_Confirm__size;
}

Connect_Confirm_Record::Connect_Confirm_Record() {
    response_type_ = 0;
    switch1_case_index_ = -1;
    neg_resp_ = nullptr;
    neg_fail_ = nullptr;
}

Connect_Confirm_Record::~Connect_Confirm_Record() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((uint8)2):
            // Clean up "neg_resp"
            {
                delete neg_resp_;
                neg_resp_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "neg_fail"
            {
                delete neg_fail_;
                neg_fail_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Connect_Confirm_Record::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Connect_Confirm_Record"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Connect_Confirm_Record",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "response_type"
    response_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "switch1"
    switch1_case_index_ = response_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((uint8)2):
            // Parse "neg_resp"
            {
                neg_resp_ = new RDP_Negotiation_Response();
                neg_resp_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
            }
            break;
        case ((uint8)3):
            // Parse "neg_fail"
            {
                neg_fail_ = new RDP_Negotiation_Failure();
                neg_fail_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Connect_Confirm_Record", (int64)switch1_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

RDP_Negotiation_Response::RDP_Negotiation_Response() {
    flags_ = 0;
    length_ = 0;
    selected_protocol_ = 0;
    byteorder_ = littleendian;
    enc_ssl_ = false;
    has_enc_ssl_ = false;
    proc_ = false;
}

RDP_Negotiation_Response::~RDP_Negotiation_Response() {
}

int RDP_Negotiation_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "RDP_Negotiation_Response"
    if ( t_begin_of_data + (7) > t_end_of_data || t_begin_of_data + (7) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDP_Negotiation_Response",
        	(0) + (7), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));
    // Evaluate '&enforce' attribute
    if (! ( length() == 8 ) ) {
        throw binpac::ExceptionEnforceViolation("RDP_Negotiation_Response:length");
    }

    // Parse "selected_protocol"
    selected_protocol_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));

    // Evaluate 'let' and 'withinput' fields
    has_enc_ssl_ =  ( selected_protocol() > 0 ) ;
    if ( has_enc_ssl() ) {
        enc_ssl_ = t_context->connection()->go_encrypted(selected_protocol());
    }
    proc_ = t_context->flow()->proc_rdp_negotiation_response(this);
    BINPAC_ASSERT(t_begin_of_data + (7) <= t_end_of_data);
    return 7;
}

RDP_Negotiation_Failure::RDP_Negotiation_Failure() {
    flags_ = 0;
    length_ = 0;
    failure_code_ = 0;
    byteorder_ = littleendian;
    proc_ = false;
}

RDP_Negotiation_Failure::~RDP_Negotiation_Failure() {
}

int RDP_Negotiation_Failure::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "RDP_Negotiation_Failure"
    if ( t_begin_of_data + (7) > t_end_of_data || t_begin_of_data + (7) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDP_Negotiation_Failure",
        	(0) + (7), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "length"
    length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "failure_code"
    failure_code_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_rdp_negotiation_failure(this);
    BINPAC_ASSERT(t_begin_of_data + (7) <= t_end_of_data);
    return 7;
}

Client_Header::Client_Header() {
    type_length_ = nullptr;
    calling_domain_selector_ = nullptr;
    called_domain_selector_ = nullptr;
    upward_flag_ = nullptr;
    target_parameters_ = nullptr;
    minimum_parameters_ = nullptr;
    maximum_parameters_ = nullptr;
    user_data_length_ = 0;
    gcc_connection_data_ = nullptr;
    gcc_client_create_request_ = nullptr;
    data_blocks_ = nullptr;
    data_blocks__elem_ = nullptr;
}

Client_Header::~Client_Header() {
    delete type_length_;
    type_length_ = nullptr;
    delete calling_domain_selector_;
    calling_domain_selector_ = nullptr;
    delete called_domain_selector_;
    called_domain_selector_ = nullptr;
    delete upward_flag_;
    upward_flag_ = nullptr;
    delete target_parameters_;
    target_parameters_ = nullptr;
    delete minimum_parameters_;
    minimum_parameters_ = nullptr;
    delete maximum_parameters_;
    maximum_parameters_ = nullptr;
    delete gcc_connection_data_;
    gcc_connection_data_ = nullptr;
    delete gcc_client_create_request_;
    gcc_client_create_request_ = nullptr;
    delete data_blocks__elem_;
    data_blocks__elem_ = nullptr;
    if ( data_blocks() ) {
        for ( auto* data_blocks__elem_ : *data_blocks() ) {
            delete data_blocks__elem_;
            data_blocks__elem_ = nullptr;
        }
    }
    delete data_blocks_;
}

int Client_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context, int t_byteorder) {
    // Parse "type_length"
    type_length_ = new ASN1Integer();
    int t_type_length__size;
    t_type_length__size = type_length_->Parse(t_begin_of_data, t_end_of_data);

    const_byteptr const t_dataptr_after_type_length = t_begin_of_data + (t_type_length__size);
    BINPAC_ASSERT(t_dataptr_after_type_length <= t_end_of_data);
    // Parse "calling_domain_selector"
    calling_domain_selector_ = new ASN1OctetString();
    int t_calling_domain_selector__size;
    t_calling_domain_selector__size = calling_domain_selector_->Parse(t_dataptr_after_type_length, t_end_of_data);

    const_byteptr const t_dataptr_after_calling_domain_selector = t_dataptr_after_type_length + (t_calling_domain_selector__size);
    BINPAC_ASSERT(t_dataptr_after_calling_domain_selector <= t_end_of_data);
    // Parse "called_domain_selector"
    called_domain_selector_ = new ASN1OctetString();
    int t_called_domain_selector__size;
    t_called_domain_selector__size = called_domain_selector_->Parse(t_dataptr_after_calling_domain_selector, t_end_of_data);

    const_byteptr const t_dataptr_after_called_domain_selector = t_dataptr_after_calling_domain_selector + (t_called_domain_selector__size);
    BINPAC_ASSERT(t_dataptr_after_called_domain_selector <= t_end_of_data);
    // Parse "upward_flag"
    upward_flag_ = new ASN1Boolean();
    int t_upward_flag__size;
    t_upward_flag__size = upward_flag_->Parse(t_dataptr_after_called_domain_selector, t_end_of_data);

    const_byteptr const t_dataptr_after_upward_flag = t_dataptr_after_called_domain_selector + (t_upward_flag__size);
    BINPAC_ASSERT(t_dataptr_after_upward_flag <= t_end_of_data);
    // Parse "target_parameters"
    target_parameters_ = new ASN1SequenceMeta();
    int t_target_parameters__size;
    t_target_parameters__size = target_parameters_->Parse(t_dataptr_after_upward_flag, t_end_of_data);

    const_byteptr const t_dataptr_after_target_parameters = t_dataptr_after_upward_flag + (t_target_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_target_parameters <= t_end_of_data);
    // Parse "targ_parameters_pad"
    int t_targ_parameters_pad__size;
    t_targ_parameters_pad__size = target_parameters()->encoding()->length();
    // Checking out-of-bound for "Client_Header:targ_parameters_pad"
    if ( t_dataptr_after_target_parameters + (t_targ_parameters_pad__size) > t_end_of_data || t_dataptr_after_target_parameters + (t_targ_parameters_pad__size) < t_dataptr_after_target_parameters ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Header:targ_parameters_pad",
        	((t_dataptr_after_target_parameters - t_begin_of_data)) + (t_targ_parameters_pad__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_target_parameters + t_targ_parameters_pad__size;
        int t_targ_parameters_pad_string_length;
        t_targ_parameters_pad_string_length = target_parameters()->encoding()->length();
        // check for negative sizes
        if ( t_targ_parameters_pad_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:163", t_targ_parameters_pad_string_length);
        targ_parameters_pad_.init(t_dataptr_after_target_parameters, t_targ_parameters_pad_string_length);
    }

    const_byteptr const t_dataptr_after_targ_parameters_pad = t_dataptr_after_target_parameters + (t_targ_parameters_pad__size);
    BINPAC_ASSERT(t_dataptr_after_targ_parameters_pad <= t_end_of_data);
    // Parse "minimum_parameters"
    minimum_parameters_ = new ASN1SequenceMeta();
    int t_minimum_parameters__size;
    t_minimum_parameters__size = minimum_parameters_->Parse(t_dataptr_after_targ_parameters_pad, t_end_of_data);

    const_byteptr const t_dataptr_after_minimum_parameters = t_dataptr_after_targ_parameters_pad + (t_minimum_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_minimum_parameters <= t_end_of_data);
    // Parse "min_parameters_pad"
    int t_min_parameters_pad__size;
    t_min_parameters_pad__size = minimum_parameters()->encoding()->length();
    // Checking out-of-bound for "Client_Header:min_parameters_pad"
    if ( t_dataptr_after_minimum_parameters + (t_min_parameters_pad__size) > t_end_of_data || t_dataptr_after_minimum_parameters + (t_min_parameters_pad__size) < t_dataptr_after_minimum_parameters ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Header:min_parameters_pad",
        	((t_dataptr_after_minimum_parameters - t_begin_of_data)) + (t_min_parameters_pad__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_minimum_parameters + t_min_parameters_pad__size;
        int t_min_parameters_pad_string_length;
        t_min_parameters_pad_string_length = minimum_parameters()->encoding()->length();
        // check for negative sizes
        if ( t_min_parameters_pad_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:165", t_min_parameters_pad_string_length);
        min_parameters_pad_.init(t_dataptr_after_minimum_parameters, t_min_parameters_pad_string_length);
    }

    const_byteptr const t_dataptr_after_min_parameters_pad = t_dataptr_after_minimum_parameters + (t_min_parameters_pad__size);
    BINPAC_ASSERT(t_dataptr_after_min_parameters_pad <= t_end_of_data);
    // Parse "maximum_parameters"
    maximum_parameters_ = new ASN1SequenceMeta();
    int t_maximum_parameters__size;
    t_maximum_parameters__size = maximum_parameters_->Parse(t_dataptr_after_min_parameters_pad, t_end_of_data);

    const_byteptr const t_dataptr_after_maximum_parameters = t_dataptr_after_min_parameters_pad + (t_maximum_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_maximum_parameters <= t_end_of_data);
    // Parse "max_parameters_pad"
    int t_max_parameters_pad__size;
    t_max_parameters_pad__size = maximum_parameters()->encoding()->length();
    // Checking out-of-bound for "Client_Header:max_parameters_pad"
    if ( t_dataptr_after_maximum_parameters + (t_max_parameters_pad__size) > t_end_of_data || t_dataptr_after_maximum_parameters + (t_max_parameters_pad__size) < t_dataptr_after_maximum_parameters ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Header:max_parameters_pad",
        	((t_dataptr_after_maximum_parameters - t_begin_of_data)) + (t_max_parameters_pad__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_maximum_parameters + t_max_parameters_pad__size;
        int t_max_parameters_pad_string_length;
        t_max_parameters_pad_string_length = maximum_parameters()->encoding()->length();
        // check for negative sizes
        if ( t_max_parameters_pad_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:167", t_max_parameters_pad_string_length);
        max_parameters_pad_.init(t_dataptr_after_maximum_parameters, t_max_parameters_pad_string_length);
    }

    const_byteptr const t_dataptr_after_max_parameters_pad = t_dataptr_after_maximum_parameters + (t_max_parameters_pad__size);
    BINPAC_ASSERT(t_dataptr_after_max_parameters_pad <= t_end_of_data);
    // Checking out-of-bound for "Client_Header:user_data_length"
    if ( t_dataptr_after_max_parameters_pad + (4) > t_end_of_data || t_dataptr_after_max_parameters_pad + (4) < t_dataptr_after_max_parameters_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Header:user_data_length",
        	((t_dataptr_after_max_parameters_pad - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "user_data_length"
    user_data_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_max_parameters_pad)));

    // Parse "gcc_connection_data"
    gcc_connection_data_ = new GCC_Client_Connection_Data();
    int t_gcc_connection_data__size;
    t_gcc_connection_data__size = gcc_connection_data_->Parse((t_dataptr_after_max_parameters_pad + 4), t_end_of_data);

    const_byteptr const t_dataptr_after_gcc_connection_data = (t_dataptr_after_max_parameters_pad + 4) + (t_gcc_connection_data__size);
    BINPAC_ASSERT(t_dataptr_after_gcc_connection_data <= t_end_of_data);
    // Parse "gcc_client_create_request"
    gcc_client_create_request_ = new GCC_Client_Create_Request();
    int t_gcc_client_create_request__size;
    t_gcc_client_create_request__size = gcc_client_create_request_->Parse(t_dataptr_after_gcc_connection_data, t_end_of_data);

    const_byteptr const t_dataptr_after_gcc_client_create_request = t_dataptr_after_gcc_connection_data + (t_gcc_client_create_request__size);
    BINPAC_ASSERT(t_dataptr_after_gcc_client_create_request <= t_end_of_data);
    // Parse "data_blocks"
    int t_data_blocks__arraylength;
    t_data_blocks__arraylength = 0;
    data_blocks__elem_ = nullptr;
    int t_data_blocks__elem__it;
    t_data_blocks__elem__it = 0;
    int t_data_blocks__size;
    data_blocks_ = new vector<Data_Block*>;
    const_byteptr t_data_blocks__elem__dataptr = t_dataptr_after_gcc_client_create_request;
    for (; /* forever */; ++t_data_blocks__elem__it) {
        // Check &until(data_blocks__elem__dataptr >= end_of_data)
        if ( t_data_blocks__elem__dataptr >= t_end_of_data ) {
            data_blocks__elem_ = nullptr;
            goto end_of_data_blocks;
        }
        data_blocks__elem_ = new Data_Block();
        int t_data_blocks__elem__size;
        t_data_blocks__elem__size = data_blocks__elem_->Parse(t_data_blocks__elem__dataptr, t_end_of_data, t_context);
        data_blocks_->push_back(data_blocks__elem_);
        t_data_blocks__elem__dataptr += t_data_blocks__elem__size;
        BINPAC_ASSERT(t_data_blocks__elem__dataptr <= t_end_of_data);
        data_blocks__elem_ = nullptr;
    }
end_of_data_blocks: ;
    t_data_blocks__size = t_data_blocks__elem__dataptr - (t_dataptr_after_gcc_client_create_request);
    // Evaluate 'let' and 'withinput' fields

    int t_Client_Header__size;
    const_byteptr const t_dataptr_after_data_blocks = t_dataptr_after_gcc_client_create_request + (t_data_blocks__size);
    BINPAC_ASSERT(t_dataptr_after_data_blocks <= t_end_of_data);
    t_Client_Header__size = t_dataptr_after_data_blocks - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Client_Header__size) <= t_end_of_data);
    return t_Client_Header__size;
}

GCC_Client_Connection_Data::GCC_Client_Connection_Data() {
    key_object_length_ = 0;
    key_object_ = nullptr;
    key_object__elem_ = 0;
    connect_data_connect_pdu_ = 0;
    byteorder_ = bigendian;
}

GCC_Client_Connection_Data::~GCC_Client_Connection_Data() {
    delete key_object_;
}

int GCC_Client_Connection_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "GCC_Client_Connection_Data:key_object_length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Client_Connection_Data:key_object_length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "key_object_length"
    key_object_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "key_object"
    int t_key_object__arraylength;
    t_key_object__arraylength = key_object_length();
    if ( t_key_object__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("GCC_Client_Connection_Data:key_object",
          t_key_object__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: GCC_Client_Connection_Data:key_object
    if ( t_key_object__arraylength > ((t_end_of_data - (t_begin_of_data + 2)) / 1) )
        throw binpac::ExceptionOutOfBound("GCC_Client_Connection_Data:key_object",
          t_key_object__arraylength, (t_end_of_data) - ((t_begin_of_data + 2)));
    key_object__elem_ = 0;
    int t_key_object__elem__it;
    t_key_object__elem__it = 0;
    int t_key_object__size;
    key_object_ = new vector<uint8>;
    key_object_->reserve(t_key_object__arraylength);
    const_byteptr t_key_object__elem__dataptr = (t_begin_of_data + 2);
    for (; t_key_object__elem__it < t_key_object__arraylength; ++t_key_object__elem__it) {
        key_object__elem_ = *(reinterpret_cast<uint8 const*>(t_key_object__elem__dataptr));
        key_object_->push_back(key_object__elem_);
        t_key_object__elem__dataptr += 1;
        BINPAC_ASSERT(t_key_object__elem__dataptr <= t_end_of_data);
    }
end_of_key_object: ;
    t_key_object__size = t_key_object__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_key_object = (t_begin_of_data + 2) + (t_key_object__size);
    BINPAC_ASSERT(t_dataptr_after_key_object <= t_end_of_data);
    // Checking out-of-bound for "GCC_Client_Connection_Data:connect_data_connect_pdu"
    if ( t_dataptr_after_key_object + (2) > t_end_of_data || t_dataptr_after_key_object + (2) < t_dataptr_after_key_object ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Client_Connection_Data:connect_data_connect_pdu",
        	((t_dataptr_after_key_object - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "connect_data_connect_pdu"
    connect_data_connect_pdu_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_key_object)));

    int t_GCC_Client_Connection_Data__size;
    t_GCC_Client_Connection_Data__size = (t_dataptr_after_key_object + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GCC_Client_Connection_Data__size) <= t_end_of_data);
    return t_GCC_Client_Connection_Data__size;
}

RegExMatcher GCC_Client_Create_Request_re_004("Duca");

GCC_Client_Create_Request::GCC_Client_Create_Request() {
    extension_bit_ = 0;
    privileges_ = 0;
    numeric_length_ = 0;
    numeric_ = 0;
    termination_method_ = 0;
    number_user_data_sets_ = 0;
    user_data_value_present_ = 0;
    h221_nonstandard_length_ = 0;
    user_data_value_length_ = 0;
    byteorder_ = bigendian;
}

GCC_Client_Create_Request::~GCC_Client_Create_Request() {
    h221_nonstandard_key_.free();
}

int GCC_Client_Create_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "GCC_Client_Create_Request:h221_nonstandard_length"
    if ( (t_begin_of_data + 7) + (1) > t_end_of_data || (t_begin_of_data + 7) + (1) < (t_begin_of_data + 7) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Client_Create_Request:h221_nonstandard_length",
        	(7) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "extension_bit"
    extension_bit_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "privileges"
    privileges_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "numeric_length"
    numeric_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "numeric"
    numeric_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "termination_method"
    termination_method_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "number_user_data_sets"
    number_user_data_sets_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Parse "user_data_value_present"
    user_data_value_present_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "h221_nonstandard_length"
    h221_nonstandard_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Parse "h221_nonstandard_key"
    int t_h221_nonstandard_key_string_length;
    t_h221_nonstandard_key_string_length = 
        GCC_Client_Create_Request_re_004.MatchPrefix(
            (t_begin_of_data + 8),
            t_end_of_data - (t_begin_of_data + 8));
    if ( t_h221_nonstandard_key_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:190", "Duca", string(reinterpret_cast<const char*>((t_begin_of_data + 8)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_h221_nonstandard_key__size;
    t_h221_nonstandard_key__size = t_h221_nonstandard_key_string_length;
    // check for negative sizes
    if ( t_h221_nonstandard_key_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:190", t_h221_nonstandard_key_string_length);
    h221_nonstandard_key_.init((t_begin_of_data + 8), t_h221_nonstandard_key_string_length);

    const_byteptr const t_dataptr_after_h221_nonstandard_key = (t_begin_of_data + 8) + (t_h221_nonstandard_key__size);
    BINPAC_ASSERT(t_dataptr_after_h221_nonstandard_key <= t_end_of_data);
    // Checking out-of-bound for "GCC_Client_Create_Request:user_data_value_length"
    if ( t_dataptr_after_h221_nonstandard_key + (2) > t_end_of_data || t_dataptr_after_h221_nonstandard_key + (2) < t_dataptr_after_h221_nonstandard_key ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Client_Create_Request:user_data_value_length",
        	((t_dataptr_after_h221_nonstandard_key - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "user_data_value_length"
    user_data_value_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_h221_nonstandard_key)));

    int t_GCC_Client_Create_Request__size;
    t_GCC_Client_Create_Request__size = (t_dataptr_after_h221_nonstandard_key + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GCC_Client_Create_Request__size) <= t_end_of_data);
    return t_GCC_Client_Create_Request__size;
}

Client_Core_Data::Client_Core_Data() {
    version_major_ = 0;
    version_minor_ = 0;
    desktop_width_ = 0;
    desktop_height_ = 0;
    color_depth_ = 0;
    sas_sequence_ = 0;
    keyboard_layout_ = 0;
    client_build_ = 0;
    keyboard_type_ = 0;
    keyboard_sub_ = 0;
    keyboard_function_key_ = 0;
    post_beta2_color_depth_ = 0;
    client_product_id_ = 0;
    serial_number_ = 0;
    high_color_depth_ = 0;
    supported_color_depths_ = 0;
    early_capability_flags_ = 0;
    byteorder_ = littleendian;
    SUPPORT_ERRINFO_PDU_ = false;
    WANT_32BPP_SESSION_ = false;
    SUPPORT_STATUSINFO_PDU_ = false;
    STRONG_ASYMMETRIC_KEYS_ = false;
    SUPPORT_MONITOR_LAYOUT_PDU_ = false;
    SUPPORT_NETCHAR_AUTODETECT_ = false;
    SUPPORT_DYNVC_GFX_PROTOCOL_ = false;
    SUPPORT_DYNAMIC_TIME_ZONE_ = false;
    SUPPORT_HEARTBEAT_PDU_ = false;
    proc_ = false;
}

Client_Core_Data::~Client_Core_Data() {
    client_name_.free();
    ime_file_name_.free();
    dig_product_id_.free();
}

int Client_Core_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Client_Core_Data:client_build"
    if ( (t_begin_of_data + 16) + (4) > t_end_of_data || (t_begin_of_data + 16) + (4) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Core_Data:client_build",
        	(16) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version_major"
    version_major_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "version_minor"
    version_minor_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "desktop_width"
    desktop_width_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "desktop_height"
    desktop_height_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "color_depth"
    color_depth_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "sas_sequence"
    sas_sequence_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "keyboard_layout"
    keyboard_layout_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "client_build"
    client_build_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "client_name"
    // Checking out-of-bound for "Client_Core_Data:client_name"
    if ( (t_begin_of_data + 20) + (32) > t_end_of_data || (t_begin_of_data + 20) + (32) < (t_begin_of_data + 20) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Core_Data:client_name",
        	(20) + (32), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 20) + 32;
        int t_client_name_string_length;
        t_client_name_string_length = 32;
        int t_client_name__size;
        t_client_name__size = t_client_name_string_length;
        client_name_.init((t_begin_of_data + 20), t_client_name_string_length);
    }

    const_byteptr const t_dataptr_after_client_name = (t_begin_of_data + 20) + (32);
    BINPAC_ASSERT(t_dataptr_after_client_name <= t_end_of_data);
    // Checking out-of-bound for "Client_Core_Data:keyboard_function_key"
    if ( (t_dataptr_after_client_name + 8) + (4) > t_end_of_data || (t_dataptr_after_client_name + 8) + (4) < (t_dataptr_after_client_name + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Core_Data:keyboard_function_key",
        	(((t_dataptr_after_client_name + 8) - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "keyboard_type"
    keyboard_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_client_name)));

    // Parse "keyboard_sub"
    keyboard_sub_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_client_name + 4))));

    // Parse "keyboard_function_key"
    keyboard_function_key_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_client_name + 8))));

    // Parse "ime_file_name"
    // Checking out-of-bound for "Client_Core_Data:ime_file_name"
    if ( (t_dataptr_after_client_name + 12) + (64) > t_end_of_data || (t_dataptr_after_client_name + 12) + (64) < (t_dataptr_after_client_name + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Core_Data:ime_file_name",
        	(((t_dataptr_after_client_name + 12) - t_begin_of_data)) + (64), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_client_name + 12) + 64;
        int t_ime_file_name_string_length;
        t_ime_file_name_string_length = 64;
        int t_ime_file_name__size;
        t_ime_file_name__size = t_ime_file_name_string_length;
        ime_file_name_.init((t_dataptr_after_client_name + 12), t_ime_file_name_string_length);
    }

    const_byteptr const t_dataptr_after_ime_file_name = (t_dataptr_after_client_name + 12) + (64);
    BINPAC_ASSERT(t_dataptr_after_ime_file_name <= t_end_of_data);
    // Checking out-of-bound for "Client_Core_Data:early_capability_flags"
    if ( (t_dataptr_after_ime_file_name + 12) + (2) > t_end_of_data || (t_dataptr_after_ime_file_name + 12) + (2) < (t_dataptr_after_ime_file_name + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Core_Data:early_capability_flags",
        	(((t_dataptr_after_ime_file_name + 12) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "post_beta2_color_depth"
    post_beta2_color_depth_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_ime_file_name)));

    // Parse "client_product_id"
    client_product_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_ime_file_name + 2))));

    // Parse "serial_number"
    serial_number_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_ime_file_name + 4))));

    // Parse "high_color_depth"
    high_color_depth_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_ime_file_name + 8))));

    // Parse "supported_color_depths"
    supported_color_depths_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_ime_file_name + 10))));

    // Parse "early_capability_flags"
    early_capability_flags_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_ime_file_name + 12))));

    // Parse "dig_product_id"
    // Checking out-of-bound for "Client_Core_Data:dig_product_id"
    if ( (t_dataptr_after_ime_file_name + 14) + (64) > t_end_of_data || (t_dataptr_after_ime_file_name + 14) + (64) < (t_dataptr_after_ime_file_name + 14) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Core_Data:dig_product_id",
        	(((t_dataptr_after_ime_file_name + 14) - t_begin_of_data)) + (64), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_ime_file_name + 14) + 64;
        int t_dig_product_id_string_length;
        t_dig_product_id_string_length = 64;
        int t_dig_product_id__size;
        t_dig_product_id__size = t_dig_product_id_string_length;
        dig_product_id_.init((t_dataptr_after_ime_file_name + 14), t_dig_product_id_string_length);
    }

    int t_Client_Core_Data__size;
    const_byteptr const t_dataptr_after_dig_product_id = (t_dataptr_after_ime_file_name + 14) + (64);
    BINPAC_ASSERT(t_dataptr_after_dig_product_id <= t_end_of_data);
    t_Client_Core_Data__size = t_dataptr_after_dig_product_id - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    SUPPORT_ERRINFO_PDU_ = early_capability_flags() & 0x01;
    WANT_32BPP_SESSION_ = early_capability_flags() & 0x02;
    SUPPORT_STATUSINFO_PDU_ = early_capability_flags() & 0x04;
    STRONG_ASYMMETRIC_KEYS_ = early_capability_flags() & 0x08;
    SUPPORT_MONITOR_LAYOUT_PDU_ = early_capability_flags() & 0x40;
    SUPPORT_NETCHAR_AUTODETECT_ = early_capability_flags() & 0x80;
    SUPPORT_DYNVC_GFX_PROTOCOL_ = early_capability_flags() & 0x0100;
    SUPPORT_DYNAMIC_TIME_ZONE_ = early_capability_flags() & 0x0200;
    SUPPORT_HEARTBEAT_PDU_ = early_capability_flags() & 0x0400;
    proc_ = t_context->flow()->proc_rdp_client_core_data(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Client_Core_Data__size) <= t_end_of_data);
    return t_Client_Core_Data__size;
}

Client_Security_Data::Client_Security_Data() {
    encryption_methods_ = 0;
    ext_encryption_methods_ = 0;
    byteorder_ = littleendian;
    proc_ = false;
}

Client_Security_Data::~Client_Security_Data() {
}

int Client_Security_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Client_Security_Data"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Security_Data",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "encryption_methods"
    encryption_methods_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "ext_encryption_methods"
    ext_encryption_methods_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_rdp_client_security_data(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

Client_Network_Data::Client_Network_Data() {
    channel_count_ = 0;
    channel_def_array_ = nullptr;
    channel_def_array__elem_ = nullptr;
    byteorder_ = littleendian;
    proc_ = false;
}

Client_Network_Data::~Client_Network_Data() {
    delete channel_def_array__elem_;
    channel_def_array__elem_ = nullptr;
    if ( channel_def_array() ) {
        for ( auto* channel_def_array__elem_ : *channel_def_array() ) {
            delete channel_def_array__elem_;
            channel_def_array__elem_ = nullptr;
        }
    }
    delete channel_def_array_;
}

int Client_Network_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Client_Network_Data:channel_count"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Network_Data:channel_count",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "channel_count"
    channel_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "channel_def_array"
    int t_channel_def_array__arraylength;
    t_channel_def_array__arraylength = channel_count();
    if ( t_channel_def_array__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("Client_Network_Data:channel_def_array",
          t_channel_def_array__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: Client_Network_Data:channel_def_array
    if ( t_channel_def_array__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 1) )
        throw binpac::ExceptionOutOfBound("Client_Network_Data:channel_def_array",
          t_channel_def_array__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
    channel_def_array__elem_ = nullptr;
    int t_channel_def_array__elem__it;
    t_channel_def_array__elem__it = 0;
    int t_channel_def_array__size;
    channel_def_array_ = new vector<Client_Channel_Def*>;
    channel_def_array_->reserve(t_channel_def_array__arraylength);
    const_byteptr t_channel_def_array__elem__dataptr = (t_begin_of_data + 4);
    for (; t_channel_def_array__elem__it < t_channel_def_array__arraylength; ++t_channel_def_array__elem__it) {
        channel_def_array__elem_ = new Client_Channel_Def();
        int t_channel_def_array__elem__size;
        t_channel_def_array__elem__size = channel_def_array__elem_->Parse(t_channel_def_array__elem__dataptr, t_end_of_data);
        channel_def_array_->push_back(channel_def_array__elem_);
        t_channel_def_array__elem__dataptr += t_channel_def_array__elem__size;
        BINPAC_ASSERT(t_channel_def_array__elem__dataptr <= t_end_of_data);
        channel_def_array__elem_ = nullptr;
    }
end_of_channel_def_array: ;
    t_channel_def_array__size = t_channel_def_array__elem__dataptr - ((t_begin_of_data + 4));
    // Evaluate 'let' and 'withinput' fields

    int t_Client_Network_Data__size;
    const_byteptr const t_dataptr_after_channel_def_array = (t_begin_of_data + 4) + (t_channel_def_array__size);
    BINPAC_ASSERT(t_dataptr_after_channel_def_array <= t_end_of_data);
    t_Client_Network_Data__size = t_dataptr_after_channel_def_array - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_rdp_client_network_data(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Client_Network_Data__size) <= t_end_of_data);
    return t_Client_Network_Data__size;
}

Client_Cluster_Data::Client_Cluster_Data() {
    flags_ = 0;
    redir_session_id_ = 0;
    byteorder_ = littleendian;
    REDIRECTION_SUPPORTED_ = false;
    SERVER_SESSION_REDIRECTION_VERSION_MASK_ = 0;
    REDIRECTED_SESSIONID_FIELD_VALID_ = false;
    REDIRECTED_SMARTCARD_ = false;
    proc_ = false;
}

Client_Cluster_Data::~Client_Cluster_Data() {
}

int Client_Cluster_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Client_Cluster_Data"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Cluster_Data",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "redir_session_id"
    redir_session_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    REDIRECTION_SUPPORTED_ = redir_session_id() & 0x00000001;
    SERVER_SESSION_REDIRECTION_VERSION_MASK_ =  ( redir_session_id() & 0x0000003C ) ;
    REDIRECTED_SESSIONID_FIELD_VALID_ =  ( redir_session_id() & 0x00000002 ) ;
    REDIRECTED_SMARTCARD_ = redir_session_id() & 0x00000040;
    proc_ = t_context->flow()->proc_rdp_client_cluster_data(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

Client_Channel_Def::Client_Channel_Def() {
    options_ = 0;
    byteorder_ = littleendian;
    REMOTE_CONTROL_PERSISTENT_ = false;
    CHANNEL_OPTION_SHOW_PROTOCOL_ = false;
    CHANNEL_OPTION_COMPRESS_ = false;
    CHANNEL_OPTION_COMPRESS_RDP_ = false;
    CHANNEL_OPTION_PRI_LOW_ = false;
    CHANNEL_OPTION_PRI_MED_ = false;
    CHANNEL_OPTION_PRI_HIGH_ = false;
    CHANNEL_OPTION_ENCRYPT_CS_ = false;
    CHANNEL_OPTION_ENCRYPT_SC_ = false;
    CHANNEL_OPTION_ENCRYPT_RDP_ = false;
    CHANNEL_OPTION_INITIALIZED_ = false;
}

Client_Channel_Def::~Client_Channel_Def() {
    name_.free();
}

int Client_Channel_Def::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "name"
    // Checking out-of-bound for "Client_Channel_Def:name"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Channel_Def:name",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 8;
        int t_name_string_length;
        t_name_string_length = 8;
        int t_name__size;
        t_name__size = t_name_string_length;
        name_.init(t_begin_of_data, t_name_string_length);
    }

    const_byteptr const t_dataptr_after_name = t_begin_of_data + (8);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    // Checking out-of-bound for "Client_Channel_Def:options"
    if ( t_dataptr_after_name + (4) > t_end_of_data || t_dataptr_after_name + (4) < t_dataptr_after_name ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Client_Channel_Def:options",
        	((t_dataptr_after_name - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "options"
    options_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_name)));

    int t_Client_Channel_Def__size;
    t_Client_Channel_Def__size = (t_dataptr_after_name + 4) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    REMOTE_CONTROL_PERSISTENT_ = options() & 0x00100000;
    CHANNEL_OPTION_SHOW_PROTOCOL_ = options() & 0x00200000;
    CHANNEL_OPTION_COMPRESS_ = options() & 0x00400000;
    CHANNEL_OPTION_COMPRESS_RDP_ = options() & 0x00800000;
    CHANNEL_OPTION_PRI_LOW_ = options() & 0x02000000;
    CHANNEL_OPTION_PRI_MED_ = options() & 0x04000000;
    CHANNEL_OPTION_PRI_HIGH_ = options() & 0x08000000;
    CHANNEL_OPTION_ENCRYPT_CS_ = options() & 0x10000000;
    CHANNEL_OPTION_ENCRYPT_SC_ = options() & 0x20000000;
    CHANNEL_OPTION_ENCRYPT_RDP_ = options() & 0x40000000;
    CHANNEL_OPTION_INITIALIZED_ = options() & 0x80000000;
    BINPAC_ASSERT(t_begin_of_data + (t_Client_Channel_Def__size) <= t_end_of_data);
    return t_Client_Channel_Def__size;
}

Server_Header::Server_Header() {
    type_length_ = nullptr;
    type_length__elem_ = 0;
    connect_response_result_ = nullptr;
    connect_response_called_id_ = nullptr;
    connect_response_domain_parameters_ = nullptr;
    user_data_length_ = 0;
    gcc_connection_data_ = nullptr;
    gcc_create_response_ = nullptr;
    data_blocks_ = nullptr;
    data_blocks__elem_ = nullptr;
    byteorder_ = littleendian;
}

Server_Header::~Server_Header() {
    delete type_length_;
    delete connect_response_result_;
    connect_response_result_ = nullptr;
    delete connect_response_called_id_;
    connect_response_called_id_ = nullptr;
    delete connect_response_domain_parameters_;
    connect_response_domain_parameters_ = nullptr;
    delete gcc_connection_data_;
    gcc_connection_data_ = nullptr;
    delete gcc_create_response_;
    gcc_create_response_ = nullptr;
    delete data_blocks__elem_;
    data_blocks__elem_ = nullptr;
    if ( data_blocks() ) {
        for ( auto* data_blocks__elem_ : *data_blocks() ) {
            delete data_blocks__elem_;
            data_blocks__elem_ = nullptr;
        }
    }
    delete data_blocks_;
}

int Server_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Server_Header:type_length"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Header:type_length",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type_length"
    int t_type_length__arraylength;
    t_type_length__arraylength = 3;
    if ( t_type_length__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("Server_Header:type_length",
          t_type_length__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: Server_Header:type_length
    if ( t_type_length__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("Server_Header:type_length",
          t_type_length__arraylength, (t_end_of_data) - (t_begin_of_data));
    type_length__elem_ = 0;
    int t_type_length__elem__it;
    t_type_length__elem__it = 0;
    type_length_ = new vector<uint8>;
    type_length_->reserve(t_type_length__arraylength);
    const_byteptr t_type_length__elem__dataptr = t_begin_of_data;
    for (; t_type_length__elem__it < t_type_length__arraylength; ++t_type_length__elem__it) {
        type_length__elem_ = *(reinterpret_cast<uint8 const*>(t_type_length__elem__dataptr));
        type_length_->push_back(type_length__elem_);
        t_type_length__elem__dataptr += 1;
        BINPAC_ASSERT(t_type_length__elem__dataptr <= t_end_of_data);
    }
end_of_type_length: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "connect_response_result"
    connect_response_result_ = new ASN1Enumerated();
    int t_connect_response_result__size;
    t_connect_response_result__size = connect_response_result_->Parse((t_begin_of_data + 3), t_end_of_data);

    const_byteptr const t_dataptr_after_connect_response_result = (t_begin_of_data + 3) + (t_connect_response_result__size);
    BINPAC_ASSERT(t_dataptr_after_connect_response_result <= t_end_of_data);
    // Parse "connect_response_called_id"
    connect_response_called_id_ = new ASN1Integer();
    int t_connect_response_called_id__size;
    t_connect_response_called_id__size = connect_response_called_id_->Parse(t_dataptr_after_connect_response_result, t_end_of_data);

    const_byteptr const t_dataptr_after_connect_response_called_id = t_dataptr_after_connect_response_result + (t_connect_response_called_id__size);
    BINPAC_ASSERT(t_dataptr_after_connect_response_called_id <= t_end_of_data);
    // Parse "connect_response_domain_parameters"
    connect_response_domain_parameters_ = new ASN1SequenceMeta();
    int t_connect_response_domain_parameters__size;
    t_connect_response_domain_parameters__size = connect_response_domain_parameters_->Parse(t_dataptr_after_connect_response_called_id, t_end_of_data);

    const_byteptr const t_dataptr_after_connect_response_domain_parameters = t_dataptr_after_connect_response_called_id + (t_connect_response_domain_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_connect_response_domain_parameters <= t_end_of_data);
    // Parse "domain_parameters"
    int t_domain_parameters__size;
    t_domain_parameters__size = connect_response_domain_parameters()->encoding()->length();
    // Checking out-of-bound for "Server_Header:domain_parameters"
    if ( t_dataptr_after_connect_response_domain_parameters + (t_domain_parameters__size) > t_end_of_data || t_dataptr_after_connect_response_domain_parameters + (t_domain_parameters__size) < t_dataptr_after_connect_response_domain_parameters ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Header:domain_parameters",
        	((t_dataptr_after_connect_response_domain_parameters - t_begin_of_data)) + (t_domain_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_connect_response_domain_parameters + t_domain_parameters__size;
        int t_domain_parameters_string_length;
        t_domain_parameters_string_length = connect_response_domain_parameters()->encoding()->length();
        // check for negative sizes
        if ( t_domain_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:281", t_domain_parameters_string_length);
        domain_parameters_.init(t_dataptr_after_connect_response_domain_parameters, t_domain_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_domain_parameters = t_dataptr_after_connect_response_domain_parameters + (t_domain_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_domain_parameters <= t_end_of_data);
    // Checking out-of-bound for "Server_Header:user_data_length"
    if ( t_dataptr_after_domain_parameters + (4) > t_end_of_data || t_dataptr_after_domain_parameters + (4) < t_dataptr_after_domain_parameters ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Header:user_data_length",
        	((t_dataptr_after_domain_parameters - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "user_data_length"
    user_data_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_domain_parameters)));

    // Parse "gcc_connection_data"
    gcc_connection_data_ = new GCC_Server_Connection_Data();
    int t_gcc_connection_data__size;
    t_gcc_connection_data__size = gcc_connection_data_->Parse((t_dataptr_after_domain_parameters + 4), t_end_of_data);

    const_byteptr const t_dataptr_after_gcc_connection_data = (t_dataptr_after_domain_parameters + 4) + (t_gcc_connection_data__size);
    BINPAC_ASSERT(t_dataptr_after_gcc_connection_data <= t_end_of_data);
    // Parse "gcc_create_response"
    gcc_create_response_ = new GCC_Server_Create_Response();
    int t_gcc_create_response__size;
    t_gcc_create_response__size = gcc_create_response_->Parse(t_dataptr_after_gcc_connection_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_gcc_create_response = t_dataptr_after_gcc_connection_data + (t_gcc_create_response__size);
    BINPAC_ASSERT(t_dataptr_after_gcc_create_response <= t_end_of_data);
    // Parse "data_blocks"
    int t_data_blocks__arraylength;
    t_data_blocks__arraylength = 0;
    data_blocks__elem_ = nullptr;
    int t_data_blocks__elem__it;
    t_data_blocks__elem__it = 0;
    int t_data_blocks__size;
    data_blocks_ = new vector<Data_Block*>;
    const_byteptr t_data_blocks__elem__dataptr = t_dataptr_after_gcc_create_response;
    for (; /* forever */; ++t_data_blocks__elem__it) {
        // Check &until(data_blocks__elem__dataptr >= end_of_data)
        if ( t_data_blocks__elem__dataptr >= t_end_of_data ) {
            data_blocks__elem_ = nullptr;
            goto end_of_data_blocks;
        }
        data_blocks__elem_ = new Data_Block();
        int t_data_blocks__elem__size;
        t_data_blocks__elem__size = data_blocks__elem_->Parse(t_data_blocks__elem__dataptr, t_end_of_data, t_context);
        data_blocks_->push_back(data_blocks__elem_);
        t_data_blocks__elem__dataptr += t_data_blocks__elem__size;
        BINPAC_ASSERT(t_data_blocks__elem__dataptr <= t_end_of_data);
        data_blocks__elem_ = nullptr;
    }
end_of_data_blocks: ;
    t_data_blocks__size = t_data_blocks__elem__dataptr - (t_dataptr_after_gcc_create_response);
    // Evaluate 'let' and 'withinput' fields

    int t_Server_Header__size;
    const_byteptr const t_dataptr_after_data_blocks = t_dataptr_after_gcc_create_response + (t_data_blocks__size);
    BINPAC_ASSERT(t_dataptr_after_data_blocks <= t_end_of_data);
    t_Server_Header__size = t_dataptr_after_data_blocks - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Server_Header__size) <= t_end_of_data);
    return t_Server_Header__size;
}

GCC_Server_Connection_Data::GCC_Server_Connection_Data() {
    key_object_length_ = 0;
    key_object_ = nullptr;
    key_object__elem_ = 0;
    connect_data_connect_pdu_ = 0;
    byteorder_ = bigendian;
}

GCC_Server_Connection_Data::~GCC_Server_Connection_Data() {
    delete key_object_;
}

int GCC_Server_Connection_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "GCC_Server_Connection_Data:key_object_length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Server_Connection_Data:key_object_length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "key_object_length"
    key_object_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "key_object"
    int t_key_object__arraylength;
    t_key_object__arraylength = key_object_length();
    if ( t_key_object__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("GCC_Server_Connection_Data:key_object",
          t_key_object__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: GCC_Server_Connection_Data:key_object
    if ( t_key_object__arraylength > ((t_end_of_data - (t_begin_of_data + 2)) / 1) )
        throw binpac::ExceptionOutOfBound("GCC_Server_Connection_Data:key_object",
          t_key_object__arraylength, (t_end_of_data) - ((t_begin_of_data + 2)));
    key_object__elem_ = 0;
    int t_key_object__elem__it;
    t_key_object__elem__it = 0;
    int t_key_object__size;
    key_object_ = new vector<uint8>;
    key_object_->reserve(t_key_object__arraylength);
    const_byteptr t_key_object__elem__dataptr = (t_begin_of_data + 2);
    for (; t_key_object__elem__it < t_key_object__arraylength; ++t_key_object__elem__it) {
        key_object__elem_ = *(reinterpret_cast<uint8 const*>(t_key_object__elem__dataptr));
        key_object_->push_back(key_object__elem_);
        t_key_object__elem__dataptr += 1;
        BINPAC_ASSERT(t_key_object__elem__dataptr <= t_end_of_data);
    }
end_of_key_object: ;
    t_key_object__size = t_key_object__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_key_object = (t_begin_of_data + 2) + (t_key_object__size);
    BINPAC_ASSERT(t_dataptr_after_key_object <= t_end_of_data);
    // Checking out-of-bound for "GCC_Server_Connection_Data:connect_data_connect_pdu"
    if ( t_dataptr_after_key_object + (1) > t_end_of_data || t_dataptr_after_key_object + (1) < t_dataptr_after_key_object ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Server_Connection_Data:connect_data_connect_pdu",
        	((t_dataptr_after_key_object - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "connect_data_connect_pdu"
    connect_data_connect_pdu_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_key_object));

    int t_GCC_Server_Connection_Data__size;
    t_GCC_Server_Connection_Data__size = (t_dataptr_after_key_object + 1) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_GCC_Server_Connection_Data__size) <= t_end_of_data);
    return t_GCC_Server_Connection_Data__size;
}

RegExMatcher GCC_Server_Create_Response_re_005("McDn");

GCC_Server_Create_Response::GCC_Server_Create_Response() {
    extension_bit_ = 0;
    node_id_ = 0;
    tag_length_ = 0;
    tag_ = 0;
    result_ = 0;
    number_user_data_sets_ = 0;
    user_data_value_present_ = 0;
    h221_nonstandard_length_ = 0;
    user_data_value_length_ = 0;
    byteorder_ = bigendian;
    proc_ = false;
}

GCC_Server_Create_Response::~GCC_Server_Create_Response() {
    h221_nonstandard_key_.free();
}

int GCC_Server_Create_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "GCC_Server_Create_Response:h221_nonstandard_length"
    if ( (t_begin_of_data + 8) + (1) > t_end_of_data || (t_begin_of_data + 8) + (1) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Server_Create_Response:h221_nonstandard_length",
        	(8) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "extension_bit"
    extension_bit_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "node_id"
    node_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "tag_length"
    tag_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "tag"
    tag_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "result"
    result_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Parse "number_user_data_sets"
    number_user_data_sets_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "user_data_value_present"
    user_data_value_present_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Parse "h221_nonstandard_length"
    h221_nonstandard_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Parse "h221_nonstandard_key"
    int t_h221_nonstandard_key_string_length;
    t_h221_nonstandard_key_string_length = 
        GCC_Server_Create_Response_re_005.MatchPrefix(
            (t_begin_of_data + 9),
            t_end_of_data - (t_begin_of_data + 9));
    if ( t_h221_nonstandard_key_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:304", "McDn", string(reinterpret_cast<const char*>((t_begin_of_data + 9)), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_h221_nonstandard_key__size;
    t_h221_nonstandard_key__size = t_h221_nonstandard_key_string_length;
    // check for negative sizes
    if ( t_h221_nonstandard_key_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:304", t_h221_nonstandard_key_string_length);
    h221_nonstandard_key_.init((t_begin_of_data + 9), t_h221_nonstandard_key_string_length);

    const_byteptr const t_dataptr_after_h221_nonstandard_key = (t_begin_of_data + 9) + (t_h221_nonstandard_key__size);
    BINPAC_ASSERT(t_dataptr_after_h221_nonstandard_key <= t_end_of_data);
    // Checking out-of-bound for "GCC_Server_Create_Response:user_data_value_length"
    if ( t_dataptr_after_h221_nonstandard_key + (2) > t_end_of_data || t_dataptr_after_h221_nonstandard_key + (2) < t_dataptr_after_h221_nonstandard_key ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("GCC_Server_Create_Response:user_data_value_length",
        	((t_dataptr_after_h221_nonstandard_key - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "user_data_value_length"
    user_data_value_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_h221_nonstandard_key)));

    int t_GCC_Server_Create_Response__size;
    t_GCC_Server_Create_Response__size = (t_dataptr_after_h221_nonstandard_key + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_rdp_gcc_server_create_response(this);
    BINPAC_ASSERT(t_begin_of_data + (t_GCC_Server_Create_Response__size) <= t_end_of_data);
    return t_GCC_Server_Create_Response__size;
}

Server_Core_Data::Server_Core_Data(Data_Header* h) {
    version_major_ = 0;
    version_minor_ = 0;
    switch1_case_index_ = -1;
    client_requested_protocols_ = 0;
    h_ = h;
    byteorder_ = littleendian;
}

Server_Core_Data::~Server_Core_Data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((uint16)8):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "client_requested_protocols"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Server_Core_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Server_Core_Data:version_minor"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Core_Data:version_minor",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version_major"
    version_major_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "version_minor"
    version_minor_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "switch1"
    int t_switch1__size;
    switch1_case_index_ = h()->length();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch1_case_index() ) {
        case ((uint16)8):
            // Parse "none"
            {
                t_switch1__size = 0;
            }
            break;
        default:
            // Parse "client_requested_protocols"
            {
                // Checking out-of-bound for "Server_Core_Data:client_requested_protocols"
                if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Server_Core_Data:client_requested_protocols",
                    	(4) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                client_requested_protocols_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));
                t_switch1__size = 4;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Server_Core_Data__size;
    const_byteptr const t_dataptr_after_switch1 = (t_begin_of_data + 4) + (t_switch1__size);
    BINPAC_ASSERT(t_dataptr_after_switch1 <= t_end_of_data);
    t_Server_Core_Data__size = t_dataptr_after_switch1 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Server_Core_Data__size) <= t_end_of_data);
    return t_Server_Core_Data__size;
}

Server_Network_Data::Server_Network_Data() {
    mcs_channel_id_ = 0;
    channel_count_ = 0;
    byteorder_ = littleendian;
}

Server_Network_Data::~Server_Network_Data() {
}

int Server_Network_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Server_Network_Data"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Network_Data",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "mcs_channel_id"
    mcs_channel_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "channel_count"
    channel_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

Server_Security_Data::Server_Security_Data() {
    encryption_method_ = 0;
    encryption_level_ = 0;
    server_random_length_ = 0;
    server_cert_length_ = 0;
    server_certificate_ = nullptr;
    byteorder_ = littleendian;
    enc_ = false;
    has_enc_ = false;
    proc_ = false;
}

Server_Security_Data::~Server_Security_Data() {
    server_random_.free();
    delete server_certificate_;
    server_certificate_ = nullptr;
}

int Server_Security_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Server_Security_Data:server_cert_length"
    if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Security_Data:server_cert_length",
        	(12) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "encryption_method"
    encryption_method_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "encryption_level"
    encryption_level_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "server_random_length"
    server_random_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));
    // Evaluate '&enforce' attribute
    if (! (  ( encryption_level() == 0 && encryption_method() == 0 && server_random_length() == 0 )  ||  ( server_random_length() == 0x20 )  ) ) {
        throw binpac::ExceptionEnforceViolation("Server_Security_Data:server_random_length");
    }

    // Parse "server_cert_length"
    server_cert_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "server_random"
    int t_server_random__size;
    t_server_random__size = server_random_length();
    // Checking out-of-bound for "Server_Security_Data:server_random"
    if ( (t_begin_of_data + 16) + (t_server_random__size) > t_end_of_data || (t_begin_of_data + 16) + (t_server_random__size) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Security_Data:server_random",
        	(16) + (t_server_random__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 16) + t_server_random__size;
        int t_server_random_string_length;
        t_server_random_string_length = server_random_length();
        // check for negative sizes
        if ( t_server_random_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:329", t_server_random_string_length);
        server_random_.init((t_begin_of_data + 16), t_server_random_string_length);
    }

    const_byteptr const t_dataptr_after_server_random = (t_begin_of_data + 16) + (t_server_random__size);
    BINPAC_ASSERT(t_dataptr_after_server_random <= t_end_of_data);
    // Parse "server_certificate"
    server_certificate_ = new Server_Certificate();
    int t_server_certificate__size;
    t_server_certificate__size = server_cert_length();
    // Checking out-of-bound for "Server_Security_Data:server_certificate"
    if ( t_dataptr_after_server_random + (t_server_certificate__size) > t_end_of_data || t_dataptr_after_server_random + (t_server_certificate__size) < t_dataptr_after_server_random ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Security_Data:server_certificate",
        	((t_dataptr_after_server_random - t_begin_of_data)) + (t_server_certificate__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_server_random + t_server_certificate__size;
        server_certificate_->Parse(t_dataptr_after_server_random, t_end_of_data, t_context);
    }

    int t_Server_Security_Data__size;
    const_byteptr const t_dataptr_after_server_certificate = t_dataptr_after_server_random + (t_server_certificate__size);
    BINPAC_ASSERT(t_dataptr_after_server_certificate <= t_end_of_data);
    t_Server_Security_Data__size = t_dataptr_after_server_certificate - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    has_enc_ =  ( encryption_method() > 0 && encryption_level() > 0 ) ;
    if ( has_enc() ) {
        enc_ = t_context->connection()->go_encrypted(0);
    }
    proc_ = t_context->flow()->proc_rdp_server_security(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Server_Security_Data__size) <= t_end_of_data);
    return t_Server_Security_Data__size;
}

Server_Certificate::Server_Certificate() {
    version_ = 0;
    switch_case_index_ = -1;
    proprietary_ = nullptr;
    x509_ = nullptr;
    byteorder_ = littleendian;
    cert_type_ = 0;
    permanently_issued_ = false;
    proc_ = false;
}

Server_Certificate::~Server_Certificate() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch_case_index() ) {
        case ((uint32)1):
            // Clean up "proprietary"
            {
                delete proprietary_;
                proprietary_ = nullptr;
            }
            break;
        case ((uint32)2):
            // Clean up "x509"
            {
                delete x509_;
                x509_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Server_Certificate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Server_Certificate:version"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Certificate:version",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "switch"
    int t_switch__size;
    cert_type_ = version() & 0x7FFFFFFF;
    switch_case_index_ = cert_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( switch_case_index() ) {
        case ((uint32)1):
            // Parse "proprietary"
            {
                proprietary_ = new Server_Proprietary_Cert(this);
                int t_proprietary__size;
                t_proprietary__size = proprietary_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                t_switch__size = t_proprietary__size;
            }
            break;
        case ((uint32)2):
            // Parse "x509"
            {
                x509_ = new X509();
                int t_x509__size;
                t_x509__size = x509_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                t_switch__size = t_x509__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("Server_Certificate", (int64)switch_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_Server_Certificate__size;
    const_byteptr const t_dataptr_after_switch = (t_begin_of_data + 4) + (t_switch__size);
    BINPAC_ASSERT(t_dataptr_after_switch <= t_end_of_data);
    t_Server_Certificate__size = t_dataptr_after_switch - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    permanently_issued_ =  ( version() & 0x80000000 )  == 0;
    proc_ = t_context->flow()->proc_rdp_server_certificate(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Server_Certificate__size) <= t_end_of_data);
    return t_Server_Certificate__size;
}

Server_Proprietary_Cert::Server_Proprietary_Cert(Server_Certificate* cert) {
    signature_algorithm_ = 0;
    key_algorithm_ = 0;
    public_key_blob_type_ = 0;
    public_key_blob_length_ = 0;
    public_key_blob_ = nullptr;
    signature_blob_type_ = 0;
    signature_blob_length_ = 0;
    cert_ = cert;
    byteorder_ = littleendian;
}

Server_Proprietary_Cert::~Server_Proprietary_Cert() {
    delete public_key_blob_;
    public_key_blob_ = nullptr;
    signature_blob_.free();
}

int Server_Proprietary_Cert::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "Server_Proprietary_Cert:public_key_blob_length"
    if ( (t_begin_of_data + 10) + (2) > t_end_of_data || (t_begin_of_data + 10) + (2) < (t_begin_of_data + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Proprietary_Cert:public_key_blob_length",
        	(10) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "signature_algorithm"
    signature_algorithm_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "key_algorithm"
    key_algorithm_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "public_key_blob_type"
    public_key_blob_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "public_key_blob_length"
    public_key_blob_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "public_key_blob"
    public_key_blob_ = new Public_Key_Blob();
    int t_public_key_blob__size;
    t_public_key_blob__size = public_key_blob_length();
    // Checking out-of-bound for "Server_Proprietary_Cert:public_key_blob"
    if ( (t_begin_of_data + 12) + (t_public_key_blob__size) > t_end_of_data || (t_begin_of_data + 12) + (t_public_key_blob__size) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Proprietary_Cert:public_key_blob",
        	(12) + (t_public_key_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 12) + t_public_key_blob__size;
        public_key_blob_->Parse((t_begin_of_data + 12), t_end_of_data);
    }

    const_byteptr const t_dataptr_after_public_key_blob = (t_begin_of_data + 12) + (t_public_key_blob__size);
    BINPAC_ASSERT(t_dataptr_after_public_key_blob <= t_end_of_data);
    // Checking out-of-bound for "Server_Proprietary_Cert:signature_blob_length"
    if ( (t_dataptr_after_public_key_blob + 2) + (2) > t_end_of_data || (t_dataptr_after_public_key_blob + 2) + (2) < (t_dataptr_after_public_key_blob + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Proprietary_Cert:signature_blob_length",
        	(((t_dataptr_after_public_key_blob + 2) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "signature_blob_type"
    signature_blob_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_public_key_blob)));

    // Parse "signature_blob_length"
    signature_blob_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_public_key_blob + 2))));

    // Parse "signature_blob"
    int t_signature_blob__size;
    t_signature_blob__size = signature_blob_length();
    // Checking out-of-bound for "Server_Proprietary_Cert:signature_blob"
    if ( (t_dataptr_after_public_key_blob + 4) + (t_signature_blob__size) > t_end_of_data || (t_dataptr_after_public_key_blob + 4) + (t_signature_blob__size) < (t_dataptr_after_public_key_blob + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Server_Proprietary_Cert:signature_blob",
        	(((t_dataptr_after_public_key_blob + 4) - t_begin_of_data)) + (t_signature_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_public_key_blob + 4) + t_signature_blob__size;
        int t_signature_blob_string_length;
        t_signature_blob_string_length = signature_blob_length();
        // check for negative sizes
        if ( t_signature_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:357", t_signature_blob_string_length);
        signature_blob_.init((t_dataptr_after_public_key_blob + 4), t_signature_blob_string_length);
    }

    int t_Server_Proprietary_Cert__size;
    const_byteptr const t_dataptr_after_signature_blob = (t_dataptr_after_public_key_blob + 4) + (t_signature_blob__size);
    BINPAC_ASSERT(t_dataptr_after_signature_blob <= t_end_of_data);
    t_Server_Proprietary_Cert__size = t_dataptr_after_signature_blob - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Server_Proprietary_Cert__size) <= t_end_of_data);
    return t_Server_Proprietary_Cert__size;
}

Public_Key_Blob::Public_Key_Blob() {
    key_length_ = 0;
    bit_length_ = 0;
    public_exponent_ = 0;
    byteorder_ = littleendian;
}

Public_Key_Blob::~Public_Key_Blob() {
    magic_.free();
    modulus_.free();
}

int Public_Key_Blob::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "magic"
    // Checking out-of-bound for "Public_Key_Blob:magic"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Public_Key_Blob:magic",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 4;
        int t_magic_string_length;
        t_magic_string_length = 4;
        int t_magic__size;
        t_magic__size = t_magic_string_length;
        magic_.init(t_begin_of_data, t_magic_string_length);
    }

    const_byteptr const t_dataptr_after_magic = t_begin_of_data + (4);
    BINPAC_ASSERT(t_dataptr_after_magic <= t_end_of_data);
    // Checking out-of-bound for "Public_Key_Blob:public_exponent"
    if ( (t_dataptr_after_magic + 8) + (4) > t_end_of_data || (t_dataptr_after_magic + 8) + (4) < (t_dataptr_after_magic + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Public_Key_Blob:public_exponent",
        	(((t_dataptr_after_magic + 8) - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "key_length"
    key_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_magic)));

    // Parse "bit_length"
    bit_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_magic + 4))));

    // Parse "public_exponent"
    public_exponent_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_magic + 8))));

    // Parse "modulus"
    int t_modulus__size;
    t_modulus__size = key_length();
    // Checking out-of-bound for "Public_Key_Blob:modulus"
    if ( (t_dataptr_after_magic + 12) + (t_modulus__size) > t_end_of_data || (t_dataptr_after_magic + 12) + (t_modulus__size) < (t_dataptr_after_magic + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Public_Key_Blob:modulus",
        	(((t_dataptr_after_magic + 12) - t_begin_of_data)) + (t_modulus__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_magic + 12) + t_modulus__size;
        int t_modulus_string_length;
        t_modulus_string_length = key_length();
        // check for negative sizes
        if ( t_modulus_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:365", t_modulus_string_length);
        modulus_.init((t_dataptr_after_magic + 12), t_modulus_string_length);
    }

    int t_Public_Key_Blob__size;
    const_byteptr const t_dataptr_after_modulus = (t_dataptr_after_magic + 12) + (t_modulus__size);
    BINPAC_ASSERT(t_dataptr_after_modulus <= t_end_of_data);
    t_Public_Key_Blob__size = t_dataptr_after_modulus - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Public_Key_Blob__size) <= t_end_of_data);
    return t_Public_Key_Blob__size;
}

X509::X509() {
    num_of_certs_ = 0;
    certs_ = nullptr;
    certs__elem_ = nullptr;
    byteorder_ = littleendian;
}

X509::~X509() {
    delete certs__elem_;
    certs__elem_ = nullptr;
    if ( certs() ) {
        for ( auto* certs__elem_ : *certs() ) {
            delete certs__elem_;
            certs__elem_ = nullptr;
        }
    }
    delete certs_;
}

int X509::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "X509:num_of_certs"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("X509:num_of_certs",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "num_of_certs"
    num_of_certs_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "certs"
    int t_certs__arraylength;
    t_certs__arraylength = num_of_certs();
    if ( t_certs__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("X509:certs",
          t_certs__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: X509:certs
    if ( t_certs__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 1) )
        throw binpac::ExceptionOutOfBound("X509:certs",
          t_certs__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
    certs__elem_ = nullptr;
    int t_certs__elem__it;
    t_certs__elem__it = 0;
    int t_certs__size;
    certs_ = new vector<X509_Cert_Data*>;
    certs_->reserve(t_certs__arraylength);
    const_byteptr t_certs__elem__dataptr = (t_begin_of_data + 4);
    for (; t_certs__elem__it < t_certs__arraylength; ++t_certs__elem__it) {
        certs__elem_ = new X509_Cert_Data();
        int t_certs__elem__size;
        t_certs__elem__size = certs__elem_->Parse(t_certs__elem__dataptr, t_end_of_data, t_context);
        certs_->push_back(certs__elem_);
        t_certs__elem__dataptr += t_certs__elem__size;
        BINPAC_ASSERT(t_certs__elem__dataptr <= t_end_of_data);
        certs__elem_ = nullptr;
    }
end_of_certs: ;
    t_certs__size = t_certs__elem__dataptr - ((t_begin_of_data + 4));
    // Evaluate 'let' and 'withinput' fields

    int t_X509__size;
    const_byteptr const t_dataptr_after_certs = (t_begin_of_data + 4) + (t_certs__size);
    BINPAC_ASSERT(t_dataptr_after_certs <= t_end_of_data);
    t_X509__size = t_dataptr_after_certs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_X509__size) <= t_end_of_data);
    return t_X509__size;
}

X509_Cert_Data::X509_Cert_Data() {
    cert_len_ = 0;
    byteorder_ = littleendian;
    proc_ = false;
}

X509_Cert_Data::~X509_Cert_Data() {
    cert_.free();
}

int X509_Cert_Data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDP* t_context) {
    // Checking out-of-bound for "X509_Cert_Data:cert_len"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("X509_Cert_Data:cert_len",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cert_len"
    cert_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "cert"
    int t_cert__size;
    t_cert__size = cert_len();
    // Checking out-of-bound for "X509_Cert_Data:cert"
    if ( (t_begin_of_data + 4) + (t_cert__size) > t_end_of_data || (t_begin_of_data + 4) + (t_cert__size) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("X509_Cert_Data:cert",
        	(4) + (t_cert__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_cert__size;
        int t_cert_string_length;
        t_cert_string_length = cert_len();
        // check for negative sizes
        if ( t_cert_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdp-protocol.pac:375", t_cert_string_length);
        cert_.init((t_begin_of_data + 4), t_cert_string_length);
    }

    int t_X509_Cert_Data__size;
    const_byteptr const t_dataptr_after_cert = (t_begin_of_data + 4) + (t_cert__size);
    BINPAC_ASSERT(t_dataptr_after_cert <= t_end_of_data);
    t_X509_Cert_Data__size = t_dataptr_after_cert - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_x509_cert_data(this);
    BINPAC_ASSERT(t_begin_of_data + (t_X509_Cert_Data__size) <= t_end_of_data);
    return t_X509_Cert_Data__size;
}

RDP_Flow::RDP_Flow(RDP_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

RDP_Flow::~RDP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void RDP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new TPKT(is_orig());
                flow_buffer_->NewFrame(0, false);
                context_ = new ContextRDP(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            while ( ! t_dataunit_parsing_complete && flow_buffer_->ready() ) {
                const_byteptr t_begin_of_data = flow_buffer()->begin();
                const_byteptr t_end_of_data = flow_buffer()->end();
                t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
                if ( t_dataunit_parsing_complete ) {
                }
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void RDP_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void RDP_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool RDP_Flow::proc_rdp_connect_request(Connect_Request* cr) {

		if ( rdp_connect_request )
			{
			zeek::StringValPtr cookie_value;
			if ( cr->cookie() )
				cookie_value = to_stringval(cr->cookie()->cookie_value());
			else
				cookie_value = zeek::val_mgr->EmptyString();

			zeek::BifEvent::enqueue_rdp_connect_request(connection()->zeek_analyzer(),
			                                      connection()->zeek_analyzer()->Conn(),
			                                      cookie_value,
			                                      cr->rdp_neg_req() ? cr->rdp_neg_req()->flags() : 0);
			}

		return true;
		
}

bool RDP_Flow::proc_rdp_negotiation_response(RDP_Negotiation_Response* nr) {

		if ( rdp_negotiation_response )
			{
			zeek::BifEvent::enqueue_rdp_negotiation_response(connection()->zeek_analyzer(),
			                                           connection()->zeek_analyzer()->Conn(),
			                                           nr->selected_protocol(),
			                                           nr->flags());
			}

		return true;
		
}

bool RDP_Flow::proc_rdp_negotiation_failure(RDP_Negotiation_Failure* nf) {

		if ( rdp_negotiation_failure )
			{
			zeek::BifEvent::enqueue_rdp_negotiation_failure(connection()->zeek_analyzer(),
			                                          connection()->zeek_analyzer()->Conn(),
			                                          nf->failure_code(),
			                                          nf->flags());
			}

		return true;
		
}

bool RDP_Flow::proc_rdp_gcc_server_create_response(GCC_Server_Create_Response* gcc_response) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();

		if ( rdp_gcc_server_create_response )
			zeek::BifEvent::enqueue_rdp_gcc_server_create_response(connection()->zeek_analyzer(),
			                                                 connection()->zeek_analyzer()->Conn(),
			                                                 gcc_response->result());

		return true;
		
}

bool RDP_Flow::proc_rdp_client_core_data(Client_Core_Data* ccore) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();

		if ( rdp_client_core_data )
			{
			auto ec_flags = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::RDP::EarlyCapabilityFlags);
			ec_flags->Assign(0, ccore->SUPPORT_ERRINFO_PDU());
			ec_flags->Assign(1, ccore->WANT_32BPP_SESSION());
			ec_flags->Assign(2, ccore->SUPPORT_STATUSINFO_PDU());
			ec_flags->Assign(3, ccore->STRONG_ASYMMETRIC_KEYS());
			ec_flags->Assign(4, ccore->SUPPORT_MONITOR_LAYOUT_PDU());
			ec_flags->Assign(5, ccore->SUPPORT_NETCHAR_AUTODETECT());
			ec_flags->Assign(6, ccore->SUPPORT_DYNVC_GFX_PROTOCOL());
			ec_flags->Assign(7, ccore->SUPPORT_DYNAMIC_TIME_ZONE());
			ec_flags->Assign(8, ccore->SUPPORT_HEARTBEAT_PDU());

			auto ccd = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::RDP::ClientCoreData);
			ccd->Assign(0, ccore->version_major());
			ccd->Assign(1, ccore->version_minor());
			ccd->Assign(2, ccore->desktop_width());
			ccd->Assign(3, ccore->desktop_height());
			ccd->Assign(4, ccore->color_depth());
			ccd->Assign(5, ccore->sas_sequence());
			ccd->Assign(6, ccore->keyboard_layout());
			ccd->Assign(7, ccore->client_build());
			ccd->Assign(8, utf16_to_utf8_val(connection()->zeek_analyzer()->Conn(), ccore->client_name()));
			ccd->Assign(9, ccore->keyboard_type());
			ccd->Assign(10, ccore->keyboard_sub());
			ccd->Assign(11, ccore->keyboard_function_key());
			ccd->Assign(12, utf16_to_utf8_val(connection()->zeek_analyzer()->Conn(), ccore->ime_file_name()));
			ccd->Assign(13, ccore->post_beta2_color_depth());
			ccd->Assign(14, ccore->client_product_id());
			ccd->Assign(15, ccore->serial_number());
			ccd->Assign(16, ccore->high_color_depth());
			ccd->Assign(17, ccore->supported_color_depths());
			ccd->Assign(18, std::move(ec_flags));
			ccd->Assign(19, utf16_to_utf8_val(connection()->zeek_analyzer()->Conn(), ccore->dig_product_id()));

			zeek::BifEvent::enqueue_rdp_client_core_data(connection()->zeek_analyzer(),
			                                       connection()->zeek_analyzer()->Conn(),
			                                       std::move(ccd));
			}

		return true;
		
}

bool RDP_Flow::proc_rdp_client_security_data(Client_Security_Data* csec) {

		if ( ! rdp_client_security_data )
			return false;

		auto csd = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::RDP::ClientSecurityData);
		csd->Assign(0, csec->encryption_methods());
		csd->Assign(1, csec->ext_encryption_methods());

		zeek::BifEvent::enqueue_rdp_client_security_data(connection()->zeek_analyzer(),
		                                           connection()->zeek_analyzer()->Conn(),
		                                           std::move(csd));
		return true;
		
}

bool RDP_Flow::proc_rdp_client_network_data(Client_Network_Data* cnetwork) {

		if ( ! rdp_client_network_data )
			return false;

		if ( ! cnetwork->channel_def_array()->empty() )
			{
			auto channels = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::RDP::ClientChannelList);

            for ( const auto& cdef : *cnetwork->channel_def_array() )
				{
				auto channel_def = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::RDP::ClientChannelDef);

				channel_def->Assign(0, to_stringval(cdef->name()));
				channel_def->Assign(1, cdef->options());

				channel_def->Assign(2, cdef->CHANNEL_OPTION_INITIALIZED());
				channel_def->Assign(3, cdef->CHANNEL_OPTION_ENCRYPT_RDP());
				channel_def->Assign(4, cdef->CHANNEL_OPTION_ENCRYPT_SC());
				channel_def->Assign(5, cdef->CHANNEL_OPTION_ENCRYPT_CS());
				channel_def->Assign(6, cdef->CHANNEL_OPTION_PRI_HIGH());
				channel_def->Assign(7, cdef->CHANNEL_OPTION_PRI_MED());
				channel_def->Assign(8, cdef->CHANNEL_OPTION_PRI_LOW());
				channel_def->Assign(9, cdef->CHANNEL_OPTION_COMPRESS_RDP());
				channel_def->Assign(10, cdef->CHANNEL_OPTION_COMPRESS());
				channel_def->Assign(11, cdef->CHANNEL_OPTION_SHOW_PROTOCOL());
				channel_def->Assign(12, cdef->REMOTE_CONTROL_PERSISTENT());

				channels->Assign(channels->Size(), std::move(channel_def));
				}

			zeek::BifEvent::enqueue_rdp_client_network_data(connection()->zeek_analyzer(),
			                                          connection()->zeek_analyzer()->Conn(),
			                                          std::move(channels));
			}

		return true;
		
}

bool RDP_Flow::proc_rdp_client_cluster_data(Client_Cluster_Data* ccluster) {

		if ( ! rdp_client_cluster_data )
			return false;

		auto ccld = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::RDP::ClientClusterData);
		ccld->Assign(0, ccluster->flags());
		ccld->Assign(1, ccluster->redir_session_id());
		ccld->Assign(2, ccluster->REDIRECTION_SUPPORTED());
		ccld->Assign(3, ccluster->SERVER_SESSION_REDIRECTION_VERSION_MASK());
		ccld->Assign(4, ccluster->REDIRECTED_SESSIONID_FIELD_VALID());
		ccld->Assign(5, ccluster->REDIRECTED_SMARTCARD());

		zeek::BifEvent::enqueue_rdp_client_cluster_data(connection()->zeek_analyzer(),
		                                          connection()->zeek_analyzer()->Conn(),
		                                          std::move(ccld));
		return true;
		
}

bool RDP_Flow::proc_rdp_server_security(Server_Security_Data* ssd) {

		connection()->zeek_analyzer()->AnalyzerConfirmation();

		if ( rdp_server_security )
			zeek::BifEvent::enqueue_rdp_server_security(connection()->zeek_analyzer(),
			                                       connection()->zeek_analyzer()->Conn(),
			                                       ssd->encryption_method(),
			                                       ssd->encryption_level());

		return true;
		
}

bool RDP_Flow::proc_rdp_server_certificate(Server_Certificate* cert) {

		if ( rdp_server_certificate )
			{
			zeek::BifEvent::enqueue_rdp_server_certificate(connection()->zeek_analyzer(),
			                                          connection()->zeek_analyzer()->Conn(),
			                                          cert->cert_type(),
			                                          cert->permanently_issued());
			}

		return true;
		
}

bool RDP_Flow::proc_x509_cert_data(X509_Cert_Data* x509) {

		const bytestring& cert = x509->cert();

		zeek::ODesc file_handle;
		file_handle.AddRaw("Analyzer::ANALYZER_RDP");
		file_handle.Add(connection()->zeek_analyzer()->Conn()->StartTime());
		connection()->zeek_analyzer()->Conn()->IDString(&file_handle);
		string file_id = zeek::file_mgr->HashHandle(file_handle.Description());

		zeek::file_mgr->DataIn(reinterpret_cast<const u_char*>(cert.data()),
		                       cert.length(),
		                       connection()->zeek_analyzer()->GetAnalyzerTag(),
		                       connection()->zeek_analyzer()->Conn(),
		                       false, // It seems there are only server certs?
		                       file_id, "application/x-x509-user-cert");
		zeek::file_mgr->EndOfFile(file_id);

		return true;
		
}

} // namespace RDP
}  // namespace binpac
