// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/rdp/rdpeudp_pac.h"

namespace binpac {






namespace RDPEUDP {
ContextRDPEUDP::ContextRDPEUDP(RDPEUDP_Conn* connection, RDPEUDP_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextRDPEUDP::~ContextRDPEUDP() {
}

RDPEUDP_Conn::RDPEUDP_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new RDPEUDP_Flow(this, true);
    downflow_ = new RDPEUDP_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

RDPEUDP_Conn::~RDPEUDP_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void RDPEUDP_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void RDPEUDP_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void RDPEUDP_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

uint8 RDPEUDP_Conn::get_state() {

		return state_;
		
}

bool RDPEUDP_Conn::is_rdpeudp2() {

		return orig_synex_flags_  == RDPUDP_PROTOCOL_VERSION_3 && resp_synex_flags_ == RDPUDP_PROTOCOL_VERSION_3;
		
}

bool RDPEUDP_Conn::proc_rdpeudp_syn(bool is_orig, uint16 uFlags, uint32 snSourceAck, uint16 uUdpVer) {

		if ( ! is_orig )
			return false;

		if ( (uFlags & 0x01) == 0 )
			return false;

		if ( snSourceAck != 0xffffffff )
			return false;

		orig_synex_flags_ = uUdpVer;

		if ( (uFlags & 0x0200) == 0x0200 )
			orig_lossy_ = true;

		if ( rdpeudp_syn )
			zeek::BifEvent::enqueue_rdpeudp_syn(zeek_analyzer(), zeek_analyzer()->Conn());

		state_ = NEED_SYNACK;
		return true;
		
}

bool RDPEUDP_Conn::proc_rdpeudp_synack(bool is_orig, uint16 uFlags, uint16 uUdpVer) {

		if ( is_orig )
			return false;

		if ( (uFlags & 0x05) == 0 )
			return false;

		if ( rdpeudp_synack )
			zeek::BifEvent::enqueue_rdpeudp_synack(zeek_analyzer(), zeek_analyzer()->Conn());

		zeek_analyzer()->AnalyzerConfirmation();
		state_ = NEED_ACK;
		resp_synex_flags_ = uUdpVer;

		if ( (uFlags & 0x0200) == 0x0200 )
			resp_lossy_ = true;

		return true;
		
}

bool RDPEUDP_Conn::proc_rdpeudp1_ack(bool is_orig, bytestring const& data) {

		if ( state_ == NEED_ACK )
			{
			state_ = ESTABLISHED;

			if ( rdpeudp_established )
				zeek::BifEvent::enqueue_rdpeudp_established(zeek_analyzer(), zeek_analyzer()->Conn(), 1);
			}

		if ( state_ == ESTABLISHED && rdpeudp_data )
			zeek::BifEvent::enqueue_rdpeudp_data(zeek_analyzer(),
							zeek_analyzer()->Conn(),
							is_orig,
							1,
							to_stringval(data)
			);

		return true;
		
}

bool RDPEUDP_Conn::proc_rdpeudp2_ack(bool is_orig, uint8 pkt_type, bytestring const& data) {

		if ( pkt_type == 8 )
			// This is a "dummy packet".
			return false;

		if ( state_ == NEED_ACK )
			{
			if ( rdpeudp_established )
				zeek::BifEvent::enqueue_rdpeudp_established(zeek_analyzer(), zeek_analyzer()->Conn(), 2);

			state_ = ESTABLISHED;
			}

		if ( state_ == ESTABLISHED && rdpeudp_data )
			zeek::BifEvent::enqueue_rdpeudp_data(zeek_analyzer(),
							zeek_analyzer()->Conn(),
							is_orig,
							2,
							to_stringval(data)
			);

		return true;
		
}

RDPEUDP_PDU::RDPEUDP_PDU(bool is_orig) {
    state_case_index_ = -1;
    need_syn_ = nullptr;
    need_synack_ = nullptr;
    need_ack_ = nullptr;
    established_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
}

RDPEUDP_PDU::~RDPEUDP_PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( state_case_index() ) {
        case ((uint8)1):
            // Clean up "need_syn"
            {
                delete need_syn_;
                need_syn_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "need_synack"
            {
                delete need_synack_;
                need_synack_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "need_ack"
            {
                delete need_ack_;
                need_ack_ = nullptr;
            }
            break;
        default:
            // Clean up "established"
            {
                delete established_;
                established_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RDPEUDP_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context) {
    // Parse "state"
    int t_state__size;
    state_case_index_ = t_context->connection()->get_state();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( state_case_index() ) {
        case ((uint8)1):
            // Parse "need_syn"
            {
                need_syn_ = new RDPEUDP_SYN(this, is_orig());
                int t_need_syn__size;
                t_need_syn__size = need_syn_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_state__size = t_need_syn__size;
            }
            break;
        case ((uint8)2):
            // Parse "need_synack"
            {
                need_synack_ = new RDPEUDP_SYNACK(this, is_orig());
                int t_need_synack__size;
                t_need_synack__size = need_synack_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_state__size = t_need_synack__size;
            }
            break;
        case ((uint8)3):
            // Parse "need_ack"
            {
                need_ack_ = new RDPEUDP_ACK(this, is_orig());
                int t_need_ack__size;
                t_need_ack__size = need_ack_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_state__size = t_need_ack__size;
            }
            break;
        default:
            // Parse "established"
            {
                established_ = new RDPEUDP_ACK(this, is_orig());
                int t_established__size;
                t_established__size = established_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_state__size = t_established__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_RDPEUDP_PDU__size;
    const_byteptr const t_dataptr_after_state = t_begin_of_data + (t_state__size);
    BINPAC_ASSERT(t_dataptr_after_state <= t_end_of_data);
    t_RDPEUDP_PDU__size = t_dataptr_after_state - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDPEUDP_PDU__size) <= t_end_of_data);
    return t_RDPEUDP_PDU__size;
}

RDPEUDP_SYN::RDPEUDP_SYN(RDPEUDP_PDU* pdu, bool is_orig) {
    fec_header_ = nullptr;
    syndata_payload_ = nullptr;
    corr_id_payload_case_index_ = -1;
    has_corr_id_payload_ = nullptr;
    synex_payload_case_index_ = -1;
    has_synex_payload_ = nullptr;
    pdu_ = pdu;
    is_orig_ = is_orig;
    proc_rdpeudp_syn_ = false;
}

RDPEUDP_SYN::~RDPEUDP_SYN() {
    delete fec_header_;
    fec_header_ = nullptr;
    delete syndata_payload_;
    syndata_payload_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( corr_id_payload_case_index() ) {
        case ((int)1):
            // Clean up "has_corr_id_payload"
            {
                delete has_corr_id_payload_;
                has_corr_id_payload_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "has_no_corr_id_payload"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( synex_payload_case_index() ) {
        case ((int)1):
            // Clean up "has_synex_payload"
            {
                delete has_synex_payload_;
                has_synex_payload_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "has_no_synex_payload"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RDPEUDP_SYN::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder) {
    // Checking out-of-bound for "RDPEUDP_SYN:syndata_payload"
    if ( (t_begin_of_data + 8) + (8) > t_end_of_data || (t_begin_of_data + 8) + (8) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPEUDP_SYN:syndata_payload",
        	(8) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "fec_header"
    fec_header_ = new RDPUDP_FEC_HEADER();
    fec_header_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "syndata_payload"
    syndata_payload_ = new RDPUDP_SYNDATA_PAYLOAD();
    syndata_payload_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "corr_id_payload"
    int t_corr_id_payload__size;
    corr_id_payload_case_index_ =  (  ( fec_header()->uFlags() & RDPUDP_FLAG_CORRELATION_ID )  > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( corr_id_payload_case_index() ) {
        case ((int)1):
            // Parse "has_corr_id_payload"
            {
                has_corr_id_payload_ = new RDPUDP_CORRELATION_ID_PAYLOAD();
                has_corr_id_payload_->Parse((t_begin_of_data + 16), t_end_of_data);
                t_corr_id_payload__size = 32;
            }
            break;
        case ((int)0):
            // Parse "has_no_corr_id_payload"
            {
                t_corr_id_payload__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RDPEUDP_SYN", (int64)corr_id_payload_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_corr_id_payload = (t_begin_of_data + 16) + (t_corr_id_payload__size);
    BINPAC_ASSERT(t_dataptr_after_corr_id_payload <= t_end_of_data);
    // Parse "synex_payload"
    int t_synex_payload__size;
    synex_payload_case_index_ =  (  ( fec_header()->uFlags() & RDPUDP_FLAG_SYNEX )  > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( synex_payload_case_index() ) {
        case ((int)1):
            // Parse "has_synex_payload"
            {
                has_synex_payload_ = new RDPUDP_SYNEX_PAYLOAD();
                int t_has_synex_payload__size;
                t_has_synex_payload__size = has_synex_payload_->Parse(t_dataptr_after_corr_id_payload, t_end_of_data, t_byteorder);
                t_synex_payload__size = t_has_synex_payload__size;
            }
            break;
        case ((int)0):
            // Parse "has_no_synex_payload"
            {
                t_synex_payload__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RDPEUDP_SYN", (int64)synex_payload_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_RDPEUDP_SYN__size;
    const_byteptr const t_dataptr_after_synex_payload = t_dataptr_after_corr_id_payload + (t_synex_payload__size);
    BINPAC_ASSERT(t_dataptr_after_synex_payload <= t_end_of_data);
    t_RDPEUDP_SYN__size = t_dataptr_after_synex_payload - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_rdpeudp_syn_ = t_context->connection()->proc_rdpeudp_syn(is_orig(), fec_header()->uFlags(), fec_header()->snSourceAck(), has_synex_payload()->uUdpVer());
    BINPAC_ASSERT(t_begin_of_data + (t_RDPEUDP_SYN__size) <= t_end_of_data);
    return t_RDPEUDP_SYN__size;
}

RDPUDP_SYNEX_PAYLOAD::RDPUDP_SYNEX_PAYLOAD() {
    uSynExFlags_ = 0;
    uUdpVer_ = 0;
    cookieHash_case_index_ = -1;
    has_cookie_hash_ = nullptr;
    has_cookie_hash__elem_ = 0;
}

RDPUDP_SYNEX_PAYLOAD::~RDPUDP_SYNEX_PAYLOAD() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( cookieHash_case_index() ) {
        case ((int)1):
            // Clean up "has_cookie_hash"
            {
                delete has_cookie_hash_;
            }
            break;
        case ((int)0):
            // Clean up "has_no_cookie_hash"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RDPUDP_SYNEX_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP_SYNEX_PAYLOAD:uUdpVer"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_SYNEX_PAYLOAD:uUdpVer",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "uSynExFlags"
    uSynExFlags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "uUdpVer"
    uUdpVer_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "cookieHash"
    int t_cookieHash__size;
    cookieHash_case_index_ =  ( uUdpVer() == RDPUDP_PROTOCOL_VERSION_3 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( cookieHash_case_index() ) {
        case ((int)1):
            // Parse "has_cookie_hash"
            {
                int t_has_cookie_hash__arraylength;
                t_has_cookie_hash__arraylength = 32;
                if ( t_has_cookie_hash__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("RDPUDP_SYNEX_PAYLOAD:has_cookie_hash",
                      t_has_cookie_hash__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: RDPUDP_SYNEX_PAYLOAD:has_cookie_hash
                if ( t_has_cookie_hash__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 1) )
                    throw binpac::ExceptionOutOfBound("RDPUDP_SYNEX_PAYLOAD:has_cookie_hash",
                      t_has_cookie_hash__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
                has_cookie_hash__elem_ = 0;
                int t_has_cookie_hash__elem__it;
                t_has_cookie_hash__elem__it = 0;
                has_cookie_hash_ = new vector<uint8>;
                has_cookie_hash_->reserve(t_has_cookie_hash__arraylength);
                const_byteptr t_has_cookie_hash__elem__dataptr = (t_begin_of_data + 4);
                for (; t_has_cookie_hash__elem__it < t_has_cookie_hash__arraylength; ++t_has_cookie_hash__elem__it) {
                    has_cookie_hash__elem_ = *(reinterpret_cast<uint8 const*>(t_has_cookie_hash__elem__dataptr));
                    has_cookie_hash_->push_back(has_cookie_hash__elem_);
                    t_has_cookie_hash__elem__dataptr += 1;
                    BINPAC_ASSERT(t_has_cookie_hash__elem__dataptr <= t_end_of_data);
                }
            end_of_has_cookie_hash: ;
                // Evaluate 'let' and 'withinput' fields
                t_cookieHash__size = 32;
            }
            break;
        case ((int)0):
            // Parse "has_no_cookie_hash"
            {
                t_cookieHash__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RDPUDP_SYNEX_PAYLOAD", (int64)cookieHash_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_RDPUDP_SYNEX_PAYLOAD__size;
    const_byteptr const t_dataptr_after_cookieHash = (t_begin_of_data + 4) + (t_cookieHash__size);
    BINPAC_ASSERT(t_dataptr_after_cookieHash <= t_end_of_data);
    t_RDPUDP_SYNEX_PAYLOAD__size = t_dataptr_after_cookieHash - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDPUDP_SYNEX_PAYLOAD__size) <= t_end_of_data);
    return t_RDPUDP_SYNEX_PAYLOAD__size;
}

RDPUDP_CORRELATION_ID_PAYLOAD::RDPUDP_CORRELATION_ID_PAYLOAD() {
    uCorrelationId_ = nullptr;
    uCorrelationId__elem_ = 0;
    uReserved_ = nullptr;
    uReserved__elem_ = 0;
}

RDPUDP_CORRELATION_ID_PAYLOAD::~RDPUDP_CORRELATION_ID_PAYLOAD() {
    delete uCorrelationId_;
    delete uReserved_;
}

int RDPUDP_CORRELATION_ID_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RDPUDP_CORRELATION_ID_PAYLOAD"
    if ( t_begin_of_data + (32) > t_end_of_data || t_begin_of_data + (32) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_CORRELATION_ID_PAYLOAD",
        	(0) + (32), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "uCorrelationId"
    int t_uCorrelationId__arraylength;
    t_uCorrelationId__arraylength = 16;
    if ( t_uCorrelationId__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("RDPUDP_CORRELATION_ID_PAYLOAD:uCorrelationId",
          t_uCorrelationId__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: RDPUDP_CORRELATION_ID_PAYLOAD:uCorrelationId
    if ( t_uCorrelationId__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("RDPUDP_CORRELATION_ID_PAYLOAD:uCorrelationId",
          t_uCorrelationId__arraylength, (t_end_of_data) - (t_begin_of_data));
    uCorrelationId__elem_ = 0;
    int t_uCorrelationId__elem__it;
    t_uCorrelationId__elem__it = 0;
    uCorrelationId_ = new vector<uint8>;
    uCorrelationId_->reserve(t_uCorrelationId__arraylength);
    const_byteptr t_uCorrelationId__elem__dataptr = t_begin_of_data;
    for (; t_uCorrelationId__elem__it < t_uCorrelationId__arraylength; ++t_uCorrelationId__elem__it) {
        uCorrelationId__elem_ = *(reinterpret_cast<uint8 const*>(t_uCorrelationId__elem__dataptr));
        uCorrelationId_->push_back(uCorrelationId__elem_);
        t_uCorrelationId__elem__dataptr += 1;
        BINPAC_ASSERT(t_uCorrelationId__elem__dataptr <= t_end_of_data);
    }
end_of_uCorrelationId: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "uReserved"
    int t_uReserved__arraylength;
    t_uReserved__arraylength = 16;
    if ( t_uReserved__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("RDPUDP_CORRELATION_ID_PAYLOAD:uReserved",
          t_uReserved__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: RDPUDP_CORRELATION_ID_PAYLOAD:uReserved
    if ( t_uReserved__arraylength > ((t_end_of_data - (t_begin_of_data + 16)) / 1) )
        throw binpac::ExceptionOutOfBound("RDPUDP_CORRELATION_ID_PAYLOAD:uReserved",
          t_uReserved__arraylength, (t_end_of_data) - ((t_begin_of_data + 16)));
    uReserved__elem_ = 0;
    int t_uReserved__elem__it;
    t_uReserved__elem__it = 0;
    uReserved_ = new vector<uint8>;
    uReserved_->reserve(t_uReserved__arraylength);
    const_byteptr t_uReserved__elem__dataptr = (t_begin_of_data + 16);
    for (; t_uReserved__elem__it < t_uReserved__arraylength; ++t_uReserved__elem__it) {
        uReserved__elem_ = *(reinterpret_cast<uint8 const*>(t_uReserved__elem__dataptr));
        uReserved_->push_back(uReserved__elem_);
        t_uReserved__elem__dataptr += 1;
        BINPAC_ASSERT(t_uReserved__elem__dataptr <= t_end_of_data);
    }
end_of_uReserved: ;
    // Evaluate 'let' and 'withinput' fields

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (32) <= t_end_of_data);
    return 32;
}

RDPUDP_SYNDATA_PAYLOAD::RDPUDP_SYNDATA_PAYLOAD() {
    snInitialSequenceNumber_ = 0;
    uUpStreamMtu_ = 0;
    uDownStreamMtu_ = 0;
}

RDPUDP_SYNDATA_PAYLOAD::~RDPUDP_SYNDATA_PAYLOAD() {
}

int RDPUDP_SYNDATA_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP_SYNDATA_PAYLOAD"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_SYNDATA_PAYLOAD",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "snInitialSequenceNumber"
    snInitialSequenceNumber_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "uUpStreamMtu"
    uUpStreamMtu_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "uDownStreamMtu"
    uDownStreamMtu_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

RDPEUDP_SYNACK::RDPEUDP_SYNACK(RDPEUDP_PDU* pdu, bool is_orig) {
    fec_header_ = nullptr;
    syndata_payload_ = nullptr;
    corr_id_payload_case_index_ = -1;
    has_corr_id_payload_ = nullptr;
    synex_payload_case_index_ = -1;
    has_synex_payload_ = nullptr;
    pdu_ = pdu;
    is_orig_ = is_orig;
    proc_rdpeudp_synack_ = false;
}

RDPEUDP_SYNACK::~RDPEUDP_SYNACK() {
    delete fec_header_;
    fec_header_ = nullptr;
    delete syndata_payload_;
    syndata_payload_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( corr_id_payload_case_index() ) {
        case ((int)1):
            // Clean up "has_corr_id_payload"
            {
                delete has_corr_id_payload_;
                has_corr_id_payload_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "has_no_corr_id_payload"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( synex_payload_case_index() ) {
        case ((int)1):
            // Clean up "has_synex_payload"
            {
                delete has_synex_payload_;
                has_synex_payload_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "has_no_synex_payload"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RDPEUDP_SYNACK::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder) {
    // Checking out-of-bound for "RDPEUDP_SYNACK:syndata_payload"
    if ( (t_begin_of_data + 8) + (8) > t_end_of_data || (t_begin_of_data + 8) + (8) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPEUDP_SYNACK:syndata_payload",
        	(8) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "fec_header"
    fec_header_ = new RDPUDP_FEC_HEADER();
    fec_header_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "syndata_payload"
    syndata_payload_ = new RDPUDP_SYNDATA_PAYLOAD();
    syndata_payload_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "corr_id_payload"
    int t_corr_id_payload__size;
    corr_id_payload_case_index_ =  (  ( fec_header()->uFlags() & RDPUDP_FLAG_CORRELATION_ID )  > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( corr_id_payload_case_index() ) {
        case ((int)1):
            // Parse "has_corr_id_payload"
            {
                has_corr_id_payload_ = new RDPUDP_CORRELATION_ID_PAYLOAD();
                has_corr_id_payload_->Parse((t_begin_of_data + 16), t_end_of_data);
                t_corr_id_payload__size = 32;
            }
            break;
        case ((int)0):
            // Parse "has_no_corr_id_payload"
            {
                t_corr_id_payload__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RDPEUDP_SYNACK", (int64)corr_id_payload_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_corr_id_payload = (t_begin_of_data + 16) + (t_corr_id_payload__size);
    BINPAC_ASSERT(t_dataptr_after_corr_id_payload <= t_end_of_data);
    // Parse "synex_payload"
    int t_synex_payload__size;
    synex_payload_case_index_ =  (  ( fec_header()->uFlags() & RDPUDP_FLAG_SYNEX )  > 0 ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( synex_payload_case_index() ) {
        case ((int)1):
            // Parse "has_synex_payload"
            {
                has_synex_payload_ = new RDPUDP_SYNEX_PAYLOAD();
                int t_has_synex_payload__size;
                t_has_synex_payload__size = has_synex_payload_->Parse(t_dataptr_after_corr_id_payload, t_end_of_data, t_byteorder);
                t_synex_payload__size = t_has_synex_payload__size;
            }
            break;
        case ((int)0):
            // Parse "has_no_synex_payload"
            {
                t_synex_payload__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RDPEUDP_SYNACK", (int64)synex_payload_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_RDPEUDP_SYNACK__size;
    const_byteptr const t_dataptr_after_synex_payload = t_dataptr_after_corr_id_payload + (t_synex_payload__size);
    BINPAC_ASSERT(t_dataptr_after_synex_payload <= t_end_of_data);
    t_RDPEUDP_SYNACK__size = t_dataptr_after_synex_payload - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_rdpeudp_synack_ = t_context->connection()->proc_rdpeudp_synack(is_orig(), fec_header()->uFlags(), has_synex_payload()->uUdpVer());
    BINPAC_ASSERT(t_begin_of_data + (t_RDPEUDP_SYNACK__size) <= t_end_of_data);
    return t_RDPEUDP_SYNACK__size;
}

RDPEUDP_ACK::RDPEUDP_ACK(RDPEUDP_PDU* pdu, bool is_orig) {
    version_case_index_ = -1;
    version2_ = nullptr;
    version1_ = nullptr;
    pdu_ = pdu;
    is_orig_ = is_orig;
}

RDPEUDP_ACK::~RDPEUDP_ACK() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( version_case_index() ) {
        case true:
            // Clean up "version2"
            {
                delete version2_;
                version2_ = nullptr;
            }
            break;
        case false:
            // Clean up "version1"
            {
                delete version1_;
                version1_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RDPEUDP_ACK::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder) {
    // Parse "version"
    int t_version__size;
    version_case_index_ =  ( t_context->connection()->is_rdpeudp2() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( version_case_index() ) {
        case true:
            // Parse "version2"
            {
                version2_ = new RDPEUDP2_ACK(pdu(), is_orig());
                int t_version2__size;
                t_version2__size = version2_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_version__size = t_version2__size;
            }
            break;
        case false:
            // Parse "version1"
            {
                version1_ = new RDPEUDP1_ACK(pdu(), is_orig());
                int t_version1__size;
                t_version1__size = version1_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_version__size = t_version1__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RDPEUDP_ACK", (int64)version_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_RDPEUDP_ACK__size;
    const_byteptr const t_dataptr_after_version = t_begin_of_data + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    t_RDPEUDP_ACK__size = t_dataptr_after_version - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDPEUDP_ACK__size) <= t_end_of_data);
    return t_RDPEUDP_ACK__size;
}

RDPEUDP1_ACK::RDPEUDP1_ACK(RDPEUDP_PDU* pdu, bool is_orig) {
    fec_header_ = nullptr;
    ack_vec_header_ = nullptr;
    ack_of_ackvec_header_case_index_ = -1;
    some_ = nullptr;
    source_payload_header_case_index_ = -1;
    some_source_payload_ = nullptr;
    pdu_ = pdu;
    is_orig_ = is_orig;
    proc_rdpeudp1_ack_ = false;
}

RDPEUDP1_ACK::~RDPEUDP1_ACK() {
    delete fec_header_;
    fec_header_ = nullptr;
    delete ack_vec_header_;
    ack_vec_header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( ack_of_ackvec_header_case_index() ) {
        case ((int)256):
            // Clean up "some"
            {
                delete some_;
                some_ = nullptr;
            }
            break;
        default:
            // Clean up "no_ack_of_ackvec_header"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( source_payload_header_case_index() ) {
        case ((int)8):
            // Clean up "some_source_payload"
            {
                delete some_source_payload_;
                some_source_payload_ = nullptr;
            }
            break;
        default:
            // Clean up "no_source_payload_header"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    data_.free();
}

int RDPEUDP1_ACK::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder) {
    // Checking out-of-bound for "RDPEUDP1_ACK:fec_header"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPEUDP1_ACK:fec_header",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "fec_header"
    fec_header_ = new RDPUDP_FEC_HEADER();
    fec_header_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "ack_vec_header"
    ack_vec_header_ = new RDPUDP_ACK_VECTOR_HEADER();
    int t_ack_vec_header__size;
    t_ack_vec_header__size = ack_vec_header_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_ack_vec_header = (t_begin_of_data + 8) + (t_ack_vec_header__size);
    BINPAC_ASSERT(t_dataptr_after_ack_vec_header <= t_end_of_data);
    // Parse "ack_of_ackvec_header"
    int t_ack_of_ackvec_header__size;
    ack_of_ackvec_header_case_index_ = fec_header()->uFlags() & RDPUDP_FLAG_ACK_OF_ACKS;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( ack_of_ackvec_header_case_index() ) {
        case ((int)256):
            // Parse "some"
            {
                some_ = new RDPUDP_ACK_OF_ACKVECTOR_HEADER();
                some_->Parse(t_dataptr_after_ack_vec_header, t_end_of_data, t_byteorder);
                t_ack_of_ackvec_header__size = 4;
            }
            break;
        default:
            // Parse "no_ack_of_ackvec_header"
            {
                t_ack_of_ackvec_header__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_ack_of_ackvec_header = t_dataptr_after_ack_vec_header + (t_ack_of_ackvec_header__size);
    BINPAC_ASSERT(t_dataptr_after_ack_of_ackvec_header <= t_end_of_data);
    // Parse "source_payload_header"
    int t_source_payload_header__size;
    source_payload_header_case_index_ =  ( fec_header()->uFlags() & RDPUDP_FLAG_DATA ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( source_payload_header_case_index() ) {
        case ((int)8):
            // Parse "some_source_payload"
            {
                some_source_payload_ = new RDPUDP_SOURCE_PAYLOAD_HEADER();
                some_source_payload_->Parse(t_dataptr_after_ack_of_ackvec_header, t_end_of_data, t_byteorder);
                t_source_payload_header__size = 8;
            }
            break;
        default:
            // Parse "no_source_payload_header"
            {
                t_source_payload_header__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_source_payload_header = t_dataptr_after_ack_of_ackvec_header + (t_source_payload_header__size);
    BINPAC_ASSERT(t_dataptr_after_source_payload_header <= t_end_of_data);
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_dataptr_after_source_payload_header);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:119", t_data_string_length);
    data_.init(t_dataptr_after_source_payload_header, t_data_string_length);

    int t_RDPEUDP1_ACK__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_source_payload_header + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_RDPEUDP1_ACK__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_rdpeudp1_ack_ = t_context->connection()->proc_rdpeudp1_ack(is_orig(), data());
    BINPAC_ASSERT(t_begin_of_data + (t_RDPEUDP1_ACK__size) <= t_end_of_data);
    return t_RDPEUDP1_ACK__size;
}

RDPUDP_SOURCE_PAYLOAD_HEADER::RDPUDP_SOURCE_PAYLOAD_HEADER() {
    snCoded_ = 0;
    snSourceStart_ = 0;
}

RDPUDP_SOURCE_PAYLOAD_HEADER::~RDPUDP_SOURCE_PAYLOAD_HEADER() {
}

int RDPUDP_SOURCE_PAYLOAD_HEADER::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP_SOURCE_PAYLOAD_HEADER"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_SOURCE_PAYLOAD_HEADER",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "snCoded"
    snCoded_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "snSourceStart"
    snSourceStart_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

RDPUDP_ACK_OF_ACKVECTOR_HEADER::RDPUDP_ACK_OF_ACKVECTOR_HEADER() {
    snAckOfAcksSeqNum_ = 0;
}

RDPUDP_ACK_OF_ACKVECTOR_HEADER::~RDPUDP_ACK_OF_ACKVECTOR_HEADER() {
}

int RDPUDP_ACK_OF_ACKVECTOR_HEADER::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP_ACK_OF_ACKVECTOR_HEADER"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_ACK_OF_ACKVECTOR_HEADER",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "snAckOfAcksSeqNum"
    snAckOfAcksSeqNum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

RDPUDP_FEC_HEADER::RDPUDP_FEC_HEADER() {
    snSourceAck_ = 0;
    uReceiveWindowSize_ = 0;
    uFlags_ = 0;
}

RDPUDP_FEC_HEADER::~RDPUDP_FEC_HEADER() {
}

int RDPUDP_FEC_HEADER::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP_FEC_HEADER"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_FEC_HEADER",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "snSourceAck"
    snSourceAck_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "uReceiveWindowSize"
    uReceiveWindowSize_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "uFlags"
    uFlags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

RDPUDP_ACK_VECTOR_HEADER::RDPUDP_ACK_VECTOR_HEADER() {
    uAckVectorSize_ = 0;
    AckVectorElement_ = nullptr;
    AckVectorElement__elem_ = 0;
}

RDPUDP_ACK_VECTOR_HEADER::~RDPUDP_ACK_VECTOR_HEADER() {
    delete AckVectorElement_;
}

int RDPUDP_ACK_VECTOR_HEADER::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP_ACK_VECTOR_HEADER:uAckVectorSize"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_ACK_VECTOR_HEADER:uAckVectorSize",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "uAckVectorSize"
    uAckVectorSize_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "AckVectorElement"
    int t_AckVectorElement__arraylength;
    t_AckVectorElement__arraylength = uAckVectorSize();
    if ( t_AckVectorElement__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("RDPUDP_ACK_VECTOR_HEADER:AckVectorElement",
          t_AckVectorElement__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: RDPUDP_ACK_VECTOR_HEADER:AckVectorElement
    if ( t_AckVectorElement__arraylength > ((t_end_of_data - (t_begin_of_data + 2)) / 1) )
        throw binpac::ExceptionOutOfBound("RDPUDP_ACK_VECTOR_HEADER:AckVectorElement",
          t_AckVectorElement__arraylength, (t_end_of_data) - ((t_begin_of_data + 2)));
    AckVectorElement__elem_ = 0;
    int t_AckVectorElement__elem__it;
    t_AckVectorElement__elem__it = 0;
    int t_AckVectorElement__size;
    AckVectorElement_ = new vector<uint8>;
    AckVectorElement_->reserve(t_AckVectorElement__arraylength);
    const_byteptr t_AckVectorElement__elem__dataptr = (t_begin_of_data + 2);
    for (; t_AckVectorElement__elem__it < t_AckVectorElement__arraylength; ++t_AckVectorElement__elem__it) {
        AckVectorElement__elem_ = *(reinterpret_cast<uint8 const*>(t_AckVectorElement__elem__dataptr));
        AckVectorElement_->push_back(AckVectorElement__elem_);
        t_AckVectorElement__elem__dataptr += 1;
        BINPAC_ASSERT(t_AckVectorElement__elem__dataptr <= t_end_of_data);
    }
end_of_AckVectorElement: ;
    t_AckVectorElement__size = t_AckVectorElement__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields


    int t_RDPUDP_ACK_VECTOR_HEADER__size;
    const_byteptr const t_dataptr_after_AckVectorElement = (t_begin_of_data + 2) + (t_AckVectorElement__size);
    BINPAC_ASSERT(t_dataptr_after_AckVectorElement <= t_end_of_data);
    int pad__size = (t_dataptr_after_AckVectorElement - t_begin_of_data) % 4;
    pad__size = (pad__size == 0) ? 0 : 4 - pad__size;
    const_byteptr const t_dataptr_after_pad = t_dataptr_after_AckVectorElement + pad__size;
    t_RDPUDP_ACK_VECTOR_HEADER__size = t_dataptr_after_pad - t_begin_of_data;
    // Checking out-of-bound for "RDPUDP_ACK_VECTOR_HEADER"
    if ( t_begin_of_data + (t_RDPUDP_ACK_VECTOR_HEADER__size) > t_end_of_data || t_begin_of_data + (t_RDPUDP_ACK_VECTOR_HEADER__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP_ACK_VECTOR_HEADER",
        	(0) + (t_RDPUDP_ACK_VECTOR_HEADER__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDPUDP_ACK_VECTOR_HEADER__size) <= t_end_of_data);
    return t_RDPUDP_ACK_VECTOR_HEADER__size;
}

RDPEUDP2_ACK::RDPEUDP2_ACK(RDPEUDP_PDU* pdu, bool is_orig) {
    PacketPrefixByte_ = 0;
    header_ = nullptr;
    pdu_ = pdu;
    is_orig_ = is_orig;
    Reserved_ = 0;
    Packet_Type_Index_ = 0;
    Short_Packet_Length_ = 0;
    proc_rdpeudp2_ack_ = false;
}

RDPEUDP2_ACK::~RDPEUDP2_ACK() {
    delete header_;
    header_ = nullptr;
    data_.free();
}

int RDPEUDP2_ACK::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder) {
    // Checking out-of-bound for "RDPEUDP2_ACK:header"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPEUDP2_ACK:header",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "PacketPrefixByte"
    PacketPrefixByte_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "header"
    header_ = new RDPUDP2_PACKET_HEADER();
    header_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 3));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:179", t_data_string_length);
    data_.init((t_begin_of_data + 3), t_data_string_length);

    int t_RDPEUDP2_ACK__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 3) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_RDPEUDP2_ACK__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    Reserved_ = PacketPrefixByte() & 0x80;
    Packet_Type_Index_ = PacketPrefixByte() & 0x78;
    Short_Packet_Length_ = PacketPrefixByte() & 0x07;
    proc_rdpeudp2_ack_ = t_context->connection()->proc_rdpeudp2_ack(is_orig(), Packet_Type_Index(), data());
    BINPAC_ASSERT(t_begin_of_data + (t_RDPEUDP2_ACK__size) <= t_end_of_data);
    return t_RDPEUDP2_ACK__size;
}

RDPUDP2_PACKET_HEADER::RDPUDP2_PACKET_HEADER() {
    everything_ = 0;
    Flags_ = 0;
    LogWindowSize_ = 0;
}

RDPUDP2_PACKET_HEADER::~RDPUDP2_PACKET_HEADER() {
}

int RDPUDP2_PACKET_HEADER::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_PACKET_HEADER"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_PACKET_HEADER",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "everything"
    everything_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    Flags_ = everything() & 0xfff0;
    LogWindowSize_ = everything() & 0x000f;
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

RDPUDP2_ACK_PAYLOAD::RDPUDP2_ACK_PAYLOAD() {
    SeqNum_ = 0;
    tmp1_ = 0;
    tmp2_ = 0;
    delayAckTimeAdditions_ = nullptr;
    delayAckTimeAdditions__elem_ = 0;
    receivedTS_ = 0;
    sendAckTimeGap_ = 0;
    numDelayedAcks_ = 0;
    delayAckTimeScale_ = 0;
}

RDPUDP2_ACK_PAYLOAD::~RDPUDP2_ACK_PAYLOAD() {
    delete delayAckTimeAdditions_;
}

int RDPUDP2_ACK_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_ACK_PAYLOAD:tmp2"
    if ( (t_begin_of_data + 6) + (1) > t_end_of_data || (t_begin_of_data + 6) + (1) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACK_PAYLOAD:tmp2",
        	(6) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "SeqNum"
    SeqNum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "tmp1"
    tmp1_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "tmp2"
    tmp2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 6)));

    // Parse "delayAckTimeAdditions"
    int t_delayAckTimeAdditions__arraylength;
    numDelayedAcks_ = tmp2() & 0xf0;
    t_delayAckTimeAdditions__arraylength = numDelayedAcks();
    if ( t_delayAckTimeAdditions__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACK_PAYLOAD:delayAckTimeAdditions",
          t_delayAckTimeAdditions__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: RDPUDP2_ACK_PAYLOAD:delayAckTimeAdditions
    if ( t_delayAckTimeAdditions__arraylength > ((t_end_of_data - (t_begin_of_data + 7)) / 1) )
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACK_PAYLOAD:delayAckTimeAdditions",
          t_delayAckTimeAdditions__arraylength, (t_end_of_data) - ((t_begin_of_data + 7)));
    delayAckTimeAdditions__elem_ = 0;
    int t_delayAckTimeAdditions__elem__it;
    t_delayAckTimeAdditions__elem__it = 0;
    int t_delayAckTimeAdditions__size;
    delayAckTimeAdditions_ = new vector<uint8>;
    delayAckTimeAdditions_->reserve(t_delayAckTimeAdditions__arraylength);
    const_byteptr t_delayAckTimeAdditions__elem__dataptr = (t_begin_of_data + 7);
    for (; t_delayAckTimeAdditions__elem__it < t_delayAckTimeAdditions__arraylength; ++t_delayAckTimeAdditions__elem__it) {
        delayAckTimeAdditions__elem_ = *(reinterpret_cast<uint8 const*>(t_delayAckTimeAdditions__elem__dataptr));
        delayAckTimeAdditions_->push_back(delayAckTimeAdditions__elem_);
        t_delayAckTimeAdditions__elem__dataptr += 1;
        BINPAC_ASSERT(t_delayAckTimeAdditions__elem__dataptr <= t_end_of_data);
    }
end_of_delayAckTimeAdditions: ;
    t_delayAckTimeAdditions__size = t_delayAckTimeAdditions__elem__dataptr - ((t_begin_of_data + 7));
    // Evaluate 'let' and 'withinput' fields

    int t_RDPUDP2_ACK_PAYLOAD__size;
    const_byteptr const t_dataptr_after_delayAckTimeAdditions = (t_begin_of_data + 7) + (t_delayAckTimeAdditions__size);
    BINPAC_ASSERT(t_dataptr_after_delayAckTimeAdditions <= t_end_of_data);
    t_RDPUDP2_ACK_PAYLOAD__size = t_dataptr_after_delayAckTimeAdditions - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    receivedTS_ = tmp1() & 0xffffff00;
    sendAckTimeGap_ = tmp1() & 0xff;
    delayAckTimeScale_ = tmp2() & 0x0f;
    BINPAC_ASSERT(t_begin_of_data + (t_RDPUDP2_ACK_PAYLOAD__size) <= t_end_of_data);
    return t_RDPUDP2_ACK_PAYLOAD__size;
}

RDPUDP2_OVERSIZE_PAYLOAD::RDPUDP2_OVERSIZE_PAYLOAD() {
    OverheadSize_ = 0;
}

RDPUDP2_OVERSIZE_PAYLOAD::~RDPUDP2_OVERSIZE_PAYLOAD() {
}

int RDPUDP2_OVERSIZE_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RDPUDP2_OVERSIZE_PAYLOAD"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_OVERSIZE_PAYLOAD",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "OverheadSize"
    OverheadSize_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

RDPUDP2_DATABODY_PAYLOAD::RDPUDP2_DATABODY_PAYLOAD() {
    ChannelSeqNum_ = 0;
}

RDPUDP2_DATABODY_PAYLOAD::~RDPUDP2_DATABODY_PAYLOAD() {
    Data_.free();
}

int RDPUDP2_DATABODY_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_DATABODY_PAYLOAD:ChannelSeqNum"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_DATABODY_PAYLOAD:ChannelSeqNum",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ChannelSeqNum"
    ChannelSeqNum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "Data"
    int t_Data_string_length;
    t_Data_string_length = (t_end_of_data) - ((t_begin_of_data + 2));
    int t_Data__size;
    t_Data__size = t_Data_string_length;
    // check for negative sizes
    if ( t_Data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:222", t_Data_string_length);
    Data_.init((t_begin_of_data + 2), t_Data_string_length);

    int t_RDPUDP2_DATABODY_PAYLOAD__size;
    const_byteptr const t_dataptr_after_Data = (t_begin_of_data + 2) + (t_Data__size);
    BINPAC_ASSERT(t_dataptr_after_Data <= t_end_of_data);
    t_RDPUDP2_DATABODY_PAYLOAD__size = t_dataptr_after_Data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDPUDP2_DATABODY_PAYLOAD__size) <= t_end_of_data);
    return t_RDPUDP2_DATABODY_PAYLOAD__size;
}

RDPUDP2_ACKVECTOR_PAYLOAD::RDPUDP2_ACKVECTOR_PAYLOAD() {
    BaseSeqNum_ = 0;
    tmp1_ = 0;
    TimeStamp_or_not_case_index_ = -1;
    some_ = nullptr;
    codedAckVector_ = nullptr;
    codedAckVector__elem_ = 0;
    codedAckVecSize_ = 0;
    TimeStampPresent_ = 0;
}

RDPUDP2_ACKVECTOR_PAYLOAD::~RDPUDP2_ACKVECTOR_PAYLOAD() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( TimeStamp_or_not_case_index() ) {
        case ((uint8)0):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "some"
            {
                delete some_;
                some_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete codedAckVector_;
}

int RDPUDP2_ACKVECTOR_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_ACKVECTOR_PAYLOAD:tmp1"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACKVECTOR_PAYLOAD:tmp1",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "BaseSeqNum"
    BaseSeqNum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "tmp1"
    tmp1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "TimeStamp_or_not"
    TimeStampPresent_ = tmp1() & 0x01;
    int t_TimeStamp_or_not__size;
    TimeStamp_or_not_case_index_ = TimeStampPresent();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( TimeStamp_or_not_case_index() ) {
        case ((uint8)0):
            // Parse "none"
            {
                t_TimeStamp_or_not__size = 0;
            }
            break;
        default:
            // Parse "some"
            {
                some_ = new RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp();
                some_->Parse((t_begin_of_data + 3), t_end_of_data);
                t_TimeStamp_or_not__size = 3;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_TimeStamp_or_not = (t_begin_of_data + 3) + (t_TimeStamp_or_not__size);
    BINPAC_ASSERT(t_dataptr_after_TimeStamp_or_not <= t_end_of_data);
    // Parse "codedAckVector"
    int t_codedAckVector__arraylength;
    codedAckVecSize_ = tmp1() & 0xfe;
    t_codedAckVector__arraylength = codedAckVecSize();
    if ( t_codedAckVector__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACKVECTOR_PAYLOAD:codedAckVector",
          t_codedAckVector__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: RDPUDP2_ACKVECTOR_PAYLOAD:codedAckVector
    if ( t_codedAckVector__arraylength > ((t_end_of_data - t_dataptr_after_TimeStamp_or_not) / 1) )
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACKVECTOR_PAYLOAD:codedAckVector",
          t_codedAckVector__arraylength, (t_end_of_data) - (t_dataptr_after_TimeStamp_or_not));
    codedAckVector__elem_ = 0;
    int t_codedAckVector__elem__it;
    t_codedAckVector__elem__it = 0;
    int t_codedAckVector__size;
    codedAckVector_ = new vector<uint8>;
    codedAckVector_->reserve(t_codedAckVector__arraylength);
    const_byteptr t_codedAckVector__elem__dataptr = t_dataptr_after_TimeStamp_or_not;
    for (; t_codedAckVector__elem__it < t_codedAckVector__arraylength; ++t_codedAckVector__elem__it) {
        codedAckVector__elem_ = *(reinterpret_cast<uint8 const*>(t_codedAckVector__elem__dataptr));
        codedAckVector_->push_back(codedAckVector__elem_);
        t_codedAckVector__elem__dataptr += 1;
        BINPAC_ASSERT(t_codedAckVector__elem__dataptr <= t_end_of_data);
    }
end_of_codedAckVector: ;
    t_codedAckVector__size = t_codedAckVector__elem__dataptr - (t_dataptr_after_TimeStamp_or_not);
    // Evaluate 'let' and 'withinput' fields

    int t_RDPUDP2_ACKVECTOR_PAYLOAD__size;
    const_byteptr const t_dataptr_after_codedAckVector = t_dataptr_after_TimeStamp_or_not + (t_codedAckVector__size);
    BINPAC_ASSERT(t_dataptr_after_codedAckVector <= t_end_of_data);
    t_RDPUDP2_ACKVECTOR_PAYLOAD__size = t_dataptr_after_codedAckVector - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RDPUDP2_ACKVECTOR_PAYLOAD__size) <= t_end_of_data);
    return t_RDPUDP2_ACKVECTOR_PAYLOAD__size;
}

RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp::RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp() {
    tmp1_ = 0;
    tmp2_ = 0;
    tmp3_ = 0;
    TimeStamp_ = 0;
}

RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp::~RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp() {
}

int RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "tmp1"
    tmp1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "tmp2"
    tmp2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "tmp3"
    tmp3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    TimeStamp_ = tmp3() |  ( tmp2() << 8 )  |  ( tmp1() << 16 ) ;
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

RDPUDP2_DATAHEADER_PAYLOAD::RDPUDP2_DATAHEADER_PAYLOAD() {
    DataSeqNum_ = 0;
}

RDPUDP2_DATAHEADER_PAYLOAD::~RDPUDP2_DATAHEADER_PAYLOAD() {
}

int RDPUDP2_DATAHEADER_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_DATAHEADER_PAYLOAD"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_DATAHEADER_PAYLOAD",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "DataSeqNum"
    DataSeqNum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

RDPUDP2_ACKOFACKS_PAYLOAD::RDPUDP2_ACKOFACKS_PAYLOAD() {
    AckOfAcksSeqNum_ = 0;
}

RDPUDP2_ACKOFACKS_PAYLOAD::~RDPUDP2_ACKOFACKS_PAYLOAD() {
}

int RDPUDP2_ACKOFACKS_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_ACKOFACKS_PAYLOAD"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_ACKOFACKS_PAYLOAD",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "AckOfAcksSeqNum"
    AckOfAcksSeqNum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

RDPUDP2_DELAYACKINFO_PAYLOAD::RDPUDP2_DELAYACKINFO_PAYLOAD() {
    MaxDelayedAcks_ = 0;
    DelayedAckTimeoutInMs_ = 0;
}

RDPUDP2_DELAYACKINFO_PAYLOAD::~RDPUDP2_DELAYACKINFO_PAYLOAD() {
}

int RDPUDP2_DELAYACKINFO_PAYLOAD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RDPUDP2_DELAYACKINFO_PAYLOAD"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RDPUDP2_DELAYACKINFO_PAYLOAD",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "MaxDelayedAcks"
    MaxDelayedAcks_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "DelayedAckTimeoutInMs"
    DelayedAckTimeoutInMs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

RDPEUDP_Flow::RDPEUDP_Flow(RDPEUDP_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

RDPEUDP_Flow::~RDPEUDP_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void RDPEUDP_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new RDPEUDP_PDU(is_orig());
        context_ = new ContextRDPEUDP(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void RDPEUDP_Flow::NewGap(int gap_length) {
}
void RDPEUDP_Flow::FlowEOF() {
}
} // namespace RDPEUDP
}  // namespace binpac
