// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_rdp_rdpeudp_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_rdp_rdpeudp_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


	#include "zeek/analyzer/protocol/rdp/events.bif.h"

namespace binpac {

namespace RDPEUDP {
class ContextRDPEUDP;
class RDPEUDP_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum RDPEUDP_STATE {
    NEED_SYN = 1,
    NEED_SYNACK = 2,
    NEED_ACK = 3,
    ESTABLISHED = 4,
};
class RDPEUDP_PDU;
class RDPEUDP_SYN;
class RDPUDP_SYNEX_PAYLOAD;
// NOLINTNEXTLINE(performance-enum-size)
enum RDPUDP_VERSION_INFO_FLAG {
    RDPUDP_PROTOCOL_VERSION_1 = 1,
    RDPUDP_PROTOCOL_VERSION_2 = 2,
    RDPUDP_PROTOCOL_VERSION_3 = 257,
};
class RDPUDP_CORRELATION_ID_PAYLOAD;
class RDPUDP_SYNDATA_PAYLOAD;
class RDPEUDP_SYNACK;
// NOLINTNEXTLINE(performance-enum-size)
enum RDPUDP_FLAG {
    RDPUDP_FLAG_SYN = 1,
    RDPUDP_FLAG_FIN = 2,
    RDPUDP_FLAG_ACK = 4,
    RDPUDP_FLAG_DATA = 8,
    RDPUDP_FLAG_FEC = 16,
    RDPUDP_FLAG_CN = 32,
    RDPUDP_FLAG_CWR = 64,
    RDPUDP_FLAG_SACK_OPTION = 128,
    RDPUDP_FLAG_ACK_OF_ACKS = 256,
    RDPUDP_FLAG_SYNLOSSY = 512,
    RDPUDP_FLAG_ACKDELAYED = 1024,
    RDPUDP_FLAG_CORRELATION_ID = 2048,
    RDPUDP_FLAG_SYNEX = 4096,
};
class RDPEUDP_ACK;
class RDPEUDP1_ACK;
class RDPUDP_SOURCE_PAYLOAD_HEADER;
class RDPUDP_ACK_OF_ACKVECTOR_HEADER;
class RDPUDP_FEC_HEADER;
class RDPUDP_ACK_VECTOR_HEADER;
class RDPEUDP2_ACK;
class RDPUDP2_PACKET_HEADER;
// NOLINTNEXTLINE(performance-enum-size)
enum RDPUDP2_PACKET_HEADER_FLAGS {
    ACK = 1,
    DATA = 4,
    ACKVEC = 8,
    AOA = 16,
    OVERHEADSIZE = 64,
    DELAYACKINFO = 256,
};
class RDPUDP2_ACK_PAYLOAD;
class RDPUDP2_OVERSIZE_PAYLOAD;
class RDPUDP2_DATABODY_PAYLOAD;
class RDPUDP2_ACKVECTOR_PAYLOAD;
class RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp;
class RDPUDP2_DATAHEADER_PAYLOAD;
class RDPUDP2_ACKOFACKS_PAYLOAD;
class RDPUDP2_DELAYACKINFO_PAYLOAD;
class RDPEUDP_Flow;
} // namespace RDPEUDP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace RDPEUDP {

class ContextRDPEUDP final {
public:
    ContextRDPEUDP(RDPEUDP_Conn* connection, RDPEUDP_Flow* flow);
    ~ContextRDPEUDP();

    // Member access functions
    RDPEUDP_Conn* connection() const { return connection_; }
    RDPEUDP_Flow* flow() const { return flow_; }

protected:
    RDPEUDP_Conn* connection_;
    RDPEUDP_Flow* flow_;
};


class RDPEUDP_Conn final : public binpac::ConnectionAnalyzer {
public:
    RDPEUDP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~RDPEUDP_Conn() override;

    // Member access functions
    RDPEUDP_Flow* upflow() const { return upflow_; }
    RDPEUDP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    uint8 get_state();
    bool is_rdpeudp2();
    bool proc_rdpeudp_syn(bool is_orig, uint16 uFlags, uint32 snSourceAck, uint16 uUdpVer);
    bool proc_rdpeudp_synack(bool is_orig, uint16 uFlags, uint16 uUdpVer);
    bool proc_rdpeudp1_ack(bool is_orig, bytestring const& data);
    bool proc_rdpeudp2_ack(bool is_orig, uint8 pkt_type, bytestring const& data);

protected:

    // Additional members

		enum RDPEUDP_STATE : uint8_t {
			NEED_SYN	= 0x1,
			NEED_SYNACK	= 0x2,
			NED_ACK		= 0x3,
			ESTABLISHED	= 0x4,
		};
		enum RDPUDP_VERSION_INFO_FLAG : uint16_t {
			RDPUDP_PROTOCOL_VERSION_1 = 0x0001,
			RDPUDP_PROTOCOL_VERSION_2 = 0x0002,
			RDPUDP_PROTOCOL_VERSION_3 = 0x0101
		};
		uint8 state_ = NEED_SYN;
		uint16 orig_synex_flags_ = RDPUDP_PROTOCOL_VERSION_1;
		uint16 resp_synex_flags_ = RDPUDP_PROTOCOL_VERSION_1;
		bool orig_lossy_ = false;
		bool resp_lossy_ = false;
	
    RDPEUDP_Flow* upflow_;
    RDPEUDP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class RDPEUDP_PDU final {
public:
    RDPEUDP_PDU(bool is_orig);
    ~RDPEUDP_PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context);

    // Member access functions
    uint8 state_case_index() const	{ return state_case_index_; }
    RDPEUDP_SYN* need_syn() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( state_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:19:need_syn", (int64)state_case_index(), "NEED_SYN");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return need_syn_;
    }
    RDPEUDP_SYNACK* need_synack() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( state_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:20:need_synack", (int64)state_case_index(), "NEED_SYNACK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return need_synack_;
    }
    RDPEUDP_ACK* need_ack() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( state_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:21:need_ack", (int64)state_case_index(), "NEED_ACK");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return need_ack_;
    }
    RDPEUDP_ACK* established() const {
        return established_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    uint8 state_case_index_;
    RDPEUDP_SYN* need_syn_;
    RDPEUDP_SYNACK* need_synack_;
    RDPEUDP_ACK* need_ack_;
    RDPEUDP_ACK* established_;
    bool is_orig_;
    int byteorder_;
};


class RDPEUDP_SYN final {
public:
    RDPEUDP_SYN(RDPEUDP_PDU* pdu, bool is_orig);
    ~RDPEUDP_SYN();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder);

    // Member access functions
    RDPUDP_FEC_HEADER* fec_header() const { return fec_header_; }
    RDPUDP_SYNDATA_PAYLOAD* syndata_payload() const { return syndata_payload_; }
    int corr_id_payload_case_index() const	{ return corr_id_payload_case_index_; }
    RDPUDP_CORRELATION_ID_PAYLOAD* has_corr_id_payload() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( corr_id_payload_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:30:has_corr_id_payload", (int64)corr_id_payload_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return has_corr_id_payload_;
    }
    int synex_payload_case_index() const	{ return synex_payload_case_index_; }
    RDPUDP_SYNEX_PAYLOAD* has_synex_payload() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( synex_payload_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:34:has_synex_payload", (int64)synex_payload_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return has_synex_payload_;
    }
    RDPEUDP_PDU* pdu() const { return pdu_; }
    bool is_orig() const { return is_orig_; }
    bool proc_rdpeudp_syn() const { return proc_rdpeudp_syn_; }

protected:
    RDPUDP_FEC_HEADER* fec_header_;
    RDPUDP_SYNDATA_PAYLOAD* syndata_payload_;
    int corr_id_payload_case_index_;
    RDPUDP_CORRELATION_ID_PAYLOAD* has_corr_id_payload_;
    int synex_payload_case_index_;
    RDPUDP_SYNEX_PAYLOAD* has_synex_payload_;
    RDPEUDP_PDU* pdu_;
    bool is_orig_;
    bool proc_rdpeudp_syn_;
};


class RDPUDP_SYNEX_PAYLOAD final {
public:
    RDPUDP_SYNEX_PAYLOAD();
    ~RDPUDP_SYNEX_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 uSynExFlags() const { return uSynExFlags_; }
    uint16 uUdpVer() const { return uUdpVer_; }
    int cookieHash_case_index() const	{ return cookieHash_case_index_; }
    vector<uint8>* has_cookie_hash() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( cookieHash_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:47:has_cookie_hash", (int64)cookieHash_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return has_cookie_hash_;
    }

protected:
    uint16 uSynExFlags_;
    uint16 uUdpVer_;
    int cookieHash_case_index_;
    vector<uint8>* has_cookie_hash_;
    uint8 has_cookie_hash__elem_;
};


class RDPUDP_CORRELATION_ID_PAYLOAD final {
public:
    RDPUDP_CORRELATION_ID_PAYLOAD();
    ~RDPUDP_CORRELATION_ID_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    vector<uint8>* uCorrelationId() const { return uCorrelationId_; }
    vector<uint8>* uReserved() const { return uReserved_; }

protected:
    vector<uint8>* uCorrelationId_;
    uint8 uCorrelationId__elem_;
    vector<uint8>* uReserved_;
    uint8 uReserved__elem_;
};


class RDPUDP_SYNDATA_PAYLOAD final {
public:
    RDPUDP_SYNDATA_PAYLOAD();
    ~RDPUDP_SYNDATA_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 snInitialSequenceNumber() const { return snInitialSequenceNumber_; }
    uint16 uUpStreamMtu() const { return uUpStreamMtu_; }
    uint16 uDownStreamMtu() const { return uDownStreamMtu_; }

protected:
    uint32 snInitialSequenceNumber_;
    uint16 uUpStreamMtu_;
    uint16 uDownStreamMtu_;
};


class RDPEUDP_SYNACK final {
public:
    RDPEUDP_SYNACK(RDPEUDP_PDU* pdu, bool is_orig);
    ~RDPEUDP_SYNACK();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder);

    // Member access functions
    RDPUDP_FEC_HEADER* fec_header() const { return fec_header_; }
    RDPUDP_SYNDATA_PAYLOAD* syndata_payload() const { return syndata_payload_; }
    int corr_id_payload_case_index() const	{ return corr_id_payload_case_index_; }
    RDPUDP_CORRELATION_ID_PAYLOAD* has_corr_id_payload() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( corr_id_payload_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:73:has_corr_id_payload", (int64)corr_id_payload_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return has_corr_id_payload_;
    }
    int synex_payload_case_index() const	{ return synex_payload_case_index_; }
    RDPUDP_SYNEX_PAYLOAD* has_synex_payload() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( synex_payload_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:77:has_synex_payload", (int64)synex_payload_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return has_synex_payload_;
    }
    RDPEUDP_PDU* pdu() const { return pdu_; }
    bool is_orig() const { return is_orig_; }
    bool proc_rdpeudp_synack() const { return proc_rdpeudp_synack_; }

protected:
    RDPUDP_FEC_HEADER* fec_header_;
    RDPUDP_SYNDATA_PAYLOAD* syndata_payload_;
    int corr_id_payload_case_index_;
    RDPUDP_CORRELATION_ID_PAYLOAD* has_corr_id_payload_;
    int synex_payload_case_index_;
    RDPUDP_SYNEX_PAYLOAD* has_synex_payload_;
    RDPEUDP_PDU* pdu_;
    bool is_orig_;
    bool proc_rdpeudp_synack_;
};


class RDPEUDP_ACK final {
public:
    RDPEUDP_ACK(RDPEUDP_PDU* pdu, bool is_orig);
    ~RDPEUDP_ACK();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder);

    // Member access functions
    int version_case_index() const	{ return version_case_index_; }
    RDPEUDP2_ACK* version2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( version_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:102:version2", (int64)version_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return version2_;
    }
    RDPEUDP1_ACK* version1() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( version_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:103:version1", (int64)version_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return version1_;
    }
    RDPEUDP_PDU* pdu() const { return pdu_; }
    bool is_orig() const { return is_orig_; }

protected:
    int version_case_index_;
    RDPEUDP2_ACK* version2_;
    RDPEUDP1_ACK* version1_;
    RDPEUDP_PDU* pdu_;
    bool is_orig_;
};


class RDPEUDP1_ACK final {
public:
    RDPEUDP1_ACK(RDPEUDP_PDU* pdu, bool is_orig);
    ~RDPEUDP1_ACK();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder);

    // Member access functions
    RDPUDP_FEC_HEADER* fec_header() const { return fec_header_; }
    RDPUDP_ACK_VECTOR_HEADER* ack_vec_header() const { return ack_vec_header_; }
    int ack_of_ackvec_header_case_index() const	{ return ack_of_ackvec_header_case_index_; }
    RDPUDP_ACK_OF_ACKVECTOR_HEADER* some() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ack_of_ackvec_header_case_index() ) {
            case ((int)256):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:111:some", (int64)ack_of_ackvec_header_case_index(), "RDPUDP_FLAG_ACK_OF_ACKS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return some_;
    }
    int source_payload_header_case_index() const	{ return source_payload_header_case_index_; }
    RDPUDP_SOURCE_PAYLOAD_HEADER* some_source_payload() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( source_payload_header_case_index() ) {
            case ((int)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/rdp/rdpeudp-protocol.pac:116:some_source_payload", (int64)source_payload_header_case_index(), "RDPUDP_FLAG_DATA");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return some_source_payload_;
    }
    bytestring const& data() const { return data_; }
    RDPEUDP_PDU* pdu() const { return pdu_; }
    bool is_orig() const { return is_orig_; }
    bool proc_rdpeudp1_ack() const { return proc_rdpeudp1_ack_; }

protected:
    RDPUDP_FEC_HEADER* fec_header_;
    RDPUDP_ACK_VECTOR_HEADER* ack_vec_header_;
    int ack_of_ackvec_header_case_index_;
    RDPUDP_ACK_OF_ACKVECTOR_HEADER* some_;
    int source_payload_header_case_index_;
    RDPUDP_SOURCE_PAYLOAD_HEADER* some_source_payload_;
    bytestring data_;
    RDPEUDP_PDU* pdu_;
    bool is_orig_;
    bool proc_rdpeudp1_ack_;
};


class RDPUDP_SOURCE_PAYLOAD_HEADER final {
public:
    RDPUDP_SOURCE_PAYLOAD_HEADER();
    ~RDPUDP_SOURCE_PAYLOAD_HEADER();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 snCoded() const { return snCoded_; }
    uint32 snSourceStart() const { return snSourceStart_; }

protected:
    uint32 snCoded_;
    uint32 snSourceStart_;
};


class RDPUDP_ACK_OF_ACKVECTOR_HEADER final {
public:
    RDPUDP_ACK_OF_ACKVECTOR_HEADER();
    ~RDPUDP_ACK_OF_ACKVECTOR_HEADER();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 snAckOfAcksSeqNum() const { return snAckOfAcksSeqNum_; }

protected:
    uint32 snAckOfAcksSeqNum_;
};


class RDPUDP_FEC_HEADER final {
public:
    RDPUDP_FEC_HEADER();
    ~RDPUDP_FEC_HEADER();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 snSourceAck() const { return snSourceAck_; }
    uint16 uReceiveWindowSize() const { return uReceiveWindowSize_; }
    uint16 uFlags() const { return uFlags_; }

protected:
    uint32 snSourceAck_;
    uint16 uReceiveWindowSize_;
    uint16 uFlags_;
};


class RDPUDP_ACK_VECTOR_HEADER final {
public:
    RDPUDP_ACK_VECTOR_HEADER();
    ~RDPUDP_ACK_VECTOR_HEADER();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 uAckVectorSize() const { return uAckVectorSize_; }
    vector<uint8>* AckVectorElement() const { return AckVectorElement_; }

protected:
    uint16 uAckVectorSize_;
    vector<uint8>* AckVectorElement_;
    uint8 AckVectorElement__elem_;
};


class RDPEUDP2_ACK final {
public:
    RDPEUDP2_ACK(RDPEUDP_PDU* pdu, bool is_orig);
    ~RDPEUDP2_ACK();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRDPEUDP* t_context, int t_byteorder);

    // Member access functions
    uint8 PacketPrefixByte() const { return PacketPrefixByte_; }
    RDPUDP2_PACKET_HEADER* header() const { return header_; }
    bytestring const& data() const { return data_; }
    RDPEUDP_PDU* pdu() const { return pdu_; }
    bool is_orig() const { return is_orig_; }
    uint8 Reserved() const { return Reserved_; }
    uint8 Packet_Type_Index() const { return Packet_Type_Index_; }
    uint8 Short_Packet_Length() const { return Short_Packet_Length_; }
    bool proc_rdpeudp2_ack() const { return proc_rdpeudp2_ack_; }

protected:
    uint8 PacketPrefixByte_;
    RDPUDP2_PACKET_HEADER* header_;
    bytestring data_;
    RDPEUDP_PDU* pdu_;
    bool is_orig_;
    uint8 Reserved_;
    uint8 Packet_Type_Index_;
    uint8 Short_Packet_Length_;
    bool proc_rdpeudp2_ack_;
};


class RDPUDP2_PACKET_HEADER final {
public:
    RDPUDP2_PACKET_HEADER();
    ~RDPUDP2_PACKET_HEADER();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 everything() const { return everything_; }
    uint16 Flags() const { return Flags_; }
    uint8 LogWindowSize() const { return LogWindowSize_; }

protected:
    uint16 everything_;
    uint16 Flags_;
    uint8 LogWindowSize_;
};


class RDPUDP2_ACK_PAYLOAD final {
public:
    RDPUDP2_ACK_PAYLOAD();
    ~RDPUDP2_ACK_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 SeqNum() const { return SeqNum_; }
    uint32 tmp1() const { return tmp1_; }
    uint8 tmp2() const { return tmp2_; }
    vector<uint8>* delayAckTimeAdditions() const { return delayAckTimeAdditions_; }
    uint8 receivedTS() const { return receivedTS_; }
    uint8 sendAckTimeGap() const { return sendAckTimeGap_; }
    uint8 numDelayedAcks() const { return numDelayedAcks_; }
    uint8 delayAckTimeScale() const { return delayAckTimeScale_; }

protected:
    uint16 SeqNum_;
    uint32 tmp1_;
    uint8 tmp2_;
    vector<uint8>* delayAckTimeAdditions_;
    uint8 delayAckTimeAdditions__elem_;
    uint8 receivedTS_;
    uint8 sendAckTimeGap_;
    uint8 numDelayedAcks_;
    uint8 delayAckTimeScale_;
};


class RDPUDP2_OVERSIZE_PAYLOAD final {
public:
    RDPUDP2_OVERSIZE_PAYLOAD();
    ~RDPUDP2_OVERSIZE_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 OverheadSize() const { return OverheadSize_; }

protected:
    uint8 OverheadSize_;
};


class RDPUDP2_DATABODY_PAYLOAD final {
public:
    RDPUDP2_DATABODY_PAYLOAD();
    ~RDPUDP2_DATABODY_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 ChannelSeqNum() const { return ChannelSeqNum_; }
    bytestring const& Data() const { return Data_; }

protected:
    uint16 ChannelSeqNum_;
    bytestring Data_;
};


class RDPUDP2_ACKVECTOR_PAYLOAD final {
public:
    RDPUDP2_ACKVECTOR_PAYLOAD();
    ~RDPUDP2_ACKVECTOR_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 BaseSeqNum() const { return BaseSeqNum_; }
    uint8 tmp1() const { return tmp1_; }
    uint8 TimeStamp_or_not_case_index() const	{ return TimeStamp_or_not_case_index_; }
    RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp* some() const {
        return some_;
    }
    vector<uint8>* codedAckVector() const { return codedAckVector_; }
    uint8 codedAckVecSize() const { return codedAckVecSize_; }
    uint8 TimeStampPresent() const { return TimeStampPresent_; }

protected:
    uint16 BaseSeqNum_;
    uint8 tmp1_;
    uint8 TimeStamp_or_not_case_index_;
    RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp* some_;
    vector<uint8>* codedAckVector_;
    uint8 codedAckVector__elem_;
    uint8 codedAckVecSize_;
    uint8 TimeStampPresent_;
};


class RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp final {
public:
    RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp();
    ~RDPUDP2_ACKVECTOR_PAYLOAD_TimeStamp();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 tmp1() const { return tmp1_; }
    uint8 tmp2() const { return tmp2_; }
    uint8 tmp3() const { return tmp3_; }
    uint32 TimeStamp() const { return TimeStamp_; }

protected:
    uint8 tmp1_;
    uint8 tmp2_;
    uint8 tmp3_;
    uint32 TimeStamp_;
};


class RDPUDP2_DATAHEADER_PAYLOAD final {
public:
    RDPUDP2_DATAHEADER_PAYLOAD();
    ~RDPUDP2_DATAHEADER_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 DataSeqNum() const { return DataSeqNum_; }

protected:
    uint16 DataSeqNum_;
};


class RDPUDP2_ACKOFACKS_PAYLOAD final {
public:
    RDPUDP2_ACKOFACKS_PAYLOAD();
    ~RDPUDP2_ACKOFACKS_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 AckOfAcksSeqNum() const { return AckOfAcksSeqNum_; }

protected:
    uint16 AckOfAcksSeqNum_;
};


class RDPUDP2_DELAYACKINFO_PAYLOAD final {
public:
    RDPUDP2_DELAYACKINFO_PAYLOAD();
    ~RDPUDP2_DELAYACKINFO_PAYLOAD();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 MaxDelayedAcks() const { return MaxDelayedAcks_; }
    uint16 DelayedAckTimeoutInMs() const { return DelayedAckTimeoutInMs_; }

protected:
    uint8 MaxDelayedAcks_;
    uint16 DelayedAckTimeoutInMs_;
};


class RDPEUDP_Flow final : public binpac::FlowAnalyzer {
public:
    RDPEUDP_Flow(RDPEUDP_Conn* connection, bool is_orig);
    ~RDPEUDP_Flow() override;

    // Member access functions
    RDPEUDP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    RDPEUDP_PDU* dataunit_;
    ContextRDPEUDP* context_;
    RDPEUDP_Conn* connection_;
    bool is_orig_;
};

} // namespace RDPEUDP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_rdp_rdpeudp_pac_h */
