// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/rfb/rfb_pac.h"

namespace binpac {






namespace RFB {
ContextRFB::ContextRFB(RFB_Conn* connection, RFB_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextRFB::~ContextRFB() {
}

RFB_Conn::RFB_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new RFB_Flow(this, true);
    downflow_ = new RFB_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;
}

RFB_Conn::~RFB_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void RFB_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void RFB_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void RFB_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool RFB_Conn::saw_handshake() {

		return saw_full_handshake;
		
}

uint16 RFB_Conn::get_ard_key_length() {

		return ard_key_length;
		
}

int RFB_Conn::get_state(bool client) {

		return client ? client_state : server_state;
		
}

uint8 RFB_Conn::get_next_msg_type(bool client) {

		return client ? next_client_msg : next_server_msg;
		
}

uint8 RFB_Conn::get_bytes_per_pixel() {

		return bytes_per_pixel;
		
}

bool RFB_Conn::handle_banners(bool client, RFBProtocolVersion* msg) {

		if ( client )
			{
			// Set protocol version on client's version
			int minor_version = bytestring_to_int(msg->minor_ver(),10);
			version = minor_version;

			// Apple specifies minor version "889" but talks v37
			if ( minor_version >= 7 )
				{
				server_state = SERVER_AUTH_TYPE37;
				client_state = CLIENT_AUTH_SELECTION;
				}
			else
				{
				server_state = SERVER_AUTH_TYPE;
				client_state = CLIENT_WAIT;
				}

			}
		else
			server_state = SERVER_WAIT;

		return true;
		
}

bool RFB_Conn::handle_security_type(RFBSecurityType* msg) {

		if ( msg->sectype() == 0 )
			{
			// Invalid / failure.
			server_state = SERVER_AUTH_FAILURE;
			client_state = CLIENT_INIT;
			}
		else if ( msg->sectype() == 1 )
			{
			// No auth.
			server_state = SERVER_INIT;
			client_state = CLIENT_INIT;
			}
		else if ( msg->sectype() == 2 )
			{
			// VNC auth.
			server_state = SERVER_AUTH_VNC_CHALLENGE;
			client_state = CLIENT_AUTH_VNC_RESPONSE;
			}
		else
			{
			// Shouldn't be a possible.
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid RFB security type %u", msg->sectype()));
			}

		return true;
		
}

bool RFB_Conn::handle_fail_reason_string(RFBFailReasonString* msg) {

		// Connection failed, server should close, but maybe see if it
		// proceeds anyway.
		server_state = SERVER_INIT;
		return true;
		
}

bool RFB_Conn::handle_security_types37(RFBSecurityTypes37* msg) {

		if ( msg->count() == 0 )
			{
			server_state = SERVER_AUTH_FAILURE;
			}
		else
			{
			server_state = SERVER_WAIT;
			}

		return true;
		
}

bool RFB_Conn::handle_auth_type_selected(RFBAuthTypeSelected* msg) {

		if ( msg->type() == 1 )
			{
			if ( version > 7 )
				server_state = SERVER_AUTH_RESULT;
			else
				server_state = SERVER_INIT;

			client_state = CLIENT_INIT;
			}
		else if ( msg->type() == 2 )
			{
			server_state = SERVER_AUTH_VNC_CHALLENGE;
			client_state = CLIENT_AUTH_VNC_RESPONSE;
			}
		else if ( msg->type() == 30 )
			{
			// Apple Remote Desktop
			server_state = SERVER_AUTH_ARD_CHALLENGE;
			//client_state = CLIENT_AUTH_ARD_RESPONSE;
			// need to wait for the key length to be set by server
			client_state = CLIENT_WAIT;
			}
		else
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unknown RFB auth selection: %u", msg->type()));
			}

		return true;
		
}

bool RFB_Conn::handle_ard_challenge(RFBSecurityARDChallenge* msg) {

		ard_key_length = msg->key_length();
		server_state = SERVER_AUTH_RESULT;
		client_state = CLIENT_AUTH_ARD_RESPONSE;
		return true;
		
}

bool RFB_Conn::handle_ard_response() {

		client_state = CLIENT_INIT;
		return true;
		
}

bool RFB_Conn::handle_auth_request() {

		server_state = SERVER_AUTH_RESULT;
		client_state = CLIENT_AUTH_VNC_RESPONSE;
		return true;
		
}

bool RFB_Conn::handle_auth_response() {

		client_state = CLIENT_INIT;
		return true;
		
}

bool RFB_Conn::handle_security_result(RFBSecurityResult* msg) {

		if ( msg->result() == 0 )
			// OK
			server_state = SERVER_INIT;
		else if ( msg->result() == 1 )
			// Failed
			server_state = SERVER_AUTH_FAILURE;
		else
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid RFB auth result: %u", msg->result()));

		return true;
		
}

bool RFB_Conn::handle_client_init(RFBClientInit* msg) {

		client_state = CLIENT_MESSAGE_TYPE;
		return true;
		
}

bool RFB_Conn::handle_server_init(RFBServerInit* msg) {

		auto bits_per_pixel = (*msg->pixel_format())[0];
		bytes_per_pixel = bits_per_pixel / 8;
		server_state = SERVER_MESSAGE_TYPE;
		saw_full_handshake = true;
		return true;
		
}

bool RFB_Conn::handle_wait_data(bool client) {

		if ( client )
			client_state = CLIENT_INVALID;
		else
			server_state = SERVER_INVALID;

		return true;
		
}

bool RFB_Conn::handle_invalid_data(bool client) {

		throw binpac::Exception(zeek::util::fmt("invalid data from RFB %s", client ? "client" : "server"));
		return true;
		
}

bool RFB_Conn::handle_client_message_type(uint8 type) {

		next_client_msg = type;
		client_state = CLIENT_MESSAGE;
		return true;
		
}

bool RFB_Conn::handle_client_message(uint8 type) {

		client_state = CLIENT_MESSAGE_TYPE;
		return true;
		
}

bool RFB_Conn::handle_server_message_type(uint8 type) {

		next_server_msg = type;
		server_state = SERVER_MESSAGE;
		return true;
		
}

bool RFB_Conn::handle_server_message(uint8 type) {

		server_state = SERVER_MESSAGE_TYPE;
		return true;
		
}

bool RFB_Conn::handle_client_set_pixel_format(ClientSetPixelFormat* msg) {

		auto bits_per_pixel = (*msg->pixel_format())[0];
		bytes_per_pixel = bits_per_pixel / 8;
		return true;
		
}

bool RFB_Conn::handle_client_set_encodings(ClientSetEncodings* msg) {

		return true;
		
}

bool RFB_Conn::handle_client_framebuffer_update_request(ClientFramebufferUpdateRequest* msg) {

		return true;
		
}

bool RFB_Conn::handle_client_key_event(ClientKeyEvent* msg) {

		return true;
		
}

bool RFB_Conn::handle_client_pointer_event(ClientPointerEvent* msg) {

		return true;
		
}

bool RFB_Conn::handle_client_cut_text(ClientCutText* msg) {

		return true;
		
}

uint32 const MAX_DATA_LENGTH = 65536;
RFBProtocolVersion::RFBProtocolVersion(bool client) {
    pad_ = 0;
    client_ = client;
    proc_ = false;
    proc2_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBProtocolVersion::~RFBProtocolVersion() {
    header_.free();
    major_ver_.free();
    dot_.free();
    minor_ver_.free();
}

bool RFBProtocolVersion::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(12);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "RFBProtocolVersion:header"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBProtocolVersion:header",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "header"
                if ( memcmp(t_begin_of_data, "RFB ", 4) != 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:34", "RFB ", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                // check for negative sizes
                if ( 4 < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:34", 4);
                header_.init(t_begin_of_data, 4);

                // Parse "major_ver"
                // Checking out-of-bound for "RFBProtocolVersion:major_ver"
                if ( (t_begin_of_data + 4) + (3) > t_end_of_data || (t_begin_of_data + 4) + (3) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBProtocolVersion:major_ver",
                    	(4) + (3), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + 3;
                    int t_major_ver_string_length;
                    t_major_ver_string_length = 3;
                    int t_major_ver__size;
                    t_major_ver__size = t_major_ver_string_length;
                    major_ver_.init((t_begin_of_data + 4), t_major_ver_string_length);
                }

                const_byteptr const t_dataptr_after_major_ver = (t_begin_of_data + 4) + (3);
                BINPAC_ASSERT(t_dataptr_after_major_ver <= t_end_of_data);
                // Checking out-of-bound for "RFBProtocolVersion:dot"
                if ( t_dataptr_after_major_ver + (1) > t_end_of_data || t_dataptr_after_major_ver + (1) < t_dataptr_after_major_ver ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBProtocolVersion:dot",
                    	((t_dataptr_after_major_ver - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "dot"
                if ( memcmp(t_dataptr_after_major_ver, ".", 1) != 0 ) {
                    throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:36", ".", string(reinterpret_cast<const char*>(t_dataptr_after_major_ver), reinterpret_cast<const char*>(t_end_of_data)).c_str());
                }
                // check for negative sizes
                if ( 1 < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:36", 1);
                dot_.init(t_dataptr_after_major_ver, 1);

                // Parse "minor_ver"
                // Checking out-of-bound for "RFBProtocolVersion:minor_ver"
                if ( (t_dataptr_after_major_ver + 1) + (3) > t_end_of_data || (t_dataptr_after_major_ver + 1) + (3) < (t_dataptr_after_major_ver + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBProtocolVersion:minor_ver",
                    	(((t_dataptr_after_major_ver + 1) - t_begin_of_data)) + (3), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_dataptr_after_major_ver + 1) + 3;
                    int t_minor_ver_string_length;
                    t_minor_ver_string_length = 3;
                    int t_minor_ver__size;
                    t_minor_ver__size = t_minor_ver_string_length;
                    minor_ver_.init((t_dataptr_after_major_ver + 1), t_minor_ver_string_length);
                }

                const_byteptr const t_dataptr_after_minor_ver = (t_dataptr_after_major_ver + 1) + (3);
                BINPAC_ASSERT(t_dataptr_after_minor_ver <= t_end_of_data);
                // Checking out-of-bound for "RFBProtocolVersion:pad"
                if ( t_dataptr_after_minor_ver + (1) > t_end_of_data || t_dataptr_after_minor_ver + (1) < t_dataptr_after_minor_ver ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBProtocolVersion:pad",
                    	((t_dataptr_after_minor_ver - t_begin_of_data)) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "pad"
                pad_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_minor_ver));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_banners(client(), this);
                    proc2_ = t_context->flow()->proc_rfb_version(client(), major_ver(), minor_ver());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBFailReasonString::RFBFailReasonString() {
    len_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBFailReasonString::~RFBFailReasonString() {
    str_.free();
}

bool RFBFailReasonString::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "len"
            // Checking out-of-bound for "RFBFailReasonString:len"
            if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("RFBFailReasonString:len",
                	(0) + (4), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
            // Evaluate '&enforce' attribute
            if (! ( len() < MAX_DATA_LENGTH ) ) {
                throw binpac::ExceptionEnforceViolation("RFBFailReasonString:len");
            }
            t_flow_buffer->GrowFrame( ( 4 + len() ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "str"
                int t_str__size;
                t_str__size = len();
                // Checking out-of-bound for "RFBFailReasonString:str"
                if ( (t_begin_of_data + 4) + (t_str__size) > t_end_of_data || (t_begin_of_data + 4) + (t_str__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBFailReasonString:str",
                    	(4) + (t_str__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_str__size;
                    int t_str_string_length;
                    t_str_string_length = len();
                    // check for negative sizes
                    if ( t_str_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:46", t_str_string_length);
                    str_.init((t_begin_of_data + 4), t_str_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_fail_reason_string(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBSecurityType::RFBSecurityType() {
    sectype_ = 0;
    proc_ = false;
    proc2_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBSecurityType::~RFBSecurityType() {
}

bool RFBSecurityType::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(4);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "RFBSecurityType:sectype"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityType:sectype",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "sectype"
                sectype_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_security_type(this);
                    proc2_ = t_context->flow()->proc_security_types(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBSecurityTypes37::RFBSecurityTypes37() {
    count_ = 0;
    types_ = nullptr;
    types__elem_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBSecurityTypes37::~RFBSecurityTypes37() {
    delete types_;
}

bool RFBSecurityTypes37::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(1, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "count"
            // Checking out-of-bound for "RFBSecurityTypes37:count"
            if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("RFBSecurityTypes37:count",
                	(0) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
            t_flow_buffer->GrowFrame( ( count() + 1 ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "types"
                int t_types__arraylength;
                t_types__arraylength = count();
                if ( t_types__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("RFBSecurityTypes37:types",
                      t_types__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: RFBSecurityTypes37:types
                if ( t_types__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 1) )
                    throw binpac::ExceptionOutOfBound("RFBSecurityTypes37:types",
                      t_types__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
                types__elem_ = 0;
                int t_types__elem__it;
                t_types__elem__it = 0;
                int t_types__size;
                types_ = new vector<uint8>;
                types_->reserve(t_types__arraylength);
                const_byteptr t_types__elem__dataptr = (t_begin_of_data + 1);
                for (; t_types__elem__it < t_types__arraylength; ++t_types__elem__it) {
                    types__elem_ = *(reinterpret_cast<uint8 const*>(t_types__elem__dataptr));
                    types_->push_back(types__elem_);
                    t_types__elem__dataptr += 1;
                    BINPAC_ASSERT(t_types__elem__dataptr <= t_end_of_data);
                }
            end_of_types: ;
                t_types__size = t_types__elem__dataptr - ((t_begin_of_data + 1));
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_security_types37(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBAuthTypeSelected::RFBAuthTypeSelected() {
    type_ = 0;
    proc_ = false;
    proc2_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBAuthTypeSelected::~RFBAuthTypeSelected() {
}

bool RFBAuthTypeSelected::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "RFBAuthTypeSelected:type"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBAuthTypeSelected:type",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "type"
                type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_auth_type_selected(this);
                    proc2_ = t_context->flow()->proc_security_types37(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBSecurityResult::RFBSecurityResult() {
    result_ = 0;
    proc_ = false;
    proc2_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBSecurityResult::~RFBSecurityResult() {
}

bool RFBSecurityResult::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(4);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "RFBSecurityResult:result"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityResult:result",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "result"
                result_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_security_result(this);
                    proc2_ = t_context->flow()->proc_handle_security_result(result());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBVNCAuthenticationRequest::RFBVNCAuthenticationRequest() {
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBVNCAuthenticationRequest::~RFBVNCAuthenticationRequest() {
    challenge_.free();
}

bool RFBVNCAuthenticationRequest::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(16);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "challenge"
                // Checking out-of-bound for "RFBVNCAuthenticationRequest:challenge"
                if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBVNCAuthenticationRequest:challenge",
                    	(0) + (16), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 16;
                    int t_challenge_string_length;
                    t_challenge_string_length = 16;
                    int t_challenge__size;
                    t_challenge__size = t_challenge_string_length;
                    challenge_.init(t_begin_of_data, t_challenge_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_auth_request();
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBVNCAuthenticationResponse::RFBVNCAuthenticationResponse() {
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBVNCAuthenticationResponse::~RFBVNCAuthenticationResponse() {
    response_.free();
}

bool RFBVNCAuthenticationResponse::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(16);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "response"
                // Checking out-of-bound for "RFBVNCAuthenticationResponse:response"
                if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBVNCAuthenticationResponse:response",
                    	(0) + (16), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 16;
                    int t_response_string_length;
                    t_response_string_length = 16;
                    int t_response__size;
                    t_response__size = t_response_string_length;
                    response_.init(t_begin_of_data, t_response_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_auth_response();
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBSecurityARDChallenge::RFBSecurityARDChallenge() {
    generator_ = 0;
    key_length_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBSecurityARDChallenge::~RFBSecurityARDChallenge() {
    prime_mod_.free();
    publickey_.free();
}

bool RFBSecurityARDChallenge::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "key_length"
            // Checking out-of-bound for "RFBSecurityARDChallenge:key_length"
            if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("RFBSecurityARDChallenge:key_length",
                	(2) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            key_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
            t_flow_buffer->GrowFrame( ( 4 +  ( 2 * key_length() )  ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "generator"
                // Checking out-of-bound for "RFBSecurityARDChallenge:generator"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityARDChallenge:generator",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                generator_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));


                // Parse "prime_mod"
                int t_prime_mod__size;
                t_prime_mod__size = key_length();
                // Checking out-of-bound for "RFBSecurityARDChallenge:prime_mod"
                if ( (t_begin_of_data + 4) + (t_prime_mod__size) > t_end_of_data || (t_begin_of_data + 4) + (t_prime_mod__size) < (t_begin_of_data + 4) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityARDChallenge:prime_mod",
                    	(4) + (t_prime_mod__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_prime_mod__size;
                    int t_prime_mod_string_length;
                    t_prime_mod_string_length = key_length();
                    // check for negative sizes
                    if ( t_prime_mod_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:95", t_prime_mod_string_length);
                    prime_mod_.init((t_begin_of_data + 4), t_prime_mod_string_length);
                }

                const_byteptr const t_dataptr_after_prime_mod = (t_begin_of_data + 4) + (t_prime_mod__size);
                BINPAC_ASSERT(t_dataptr_after_prime_mod <= t_end_of_data);
                // Parse "publickey"
                int t_publickey__size;
                t_publickey__size = key_length();
                // Checking out-of-bound for "RFBSecurityARDChallenge:publickey"
                if ( t_dataptr_after_prime_mod + (t_publickey__size) > t_end_of_data || t_dataptr_after_prime_mod + (t_publickey__size) < t_dataptr_after_prime_mod ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityARDChallenge:publickey",
                    	((t_dataptr_after_prime_mod - t_begin_of_data)) + (t_publickey__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_prime_mod + t_publickey__size;
                    int t_publickey_string_length;
                    t_publickey_string_length = key_length();
                    // check for negative sizes
                    if ( t_publickey_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:96", t_publickey_string_length);
                    publickey_.init(t_dataptr_after_prime_mod, t_publickey_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_ard_challenge(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBSecurityARDResponse::RFBSecurityARDResponse() {
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBSecurityARDResponse::~RFBSecurityARDResponse() {
    publickey_.free();
    creds_.free();
}

bool RFBSecurityARDResponse::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame( ( 2 * t_context->connection()->get_ard_key_length() ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "publickey"
                int t_publickey__size;
                t_publickey__size = t_context->connection()->get_ard_key_length();
                // Checking out-of-bound for "RFBSecurityARDResponse:publickey"
                if ( t_begin_of_data + (t_publickey__size) > t_end_of_data || t_begin_of_data + (t_publickey__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityARDResponse:publickey",
                    	(0) + (t_publickey__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_publickey__size;
                    int t_publickey_string_length;
                    t_publickey_string_length = t_context->connection()->get_ard_key_length();
                    // check for negative sizes
                    if ( t_publickey_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:102", t_publickey_string_length);
                    publickey_.init(t_begin_of_data, t_publickey_string_length);
                }

                const_byteptr const t_dataptr_after_publickey = t_begin_of_data + (t_publickey__size);
                BINPAC_ASSERT(t_dataptr_after_publickey <= t_end_of_data);
                // Parse "creds"
                int t_creds__size;
                t_creds__size = t_context->connection()->get_ard_key_length();
                // Checking out-of-bound for "RFBSecurityARDResponse:creds"
                if ( t_dataptr_after_publickey + (t_creds__size) > t_end_of_data || t_dataptr_after_publickey + (t_creds__size) < t_dataptr_after_publickey ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBSecurityARDResponse:creds",
                    	((t_dataptr_after_publickey - t_begin_of_data)) + (t_creds__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_publickey + t_creds__size;
                    int t_creds_string_length;
                    t_creds_string_length = t_context->connection()->get_ard_key_length();
                    // check for negative sizes
                    if ( t_creds_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:103", t_creds_string_length);
                    creds_.init(t_dataptr_after_publickey, t_creds_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_ard_response();
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBClientInit::RFBClientInit() {
    shared_flag_ = 0;
    proc_ = false;
    proc2_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBClientInit::~RFBClientInit() {
}

bool RFBClientInit::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "RFBClientInit:shared_flag"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBClientInit:shared_flag",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "shared_flag"
                shared_flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_init(this);
                    proc2_ = t_context->flow()->proc_rfb_share_flag(shared_flag());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFBServerInit::RFBServerInit() {
    width_ = 0;
    height_ = 0;
    pixel_format_ = nullptr;
    pixel_format__elem_ = 0;
    len_ = 0;
    name_ = nullptr;
    name__elem_ = 0;
    proc_ = false;
    proc2_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

RFBServerInit::~RFBServerInit() {
    delete pixel_format_;
    delete name_;
}

bool RFBServerInit::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(24, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "len"
            // Checking out-of-bound for "RFBServerInit:len"
            if ( (t_begin_of_data + 20) + (4) > t_end_of_data || (t_begin_of_data + 20) + (4) < (t_begin_of_data + 20) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("RFBServerInit:len",
                	(20) + (4), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 20))));
            // Evaluate '&enforce' attribute
            if (! ( len() < MAX_DATA_LENGTH ) ) {
                throw binpac::ExceptionEnforceViolation("RFBServerInit:len");
            }
            t_flow_buffer->GrowFrame(24 + len());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "width"
                // Checking out-of-bound for "RFBServerInit:width"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBServerInit:width",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                width_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

                // Parse "height"
                // Checking out-of-bound for "RFBServerInit:height"
                if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("RFBServerInit:height",
                    	(2) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                height_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

                // Parse "pixel_format"
                int t_pixel_format__arraylength;
                t_pixel_format__arraylength = 16;
                if ( t_pixel_format__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("RFBServerInit:pixel_format",
                      t_pixel_format__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: RFBServerInit:pixel_format
                if ( t_pixel_format__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 1) )
                    throw binpac::ExceptionOutOfBound("RFBServerInit:pixel_format",
                      t_pixel_format__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
                pixel_format__elem_ = 0;
                int t_pixel_format__elem__it;
                t_pixel_format__elem__it = 0;
                pixel_format_ = new vector<uint8>;
                pixel_format_->reserve(t_pixel_format__arraylength);
                const_byteptr t_pixel_format__elem__dataptr = (t_begin_of_data + 4);
                for (; t_pixel_format__elem__it < t_pixel_format__arraylength; ++t_pixel_format__elem__it) {
                    pixel_format__elem_ = *(reinterpret_cast<uint8 const*>(t_pixel_format__elem__dataptr));
                    pixel_format_->push_back(pixel_format__elem_);
                    t_pixel_format__elem__dataptr += 1;
                    BINPAC_ASSERT(t_pixel_format__elem__dataptr <= t_end_of_data);
                }
            end_of_pixel_format: ;
                // Evaluate 'let' and 'withinput' fields


                // Parse "name"
                int t_name__arraylength;
                t_name__arraylength = len();
                if ( t_name__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("RFBServerInit:name",
                      t_name__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: RFBServerInit:name
                if ( t_name__arraylength > ((t_end_of_data - (t_begin_of_data + 24)) / 1) )
                    throw binpac::ExceptionOutOfBound("RFBServerInit:name",
                      t_name__arraylength, (t_end_of_data) - ((t_begin_of_data + 24)));
                name__elem_ = 0;
                int t_name__elem__it;
                t_name__elem__it = 0;
                int t_name__size;
                name_ = new vector<uint8>;
                name_->reserve(t_name__arraylength);
                const_byteptr t_name__elem__dataptr = (t_begin_of_data + 24);
                for (; t_name__elem__it < t_name__arraylength; ++t_name__elem__it) {
                    name__elem_ = *(reinterpret_cast<uint8 const*>(t_name__elem__dataptr));
                    name_->push_back(name__elem_);
                    t_name__elem__dataptr += 1;
                    BINPAC_ASSERT(t_name__elem__dataptr <= t_end_of_data);
                }
            end_of_name: ;
                t_name__size = t_name__elem__dataptr - ((t_begin_of_data + 24));
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_server_init(this);
                    proc2_ = t_context->flow()->proc_handle_server_params(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

InvalidData::InvalidData(bool orig) {
    invalid_ = 0;
    orig_ = orig;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

InvalidData::~InvalidData() {
}

bool InvalidData::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "InvalidData:invalid"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("InvalidData:invalid",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "invalid"
                invalid_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_invalid_data(orig());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

WaitData::WaitData(bool orig) {
    orig_ = orig;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

WaitData::~WaitData() {
    nothing_.free();
}

bool WaitData::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(0);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "nothing"
                // Checking out-of-bound for "WaitData:nothing"
                if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("WaitData:nothing",
                    	(0) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 0;
                    int t_nothing_string_length;
                    t_nothing_string_length = 0;
                    int t_nothing__size;
                    t_nothing__size = t_nothing_string_length;
                    nothing_.init(t_begin_of_data, t_nothing_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_wait_data(orig());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientMessageType::ClientMessageType() {
    type_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientMessageType::~ClientMessageType() {
}

bool ClientMessageType::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ClientMessageType:type"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientMessageType:type",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "type"
                type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_message_type(type());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientMessage::ClientMessage(uint8 type) {
    val_case_index_ = -1;
    set_pixel_format_ = nullptr;
    set_encodings_ = nullptr;
    framebuffer_update_request_ = nullptr;
    key_event_ = nullptr;
    pointer_event_ = nullptr;
    cut_text_ = nullptr;
    type_ = type;
    proc_ = false;
}

ClientMessage::~ClientMessage() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "set_pixel_format"
            {
                delete set_pixel_format_;
                set_pixel_format_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "set_encodings"
            {
                delete set_encodings_;
                set_encodings_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "framebuffer_update_request"
            {
                delete framebuffer_update_request_;
                framebuffer_update_request_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "key_event"
            {
                delete key_event_;
                key_event_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "pointer_event"
            {
                delete pointer_event_;
                pointer_event_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "cut_text"
            {
                delete cut_text_;
                cut_text_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool ClientMessage::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "set_pixel_format"
            {
                if ( ! set_pixel_format_ ) {
                    set_pixel_format_ = new ClientSetPixelFormat();
                }
                bool t_set_pixel_format_parsing_complete;
                t_set_pixel_format_parsing_complete = false;
                while ( ! t_set_pixel_format_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_set_pixel_format_parsing_complete = set_pixel_format_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_set_pixel_format_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_set_pixel_format_parsing_complete;
            }
            break;
        case ((uint8)2):
            // Parse "set_encodings"
            {
                if ( ! set_encodings_ ) {
                    set_encodings_ = new ClientSetEncodings();
                }
                bool t_set_encodings_parsing_complete;
                t_set_encodings_parsing_complete = false;
                while ( ! t_set_encodings_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_set_encodings_parsing_complete = set_encodings_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_set_encodings_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_set_encodings_parsing_complete;
            }
            break;
        case ((uint8)3):
            // Parse "framebuffer_update_request"
            {
                if ( ! framebuffer_update_request_ ) {
                    framebuffer_update_request_ = new ClientFramebufferUpdateRequest();
                }
                bool t_framebuffer_update_request_parsing_complete;
                t_framebuffer_update_request_parsing_complete = false;
                while ( ! t_framebuffer_update_request_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_framebuffer_update_request_parsing_complete = framebuffer_update_request_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_framebuffer_update_request_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_framebuffer_update_request_parsing_complete;
            }
            break;
        case ((uint8)4):
            // Parse "key_event"
            {
                if ( ! key_event_ ) {
                    key_event_ = new ClientKeyEvent();
                }
                bool t_key_event_parsing_complete;
                t_key_event_parsing_complete = false;
                while ( ! t_key_event_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_key_event_parsing_complete = key_event_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_key_event_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_key_event_parsing_complete;
            }
            break;
        case ((uint8)5):
            // Parse "pointer_event"
            {
                if ( ! pointer_event_ ) {
                    pointer_event_ = new ClientPointerEvent();
                }
                bool t_pointer_event_parsing_complete;
                t_pointer_event_parsing_complete = false;
                while ( ! t_pointer_event_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_pointer_event_parsing_complete = pointer_event_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_pointer_event_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_pointer_event_parsing_complete;
            }
            break;
        case ((uint8)6):
            // Parse "cut_text"
            {
                if ( ! cut_text_ ) {
                    cut_text_ = new ClientCutText();
                }
                bool t_cut_text_parsing_complete;
                t_cut_text_parsing_complete = false;
                while ( ! t_cut_text_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_cut_text_parsing_complete = cut_text_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_cut_text_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_cut_text_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ClientMessage", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->handle_client_message(type());
    }
    return t_val_parsing_complete;
}

ClientSetPixelFormat::ClientSetPixelFormat() {
    pad_ = nullptr;
    pad__elem_ = 0;
    pixel_format_ = nullptr;
    pixel_format__elem_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientSetPixelFormat::~ClientSetPixelFormat() {
    delete pad_;
    delete pixel_format_;
}

bool ClientSetPixelFormat::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(19);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ClientSetPixelFormat:pixel_format"
                if ( (t_begin_of_data + 3) + (16) > t_end_of_data || (t_begin_of_data + 3) + (16) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientSetPixelFormat:pixel_format",
                    	(3) + (16), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "pad"
                int t_pad__arraylength;
                t_pad__arraylength = 3;
                if ( t_pad__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ClientSetPixelFormat:pad",
                      t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ClientSetPixelFormat:pad
                if ( t_pad__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
                    throw binpac::ExceptionOutOfBound("ClientSetPixelFormat:pad",
                      t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
                pad__elem_ = 0;
                int t_pad__elem__it;
                t_pad__elem__it = 0;
                pad_ = new vector<uint8>;
                pad_->reserve(t_pad__arraylength);
                const_byteptr t_pad__elem__dataptr = t_begin_of_data;
                for (; t_pad__elem__it < t_pad__arraylength; ++t_pad__elem__it) {
                    pad__elem_ = *(reinterpret_cast<uint8 const*>(t_pad__elem__dataptr));
                    pad_->push_back(pad__elem_);
                    t_pad__elem__dataptr += 1;
                    BINPAC_ASSERT(t_pad__elem__dataptr <= t_end_of_data);
                }
            end_of_pad: ;
                // Evaluate 'let' and 'withinput' fields

                // Parse "pixel_format"
                int t_pixel_format__arraylength;
                t_pixel_format__arraylength = 16;
                if ( t_pixel_format__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ClientSetPixelFormat:pixel_format",
                      t_pixel_format__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ClientSetPixelFormat:pixel_format
                if ( t_pixel_format__arraylength > ((t_end_of_data - (t_begin_of_data + 3)) / 1) )
                    throw binpac::ExceptionOutOfBound("ClientSetPixelFormat:pixel_format",
                      t_pixel_format__arraylength, (t_end_of_data) - ((t_begin_of_data + 3)));
                pixel_format__elem_ = 0;
                int t_pixel_format__elem__it;
                t_pixel_format__elem__it = 0;
                pixel_format_ = new vector<uint8>;
                pixel_format_->reserve(t_pixel_format__arraylength);
                const_byteptr t_pixel_format__elem__dataptr = (t_begin_of_data + 3);
                for (; t_pixel_format__elem__it < t_pixel_format__arraylength; ++t_pixel_format__elem__it) {
                    pixel_format__elem_ = *(reinterpret_cast<uint8 const*>(t_pixel_format__elem__dataptr));
                    pixel_format_->push_back(pixel_format__elem_);
                    t_pixel_format__elem__dataptr += 1;
                    BINPAC_ASSERT(t_pixel_format__elem__dataptr <= t_end_of_data);
                }
            end_of_pixel_format: ;
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_set_pixel_format(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientSetEncodings::ClientSetEncodings() {
    pad_ = 0;
    num_encodings_ = 0;
    encodings_ = nullptr;
    encodings__elem_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientSetEncodings::~ClientSetEncodings() {
    delete encodings_;
}

bool ClientSetEncodings::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(3, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "num_encodings"
            // Checking out-of-bound for "ClientSetEncodings:num_encodings"
            if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("ClientSetEncodings:num_encodings",
                	(1) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            num_encodings_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));
            t_flow_buffer->GrowFrame(3 +  ( 4 * num_encodings() ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "pad"
                // Checking out-of-bound for "ClientSetEncodings:pad"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientSetEncodings:pad",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                pad_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));


                // Parse "encodings"
                int t_encodings__arraylength;
                t_encodings__arraylength = num_encodings();
                if ( t_encodings__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ClientSetEncodings:encodings",
                      t_encodings__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ClientSetEncodings:encodings
                if ( t_encodings__arraylength > ((t_end_of_data - (t_begin_of_data + 3)) / 4) )
                    throw binpac::ExceptionOutOfBound("ClientSetEncodings:encodings",
                      t_encodings__arraylength, (t_end_of_data) - ((t_begin_of_data + 3)));
                encodings__elem_ = 0;
                int t_encodings__elem__it;
                t_encodings__elem__it = 0;
                int t_encodings__size;
                encodings_ = new vector<uint32>;
                encodings_->reserve(t_encodings__arraylength);
                const_byteptr t_encodings__elem__dataptr = (t_begin_of_data + 3);
                for (; t_encodings__elem__it < t_encodings__arraylength; ++t_encodings__elem__it) {
                    encodings__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_encodings__elem__dataptr)));
                    encodings_->push_back(encodings__elem_);
                    t_encodings__elem__dataptr += 4;
                    BINPAC_ASSERT(t_encodings__elem__dataptr <= t_end_of_data);
                }
            end_of_encodings: ;
                t_encodings__size = t_encodings__elem__dataptr - ((t_begin_of_data + 3));
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_set_encodings(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientFramebufferUpdateRequest::ClientFramebufferUpdateRequest() {
    incremental_ = 0;
    xpos_ = 0;
    ypos_ = 0;
    width_ = 0;
    height_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientFramebufferUpdateRequest::~ClientFramebufferUpdateRequest() {
}

bool ClientFramebufferUpdateRequest::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(9);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ClientFramebufferUpdateRequest:height"
                if ( (t_begin_of_data + 7) + (2) > t_end_of_data || (t_begin_of_data + 7) + (2) < (t_begin_of_data + 7) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientFramebufferUpdateRequest:height",
                    	(7) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "incremental"
                incremental_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                // Parse "xpos"
                xpos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

                // Parse "ypos"
                ypos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

                // Parse "width"
                width_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

                // Parse "height"
                height_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_framebuffer_update_request(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientKeyEvent::ClientKeyEvent() {
    down_flag_ = 0;
    pad_ = 0;
    key_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientKeyEvent::~ClientKeyEvent() {
}

bool ClientKeyEvent::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(7);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ClientKeyEvent:key"
                if ( (t_begin_of_data + 3) + (4) > t_end_of_data || (t_begin_of_data + 3) + (4) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientKeyEvent:key",
                    	(3) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "down_flag"
                down_flag_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                // Parse "pad"
                pad_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

                // Parse "key"
                key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_key_event(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientPointerEvent::ClientPointerEvent() {
    button_mask_ = 0;
    xpos_ = 0;
    ypos_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientPointerEvent::~ClientPointerEvent() {
}

bool ClientPointerEvent::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(5);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ClientPointerEvent:ypos"
                if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientPointerEvent:ypos",
                    	(3) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "button_mask"
                button_mask_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                // Parse "xpos"
                xpos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

                // Parse "ypos"
                ypos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_pointer_event(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ClientCutText::ClientCutText() {
    pad_ = nullptr;
    pad__elem_ = 0;
    len_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ClientCutText::~ClientCutText() {
    delete pad_;
    text_.free();
}

bool ClientCutText::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(7, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "len"
            // Checking out-of-bound for "ClientCutText:len"
            if ( (t_begin_of_data + 3) + (4) > t_end_of_data || (t_begin_of_data + 3) + (4) < (t_begin_of_data + 3) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("ClientCutText:len",
                	(3) + (4), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));
            // Evaluate '&enforce' attribute
            if (! ( len() < MAX_DATA_LENGTH ) ) {
                throw binpac::ExceptionEnforceViolation("ClientCutText:len");
            }
            t_flow_buffer->GrowFrame( ( 7 + len() ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "pad"
                int t_pad__arraylength;
                t_pad__arraylength = 3;
                if ( t_pad__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ClientCutText:pad",
                      t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ClientCutText:pad
                if ( t_pad__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
                    throw binpac::ExceptionOutOfBound("ClientCutText:pad",
                      t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
                pad__elem_ = 0;
                int t_pad__elem__it;
                t_pad__elem__it = 0;
                pad_ = new vector<uint8>;
                pad_->reserve(t_pad__arraylength);
                const_byteptr t_pad__elem__dataptr = t_begin_of_data;
                for (; t_pad__elem__it < t_pad__arraylength; ++t_pad__elem__it) {
                    pad__elem_ = *(reinterpret_cast<uint8 const*>(t_pad__elem__dataptr));
                    pad_->push_back(pad__elem_);
                    t_pad__elem__dataptr += 1;
                    BINPAC_ASSERT(t_pad__elem__dataptr <= t_end_of_data);
                }
            end_of_pad: ;
                // Evaluate 'let' and 'withinput' fields


                // Parse "text"
                int t_text__size;
                t_text__size = len();
                // Checking out-of-bound for "ClientCutText:text"
                if ( (t_begin_of_data + 7) + (t_text__size) > t_end_of_data || (t_begin_of_data + 7) + (t_text__size) < (t_begin_of_data + 7) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientCutText:text",
                    	(7) + (t_text__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 7) + t_text__size;
                    int t_text_string_length;
                    t_text_string_length = len();
                    // check for negative sizes
                    if ( t_text_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:199", t_text_string_length);
                    text_.init((t_begin_of_data + 7), t_text_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_client_cut_text(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ServerMessageType::ServerMessageType() {
    type_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ServerMessageType::~ServerMessageType() {
}

bool ServerMessageType::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(1);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ServerMessageType:type"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ServerMessageType:type",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "type"
                type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->connection()->handle_server_message_type(type());
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ServerMessage::ServerMessage(uint8 type) {
    val_case_index_ = -1;
    framebuffer_update_ = nullptr;
    set_color_map_entries_ = nullptr;
    bell_ = nullptr;
    cut_text_ = nullptr;
    type_ = type;
    proc_ = false;
}

ServerMessage::~ServerMessage() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "framebuffer_update"
            {
                delete framebuffer_update_;
                framebuffer_update_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "set_color_map_entries"
            {
                delete set_color_map_entries_;
                set_color_map_entries_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "bell"
            {
                delete bell_;
                bell_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "cut_text"
            {
                delete cut_text_;
                cut_text_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool ServerMessage::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "framebuffer_update"
            {
                if ( ! framebuffer_update_ ) {
                    framebuffer_update_ = new ServerFramebufferUpdate();
                }
                bool t_framebuffer_update_parsing_complete;
                t_framebuffer_update_parsing_complete = false;
                while ( ! t_framebuffer_update_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_framebuffer_update_parsing_complete = framebuffer_update_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_framebuffer_update_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_framebuffer_update_parsing_complete;
            }
            break;
        case ((uint8)1):
            // Parse "set_color_map_entries"
            {
                if ( ! set_color_map_entries_ ) {
                    set_color_map_entries_ = new ServerSetColorMapEntries();
                }
                bool t_set_color_map_entries_parsing_complete;
                t_set_color_map_entries_parsing_complete = false;
                while ( ! t_set_color_map_entries_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_set_color_map_entries_parsing_complete = set_color_map_entries_->ParseBuffer(t_flow_buffer, t_byteorder);
                    if ( t_set_color_map_entries_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_set_color_map_entries_parsing_complete;
            }
            break;
        case ((uint8)2):
            // Parse "bell"
            {
                if ( ! bell_ ) {
                    bell_ = new ServerBell();
                }
                bool t_bell_parsing_complete;
                t_bell_parsing_complete = false;
                t_bell_parsing_complete = true;
                t_val_parsing_complete = t_bell_parsing_complete;
            }
            break;
        case ((uint8)3):
            // Parse "cut_text"
            {
                if ( ! cut_text_ ) {
                    cut_text_ = new ServerCutText();
                }
                bool t_cut_text_parsing_complete;
                t_cut_text_parsing_complete = false;
                while ( ! t_cut_text_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_cut_text_parsing_complete = cut_text_->ParseBuffer(t_flow_buffer, t_byteorder);
                    if ( t_cut_text_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_cut_text_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ServerMessage", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->handle_server_message(type());
    }
    return t_val_parsing_complete;
}

PixelData::PixelData(int32 encoding, uint16 x, uint16 y, uint16 w, uint16 h) {
    val_case_index_ = -1;
    raw_ = nullptr;
    copy_rec_ = nullptr;
    rre_ = nullptr;
    hextile_ = nullptr;
    trle_ = nullptr;
    zrle_ = nullptr;
    encoding_ = encoding;
    x_ = x;
    y_ = y;
    w_ = w;
    h_ = h;
}

PixelData::~PixelData() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int32)0):
            // Clean up "raw"
            {
                delete raw_;
                raw_ = nullptr;
            }
            break;
        case ((int32)1):
            // Clean up "copy_rec"
            {
                delete copy_rec_;
                copy_rec_ = nullptr;
            }
            break;
        case ((int32)2):
            // Clean up "rre"
            {
                delete rre_;
                rre_ = nullptr;
            }
            break;
        case ((int32)5):
            // Clean up "hextile"
            {
                delete hextile_;
                hextile_ = nullptr;
            }
            break;
        case ((int32)15):
            // Clean up "trle"
            {
                delete trle_;
                trle_ = nullptr;
            }
            break;
        case ((int32)16):
            // Clean up "zrle"
            {
                delete zrle_;
                zrle_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int PixelData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = encoding();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int32)0):
            // Parse "raw"
            {
                raw_ = new PD_Raw(w(), h());
                int t_raw__size;
                t_raw__size = raw_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_raw__size;
            }
            break;
        case ((int32)1):
            // Parse "copy_rec"
            {
                copy_rec_ = new PD_CopyRec();
                copy_rec_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = 4;
            }
            break;
        case ((int32)2):
            // Parse "rre"
            {
                rre_ = new PD_RRE();
                int t_rre__size;
                t_rre__size = rre_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_rre__size;
            }
            break;
        case ((int32)5):
            // Parse "hextile"
            {
                hextile_ = new PD_Hextile();
                hextile_->Parse(nullptr, nullptr);
                t_val__size = 0;
            }
            break;
        case ((int32)15):
            // Parse "trle"
            {
                trle_ = new PD_TRLE();
                trle_->Parse(nullptr, nullptr);
                t_val__size = 0;
            }
            break;
        case ((int32)16):
            // Parse "zrle"
            {
                zrle_ = new PD_ZRLE();
                int t_zrle__size;
                t_zrle__size = zrle_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_zrle__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("PixelData", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

PD_Raw::PD_Raw(uint16 w, uint16 h) {
    w_ = w;
    h_ = h;
}

PD_Raw::~PD_Raw() {
}

int PD_Raw::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context) {
    int t_PD_Raw__size;
    t_PD_Raw__size =  ( w() * h() * t_context->connection()->get_bytes_per_pixel() ) ;
    // Checking out-of-bound for "PD_Raw"
    if ( t_begin_of_data + (t_PD_Raw__size) > t_end_of_data || t_begin_of_data + (t_PD_Raw__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_Raw",
        	(0) + (t_PD_Raw__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PD_Raw__size;
        // Parse "pixels"
        int t_pixels__size;
        t_pixels__size =  ( w() * h() * t_context->connection()->get_bytes_per_pixel() ) ;
        // Checking out-of-bound for "PD_Raw:pixels"
        if ( t_begin_of_data + (t_pixels__size) > t_end_of_data || t_begin_of_data + (t_pixels__size) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_Raw:pixels",
            	(0) + (t_pixels__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + t_pixels__size;
            int t_pixels_string_length;
            t_pixels_string_length =  ( w() * h() * t_context->connection()->get_bytes_per_pixel() ) ;
            // check for negative sizes
            if ( t_pixels_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:232", t_pixels_string_length);
            pixels_.init(t_begin_of_data, t_pixels_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PD_Raw__size) <= t_end_of_data);
    return t_PD_Raw__size;
}

PD_CopyRec::PD_CopyRec() {
    xpos_ = 0;
    ypos_ = 0;
}

PD_CopyRec::~PD_CopyRec() {
}

int PD_CopyRec::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "PD_CopyRec"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_CopyRec",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 4;
        // Checking out-of-bound for "PD_CopyRec:ypos"
        if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_CopyRec:ypos",
            	(2) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "xpos"
        xpos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

        // Parse "ypos"
        ypos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

RRE_Subrect::RRE_Subrect() {
    xpos_ = 0;
    ypos_ = 0;
    width_ = 0;
    height_ = 0;
}

RRE_Subrect::~RRE_Subrect() {
    pixel_.free();
}

int RRE_Subrect::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder) {
    int t_RRE_Subrect__size;
    t_RRE_Subrect__size = t_context->connection()->get_bytes_per_pixel() + 8;
    // Checking out-of-bound for "RRE_Subrect"
    if ( t_begin_of_data + (t_RRE_Subrect__size) > t_end_of_data || t_begin_of_data + (t_RRE_Subrect__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RRE_Subrect",
        	(0) + (t_RRE_Subrect__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_RRE_Subrect__size;
        // Parse "pixel"
        int t_pixel__size;
        t_pixel__size = t_context->connection()->get_bytes_per_pixel();
        // Checking out-of-bound for "RRE_Subrect:pixel"
        if ( t_begin_of_data + (t_pixel__size) > t_end_of_data || t_begin_of_data + (t_pixel__size) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("RRE_Subrect:pixel",
            	(0) + (t_pixel__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + t_pixel__size;
            int t_pixel_string_length;
            t_pixel_string_length = t_context->connection()->get_bytes_per_pixel();
            // check for negative sizes
            if ( t_pixel_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:241", t_pixel_string_length);
            pixel_.init(t_begin_of_data, t_pixel_string_length);
        }

        const_byteptr const t_dataptr_after_pixel = t_begin_of_data + (t_pixel__size);
        BINPAC_ASSERT(t_dataptr_after_pixel <= t_end_of_data);
        // Checking out-of-bound for "RRE_Subrect:height"
        if ( (t_dataptr_after_pixel + 6) + (2) > t_end_of_data || (t_dataptr_after_pixel + 6) + (2) < (t_dataptr_after_pixel + 6) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("RRE_Subrect:height",
            	(((t_dataptr_after_pixel + 6) - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "xpos"
        xpos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_pixel)));

        // Parse "ypos"
        ypos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_pixel + 2))));

        // Parse "width"
        width_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_pixel + 4))));

        // Parse "height"
        height_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_pixel + 6))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_RRE_Subrect__size) <= t_end_of_data);
    return t_RRE_Subrect__size;
}

PD_RRE::PD_RRE() {
    num_subrects_ = 0;
    subrects_ = nullptr;
    subrects__elem_ = nullptr;
}

PD_RRE::~PD_RRE() {
    bg_pixel_.free();
    delete subrects__elem_;
    subrects__elem_ = nullptr;
    if ( subrects_ ) {
        for ( auto* subrects__elem_ : *subrects_ ) {
            delete subrects__elem_;
            subrects__elem_ = nullptr;
        }
    }
    delete subrects_;
}

int PD_RRE::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder) {
    int t_PD_RRE__size;
    // Checking out-of-bound for "PD_RRE:num_subrects"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_RRE:num_subrects",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "num_subrects"
    num_subrects_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
    t_PD_RRE__size = 4 + t_context->connection()->get_bytes_per_pixel() +  ( num_subrects() *  ( t_context->connection()->get_bytes_per_pixel() + 8 )  ) ;
    // Checking out-of-bound for "PD_RRE"
    if ( t_begin_of_data + (t_PD_RRE__size) > t_end_of_data || t_begin_of_data + (t_PD_RRE__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_RRE",
        	(0) + (t_PD_RRE__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PD_RRE__size;

        // Parse "bg_pixel"
        int t_bg_pixel__size;
        t_bg_pixel__size = t_context->connection()->get_bytes_per_pixel();
        // Checking out-of-bound for "PD_RRE:bg_pixel"
        if ( (t_begin_of_data + 4) + (t_bg_pixel__size) > t_end_of_data || (t_begin_of_data + 4) + (t_bg_pixel__size) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_RRE:bg_pixel",
            	(4) + (t_bg_pixel__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_bg_pixel__size;
            int t_bg_pixel_string_length;
            t_bg_pixel_string_length = t_context->connection()->get_bytes_per_pixel();
            // check for negative sizes
            if ( t_bg_pixel_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:250", t_bg_pixel_string_length);
            bg_pixel_.init((t_begin_of_data + 4), t_bg_pixel_string_length);
        }

        const_byteptr const t_dataptr_after_bg_pixel = (t_begin_of_data + 4) + (t_bg_pixel__size);
        BINPAC_ASSERT(t_dataptr_after_bg_pixel <= t_end_of_data);
        // Parse "subrects"
        int t_subrects__arraylength;
        t_subrects__arraylength = num_subrects();
        if ( t_subrects__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("PD_RRE:subrects",
              t_subrects__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check array element quantity: PD_RRE:subrects
        if ( t_subrects__arraylength > ((t_end_of_data - t_dataptr_after_bg_pixel) / 1) )
            throw binpac::ExceptionOutOfBound("PD_RRE:subrects",
              t_subrects__arraylength, (t_end_of_data) - (t_dataptr_after_bg_pixel));
        subrects__elem_ = nullptr;
        int t_subrects__elem__it;
        t_subrects__elem__it = 0;
        int t_subrects__size;
        subrects_ = new vector<RRE_Subrect*>;
        subrects_->reserve(t_subrects__arraylength);
        const_byteptr t_subrects__elem__dataptr = t_dataptr_after_bg_pixel;
        for (; t_subrects__elem__it < t_subrects__arraylength; ++t_subrects__elem__it) {
            subrects__elem_ = new RRE_Subrect();
            int t_subrects__elem__size;
            t_subrects__elem__size = subrects__elem_->Parse(t_subrects__elem__dataptr, t_end_of_data, t_context, t_byteorder);
            delete subrects__elem_;
            t_subrects__elem__dataptr += t_subrects__elem__size;
            BINPAC_ASSERT(t_subrects__elem__dataptr <= t_end_of_data);
            subrects__elem_ = nullptr;
        }
    end_of_subrects: ;
        t_subrects__size = t_subrects__elem__dataptr - (t_dataptr_after_bg_pixel);
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PD_RRE__size) <= t_end_of_data);
    return t_PD_RRE__size;
}

PD_Hextile::PD_Hextile() {
}

PD_Hextile::~PD_Hextile() {
}

int PD_Hextile::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PD_Hextile"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_Hextile",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 0;
        // Checking out-of-bound for "PD_Hextile:nothing"
        if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_Hextile:nothing",
            	(0) + (0), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "nothing"

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

PD_TRLE::PD_TRLE() {
}

PD_TRLE::~PD_TRLE() {
}

int PD_TRLE::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PD_TRLE"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_TRLE",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 0;
        // Checking out-of-bound for "PD_TRLE:nothing"
        if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_TRLE:nothing",
            	(0) + (0), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "nothing"

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

PD_ZRLE::PD_ZRLE() {
    len_ = 0;
}

PD_ZRLE::~PD_ZRLE() {
}

int PD_ZRLE::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_PD_ZRLE__size;
    // Checking out-of-bound for "PD_ZRLE:len"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_ZRLE:len",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
    t_PD_ZRLE__size =  ( 4 + len() ) ;
    // Checking out-of-bound for "PD_ZRLE"
    if ( t_begin_of_data + (t_PD_ZRLE__size) > t_end_of_data || t_begin_of_data + (t_PD_ZRLE__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_ZRLE",
        	(0) + (t_PD_ZRLE__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PD_ZRLE__size;

        // Parse "zlib_data"
        int t_zlib_data__size;
        t_zlib_data__size = len();
        // Checking out-of-bound for "PD_ZRLE:zlib_data"
        if ( (t_begin_of_data + 4) + (t_zlib_data__size) > t_end_of_data || (t_begin_of_data + 4) + (t_zlib_data__size) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_ZRLE:zlib_data",
            	(4) + (t_zlib_data__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_zlib_data__size;
            int t_zlib_data_string_length;
            t_zlib_data_string_length = len();
            // check for negative sizes
            if ( t_zlib_data_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:266", t_zlib_data_string_length);
            zlib_data_.init((t_begin_of_data + 4), t_zlib_data_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PD_ZRLE__size) <= t_end_of_data);
    return t_PD_ZRLE__size;
}

PD_PseudoCursor::PD_PseudoCursor(uint16 w, uint16 h) {
    w_ = w;
    h_ = h;
}

PD_PseudoCursor::~PD_PseudoCursor() {
}

int PD_PseudoCursor::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context) {
    int t_PD_PseudoCursor__size;
    t_PD_PseudoCursor__size =  ( w() * h() * t_context->connection()->get_bytes_per_pixel() )  +  ( h() *  (  ( w() + 7 )  / 8 )  ) ;
    // Checking out-of-bound for "PD_PseudoCursor"
    if ( t_begin_of_data + (t_PD_PseudoCursor__size) > t_end_of_data || t_begin_of_data + (t_PD_PseudoCursor__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_PseudoCursor",
        	(0) + (t_PD_PseudoCursor__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PD_PseudoCursor__size;
        // Parse "pixels"
        int t_pixels__size;
        t_pixels__size =  ( w() * h() * t_context->connection()->get_bytes_per_pixel() ) ;
        // Checking out-of-bound for "PD_PseudoCursor:pixels"
        if ( t_begin_of_data + (t_pixels__size) > t_end_of_data || t_begin_of_data + (t_pixels__size) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_PseudoCursor:pixels",
            	(0) + (t_pixels__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + t_pixels__size;
            int t_pixels_string_length;
            t_pixels_string_length =  ( w() * h() * t_context->connection()->get_bytes_per_pixel() ) ;
            // check for negative sizes
            if ( t_pixels_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:270", t_pixels_string_length);
            pixels_.init(t_begin_of_data, t_pixels_string_length);
        }

        const_byteptr const t_dataptr_after_pixels = t_begin_of_data + (t_pixels__size);
        BINPAC_ASSERT(t_dataptr_after_pixels <= t_end_of_data);
        // Parse "bitmask"
        int t_bitmask__size;
        t_bitmask__size =  ( h() *  (  ( w() + 7 )  / 8 )  ) ;
        // Checking out-of-bound for "PD_PseudoCursor:bitmask"
        if ( t_dataptr_after_pixels + (t_bitmask__size) > t_end_of_data || t_dataptr_after_pixels + (t_bitmask__size) < t_dataptr_after_pixels ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_PseudoCursor:bitmask",
            	((t_dataptr_after_pixels - t_begin_of_data)) + (t_bitmask__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_dataptr_after_pixels + t_bitmask__size;
            int t_bitmask_string_length;
            t_bitmask_string_length =  ( h() *  (  ( w() + 7 )  / 8 )  ) ;
            // check for negative sizes
            if ( t_bitmask_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:271", t_bitmask_string_length);
            bitmask_.init(t_dataptr_after_pixels, t_bitmask_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PD_PseudoCursor__size) <= t_end_of_data);
    return t_PD_PseudoCursor__size;
}

PD_PseudoDesktopSize::PD_PseudoDesktopSize() {
}

PD_PseudoDesktopSize::~PD_PseudoDesktopSize() {
}

int PD_PseudoDesktopSize::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PD_PseudoDesktopSize"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PD_PseudoDesktopSize",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 0;
        // Checking out-of-bound for "PD_PseudoDesktopSize:nothing"
        if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("PD_PseudoDesktopSize:nothing",
            	(0) + (0), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "nothing"

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

Rectangle::Rectangle() {
    xpos_ = 0;
    ypos_ = 0;
    width_ = 0;
    height_ = 0;
    encoding_ = 0;
    pixel_data_ = nullptr;
}

Rectangle::~Rectangle() {
    delete pixel_data_;
    pixel_data_ = nullptr;
}

int Rectangle::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextRFB* t_context, int t_byteorder) {
    // Checking out-of-bound for "Rectangle"
    if ( t_begin_of_data + (12) > t_end_of_data || t_begin_of_data + (12) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Rectangle",
        	(0) + (12), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 12;
        // Checking out-of-bound for "Rectangle:encoding"
        if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Rectangle:encoding",
            	(8) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "xpos"
        xpos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

        // Parse "ypos"
        ypos_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

        // Parse "width"
        width_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

        // Parse "height"
        height_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

        // Parse "encoding"
        encoding_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int32 const*>((t_begin_of_data + 8))));

        // Parse "pixel_data"
        pixel_data_ = new PixelData(encoding(), xpos(), ypos(), width(), height());
        int t_pixel_data__size;
        t_pixel_data__size = pixel_data_->Parse((t_begin_of_data + 12), t_end_of_data, t_context, t_byteorder);

        int t_Rectangle__size;
        const_byteptr const t_dataptr_after_pixel_data = (t_begin_of_data + 12) + (t_pixel_data__size);
        BINPAC_ASSERT(t_dataptr_after_pixel_data <= t_end_of_data);
        t_Rectangle__size = t_dataptr_after_pixel_data - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (12) <= t_end_of_data);
    return 12;
}

ServerFramebufferUpdate::ServerFramebufferUpdate() {
    pad_ = 0;
    num_rects_ = 0;
    rects_ = nullptr;
    rects__elem_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ServerFramebufferUpdate::~ServerFramebufferUpdate() {
    delete rects__elem_;
    rects__elem_ = nullptr;
    if ( rects() ) {
        for ( auto* rects__elem_ : *rects() ) {
            delete rects__elem_;
            rects__elem_ = nullptr;
        }
    }
    delete rects_;
}

bool ServerFramebufferUpdate::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(3);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Checking out-of-bound for "ServerFramebufferUpdate:num_rects"
                if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ServerFramebufferUpdate:num_rects",
                    	(1) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "pad"
                pad_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                // Parse "num_rects"
                num_rects_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

                // Parse "rects"
                int t_rects__arraylength;
                t_rects__arraylength = num_rects();
                if ( t_rects__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ServerFramebufferUpdate:rects",
                      t_rects__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: ServerFramebufferUpdate:rects
                if ( t_rects__arraylength > ((t_end_of_data - (t_begin_of_data + 3)) / 1) )
                    throw binpac::ExceptionOutOfBound("ServerFramebufferUpdate:rects",
                      t_rects__arraylength, (t_end_of_data) - ((t_begin_of_data + 3)));
                rects__elem_ = nullptr;
                int t_rects__elem__it;
                t_rects__elem__it = 0;
                int t_rects__size;
                rects_ = new vector<Rectangle*>;
                rects_->reserve(t_rects__arraylength);
                const_byteptr t_rects__elem__dataptr = (t_begin_of_data + 3);
                for (; t_rects__elem__it < t_rects__arraylength; ++t_rects__elem__it) {
                    rects__elem_ = new Rectangle();
                    int t_rects__elem__size;
                    t_rects__elem__size = rects__elem_->Parse(t_rects__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    rects_->push_back(rects__elem_);
                    t_rects__elem__dataptr += t_rects__elem__size;
                    BINPAC_ASSERT(t_rects__elem__dataptr <= t_end_of_data);
                    rects__elem_ = nullptr;
                }
            end_of_rects: ;
                t_rects__size = t_rects__elem__dataptr - ((t_begin_of_data + 3));
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RGB_Value::RGB_Value() {
    red_ = 0;
    green_ = 0;
    blue_ = 0;
}

RGB_Value::~RGB_Value() {
}

int RGB_Value::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RGB_Value"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RGB_Value",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 6;
        // Checking out-of-bound for "RGB_Value:blue"
        if ( (t_begin_of_data + 4) + (2) > t_end_of_data || (t_begin_of_data + 4) + (2) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("RGB_Value:blue",
            	(4) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "red"
        red_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

        // Parse "green"
        green_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

        // Parse "blue"
        blue_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}

ServerSetColorMapEntries::ServerSetColorMapEntries() {
    pad_ = 0;
    first_color_ = 0;
    num_colors_ = 0;
    colors_ = nullptr;
    colors__elem_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ServerSetColorMapEntries::~ServerSetColorMapEntries() {
    delete colors__elem_;
    colors__elem_ = nullptr;
    if ( colors() ) {
        for ( auto* colors__elem_ : *colors() ) {
            delete colors__elem_;
            colors__elem_ = nullptr;
        }
    }
    delete colors_;
}

bool ServerSetColorMapEntries::ParseBuffer(flow_buffer_t t_flow_buffer, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(5, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "num_colors"
            // Checking out-of-bound for "ServerSetColorMapEntries:num_colors"
            if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("ServerSetColorMapEntries:num_colors",
                	(3) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            num_colors_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));
            t_flow_buffer->GrowFrame(5 +  ( num_colors() * 6 ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "pad"
                // Checking out-of-bound for "ServerSetColorMapEntries:pad"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ServerSetColorMapEntries:pad",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                pad_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

                // Parse "first_color"
                // Checking out-of-bound for "ServerSetColorMapEntries:first_color"
                if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ServerSetColorMapEntries:first_color",
                    	(1) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                first_color_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));


                // Parse "colors"
                int t_colors__arraylength;
                t_colors__arraylength = num_colors();
                if ( t_colors__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ServerSetColorMapEntries:colors",
                      t_colors__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ServerSetColorMapEntries:colors
                if ( t_colors__arraylength > ((t_end_of_data - (t_begin_of_data + 5)) / 6) )
                    throw binpac::ExceptionOutOfBound("ServerSetColorMapEntries:colors",
                      t_colors__arraylength, (t_end_of_data) - ((t_begin_of_data + 5)));
                colors__elem_ = nullptr;
                int t_colors__elem__it;
                t_colors__elem__it = 0;
                int t_colors__size;
                colors_ = new vector<RGB_Value*>;
                colors_->reserve(t_colors__arraylength);
                const_byteptr t_colors__elem__dataptr = (t_begin_of_data + 5);
                for (; t_colors__elem__it < t_colors__arraylength; ++t_colors__elem__it) {
                    colors__elem_ = new RGB_Value();
                    colors__elem_->Parse(t_colors__elem__dataptr, t_end_of_data, t_byteorder);
                    colors_->push_back(colors__elem_);
                    t_colors__elem__dataptr += 6;
                    BINPAC_ASSERT(t_colors__elem__dataptr <= t_end_of_data);
                    colors__elem_ = nullptr;
                }
            end_of_colors: ;
                t_colors__size = t_colors__elem__dataptr - ((t_begin_of_data + 5));
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

ServerBell::ServerBell() {
}

ServerBell::~ServerBell() {
}

int ServerBell::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ServerBell"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerBell",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 0;
        // Checking out-of-bound for "ServerBell:nothing"
        if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("ServerBell:nothing",
            	(0) + (0), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "nothing"

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

ServerCutText::ServerCutText() {
    pad_ = nullptr;
    pad__elem_ = 0;
    len_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

ServerCutText::~ServerCutText() {
    delete pad_;
    text_.free();
}

bool ServerCutText::ParseBuffer(flow_buffer_t t_flow_buffer, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(7, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "len"
            // Checking out-of-bound for "ServerCutText:len"
            if ( (t_begin_of_data + 3) + (4) > t_end_of_data || (t_begin_of_data + 3) + (4) < (t_begin_of_data + 3) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("ServerCutText:len",
                	(3) + (4), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));
            // Evaluate '&enforce' attribute
            if (! ( len() < MAX_DATA_LENGTH ) ) {
                throw binpac::ExceptionEnforceViolation("ServerCutText:len");
            }
            t_flow_buffer->GrowFrame( ( 7 + len() ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "pad"
                int t_pad__arraylength;
                t_pad__arraylength = 3;
                if ( t_pad__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("ServerCutText:pad",
                      t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: ServerCutText:pad
                if ( t_pad__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
                    throw binpac::ExceptionOutOfBound("ServerCutText:pad",
                      t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
                pad__elem_ = 0;
                int t_pad__elem__it;
                t_pad__elem__it = 0;
                pad_ = new vector<uint8>;
                pad_->reserve(t_pad__arraylength);
                const_byteptr t_pad__elem__dataptr = t_begin_of_data;
                for (; t_pad__elem__it < t_pad__arraylength; ++t_pad__elem__it) {
                    pad__elem_ = *(reinterpret_cast<uint8 const*>(t_pad__elem__dataptr));
                    pad_->push_back(pad__elem_);
                    t_pad__elem__dataptr += 1;
                    BINPAC_ASSERT(t_pad__elem__dataptr <= t_end_of_data);
                }
            end_of_pad: ;
                // Evaluate 'let' and 'withinput' fields


                // Parse "text"
                int t_text__size;
                t_text__size = len();
                // Checking out-of-bound for "ServerCutText:text"
                if ( (t_begin_of_data + 7) + (t_text__size) > t_end_of_data || (t_begin_of_data + 7) + (t_text__size) < (t_begin_of_data + 7) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ServerCutText:text",
                    	(7) + (t_text__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 7) + t_text__size;
                    int t_text_string_length;
                    t_text_string_length = len();
                    // check for negative sizes
                    if ( t_text_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/rfb/rfb-protocol.pac:316", t_text_string_length);
                    text_.init((t_begin_of_data + 7), t_text_string_length);
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RFB_PDU_request::RFB_PDU_request(uint8 state) {
    val_case_index_ = -1;
    wait_ = nullptr;
    invalid_ = nullptr;
    version_ = nullptr;
    authtype_ = nullptr;
    response_ = nullptr;
    ard_response_ = nullptr;
    shareflag_ = nullptr;
    msg_type_ = nullptr;
    msg_ = nullptr;
    state_ = state;
}

RFB_PDU_request::~RFB_PDU_request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)99):
            // Clean up "wait"
            {
                delete wait_;
                wait_ = nullptr;
            }
            break;
        case ((uint8)100):
            // Clean up "invalid"
            {
                delete invalid_;
                invalid_ = nullptr;
            }
            break;
        case ((uint8)0):
            // Clean up "version"
            {
                delete version_;
                version_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "authtype"
            {
                delete authtype_;
                authtype_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "ard_response"
            {
                delete ard_response_;
                ard_response_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "shareflag"
            {
                delete shareflag_;
                shareflag_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "msg_type"
            {
                delete msg_type_;
                msg_type_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "msg"
            {
                delete msg_;
                msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool RFB_PDU_request::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = state();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)99):
            // Parse "wait"
            {
                if ( ! wait_ ) {
                    wait_ = new WaitData(true);
                }
                bool t_wait_parsing_complete;
                t_wait_parsing_complete = false;
                while ( ! t_wait_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_wait_parsing_complete = wait_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_wait_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_wait_parsing_complete;
            }
            break;
        case ((uint8)100):
            // Parse "invalid"
            {
                if ( ! invalid_ ) {
                    invalid_ = new InvalidData(true);
                }
                bool t_invalid_parsing_complete;
                t_invalid_parsing_complete = false;
                while ( ! t_invalid_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_invalid_parsing_complete = invalid_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_invalid_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_invalid_parsing_complete;
            }
            break;
        case ((uint8)0):
            // Parse "version"
            {
                if ( ! version_ ) {
                    version_ = new RFBProtocolVersion(true);
                }
                bool t_version_parsing_complete;
                t_version_parsing_complete = false;
                while ( ! t_version_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_version_parsing_complete = version_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_version_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_version_parsing_complete;
            }
            break;
        case ((uint8)1):
            // Parse "authtype"
            {
                if ( ! authtype_ ) {
                    authtype_ = new RFBAuthTypeSelected();
                }
                bool t_authtype_parsing_complete;
                t_authtype_parsing_complete = false;
                while ( ! t_authtype_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_authtype_parsing_complete = authtype_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_authtype_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_authtype_parsing_complete;
            }
            break;
        case ((uint8)2):
            // Parse "response"
            {
                if ( ! response_ ) {
                    response_ = new RFBVNCAuthenticationResponse();
                }
                bool t_response_parsing_complete;
                t_response_parsing_complete = false;
                while ( ! t_response_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_response_parsing_complete = response_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_response_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_response_parsing_complete;
            }
            break;
        case ((uint8)3):
            // Parse "ard_response"
            {
                if ( ! ard_response_ ) {
                    ard_response_ = new RFBSecurityARDResponse();
                }
                bool t_ard_response_parsing_complete;
                t_ard_response_parsing_complete = false;
                while ( ! t_ard_response_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_ard_response_parsing_complete = ard_response_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_ard_response_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_ard_response_parsing_complete;
            }
            break;
        case ((uint8)4):
            // Parse "shareflag"
            {
                if ( ! shareflag_ ) {
                    shareflag_ = new RFBClientInit();
                }
                bool t_shareflag_parsing_complete;
                t_shareflag_parsing_complete = false;
                while ( ! t_shareflag_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_shareflag_parsing_complete = shareflag_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_shareflag_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_shareflag_parsing_complete;
            }
            break;
        case ((uint8)5):
            // Parse "msg_type"
            {
                if ( ! msg_type_ ) {
                    msg_type_ = new ClientMessageType();
                }
                bool t_msg_type_parsing_complete;
                t_msg_type_parsing_complete = false;
                while ( ! t_msg_type_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_msg_type_parsing_complete = msg_type_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_msg_type_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_msg_type_parsing_complete;
            }
            break;
        case ((uint8)6):
            // Parse "msg"
            {
                if ( ! msg_ ) {
                    msg_ = new ClientMessage(t_context->connection()->get_next_msg_type(true));
                }
                bool t_msg_parsing_complete;
                t_msg_parsing_complete = false;
                t_msg_parsing_complete = msg_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                if ( t_msg_parsing_complete ) {
                }
                t_val_parsing_complete = t_msg_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RFB_PDU_request", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

RFB_PDU_response::RFB_PDU_response(uint8 state) {
    val_case_index_ = -1;
    wait_ = nullptr;
    invalid_ = nullptr;
    version_ = nullptr;
    auth_type_ = nullptr;
    auth_types37_ = nullptr;
    fail_reason_ = nullptr;
    challenge_ = nullptr;
    ard_challenge_ = nullptr;
    authresult_ = nullptr;
    serverinit_ = nullptr;
    msg_type_ = nullptr;
    msg_ = nullptr;
    state_ = state;
}

RFB_PDU_response::~RFB_PDU_response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)99):
            // Clean up "wait"
            {
                delete wait_;
                wait_ = nullptr;
            }
            break;
        case ((uint8)100):
            // Clean up "invalid"
            {
                delete invalid_;
                invalid_ = nullptr;
            }
            break;
        case ((uint8)0):
            // Clean up "version"
            {
                delete version_;
                version_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "auth_type"
            {
                delete auth_type_;
                auth_type_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "auth_types37"
            {
                delete auth_types37_;
                auth_types37_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "fail_reason"
            {
                delete fail_reason_;
                fail_reason_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "challenge"
            {
                delete challenge_;
                challenge_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "ard_challenge"
            {
                delete ard_challenge_;
                ard_challenge_ = nullptr;
            }
            break;
        case ((uint8)6):
            // Clean up "authresult"
            {
                delete authresult_;
                authresult_ = nullptr;
            }
            break;
        case ((uint8)7):
            // Clean up "serverinit"
            {
                delete serverinit_;
                serverinit_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "msg_type"
            {
                delete msg_type_;
                msg_type_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "msg"
            {
                delete msg_;
                msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool RFB_PDU_response::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = state();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)99):
            // Parse "wait"
            {
                if ( ! wait_ ) {
                    wait_ = new WaitData(false);
                }
                bool t_wait_parsing_complete;
                t_wait_parsing_complete = false;
                while ( ! t_wait_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_wait_parsing_complete = wait_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_wait_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_wait_parsing_complete;
            }
            break;
        case ((uint8)100):
            // Parse "invalid"
            {
                if ( ! invalid_ ) {
                    invalid_ = new InvalidData(false);
                }
                bool t_invalid_parsing_complete;
                t_invalid_parsing_complete = false;
                while ( ! t_invalid_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_invalid_parsing_complete = invalid_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_invalid_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_invalid_parsing_complete;
            }
            break;
        case ((uint8)0):
            // Parse "version"
            {
                if ( ! version_ ) {
                    version_ = new RFBProtocolVersion(false);
                }
                bool t_version_parsing_complete;
                t_version_parsing_complete = false;
                while ( ! t_version_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_version_parsing_complete = version_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_version_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_version_parsing_complete;
            }
            break;
        case ((uint8)1):
            // Parse "auth_type"
            {
                if ( ! auth_type_ ) {
                    auth_type_ = new RFBSecurityType();
                }
                bool t_auth_type_parsing_complete;
                t_auth_type_parsing_complete = false;
                while ( ! t_auth_type_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_auth_type_parsing_complete = auth_type_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_auth_type_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_auth_type_parsing_complete;
            }
            break;
        case ((uint8)2):
            // Parse "auth_types37"
            {
                if ( ! auth_types37_ ) {
                    auth_types37_ = new RFBSecurityTypes37();
                }
                bool t_auth_types37_parsing_complete;
                t_auth_types37_parsing_complete = false;
                while ( ! t_auth_types37_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_auth_types37_parsing_complete = auth_types37_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_auth_types37_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_auth_types37_parsing_complete;
            }
            break;
        case ((uint8)3):
            // Parse "fail_reason"
            {
                if ( ! fail_reason_ ) {
                    fail_reason_ = new RFBFailReasonString();
                }
                bool t_fail_reason_parsing_complete;
                t_fail_reason_parsing_complete = false;
                while ( ! t_fail_reason_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_fail_reason_parsing_complete = fail_reason_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_fail_reason_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_fail_reason_parsing_complete;
            }
            break;
        case ((uint8)4):
            // Parse "challenge"
            {
                if ( ! challenge_ ) {
                    challenge_ = new RFBVNCAuthenticationRequest();
                }
                bool t_challenge_parsing_complete;
                t_challenge_parsing_complete = false;
                while ( ! t_challenge_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_challenge_parsing_complete = challenge_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_challenge_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_challenge_parsing_complete;
            }
            break;
        case ((uint8)5):
            // Parse "ard_challenge"
            {
                if ( ! ard_challenge_ ) {
                    ard_challenge_ = new RFBSecurityARDChallenge();
                }
                bool t_ard_challenge_parsing_complete;
                t_ard_challenge_parsing_complete = false;
                while ( ! t_ard_challenge_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_ard_challenge_parsing_complete = ard_challenge_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_ard_challenge_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_ard_challenge_parsing_complete;
            }
            break;
        case ((uint8)6):
            // Parse "authresult"
            {
                if ( ! authresult_ ) {
                    authresult_ = new RFBSecurityResult();
                }
                bool t_authresult_parsing_complete;
                t_authresult_parsing_complete = false;
                while ( ! t_authresult_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_authresult_parsing_complete = authresult_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_authresult_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_authresult_parsing_complete;
            }
            break;
        case ((uint8)7):
            // Parse "serverinit"
            {
                if ( ! serverinit_ ) {
                    serverinit_ = new RFBServerInit();
                }
                bool t_serverinit_parsing_complete;
                t_serverinit_parsing_complete = false;
                while ( ! t_serverinit_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_serverinit_parsing_complete = serverinit_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                    if ( t_serverinit_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_serverinit_parsing_complete;
            }
            break;
        case ((uint8)8):
            // Parse "msg_type"
            {
                if ( ! msg_type_ ) {
                    msg_type_ = new ServerMessageType();
                }
                bool t_msg_type_parsing_complete;
                t_msg_type_parsing_complete = false;
                while ( ! t_msg_type_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_msg_type_parsing_complete = msg_type_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_msg_type_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_msg_type_parsing_complete;
            }
            break;
        case ((uint8)9):
            // Parse "msg"
            {
                if ( ! msg_ ) {
                    msg_ = new ServerMessage(t_context->connection()->get_next_msg_type(false));
                }
                bool t_msg_parsing_complete;
                t_msg_parsing_complete = false;
                t_msg_parsing_complete = msg_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
                if ( t_msg_parsing_complete ) {
                }
                t_val_parsing_complete = t_msg_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RFB_PDU_response", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

RFB_PDU::RFB_PDU(bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    response_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
}

RFB_PDU::~RFB_PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool RFB_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextRFB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                if ( ! request_ ) {
                    request_ = new RFB_PDU_request(t_context->connection()->get_state(true));
                }
                bool t_request_parsing_complete;
                t_request_parsing_complete = false;
                t_request_parsing_complete = request_->ParseBuffer(t_flow_buffer, t_context, byteorder());
                if ( t_request_parsing_complete ) {
                }
                t_val_parsing_complete = t_request_parsing_complete;
            }
            break;
        case false:
            // Parse "response"
            {
                if ( ! response_ ) {
                    response_ = new RFB_PDU_response(t_context->connection()->get_state(false));
                }
                bool t_response_parsing_complete;
                t_response_parsing_complete = false;
                t_response_parsing_complete = response_->ParseBuffer(t_flow_buffer, t_context, byteorder());
                if ( t_response_parsing_complete ) {
                }
                t_val_parsing_complete = t_response_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("RFB_PDU", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

RFB_Flow::RFB_Flow(RFB_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

RFB_Flow::~RFB_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void RFB_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new RFB_PDU(is_orig());
                context_ = new ContextRFB(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void RFB_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void RFB_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool RFB_Flow::proc_rfb_version(bool client, bytestring const& major, bytestring const& minor) {

		if ( client )
			{
			if ( rfb_client_version )
				zeek::BifEvent::enqueue_rfb_client_version(connection()->zeek_analyzer(),
				                                     connection()->zeek_analyzer()->Conn(),
				                                     to_stringval(major),
				                                     to_stringval(minor));

			connection()->zeek_analyzer()->AnalyzerConfirmation();
			}
		else
			{
			if ( rfb_server_version )
				zeek::BifEvent::enqueue_rfb_server_version(connection()->zeek_analyzer(),
				                                     connection()->zeek_analyzer()->Conn(),
				                                     to_stringval(major),
				                                     to_stringval(minor));
			}

		return true;
		
}

bool RFB_Flow::proc_rfb_share_flag(bool shared) {

		if ( rfb_share_flag )
			zeek::BifEvent::enqueue_rfb_share_flag(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), shared);
		return true;
		
}

bool RFB_Flow::proc_security_types(RFBSecurityType* msg) {

		if ( rfb_authentication_type )
			zeek::BifEvent::enqueue_rfb_authentication_type(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), msg->sectype());
		return true;
		
}

bool RFB_Flow::proc_security_types37(RFBAuthTypeSelected* msg) {

		if ( rfb_authentication_type )
			zeek::BifEvent::enqueue_rfb_authentication_type(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), msg->type());
		return true;
		
}

bool RFB_Flow::proc_handle_server_params(RFBServerInit* msg) {

		if ( rfb_server_parameters )
			{
			auto vec_ptr = msg->name();
			auto name_ptr = &((*vec_ptr)[0]);
			zeek::BifEvent::enqueue_rfb_server_parameters(
			    connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(),
			    zeek::make_intrusive<zeek::StringVal>(msg->name()->size(), reinterpret_cast<const char*>(name_ptr)),
			    msg->width(),
			    msg->height());
			}
		return true;
		
}

bool RFB_Flow::proc_handle_security_result(uint32 result) {

		// Remove in v9.1: rfb_auth_result should have been removed.
		if ( rfb_auth_result )
			zeek::BifEvent::enqueue_rfb_auth_result(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), result);

		if ( rfb_authentication_result )
			zeek::BifEvent::enqueue_rfb_authentication_result(connection()->zeek_analyzer(), connection()->zeek_analyzer()->Conn(), result == 0);
		return true;
		
}

} // namespace RFB
}  // namespace binpac
