// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/smb/smb_pac.h"

namespace binpac {






namespace SMB {
ContextSMB::ContextSMB(SMB_Conn* connection, SMB_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextSMB::~ContextSMB() {
}

SMB_Conn::SMB_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new SMB_Flow(this, true);
    downflow_ = new SMB_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		me = nullptr;
	

		gssapi = nullptr;
		ntlm = nullptr;
	

		// This needs to be set to some actual value.
		// TODO: figure out where the hell to get this value from...
		offset_len = 64;
	
}

SMB_Conn::~SMB_Conn() {

		// Iterate all of the analyzers and destroy them.
		for ( const auto& kv : fid_to_analyzer_map )
			{
			if ( kv.second )
				{
				kv.second->Done();
				delete kv.second;
				}
			}
	

		if ( gssapi )
			{
			gssapi->Done();
			delete gssapi;
			}

		if ( ntlm )
			{
			ntlm->Done();
			delete ntlm;
			}
	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SMB_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SMB_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SMB_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool SMB_Conn::store_this_unicode_string(SMB_unicode_string* s) {

		me = s;
		return true;
		
}

uint8 SMB_Conn::get_prev_elem() {

		if ( me && (me->s()->size() & 1) == 0 && me->s()->size() > 1 )
			{
			return me->s()->at(me->s()->size() - 2);
			}
		else
			return 0xFF;
		
}

bool SMB_Conn::get_tree_is_pipe(uint32 tree_id) {

		auto it = tree_is_pipe_map.find(tree_id);

		if ( it == tree_is_pipe_map.end() )
			return false;

		return it->second;
		
}

bool SMB_Conn::unset_tree_is_pipe(uint32 tree_id) {

		tree_is_pipe_map.erase(tree_id);
		return true;
		
}

bool SMB_Conn::set_tree_is_pipe(uint32 tree_id) {

		tree_is_pipe_map[tree_id] = true;
		return true;
		
}

bool SMB_Conn::forward_dce_rpc(bytestring const& pipe_data, uint64 fid, bool is_orig) {

		zeek::analyzer::dce_rpc::DCE_RPC_Analyzer *pipe_dcerpc = nullptr;
		auto it = fid_to_analyzer_map.find(fid);

		if ( it == fid_to_analyzer_map.end() )
			{
			// Too many analyzers?
			if ( zeek::BifConst::SMB::max_dce_rpc_analyzers > 0 &&
			     fid_to_analyzer_map.size() >= zeek::BifConst::SMB::max_dce_rpc_analyzers )
				{
				if ( smb_discarded_dce_rpc_analyzers )
					zeek::BifEvent::enqueue_smb_discarded_dce_rpc_analyzers(zeek_analyzer(), zeek_analyzer()->Conn());

				for ( const auto& kv : fid_to_analyzer_map )
					{
					kv.second->Done();
					delete kv.second;
					}

				fid_to_analyzer_map.clear();
				}

			auto tmp_analyzer = zeek::analyzer_mgr->InstantiateAnalyzer("DCE_RPC", zeek_analyzer()->Conn());
			pipe_dcerpc = static_cast<zeek::analyzer::dce_rpc::DCE_RPC_Analyzer *>(tmp_analyzer);

			if ( pipe_dcerpc )
				{
				pipe_dcerpc->SetFileID(fid);
				fid_to_analyzer_map[fid] = pipe_dcerpc;
				}
			}
		else
			{
			pipe_dcerpc = it->second;
			}

		if ( pipe_dcerpc )
			pipe_dcerpc->DeliverStream(pipe_data.length(), pipe_data.begin(), is_orig);

		return true;
		
}

bool SMB_Conn::forward_dce_rpc_close(uint64 fid) {

		auto it = fid_to_analyzer_map.find(fid);

		if ( it != fid_to_analyzer_map.end() )
			{
			it->second->Done();
			delete it->second;
			fid_to_analyzer_map.erase(it);
			return true;
			}

		return false;
		
}

bool SMB_Conn::forward_gssapi(bytestring const& data, bool is_orig) {

		if ( ! gssapi )
			gssapi = zeek::analyzer_mgr->InstantiateAnalyzer("GSSAPI", zeek_analyzer()->Conn());

		if ( ! ntlm )
			ntlm = zeek::analyzer_mgr->InstantiateAnalyzer("NTLM", zeek_analyzer()->Conn());

		// SMB allows raw NTLM instead of GSSAPI in certain messages.
		// We check if this is the case and run the NTLM analyzer directly.
		if ( data.length() >= 8 )
			{
			if ( strncmp(reinterpret_cast<const char*>(data.begin()), "NTLMSSP",7) == 0 )
				{
				if ( ntlm )
					ntlm->DeliverStream(data.length(), data.begin(), is_orig);
				}
			else
				{
				if ( gssapi )
					gssapi->DeliverStream(data.length(), data.begin(), is_orig);
				}
			}
		return true;
		
}

bool SMB_Conn::proc_smb1_check_directory_request(SMB_Header* header, SMB1_check_directory_request* val) {

		if ( smb1_check_directory_request )
			zeek::BifEvent::enqueue_smb1_check_directory_request(zeek_analyzer(),
			                                               zeek_analyzer()->Conn(),
			                                               SMBHeaderVal(header),
			                                               smb_string2stringval(val->directory_name()));
		return true;
		
}

bool SMB_Conn::proc_smb1_check_directory_response(SMB_Header* header, SMB1_check_directory_response* val) {

		if ( smb1_check_directory_response )
			zeek::BifEvent::enqueue_smb1_check_directory_response(zeek_analyzer(),
			                                                zeek_analyzer()->Conn(),
			                                                SMBHeaderVal(header));
		return true;
		
}

bool SMB_Conn::proc_smb1_close_request(SMB_Header* h, SMB1_close_request* val) {

		if ( smb1_close_request )
			zeek::BifEvent::enqueue_smb1_close_request(zeek_analyzer(),
			                                     zeek_analyzer()->Conn(),
			                                     SMBHeaderVal(h),
			                                     val->file_id());

		zeek::file_mgr->EndOfFile(zeek_analyzer()->GetAnalyzerTag(),
		                          zeek_analyzer()->Conn(), h->is_orig());

		return true;
		
}

bool SMB_Conn::proc_smb1_create_directory_request(SMB_Header* header, SMB1_create_directory_request* val) {

		if ( smb1_create_directory_request )
			zeek::BifEvent::enqueue_smb1_create_directory_request(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                                SMBHeaderVal(header),
			                                                smb_string2stringval(val->directory_name()));
		return true;
		
}

bool SMB_Conn::proc_smb1_create_directory_response(SMB_Header* header, SMB1_create_directory_response* val) {

		if ( smb1_create_directory_response )
			zeek::BifEvent::enqueue_smb1_create_directory_response(zeek_analyzer(),
			                                                 zeek_analyzer()->Conn(),
			                                                 SMBHeaderVal(header));
		return true;
		
}

bool SMB_Conn::proc_smb1_echo_request(SMB_Header* header, SMB1_echo_request* val) {

		if ( smb1_echo_request )
			zeek::BifEvent::enqueue_smb1_echo_request(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                    val->echo_count(), to_stringval(val->data()));
		return true;
		
}

bool SMB_Conn::proc_smb1_echo_response(SMB_Header* header, SMB1_echo_response* val) {

		if ( smb1_echo_response )
			zeek::BifEvent::enqueue_smb1_echo_response(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                     val->seq_num(), to_stringval(val->data()));
		return true;
		
}

bool SMB_Conn::proc_smb1_locking_andx_request(SMB_Header* header, SMB1_locking_andx_request* val) {

		//printf("locking_andx_request\n");
		return true;
		
}

bool SMB_Conn::proc_smb1_locking_andx_response(SMB_Header* header, SMB1_locking_andx_response* val) {

		//printf("locking_andx_response\n");
		return true;
		
}

bool SMB_Conn::proc_smb1_logoff_andx(SMB_Header* header, SMB1_logoff_andx* val) {

		if ( smb1_logoff_andx )
			zeek::BifEvent::enqueue_smb1_logoff_andx(zeek_analyzer(), zeek_analyzer()->Conn(), val->is_orig());

		return true;
		
}

bool SMB_Conn::proc_smb1_negotiate_request(SMB_Header* header, SMB1_negotiate_request* val) {

		if ( smb1_negotiate_request )
			{
			auto dialects = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

			for ( unsigned int i = 0; i < val->dialects()->size(); ++i )
				{
				auto dia = smb_string2stringval((*val->dialects())[i]->name());
				dialects->Assign(i, std::move(dia));
				}

			zeek::BifEvent::enqueue_smb1_negotiate_request(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                         SMBHeaderVal(header),
			                                         std::move(dialects));
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_negotiate_response(SMB_Header* header, SMB1_negotiate_response* val) {

		if ( smb1_negotiate_response )
			{
			auto response = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateResponse);

			switch ( val->word_count() )
				{
				case 0x01:
					{
					auto core = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateResponseCore);
					core->Assign(0, val->dialect_index());

					response->Assign(0, std::move(core));
					}
					break;

				case 0x0d:
					{
					auto security = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateResponseSecurity);
					security->Assign(0, val->lanman()->security_user_level());
					security->Assign(1, val->lanman()->security_challenge_response());

					auto raw = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateRawMode);
					raw->Assign(0, val->lanman()->raw_read_supported());
					raw->Assign(1, val->lanman()->raw_write_supported());

					auto lanman = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateResponseLANMAN);
					lanman->Assign(0, val->word_count());
					lanman->Assign(1, val->dialect_index());
					lanman->Assign(2, std::move(security));
					lanman->Assign(3, val->lanman()->max_buffer_size());
					lanman->Assign(4, val->lanman()->max_mpx_count());

					lanman->Assign(5, val->lanman()->max_number_vcs());
					lanman->Assign(6, std::move(raw));
					lanman->Assign(7, val->lanman()->session_key());
					lanman->Assign(8, time_from_lanman(val->lanman()->server_time(), val->lanman()->server_date(), val->lanman()->server_tz()));
					lanman->Assign(9, to_stringval(val->lanman()->encryption_key()));

					lanman->Assign(10, smb_string2stringval(val->lanman()->primary_domain()));

					response->Assign(1, std::move(lanman));
					}
					break;

				case 0x11:
					{
					auto security = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateResponseSecurity);
					security->Assign(0, val->ntlm()->security_user_level());
					security->Assign(1, val->ntlm()->security_challenge_response());
					security->Assign(2, val->ntlm()->security_signatures_enabled());
					security->Assign(3, val->ntlm()->security_signatures_required());

					auto capabilities = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateCapabilities);
					capabilities->Assign(0, val->ntlm()->capabilities_raw_mode());
					capabilities->Assign(1, val->ntlm()->capabilities_mpx_mode());
					capabilities->Assign(2, val->ntlm()->capabilities_unicode());
					capabilities->Assign(3, val->ntlm()->capabilities_large_files());
					capabilities->Assign(4, val->ntlm()->capabilities_nt_smbs());

					capabilities->Assign(5, val->ntlm()->capabilities_rpc_remote_apis());
					capabilities->Assign(6, val->ntlm()->capabilities_status32());
					capabilities->Assign(7, val->ntlm()->capabilities_level_2_oplocks());
					capabilities->Assign(8, val->ntlm()->capabilities_lock_and_read());
					capabilities->Assign(9, val->ntlm()->capabilities_nt_find());

					capabilities->Assign(10, val->ntlm()->capabilities_dfs());
					capabilities->Assign(11, val->ntlm()->capabilities_infolevel_passthru());
					capabilities->Assign(12, val->ntlm()->capabilities_large_readx());
					capabilities->Assign(13, val->ntlm()->capabilities_large_writex());
					capabilities->Assign(14, val->ntlm()->capabilities_unix());

					capabilities->Assign(15, val->ntlm()->capabilities_bulk_transfer());
					capabilities->Assign(16, val->ntlm()->capabilities_compressed_data());
					capabilities->Assign(17, val->ntlm()->capabilities_extended_security());

					auto ntlm = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::NegotiateResponseNTLM);
					ntlm->Assign(0, val->word_count());
					ntlm->Assign(1, val->dialect_index());
					ntlm->Assign(2, std::move(security));
					ntlm->Assign(3, val->ntlm()->max_buffer_size());
					ntlm->Assign(4, val->ntlm()->max_mpx_count());

					ntlm->Assign(5, val->ntlm()->max_number_vcs());
					ntlm->Assign(6, val->ntlm()->max_raw_size());
					ntlm->Assign(7, val->ntlm()->session_key());
					ntlm->Assign(8, std::move(capabilities));
					ntlm->Assign(9, filetime2zeektime(val->ntlm()->server_time()));

					if ( val->ntlm()->capabilities_extended_security() == false )
						{
						ntlm->Assign(10, to_stringval(val->ntlm()->encryption_key()));
						ntlm->Assign(11, smb_string2stringval(val->ntlm()->domain_name()));
						}
					else
						{
						ntlm->Assign(12, to_stringval(val->ntlm()->server_guid()));
						}

					response->Assign(2, std::move(ntlm));
					}
					break;
				}
			zeek::BifEvent::enqueue_smb1_negotiate_response(zeek_analyzer(),
			                                          zeek_analyzer()->Conn(),
			                                          SMBHeaderVal(header),
			                                          std::move(response));
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_nt_cancel_request(SMB_Header* header, SMB1_nt_cancel_request* val) {

		if ( smb1_nt_cancel_request )
			zeek::BifEvent::enqueue_smb1_nt_cancel_request(zeek_analyzer(),
			                                         zeek_analyzer()->Conn(),
			                                         SMBHeaderVal(header));
		return true;
		
}

bool SMB_Conn::proc_smb1_nt_create_andx_request(SMB_Header* header, SMB1_nt_create_andx_request* val) {

		auto filename = smb_string2stringval(val->filename());

		if ( ! header->is_pipe() &&
		     zeek::BifConst::SMB::pipe_filenames->AsTable()->Lookup(filename->CheckString()) )
			{
			set_tree_is_pipe(header->tid());

			if ( smb_pipe_connect_heuristic )
				zeek::BifEvent::enqueue_smb_pipe_connect_heuristic(zeek_analyzer(),
				                                             zeek_analyzer()->Conn());
			}

		if ( smb1_nt_create_andx_request )
			{
			zeek::BifEvent::enqueue_smb1_nt_create_andx_request(zeek_analyzer(),
			                                              zeek_analyzer()->Conn(),
			                                              SMBHeaderVal(header),
			                                              std::move(filename));
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_nt_create_andx_response(SMB_Header* header, SMB1_nt_create_andx_response* val) {

		if ( smb1_nt_create_andx_response )
			{
			zeek::BifEvent::enqueue_smb1_nt_create_andx_response(zeek_analyzer(),
			                                               zeek_analyzer()->Conn(),
			                                               SMBHeaderVal(header),
			                                               val->file_id(),
			                                               val->end_of_file(),
			                                               SMB_BuildMACTimes(val->last_write_time(),
			                                                                 val->last_access_time(),
			                                                                 val->create_time(),
			                                                                 val->last_change_time()));
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_nt_transact_request(SMB_Header* header, SMB1_nt_transact_request* val) {

		//printf("nt_transact_request\n");
		return true;
		
}

bool SMB_Conn::proc_smb1_nt_transact_response(SMB_Header* header, SMB1_nt_transact_response* val) {

		//printf("nt_transact_response\n");
		return true;
		
}

bool SMB_Conn::proc_smb1_query_information_request(SMB_Header* header, SMB1_query_information_request* val) {

		if ( smb1_query_information_request )
			zeek::BifEvent::enqueue_smb1_query_information_request(zeek_analyzer(),
			                                                 zeek_analyzer()->Conn(),
			                                                 SMBHeaderVal(header),
			                                                 smb_string2stringval(val->filename()));
		return true;
		
}

bool SMB_Conn::proc_smb1_query_information_response(SMB_Header* header, SMB1_query_information_response* val) {

		//printf("query_information_response\n");
		return true;
		
}

bool SMB_Conn::proc_smb1_read_andx_request(SMB_Header* h, SMB1_read_andx_request* val) {

		if ( smb1_read_andx_request )
			zeek::BifEvent::enqueue_smb1_read_andx_request(zeek_analyzer(),
			                                         zeek_analyzer()->Conn(),
			                                         SMBHeaderVal(h),
			                                         val->file_id(),
			                                         val->read_offset(),
			                                         val->max_count());

		read_offsets[h->mid()] = val->read_offset();
		return true;
		
}

bool SMB_Conn::proc_smb1_read_andx_response(SMB_Header* h, SMB1_read_andx_response* val) {

		if ( smb1_read_andx_response )
			zeek::BifEvent::enqueue_smb1_read_andx_response(zeek_analyzer(),
			                                          zeek_analyzer()->Conn(),
			                                          SMBHeaderVal(h),
			                                          val->data_len());

		if ( ! h->is_pipe() && val->data_len() > 0 )
			{
			uint64 offset = read_offsets[h->mid()];
			read_offsets.erase(h->mid());

			zeek::file_mgr->DataIn(val->data().begin(), val->data_len(), offset,
			                       zeek_analyzer()->GetAnalyzerTag(),
			                       zeek_analyzer()->Conn(), h->is_orig());
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_session_setup_andx_request(SMB_Header* header, SMB1_session_setup_andx_request* val) {

		if ( smb1_session_setup_andx_request )
			{
			auto request = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::SessionSetupAndXRequest);

			request->Assign(0, val->word_count());
			switch ( val->word_count() ) {
				case 10:	// pre NT LM 0.12
					request->Assign(1, val->lanman()->max_buffer_size());
					request->Assign(2, val->lanman()->max_mpx_count());
					request->Assign(3, val->lanman()->vc_number());
					request->Assign(4, val->lanman()->session_key());

					request->Assign(5, smb_string2stringval(val->lanman()->native_os()));
					request->Assign(6, smb_string2stringval(val->lanman()->native_lanman()));
					request->Assign(7, smb_string2stringval(val->lanman()->account_name()));
					request->Assign(8, to_stringval(val->lanman()->account_password()));
					request->Assign(9, smb_string2stringval(val->lanman()->primary_domain()));

					break;
				case 12:	// NT LM 0.12 with extended security
					{
					auto capabilities = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::SessionSetupAndXCapabilities);
					capabilities->Assign(0, val->ntlm_extended_security()->capabilities()->unicode());
					capabilities->Assign(1, val->ntlm_extended_security()->capabilities()->large_files());
					capabilities->Assign(2, val->ntlm_extended_security()->capabilities()->nt_smbs());
					capabilities->Assign(3, val->ntlm_extended_security()->capabilities()->status32());
					capabilities->Assign(4, val->ntlm_extended_security()->capabilities()->level_2_oplocks());
					capabilities->Assign(5, val->ntlm_extended_security()->capabilities()->nt_find());

					request->Assign(1, val->ntlm_extended_security()->max_buffer_size());
					request->Assign(2, val->ntlm_extended_security()->max_mpx_count());
					request->Assign(3, val->ntlm_extended_security()->vc_number());
					request->Assign(4, val->ntlm_extended_security()->session_key());

					request->Assign(5, smb_string2stringval(val->ntlm_extended_security()->native_os()));
					request->Assign(6, smb_string2stringval(val->ntlm_extended_security()->native_lanman()));

					request->Assign(13, std::move(capabilities));
					}
					break;

				case 13: // NT LM 0.12 without extended security
					{
					auto capabilities = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::SessionSetupAndXCapabilities);
					capabilities->Assign(0, val->ntlm_nonextended_security()->capabilities()->unicode());
					capabilities->Assign(1, val->ntlm_nonextended_security()->capabilities()->large_files());
					capabilities->Assign(2, val->ntlm_nonextended_security()->capabilities()->nt_smbs());
					capabilities->Assign(3, val->ntlm_nonextended_security()->capabilities()->status32());
					capabilities->Assign(4, val->ntlm_nonextended_security()->capabilities()->level_2_oplocks());
					capabilities->Assign(5, val->ntlm_nonextended_security()->capabilities()->nt_find());

					request->Assign(1, val->ntlm_nonextended_security()->max_buffer_size());
					request->Assign(2, val->ntlm_nonextended_security()->max_mpx_count());
					request->Assign(3, val->ntlm_nonextended_security()->vc_number());
					request->Assign(4, val->ntlm_nonextended_security()->session_key());

					request->Assign(5, smb_string2stringval(val->ntlm_nonextended_security()->native_os()));
					request->Assign(6, smb_string2stringval(val->ntlm_nonextended_security()->native_lanman()));
					request->Assign(7, smb_string2stringval(val->ntlm_nonextended_security()->account_name()));
					request->Assign(9, smb_string2stringval(val->ntlm_nonextended_security()->primary_domain()));

					request->Assign(10, to_stringval(val->ntlm_nonextended_security()->case_insensitive_password()));
					request->Assign(11, to_stringval(val->ntlm_nonextended_security()->case_sensitive_password()));
					request->Assign(13, std::move(capabilities));
					}
					break;
				}

			zeek::BifEvent::enqueue_smb1_session_setup_andx_request(zeek_analyzer(),
			                                                  zeek_analyzer()->Conn(),
			                                                  SMBHeaderVal(header),
			                                                  std::move(request));
			}
		return true;
		
}

bool SMB_Conn::proc_smb1_session_setup_andx_response(SMB_Header* header, SMB1_session_setup_andx_response* val) {

		if ( smb1_session_setup_andx_response )
			{
			auto response = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::SessionSetupAndXResponse);
			response->Assign(0, val->word_count());

			switch ( val->word_count() )
				{
				case 3: // pre NT LM 0.12
					response->Assign(1, val->lanman()->is_guest());
					response->Assign(2, val->lanman()->byte_count() == 0 ? zeek::val_mgr->EmptyString() : smb_string2stringval((*(val->lanman()->native_os()))[0]));
					response->Assign(3, val->lanman()->byte_count() == 0 ? zeek::val_mgr->EmptyString() : smb_string2stringval((*(val->lanman()->native_lanman()))[0]));
					response->Assign(4, val->lanman()->byte_count() == 0 ? zeek::val_mgr->EmptyString() : smb_string2stringval((*(val->lanman()->primary_domain()))[0]));
					break;
				case 4: // NT LM 0.12
					response->Assign(1, val->ntlm()->is_guest());
					response->Assign(2, smb_string2stringval(val->ntlm()->native_os()));
					response->Assign(3, smb_string2stringval(val->ntlm()->native_lanman()));
					//response->Assign(4, smb_string2stringval(${val.ntlm.primary_domain}));
					//response->Assign(5, to_stringval(${val.ntlm.security_blob}));
					break;
				default: // Error!
					break;
				}

			zeek::BifEvent::enqueue_smb1_session_setup_andx_response(zeek_analyzer(),
			                                                   zeek_analyzer()->Conn(),
			                                                   SMBHeaderVal(header),
			                                                   std::move(response));
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_transaction_secondary_request(SMB_Header* header, SMB1_transaction_secondary_request* val) {

	if ( ! smb1_transaction_secondary_request )
		return false;

	auto args = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::Trans_Sec_Args);
	args->Assign(0, val->total_param_count());
	args->Assign(1, val->total_data_count());
	args->Assign(2, val->param_count());
	args->Assign(3, val->param_offset());
	args->Assign(4, val->param_displacement());
	args->Assign(5, val->data_count());
	args->Assign(6, val->data_offset());
	args->Assign(7, val->data_displacement());

	auto parameters = zeek::make_intrusive<zeek::StringVal>(val->parameters().length(),
	                                            reinterpret_cast<const char*>(val->parameters().data()));
	zeek::StringValPtr payload_str;

	if ( val->data_count() > 0 )
		payload_str = transaction_data_to_val(val->data());
	else
		payload_str = zeek::val_mgr->EmptyString();

	zeek::BifEvent::enqueue_smb1_transaction_secondary_request(zeek_analyzer(),
	                                                     zeek_analyzer()->Conn(),
	                                                     SMBHeaderVal(header),
	                                                     std::move(args),
	                                                     std::move(parameters),
	                                                     std::move(payload_str));

	return true;
	
}

bool SMB_Conn::get_is_file_a_pipe(uint16 id) {

		if ( is_file_a_pipe.contains(id) )
			{
			bool is_pipe = is_file_a_pipe.at(id);
			is_file_a_pipe.erase(id);

			return is_pipe;
			}
		else
			return false;
		
}

bool SMB_Conn::set_is_file_a_pipe(uint16 id, bool is_it) {

		is_file_a_pipe[id] = is_it;
		return true;
		
}

bool SMB_Conn::proc_smb1_transaction_request(SMB_Header* header, SMB1_transaction_request* val) {

		if ( ! smb1_transaction_request )
			return false;

		auto parameters = zeek::make_intrusive<zeek::StringVal>(val->parameters().length(),
		                                                  reinterpret_cast<const char*>(val->parameters().data()));
		zeek::StringValPtr payload_str;

		if ( val->data_count() > 0 )
			payload_str = transaction_data_to_val(val->data());
		else
			payload_str = zeek::val_mgr->EmptyString();

		zeek::BifEvent::enqueue_smb1_transaction_request(zeek_analyzer(),
		                                           zeek_analyzer()->Conn(),
		                                           SMBHeaderVal(header),
		                                           smb_string2stringval(val->name()),
		                                           val->sub_cmd(),
		                                           std::move(parameters),
		                                           std::move(payload_str));

		return true;
		
}

bool SMB_Conn::proc_smb1_transaction_response(SMB_Header* header, SMB1_transaction_response* val) {

		if ( ! smb1_transaction_response )
			return false;

		auto parameters = zeek::make_intrusive<zeek::StringVal>(val->parameters().length(),
		                                                  reinterpret_cast<const char*>(val->parameters().data()));
		zeek::StringValPtr payload_str;

		if ( val->data_count() > 0 )
			payload_str = transaction_data_to_val((*(val->data()))[0]);
		else
			payload_str = zeek::val_mgr->EmptyString();

		zeek::BifEvent::enqueue_smb1_transaction_response(zeek_analyzer(),
		                                            zeek_analyzer()->Conn(),
		                                            SMBHeaderVal(header),
		                                            std::move(parameters),
		                                            std::move(payload_str));
		return true;
		
}

bool SMB_Conn::proc_smb1_transaction2_request(SMB_Header* header, SMB1_transaction2_request* val) {

		if ( smb1_transaction2_request )
			{
			auto args = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::Trans2_Args);
			args->Assign(0, val->total_param_count());
			args->Assign(1, val->total_data_count());
			args->Assign(2, val->max_param_count());
			args->Assign(3, val->max_data_count());
			args->Assign(4, val->max_setup_count());
			args->Assign(5, val->flags());
			args->Assign(6, val->timeout());
			args->Assign(7, val->param_count());
			args->Assign(8, val->param_offset());
			args->Assign(9, val->data_count());
			args->Assign(10, val->data_offset());
			args->Assign(11, val->setup_count());

			zeek::BifEvent::enqueue_smb1_transaction2_request(zeek_analyzer(),
			                                            zeek_analyzer()->Conn(),
			                                            SMBHeaderVal(header),
			                                            std::move(args),
			                                            val->sub_cmd());
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_transaction2_response(SMB_Header* header, SMB1_transaction2_response* val) {

		//if ( smb1_transaction2_response )
		//	zeek::BifEvent::enqueue_smb1_transaction2_response(zeek_analyzer(), zeek_analyzer()->Conn(), SMBHeaderVal(header), ${val.sub_cmd});
		return true;
		
}

bool SMB_Conn::proc_trans2_find_first2_request(SMB_Header* header, trans2_find_first2_request* val) {

		if ( smb1_trans2_find_first2_request )
			{
			auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::Find_First2_Request_Args);
			result->Assign(0, val->search_attrs());
			result->Assign(1, val->search_count());
			result->Assign(2, val->flags());
			result->Assign(3, val->info_level());
			result->Assign(4, val->search_storage_type());
			result->Assign(5, smb_string2stringval(val->file_name()));
			zeek::BifEvent::enqueue_smb1_trans2_find_first2_request(zeek_analyzer(),
			                                                        zeek_analyzer()->Conn(),
			                                                        SMBHeaderVal(header),
			                                                        std::move(result));

			}
		return true;
		
}

bool SMB_Conn::proc_trans2_find_first2_response(SMB_Header* header, trans2_find_first2_response* val) {

		// TODO: implement this.
		//printf("trans2_find_first2 response!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_query_fs_info_request(SMB_Header* header, trans2_query_fs_info_request* val) {

		// TODO: implement this.
		//printf("trans2_query_fs_info request!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_query_fs_info_response(SMB_Header* header, trans2_query_fs_info_response* val) {

		// TODO: implement this.
		//printf("trans2_query_fs_info response!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_query_path_info_request(SMB_Header* header, trans2_query_path_info_request* val) {

		if ( smb1_trans2_query_path_info_request )
			{
			zeek::BifEvent::enqueue_smb1_trans2_query_path_info_request(zeek_analyzer(),
			                                                      zeek_analyzer()->Conn(),
			                                                      SMBHeaderVal(header),
			                                                      smb_string2stringval(val->file_name()));
			}
		return true;
		
}

bool SMB_Conn::proc_trans2_query_path_info_response(SMB_Header* header, trans2_query_path_info_response* val) {

		// TODO: implement this.
		//printf("trans2_query_path_info response!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_query_file_info_request(SMB_Header* header, trans2_query_file_info_request* val) {

		// TODO: implement this.
		//printf("trans2_query_file_info request!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_query_file_info_response(SMB_Header* header, trans2_query_file_info_response* val) {

		// TODO: implement this.
		//printf("trans2_query_file_info response!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_set_file_info_request(SMB_Header* header, trans2_set_file_info_request* val) {

		// TODO: implement this.
		//printf("trans2_set_file_info request!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_set_file_info_response(SMB_Header* header, trans2_set_file_info_response* val) {

		// TODO: implement this.
		//printf("trans2_set_file_info response!\n");
		return true;
		
}

bool SMB_Conn::proc_trans2_get_dfs_referral_request(SMB_Header* header, trans2_get_dfs_referral_request* val) {

		if ( smb1_trans2_get_dfs_referral_request )
			{
			zeek::BifEvent::enqueue_smb1_trans2_get_dfs_referral_request(zeek_analyzer(),
			                                                       zeek_analyzer()->Conn(),
			                                                       SMBHeaderVal(header),
			                                                       smb_string2stringval(val->file_name()));
			}
		return true;
		
}

bool SMB_Conn::proc_trans2_get_dfs_referral_response(SMB_Header* header, trans2_get_dfs_referral_response* val) {

		// TODO: implement this.
		//printf("trans2_get_dfs_referral response!\n");
		return true;
		
}

bool SMB_Conn::proc_smb1_transaction2_secondary_request(SMB_Header* header, SMB1_transaction2_secondary_request* val) {

	if ( ! smb1_transaction2_secondary_request )
		return false;

	auto args = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::Trans2_Sec_Args);
	args->Assign(0, val->total_param_count());
	args->Assign(1, val->total_data_count());
	args->Assign(2, val->param_count());
	args->Assign(3, val->param_offset());
	args->Assign(4, val->param_displacement());
	args->Assign(5, val->data_count());
	args->Assign(6, val->data_offset());
	args->Assign(7, val->data_displacement());
	args->Assign(8, val->FID());

	auto parameters = zeek::make_intrusive<zeek::StringVal>(val->parameters().length(), reinterpret_cast<const char*>(val->parameters().data()));
	auto payload = zeek::make_intrusive<zeek::StringVal>(val->data().length(), reinterpret_cast<const char*>(val->data().data()));

	zeek::BifEvent::enqueue_smb1_transaction2_secondary_request(zeek_analyzer(),
	                                                      zeek_analyzer()->Conn(),
	                                                      SMBHeaderVal(header),
	                                                      std::move(args),
	                                                      std::move(parameters),
	                                                      std::move(payload));

	return true;
	
}

bool SMB_Conn::proc_smb1_tree_connect_andx_request(SMB_Header* header, SMB1_tree_connect_andx_request* val) {

		if ( smb1_tree_connect_andx_request )
			zeek::BifEvent::enqueue_smb1_tree_connect_andx_request(zeek_analyzer(),
			                                                 zeek_analyzer()->Conn(),
			                                                 SMBHeaderVal(header),
			                                                 smb_string2stringval(val->path()),
			                                                 smb_string2stringval(val->service()));
		return true;
		
}

bool SMB_Conn::proc_smb1_tree_connect_andx_response(SMB_Header* header, SMB1_tree_connect_andx_response* val) {

		auto service_string = smb_string2stringval(val->service());
		auto s = reinterpret_cast<const char*>(service_string->Bytes());

		if ( strncmp(s, "IPC", 3) == 0 )
			set_tree_is_pipe(header->tid());

		if ( smb1_tree_connect_andx_response )
			zeek::BifEvent::enqueue_smb1_tree_connect_andx_response(zeek_analyzer(),
			                                                  zeek_analyzer()->Conn(),
			                                                  SMBHeaderVal(header),
			                                                  std::move(service_string),
			                                                  val->byte_count() > val->service()->a()->size() ?
			                                                     smb_string2stringval((*(val->native_file_system()))[0]) :
			                                                     zeek::val_mgr->EmptyString());

		return true;
		
}

bool SMB_Conn::proc_smb1_tree_disconnect(SMB_Header* header, SMB1_tree_disconnect* val) {

		if ( smb1_tree_disconnect )
			zeek::BifEvent::enqueue_smb1_tree_disconnect(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       SMBHeaderVal(header),
			                                       val->is_orig());
		return true;
		
}

bool SMB_Conn::proc_smb1_write_andx_request(SMB_Header* h, SMB1_write_andx_request* val) {

		if ( smb1_write_andx_request )
			zeek::BifEvent::enqueue_smb1_write_andx_request(zeek_analyzer(),
			                                          zeek_analyzer()->Conn(),
			                                          SMBHeaderVal(h),
			                                          val->file_id(),
			                                          val->write_offset(),
			                                          val->data_len());

		if ( ! h->is_pipe() && val->data().length() > 0 )
			{
			zeek::file_mgr->DataIn(val->data().begin(), val->data().length(),
			                       val->write_offset(),
			                       zeek_analyzer()->GetAnalyzerTag(),
			                       zeek_analyzer()->Conn(), h->is_orig());
			}

		return true;
		
}

bool SMB_Conn::proc_smb1_write_andx_response(SMB_Header* h, SMB1_write_andx_response* val) {

		if ( smb1_write_andx_response )
			zeek::BifEvent::enqueue_smb1_write_andx_response(zeek_analyzer(),
			                                           zeek_analyzer()->Conn(),
			                                           SMBHeaderVal(h),
			                                           val->written_bytes());

		return true;
		
}

bool SMB_Conn::proc_smb2_close_request(SMB2_Header* h, SMB2_close_request* val) {

		if ( smb2_close_request )
			{
			zeek::BifEvent::enqueue_smb2_close_request(zeek_analyzer(),
			                                     zeek_analyzer()->Conn(),
			                                     BuildSMB2HeaderVal(h),
			                                     BuildSMB2GUID(val->file_id()));
			}

		zeek::file_mgr->EndOfFile(zeek_analyzer()->GetAnalyzerTag(),
		                          zeek_analyzer()->Conn(), h->is_orig());

		return true;
		
}

bool SMB_Conn::proc_smb2_close_response(SMB2_Header* h, SMB2_close_response* val) {

		if ( smb2_close_response )
			{
			auto resp = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::CloseResponse);

			resp->Assign(0, val->alloc_size());
			resp->Assign(1, val->eof());
			resp->Assign(2, SMB_BuildMACTimes(val->last_write_time(),
			                                  val->last_access_time(),
			                                  val->creation_time(),
			                                  val->change_time()));
			resp->Assign(3, smb2_file_attrs_to_zeek(val->file_attrs()));

			zeek::BifEvent::enqueue_smb2_close_response(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      BuildSMB2HeaderVal(h),
			                                      std::move(resp));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_create_request(SMB2_Header* h, SMB2_create_request* val) {

		auto filename = smb2_string2stringval(val->filename());

		if ( ! h->is_pipe() &&
		     zeek::BifConst::SMB::pipe_filenames->AsTable()->Lookup(filename->CheckString()) )
			{
			set_tree_is_pipe(h->tree_id());

			if ( smb_pipe_connect_heuristic )
				zeek::BifEvent::enqueue_smb_pipe_connect_heuristic(zeek_analyzer(),
				                                             zeek_analyzer()->Conn());
			}

		if ( smb2_create_request )
			{
			auto requestinfo = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::CreateRequest);
			requestinfo->Assign(0, std::move(filename));
			requestinfo->Assign(1, val->disposition());
			requestinfo->Assign(2, val->create_options());
			zeek::BifEvent::enqueue_smb2_create_request(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      BuildSMB2HeaderVal(h),
			                                      std::move(requestinfo));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_create_response(SMB2_Header* h, SMB2_create_response* val) {

		if ( smb2_create_response )
			{
			auto responseinfo = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::CreateResponse);
			responseinfo->Assign(0, BuildSMB2GUID(val->file_id()));
			responseinfo->Assign(1, val->eof());
			responseinfo->Assign(2, SMB_BuildMACTimes(val->last_write_time(),
			                                          val->last_access_time(),
			                                          val->creation_time(),
			                                          val->change_time()));
			responseinfo->Assign(3, smb2_file_attrs_to_zeek(val->file_attrs()));
			responseinfo->Assign(4, val->create_action());
			zeek::BifEvent::enqueue_smb2_create_response(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       BuildSMB2HeaderVal(h),
			                                       std::move(responseinfo));
			}

		return true;
		
}

uint64 SMB_Conn::get_ioctl_fid(uint64 message_id) {

		auto it = smb2_ioctl_fids.find(message_id);

		if ( it == smb2_ioctl_fids.end() )
			return 0;

		uint64 fid = it->second;
		smb2_ioctl_fids.erase(it);
		return fid;
		
}

bool SMB_Conn::proc_smb2_ioctl_request(SMB2_ioctl_request* val) {

		if ( zeek::BifConst::SMB::max_pending_messages > 0 &&
		     smb2_ioctl_fids.size() >= zeek::BifConst::SMB::max_pending_messages )
			{
			if ( smb2_discarded_messages_state )
				zeek::BifEvent::enqueue_smb2_discarded_messages_state(zeek_analyzer(), zeek_analyzer()->Conn(),
				                                                     zeek::make_intrusive<zeek::StringVal>("ioctl"));


			smb2_ioctl_fids.clear();
			}

		smb2_ioctl_fids[val->header()->message_id()] = val->file_id()->persistent() + val->file_id()->_volatile();
		return true;
		
}

bool SMB_Conn::proc_smb2_negotiate_request(SMB2_Header* h, SMB2_negotiate_request* val) {

		if ( smb2_negotiate_request )
			{
			auto dialects = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

			for ( unsigned int i = 0; i < val->dialects()->size(); ++i )
				dialects->Assign(i, zeek::val_mgr->Count((*val->dialects())[i]));

			zeek::BifEvent::enqueue_smb2_negotiate_request(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                         BuildSMB2HeaderVal(h),
			                                         std::move(dialects));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_negotiate_response(SMB2_Header* h, SMB2_negotiate_response* val) {

		if ( smb2_negotiate_response )
			{
			auto nr = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::NegotiateResponse);

			nr->Assign(0, val->dialect_revision());
			nr->Assign(1, val->security_mode());
			nr->Assign(2, BuildSMB2GUID(val->server_guid()));
			nr->Assign(3, filetime2zeektime(val->system_time()));
			nr->Assign(4, filetime2zeektime(val->server_start_time()));
			nr->Assign(5, val->negotiate_context_count());

			auto cv = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::SMB2::NegotiateContextValues);

			if ( val->dialect_revision() == 0x0311 && val->negotiate_context_count() > 0 )
				{
				for ( auto i = 0u; i < val->smb3_ncl()->list()->vals()->size(); ++i )
					cv->Assign(i, BuildSMB2ContextVal((*(val->smb3_ncl()->list()->vals()))[i]->ncv()));

				cv->Assign(val->smb3_ncl()->list()->vals()->size(), BuildSMB2ContextVal(val->smb3_ncl()->list()->last_val()));
				}

			nr->Assign(6, std::move(cv));

			zeek::BifEvent::enqueue_smb2_negotiate_response(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                                BuildSMB2HeaderVal(h),
			                                                std::move(nr));
			}

		return true;
		
}

uint64 SMB_Conn::get_file_id(uint64 message_id, bool forget) {

		auto it = smb2_read_fids.find(message_id);

		if ( it == smb2_read_fids.end() )
			return 0;

		uint64 fid = it->second;

		if ( forget )
			smb2_read_fids.erase(it);

		return fid;
		
}

bool SMB_Conn::proc_smb2_read_request(SMB2_Header* h, SMB2_read_request* val) {

		if ( smb2_read_request )
			{
			zeek::BifEvent::enqueue_smb2_read_request(zeek_analyzer(),
			                                    zeek_analyzer()->Conn(),
			                                    BuildSMB2HeaderVal(h),
			                                    BuildSMB2GUID(val->file_id()),
			                                    val->offset(),
			                                    val->read_len());
			}

		if ( zeek::BifConst::SMB::max_pending_messages > 0 &&
		     (smb2_read_offsets.size() >= zeek::BifConst::SMB::max_pending_messages ||
		      smb2_read_fids.size() >= zeek::BifConst::SMB::max_pending_messages) )
			{
			if ( smb2_discarded_messages_state )
				zeek::BifEvent::enqueue_smb2_discarded_messages_state(zeek_analyzer(), zeek_analyzer()->Conn(),
				                                                      zeek::make_intrusive<zeek::StringVal>("read"));
			smb2_read_offsets.clear();
			smb2_read_fids.clear();
			}

		smb2_read_offsets[h->message_id()] = val->offset();
		smb2_read_fids[h->message_id()] = val->file_id()->persistent() + val->file_id()->_volatile();

		return true;
		
}

bool SMB_Conn::proc_smb2_read_response(SMB2_Header* h, SMB2_read_response* val) {

		uint64 offset = smb2_read_offsets[h->message_id()];

		// If a PENDING status was received, keep this around.
		if ( h->status() != 0x00000103 )
			smb2_read_offsets.erase(h->message_id());

		if ( ! h->is_pipe() && val->data_len() > 0 )
			{
			zeek::file_mgr->DataIn(val->data().begin(), val->data_len(), offset,
			                       zeek_analyzer()->GetAnalyzerTag(),
			                       zeek_analyzer()->Conn(), h->is_orig());
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_session_setup_request(SMB2_Header* h, SMB2_session_setup_request* val) {

		if ( smb2_session_setup_request )
			{
			auto req = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::SessionSetupRequest);
			req->Assign(0, val->security_mode());

			zeek::BifEvent::enqueue_smb2_session_setup_request(zeek_analyzer(),
			                                             zeek_analyzer()->Conn(),
			                                             BuildSMB2HeaderVal(h),
			                                             std::move(req));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_session_setup_response(SMB2_Header* h, SMB2_session_setup_response* val) {

		if ( smb2_session_setup_response )
			{
			auto flags = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::SessionSetupFlags);
			flags->Assign(0, val->flag_guest());
			flags->Assign(1, val->flag_anonymous());
			flags->Assign(2, val->flag_encrypt());

			auto resp = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::SessionSetupResponse);
			resp->Assign(0, std::move(flags));

			zeek::BifEvent::enqueue_smb2_session_setup_response(zeek_analyzer(),
			                                              zeek_analyzer()->Conn(),
			                                              BuildSMB2HeaderVal(h),
			                                              std::move(resp));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file(SMB2_file_basic_info* val) {

		if ( smb2_file_sattr )
			zeek::BifEvent::enqueue_smb2_file_sattr(zeek_analyzer(),
			                                  zeek_analyzer()->Conn(),
			                                  BuildSMB2HeaderVal(val->sir()->header()),
			                                  BuildSMB2GUID(val->sir()->file_id()),
			                                  SMB_BuildMACTimes(val->last_write_time(),
			                                                    val->last_access_time(),
			                                                    val->creation_time(),
			                                                    val->change_time()),
			                                  smb2_file_attrs_to_zeek(val->file_attrs()));

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_rename(SMB2_file_rename_info* val) {

		if ( smb2_file_rename )
			zeek::BifEvent::enqueue_smb2_file_rename(zeek_analyzer(),
			                                   zeek_analyzer()->Conn(),
			                                   BuildSMB2HeaderVal(val->sir()->header()),
			                                   BuildSMB2GUID(val->sir()->file_id()),
			                                   smb2_string2stringval(val->filename()));

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_delete(SMB2_file_disposition_info* val) {

		if ( smb2_file_delete )
			zeek::BifEvent::enqueue_smb2_file_delete(zeek_analyzer(),
			                                   zeek_analyzer()->Conn(),
			                                   BuildSMB2HeaderVal(val->sir()->header()),
			                                   BuildSMB2GUID(val->sir()->file_id()),
			                                   (val->delete_pending() > 0));

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_allocation(SMB2_file_allocation_info* val) {

		if ( smb2_file_allocation )
			zeek::BifEvent::enqueue_smb2_file_allocation(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       BuildSMB2HeaderVal(val->sir()->header()),
			                                       BuildSMB2GUID(val->sir()->file_id()),
			                                       (val->allocation_size()));

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_endoffile(SMB2_file_endoffile_info* val) {

		if ( smb2_file_endoffile )
			zeek::BifEvent::enqueue_smb2_file_endoffile(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      BuildSMB2HeaderVal(val->sir()->header()),
			                                      BuildSMB2GUID(val->sir()->file_id()),
			                                      val->endoffile());

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_fullea(SMB2_file_fullea_info* val) {

		if ( smb2_file_fullea )
			{
			auto eas = zeek::make_intrusive<zeek::VectorVal>(zeek::BifType::Vector::SMB2::FileEAs);

			for ( auto i = 0u; i < val->ea_vector()->size(); ++i )
				{
				auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::FileEA);
				r->Assign(0, smb2_string2stringval((*(val->ea_vector()))[i]->ea_name()));
				r->Assign(1, smb2_string2stringval((*(val->ea_vector()))[i]->ea_value()));

				eas->Assign(i, std::move(r));
				}

			zeek::BifEvent::enqueue_smb2_file_fullea(zeek_analyzer(),
			                                   zeek_analyzer()->Conn(),
			                                   BuildSMB2HeaderVal(val->sir()->header()),
			                                   BuildSMB2GUID(val->sir()->file_id()),
			                                   std::move(eas));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_link(SMB2_file_link_info* val) {

		if ( smb2_file_link )
			zeek::BifEvent::enqueue_smb2_file_link(zeek_analyzer(),
			                                 zeek_analyzer()->Conn(),
			                                 BuildSMB2HeaderVal(val->sir()->header()),
			                                 BuildSMB2GUID(val->sir()->file_id()),
			                                 val->root_directory(),
			                                 smb2_string2stringval(val->file_name()));

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_mode(SMB2_file_mode_info* val) {

		if ( smb2_file_mode )
			zeek::BifEvent::enqueue_smb2_file_mode(zeek_analyzer(),
			                                 zeek_analyzer()->Conn(),
			                                 BuildSMB2HeaderVal(val->sir()->header()),
			                                 BuildSMB2GUID(val->sir()->file_id()),
			                                 val->mode());

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_pipe(SMB2_file_pipe_info* val) {

		if ( smb2_file_pipe )
			zeek::BifEvent::enqueue_smb2_file_pipe(zeek_analyzer(),
			                                 zeek_analyzer()->Conn(),
			                                 BuildSMB2HeaderVal(val->sir()->header()),
			                                 BuildSMB2GUID(val->sir()->file_id()),
			                                 val->read_mode(),
			                                 val->completion_mode());

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_position(SMB2_file_position_info* val) {

		if ( smb2_file_position )
			zeek::BifEvent::enqueue_smb2_file_position(zeek_analyzer(),
			                                     zeek_analyzer()->Conn(),
			                                     BuildSMB2HeaderVal(val->sir()->header()),
			                                     BuildSMB2GUID(val->sir()->file_id()),
			                                     val->current_byte_offset());

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_shortname(SMB2_file_shortname_info* val) {

		if ( smb2_file_shortname )
			zeek::BifEvent::enqueue_smb2_file_shortname(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      BuildSMB2HeaderVal(val->sir()->header()),
			                                      BuildSMB2GUID(val->sir()->file_id()),
			                                      smb2_string2stringval(val->filename()));

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_validdatalength(SMB2_file_validdatalength_info* val) {

		if ( smb2_file_validdatalength )
			zeek::BifEvent::enqueue_smb2_file_validdatalength(zeek_analyzer(),
			                                            zeek_analyzer()->Conn(),
			                                            BuildSMB2HeaderVal(val->sir()->header()),
			                                            BuildSMB2GUID(val->sir()->file_id()),
			                                            val->validdatalength());

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_fscontrol(SMB2_file_fscontrol_info* val) {

		if ( smb2_file_fscontrol )
			{
			auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::Fscontrol);
			r->Assign(0, static_cast<int>(val->free_space_start_filtering()));
			r->Assign(1, static_cast<int>(val->free_space_start_threshold()));
			r->Assign(2, static_cast<int>(val->free_space_stop_filtering()));
			r->Assign(3, val->default_quota_threshold());
			r->Assign(4, val->default_quota_limit());
			r->Assign(5, val->file_system_control_flags());

			zeek::BifEvent::enqueue_smb2_file_fscontrol(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      BuildSMB2HeaderVal(val->sir()->header()),
			                                      BuildSMB2GUID(val->sir()->file_id()),
			                                      std::move(r));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_set_info_request_file_fsobjectid(SMB2_file_fsobjectid_info* val) {

		if ( smb2_file_fsobjectid )
			zeek::BifEvent::enqueue_smb2_file_fsobjectid(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       BuildSMB2HeaderVal(val->sir()->header()),
			                                       BuildSMB2GUID(val->sir()->file_id()),
			                                       BuildSMB2GUID(val->object_id()),
			                                       smb2_string2stringval(val->extended_info()));

		return true;
		
}

bool SMB_Conn::proc_smb2_tree_connect_request(SMB2_Header* header, SMB2_tree_connect_request* val) {

		if ( smb2_tree_connect_request )
			zeek::BifEvent::enqueue_smb2_tree_connect_request(zeek_analyzer(),
			                                            zeek_analyzer()->Conn(),
			                                            BuildSMB2HeaderVal(header),
			                                            smb2_string2stringval(val->path()));

		return true;
		
}

bool SMB_Conn::proc_smb2_tree_connect_response(SMB2_Header* header, SMB2_tree_connect_response* val) {

		if ( val->share_type() == SMB2_SHARE_TYPE_PIPE )
			set_tree_is_pipe(header->tree_id());

		if ( smb2_tree_connect_response )
			{
			auto resp = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::TreeConnectResponse);
			resp->Assign(0, val->share_type());

			zeek::BifEvent::enqueue_smb2_tree_connect_response(zeek_analyzer(),
			                                             zeek_analyzer()->Conn(),
			                                             BuildSMB2HeaderVal(header),
			                                             std::move(resp));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_tree_disconnect_request(SMB2_Header* header) {

		unset_tree_is_pipe(header->tree_id());

		if ( smb2_tree_disconnect_request )
			{
			zeek::BifEvent::enqueue_smb2_tree_disconnect_request(zeek_analyzer(),
			                                               zeek_analyzer()->Conn(),
			                                               BuildSMB2HeaderVal(header));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_tree_disconnect_response(SMB2_Header* header) {

		if ( smb2_tree_disconnect_response )
			{
			zeek::BifEvent::enqueue_smb2_tree_disconnect_response(zeek_analyzer(),
			                                                zeek_analyzer()->Conn(),
			                                                BuildSMB2HeaderVal(header));
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_write_request(SMB2_Header* h, SMB2_write_request* val) {

		if ( smb2_write_request )
			{
			zeek::BifEvent::enqueue_smb2_write_request(zeek_analyzer(),
			                                     zeek_analyzer()->Conn(),
			                                     BuildSMB2HeaderVal(h),
			                                     BuildSMB2GUID(val->file_id()),
			                                     val->offset(),
			                                     val->data_len());
			}

		if ( ! h->is_pipe() && val->data().length() > 0 )
			{
			zeek::file_mgr->DataIn(val->data().begin(), val->data_len(), val->offset(),
			                       zeek_analyzer()->GetAnalyzerTag(),
			                       zeek_analyzer()->Conn(), h->is_orig());
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_write_response(SMB2_Header* h, SMB2_write_response* val) {


		if ( smb2_write_response )
			{
			zeek::BifEvent::enqueue_smb2_write_response(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      BuildSMB2HeaderVal(h),
			                                      val->write_count());
			}

		return true;
		
}

bool SMB_Conn::proc_smb2_transform_header(SMB2_transform_header* hdr) {

		if ( smb2_transform_header )
			{
			auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::Transform_header);
			r->Assign(0, to_stringval(hdr->signature()));
			r->Assign(1, to_stringval(hdr->nonce()));
			r->Assign(2, hdr->orig_msg_size());
			r->Assign(3, hdr->flags());
			r->Assign(4, hdr->session_id());

			zeek::BifEvent::enqueue_smb2_transform_header(zeek_analyzer(),
			                                        zeek_analyzer()->Conn(),
			                                        std::move(r));
			}

		return true;
		
}

uint32 SMB_Conn::join_pid_bits(uint16 hi, uint16 lo) {

		return (static_cast<uint32_t>(hi) << 16) | static_cast<uint32_t>(lo);
		
}

bool SMB_Conn::proc_smb_message(SMB_Header* h, bool is_orig) {

		if ( smb1_message )
			{
			zeek::BifEvent::enqueue_smb1_message(zeek_analyzer(), zeek_analyzer()->Conn(),
			                                SMBHeaderVal(h),
			                                is_orig);
			}
		return true;
		
}

bool SMB_Conn::proc_smb_empty_response(SMB_Header* header) {

		if ( smb1_empty_response )
			{
			zeek::BifEvent::enqueue_smb1_empty_response(zeek_analyzer(),
			                                      zeek_analyzer()->Conn(),
			                                      SMBHeaderVal(header));
			}
		return true;
		
}

bool SMB_Conn::proc_smb_no_msg(SMB_Header* h, bool is_orig) {

		if ( h->status() == STATUS_SUCCESS )
			{
			if ( smb1_empty_response )
				{
				zeek::BifEvent::enqueue_smb1_empty_response(zeek_analyzer(),
				                                      zeek_analyzer()->Conn(),
				                                      SMBHeaderVal(h));
				}
			}
		else
			{
			if ( smb1_error )
				zeek::BifEvent::enqueue_smb1_error(zeek_analyzer(),
				                             zeek_analyzer()->Conn(),
				                             SMBHeaderVal(h), is_orig);
			}
		return true;
		
}

int SMB_Conn::get_offset_len() {

		return offset_len;
		
}

bool SMB_Conn::proc_smb2_message(SMB2_Header* h, bool is_orig) {

		if ( is_orig )
			{
			if ( zeek::BifConst::SMB::max_pending_messages > 0 &&
			     smb2_request_tree_id.size() >= zeek::BifConst::SMB::max_pending_messages )
				{
				if ( smb2_discarded_messages_state )
					zeek::BifEvent::enqueue_smb2_discarded_messages_state(zeek_analyzer(), zeek_analyzer()->Conn(),
					                                                     zeek::make_intrusive<zeek::StringVal>("tree"));

				smb2_request_tree_id.clear();
				}

			// Store the tree_id
			smb2_request_tree_id[h->message_id()] = h->tree_id();
			}
		else
			{
			// Remove the stored tree_id unless the reply is pending.  It will
			// have already been used by the time this code is reached.
			if ( h->status() != 0x00000103 )
				{
				smb2_request_tree_id.erase(h->message_id());
				}
			}

		if ( smb2_message )
			{
			zeek::BifEvent::enqueue_smb2_message(zeek_analyzer(), zeek_analyzer()->Conn(),
			                               BuildSMB2HeaderVal(h), is_orig);
			}
		return true;
		
}

uint64 SMB_Conn::get_request_tree_id(uint64 message_id) {

		// This is stored at the request and used at the reply.
		auto it = smb2_request_tree_id.find(message_id);

		if ( it == smb2_request_tree_id.end() )
			return 0;

		return it->second;
		
}

bool SMB_Conn::is_error_response(SMB2_Header* header, bool is_orig) {

		// In an request, we ignore this field. Relevant documentation is
		// at [MS-SMB2] 2.2.1.1 SMB2 Packet Header

		// For SMB 3.x, it's the ChannelSequence field, followed by
		// the reserved field. In older dialects, the client MUST set
		// it to 0, and the server MUST ignore it.

		// I don't believe that we care about the ChannelSequence,
		// since that seems inconsequential to our parsing.

		if ( is_orig )
			return false;

		// In a response, this is parsed as the status of the request.

		// Non-zero USUALLY means an error, except for the specific cases detailed in
		// [MS-SMB2] 3.3.4.4 Sending an Error Response

		auto status = static_cast<SMB_Status>(header->status());

		switch ( status ) {
		case 0:
			// No error.
			return false;
		case STATUS_BUFFER_OVERFLOW:
			// SMB2_IOCTL is a bit loose, as it's only acceptable if the IOCTL
			// CtlCode is {FSCTL_PIPE_TRANSCEIVE, FSCTL_PIPE_PEEK, or
			// FSCTL_DFS_GETREFERRALS}, but we haven't parsed that yet.
			return ( header->command() != SMB2_IOCTL &&
			         header->command() != SMB2_QUERY_INFO &&
			         header->command() != SMB2_READ );
		case STATUS_INVALID_PARAMETER:
			// This is a bit loose, as it's only acceptable if the IOCTL
			// CtlCode is {FSCTL_SRV_COPYCHUNK or
			// FSCTL_SRV_COPYCHUNK_WRITE}, but we haven't parsed that yet.
			return header->command() != SMB2_IOCTL;
		case STATUS_MORE_PROCESSING_REQUIRED:
			// Return true (is_error) if it does NOT match this command
			return header->command() != SMB2_SESSION_SETUP;
		case STATUS_NOTIFY_ENUM_DIR:
			return header->command() != SMB2_CHANGE_NOTIFY;
		default:
			return true;
		}
		
}


zeek::StringValPtr binpac::SMB::SMB_Conn::uint8s_to_stringval(std::vector<uint8_t>* data)
	{
	int length = data->size();
	auto buf = std::make_unique<uint8[]>(length);

	for ( int i = 0; i < length; ++i)
		buf[i] = (*data)[i];

	const bytestring bs = bytestring(buf.get(), length);
	return utf16_to_utf8_val(zeek_analyzer()->Conn(), bs);
	}

zeek::StringValPtr binpac::SMB::SMB_Conn::extract_string(SMB_string* s)
	{
	if ( s->unicode() == false )
		{
		int length = s->a()->size();
		auto buf = std::make_unique<char[]>(length);

		for ( int i = 0; i < length; i++)
			{
			unsigned char t = (*(s->a()))[i];
			buf[i] = t;
			}

		if ( length > 0 && buf[length-1] == 0x00 )
			length--;

		return zeek::make_intrusive<zeek::StringVal>(length, buf.get());
		}
	else
		return uint8s_to_stringval(s->u()->s());
	}

zeek::StringValPtr binpac::SMB::SMB_Conn::smb_string2stringval(SMB_string* s)
	{
	return extract_string(s);
	}

zeek::StringValPtr binpac::SMB::SMB_Conn::smb2_string2stringval(SMB2_string* s)
	{
	return uint8s_to_stringval(s->s());
	}

SMB_ascii_string::SMB_ascii_string() {
    val_ = nullptr;
    val__elem_ = 0;
}

SMB_ascii_string::~SMB_ascii_string() {
    delete val_;
}

int SMB_ascii_string::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    int t_val__arraylength;
    t_val__arraylength = 0;
    val__elem_ = 0;
    int t_val__elem__it;
    t_val__elem__it = 0;
    int t_val__size;
    val_ = new vector<uint8>;
    const_byteptr t_val__elem__dataptr = t_begin_of_data;
    for (; /* forever */; ++t_val__elem__it) {
        // Check &until(val__elem__dataptr >= end_of_data)
        if ( t_val__elem__dataptr >= t_end_of_data ) {
            goto end_of_val;
        }
        // Checking out-of-bound for "SMB_ascii_string:val__elem"
        if ( t_val__elem__dataptr + (1) > t_end_of_data || t_val__elem__dataptr + (1) < t_val__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SMB_ascii_string:val__elem",
            	((t_val__elem__dataptr - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        val__elem_ = *(reinterpret_cast<uint8 const*>(t_val__elem__dataptr));
        val_->push_back(val__elem_);
        t_val__elem__dataptr += 1;
        BINPAC_ASSERT(t_val__elem__dataptr <= t_end_of_data);
        // Check &until( ( $element == ((int) 0x00) ) )
        if (  ( val__elem_ == 0x00 )  ) {
            goto end_of_val;
        }
    }
end_of_val: ;
    t_val__size = t_val__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB_unicode_string::SMB_unicode_string(int offset) {
    pad_ = nullptr;
    pad__elem_ = 0;
    prev_ = false;
    s_ = nullptr;
    s__elem_ = 0;
    offset_ = offset;
    byteorder_ = littleendian;
}

SMB_unicode_string::~SMB_unicode_string() {
    delete pad_;
    delete s_;
}

int SMB_unicode_string::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Parse "pad"
    int t_pad__arraylength;
    t_pad__arraylength = offset() & 1;
    if ( t_pad__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB_unicode_string:pad",
          t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB_unicode_string:pad
    if ( t_pad__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("SMB_unicode_string:pad",
          t_pad__arraylength, (t_end_of_data) - (t_begin_of_data));
    pad__elem_ = 0;
    int t_pad__elem__it;
    t_pad__elem__it = 0;
    int t_pad__size;
    pad_ = new vector<uint8>;
    pad_->reserve(t_pad__arraylength);
    const_byteptr t_pad__elem__dataptr = t_begin_of_data;
    for (; t_pad__elem__it < t_pad__arraylength; ++t_pad__elem__it) {
        pad__elem_ = *(reinterpret_cast<uint8 const*>(t_pad__elem__dataptr));
        pad_->push_back(pad__elem_);
        t_pad__elem__dataptr += 1;
        BINPAC_ASSERT(t_pad__elem__dataptr <= t_end_of_data);
    }
end_of_pad: ;
    t_pad__size = t_pad__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields
    prev_ = t_context->connection()->store_this_unicode_string(this);

    const_byteptr const t_dataptr_after_pad = t_begin_of_data + (t_pad__size);
    BINPAC_ASSERT(t_dataptr_after_pad <= t_end_of_data);
    // Parse "s"
    int t_s__arraylength;
    t_s__arraylength = 0;
    s__elem_ = 0;
    int t_s__elem__it;
    t_s__elem__it = 0;
    int t_s__size;
    s_ = new vector<uint8>;
    const_byteptr t_s__elem__dataptr = t_dataptr_after_pad;
    for (; /* forever */; ++t_s__elem__it) {
        // Check &until(s__elem__dataptr >= end_of_data)
        if ( t_s__elem__dataptr >= t_end_of_data ) {
            goto end_of_s;
        }
        // Checking out-of-bound for "SMB_unicode_string:s__elem"
        if ( t_s__elem__dataptr + (1) > t_end_of_data || t_s__elem__dataptr + (1) < t_s__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SMB_unicode_string:s__elem",
            	((t_s__elem__dataptr - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        s__elem_ = *(reinterpret_cast<uint8 const*>(t_s__elem__dataptr));
        s_->push_back(s__elem_);
        t_s__elem__dataptr += 1;
        BINPAC_ASSERT(t_s__elem__dataptr <= t_end_of_data);
        // Check &until( ( $element == ((int) 0x00) && @@$context->connection@->get_prev_elem@() == ((int) 0x00) ) )
        if (  ( s__elem_ == 0x00 && t_context->connection()->get_prev_elem() == 0x00 )  ) {
            goto end_of_s;
        }
    }
end_of_s: ;
    t_s__size = t_s__elem__dataptr - (t_dataptr_after_pad);
    // Evaluate 'let' and 'withinput' fields

    int t_SMB_unicode_string__size;
    const_byteptr const t_dataptr_after_s = t_dataptr_after_pad + (t_s__size);
    BINPAC_ASSERT(t_dataptr_after_s <= t_end_of_data);
    t_SMB_unicode_string__size = t_dataptr_after_s - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_unicode_string__size) <= t_end_of_data);
    return t_SMB_unicode_string__size;
}

SMB_string::SMB_string(bool unicode, int offset) {
    val_case_index_ = -1;
    u_ = nullptr;
    a_ = nullptr;
    unicode_ = unicode;
    offset_ = offset;
}

SMB_string::~SMB_string() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "u"
            {
                delete u_;
                u_ = nullptr;
            }
            break;
        case false:
            // Clean up "a"
            {
                delete a_;
                a_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_string::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = unicode();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "u"
            {
                u_ = new SMB_unicode_string(offset());
                int t_u__size;
                t_u__size = u_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_u__size;
            }
            break;
        case false:
            // Parse "a"
            {
                a_ = new SMB_ascii_string();
                int t_a__size;
                t_a__size = a_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_a__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB_string", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_string::SMB2_string(int len) {
    s_ = nullptr;
    s__elem_ = 0;
    len_ = len;
}

SMB2_string::~SMB2_string() {
    delete s_;
}

int SMB2_string::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "s"
    int t_s__arraylength;
    t_s__arraylength = len();
    if ( t_s__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB2_string:s",
          t_s__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB2_string:s
    if ( t_s__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("SMB2_string:s",
          t_s__arraylength, (t_end_of_data) - (t_begin_of_data));
    s__elem_ = 0;
    int t_s__elem__it;
    t_s__elem__it = 0;
    int t_s__size;
    s_ = new vector<uint8>;
    s_->reserve(t_s__arraylength);
    const_byteptr t_s__elem__dataptr = t_begin_of_data;
    for (; t_s__elem__it < t_s__arraylength; ++t_s__elem__it) {
        s__elem_ = *(reinterpret_cast<uint8 const*>(t_s__elem__dataptr));
        s_->push_back(s__elem_);
        t_s__elem__dataptr += 1;
        BINPAC_ASSERT(t_s__elem__dataptr <= t_end_of_data);
    }
end_of_s: ;
    t_s__size = t_s__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_string__size;
    const_byteptr const t_dataptr_after_s = t_begin_of_data + (t_s__size);
    BINPAC_ASSERT(t_dataptr_after_s <= t_end_of_data);
    t_SMB2_string__size = t_dataptr_after_s - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_string__size) <= t_end_of_data);
    return t_SMB2_string__size;
}

TransactionType determine_transaction_type(SMB_Header* header, SMB_string* name) {

	if ( name == nullptr )
		{
		return SMB_UNKNOWN;
		}

	if ( (header->unicode() && name->u()->s()->size() > 10 && (*(name->u()->s()))[0] == '\\' &&
	                                                       (*(name->u()->s()))[2] == 'P' &&
	                                                       (*(name->u()->s()))[4] == 'I' &&
	                                                       (*(name->u()->s()))[6] == 'P' &&
	                                                       (*(name->u()->s()))[8] == 'E' &&
	                                                       (*(name->u()->s()))[10] == '\\') ||
	     (!header->unicode() && name->a()->size() > 5 && name->a()->val()->at(0) == '\\' &&
	                                                     name->a()->val()->at(1) == 'P' &&
	                                                     name->a()->val()->at(2) == 'I' &&
	                                                     name->a()->val()->at(3) == 'P' &&
	                                                     name->a()->val()->at(4) == 'E' &&
	                                                     name->a()->val()->at(5) == '\\') )
		{
		if ( (header->unicode() && name->u()->s()->size() > 22 && (*(name->u()->s()))[12] == 'L' &&
		                                                       (*(name->u()->s()))[14] == 'A' &&
		                                                       (*(name->u()->s()))[16] == 'N' &&
		                                                       (*(name->u()->s()))[18] == 'M' &&
		                                                       (*(name->u()->s()))[20] == 'A' &&
		                                                       (*(name->u()->s()))[22] == 'N') ||
	         (!header->unicode() && name->a()->size() > 11 && name->a()->val()->at(6) == 'L' &&
	                                                          name->a()->val()->at(7) == 'A' &&
	                                                          name->a()->val()->at(8) == 'N' &&
	                                                          name->a()->val()->at(9) == 'M' &&
	                                                          name->a()->val()->at(10) == 'A' &&
	                                                          name->a()->val()->at(11) == 'N') )
			{
			return SMB_RAP;
			}

		return SMB_PIPE;
		}

	return SMB_UNKNOWN;
	
}


double filetime2zeektime(uint64_t ts)
	{
	// Zeek can't support times back to the 1600's
	// so we subtract a lot of seconds.
	return (static_cast<double>(ts) / 10000000.0) - 11644473600.0;
	}

double time_from_lanman(uint32_t smb_time, uint32_t smb_date, uint16_t tz)
	{
	tm lTime{0};

	// Lanman uses this format for time/date:
	// https://learn.microsoft.com/en-us/cpp/c-runtime-library/32-bit-windows-time-date-formats
	// Seconds is in 2-second increments in the data.
	lTime.tm_sec = (smb_time & 0x1f) * 2;
	lTime.tm_min = (smb_time >> 5) & 0x3f;
	lTime.tm_hour = (smb_time >> 11) & 0x1f;

	lTime.tm_mday = smb_date & 0x1f;
	// tm_mon is zero-indexed, so adjust for that.
	lTime.tm_mon = ((smb_date >> 5) & 0x0f) - 1;
	// The year in the data is the number of years from 1980, while tm_year is the
	// number of years since 1900.
	lTime.tm_year = ((smb_date >> 9) & 0x7f) + 80;
	lTime.tm_isdst = -1;

#ifndef _MSC_VER
	// The timezone passed in the data is the number of minutes from UTC, while
	// tm_gmtoff is the number of seconds east of UTC. Adjust for that. This field
	// is a POSIX extension that Windows doesn't support.
	lTime.tm_gmtoff = static_cast<long>(tz) * 60;
#endif

	return timegm(&lTime);
	}

zeek::RecordValPtr SMB_BuildMACTimes(uint64_t modify, uint64_t access,
                                     uint64_t create, uint64_t change)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB::MACTimes);
	r->Assign(0, filetime2zeektime(modify));
	r->Assign(1, modify);
	r->Assign(2, filetime2zeektime(access));
	r->Assign(3, access);
	r->Assign(4, filetime2zeektime(create));
	r->Assign(5, create);
	r->Assign(6, filetime2zeektime(change));
	r->Assign(7, change);
	return r;
	}

SMB_timestamp32::SMB_timestamp32() {
    val_ = 0;
}

SMB_timestamp32::~SMB_timestamp32() {
}

int SMB_timestamp32::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB_timestamp32:val"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_timestamp32:val",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB_timestamp::SMB_timestamp() {
    val_ = 0;
}

SMB_timestamp::~SMB_timestamp() {
}

int SMB_timestamp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB_timestamp:val"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_timestamp:val",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    val_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_begin_of_data)));
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SMB_MailSlot_message::SMB_MailSlot_message(bool unicode, uint16 byte_count) {
    opcode_ = 0;
    data_ = nullptr;
    unicode_ = unicode;
    byte_count_ = byte_count;
    byteorder_ = littleendian;
}

SMB_MailSlot_message::~SMB_MailSlot_message() {
    delete data_;
    data_ = nullptr;
}

int SMB_MailSlot_message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_message:opcode"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_message:opcode",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "opcode"
    opcode_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "data"
    data_ = new SMB_MailSlot_command(unicode(), opcode(), byte_count());
    int t_data__size;
    t_data__size = data_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);

    int t_SMB_MailSlot_message__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 1) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB_MailSlot_message__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_message__size) <= t_end_of_data);
    return t_SMB_MailSlot_message__size;
}

SMB_MailSlot_command::SMB_MailSlot_command(bool unicode, uint8 code, uint16 byte_count) {
    val_case_index_ = -1;
    announce_ = nullptr;
    announce_req_ = nullptr;
    election_req_ = nullptr;
    get_backup_req_ = nullptr;
    get_backup_resp_ = nullptr;
    domain_announce_ = nullptr;
    lm_announce_ = nullptr;
    unicode_ = unicode;
    code_ = code;
    byte_count_ = byte_count;
    byteorder_ = littleendian;
}

SMB_MailSlot_command::~SMB_MailSlot_command() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Clean up "announce"
            {
                delete announce_;
                announce_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "announce_req"
            {
                delete announce_req_;
                announce_req_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "election_req"
            {
                delete election_req_;
                election_req_ = nullptr;
            }
            break;
        case ((uint8)9):
            // Clean up "get_backup_req"
            {
                delete get_backup_req_;
                get_backup_req_ = nullptr;
            }
            break;
        case ((uint8)10):
            // Clean up "get_backup_resp"
            {
                delete get_backup_resp_;
                get_backup_resp_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "domain_announce"
            {
                delete domain_announce_;
                domain_announce_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "lm_announce"
            {
                delete lm_announce_;
                lm_announce_ = nullptr;
            }
            break;
        default:
            // Clean up "data"
            {
                data_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_MailSlot_command::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = code();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Parse "announce"
            {
                announce_ = new SMB_MailSlot_host_announcement(unicode());
                int t_announce__size;
                t_announce__size = announce_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_announce__size;
            }
            break;
        case ((uint8)2):
            // Parse "announce_req"
            {
                announce_req_ = new SMB_MailSlot_announcement_request(unicode());
                int t_announce_req__size;
                t_announce_req__size = announce_req_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_announce_req__size;
            }
            break;
        case ((uint8)8):
            // Parse "election_req"
            {
                election_req_ = new SMB_MailSlot_request_election(unicode());
                int t_election_req__size;
                t_election_req__size = election_req_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_election_req__size;
            }
            break;
        case ((uint8)9):
            // Parse "get_backup_req"
            {
                get_backup_req_ = new SMB_MailSlot_get_backup_list_request(unicode());
                get_backup_req_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = 5;
            }
            break;
        case ((uint8)10):
            // Parse "get_backup_resp"
            {
                get_backup_resp_ = new SMB_MailSlot_get_backup_list_response(unicode());
                int t_get_backup_resp__size;
                t_get_backup_resp__size = get_backup_resp_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_get_backup_resp__size;
            }
            break;
        case ((uint8)12):
            // Parse "domain_announce"
            {
                domain_announce_ = new SMB_MailSlot_domain_announcement(unicode());
                int t_domain_announce__size;
                t_domain_announce__size = domain_announce_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_domain_announce__size;
            }
            break;
        case ((uint8)15):
            // Parse "lm_announce"
            {
                lm_announce_ = new SMB_MailSlot_local_master_announcement(unicode());
                int t_lm_announce__size;
                t_lm_announce__size = lm_announce_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_lm_announce__size;
            }
            break;
        default:
            // Parse "data"
            {
                int t_data_string_length;
                t_data_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_data__size;
                t_data__size = t_data_string_length;
                // check for negative sizes
                if ( t_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb-mailslot.pac:29", t_data_string_length);
                data_.init(t_begin_of_data, t_data_string_length);
                t_val__size = t_data__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB_MailSlot_host_announcement::SMB_MailSlot_host_announcement(bool unicode) {
    update_count_ = 0;
    periodicity_ = 0;
    server_name_ = nullptr;
    os_major_ver_ = 0;
    os_minor_ver_ = 0;
    server_type_ = 0;
    bro_major_ver_ = 0;
    bro_minor_ver_ = 0;
    signature_ = 0;
    comment_ = nullptr;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_host_announcement::~SMB_MailSlot_host_announcement() {
    delete server_name_;
    server_name_ = nullptr;
    delete comment_;
    comment_ = nullptr;
}

int SMB_MailSlot_host_announcement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_host_announcement:periodicity"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_host_announcement:periodicity",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "update_count"
    update_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "periodicity"
    periodicity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "server_name"
    server_name_ = new SMB_string(unicode(), 5);
    int t_server_name__size;
    t_server_name__size = server_name_->Parse((t_begin_of_data + 5), t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_server_name = (t_begin_of_data + 5) + (t_server_name__size);
    BINPAC_ASSERT(t_dataptr_after_server_name <= t_end_of_data);
    // Checking out-of-bound for "SMB_MailSlot_host_announcement:signature"
    if ( (t_dataptr_after_server_name + 8) + (2) > t_end_of_data || (t_dataptr_after_server_name + 8) + (2) < (t_dataptr_after_server_name + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_host_announcement:signature",
        	(((t_dataptr_after_server_name + 8) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "os_major_ver"
    os_major_ver_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_server_name));

    // Parse "os_minor_ver"
    os_minor_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 1)));

    // Parse "server_type"
    server_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_server_name + 2))));

    // Parse "bro_major_ver"
    bro_major_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 6)));

    // Parse "bro_minor_ver"
    bro_minor_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 7)));

    // Parse "signature"
    signature_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_server_name + 8))));

    // Parse "comment"
    comment_ = new SMB_string(unicode(), ((t_dataptr_after_server_name + 10) - t_begin_of_data));
    int t_comment__size;
    t_comment__size = comment_->Parse((t_dataptr_after_server_name + 10), t_end_of_data, t_context);

    int t_SMB_MailSlot_host_announcement__size;
    const_byteptr const t_dataptr_after_comment = (t_dataptr_after_server_name + 10) + (t_comment__size);
    BINPAC_ASSERT(t_dataptr_after_comment <= t_end_of_data);
    t_SMB_MailSlot_host_announcement__size = t_dataptr_after_comment - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_host_announcement__size) <= t_end_of_data);
    return t_SMB_MailSlot_host_announcement__size;
}

SMB_MailSlot_announcement_request::SMB_MailSlot_announcement_request(bool unicode) {
    unused_ = 0;
    response_name_ = nullptr;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_announcement_request::~SMB_MailSlot_announcement_request() {
    delete response_name_;
    response_name_ = nullptr;
}

int SMB_MailSlot_announcement_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_announcement_request:unused"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_announcement_request:unused",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "unused"
    unused_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "response_name"
    response_name_ = new SMB_string(unicode(), 1);
    int t_response_name__size;
    t_response_name__size = response_name_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);

    int t_SMB_MailSlot_announcement_request__size;
    const_byteptr const t_dataptr_after_response_name = (t_begin_of_data + 1) + (t_response_name__size);
    BINPAC_ASSERT(t_dataptr_after_response_name <= t_end_of_data);
    t_SMB_MailSlot_announcement_request__size = t_dataptr_after_response_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_announcement_request__size) <= t_end_of_data);
    return t_SMB_MailSlot_announcement_request__size;
}

SMB_MailSlot_request_election::SMB_MailSlot_request_election(bool unicode) {
    version_ = 0;
    criteria_ = 0;
    uptime_ = 0;
    reserved_ = 0;
    server_name_ = nullptr;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_request_election::~SMB_MailSlot_request_election() {
    delete server_name_;
    server_name_ = nullptr;
}

int SMB_MailSlot_request_election::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_request_election:reserved"
    if ( (t_begin_of_data + 9) + (4) > t_end_of_data || (t_begin_of_data + 9) + (4) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_request_election:reserved",
        	(9) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "criteria"
    criteria_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "uptime"
    uptime_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Parse "reserved"
    reserved_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 9))));

    // Parse "server_name"
    server_name_ = new SMB_string(unicode(), 13);
    int t_server_name__size;
    t_server_name__size = server_name_->Parse((t_begin_of_data + 13), t_end_of_data, t_context);

    int t_SMB_MailSlot_request_election__size;
    const_byteptr const t_dataptr_after_server_name = (t_begin_of_data + 13) + (t_server_name__size);
    BINPAC_ASSERT(t_dataptr_after_server_name <= t_end_of_data);
    t_SMB_MailSlot_request_election__size = t_dataptr_after_server_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_request_election__size) <= t_end_of_data);
    return t_SMB_MailSlot_request_election__size;
}

SMB_MailSlot_get_backup_list_request::SMB_MailSlot_get_backup_list_request(bool unicode) {
    req_count_ = 0;
    token_ = 0;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_get_backup_list_request::~SMB_MailSlot_get_backup_list_request() {
}

int SMB_MailSlot_get_backup_list_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SMB_MailSlot_get_backup_list_request"
    if ( t_begin_of_data + (5) > t_end_of_data || t_begin_of_data + (5) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_get_backup_list_request",
        	(0) + (5), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "req_count"
    req_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "token"
    token_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (5) <= t_end_of_data);
    return 5;
}

SMB_MailSlot_get_backup_list_response::SMB_MailSlot_get_backup_list_response(bool unicode) {
    backup_count_ = 0;
    token_ = 0;
    backup_list_ = nullptr;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_get_backup_list_response::~SMB_MailSlot_get_backup_list_response() {
    delete backup_list_;
    backup_list_ = nullptr;
}

int SMB_MailSlot_get_backup_list_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_get_backup_list_response:token"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_get_backup_list_response:token",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "backup_count"
    backup_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "token"
    token_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "backup_list"
    backup_list_ = new SMB_string(unicode(), 5);
    int t_backup_list__size;
    t_backup_list__size = backup_list_->Parse((t_begin_of_data + 5), t_end_of_data, t_context);

    int t_SMB_MailSlot_get_backup_list_response__size;
    const_byteptr const t_dataptr_after_backup_list = (t_begin_of_data + 5) + (t_backup_list__size);
    BINPAC_ASSERT(t_dataptr_after_backup_list <= t_end_of_data);
    t_SMB_MailSlot_get_backup_list_response__size = t_dataptr_after_backup_list - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_get_backup_list_response__size) <= t_end_of_data);
    return t_SMB_MailSlot_get_backup_list_response__size;
}

SMB_MailSlot_domain_announcement::SMB_MailSlot_domain_announcement(bool unicode) {
    update_count_ = 0;
    periodicity_ = 0;
    server_name_ = nullptr;
    os_major_ver_ = 0;
    os_minor_ver_ = 0;
    server_type_ = 0;
    bro_major_ver_ = 0;
    bro_minor_ver_ = 0;
    signature_ = 0;
    comment_ = nullptr;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_domain_announcement::~SMB_MailSlot_domain_announcement() {
    delete server_name_;
    server_name_ = nullptr;
    delete comment_;
    comment_ = nullptr;
}

int SMB_MailSlot_domain_announcement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_domain_announcement:periodicity"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_domain_announcement:periodicity",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "update_count"
    update_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "periodicity"
    periodicity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "server_name"
    server_name_ = new SMB_string(unicode(), 5);
    int t_server_name__size;
    t_server_name__size = server_name_->Parse((t_begin_of_data + 5), t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_server_name = (t_begin_of_data + 5) + (t_server_name__size);
    BINPAC_ASSERT(t_dataptr_after_server_name <= t_end_of_data);
    // Checking out-of-bound for "SMB_MailSlot_domain_announcement:signature"
    if ( (t_dataptr_after_server_name + 8) + (2) > t_end_of_data || (t_dataptr_after_server_name + 8) + (2) < (t_dataptr_after_server_name + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_domain_announcement:signature",
        	(((t_dataptr_after_server_name + 8) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "os_major_ver"
    os_major_ver_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_server_name));

    // Parse "os_minor_ver"
    os_minor_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 1)));

    // Parse "server_type"
    server_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_server_name + 2))));

    // Parse "bro_major_ver"
    bro_major_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 6)));

    // Parse "bro_minor_ver"
    bro_minor_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 7)));

    // Parse "signature"
    signature_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_server_name + 8))));

    // Parse "comment"
    comment_ = new SMB_string(unicode(), ((t_dataptr_after_server_name + 10) - t_begin_of_data));
    int t_comment__size;
    t_comment__size = comment_->Parse((t_dataptr_after_server_name + 10), t_end_of_data, t_context);

    int t_SMB_MailSlot_domain_announcement__size;
    const_byteptr const t_dataptr_after_comment = (t_dataptr_after_server_name + 10) + (t_comment__size);
    BINPAC_ASSERT(t_dataptr_after_comment <= t_end_of_data);
    t_SMB_MailSlot_domain_announcement__size = t_dataptr_after_comment - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_domain_announcement__size) <= t_end_of_data);
    return t_SMB_MailSlot_domain_announcement__size;
}

SMB_MailSlot_local_master_announcement::SMB_MailSlot_local_master_announcement(bool unicode) {
    update_count_ = 0;
    periodicity_ = 0;
    server_name_ = nullptr;
    os_major_ver_ = 0;
    os_minor_ver_ = 0;
    server_type_ = 0;
    bro_major_ver_ = 0;
    bro_minor_ver_ = 0;
    signature_ = 0;
    comment_ = nullptr;
    unicode_ = unicode;
    byteorder_ = littleendian;
}

SMB_MailSlot_local_master_announcement::~SMB_MailSlot_local_master_announcement() {
    delete server_name_;
    server_name_ = nullptr;
    delete comment_;
    comment_ = nullptr;
}

int SMB_MailSlot_local_master_announcement::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_MailSlot_local_master_announcement:periodicity"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_local_master_announcement:periodicity",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "update_count"
    update_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "periodicity"
    periodicity_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "server_name"
    server_name_ = new SMB_string(unicode(), 5);
    int t_server_name__size;
    t_server_name__size = server_name_->Parse((t_begin_of_data + 5), t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_server_name = (t_begin_of_data + 5) + (t_server_name__size);
    BINPAC_ASSERT(t_dataptr_after_server_name <= t_end_of_data);
    // Checking out-of-bound for "SMB_MailSlot_local_master_announcement:signature"
    if ( (t_dataptr_after_server_name + 8) + (2) > t_end_of_data || (t_dataptr_after_server_name + 8) + (2) < (t_dataptr_after_server_name + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_MailSlot_local_master_announcement:signature",
        	(((t_dataptr_after_server_name + 8) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "os_major_ver"
    os_major_ver_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_server_name));

    // Parse "os_minor_ver"
    os_minor_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 1)));

    // Parse "server_type"
    server_type_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_dataptr_after_server_name + 2))));

    // Parse "bro_major_ver"
    bro_major_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 6)));

    // Parse "bro_minor_ver"
    bro_minor_ver_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_server_name + 7)));

    // Parse "signature"
    signature_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_server_name + 8))));

    // Parse "comment"
    comment_ = new SMB_string(unicode(), ((t_dataptr_after_server_name + 10) - t_begin_of_data));
    int t_comment__size;
    t_comment__size = comment_->Parse((t_dataptr_after_server_name + 10), t_end_of_data, t_context);

    int t_SMB_MailSlot_local_master_announcement__size;
    const_byteptr const t_dataptr_after_comment = (t_dataptr_after_server_name + 10) + (t_comment__size);
    BINPAC_ASSERT(t_dataptr_after_comment <= t_end_of_data);
    t_SMB_MailSlot_local_master_announcement__size = t_dataptr_after_comment - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_MailSlot_local_master_announcement__size) <= t_end_of_data);
    return t_SMB_MailSlot_local_master_announcement__size;
}

SMB1_check_directory_request::SMB1_check_directory_request(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    buffer_format_ = 0;
    directory_name_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_check_directory_request::~SMB1_check_directory_request() {
    delete directory_name_;
    directory_name_ = nullptr;
}

int SMB1_check_directory_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_check_directory_request:buffer_format"
    if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_check_directory_request:buffer_format",
        	(3) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "buffer_format"
    buffer_format_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "directory_name"
    directory_name_ = new SMB_string(header()->unicode(), 4);
    int t_directory_name__size;
    t_directory_name__size = directory_name_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);

    int t_SMB1_check_directory_request__size;
    const_byteptr const t_dataptr_after_directory_name = (t_begin_of_data + 4) + (t_directory_name__size);
    BINPAC_ASSERT(t_dataptr_after_directory_name <= t_end_of_data);
    t_SMB1_check_directory_request__size = t_dataptr_after_directory_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_check_directory_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_check_directory_request__size) <= t_end_of_data);
    return t_SMB1_check_directory_request__size;
}

SMB1_check_directory_response::SMB1_check_directory_response(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_check_directory_response::~SMB1_check_directory_response() {
}

int SMB1_check_directory_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_check_directory_response"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_check_directory_response",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_check_directory_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

SMB1_close_request::SMB1_close_request(SMB_Header* header) {
    word_count_ = 0;
    file_id_ = 0;
    last_modified_time_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_close_request::~SMB1_close_request() {
}

int SMB1_close_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_close_request"
    if ( t_begin_of_data + (9) > t_end_of_data || t_begin_of_data + (9) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_close_request",
        	(0) + (9), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "file_id"
    file_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "last_modified_time"
    last_modified_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_close_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (9) <= t_end_of_data);
    return 9;
}

SMB1_create_directory_request::SMB1_create_directory_request(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    buffer_format_ = 0;
    directory_name_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_create_directory_request::~SMB1_create_directory_request() {
    delete directory_name_;
    directory_name_ = nullptr;
}

int SMB1_create_directory_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_create_directory_request:buffer_format"
    if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_create_directory_request:buffer_format",
        	(3) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "buffer_format"
    buffer_format_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "directory_name"
    directory_name_ = new SMB_string(header()->unicode(), 4);
    int t_directory_name__size;
    t_directory_name__size = directory_name_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);

    int t_SMB1_create_directory_request__size;
    const_byteptr const t_dataptr_after_directory_name = (t_begin_of_data + 4) + (t_directory_name__size);
    BINPAC_ASSERT(t_dataptr_after_directory_name <= t_end_of_data);
    t_SMB1_create_directory_request__size = t_dataptr_after_directory_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_create_directory_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_create_directory_request__size) <= t_end_of_data);
    return t_SMB1_create_directory_request__size;
}

SMB1_create_directory_response::SMB1_create_directory_response(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_create_directory_response::~SMB1_create_directory_response() {
}

int SMB1_create_directory_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_create_directory_response"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_create_directory_response",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_create_directory_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

SMB1_echo_request::SMB1_echo_request(SMB_Header* header) {
    word_count_ = 0;
    echo_count_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_echo_request::~SMB1_echo_request() {
    data_.free();
}

int SMB1_echo_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_echo_request:byte_count"
    if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_echo_request:byte_count",
        	(3) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "echo_count"
    echo_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "data"
    int t_data__size;
    t_data__size = byte_count();
    // Checking out-of-bound for "SMB1_echo_request:data"
    if ( (t_begin_of_data + 5) + (t_data__size) > t_end_of_data || (t_begin_of_data + 5) + (t_data__size) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_echo_request:data",
        	(5) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_data__size;
        int t_data_string_length;
        t_data_string_length = byte_count();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-echo.pac:28", t_data_string_length);
        data_.init((t_begin_of_data + 5), t_data_string_length);
    }

    int t_SMB1_echo_request__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 5) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB1_echo_request__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_echo_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_echo_request__size) <= t_end_of_data);
    return t_SMB1_echo_request__size;
}

SMB1_echo_response::SMB1_echo_response(SMB_Header* header) {
    word_count_ = 0;
    seq_num_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_echo_response::~SMB1_echo_response() {
    data_.free();
}

int SMB1_echo_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_echo_response:byte_count"
    if ( (t_begin_of_data + 3) + (2) > t_end_of_data || (t_begin_of_data + 3) + (2) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_echo_response:byte_count",
        	(3) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "seq_num"
    seq_num_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "data"
    int t_data__size;
    t_data__size = byte_count();
    // Checking out-of-bound for "SMB1_echo_response:data"
    if ( (t_begin_of_data + 5) + (t_data__size) > t_end_of_data || (t_begin_of_data + 5) + (t_data__size) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_echo_response:data",
        	(5) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_data__size;
        int t_data_string_length;
        t_data_string_length = byte_count();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-echo.pac:39", t_data_string_length);
        data_.init((t_begin_of_data + 5), t_data_string_length);
    }

    int t_SMB1_echo_response__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 5) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB1_echo_response__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_echo_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_echo_response__size) <= t_end_of_data);
    return t_SMB1_echo_response__size;
}

LOCKING_ANDX_RANGE32::LOCKING_ANDX_RANGE32() {
    pid_ = 0;
    byte_offset_ = 0;
    byte_len_ = 0;
}

LOCKING_ANDX_RANGE32::~LOCKING_ANDX_RANGE32() {
}

int LOCKING_ANDX_RANGE32::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "LOCKING_ANDX_RANGE32"
    if ( t_begin_of_data + (10) > t_end_of_data || t_begin_of_data + (10) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("LOCKING_ANDX_RANGE32",
        	(0) + (10), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "pid"
    pid_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "byte_offset"
    byte_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "byte_len"
    byte_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 6))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (10) <= t_end_of_data);
    return 10;
}

LOCKING_ANDX_RANGE64::LOCKING_ANDX_RANGE64() {
    pid_ = 0;
    pad_ = 0;
    byte_offset_ = 0;
    byte_len_ = 0;
}

LOCKING_ANDX_RANGE64::~LOCKING_ANDX_RANGE64() {
}

int LOCKING_ANDX_RANGE64::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "LOCKING_ANDX_RANGE64"
    if ( t_begin_of_data + (20) > t_end_of_data || t_begin_of_data + (20) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("LOCKING_ANDX_RANGE64",
        	(0) + (20), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "pid"
    pid_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "pad"
    pad_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "byte_offset"
    byte_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 4))));

    // Parse "byte_len"
    byte_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 12))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (20) <= t_end_of_data);
    return 20;
}

SMB1_locking_andx_request::SMB1_locking_andx_request(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    file_id_ = 0;
    type_of_lock_ = 0;
    new_op_lock_level_ = 0;
    timeout_ = 0;
    num_requested_unlocks_ = 0;
    num_requested_locks_ = 0;
    bytecount_ = 0;
    unlocks_case_index_ = -1;
    unlocks32_ = nullptr;
    unlocks32__elem_ = nullptr;
    unlocks64_ = nullptr;
    unlocks64__elem_ = nullptr;
    locks_case_index_ = -1;
    locks32_ = nullptr;
    locks32__elem_ = nullptr;
    locks64_ = nullptr;
    locks64__elem_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_locking_andx_request::~SMB1_locking_andx_request() {
    delete andx_;
    andx_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( unlocks_case_index() ) {
        case ((int)32):
            // Clean up "unlocks32"
            {
                delete unlocks32__elem_;
                unlocks32__elem_ = nullptr;
                if ( unlocks32() ) {
                    for ( auto* unlocks32__elem_ : *unlocks32() ) {
                        delete unlocks32__elem_;
                        unlocks32__elem_ = nullptr;
                    }
                }
                delete unlocks32_;
            }
            break;
        case ((int)64):
            // Clean up "unlocks64"
            {
                delete unlocks64__elem_;
                unlocks64__elem_ = nullptr;
                if ( unlocks64() ) {
                    for ( auto* unlocks64__elem_ : *unlocks64() ) {
                        delete unlocks64__elem_;
                        unlocks64__elem_ = nullptr;
                    }
                }
                delete unlocks64_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( locks_case_index() ) {
        case ((int)32):
            // Clean up "locks32"
            {
                delete locks32__elem_;
                locks32__elem_ = nullptr;
                if ( locks32() ) {
                    for ( auto* locks32__elem_ : *locks32() ) {
                        delete locks32__elem_;
                        locks32__elem_ = nullptr;
                    }
                }
                delete locks32_;
            }
            break;
        case ((int)64):
            // Clean up "locks64"
            {
                delete locks64__elem_;
                locks64__elem_ = nullptr;
                if ( locks64() ) {
                    for ( auto* locks64__elem_ : *locks64() ) {
                        delete locks64__elem_;
                        locks64__elem_ = nullptr;
                    }
                }
                delete locks64_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_locking_andx_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_locking_andx_request:bytecount"
    if ( (t_begin_of_data + 17) + (2) > t_end_of_data || (t_begin_of_data + 17) + (2) < (t_begin_of_data + 17) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:bytecount",
        	(17) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "file_id"
    file_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "type_of_lock"
    type_of_lock_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 7)));

    // Parse "new_op_lock_level"
    new_op_lock_level_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 8)));

    // Parse "timeout"
    timeout_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 9))));

    // Parse "num_requested_unlocks"
    num_requested_unlocks_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "num_requested_locks"
    num_requested_locks_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "bytecount"
    bytecount_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "unlocks"
    int t_unlocks__size;
    unlocks_case_index_ = t_context->connection()->get_offset_len();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( unlocks_case_index() ) {
        case ((int)32):
            // Parse "unlocks32"
            {
                int t_unlocks32__arraylength;
                t_unlocks32__arraylength = num_requested_unlocks();
                if ( t_unlocks32__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:unlocks32",
                      t_unlocks32__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: SMB1_locking_andx_request:unlocks32
                if ( t_unlocks32__arraylength > ((t_end_of_data - (t_begin_of_data + 19)) / 10) )
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:unlocks32",
                      t_unlocks32__arraylength, (t_end_of_data) - ((t_begin_of_data + 19)));
                unlocks32__elem_ = nullptr;
                int t_unlocks32__elem__it;
                t_unlocks32__elem__it = 0;
                int t_unlocks32__size;
                unlocks32_ = new vector<LOCKING_ANDX_RANGE32*>;
                unlocks32_->reserve(t_unlocks32__arraylength);
                const_byteptr t_unlocks32__elem__dataptr = (t_begin_of_data + 19);
                for (; t_unlocks32__elem__it < t_unlocks32__arraylength; ++t_unlocks32__elem__it) {
                    unlocks32__elem_ = new LOCKING_ANDX_RANGE32();
                    unlocks32__elem_->Parse(t_unlocks32__elem__dataptr, t_end_of_data, t_byteorder);
                    unlocks32_->push_back(unlocks32__elem_);
                    t_unlocks32__elem__dataptr += 10;
                    BINPAC_ASSERT(t_unlocks32__elem__dataptr <= t_end_of_data);
                    unlocks32__elem_ = nullptr;
                }
            end_of_unlocks32: ;
                t_unlocks32__size = t_unlocks32__elem__dataptr - ((t_begin_of_data + 19));
                // Evaluate 'let' and 'withinput' fields
                t_unlocks__size = t_unlocks32__size;
            }
            break;
        case ((int)64):
            // Parse "unlocks64"
            {
                int t_unlocks64__arraylength;
                t_unlocks64__arraylength = num_requested_unlocks();
                if ( t_unlocks64__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:unlocks64",
                      t_unlocks64__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: SMB1_locking_andx_request:unlocks64
                if ( t_unlocks64__arraylength > ((t_end_of_data - (t_begin_of_data + 19)) / 20) )
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:unlocks64",
                      t_unlocks64__arraylength, (t_end_of_data) - ((t_begin_of_data + 19)));
                unlocks64__elem_ = nullptr;
                int t_unlocks64__elem__it;
                t_unlocks64__elem__it = 0;
                int t_unlocks64__size;
                unlocks64_ = new vector<LOCKING_ANDX_RANGE64*>;
                unlocks64_->reserve(t_unlocks64__arraylength);
                const_byteptr t_unlocks64__elem__dataptr = (t_begin_of_data + 19);
                for (; t_unlocks64__elem__it < t_unlocks64__arraylength; ++t_unlocks64__elem__it) {
                    unlocks64__elem_ = new LOCKING_ANDX_RANGE64();
                    unlocks64__elem_->Parse(t_unlocks64__elem__dataptr, t_end_of_data, t_byteorder);
                    unlocks64_->push_back(unlocks64__elem_);
                    t_unlocks64__elem__dataptr += 20;
                    BINPAC_ASSERT(t_unlocks64__elem__dataptr <= t_end_of_data);
                    unlocks64__elem_ = nullptr;
                }
            end_of_unlocks64: ;
                t_unlocks64__size = t_unlocks64__elem__dataptr - ((t_begin_of_data + 19));
                // Evaluate 'let' and 'withinput' fields
                t_unlocks__size = t_unlocks64__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_locking_andx_request", (int64)unlocks_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_unlocks = (t_begin_of_data + 19) + (t_unlocks__size);
    BINPAC_ASSERT(t_dataptr_after_unlocks <= t_end_of_data);
    // Parse "locks"
    int t_locks__size;
    locks_case_index_ = t_context->connection()->get_offset_len();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( locks_case_index() ) {
        case ((int)32):
            // Parse "locks32"
            {
                int t_locks32__arraylength;
                t_locks32__arraylength = num_requested_locks();
                if ( t_locks32__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:locks32",
                      t_locks32__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: SMB1_locking_andx_request:locks32
                if ( t_locks32__arraylength > ((t_end_of_data - t_dataptr_after_unlocks) / 10) )
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:locks32",
                      t_locks32__arraylength, (t_end_of_data) - (t_dataptr_after_unlocks));
                locks32__elem_ = nullptr;
                int t_locks32__elem__it;
                t_locks32__elem__it = 0;
                int t_locks32__size;
                locks32_ = new vector<LOCKING_ANDX_RANGE32*>;
                locks32_->reserve(t_locks32__arraylength);
                const_byteptr t_locks32__elem__dataptr = t_dataptr_after_unlocks;
                for (; t_locks32__elem__it < t_locks32__arraylength; ++t_locks32__elem__it) {
                    locks32__elem_ = new LOCKING_ANDX_RANGE32();
                    locks32__elem_->Parse(t_locks32__elem__dataptr, t_end_of_data, t_byteorder);
                    locks32_->push_back(locks32__elem_);
                    t_locks32__elem__dataptr += 10;
                    BINPAC_ASSERT(t_locks32__elem__dataptr <= t_end_of_data);
                    locks32__elem_ = nullptr;
                }
            end_of_locks32: ;
                t_locks32__size = t_locks32__elem__dataptr - (t_dataptr_after_unlocks);
                // Evaluate 'let' and 'withinput' fields
                t_locks__size = t_locks32__size;
            }
            break;
        case ((int)64):
            // Parse "locks64"
            {
                int t_locks64__arraylength;
                t_locks64__arraylength = num_requested_locks();
                if ( t_locks64__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:locks64",
                      t_locks64__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: SMB1_locking_andx_request:locks64
                if ( t_locks64__arraylength > ((t_end_of_data - t_dataptr_after_unlocks) / 20) )
                    throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:locks64",
                      t_locks64__arraylength, (t_end_of_data) - (t_dataptr_after_unlocks));
                locks64__elem_ = nullptr;
                int t_locks64__elem__it;
                t_locks64__elem__it = 0;
                int t_locks64__size;
                locks64_ = new vector<LOCKING_ANDX_RANGE64*>;
                locks64_->reserve(t_locks64__arraylength);
                const_byteptr t_locks64__elem__dataptr = t_dataptr_after_unlocks;
                for (; t_locks64__elem__it < t_locks64__arraylength; ++t_locks64__elem__it) {
                    locks64__elem_ = new LOCKING_ANDX_RANGE64();
                    locks64__elem_->Parse(t_locks64__elem__dataptr, t_end_of_data, t_byteorder);
                    locks64_->push_back(locks64__elem_);
                    t_locks64__elem__dataptr += 20;
                    BINPAC_ASSERT(t_locks64__elem__dataptr <= t_end_of_data);
                    locks64__elem_ = nullptr;
                }
            end_of_locks64: ;
                t_locks64__size = t_locks64__elem__dataptr - (t_dataptr_after_unlocks);
                // Evaluate 'let' and 'withinput' fields
                t_locks__size = t_locks64__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_locking_andx_request", (int64)locks_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_locks = t_dataptr_after_unlocks + (t_locks__size);
    BINPAC_ASSERT(t_dataptr_after_locks <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_locks - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_locks - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_locking_andx_request:extra_byte_parameters"
    if ( t_dataptr_after_locks + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_locks + (t_extra_byte_parameters__size) < t_dataptr_after_locks ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_locking_andx_request:extra_byte_parameters",
        	((t_dataptr_after_locks - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_locks + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_locks - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_locks - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-locking-andx.pac:51", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_locks, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_locks + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_locking_andx_request__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_locking_andx_request__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_locking_andx_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_locking_andx_request__size) <= t_end_of_data);
    return t_SMB1_locking_andx_request__size;
}

SMB1_locking_andx_response::SMB1_locking_andx_response(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

SMB1_locking_andx_response::~SMB1_locking_andx_response() {
}

int SMB1_locking_andx_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB1_locking_andx_response"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_locking_andx_response",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_locking_andx_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

SMB1_logoff_andx::SMB1_logoff_andx(SMB_Header* header, uint16 offset, bool is_orig) {
    word_count_ = 0;
    andx_ = nullptr;
    byte_count_ = 0;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    is_orig_ = is_orig;
    proc_ = false;
}

SMB1_logoff_andx::~SMB1_logoff_andx() {
    delete andx_;
    andx_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_logoff_andx::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_logoff_andx:byte_count"
    if ( (t_begin_of_data + 5) + (2) > t_end_of_data || (t_begin_of_data + 5) + (2) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_logoff_andx:byte_count",
        	(5) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + 7 )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + 7 )  ) ;
    // Checking out-of-bound for "SMB1_logoff_andx:extra_byte_parameters"
    if ( (t_begin_of_data + 7) + (t_extra_byte_parameters__size) > t_end_of_data || (t_begin_of_data + 7) + (t_extra_byte_parameters__size) < (t_begin_of_data + 7) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_logoff_andx:extra_byte_parameters",
        	(7) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 7) + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + 7 )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + 7 )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-logoff-andx.pac:18", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init((t_begin_of_data + 7), t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = (t_begin_of_data + 7) + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_logoff_andx__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_logoff_andx__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_logoff_andx(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_logoff_andx__size) <= t_end_of_data);
    return t_SMB1_logoff_andx__size;
}

SMB_dialect::SMB_dialect() {
    buffer_format_ = 0;
    name_ = nullptr;
}

SMB_dialect::~SMB_dialect() {
    delete name_;
    name_ = nullptr;
}

int SMB_dialect::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_dialect:buffer_format"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_dialect:buffer_format",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "buffer_format"
    buffer_format_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "name"
    name_ = new SMB_string(false, 0);
    int t_name__size;
    t_name__size = name_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);

    int t_SMB_dialect__size;
    const_byteptr const t_dataptr_after_name = (t_begin_of_data + 1) + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    t_SMB_dialect__size = t_dataptr_after_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_dialect__size) <= t_end_of_data);
    return t_SMB_dialect__size;
}

SMB1_negotiate_request::SMB1_negotiate_request(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    dialects_ = nullptr;
    dialects__elem_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_negotiate_request::~SMB1_negotiate_request() {
    delete dialects__elem_;
    dialects__elem_ = nullptr;
    if ( dialects() ) {
        for ( auto* dialects__elem_ : *dialects() ) {
            delete dialects__elem_;
            dialects__elem_ = nullptr;
        }
    }
    delete dialects_;
}

int SMB1_negotiate_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_negotiate_request:byte_count"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_request:byte_count",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "dialects"
    int t_dialects__size;
    t_dialects__size = byte_count();
    // Checking out-of-bound for "SMB1_negotiate_request:dialects"
    if ( (t_begin_of_data + 3) + (t_dialects__size) > t_end_of_data || (t_begin_of_data + 3) + (t_dialects__size) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_request:dialects",
        	(3) + (t_dialects__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + t_dialects__size;
        int t_dialects__arraylength;
        t_dialects__arraylength = 0;
        dialects__elem_ = nullptr;
        int t_dialects__elem__it;
        t_dialects__elem__it = 0;
        dialects_ = new vector<SMB_dialect*>;
        const_byteptr t_dialects__elem__dataptr = (t_begin_of_data + 3);
        for (; /* forever */; ++t_dialects__elem__it) {
            // Check &until(dialects__elem__dataptr >= end_of_data)
            if ( t_dialects__elem__dataptr >= t_end_of_data ) {
                dialects__elem_ = nullptr;
                goto end_of_dialects;
            }
            dialects__elem_ = new SMB_dialect();
            int t_dialects__elem__size;
            t_dialects__elem__size = dialects__elem_->Parse(t_dialects__elem__dataptr, t_end_of_data, t_context);
            dialects_->push_back(dialects__elem_);
            t_dialects__elem__dataptr += t_dialects__elem__size;
            BINPAC_ASSERT(t_dialects__elem__dataptr <= t_end_of_data);
            dialects__elem_ = nullptr;
        }
    end_of_dialects: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_SMB1_negotiate_request__size;
    const_byteptr const t_dataptr_after_dialects = (t_begin_of_data + 3) + (t_dialects__size);
    BINPAC_ASSERT(t_dataptr_after_dialects <= t_end_of_data);
    t_SMB1_negotiate_request__size = t_dataptr_after_dialects - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_negotiate_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_negotiate_request__size) <= t_end_of_data);
    return t_SMB1_negotiate_request__size;
}

SMB1_negotiate_response::SMB1_negotiate_response(SMB_Header* header) {
    word_count_ = 0;
    dialect_index_ = 0;
    response_case_index_ = -1;
    core_ = nullptr;
    lanman_ = nullptr;
    ntlm_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_negotiate_response::~SMB1_negotiate_response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( response_case_index() ) {
        case ((uint8)1):
            // Clean up "core"
            {
                delete core_;
                core_ = nullptr;
            }
            break;
        case ((uint8)13):
            // Clean up "lanman"
            {
                delete lanman_;
                lanman_ = nullptr;
            }
            break;
        case ((uint8)17):
            // Clean up "ntlm"
            {
                delete ntlm_;
                ntlm_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB1_negotiate_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_negotiate_response:dialect_index"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_response:dialect_index",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "dialect_index"
    dialect_index_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "response"
    int t_response__size;
    response_case_index_ = word_count();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( response_case_index() ) {
        case ((uint8)1):
            // Parse "core"
            {
                core_ = new SMB1_negotiate_core_response();
                core_->Parse((t_begin_of_data + 3), t_end_of_data, t_byteorder);
                t_response__size = 2;
            }
            break;
        case ((uint8)13):
            // Parse "lanman"
            {
                lanman_ = new SMB1_negotiate_lanman_response(header());
                int t_lanman__size;
                t_lanman__size = lanman_->Parse((t_begin_of_data + 3), t_end_of_data, t_context, t_byteorder);
                t_response__size = t_lanman__size;
            }
            break;
        case ((uint8)17):
            // Parse "ntlm"
            {
                ntlm_ = new SMB1_negotiate_ntlm_response(header());
                int t_ntlm__size;
                t_ntlm__size = ntlm_->Parse((t_begin_of_data + 3), t_end_of_data, t_context, t_byteorder);
                t_response__size = t_ntlm__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_negotiate_response", (int64)response_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB1_negotiate_response__size;
    const_byteptr const t_dataptr_after_response = (t_begin_of_data + 3) + (t_response__size);
    BINPAC_ASSERT(t_dataptr_after_response <= t_end_of_data);
    t_SMB1_negotiate_response__size = t_dataptr_after_response - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_negotiate_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_negotiate_response__size) <= t_end_of_data);
    return t_SMB1_negotiate_response__size;
}

SMB1_negotiate_core_response::SMB1_negotiate_core_response() {
    byte_count_ = 0;
}

SMB1_negotiate_core_response::~SMB1_negotiate_core_response() {
}

int SMB1_negotiate_core_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB1_negotiate_core_response"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_core_response",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

SMB1_negotiate_lanman_response::SMB1_negotiate_lanman_response(SMB_Header* header) {
    security_flags_ = 0;
    max_buffer_size_ = 0;
    max_mpx_count_ = 0;
    max_number_vcs_ = 0;
    raw_mode_ = 0;
    session_key_ = 0;
    server_time_ = 0;
    server_date_ = 0;
    server_tz_ = 0;
    encryption_key_length_ = 0;
    reserved_ = 0;
    byte_count_ = 0;
    primary_domain_ = nullptr;
    header_ = header;
    security_user_level_ = false;
    security_challenge_response_ = false;
    raw_read_supported_ = false;
    raw_write_supported_ = false;
}

SMB1_negotiate_lanman_response::~SMB1_negotiate_lanman_response() {
    encryption_key_.free();
    delete primary_domain_;
    primary_domain_ = nullptr;
}

int SMB1_negotiate_lanman_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_negotiate_lanman_response:byte_count"
    if ( (t_begin_of_data + 24) + (2) > t_end_of_data || (t_begin_of_data + 24) + (2) < (t_begin_of_data + 24) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_lanman_response:byte_count",
        	(24) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "security_flags"
    security_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "max_buffer_size"
    max_buffer_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "max_mpx_count"
    max_mpx_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "max_number_vcs"
    max_number_vcs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "raw_mode"
    raw_mode_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "session_key"
    session_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 10))));

    // Parse "server_time"
    server_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "server_date"
    server_date_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 16))));

    // Parse "server_tz"
    server_tz_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 18))));

    // Parse "encryption_key_length"
    encryption_key_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 20))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 22))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 24))));

    // Parse "encryption_key"
    int t_encryption_key__size;
    t_encryption_key__size = encryption_key_length();
    // Checking out-of-bound for "SMB1_negotiate_lanman_response:encryption_key"
    if ( (t_begin_of_data + 26) + (t_encryption_key__size) > t_end_of_data || (t_begin_of_data + 26) + (t_encryption_key__size) < (t_begin_of_data + 26) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_lanman_response:encryption_key",
        	(26) + (t_encryption_key__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 26) + t_encryption_key__size;
        int t_encryption_key_string_length;
        t_encryption_key_string_length = encryption_key_length();
        // check for negative sizes
        if ( t_encryption_key_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:190", t_encryption_key_string_length);
        encryption_key_.init((t_begin_of_data + 26), t_encryption_key_string_length);
    }

    const_byteptr const t_dataptr_after_encryption_key = (t_begin_of_data + 26) + (t_encryption_key__size);
    BINPAC_ASSERT(t_dataptr_after_encryption_key <= t_end_of_data);
    // Parse "primary_domain"
    primary_domain_ = new SMB_string(header()->unicode(), (t_dataptr_after_encryption_key - t_begin_of_data));
    int t_primary_domain__size;
    t_primary_domain__size = primary_domain_->Parse(t_dataptr_after_encryption_key, t_end_of_data, t_context);

    int t_SMB1_negotiate_lanman_response__size;
    const_byteptr const t_dataptr_after_primary_domain = t_dataptr_after_encryption_key + (t_primary_domain__size);
    BINPAC_ASSERT(t_dataptr_after_primary_domain <= t_end_of_data);
    t_SMB1_negotiate_lanman_response__size = t_dataptr_after_primary_domain - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    security_user_level_ =  ( security_flags() & 0x1 )  > 0;
    security_challenge_response_ =  ( security_flags() & 0x2 )  > 0;
    raw_read_supported_ =  ( raw_mode() & 0x1 )  > 0;
    raw_write_supported_ =  ( raw_mode() & 0x2 )  > 0;
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_negotiate_lanman_response__size) <= t_end_of_data);
    return t_SMB1_negotiate_lanman_response__size;
}

SMB1_negotiate_ntlm_response::SMB1_negotiate_ntlm_response(SMB_Header* header) {
    security_flags_ = 0;
    max_mpx_count_ = 0;
    max_number_vcs_ = 0;
    max_buffer_size_ = 0;
    max_raw_size_ = 0;
    session_key_ = 0;
    capabilities_ = 0;
    server_time_ = 0;
    server_tz_ = 0;
    encryption_key_length_ = 0;
    byte_count_ = 0;
    encryption_key_present_case_index_ = -1;
    domain_name_present_case_index_ = -1;
    domain_name_ = nullptr;
    server_guid_present_case_index_ = -1;
    security_blob_present_case_index_ = -1;
    header_ = header;
    security_user_level_ = false;
    security_challenge_response_ = false;
    security_signatures_enabled_ = false;
    security_signatures_required_ = false;
    capabilities_raw_mode_ = false;
    capabilities_mpx_mode_ = false;
    capabilities_unicode_ = false;
    capabilities_large_files_ = false;
    capabilities_nt_smbs_ = false;
    capabilities_rpc_remote_apis_ = false;
    capabilities_status32_ = false;
    capabilities_level_2_oplocks_ = false;
    capabilities_lock_and_read_ = false;
    capabilities_nt_find_ = false;
    capabilities_dfs_ = false;
    capabilities_infolevel_passthru_ = false;
    capabilities_large_readx_ = false;
    capabilities_large_writex_ = false;
    capabilities_unix_ = false;
    capabilities_reserved_ = false;
    capabilities_bulk_transfer_ = false;
    capabilities_compressed_data_ = false;
    capabilities_extended_security_ = false;
    gssapi_proc_ = false;
    has_gssapi_proc_ = false;
}

SMB1_negotiate_ntlm_response::~SMB1_negotiate_ntlm_response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( encryption_key_present_case_index() ) {
        case false:
            // Clean up "encryption_key"
            {
                encryption_key_.free();
            }
            break;
        case true:
            // Clean up "no_key"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( domain_name_present_case_index() ) {
        case false:
            // Clean up "domain_name"
            {
                delete domain_name_;
                domain_name_ = nullptr;
            }
            break;
        case true:
            // Clean up "no_name"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( server_guid_present_case_index() ) {
        case true:
            // Clean up "server_guid"
            {
                server_guid_.free();
            }
            break;
        case false:
            // Clean up "no_guid"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( security_blob_present_case_index() ) {
        case true:
            // Clean up "security_blob"
            {
                security_blob_.free();
            }
            break;
        case false:
            // Clean up "no_blob"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB1_negotiate_ntlm_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_negotiate_ntlm_response:byte_count"
    if ( (t_begin_of_data + 32) + (2) > t_end_of_data || (t_begin_of_data + 32) + (2) < (t_begin_of_data + 32) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_negotiate_ntlm_response:byte_count",
        	(32) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "security_flags"
    security_flags_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "max_mpx_count"
    max_mpx_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "max_number_vcs"
    max_number_vcs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "max_buffer_size"
    max_buffer_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 5))));

    // Parse "max_raw_size"
    max_raw_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 9))));

    // Parse "session_key"
    session_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 13))));

    // Parse "capabilities"
    capabilities_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 17))));

    // Parse "server_time"
    server_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 21))));

    // Parse "server_tz"
    server_tz_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 29))));

    // Parse "encryption_key_length"
    encryption_key_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 31)));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 32))));

    // Parse "encryption_key_present"
    capabilities_extended_security_ =  ( capabilities() & 0x80000000 )  > 0;
    int t_encryption_key_present__size;
    encryption_key_present_case_index_ = capabilities_extended_security();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( encryption_key_present_case_index() ) {
        case false:
            // Parse "encryption_key"
            {
                int t_encryption_key__size;
                t_encryption_key__size = encryption_key_length();
                // Checking out-of-bound for "SMB1_negotiate_ntlm_response:encryption_key"
                if ( (t_begin_of_data + 34) + (t_encryption_key__size) > t_end_of_data || (t_begin_of_data + 34) + (t_encryption_key__size) < (t_begin_of_data + 34) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB1_negotiate_ntlm_response:encryption_key",
                    	(34) + (t_encryption_key__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 34) + t_encryption_key__size;
                    int t_encryption_key_string_length;
                    t_encryption_key_string_length = encryption_key_length();
                    // check for negative sizes
                    if ( t_encryption_key_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:212", t_encryption_key_string_length);
                    encryption_key_.init((t_begin_of_data + 34), t_encryption_key_string_length);
                }
                t_encryption_key_present__size = t_encryption_key__size;
            }
            break;
        case true:
            // Parse "no_key"
            {
                t_encryption_key_present__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_negotiate_ntlm_response", (int64)encryption_key_present_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_encryption_key_present = (t_begin_of_data + 34) + (t_encryption_key_present__size);
    BINPAC_ASSERT(t_dataptr_after_encryption_key_present <= t_end_of_data);
    // Parse "domain_name_present"
    int t_domain_name_present__size;
    domain_name_present_case_index_ = capabilities_extended_security();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( domain_name_present_case_index() ) {
        case false:
            // Parse "domain_name"
            {
                domain_name_ = new SMB_string(header()->unicode(), (t_dataptr_after_encryption_key_present - t_begin_of_data));
                int t_domain_name__size;
                t_domain_name__size = domain_name_->Parse(t_dataptr_after_encryption_key_present, t_end_of_data, t_context);
                t_domain_name_present__size = t_domain_name__size;
            }
            break;
        case true:
            // Parse "no_name"
            {
                t_domain_name_present__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_negotiate_ntlm_response", (int64)domain_name_present_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_domain_name_present = t_dataptr_after_encryption_key_present + (t_domain_name_present__size);
    BINPAC_ASSERT(t_dataptr_after_domain_name_present <= t_end_of_data);
    // Parse "server_guid_present"
    int t_server_guid_present__size;
    server_guid_present_case_index_ = capabilities_extended_security();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( server_guid_present_case_index() ) {
        case true:
            // Parse "server_guid"
            {
                // Checking out-of-bound for "SMB1_negotiate_ntlm_response:server_guid"
                if ( t_dataptr_after_domain_name_present + (16) > t_end_of_data || t_dataptr_after_domain_name_present + (16) < t_dataptr_after_domain_name_present ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB1_negotiate_ntlm_response:server_guid",
                    	((t_dataptr_after_domain_name_present - t_begin_of_data)) + (16), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_domain_name_present + 16;
                    int t_server_guid_string_length;
                    t_server_guid_string_length = 16;
                    int t_server_guid__size;
                    t_server_guid__size = t_server_guid_string_length;
                    server_guid_.init(t_dataptr_after_domain_name_present, t_server_guid_string_length);
                }
                t_server_guid_present__size = 16;
            }
            break;
        case false:
            // Parse "no_guid"
            {
                t_server_guid_present__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_negotiate_ntlm_response", (int64)server_guid_present_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_server_guid_present = t_dataptr_after_domain_name_present + (t_server_guid_present__size);
    BINPAC_ASSERT(t_dataptr_after_server_guid_present <= t_end_of_data);
    // Parse "security_blob_present"
    int t_security_blob_present__size;
    security_blob_present_case_index_ = capabilities_extended_security();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( security_blob_present_case_index() ) {
        case true:
            // Parse "security_blob"
            {
                int t_security_blob__size;
                t_security_blob__size =  ( byte_count() - 16 ) ;
                // Checking out-of-bound for "SMB1_negotiate_ntlm_response:security_blob"
                if ( t_dataptr_after_server_guid_present + (t_security_blob__size) > t_end_of_data || t_dataptr_after_server_guid_present + (t_security_blob__size) < t_dataptr_after_server_guid_present ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB1_negotiate_ntlm_response:security_blob",
                    	((t_dataptr_after_server_guid_present - t_begin_of_data)) + (t_security_blob__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_server_guid_present + t_security_blob__size;
                    int t_security_blob_string_length;
                    t_security_blob_string_length =  ( byte_count() - 16 ) ;
                    // check for negative sizes
                    if ( t_security_blob_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-negotiate.pac:224", t_security_blob_string_length);
                    security_blob_.init(t_dataptr_after_server_guid_present, t_security_blob_string_length);
                }
                t_security_blob_present__size = t_security_blob__size;
            }
            break;
        case false:
            // Parse "no_blob"
            {
                t_security_blob_present__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_negotiate_ntlm_response", (int64)security_blob_present_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB1_negotiate_ntlm_response__size;
    const_byteptr const t_dataptr_after_security_blob_present = t_dataptr_after_server_guid_present + (t_security_blob_present__size);
    BINPAC_ASSERT(t_dataptr_after_security_blob_present <= t_end_of_data);
    t_SMB1_negotiate_ntlm_response__size = t_dataptr_after_security_blob_present - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    security_user_level_ =  ( security_flags() & 0x1 )  > 0;
    security_challenge_response_ =  ( security_flags() & 0x2 )  > 0;
    security_signatures_enabled_ =  ( security_flags() & 0x4 )  > 0;
    security_signatures_required_ =  ( security_flags() & 0x8 )  > 0;
    capabilities_raw_mode_ =  ( capabilities() & 0x1 )  > 0;
    capabilities_mpx_mode_ =  ( capabilities() & 0x2 )  > 0;
    capabilities_unicode_ =  ( capabilities() & 0x4 )  > 0;
    capabilities_large_files_ =  ( capabilities() & 0x8 )  > 0;
    capabilities_nt_smbs_ =  ( capabilities() & 0x10 )  > 0;
    capabilities_rpc_remote_apis_ =  ( capabilities() & 0x20 )  > 0;
    capabilities_status32_ =  ( capabilities() & 0x40 )  > 0;
    capabilities_level_2_oplocks_ =  ( capabilities() & 0x80 )  > 0;
    capabilities_lock_and_read_ =  ( capabilities() & 0x100 )  > 0;
    capabilities_nt_find_ =  ( capabilities() & 0x200 )  > 0;
    capabilities_dfs_ =  ( capabilities() & 0x1000 )  > 0;
    capabilities_infolevel_passthru_ =  ( capabilities() & 0x2000 )  > 0;
    capabilities_large_readx_ =  ( capabilities() & 0x4000 )  > 0;
    capabilities_large_writex_ =  ( capabilities() & 0x8000 )  > 0;
    capabilities_unix_ =  ( capabilities() & 0x00800000 )  > 0;
    capabilities_reserved_ =  ( capabilities() & 0x02000000 )  > 0;
    capabilities_bulk_transfer_ =  ( capabilities() & 0x20000000 )  > 0;
    capabilities_compressed_data_ =  ( capabilities() & 0x40000000 )  > 0;
    has_gssapi_proc_ =  ( capabilities_extended_security() ) ;
    if ( has_gssapi_proc() ) {
        gssapi_proc_ = t_context->connection()->forward_gssapi(security_blob(), false);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_negotiate_ntlm_response__size) <= t_end_of_data);
    return t_SMB1_negotiate_ntlm_response__size;
}

SMB1_nt_cancel_request::SMB1_nt_cancel_request(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_nt_cancel_request::~SMB1_nt_cancel_request() {
}

int SMB1_nt_cancel_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_nt_cancel_request"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_cancel_request",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_nt_cancel_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

SMB1_nt_create_andx_request::SMB1_nt_create_andx_request(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    reserved_ = 0;
    name_length_ = 0;
    flags_ = 0;
    root_dir_file_id_ = 0;
    desired_access_ = 0;
    alloc_size_ = 0;
    ext_file_attrs_ = 0;
    share_access_ = 0;
    create_disposition_ = 0;
    create_options_ = 0;
    impersonation_level_ = 0;
    security_flags_ = 0;
    byte_count_ = 0;
    filename_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_nt_create_andx_request::~SMB1_nt_create_andx_request() {
    delete andx_;
    andx_ = nullptr;
    delete filename_;
    filename_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_nt_create_andx_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_nt_create_andx_request:byte_count"
    if ( (t_begin_of_data + 49) + (2) > t_end_of_data || (t_begin_of_data + 49) + (2) < (t_begin_of_data + 49) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_create_andx_request:byte_count",
        	(49) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Parse "name_length"
    name_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "root_dir_file_id"
    root_dir_file_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "desired_access"
    desired_access_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "alloc_size"
    alloc_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 20))));

    // Parse "ext_file_attrs"
    ext_file_attrs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));

    // Parse "share_access"
    share_access_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "create_disposition"
    create_disposition_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 36))));

    // Parse "create_options"
    create_options_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 40))));

    // Parse "impersonation_level"
    impersonation_level_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 44))));

    // Parse "security_flags"
    security_flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 48)));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 49))));

    // Parse "filename"
    filename_ = new SMB_string(header()->unicode(), 51);
    int t_filename__size;
    t_filename__size = filename_->Parse((t_begin_of_data + 51), t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_filename = (t_begin_of_data + 51) + (t_filename__size);
    BINPAC_ASSERT(t_dataptr_after_filename <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_filename - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_filename - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_nt_create_andx_request:extra_byte_parameters"
    if ( t_dataptr_after_filename + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_filename + (t_extra_byte_parameters__size) < t_dataptr_after_filename ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_create_andx_request:extra_byte_parameters",
        	((t_dataptr_after_filename - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_filename + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_filename - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_filename - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-nt-create-andx.pac:72", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_filename, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_filename + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_nt_create_andx_request__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_nt_create_andx_request__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_nt_create_andx_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_nt_create_andx_request__size) <= t_end_of_data);
    return t_SMB1_nt_create_andx_request__size;
}

SMB1_nt_create_andx_response::SMB1_nt_create_andx_response(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    oplock_level_ = 0;
    file_id_ = 0;
    create_disposition_ = 0;
    create_time_ = 0;
    last_access_time_ = 0;
    last_write_time_ = 0;
    last_change_time_ = 0;
    ext_file_attrs_ = 0;
    allocation_size_ = 0;
    end_of_file_ = 0;
    resource_type_ = 0;
    nm_pipe_status_ = 0;
    directory_ = 0;
    byte_count_ = 0;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_nt_create_andx_response::~SMB1_nt_create_andx_response() {
    delete andx_;
    andx_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_nt_create_andx_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_nt_create_andx_response:byte_count"
    if ( (t_begin_of_data + 69) + (2) > t_end_of_data || (t_begin_of_data + 69) + (2) < (t_begin_of_data + 69) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_create_andx_response:byte_count",
        	(69) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "oplock_level"
    oplock_level_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Parse "file_id"
    file_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "create_disposition"
    create_disposition_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "create_time"
    create_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 12))));

    // Parse "last_access_time"
    last_access_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 20))));

    // Parse "last_write_time"
    last_write_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 28))));

    // Parse "last_change_time"
    last_change_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 36))));

    // Parse "ext_file_attrs"
    ext_file_attrs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 44))));

    // Parse "allocation_size"
    allocation_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 48))));

    // Parse "end_of_file"
    end_of_file_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 56))));

    // Parse "resource_type"
    resource_type_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 64))));

    // Parse "nm_pipe_status"
    nm_pipe_status_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 66))));

    // Parse "directory"
    directory_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 68)));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 69))));

    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + 71 )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + 71 )  ) ;
    // Checking out-of-bound for "SMB1_nt_create_andx_response:extra_byte_parameters"
    if ( (t_begin_of_data + 71) + (t_extra_byte_parameters__size) > t_end_of_data || (t_begin_of_data + 71) + (t_extra_byte_parameters__size) < (t_begin_of_data + 71) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_create_andx_response:extra_byte_parameters",
        	(71) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 71) + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + 71 )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + 71 )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-nt-create-andx.pac:98", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init((t_begin_of_data + 71), t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = (t_begin_of_data + 71) + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), false, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_nt_create_andx_response__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_nt_create_andx_response__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_nt_create_andx_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_nt_create_andx_response__size) <= t_end_of_data);
    return t_SMB1_nt_create_andx_response__size;
}

SMB1_nt_transact_request::SMB1_nt_transact_request(SMB_Header* header) {
    word_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_nt_transact_request::~SMB1_nt_transact_request() {
}

int SMB1_nt_transact_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB1_nt_transact_request"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_transact_request",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_nt_transact_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

SMB1_nt_transact_response::SMB1_nt_transact_response(SMB_Header* header) {
    word_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_nt_transact_response::~SMB1_nt_transact_response() {
}

int SMB1_nt_transact_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB1_nt_transact_response"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_nt_transact_response",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_nt_transact_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

SMB1_query_information_request::SMB1_query_information_request(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    buffer_format_ = 0;
    filename_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_query_information_request::~SMB1_query_information_request() {
    delete filename_;
    filename_ = nullptr;
}

int SMB1_query_information_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_query_information_request:buffer_format"
    if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_query_information_request:buffer_format",
        	(3) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "buffer_format"
    buffer_format_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "filename"
    filename_ = new SMB_string(header()->unicode(), 4);
    int t_filename__size;
    t_filename__size = filename_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);

    int t_SMB1_query_information_request__size;
    const_byteptr const t_dataptr_after_filename = (t_begin_of_data + 4) + (t_filename__size);
    BINPAC_ASSERT(t_dataptr_after_filename <= t_end_of_data);
    t_SMB1_query_information_request__size = t_dataptr_after_filename - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_query_information_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_query_information_request__size) <= t_end_of_data);
    return t_SMB1_query_information_request__size;
}

SMB1_query_information_response::SMB1_query_information_response(SMB_Header* header) {
    word_count_ = 0;
    file_attribs_ = 0;
    last_write_time_ = 0;
    file_size_ = 0;
    reserved_ = nullptr;
    reserved__elem_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_query_information_response::~SMB1_query_information_response() {
    delete reserved_;
}

int SMB1_query_information_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_query_information_response"
    if ( t_begin_of_data + (23) > t_end_of_data || t_begin_of_data + (23) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_query_information_response",
        	(0) + (23), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "file_attribs"
    file_attribs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "last_write_time"
    last_write_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));

    // Parse "file_size"
    file_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 7))));

    // Parse "reserved"
    int t_reserved__arraylength;
    t_reserved__arraylength = 5;
    if ( t_reserved__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_query_information_response:reserved",
          t_reserved__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB1_query_information_response:reserved
    if ( t_reserved__arraylength > ((t_end_of_data - (t_begin_of_data + 11)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB1_query_information_response:reserved",
          t_reserved__arraylength, (t_end_of_data) - ((t_begin_of_data + 11)));
    reserved__elem_ = 0;
    int t_reserved__elem__it;
    t_reserved__elem__it = 0;
    reserved_ = new vector<uint16>;
    reserved_->reserve(t_reserved__arraylength);
    const_byteptr t_reserved__elem__dataptr = (t_begin_of_data + 11);
    for (; t_reserved__elem__it < t_reserved__arraylength; ++t_reserved__elem__it) {
        reserved__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_reserved__elem__dataptr)));
        reserved_->push_back(reserved__elem_);
        t_reserved__elem__dataptr += 2;
        BINPAC_ASSERT(t_reserved__elem__dataptr <= t_end_of_data);
    }
end_of_reserved: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 21))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_query_information_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (23) <= t_end_of_data);
    return 23;
}

SMB1_read_andx_request::SMB1_read_andx_request(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    file_id_ = 0;
    offset_low_ = 0;
    max_count_low_ = 0;
    min_count_ = 0;
    max_count_high_ = 0;
    remaining_ = 0;
    offset_high_u_case_index_ = -1;
    offset_high_tmp_ = 0;
    byte_count_ = 0;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    byteorder_ = littleendian;
    offset_high_64_ = 0;
    offset_high_ = 0;
    read_offset_ = 0;
    max_count_high_64_ = 0;
    max_count_ = 0;
    proc_ = false;
}

SMB1_read_andx_request::~SMB1_read_andx_request() {
    delete andx_;
    andx_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( offset_high_u_case_index() ) {
        case ((uint8)12):
            // Clean up "offset_high_tmp"
            {
            }
            break;
        default:
            // Clean up "null"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_read_andx_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB1_read_andx_request:remaining"
    if ( (t_begin_of_data + 19) + (2) > t_end_of_data || (t_begin_of_data + 19) + (2) < (t_begin_of_data + 19) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_request:remaining",
        	(19) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "file_id"
    file_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "offset_low"
    offset_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 7))));

    // Parse "max_count_low"
    max_count_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "min_count"
    min_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "max_count_high"
    max_count_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 15))));

    // Parse "remaining"
    remaining_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 19))));

    // Parse "offset_high_u"
    int t_offset_high_u__size;
    offset_high_u_case_index_ = word_count();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( offset_high_u_case_index() ) {
        case ((uint8)12):
            // Parse "offset_high_tmp"
            {
                // Checking out-of-bound for "SMB1_read_andx_request:offset_high_tmp"
                if ( (t_begin_of_data + 21) + (4) > t_end_of_data || (t_begin_of_data + 21) + (4) < (t_begin_of_data + 21) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB1_read_andx_request:offset_high_tmp",
                    	(21) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                offset_high_tmp_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 21))));
                t_offset_high_u__size = 4;
            }
            break;
        default:
            // Parse "null"
            {
                t_offset_high_u__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_offset_high_u = (t_begin_of_data + 21) + (t_offset_high_u__size);
    BINPAC_ASSERT(t_dataptr_after_offset_high_u <= t_end_of_data);
    // Checking out-of-bound for "SMB1_read_andx_request:byte_count"
    if ( t_dataptr_after_offset_high_u + (2) > t_end_of_data || t_dataptr_after_offset_high_u + (2) < t_dataptr_after_offset_high_u ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_request:byte_count",
        	((t_dataptr_after_offset_high_u - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_offset_high_u)));

    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  (  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + ((t_dataptr_after_offset_high_u + 2) - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + ((t_dataptr_after_offset_high_u + 2) - t_begin_of_data) )  )  ) ;
    // Checking out-of-bound for "SMB1_read_andx_request:extra_byte_parameters"
    if ( (t_dataptr_after_offset_high_u + 2) + (t_extra_byte_parameters__size) > t_end_of_data || (t_dataptr_after_offset_high_u + 2) + (t_extra_byte_parameters__size) < (t_dataptr_after_offset_high_u + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_request:extra_byte_parameters",
        	(((t_dataptr_after_offset_high_u + 2) - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_offset_high_u + 2) + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  (  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + ((t_dataptr_after_offset_high_u + 2) - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + ((t_dataptr_after_offset_high_u + 2) - t_begin_of_data) )  )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-read-andx.pac:65", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init((t_dataptr_after_offset_high_u + 2), t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = (t_dataptr_after_offset_high_u + 2) + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_read_andx_request__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_read_andx_request__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    offset_high_ =  ( word_count() == 0x0C && offset_high_tmp() != 0xffffffff )  ? offset_high_tmp() : 0;
    offset_high_64_ = offset_high();
    read_offset_ =  ( offset_high_64() * 0x10000 )  + offset_low();
    max_count_high_64_ = max_count_high() == 0xffffffff ? 0 : max_count_high();
    max_count_ =  ( max_count_high_64() * 0x10000 )  + max_count_low();
    proc_ = t_context->connection()->proc_smb1_read_andx_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_read_andx_request__size) <= t_end_of_data);
    return t_SMB1_read_andx_request__size;
}

SMB1_read_andx_response::SMB1_read_andx_response(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    available_ = 0;
    data_compact_mode_ = 0;
    reserved1_ = 0;
    data_len_low_ = 0;
    data_offset_ = 0;
    data_len_high_ = 0;
    reserved2_ = 0;
    byte_count_ = 0;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    byteorder_ = littleendian;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
    padding_len_ = 0;
    data_len_ = 0;
    proc_ = false;
}

SMB1_read_andx_response::~SMB1_read_andx_response() {
    delete andx_;
    andx_ = nullptr;
    data_.free();
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_read_andx_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB1_read_andx_response:byte_count"
    if ( (t_begin_of_data + 25) + (2) > t_end_of_data || (t_begin_of_data + 25) + (2) < (t_begin_of_data + 25) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_response:byte_count",
        	(25) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "available"
    available_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "data_compact_mode"
    data_compact_mode_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "reserved1"
    reserved1_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "data_len_low"
    data_len_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "data_len_high"
    data_len_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 17))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 25))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (data_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad < (t_begin_of_data + 27) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-read-andx.pac:89:pad", (t_begin_of_data + 27) - t_begin_of_data, data_offset() - SMB_Header_length);
        t_dataptr_after_pad = (t_begin_of_data + 27);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_response:pad",
        	(data_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "data"
    int t_data__size;
    data_len_ =  ( data_len_high() << 16 )  + data_len_low();
    t_data__size = data_len();
    // Checking out-of-bound for "SMB1_read_andx_response:data"
    if ( t_dataptr_after_pad + (t_data__size) > t_end_of_data || t_dataptr_after_pad + (t_data__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_response:data",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_data__size;
        int t_data_string_length;
        t_data_string_length = data_len();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-read-andx.pac:90", t_data_string_length);
        data_.init(t_dataptr_after_pad, t_data_string_length);
    }

    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_read_andx_response:extra_byte_parameters"
    if ( t_dataptr_after_data + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_data + (t_extra_byte_parameters__size) < t_dataptr_after_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_read_andx_response:extra_byte_parameters",
        	((t_dataptr_after_data - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_data + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-read-andx.pac:92", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_data, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_data + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), false, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_read_andx_response__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_read_andx_response__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    has_pipe_proc_ =  ( header()->is_pipe() ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(data(), 0, false);
    }
    padding_len_ =  ( header()->unicode() == 1 )  ? 1 : 0;
    proc_ = t_context->connection()->proc_smb1_read_andx_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_read_andx_response__size) <= t_end_of_data);
    return t_SMB1_read_andx_response__size;
}

SMB1_session_setup_andx_request::SMB1_session_setup_andx_request(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    lanman_or_ntlm_case_index_ = -1;
    lanman_ = nullptr;
    ntlm_extended_security_ = nullptr;
    ntlm_nonextended_security_ = nullptr;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_session_setup_andx_request::~SMB1_session_setup_andx_request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( lanman_or_ntlm_case_index() ) {
        case ((uint8)10):
            // Clean up "lanman"
            {
                delete lanman_;
                lanman_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "ntlm_extended_security"
            {
                delete ntlm_extended_security_;
                ntlm_extended_security_ = nullptr;
            }
            break;
        case ((uint8)13):
            // Clean up "ntlm_nonextended_security"
            {
                delete ntlm_nonextended_security_;
                ntlm_nonextended_security_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB1_session_setup_andx_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_request:word_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request:word_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "lanman_or_ntlm"
    int t_lanman_or_ntlm__size;
    lanman_or_ntlm_case_index_ = word_count();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( lanman_or_ntlm_case_index() ) {
        case ((uint8)10):
            // Parse "lanman"
            {
                lanman_ = new SMB1_session_setup_andx_request_lanman(header(), offset() + 1);
                int t_lanman__size;
                t_lanman__size = lanman_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_lanman_or_ntlm__size = t_lanman__size;
            }
            break;
        case ((uint8)12):
            // Parse "ntlm_extended_security"
            {
                ntlm_extended_security_ = new SMB1_session_setup_andx_request_ntlm_extended_security(header(), offset() + 1);
                int t_ntlm_extended_security__size;
                t_ntlm_extended_security__size = ntlm_extended_security_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_lanman_or_ntlm__size = t_ntlm_extended_security__size;
            }
            break;
        case ((uint8)13):
            // Parse "ntlm_nonextended_security"
            {
                ntlm_nonextended_security_ = new SMB1_session_setup_andx_request_ntlm_nonextended_security(header(), offset() + 1);
                int t_ntlm_nonextended_security__size;
                t_ntlm_nonextended_security__size = ntlm_nonextended_security_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_lanman_or_ntlm__size = t_ntlm_nonextended_security__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB1_session_setup_andx_request", (int64)lanman_or_ntlm_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB1_session_setup_andx_request__size;
    const_byteptr const t_dataptr_after_lanman_or_ntlm = (t_begin_of_data + 1) + (t_lanman_or_ntlm__size);
    BINPAC_ASSERT(t_dataptr_after_lanman_or_ntlm <= t_end_of_data);
    t_SMB1_session_setup_andx_request__size = t_dataptr_after_lanman_or_ntlm - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_session_setup_andx_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_request__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_request__size;
}

SMB1_session_setup_andx_response::SMB1_session_setup_andx_response(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    lanman_or_ntlm_case_index_ = -1;
    lanman_ = nullptr;
    ntlm_ = nullptr;
    error_ = 0;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_session_setup_andx_response::~SMB1_session_setup_andx_response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( lanman_or_ntlm_case_index() ) {
        case ((uint8)3):
            // Clean up "lanman"
            {
                delete lanman_;
                lanman_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "ntlm"
            {
                delete ntlm_;
                ntlm_ = nullptr;
            }
            break;
        default:
            // Clean up "error"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB1_session_setup_andx_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_response:word_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response:word_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "lanman_or_ntlm"
    int t_lanman_or_ntlm__size;
    lanman_or_ntlm_case_index_ = word_count();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( lanman_or_ntlm_case_index() ) {
        case ((uint8)3):
            // Parse "lanman"
            {
                lanman_ = new SMB1_session_setup_andx_response_lanman(header(), offset() + 1);
                int t_lanman__size;
                t_lanman__size = lanman_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_lanman_or_ntlm__size = t_lanman__size;
            }
            break;
        case ((uint8)4):
            // Parse "ntlm"
            {
                ntlm_ = new SMB1_session_setup_andx_response_ntlm(header(), offset() + 1);
                int t_ntlm__size;
                t_ntlm__size = ntlm_->Parse((t_begin_of_data + 1), t_end_of_data, t_context, t_byteorder);
                t_lanman_or_ntlm__size = t_ntlm__size;
            }
            break;
        default:
            // Parse "error"
            {
                // Checking out-of-bound for "SMB1_session_setup_andx_response:error"
                if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response:error",
                    	(1) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                error_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));
                t_lanman_or_ntlm__size = 2;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB1_session_setup_andx_response__size;
    const_byteptr const t_dataptr_after_lanman_or_ntlm = (t_begin_of_data + 1) + (t_lanman_or_ntlm__size);
    BINPAC_ASSERT(t_dataptr_after_lanman_or_ntlm <= t_end_of_data);
    t_SMB1_session_setup_andx_response__size = t_dataptr_after_lanman_or_ntlm - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_session_setup_andx_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_response__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_response__size;
}

SMB1_session_setup_andx_request_lanman::SMB1_session_setup_andx_request_lanman(SMB_Header* header, uint16 offset) {
    andx_ = nullptr;
    max_buffer_size_ = 0;
    max_mpx_count_ = 0;
    vc_number_ = 0;
    session_key_ = 0;
    password_length_ = 0;
    reserved_ = 0;
    byte_count_ = 0;
    account_name_ = nullptr;
    primary_domain_ = nullptr;
    native_os_ = nullptr;
    native_lanman_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
}

SMB1_session_setup_andx_request_lanman::~SMB1_session_setup_andx_request_lanman() {
    delete andx_;
    andx_ = nullptr;
    account_password_.free();
    delete account_name_;
    account_name_ = nullptr;
    delete primary_domain_;
    primary_domain_ = nullptr;
    delete native_os_;
    native_os_ = nullptr;
    delete native_lanman_;
    native_lanman_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_session_setup_andx_request_lanman::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_request_lanman:byte_count"
    if ( (t_begin_of_data + 20) + (2) > t_end_of_data || (t_begin_of_data + 20) + (2) < (t_begin_of_data + 20) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_lanman:byte_count",
        	(20) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "max_buffer_size"
    max_buffer_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "max_mpx_count"
    max_mpx_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "vc_number"
    vc_number_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "session_key"
    session_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 10))));

    // Parse "password_length"
    password_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 20))));

    // Parse "account_password"
    int t_account_password__size;
    t_account_password__size = password_length();
    // Checking out-of-bound for "SMB1_session_setup_andx_request_lanman:account_password"
    if ( (t_begin_of_data + 22) + (t_account_password__size) > t_end_of_data || (t_begin_of_data + 22) + (t_account_password__size) < (t_begin_of_data + 22) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_lanman:account_password",
        	(22) + (t_account_password__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 22) + t_account_password__size;
        int t_account_password_string_length;
        t_account_password_string_length = password_length();
        // check for negative sizes
        if ( t_account_password_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:157", t_account_password_string_length);
        account_password_.init((t_begin_of_data + 22), t_account_password_string_length);
    }

    const_byteptr const t_dataptr_after_account_password = (t_begin_of_data + 22) + (t_account_password__size);
    BINPAC_ASSERT(t_dataptr_after_account_password <= t_end_of_data);
    // Parse "account_name"
    account_name_ = new SMB_string(header()->unicode(), (t_dataptr_after_account_password - t_begin_of_data) + 1);
    int t_account_name__size;
    t_account_name__size = account_name_->Parse(t_dataptr_after_account_password, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_account_name = t_dataptr_after_account_password + (t_account_name__size);
    BINPAC_ASSERT(t_dataptr_after_account_name <= t_end_of_data);
    // Parse "primary_domain"
    primary_domain_ = new SMB_string(header()->unicode(), (t_dataptr_after_account_name - t_begin_of_data) + 1);
    int t_primary_domain__size;
    t_primary_domain__size = primary_domain_->Parse(t_dataptr_after_account_name, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_primary_domain = t_dataptr_after_account_name + (t_primary_domain__size);
    BINPAC_ASSERT(t_dataptr_after_primary_domain <= t_end_of_data);
    // Parse "native_os"
    native_os_ = new SMB_string(header()->unicode(), (t_dataptr_after_primary_domain - t_begin_of_data) + 1);
    int t_native_os__size;
    t_native_os__size = native_os_->Parse(t_dataptr_after_primary_domain, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_os = t_dataptr_after_primary_domain + (t_native_os__size);
    BINPAC_ASSERT(t_dataptr_after_native_os <= t_end_of_data);
    // Parse "native_lanman"
    native_lanman_ = new SMB_string(header()->unicode(), (t_dataptr_after_native_os - t_begin_of_data) + 1);
    int t_native_lanman__size;
    t_native_lanman__size = native_lanman_->Parse(t_dataptr_after_native_os, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_lanman = t_dataptr_after_native_os + (t_native_lanman__size);
    BINPAC_ASSERT(t_dataptr_after_native_lanman <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_session_setup_andx_request_lanman:extra_byte_parameters"
    if ( t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) < t_dataptr_after_native_lanman ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_lanman:extra_byte_parameters",
        	((t_dataptr_after_native_lanman - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_native_lanman + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:164", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_native_lanman, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_native_lanman + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_session_setup_andx_request_lanman__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_session_setup_andx_request_lanman__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_request_lanman__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_request_lanman__size;
}

SMB1_session_setup_andx_response_lanman::SMB1_session_setup_andx_response_lanman(SMB_Header* header, uint16 offset) {
    andx_ = nullptr;
    action_ = 0;
    byte_count_ = 0;
    native_os_ = nullptr;
    native_os__elem_ = nullptr;
    native_lanman_ = nullptr;
    native_lanman__elem_ = nullptr;
    primary_domain_ = nullptr;
    primary_domain__elem_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    is_guest_ = false;
}

SMB1_session_setup_andx_response_lanman::~SMB1_session_setup_andx_response_lanman() {
    delete andx_;
    andx_ = nullptr;
    delete native_os__elem_;
    native_os__elem_ = nullptr;
    if ( native_os() ) {
        for ( auto* native_os__elem_ : *native_os() ) {
            delete native_os__elem_;
            native_os__elem_ = nullptr;
        }
    }
    delete native_os_;
    delete native_lanman__elem_;
    native_lanman__elem_ = nullptr;
    if ( native_lanman() ) {
        for ( auto* native_lanman__elem_ : *native_lanman() ) {
            delete native_lanman__elem_;
            native_lanman__elem_ = nullptr;
        }
    }
    delete native_lanman_;
    delete primary_domain__elem_;
    primary_domain__elem_ = nullptr;
    if ( primary_domain() ) {
        for ( auto* primary_domain__elem_ : *primary_domain() ) {
            delete primary_domain__elem_;
            primary_domain__elem_ = nullptr;
        }
    }
    delete primary_domain_;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_session_setup_andx_response_lanman::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_response_lanman:byte_count"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:byte_count",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "action"
    action_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "native_os"
    int t_native_os__arraylength;
    t_native_os__arraylength = byte_count() == 0 ? 0 : 1;
    if ( t_native_os__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:native_os",
          t_native_os__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: SMB1_session_setup_andx_response_lanman:native_os
    if ( t_native_os__arraylength > ((t_end_of_data - (t_begin_of_data + 8)) / 1) )
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:native_os",
          t_native_os__arraylength, (t_end_of_data) - ((t_begin_of_data + 8)));
    native_os__elem_ = nullptr;
    int t_native_os__elem__it;
    t_native_os__elem__it = 0;
    int t_native_os__size;
    native_os_ = new vector<SMB_string*>;
    native_os_->reserve(t_native_os__arraylength);
    const_byteptr t_native_os__elem__dataptr = (t_begin_of_data + 8);
    for (; t_native_os__elem__it < t_native_os__arraylength; ++t_native_os__elem__it) {
        native_os__elem_ = new SMB_string(header()->unicode(), 8 + 1);
        int t_native_os__elem__size;
        t_native_os__elem__size = native_os__elem_->Parse(t_native_os__elem__dataptr, t_end_of_data, t_context);
        native_os_->push_back(native_os__elem_);
        t_native_os__elem__dataptr += t_native_os__elem__size;
        BINPAC_ASSERT(t_native_os__elem__dataptr <= t_end_of_data);
        native_os__elem_ = nullptr;
    }
end_of_native_os: ;
    t_native_os__size = t_native_os__elem__dataptr - ((t_begin_of_data + 8));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_native_os = (t_begin_of_data + 8) + (t_native_os__size);
    BINPAC_ASSERT(t_dataptr_after_native_os <= t_end_of_data);
    // Parse "native_lanman"
    int t_native_lanman__arraylength;
    t_native_lanman__arraylength = byte_count() == 0 ? 0 : 1;
    if ( t_native_lanman__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:native_lanman",
          t_native_lanman__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: SMB1_session_setup_andx_response_lanman:native_lanman
    if ( t_native_lanman__arraylength > ((t_end_of_data - t_dataptr_after_native_os) / 1) )
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:native_lanman",
          t_native_lanman__arraylength, (t_end_of_data) - (t_dataptr_after_native_os));
    native_lanman__elem_ = nullptr;
    int t_native_lanman__elem__it;
    t_native_lanman__elem__it = 0;
    int t_native_lanman__size;
    native_lanman_ = new vector<SMB_string*>;
    native_lanman_->reserve(t_native_lanman__arraylength);
    const_byteptr t_native_lanman__elem__dataptr = t_dataptr_after_native_os;
    for (; t_native_lanman__elem__it < t_native_lanman__arraylength; ++t_native_lanman__elem__it) {
        native_lanman__elem_ = new SMB_string(header()->unicode(), (t_dataptr_after_native_os - t_begin_of_data) + 1);
        int t_native_lanman__elem__size;
        t_native_lanman__elem__size = native_lanman__elem_->Parse(t_native_lanman__elem__dataptr, t_end_of_data, t_context);
        native_lanman_->push_back(native_lanman__elem_);
        t_native_lanman__elem__dataptr += t_native_lanman__elem__size;
        BINPAC_ASSERT(t_native_lanman__elem__dataptr <= t_end_of_data);
        native_lanman__elem_ = nullptr;
    }
end_of_native_lanman: ;
    t_native_lanman__size = t_native_lanman__elem__dataptr - (t_dataptr_after_native_os);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_native_lanman = t_dataptr_after_native_os + (t_native_lanman__size);
    BINPAC_ASSERT(t_dataptr_after_native_lanman <= t_end_of_data);
    // Parse "primary_domain"
    int t_primary_domain__arraylength;
    t_primary_domain__arraylength = byte_count() == 0 ? 0 : 1;
    if ( t_primary_domain__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:primary_domain",
          t_primary_domain__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: SMB1_session_setup_andx_response_lanman:primary_domain
    if ( t_primary_domain__arraylength > ((t_end_of_data - t_dataptr_after_native_lanman) / 1) )
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:primary_domain",
          t_primary_domain__arraylength, (t_end_of_data) - (t_dataptr_after_native_lanman));
    primary_domain__elem_ = nullptr;
    int t_primary_domain__elem__it;
    t_primary_domain__elem__it = 0;
    int t_primary_domain__size;
    primary_domain_ = new vector<SMB_string*>;
    primary_domain_->reserve(t_primary_domain__arraylength);
    const_byteptr t_primary_domain__elem__dataptr = t_dataptr_after_native_lanman;
    for (; t_primary_domain__elem__it < t_primary_domain__arraylength; ++t_primary_domain__elem__it) {
        primary_domain__elem_ = new SMB_string(header()->unicode(), (t_dataptr_after_native_lanman - t_begin_of_data) + 1);
        int t_primary_domain__elem__size;
        t_primary_domain__elem__size = primary_domain__elem_->Parse(t_primary_domain__elem__dataptr, t_end_of_data, t_context);
        primary_domain_->push_back(primary_domain__elem_);
        t_primary_domain__elem__dataptr += t_primary_domain__elem__size;
        BINPAC_ASSERT(t_primary_domain__elem__dataptr <= t_end_of_data);
        primary_domain__elem_ = nullptr;
    }
end_of_primary_domain: ;
    t_primary_domain__size = t_primary_domain__elem__dataptr - (t_dataptr_after_native_lanman);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_primary_domain = t_dataptr_after_native_lanman + (t_primary_domain__size);
    BINPAC_ASSERT(t_dataptr_after_primary_domain <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_primary_domain - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_primary_domain - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_session_setup_andx_response_lanman:extra_byte_parameters"
    if ( t_dataptr_after_primary_domain + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_primary_domain + (t_extra_byte_parameters__size) < t_dataptr_after_primary_domain ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_lanman:extra_byte_parameters",
        	((t_dataptr_after_primary_domain - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_primary_domain + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_primary_domain - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_primary_domain - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:178", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_primary_domain, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_primary_domain + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), false, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_session_setup_andx_response_lanman__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_session_setup_andx_response_lanman__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    is_guest_ =  ( action() & 0x1 )  > 0;
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_response_lanman__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_response_lanman__size;
}

SMB1_session_setup_andx_request_ntlm_capabilities::SMB1_session_setup_andx_request_ntlm_capabilities() {
    capabilities_ = 0;
    unicode_ = false;
    large_files_ = false;
    nt_smbs_ = false;
    status32_ = false;
    level_2_oplocks_ = false;
    nt_find_ = false;
}

SMB1_session_setup_andx_request_ntlm_capabilities::~SMB1_session_setup_andx_request_ntlm_capabilities() {
}

int SMB1_session_setup_andx_request_ntlm_capabilities::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_capabilities"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_capabilities",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "capabilities"
    capabilities_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    unicode_ =  ( capabilities() & 0x0004 )  > 0;
    large_files_ =  ( capabilities() & 0x0008 )  > 0;
    nt_smbs_ =  ( capabilities() & 0x0010 )  > 0;
    status32_ =  ( capabilities() & 0x0040 )  > 0;
    level_2_oplocks_ =  ( capabilities() & 0x0080 )  > 0;
    nt_find_ =  ( capabilities() & 0x0200 )  > 0;
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB1_session_setup_andx_request_ntlm_nonextended_security::SMB1_session_setup_andx_request_ntlm_nonextended_security(SMB_Header* header, uint16 offset) {
    andx_ = nullptr;
    max_buffer_size_ = 0;
    max_mpx_count_ = 0;
    vc_number_ = 0;
    session_key_ = 0;
    case_insensitive_password_length_ = 0;
    case_sensitive_password_length_ = 0;
    reserved_ = 0;
    capabilities_ = nullptr;
    byte_count_ = 0;
    account_name_ = nullptr;
    primary_domain_ = nullptr;
    native_os_ = nullptr;
    native_lanman_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
}

SMB1_session_setup_andx_request_ntlm_nonextended_security::~SMB1_session_setup_andx_request_ntlm_nonextended_security() {
    delete andx_;
    andx_ = nullptr;
    delete capabilities_;
    capabilities_ = nullptr;
    case_insensitive_password_.free();
    case_sensitive_password_.free();
    delete account_name_;
    account_name_ = nullptr;
    delete primary_domain_;
    primary_domain_ = nullptr;
    delete native_os_;
    native_os_ = nullptr;
    delete native_lanman_;
    native_lanman_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_session_setup_andx_request_ntlm_nonextended_security::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_nonextended_security:byte_count"
    if ( (t_begin_of_data + 26) + (2) > t_end_of_data || (t_begin_of_data + 26) + (2) < (t_begin_of_data + 26) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_nonextended_security:byte_count",
        	(26) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "max_buffer_size"
    max_buffer_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "max_mpx_count"
    max_mpx_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "vc_number"
    vc_number_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "session_key"
    session_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 10))));

    // Parse "case_insensitive_password_length"
    case_insensitive_password_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "case_sensitive_password_length"
    case_sensitive_password_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 16))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 18))));

    // Parse "capabilities"
    capabilities_ = new SMB1_session_setup_andx_request_ntlm_capabilities();
    capabilities_->Parse((t_begin_of_data + 22), t_end_of_data, t_byteorder);

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 26))));

    // Parse "case_insensitive_password"
    int t_case_insensitive_password__size;
    t_case_insensitive_password__size = case_insensitive_password_length();
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_nonextended_security:case_insensitive_password"
    if ( (t_begin_of_data + 28) + (t_case_insensitive_password__size) > t_end_of_data || (t_begin_of_data + 28) + (t_case_insensitive_password__size) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_nonextended_security:case_insensitive_password",
        	(28) + (t_case_insensitive_password__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 28) + t_case_insensitive_password__size;
        int t_case_insensitive_password_string_length;
        t_case_insensitive_password_string_length = case_insensitive_password_length();
        // check for negative sizes
        if ( t_case_insensitive_password_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:207", t_case_insensitive_password_string_length);
        case_insensitive_password_.init((t_begin_of_data + 28), t_case_insensitive_password_string_length);
    }

    const_byteptr const t_dataptr_after_case_insensitive_password = (t_begin_of_data + 28) + (t_case_insensitive_password__size);
    BINPAC_ASSERT(t_dataptr_after_case_insensitive_password <= t_end_of_data);
    // Parse "case_sensitive_password"
    int t_case_sensitive_password__size;
    t_case_sensitive_password__size = case_sensitive_password_length();
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_nonextended_security:case_sensitive_password"
    if ( t_dataptr_after_case_insensitive_password + (t_case_sensitive_password__size) > t_end_of_data || t_dataptr_after_case_insensitive_password + (t_case_sensitive_password__size) < t_dataptr_after_case_insensitive_password ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_nonextended_security:case_sensitive_password",
        	((t_dataptr_after_case_insensitive_password - t_begin_of_data)) + (t_case_sensitive_password__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_case_insensitive_password + t_case_sensitive_password__size;
        int t_case_sensitive_password_string_length;
        t_case_sensitive_password_string_length = case_sensitive_password_length();
        // check for negative sizes
        if ( t_case_sensitive_password_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:208", t_case_sensitive_password_string_length);
        case_sensitive_password_.init(t_dataptr_after_case_insensitive_password, t_case_sensitive_password_string_length);
    }

    const_byteptr const t_dataptr_after_case_sensitive_password = t_dataptr_after_case_insensitive_password + (t_case_sensitive_password__size);
    BINPAC_ASSERT(t_dataptr_after_case_sensitive_password <= t_end_of_data);
    // Parse "account_name"
    account_name_ = new SMB_string(header()->unicode(), (t_dataptr_after_case_sensitive_password - t_begin_of_data) + 1);
    int t_account_name__size;
    t_account_name__size = account_name_->Parse(t_dataptr_after_case_sensitive_password, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_account_name = t_dataptr_after_case_sensitive_password + (t_account_name__size);
    BINPAC_ASSERT(t_dataptr_after_account_name <= t_end_of_data);
    // Parse "primary_domain"
    primary_domain_ = new SMB_string(header()->unicode(), (t_dataptr_after_account_name - t_begin_of_data) + 1);
    int t_primary_domain__size;
    t_primary_domain__size = primary_domain_->Parse(t_dataptr_after_account_name, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_primary_domain = t_dataptr_after_account_name + (t_primary_domain__size);
    BINPAC_ASSERT(t_dataptr_after_primary_domain <= t_end_of_data);
    // Parse "native_os"
    native_os_ = new SMB_string(header()->unicode(), (t_dataptr_after_primary_domain - t_begin_of_data) + 1);
    int t_native_os__size;
    t_native_os__size = native_os_->Parse(t_dataptr_after_primary_domain, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_os = t_dataptr_after_primary_domain + (t_native_os__size);
    BINPAC_ASSERT(t_dataptr_after_native_os <= t_end_of_data);
    // Parse "native_lanman"
    native_lanman_ = new SMB_string(header()->unicode(), (t_dataptr_after_native_os - t_begin_of_data) + 1);
    int t_native_lanman__size;
    t_native_lanman__size = native_lanman_->Parse(t_dataptr_after_native_os, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_lanman = t_dataptr_after_native_os + (t_native_lanman__size);
    BINPAC_ASSERT(t_dataptr_after_native_lanman <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_nonextended_security:extra_byte_parameters"
    if ( t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) < t_dataptr_after_native_lanman ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_nonextended_security:extra_byte_parameters",
        	((t_dataptr_after_native_lanman - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_native_lanman + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:215", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_native_lanman, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_native_lanman + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_session_setup_andx_request_ntlm_nonextended_security__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_session_setup_andx_request_ntlm_nonextended_security__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_request_ntlm_nonextended_security__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_request_ntlm_nonextended_security__size;
}

SMB1_session_setup_andx_request_ntlm_extended_security::SMB1_session_setup_andx_request_ntlm_extended_security(SMB_Header* header, uint16 offset) {
    andx_ = nullptr;
    max_buffer_size_ = 0;
    max_mpx_count_ = 0;
    vc_number_ = 0;
    session_key_ = 0;
    security_blob_length_ = 0;
    reserved_ = 0;
    capabilities_ = nullptr;
    byte_count_ = 0;
    native_os_ = nullptr;
    native_lanman_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    pipe_proc_ = false;
}

SMB1_session_setup_andx_request_ntlm_extended_security::~SMB1_session_setup_andx_request_ntlm_extended_security() {
    delete andx_;
    andx_ = nullptr;
    delete capabilities_;
    capabilities_ = nullptr;
    security_blob_.free();
    delete native_os_;
    native_os_ = nullptr;
    delete native_lanman_;
    native_lanman_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_session_setup_andx_request_ntlm_extended_security::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_extended_security:byte_count"
    if ( (t_begin_of_data + 24) + (2) > t_end_of_data || (t_begin_of_data + 24) + (2) < (t_begin_of_data + 24) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_extended_security:byte_count",
        	(24) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "max_buffer_size"
    max_buffer_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "max_mpx_count"
    max_mpx_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "vc_number"
    vc_number_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "session_key"
    session_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 10))));

    // Parse "security_blob_length"
    security_blob_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "capabilities"
    capabilities_ = new SMB1_session_setup_andx_request_ntlm_capabilities();
    capabilities_->Parse((t_begin_of_data + 20), t_end_of_data, t_byteorder);

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 24))));

    // Parse "security_blob"
    int t_security_blob__size;
    t_security_blob__size = security_blob_length();
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_extended_security:security_blob"
    if ( (t_begin_of_data + 26) + (t_security_blob__size) > t_end_of_data || (t_begin_of_data + 26) + (t_security_blob__size) < (t_begin_of_data + 26) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_extended_security:security_blob",
        	(26) + (t_security_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 26) + t_security_blob__size;
        int t_security_blob_string_length;
        t_security_blob_string_length = security_blob_length();
        // check for negative sizes
        if ( t_security_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:230", t_security_blob_string_length);
        security_blob_.init((t_begin_of_data + 26), t_security_blob_string_length);
    }

    const_byteptr const t_dataptr_after_security_blob = (t_begin_of_data + 26) + (t_security_blob__size);
    BINPAC_ASSERT(t_dataptr_after_security_blob <= t_end_of_data);
    // Parse "native_os"
    native_os_ = new SMB_string(header()->unicode(), (t_dataptr_after_security_blob - t_begin_of_data) + 1);
    int t_native_os__size;
    t_native_os__size = native_os_->Parse(t_dataptr_after_security_blob, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_os = t_dataptr_after_security_blob + (t_native_os__size);
    BINPAC_ASSERT(t_dataptr_after_native_os <= t_end_of_data);
    // Parse "native_lanman"
    native_lanman_ = new SMB_string(header()->unicode(), (t_dataptr_after_native_os - t_begin_of_data) + 1);
    int t_native_lanman__size;
    t_native_lanman__size = native_lanman_->Parse(t_dataptr_after_native_os, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_lanman = t_dataptr_after_native_os + (t_native_lanman__size);
    BINPAC_ASSERT(t_dataptr_after_native_lanman <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_session_setup_andx_request_ntlm_extended_security:extra_byte_parameters"
    if ( t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) < t_dataptr_after_native_lanman ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_request_ntlm_extended_security:extra_byte_parameters",
        	((t_dataptr_after_native_lanman - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_native_lanman + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:235", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_native_lanman, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_native_lanman + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_session_setup_andx_request_ntlm_extended_security__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_session_setup_andx_request_ntlm_extended_security__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    pipe_proc_ = t_context->connection()->forward_gssapi(security_blob(), true);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_request_ntlm_extended_security__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_request_ntlm_extended_security__size;
}

SMB1_session_setup_andx_response_ntlm::SMB1_session_setup_andx_response_ntlm(SMB_Header* header, uint16 offset) {
    andx_ = nullptr;
    action_ = 0;
    security_blob_length_ = 0;
    byte_count_ = 0;
    native_os_ = nullptr;
    native_lanman_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    is_guest_ = false;
    gssapi_proc_ = false;
}

SMB1_session_setup_andx_response_ntlm::~SMB1_session_setup_andx_response_ntlm() {
    delete andx_;
    andx_ = nullptr;
    security_blob_.free();
    delete native_os_;
    native_os_ = nullptr;
    delete native_lanman_;
    native_lanman_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_session_setup_andx_response_ntlm::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_session_setup_andx_response_ntlm:byte_count"
    if ( (t_begin_of_data + 8) + (2) > t_end_of_data || (t_begin_of_data + 8) + (2) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_ntlm:byte_count",
        	(8) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "action"
    action_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "security_blob_length"
    security_blob_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "security_blob"
    int t_security_blob__size;
    t_security_blob__size = security_blob_length();
    // Checking out-of-bound for "SMB1_session_setup_andx_response_ntlm:security_blob"
    if ( (t_begin_of_data + 10) + (t_security_blob__size) > t_end_of_data || (t_begin_of_data + 10) + (t_security_blob__size) < (t_begin_of_data + 10) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_ntlm:security_blob",
        	(10) + (t_security_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 10) + t_security_blob__size;
        int t_security_blob_string_length;
        t_security_blob_string_length = security_blob_length();
        // check for negative sizes
        if ( t_security_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:247", t_security_blob_string_length);
        security_blob_.init((t_begin_of_data + 10), t_security_blob_string_length);
    }

    const_byteptr const t_dataptr_after_security_blob = (t_begin_of_data + 10) + (t_security_blob__size);
    BINPAC_ASSERT(t_dataptr_after_security_blob <= t_end_of_data);
    // Parse "native_os"
    native_os_ = new SMB_string(header()->unicode(), (t_dataptr_after_security_blob - t_begin_of_data) + 1);
    int t_native_os__size;
    t_native_os__size = native_os_->Parse(t_dataptr_after_security_blob, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_os = t_dataptr_after_security_blob + (t_native_os__size);
    BINPAC_ASSERT(t_dataptr_after_native_os <= t_end_of_data);
    // Parse "native_lanman"
    native_lanman_ = new SMB_string(header()->unicode(), (t_dataptr_after_native_os - t_begin_of_data) + 1);
    int t_native_lanman__size;
    t_native_lanman__size = native_lanman_->Parse(t_dataptr_after_native_os, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_native_lanman = t_dataptr_after_native_os + (t_native_lanman__size);
    BINPAC_ASSERT(t_dataptr_after_native_lanman <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_session_setup_andx_response_ntlm:extra_byte_parameters"
    if ( t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_native_lanman + (t_extra_byte_parameters__size) < t_dataptr_after_native_lanman ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_session_setup_andx_response_ntlm:extra_byte_parameters",
        	((t_dataptr_after_native_lanman - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_native_lanman + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_lanman - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-session-setup-andx.pac:252", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_native_lanman, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_native_lanman + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), false, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_session_setup_andx_response_ntlm__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_session_setup_andx_response_ntlm__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    is_guest_ =  ( action() & 0x1 )  > 0;
    gssapi_proc_ = t_context->connection()->forward_gssapi(security_blob(), false);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_session_setup_andx_response_ntlm__size) <= t_end_of_data);
    return t_SMB1_session_setup_andx_response_ntlm__size;
}

SMB1_transaction_secondary_request::SMB1_transaction_secondary_request(SMB_Header* header) {
    word_count_ = 0;
    total_param_count_ = 0;
    total_data_count_ = 0;
    param_count_ = 0;
    param_offset_ = 0;
    param_displacement_ = 0;
    data_count_ = 0;
    data_offset_ = 0;
    data_displacement_ = 0;
    byte_count_ = 0;
    data_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_transaction_secondary_request::~SMB1_transaction_secondary_request() {
    parameters_.free();
    delete data_;
    data_ = nullptr;
}

int SMB1_transaction_secondary_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_transaction_secondary_request:byte_count"
    if ( (t_begin_of_data + 17) + (2) > t_end_of_data || (t_begin_of_data + 17) + (2) < (t_begin_of_data + 17) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_secondary_request:byte_count",
        	(17) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "total_param_count"
    total_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "total_data_count"
    total_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "param_count"
    param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "param_offset"
    param_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "param_displacement"
    param_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "data_count"
    data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "data_displacement"
    data_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));


    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (param_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad1 < (t_begin_of_data + 19) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction-secondary.pac:50:pad1", (t_begin_of_data + 19) - t_begin_of_data, param_offset() - SMB_Header_length);
        t_dataptr_after_pad1 = (t_begin_of_data + 19);
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_secondary_request:pad1",
        	(param_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "parameters"
    int t_parameters__size;
    t_parameters__size = param_count();
    // Checking out-of-bound for "SMB1_transaction_secondary_request:parameters"
    if ( t_dataptr_after_pad1 + (t_parameters__size) > t_end_of_data || t_dataptr_after_pad1 + (t_parameters__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_secondary_request:parameters",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_parameters__size;
        int t_parameters_string_length;
        t_parameters_string_length = param_count();
        // check for negative sizes
        if ( t_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction-secondary.pac:51", t_parameters_string_length);
        parameters_.init(t_dataptr_after_pad1, t_parameters_string_length);
    }


    const_byteptr const t_dataptr_after_parameters = t_dataptr_after_pad1 + (t_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_parameters <= t_end_of_data);
    const_byteptr t_dataptr_after_pad2 = t_begin_of_data + (data_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad2 < t_dataptr_after_parameters ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction-secondary.pac:52:pad2", t_dataptr_after_parameters - t_begin_of_data, data_offset() - SMB_Header_length);
        t_dataptr_after_pad2 = t_dataptr_after_parameters;
    }
    if ( t_dataptr_after_pad2 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_secondary_request:pad2",
        	(data_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad2));
    }
    // Parse "data"
    data_ = new SMB1_transaction_data(header(), true, data_count(), 0, SMB_UNKNOWN, false);
    int t_data__size;
    t_data__size = data_->Parse(t_dataptr_after_pad2, t_end_of_data, t_context);

    int t_SMB1_transaction_secondary_request__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad2 + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB1_transaction_secondary_request__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_transaction_secondary_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_transaction_secondary_request__size) <= t_end_of_data);
    return t_SMB1_transaction_secondary_request__size;
}


	zeek::StringValPtr SMB_Conn::transaction_data_to_val(SMB1_transaction_data* payload)
		{
		switch ( payload->trans_type() ) {
		case SMB_PIPE:
			return to_stringval(payload->pipe_data());
		case SMB_UNKNOWN:
			return to_stringval(payload->unknown());
		default:
			return to_stringval(payload->data());
		}

		assert(false);
		return zeek::val_mgr->EmptyString();
		}

SMB1_transaction_data::SMB1_transaction_data(SMB_Header* header, bool is_orig, uint16 count, uint16 sub_cmd, int trans_type, bool is_pipe) {
    val_case_index_ = -1;
    header_ = header;
    is_orig_ = is_orig;
    count_ = count;
    sub_cmd_ = sub_cmd;
    trans_type_ = trans_type;
    is_pipe_ = is_pipe;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
}

SMB1_transaction_data::~SMB1_transaction_data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)2):
            // Clean up "pipe_data"
            {
                pipe_data_.free();
            }
            break;
        case ((int)4):
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
        default:
            // Clean up "data"
            {
                data_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB1_transaction_data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = trans_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)2):
            // Parse "pipe_data"
            {
                int t_pipe_data_string_length;
                t_pipe_data_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_pipe_data__size;
                t_pipe_data__size = t_pipe_data_string_length;
                // check for negative sizes
                if ( t_pipe_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:105", t_pipe_data_string_length);
                pipe_data_.init(t_begin_of_data, t_pipe_data_string_length);
                t_val__size = t_pipe_data__size;
            }
            break;
        case ((int)4):
            // Parse "unknown"
            {
                int t_unknown_string_length;
                t_unknown_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown__size;
                t_unknown__size = t_unknown_string_length;
                // check for negative sizes
                if ( t_unknown_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:106", t_unknown_string_length);
                unknown_.init(t_begin_of_data, t_unknown_string_length);
                t_val__size = t_unknown__size;
            }
            break;
        default:
            // Parse "data"
            {
                int t_data_string_length;
                t_data_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_data__size;
                t_data__size = t_data_string_length;
                // check for negative sizes
                if ( t_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:107", t_data_string_length);
                data_.init(t_begin_of_data, t_data_string_length);
                t_val__size = t_data__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    has_pipe_proc_ =  ( trans_type() == SMB_PIPE ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(pipe_data(), 0, is_orig());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB1_transaction_request::SMB1_transaction_request(SMB_Header* header) {
    word_count_ = 0;
    total_param_count_ = 0;
    total_data_count_ = 0;
    max_param_count_ = 0;
    max_data_count_ = 0;
    max_setup_count_ = 0;
    reserved1_ = 0;
    flags_ = 0;
    timeout_ = 0;
    reserved2_ = 0;
    param_count_ = 0;
    param_offset_ = 0;
    data_count_ = 0;
    data_offset_ = 0;
    setup_count_ = 0;
    reserved3_ = 0;
    setup_ = nullptr;
    setup__elem_ = 0;
    byte_count_ = 0;
    name_ = nullptr;
    data_ = nullptr;
    header_ = header;
    sub_cmd_ = 0;
    transtype_ = 0;
    is_pipe_ = false;
    proc_set_pipe_ = false;
    proc_ = false;
}

SMB1_transaction_request::~SMB1_transaction_request() {
    delete setup_;
    delete name_;
    name_ = nullptr;
    parameters_.free();
    delete data_;
    data_ = nullptr;
}

int SMB1_transaction_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_transaction_request:reserved3"
    if ( (t_begin_of_data + 28) + (1) > t_end_of_data || (t_begin_of_data + 28) + (1) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:reserved3",
        	(28) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "total_param_count"
    total_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "total_data_count"
    total_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "max_param_count"
    max_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "max_data_count"
    max_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "max_setup_count"
    max_setup_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 9)));

    // Parse "reserved1"
    reserved1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 10)));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "timeout"
    timeout_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 13))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "param_count"
    param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 19))));

    // Parse "param_offset"
    param_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 21))));

    // Parse "data_count"
    data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 23))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 25))));

    // Parse "setup_count"
    setup_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 27)));

    // Parse "reserved3"
    reserved3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 28)));

    // Parse "setup"
    int t_setup__arraylength;
    t_setup__arraylength = setup_count();
    if ( t_setup__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:setup",
          t_setup__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB1_transaction_request:setup
    if ( t_setup__arraylength > ((t_end_of_data - (t_begin_of_data + 29)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:setup",
          t_setup__arraylength, (t_end_of_data) - ((t_begin_of_data + 29)));
    setup__elem_ = 0;
    int t_setup__elem__it;
    t_setup__elem__it = 0;
    int t_setup__size;
    setup_ = new vector<uint16>;
    setup_->reserve(t_setup__arraylength);
    const_byteptr t_setup__elem__dataptr = (t_begin_of_data + 29);
    for (; t_setup__elem__it < t_setup__arraylength; ++t_setup__elem__it) {
        setup__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_setup__elem__dataptr)));
        setup_->push_back(setup__elem_);
        t_setup__elem__dataptr += 2;
        BINPAC_ASSERT(t_setup__elem__dataptr <= t_end_of_data);
    }
end_of_setup: ;
    t_setup__size = t_setup__elem__dataptr - ((t_begin_of_data + 29));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_setup = (t_begin_of_data + 29) + (t_setup__size);
    BINPAC_ASSERT(t_dataptr_after_setup <= t_end_of_data);
    // Checking out-of-bound for "SMB1_transaction_request:byte_count"
    if ( t_dataptr_after_setup + (2) > t_end_of_data || t_dataptr_after_setup + (2) < t_dataptr_after_setup ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:byte_count",
        	((t_dataptr_after_setup - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_setup)));

    // Parse "name"
    name_ = new SMB_string(header()->unicode(), ((t_dataptr_after_setup + 2) - t_begin_of_data));
    int t_name__size;
    t_name__size = name_->Parse((t_dataptr_after_setup + 2), t_end_of_data, t_context);


    const_byteptr const t_dataptr_after_name = (t_dataptr_after_setup + 2) + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (param_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad1 < t_dataptr_after_name ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:134:pad1", t_dataptr_after_name - t_begin_of_data, param_offset() - SMB_Header_length);
        t_dataptr_after_pad1 = t_dataptr_after_name;
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:pad1",
        	(param_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "parameters"
    int t_parameters__size;
    t_parameters__size = param_count();
    // Checking out-of-bound for "SMB1_transaction_request:parameters"
    if ( t_dataptr_after_pad1 + (t_parameters__size) > t_end_of_data || t_dataptr_after_pad1 + (t_parameters__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:parameters",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_parameters__size;
        int t_parameters_string_length;
        t_parameters_string_length = param_count();
        // check for negative sizes
        if ( t_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:135", t_parameters_string_length);
        parameters_.init(t_dataptr_after_pad1, t_parameters_string_length);
    }


    const_byteptr const t_dataptr_after_parameters = t_dataptr_after_pad1 + (t_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_parameters <= t_end_of_data);
    const_byteptr t_dataptr_after_pad2 = t_begin_of_data + (data_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad2 < t_dataptr_after_parameters ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:136:pad2", t_dataptr_after_parameters - t_begin_of_data, data_offset() - SMB_Header_length);
        t_dataptr_after_pad2 = t_dataptr_after_parameters;
    }
    if ( t_dataptr_after_pad2 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_request:pad2",
        	(data_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad2));
    }
    // Parse "data"
    sub_cmd_ =  ( (t_dataptr_after_setup - (t_begin_of_data + 29)) > 0 && word_count() != 16 )  ? (*(setup()))[0] : 0;
    transtype_ = determine_transaction_type(header(), name());
    is_pipe_ =  ( transtype() == SMB_PIPE ||  ( transtype() == SMB_UNKNOWN && t_context->connection()->get_tree_is_pipe(header()->tid()) )  ) ;
    data_ = new SMB1_transaction_data(header(), true, data_count(), sub_cmd(), transtype(), is_pipe());
    int t_data__size;
    t_data__size = data_->Parse(t_dataptr_after_pad2, t_end_of_data, t_context);

    int t_SMB1_transaction_request__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad2 + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB1_transaction_request__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_set_pipe_ = t_context->connection()->set_is_file_a_pipe(header()->mid(), is_pipe());
    proc_ = t_context->connection()->proc_smb1_transaction_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_transaction_request__size) <= t_end_of_data);
    return t_SMB1_transaction_request__size;
}

SMB1_transaction_response::SMB1_transaction_response(SMB_Header* header) {
    word_count_ = 0;
    total_param_count_ = 0;
    total_data_count_ = 0;
    reserved_ = 0;
    param_count_ = 0;
    param_offset_ = 0;
    param_displacement_ = 0;
    data_count_ = 0;
    data_offset_ = 0;
    data_displacement_ = 0;
    setup_count_ = 0;
    reserved2_ = 0;
    setup_ = nullptr;
    setup__elem_ = 0;
    byte_count_ = 0;
    data_ = nullptr;
    data__elem_ = nullptr;
    header_ = header;
    proc_ = false;
    is_pipe_ = false;
}

SMB1_transaction_response::~SMB1_transaction_response() {
    delete setup_;
    parameters_.free();
    delete data__elem_;
    data__elem_ = nullptr;
    if ( data() ) {
        for ( auto* data__elem_ : *data() ) {
            delete data__elem_;
            data__elem_ = nullptr;
        }
    }
    delete data_;
}

int SMB1_transaction_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_transaction_response:reserved2"
    if ( (t_begin_of_data + 20) + (1) > t_end_of_data || (t_begin_of_data + 20) + (1) < (t_begin_of_data + 20) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:reserved2",
        	(20) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "total_param_count"
    total_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "total_data_count"
    total_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "param_count"
    param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "param_offset"
    param_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "param_displacement"
    param_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "data_count"
    data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "data_displacement"
    data_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "setup_count"
    setup_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 19)));

    // Parse "reserved2"
    reserved2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 20)));

    // Parse "setup"
    int t_setup__arraylength;
    t_setup__arraylength = setup_count();
    if ( t_setup__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:setup",
          t_setup__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB1_transaction_response:setup
    if ( t_setup__arraylength > ((t_end_of_data - (t_begin_of_data + 21)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:setup",
          t_setup__arraylength, (t_end_of_data) - ((t_begin_of_data + 21)));
    setup__elem_ = 0;
    int t_setup__elem__it;
    t_setup__elem__it = 0;
    int t_setup__size;
    setup_ = new vector<uint16>;
    setup_->reserve(t_setup__arraylength);
    const_byteptr t_setup__elem__dataptr = (t_begin_of_data + 21);
    for (; t_setup__elem__it < t_setup__arraylength; ++t_setup__elem__it) {
        setup__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_setup__elem__dataptr)));
        setup_->push_back(setup__elem_);
        t_setup__elem__dataptr += 2;
        BINPAC_ASSERT(t_setup__elem__dataptr <= t_end_of_data);
    }
end_of_setup: ;
    t_setup__size = t_setup__elem__dataptr - ((t_begin_of_data + 21));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_setup = (t_begin_of_data + 21) + (t_setup__size);
    BINPAC_ASSERT(t_dataptr_after_setup <= t_end_of_data);
    // Checking out-of-bound for "SMB1_transaction_response:byte_count"
    if ( t_dataptr_after_setup + (2) > t_end_of_data || t_dataptr_after_setup + (2) < t_dataptr_after_setup ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:byte_count",
        	((t_dataptr_after_setup - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_setup)));


    const_byteptr t_dataptr_after_pad0 = t_begin_of_data + (param_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad0 < (t_dataptr_after_setup + 2) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:163:pad0", (t_dataptr_after_setup + 2) - t_begin_of_data, param_offset() - SMB_Header_length);
        t_dataptr_after_pad0 = (t_dataptr_after_setup + 2);
    }
    if ( t_dataptr_after_pad0 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:pad0",
        	(param_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad0));
    }
    // Parse "parameters"
    int t_parameters__size;
    t_parameters__size = param_count();
    // Checking out-of-bound for "SMB1_transaction_response:parameters"
    if ( t_dataptr_after_pad0 + (t_parameters__size) > t_end_of_data || t_dataptr_after_pad0 + (t_parameters__size) < t_dataptr_after_pad0 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:parameters",
        	((t_dataptr_after_pad0 - t_begin_of_data)) + (t_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad0 + t_parameters__size;
        int t_parameters_string_length;
        t_parameters_string_length = param_count();
        // check for negative sizes
        if ( t_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:164", t_parameters_string_length);
        parameters_.init(t_dataptr_after_pad0, t_parameters_string_length);
    }


    const_byteptr const t_dataptr_after_parameters = t_dataptr_after_pad0 + (t_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_parameters <= t_end_of_data);
    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (data_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad1 < t_dataptr_after_parameters ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction.pac:165:pad1", t_dataptr_after_parameters - t_begin_of_data, data_offset() - SMB_Header_length);
        t_dataptr_after_pad1 = t_dataptr_after_parameters;
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:pad1",
        	(data_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "data"
    int t_data__arraylength;
    t_data__arraylength = data_count() > 0 ? 1 : 0;
    if ( t_data__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:data",
          t_data__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: SMB1_transaction_response:data
    if ( t_data__arraylength > ((t_end_of_data - t_dataptr_after_pad1) / 1) )
        throw binpac::ExceptionOutOfBound("SMB1_transaction_response:data",
          t_data__arraylength, (t_end_of_data) - (t_dataptr_after_pad1));
    data__elem_ = nullptr;
    int t_data__elem__it;
    t_data__elem__it = 0;
    int t_data__size;
    data_ = new vector<SMB1_transaction_data*>;
    data_->reserve(t_data__arraylength);
    const_byteptr t_data__elem__dataptr = t_dataptr_after_pad1;
    for (; t_data__elem__it < t_data__arraylength; ++t_data__elem__it) {
        is_pipe_ = t_context->connection()->get_is_file_a_pipe(header()->mid());
        data__elem_ = new SMB1_transaction_data(header(), false, data_count(), 0, is_pipe() ? SMB_PIPE : SMB_UNKNOWN, is_pipe());
        int t_data__elem__size;
        t_data__elem__size = data__elem_->Parse(t_data__elem__dataptr, t_end_of_data, t_context);
        data_->push_back(data__elem_);
        t_data__elem__dataptr += t_data__elem__size;
        BINPAC_ASSERT(t_data__elem__dataptr <= t_end_of_data);
        data__elem_ = nullptr;
    }
end_of_data: ;
    t_data__size = t_data__elem__dataptr - (t_dataptr_after_pad1);
    // Evaluate 'let' and 'withinput' fields

    int t_SMB1_transaction_response__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad1 + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB1_transaction_response__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_transaction_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_transaction_response__size) <= t_end_of_data);
    return t_SMB1_transaction_response__size;
}

SMB1_transaction2_request::SMB1_transaction2_request(SMB_Header* header) {
    word_count_ = 0;
    total_param_count_ = 0;
    total_data_count_ = 0;
    max_param_count_ = 0;
    max_data_count_ = 0;
    max_setup_count_ = 0;
    reserved1_ = 0;
    flags_ = 0;
    timeout_ = 0;
    reserved2_ = 0;
    param_count_ = 0;
    param_offset_ = 0;
    data_count_ = 0;
    data_offset_ = 0;
    setup_count_ = 0;
    reserved3_ = 0;
    sub_cmd_ = 0;
    byte_count_ = 0;
    parameters_case_index_ = -1;
    find_first2_ = nullptr;
    query_fs_info_ = nullptr;
    query_path_info_ = nullptr;
    query_file_info_ = nullptr;
    set_file_info_ = nullptr;
    get_dfs_referral_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB1_transaction2_request::~SMB1_transaction2_request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parameters_case_index() ) {
        case ((uint16)1):
            // Clean up "find_first2"
            {
                delete find_first2_;
                find_first2_ = nullptr;
            }
            break;
        case ((uint16)3):
            // Clean up "query_fs_info"
            {
                delete query_fs_info_;
                query_fs_info_ = nullptr;
            }
            break;
        case ((uint16)5):
            // Clean up "query_path_info"
            {
                delete query_path_info_;
                query_path_info_ = nullptr;
            }
            break;
        case ((uint16)7):
            // Clean up "query_file_info"
            {
                delete query_file_info_;
                query_file_info_ = nullptr;
            }
            break;
        case ((uint16)8):
            // Clean up "set_file_info"
            {
                delete set_file_info_;
                set_file_info_ = nullptr;
            }
            break;
        case ((uint16)16):
            // Clean up "get_dfs_referral"
            {
                delete get_dfs_referral_;
                get_dfs_referral_ = nullptr;
            }
            break;
        default:
            // Clean up "blah"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB1_transaction2_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_transaction2_request:byte_count"
    if ( (t_begin_of_data + 31) + (2) > t_end_of_data || (t_begin_of_data + 31) + (2) < (t_begin_of_data + 31) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_request:byte_count",
        	(31) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "total_param_count"
    total_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "total_data_count"
    total_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "max_param_count"
    max_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "max_data_count"
    max_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "max_setup_count"
    max_setup_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 9)));

    // Parse "reserved1"
    reserved1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 10)));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "timeout"
    timeout_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 13))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "param_count"
    param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 19))));

    // Parse "param_offset"
    param_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 21))));

    // Parse "data_count"
    data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 23))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 25))));

    // Parse "setup_count"
    setup_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 27)));

    // Parse "reserved3"
    reserved3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 28)));

    // Parse "sub_cmd"
    sub_cmd_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 29))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 31))));


    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + ( ( param_offset() - SMB_Header_length ) );
    if ( t_dataptr_after_pad1 < (t_begin_of_data + 33) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:84:pad1", (t_begin_of_data + 33) - t_begin_of_data,  ( param_offset() - SMB_Header_length ) );
        t_dataptr_after_pad1 = (t_begin_of_data + 33);
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_request:pad1",
        	( ( param_offset() - SMB_Header_length ) ), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "parameters"
    int t_parameters__size;
    parameters_case_index_ = sub_cmd();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parameters_case_index() ) {
        case ((uint16)1):
            // Parse "find_first2"
            {
                find_first2_ = new trans2_find_first2_request(header());
                int t_find_first2__size;
                t_find_first2__size = find_first2_->Parse(t_dataptr_after_pad1, t_end_of_data, t_context, t_byteorder);
                t_parameters__size = t_find_first2__size;
            }
            break;
        case ((uint16)3):
            // Parse "query_fs_info"
            {
                query_fs_info_ = new trans2_query_fs_info_request(header());
                query_fs_info_->Parse(nullptr, nullptr, t_context);
                t_parameters__size = 0;
            }
            break;
        case ((uint16)5):
            // Parse "query_path_info"
            {
                query_path_info_ = new trans2_query_path_info_request(header());
                int t_query_path_info__size;
                t_query_path_info__size = query_path_info_->Parse(t_dataptr_after_pad1, t_end_of_data, t_context, t_byteorder);
                t_parameters__size = t_query_path_info__size;
            }
            break;
        case ((uint16)7):
            // Parse "query_file_info"
            {
                query_file_info_ = new trans2_query_file_info_request(header());
                query_file_info_->Parse(t_dataptr_after_pad1, t_end_of_data, t_context, t_byteorder);
                t_parameters__size = 4;
            }
            break;
        case ((uint16)8):
            // Parse "set_file_info"
            {
                set_file_info_ = new trans2_set_file_info_request(header());
                set_file_info_->Parse(nullptr, nullptr, t_context);
                t_parameters__size = 0;
            }
            break;
        case ((uint16)16):
            // Parse "get_dfs_referral"
            {
                get_dfs_referral_ = new trans2_get_dfs_referral_request(header());
                int t_get_dfs_referral__size;
                t_get_dfs_referral__size = get_dfs_referral_->Parse(t_dataptr_after_pad1, t_end_of_data, t_context, t_byteorder);
                t_parameters__size = t_get_dfs_referral__size;
            }
            break;
        default:
            // Parse "blah"
            {
                int t_blah_string_length;
                t_blah_string_length = (t_end_of_data) - (t_dataptr_after_pad1);
                int t_blah__size;
                t_blah__size = t_blah_string_length;
                // check for negative sizes
                if ( t_blah_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:92", t_blah_string_length);
                blah_.init(t_dataptr_after_pad1, t_blah_string_length);
                t_parameters__size = t_blah__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB1_transaction2_request__size;
    const_byteptr const t_dataptr_after_parameters = t_dataptr_after_pad1 + (t_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_parameters <= t_end_of_data);
    t_SMB1_transaction2_request__size = t_dataptr_after_parameters - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_transaction2_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_transaction2_request__size) <= t_end_of_data);
    return t_SMB1_transaction2_request__size;
}

SMB1_transaction2_response::SMB1_transaction2_response(SMB_Header* header) {
    word_count_ = 0;
    total_param_count_ = 0;
    total_data_count_ = 0;
    reserved1_ = 0;
    param_count_ = 0;
    param_offset_ = 0;
    param_displacement_ = 0;
    data_count_ = 0;
    data_offset_ = 0;
    data_displacement_ = 0;
    setup_count_ = 0;
    reserved2_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_transaction2_response::~SMB1_transaction2_response() {
    stuff_.free();
}

int SMB1_transaction2_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_transaction2_response:byte_count"
    if ( (t_begin_of_data + 21) + (2) > t_end_of_data || (t_begin_of_data + 21) + (2) < (t_begin_of_data + 21) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_response:byte_count",
        	(21) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "total_param_count"
    total_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "total_data_count"
    total_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "reserved1"
    reserved1_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "param_count"
    param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "param_offset"
    param_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "param_displacement"
    param_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "data_count"
    data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "data_displacement"
    data_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "setup_count"
    setup_count_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 19)));

    // Parse "reserved2"
    reserved2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 20)));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 21))));

    // Parse "stuff"
    int t_stuff__size;
    t_stuff__size = byte_count();
    // Checking out-of-bound for "SMB1_transaction2_response:stuff"
    if ( (t_begin_of_data + 23) + (t_stuff__size) > t_end_of_data || (t_begin_of_data + 23) + (t_stuff__size) < (t_begin_of_data + 23) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_response:stuff",
        	(23) + (t_stuff__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 23) + t_stuff__size;
        int t_stuff_string_length;
        t_stuff_string_length = byte_count();
        // check for negative sizes
        if ( t_stuff_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2.pac:116", t_stuff_string_length);
        stuff_.init((t_begin_of_data + 23), t_stuff_string_length);
    }

    int t_SMB1_transaction2_response__size;
    const_byteptr const t_dataptr_after_stuff = (t_begin_of_data + 23) + (t_stuff__size);
    BINPAC_ASSERT(t_dataptr_after_stuff <= t_end_of_data);
    t_SMB1_transaction2_response__size = t_dataptr_after_stuff - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_transaction2_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_transaction2_response__size) <= t_end_of_data);
    return t_SMB1_transaction2_response__size;
}

trans2_find_first2_request::trans2_find_first2_request(SMB_Header* header) {
    search_attrs_ = 0;
    search_count_ = 0;
    flags_ = 0;
    info_level_ = 0;
    search_storage_type_ = 0;
    file_name_ = nullptr;
    header_ = header;
    proc_ = false;
}

trans2_find_first2_request::~trans2_find_first2_request() {
    delete file_name_;
    file_name_ = nullptr;
}

int trans2_find_first2_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "trans2_find_first2_request:search_storage_type"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_find_first2_request:search_storage_type",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "search_attrs"
    search_attrs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "search_count"
    search_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "info_level"
    info_level_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "search_storage_type"
    search_storage_type_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "file_name"
    file_name_ = new SMB_string(header()->unicode(), 12);
    int t_file_name__size;
    t_file_name__size = file_name_->Parse((t_begin_of_data + 12), t_end_of_data, t_context);

    int t_trans2_find_first2_request__size;
    const_byteptr const t_dataptr_after_file_name = (t_begin_of_data + 12) + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    t_trans2_find_first2_request__size = t_dataptr_after_file_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_find_first2_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_trans2_find_first2_request__size) <= t_end_of_data);
    return t_trans2_find_first2_request__size;
}

trans2_find_first2_response::trans2_find_first2_response(SMB_Header* header) {
    sid_ = 0;
    search_count_ = 0;
    end_of_search_ = 0;
    ea_error_offset_ = 0;
    last_name_offset_ = 0;
    header_ = header;
    proc_ = false;
}

trans2_find_first2_response::~trans2_find_first2_response() {
}

int trans2_find_first2_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "trans2_find_first2_response"
    if ( t_begin_of_data + (10) > t_end_of_data || t_begin_of_data + (10) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_find_first2_response",
        	(0) + (10), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "sid"
    sid_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "search_count"
    search_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "end_of_search"
    end_of_search_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "ea_error_offset"
    ea_error_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "last_name_offset"
    last_name_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_find_first2_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (10) <= t_end_of_data);
    return 10;
}

trans2_query_fs_info_request::trans2_query_fs_info_request(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_query_fs_info_request::~trans2_query_fs_info_request() {
}

int trans2_query_fs_info_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_query_fs_info_request"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_query_fs_info_request",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_query_fs_info_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

trans2_query_fs_info_response::trans2_query_fs_info_response(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_query_fs_info_response::~trans2_query_fs_info_response() {
}

int trans2_query_fs_info_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_query_fs_info_response"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_query_fs_info_response",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_query_fs_info_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

trans2_query_path_info_request::trans2_query_path_info_request(SMB_Header* header) {
    information_level_ = 0;
    reserved_ = 0;
    file_name_ = nullptr;
    header_ = header;
    proc_ = false;
}

trans2_query_path_info_request::~trans2_query_path_info_request() {
    delete file_name_;
    file_name_ = nullptr;
}

int trans2_query_path_info_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "trans2_query_path_info_request:reserved"
    if ( (t_begin_of_data + 2) + (4) > t_end_of_data || (t_begin_of_data + 2) + (4) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_query_path_info_request:reserved",
        	(2) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "information_level"
    information_level_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "file_name"
    file_name_ = new SMB_string(header()->unicode(), 6);
    int t_file_name__size;
    t_file_name__size = file_name_->Parse((t_begin_of_data + 6), t_end_of_data, t_context);

    int t_trans2_query_path_info_request__size;
    const_byteptr const t_dataptr_after_file_name = (t_begin_of_data + 6) + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    t_trans2_query_path_info_request__size = t_dataptr_after_file_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_query_path_info_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_trans2_query_path_info_request__size) <= t_end_of_data);
    return t_trans2_query_path_info_request__size;
}

trans2_query_path_info_response::trans2_query_path_info_response(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_query_path_info_response::~trans2_query_path_info_response() {
}

int trans2_query_path_info_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_query_path_info_response"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_query_path_info_response",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_query_path_info_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

trans2_query_file_info_request::trans2_query_file_info_request(SMB_Header* header) {
    file_id_ = 0;
    information_level_ = 0;
    header_ = header;
    proc_ = false;
}

trans2_query_file_info_request::~trans2_query_file_info_request() {
}

int trans2_query_file_info_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "trans2_query_file_info_request"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_query_file_info_request",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "file_id"
    file_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "information_level"
    information_level_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_query_file_info_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

trans2_query_file_info_response::trans2_query_file_info_response(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_query_file_info_response::~trans2_query_file_info_response() {
}

int trans2_query_file_info_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_query_file_info_response"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_query_file_info_response",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_query_file_info_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

trans2_set_file_info_request::trans2_set_file_info_request(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_set_file_info_request::~trans2_set_file_info_request() {
}

int trans2_set_file_info_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_set_file_info_request"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_set_file_info_request",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_set_file_info_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

trans2_set_file_info_response::trans2_set_file_info_response(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_set_file_info_response::~trans2_set_file_info_response() {
}

int trans2_set_file_info_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_set_file_info_response"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_set_file_info_response",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_set_file_info_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

trans2_get_dfs_referral_request::trans2_get_dfs_referral_request(SMB_Header* header) {
    max_referral_level_ = 0;
    file_name_ = nullptr;
    header_ = header;
    proc_ = false;
}

trans2_get_dfs_referral_request::~trans2_get_dfs_referral_request() {
    delete file_name_;
    file_name_ = nullptr;
}

int trans2_get_dfs_referral_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "trans2_get_dfs_referral_request:max_referral_level"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_get_dfs_referral_request:max_referral_level",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "max_referral_level"
    max_referral_level_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "file_name"
    file_name_ = new SMB_string(header()->unicode(), 2);
    int t_file_name__size;
    t_file_name__size = file_name_->Parse((t_begin_of_data + 2), t_end_of_data, t_context);

    int t_trans2_get_dfs_referral_request__size;
    const_byteptr const t_dataptr_after_file_name = (t_begin_of_data + 2) + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    t_trans2_get_dfs_referral_request__size = t_dataptr_after_file_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_get_dfs_referral_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_trans2_get_dfs_referral_request__size) <= t_end_of_data);
    return t_trans2_get_dfs_referral_request__size;
}

trans2_get_dfs_referral_response::trans2_get_dfs_referral_response(SMB_Header* header) {
    header_ = header;
    proc_ = false;
}

trans2_get_dfs_referral_response::~trans2_get_dfs_referral_response() {
}

int trans2_get_dfs_referral_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "trans2_get_dfs_referral_response"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("trans2_get_dfs_referral_response",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_trans2_get_dfs_referral_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

SMB1_transaction2_secondary_request::SMB1_transaction2_secondary_request(SMB_Header* header) {
    word_count_ = 0;
    total_param_count_ = 0;
    total_data_count_ = 0;
    param_count_ = 0;
    param_offset_ = 0;
    param_displacement_ = 0;
    data_count_ = 0;
    data_offset_ = 0;
    data_displacement_ = 0;
    FID_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB1_transaction2_secondary_request::~SMB1_transaction2_secondary_request() {
    parameters_.free();
    data_.free();
}

int SMB1_transaction2_secondary_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_transaction2_secondary_request:byte_count"
    if ( (t_begin_of_data + 19) + (2) > t_end_of_data || (t_begin_of_data + 19) + (2) < (t_begin_of_data + 19) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_secondary_request:byte_count",
        	(19) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "total_param_count"
    total_param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "total_data_count"
    total_data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));

    // Parse "param_count"
    param_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "param_offset"
    param_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "param_displacement"
    param_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "data_count"
    data_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "data_displacement"
    data_displacement_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "FID"
    FID_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 19))));


    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + ( ( param_offset() - SMB_Header_length ) );
    if ( t_dataptr_after_pad1 < (t_begin_of_data + 21) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2-secondary.pac:46:pad1", (t_begin_of_data + 21) - t_begin_of_data,  ( param_offset() - SMB_Header_length ) );
        t_dataptr_after_pad1 = (t_begin_of_data + 21);
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_secondary_request:pad1",
        	( ( param_offset() - SMB_Header_length ) ), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "parameters"
    int t_parameters__size;
    t_parameters__size = param_count();
    // Checking out-of-bound for "SMB1_transaction2_secondary_request:parameters"
    if ( t_dataptr_after_pad1 + (t_parameters__size) > t_end_of_data || t_dataptr_after_pad1 + (t_parameters__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_secondary_request:parameters",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_parameters__size;
        int t_parameters_string_length;
        t_parameters_string_length = param_count();
        // check for negative sizes
        if ( t_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2-secondary.pac:47", t_parameters_string_length);
        parameters_.init(t_dataptr_after_pad1, t_parameters_string_length);
    }


    const_byteptr const t_dataptr_after_parameters = t_dataptr_after_pad1 + (t_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_parameters <= t_end_of_data);
    const_byteptr t_dataptr_after_pad2 = t_begin_of_data + ( ( data_offset() - SMB_Header_length ) );
    if ( t_dataptr_after_pad2 < t_dataptr_after_parameters ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2-secondary.pac:48:pad2", t_dataptr_after_parameters - t_begin_of_data,  ( data_offset() - SMB_Header_length ) );
        t_dataptr_after_pad2 = t_dataptr_after_parameters;
    }
    if ( t_dataptr_after_pad2 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_secondary_request:pad2",
        	( ( data_offset() - SMB_Header_length ) ), 
        	(t_end_of_data) - (t_dataptr_after_pad2));
    }
    // Parse "data"
    int t_data__size;
    t_data__size = data_count();
    // Checking out-of-bound for "SMB1_transaction2_secondary_request:data"
    if ( t_dataptr_after_pad2 + (t_data__size) > t_end_of_data || t_dataptr_after_pad2 + (t_data__size) < t_dataptr_after_pad2 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_transaction2_secondary_request:data",
        	((t_dataptr_after_pad2 - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad2 + t_data__size;
        int t_data_string_length;
        t_data_string_length = data_count();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-transaction2-secondary.pac:49", t_data_string_length);
        data_.init(t_dataptr_after_pad2, t_data_string_length);
    }

    int t_SMB1_transaction2_secondary_request__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad2 + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB1_transaction2_secondary_request__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_transaction2_secondary_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_transaction2_secondary_request__size) <= t_end_of_data);
    return t_SMB1_transaction2_secondary_request__size;
}

SMB1_tree_connect_andx_request::SMB1_tree_connect_andx_request(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    flags_ = 0;
    password_length_ = 0;
    byte_count_ = 0;
    password_ = nullptr;
    password__elem_ = 0;
    path_ = nullptr;
    service_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_tree_connect_andx_request::~SMB1_tree_connect_andx_request() {
    delete andx_;
    andx_ = nullptr;
    delete password_;
    delete path_;
    path_ = nullptr;
    delete service_;
    service_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_tree_connect_andx_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_tree_connect_andx_request:byte_count"
    if ( (t_begin_of_data + 9) + (2) > t_end_of_data || (t_begin_of_data + 9) + (2) < (t_begin_of_data + 9) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_request:byte_count",
        	(9) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "password_length"
    password_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "password"
    int t_password__arraylength;
    t_password__arraylength = password_length();
    if ( t_password__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_request:password",
          t_password__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB1_tree_connect_andx_request:password
    if ( t_password__arraylength > ((t_end_of_data - (t_begin_of_data + 11)) / 1) )
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_request:password",
          t_password__arraylength, (t_end_of_data) - ((t_begin_of_data + 11)));
    password__elem_ = 0;
    int t_password__elem__it;
    t_password__elem__it = 0;
    int t_password__size;
    password_ = new vector<uint8>;
    password_->reserve(t_password__arraylength);
    const_byteptr t_password__elem__dataptr = (t_begin_of_data + 11);
    for (; t_password__elem__it < t_password__arraylength; ++t_password__elem__it) {
        password__elem_ = *(reinterpret_cast<uint8 const*>(t_password__elem__dataptr));
        password_->push_back(password__elem_);
        t_password__elem__dataptr += 1;
        BINPAC_ASSERT(t_password__elem__dataptr <= t_end_of_data);
    }
end_of_password: ;
    t_password__size = t_password__elem__dataptr - ((t_begin_of_data + 11));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_password = (t_begin_of_data + 11) + (t_password__size);
    BINPAC_ASSERT(t_dataptr_after_password <= t_end_of_data);
    // Parse "path"
    path_ = new SMB_string(header()->unicode(), (t_dataptr_after_password - t_begin_of_data));
    int t_path__size;
    t_path__size = path_->Parse(t_dataptr_after_password, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_path = t_dataptr_after_password + (t_path__size);
    BINPAC_ASSERT(t_dataptr_after_path <= t_end_of_data);
    // Parse "service"
    service_ = new SMB_string(false, (t_dataptr_after_path - t_begin_of_data));
    int t_service__size;
    t_service__size = service_->Parse(t_dataptr_after_path, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_service = t_dataptr_after_path + (t_service__size);
    BINPAC_ASSERT(t_dataptr_after_service <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_service - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_service - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_tree_connect_andx_request:extra_byte_parameters"
    if ( t_dataptr_after_service + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_service + (t_extra_byte_parameters__size) < t_dataptr_after_service ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_request:extra_byte_parameters",
        	((t_dataptr_after_service - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_service + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_service - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_service - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-tree-connect-andx.pac:47", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_service, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_service + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_tree_connect_andx_request__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_tree_connect_andx_request__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_tree_connect_andx_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_tree_connect_andx_request__size) <= t_end_of_data);
    return t_SMB1_tree_connect_andx_request__size;
}

SMB1_tree_connect_andx_response::SMB1_tree_connect_andx_response(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    optional_support_ = nullptr;
    optional_support__elem_ = 0;
    byte_count_ = 0;
    service_ = nullptr;
    native_file_system_ = nullptr;
    native_file_system__elem_ = nullptr;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    proc_ = false;
}

SMB1_tree_connect_andx_response::~SMB1_tree_connect_andx_response() {
    delete andx_;
    andx_ = nullptr;
    delete optional_support_;
    delete service_;
    service_ = nullptr;
    delete native_file_system__elem_;
    native_file_system__elem_ = nullptr;
    if ( native_file_system() ) {
        for ( auto* native_file_system__elem_ : *native_file_system() ) {
            delete native_file_system__elem_;
            native_file_system__elem_ = nullptr;
        }
    }
    delete native_file_system_;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_tree_connect_andx_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_tree_connect_andx_response:andx"
    if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:andx",
        	(1) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "optional_support"
    int t_optional_support__arraylength;
    t_optional_support__arraylength = word_count() < 3 ? 0 : 1;
    if ( t_optional_support__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:optional_support",
          t_optional_support__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB1_tree_connect_andx_response:optional_support
    if ( t_optional_support__arraylength > ((t_end_of_data - (t_begin_of_data + 5)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:optional_support",
          t_optional_support__arraylength, (t_end_of_data) - ((t_begin_of_data + 5)));
    optional_support__elem_ = 0;
    int t_optional_support__elem__it;
    t_optional_support__elem__it = 0;
    int t_optional_support__size;
    optional_support_ = new vector<uint16>;
    optional_support_->reserve(t_optional_support__arraylength);
    const_byteptr t_optional_support__elem__dataptr = (t_begin_of_data + 5);
    for (; t_optional_support__elem__it < t_optional_support__arraylength; ++t_optional_support__elem__it) {
        optional_support__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_optional_support__elem__dataptr)));
        optional_support_->push_back(optional_support__elem_);
        t_optional_support__elem__dataptr += 2;
        BINPAC_ASSERT(t_optional_support__elem__dataptr <= t_end_of_data);
    }
end_of_optional_support: ;
    t_optional_support__size = t_optional_support__elem__dataptr - ((t_begin_of_data + 5));
    // Evaluate 'let' and 'withinput' fields


    const_byteptr const t_dataptr_after_optional_support = (t_begin_of_data + 5) + (t_optional_support__size);
    BINPAC_ASSERT(t_dataptr_after_optional_support <= t_end_of_data);
    if ( (word_count() < 3 ? 0 :  ( word_count() - 3 )  * 2) < 0 ) { // check for negative pad length
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-tree-connect-andx.pac:58", word_count() < 3 ? 0 :  ( word_count() - 3 )  * 2);
    }

    const_byteptr const t_dataptr_after_pad = t_dataptr_after_optional_support + (word_count() < 3 ? 0 :  ( word_count() - 3 )  * 2);
    // Checking out-of-bound padding for "SMB1_tree_connect_andx_response:pad"
    if ( t_dataptr_after_pad > t_end_of_data || t_dataptr_after_pad < t_dataptr_after_optional_support ) {
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:pad",
        	(word_count() < 3 ? 0 :  ( word_count() - 3 )  * 2), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }

    // Checking out-of-bound for "SMB1_tree_connect_andx_response:byte_count"
    if ( t_dataptr_after_pad + (2) > t_end_of_data || t_dataptr_after_pad + (2) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:byte_count",
        	((t_dataptr_after_pad - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_pad)));

    // Parse "service"
    service_ = new SMB_string(false, ((t_dataptr_after_pad + 2) - t_begin_of_data));
    int t_service__size;
    t_service__size = service_->Parse((t_dataptr_after_pad + 2), t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_service = (t_dataptr_after_pad + 2) + (t_service__size);
    BINPAC_ASSERT(t_dataptr_after_service <= t_end_of_data);
    // Parse "native_file_system"
    int t_native_file_system__arraylength;
    t_native_file_system__arraylength = byte_count() > (t_dataptr_after_service - (t_dataptr_after_pad + 2)) ? 1 : 0;
    if ( t_native_file_system__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:native_file_system",
          t_native_file_system__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: SMB1_tree_connect_andx_response:native_file_system
    if ( t_native_file_system__arraylength > ((t_end_of_data - t_dataptr_after_service) / 1) )
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:native_file_system",
          t_native_file_system__arraylength, (t_end_of_data) - (t_dataptr_after_service));
    native_file_system__elem_ = nullptr;
    int t_native_file_system__elem__it;
    t_native_file_system__elem__it = 0;
    int t_native_file_system__size;
    native_file_system_ = new vector<SMB_string*>;
    native_file_system_->reserve(t_native_file_system__arraylength);
    const_byteptr t_native_file_system__elem__dataptr = t_dataptr_after_service;
    for (; t_native_file_system__elem__it < t_native_file_system__arraylength; ++t_native_file_system__elem__it) {
        native_file_system__elem_ = new SMB_string(header()->unicode(), (t_dataptr_after_service - t_begin_of_data));
        int t_native_file_system__elem__size;
        t_native_file_system__elem__size = native_file_system__elem_->Parse(t_native_file_system__elem__dataptr, t_end_of_data, t_context);
        native_file_system_->push_back(native_file_system__elem_);
        t_native_file_system__elem__dataptr += t_native_file_system__elem__size;
        BINPAC_ASSERT(t_native_file_system__elem__dataptr <= t_end_of_data);
        native_file_system__elem_ = nullptr;
    }
end_of_native_file_system: ;
    t_native_file_system__size = t_native_file_system__elem__dataptr - (t_dataptr_after_service);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_native_file_system = t_dataptr_after_service + (t_native_file_system__size);
    BINPAC_ASSERT(t_dataptr_after_native_file_system <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_file_system - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_file_system - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_tree_connect_andx_response:extra_byte_parameters"
    if ( t_dataptr_after_native_file_system + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_native_file_system + (t_extra_byte_parameters__size) < t_dataptr_after_native_file_system ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_tree_connect_andx_response:extra_byte_parameters",
        	((t_dataptr_after_native_file_system - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_native_file_system + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_native_file_system - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_native_file_system - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-tree-connect-andx.pac:64", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_native_file_system, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_native_file_system + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), false, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_tree_connect_andx_response__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_tree_connect_andx_response__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_tree_connect_andx_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_tree_connect_andx_response__size) <= t_end_of_data);
    return t_SMB1_tree_connect_andx_response__size;
}

SMB1_tree_disconnect::SMB1_tree_disconnect(SMB_Header* header, bool is_orig) {
    word_count_ = 0;
    byte_count_ = 0;
    header_ = header;
    is_orig_ = is_orig;
    proc_ = false;
}

SMB1_tree_disconnect::~SMB1_tree_disconnect() {
}

int SMB1_tree_disconnect::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_tree_disconnect"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_tree_disconnect",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb1_tree_disconnect(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

SMB1_write_andx_request::SMB1_write_andx_request(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    file_id_ = 0;
    offset_low_ = 0;
    timeout_ = 0;
    write_mode_ = 0;
    remaining_ = 0;
    data_len_high_ = 0;
    data_len_low_ = 0;
    data_offset_ = 0;
    offset_high_u_case_index_ = -1;
    offset_high_tmp_ = 0;
    byte_count_ = 0;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
    data_len_ = 0;
    offset_high_ = 0;
    write_offset_ = 0;
    proc_ = false;
}

SMB1_write_andx_request::~SMB1_write_andx_request() {
    delete andx_;
    andx_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( offset_high_u_case_index() ) {
        case ((uint8)14):
            // Clean up "offset_high_tmp"
            {
            }
            break;
        default:
            // Clean up "null"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    data_.free();
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_write_andx_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_write_andx_request:data_offset"
    if ( (t_begin_of_data + 23) + (2) > t_end_of_data || (t_begin_of_data + 23) + (2) < (t_begin_of_data + 23) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_request:data_offset",
        	(23) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "file_id"
    file_id_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "offset_low"
    offset_low_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 7))));

    // Parse "timeout"
    timeout_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 11))));

    // Parse "write_mode"
    write_mode_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 15))));

    // Parse "remaining"
    remaining_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 17))));

    // Parse "data_len_high"
    data_len_high_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 19))));

    // Parse "data_len_low"
    data_len_low_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 21))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 23))));

    // Parse "offset_high_u"
    int t_offset_high_u__size;
    offset_high_u_case_index_ = word_count();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( offset_high_u_case_index() ) {
        case ((uint8)14):
            // Parse "offset_high_tmp"
            {
                // Checking out-of-bound for "SMB1_write_andx_request:offset_high_tmp"
                if ( (t_begin_of_data + 25) + (4) > t_end_of_data || (t_begin_of_data + 25) + (4) < (t_begin_of_data + 25) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB1_write_andx_request:offset_high_tmp",
                    	(25) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                offset_high_tmp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 25))));
                t_offset_high_u__size = 4;
            }
            break;
        default:
            // Parse "null"
            {
                t_offset_high_u__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_offset_high_u = (t_begin_of_data + 25) + (t_offset_high_u__size);
    BINPAC_ASSERT(t_dataptr_after_offset_high_u <= t_end_of_data);
    // Checking out-of-bound for "SMB1_write_andx_request:byte_count"
    if ( t_dataptr_after_offset_high_u + (2) > t_end_of_data || t_dataptr_after_offset_high_u + (2) < t_dataptr_after_offset_high_u ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_request:byte_count",
        	((t_dataptr_after_offset_high_u - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_offset_high_u)));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (data_offset() - SMB_Header_length);
    if ( t_dataptr_after_pad < (t_dataptr_after_offset_high_u + 2) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-write-andx.pac:54:pad", (t_dataptr_after_offset_high_u + 2) - t_begin_of_data, data_offset() - SMB_Header_length);
        t_dataptr_after_pad = (t_dataptr_after_offset_high_u + 2);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_request:pad",
        	(data_offset() - SMB_Header_length), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "data"
    int t_data__size;
    data_len_ =  ( data_len_high() << 16 )  + data_len_low();
    t_data__size = data_len();
    // Checking out-of-bound for "SMB1_write_andx_request:data"
    if ( t_dataptr_after_pad + (t_data__size) > t_end_of_data || t_dataptr_after_pad + (t_data__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_request:data",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_data__size;
        int t_data_string_length;
        t_data_string_length = data_len();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-write-andx.pac:55", t_data_string_length);
        data_.init(t_dataptr_after_pad, t_data_string_length);
    }

    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  ) ;
    // Checking out-of-bound for "SMB1_write_andx_request:extra_byte_parameters"
    if ( t_dataptr_after_data + (t_extra_byte_parameters__size) > t_end_of_data || t_dataptr_after_data + (t_extra_byte_parameters__size) < t_dataptr_after_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_request:extra_byte_parameters",
        	((t_dataptr_after_data - t_begin_of_data)) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_data + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + (t_dataptr_after_data - t_begin_of_data) )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-write-andx.pac:57", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init(t_dataptr_after_data, t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = t_dataptr_after_data + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), true, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_write_andx_request__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_write_andx_request__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    has_pipe_proc_ =  ( header()->is_pipe() ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(data(), 0, true);
    }
    offset_high_ =  ( word_count() == 0x0E )  ? offset_high_tmp() : 0;
    write_offset_ =  ( offset_high() * 0x10000 )  + offset_low();
    proc_ = t_context->connection()->proc_smb1_write_andx_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_write_andx_request__size) <= t_end_of_data);
    return t_SMB1_write_andx_request__size;
}

SMB1_write_andx_response::SMB1_write_andx_response(SMB_Header* header, uint16 offset) {
    word_count_ = 0;
    andx_ = nullptr;
    written_low_ = 0;
    remaining_ = 0;
    written_high_ = 0;
    reserved_ = 0;
    byte_count_ = 0;
    andx_command_ = nullptr;
    header_ = header;
    offset_ = offset;
    written_bytes_ = 0;
    proc_ = false;
}

SMB1_write_andx_response::~SMB1_write_andx_response() {
    delete andx_;
    andx_ = nullptr;
    delete andx_command_;
    andx_command_ = nullptr;
}

int SMB1_write_andx_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB1_write_andx_response:byte_count"
    if ( (t_begin_of_data + 13) + (2) > t_end_of_data || (t_begin_of_data + 13) + (2) < (t_begin_of_data + 13) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_response:byte_count",
        	(13) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "andx"
    andx_ = new SMB_andx();
    andx_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "written_low"
    written_low_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));

    // Parse "remaining"
    remaining_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 7))));

    // Parse "written_high"
    written_high_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 9))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 11))));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 13))));

    // Parse "extra_byte_parameters"
    int t_extra_byte_parameters__size;
    t_extra_byte_parameters__size =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + 15 )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + 15 )  ) ;
    // Checking out-of-bound for "SMB1_write_andx_response:extra_byte_parameters"
    if ( (t_begin_of_data + 15) + (t_extra_byte_parameters__size) > t_end_of_data || (t_begin_of_data + 15) + (t_extra_byte_parameters__size) < (t_begin_of_data + 15) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB1_write_andx_response:extra_byte_parameters",
        	(15) + (t_extra_byte_parameters__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 15) + t_extra_byte_parameters__size;
        int t_extra_byte_parameters_string_length;
        t_extra_byte_parameters_string_length =  ( andx()->offset() == 0 || andx()->offset() >=  ( offset() + 15 )  + 2 )  ? 0 :  ( andx()->offset() -  ( offset() + 15 )  ) ;
        // check for negative sizes
        if ( t_extra_byte_parameters_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-com-write-andx.pac:79", t_extra_byte_parameters_string_length);
        extra_byte_parameters_.init((t_begin_of_data + 15), t_extra_byte_parameters_string_length);
    }

    const_byteptr const t_dataptr_after_extra_byte_parameters = (t_begin_of_data + 15) + (t_extra_byte_parameters__size);
    BINPAC_ASSERT(t_dataptr_after_extra_byte_parameters <= t_end_of_data);
    // Parse "andx_command"
    andx_command_ = new SMB_andx_command(header(), false, offset() + (t_dataptr_after_extra_byte_parameters - t_begin_of_data), andx()->command());
    int t_andx_command__size;
    t_andx_command__size = andx_command_->Parse(t_dataptr_after_extra_byte_parameters, t_end_of_data, t_context);

    int t_SMB1_write_andx_response__size;
    const_byteptr const t_dataptr_after_andx_command = t_dataptr_after_extra_byte_parameters + (t_andx_command__size);
    BINPAC_ASSERT(t_dataptr_after_andx_command <= t_end_of_data);
    t_SMB1_write_andx_response__size = t_dataptr_after_andx_command - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    written_bytes_ =  ( written_high() * 0x10000 )  + written_low();
    proc_ = t_context->connection()->proc_smb1_write_andx_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB1_write_andx_response__size) <= t_end_of_data);
    return t_SMB1_write_andx_response__size;
}

SMB2_close_request::SMB2_close_request(SMB2_Header* header) {
    structure_size_ = 0;
    flags_ = 0;
    reserved_ = 0;
    file_id_ = nullptr;
    header_ = header;
    fid_ = 0;
    proc_ = false;
    maybe_pipe_close_ = false;
}

SMB2_close_request::~SMB2_close_request() {
    delete file_id_;
    file_id_ = nullptr;
}

int SMB2_close_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_close_request"
    if ( t_begin_of_data + (24) > t_end_of_data || t_begin_of_data + (24) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_close_request",
        	(0) + (24), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Evaluate 'let' and 'withinput' fields
    fid_ = file_id()->persistent() + file_id()->_volatile();
    proc_ = t_context->connection()->proc_smb2_close_request(header(), this);
    maybe_pipe_close_ = t_context->connection()->forward_dce_rpc_close(fid());
    BINPAC_ASSERT(t_begin_of_data + (24) <= t_end_of_data);
    return 24;
}

SMB2_close_response::SMB2_close_response(SMB2_Header* header) {
    structure_size_ = 0;
    flags_ = 0;
    reserved_ = 0;
    creation_time_ = 0;
    last_access_time_ = 0;
    last_write_time_ = 0;
    change_time_ = 0;
    alloc_size_ = 0;
    eof_ = 0;
    file_attrs_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB2_close_response::~SMB2_close_response() {
    delete file_attrs_;
    file_attrs_ = nullptr;
}

int SMB2_close_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_close_response"
    if ( t_begin_of_data + (60) > t_end_of_data || t_begin_of_data + (60) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_close_response",
        	(0) + (60), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "creation_time"
    creation_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "last_access_time"
    last_access_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 16))));

    // Parse "last_write_time"
    last_write_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 24))));

    // Parse "change_time"
    change_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 32))));

    // Parse "alloc_size"
    alloc_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 40))));

    // Parse "eof"
    eof_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 48))));

    // Parse "file_attrs"
    file_attrs_ = new SMB2_file_attributes();
    file_attrs_->Parse((t_begin_of_data + 56), t_end_of_data, t_byteorder);

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_close_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (60) <= t_end_of_data);
    return 60;
}

SMB2_create_context::SMB2_create_context() {
    next_offset_ = 0;
    name_offset_ = 0;
    name_len_ = 0;
    reserved_ = 0;
    data_offset_ = 0;
    data_len_ = 0;
    name_ = nullptr;
    data_ = nullptr;
}

SMB2_create_context::~SMB2_create_context() {
    delete name_;
    name_ = nullptr;
    delete data_;
    data_ = nullptr;
}

int SMB2_create_context::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB2_create_context:data_len"
    if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_context:data_len",
        	(12) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "next_offset"
    next_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "name_offset"
    name_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "name_len"
    name_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "data_len"
    data_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));


    const_byteptr t_dataptr_after_name_pad = t_begin_of_data + (name_offset());
    if ( t_dataptr_after_name_pad < (t_begin_of_data + 16) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:66:name_pad", (t_begin_of_data + 16) - t_begin_of_data, name_offset());
        t_dataptr_after_name_pad = (t_begin_of_data + 16);
    }
    if ( t_dataptr_after_name_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_create_context:name_pad",
        	(name_offset()), 
        	(t_end_of_data) - (t_dataptr_after_name_pad));
    }
    // Parse "name"
    name_ = new SMB2_string(name_len() == 0 ? 2 : name_len());
    int t_name__size;
    t_name__size = name_->Parse(t_dataptr_after_name_pad, t_end_of_data);


    const_byteptr const t_dataptr_after_name = t_dataptr_after_name_pad + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    const_byteptr t_dataptr_after_data_pad = t_begin_of_data + (data_offset());
    if ( t_dataptr_after_data_pad < t_dataptr_after_name ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:71:data_pad", t_dataptr_after_name - t_begin_of_data, data_offset());
        t_dataptr_after_data_pad = t_dataptr_after_name;
    }
    if ( t_dataptr_after_data_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_create_context:data_pad",
        	(data_offset()), 
        	(t_end_of_data) - (t_dataptr_after_data_pad));
    }
    // Parse "data"
    data_ = new SMB2_string(data_len() == 0 ? 2 : data_len());
    int t_data__size;
    t_data__size = data_->Parse(t_dataptr_after_data_pad, t_end_of_data);


    int t_SMB2_create_context__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_data_pad + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    const_byteptr t_dataptr_after_next_context_pad = t_begin_of_data + (next_offset());
    if ( t_dataptr_after_next_context_pad < t_dataptr_after_data ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:73:next_context_pad", t_dataptr_after_data - t_begin_of_data, next_offset());
        t_dataptr_after_next_context_pad = t_dataptr_after_data;
    }
    if ( t_dataptr_after_next_context_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_create_context:next_context_pad",
        	(next_offset()), 
        	(t_end_of_data) - (t_dataptr_after_next_context_pad));
    }
    t_SMB2_create_context__size = t_dataptr_after_next_context_pad - t_begin_of_data;
    // Checking out-of-bound for "SMB2_create_context"
    if ( t_begin_of_data + (t_SMB2_create_context__size) > t_end_of_data || t_begin_of_data + (t_SMB2_create_context__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_context",
        	(0) + (t_SMB2_create_context__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_create_context__size) <= t_end_of_data);
    return t_SMB2_create_context__size;
}

SMB2_create_request::SMB2_create_request(SMB2_Header* header) {
    structure_size_ = 0;
    sec_flags_reserved_ = 0;
    oplock_ = 0;
    impersonation_level_ = 0;
    access_mask_ = 0;
    file_attrs_ = nullptr;
    share_access_ = 0;
    disposition_ = 0;
    create_options_ = 0;
    filename_offset_ = 0;
    filename_len_ = 0;
    context_offset_ = 0;
    context_len_ = 0;
    filename_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB2_create_request::~SMB2_create_request() {
    flags_.free();
    reserved_.free();
    delete file_attrs_;
    file_attrs_ = nullptr;
    delete filename_;
    filename_ = nullptr;
}

int SMB2_create_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_create_request:impersonation_level"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_request:impersonation_level",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "sec_flags_reserved"
    sec_flags_reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "oplock"
    oplock_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "impersonation_level"
    impersonation_level_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "flags"
    // Checking out-of-bound for "SMB2_create_request:flags"
    if ( (t_begin_of_data + 8) + (8) > t_end_of_data || (t_begin_of_data + 8) + (8) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_request:flags",
        	(8) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + 8;
        int t_flags_string_length;
        t_flags_string_length = 8;
        int t_flags__size;
        t_flags__size = t_flags_string_length;
        flags_.init((t_begin_of_data + 8), t_flags_string_length);
    }

    const_byteptr const t_dataptr_after_flags = (t_begin_of_data + 8) + (8);
    BINPAC_ASSERT(t_dataptr_after_flags <= t_end_of_data);
    // Parse "reserved"
    // Checking out-of-bound for "SMB2_create_request:reserved"
    if ( t_dataptr_after_flags + (8) > t_end_of_data || t_dataptr_after_flags + (8) < t_dataptr_after_flags ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_request:reserved",
        	((t_dataptr_after_flags - t_begin_of_data)) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_flags + 8;
        int t_reserved_string_length;
        t_reserved_string_length = 8;
        int t_reserved__size;
        t_reserved__size = t_reserved_string_length;
        reserved_.init(t_dataptr_after_flags, t_reserved_string_length);
    }

    const_byteptr const t_dataptr_after_reserved = t_dataptr_after_flags + (8);
    BINPAC_ASSERT(t_dataptr_after_reserved <= t_end_of_data);
    // Checking out-of-bound for "SMB2_create_request:context_len"
    if ( (t_dataptr_after_reserved + 28) + (4) > t_end_of_data || (t_dataptr_after_reserved + 28) + (4) < (t_dataptr_after_reserved + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_request:context_len",
        	(((t_dataptr_after_reserved + 28) - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "access_mask"
    access_mask_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_reserved)));

    // Parse "file_attrs"
    file_attrs_ = new SMB2_file_attributes();
    file_attrs_->Parse((t_dataptr_after_reserved + 4), t_end_of_data, t_byteorder);

    // Parse "share_access"
    share_access_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_reserved + 8))));

    // Parse "disposition"
    disposition_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_reserved + 12))));

    // Parse "create_options"
    create_options_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_reserved + 16))));

    // Parse "filename_offset"
    filename_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_reserved + 20))));

    // Parse "filename_len"
    filename_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_reserved + 22))));

    // Parse "context_offset"
    context_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_reserved + 24))));

    // Parse "context_len"
    context_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_reserved + 28))));


    const_byteptr t_dataptr_after_filename_pad = t_begin_of_data + (filename_offset() - header()->head_length());
    if ( t_dataptr_after_filename_pad < (t_dataptr_after_reserved + 32) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:92:filename_pad", (t_dataptr_after_reserved + 32) - t_begin_of_data, filename_offset() - header()->head_length());
        t_dataptr_after_filename_pad = (t_dataptr_after_reserved + 32);
    }
    if ( t_dataptr_after_filename_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_create_request:filename_pad",
        	(filename_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_filename_pad));
    }
    // Parse "filename"
    filename_ = new SMB2_string(filename_len());
    int t_filename__size;
    t_filename__size = filename_->Parse(t_dataptr_after_filename_pad, t_end_of_data);


    const_byteptr const t_dataptr_after_filename = t_dataptr_after_filename_pad + (t_filename__size);
    BINPAC_ASSERT(t_dataptr_after_filename <= t_end_of_data);
    const_byteptr t_dataptr_after_context_pad = t_begin_of_data + ( ( context_offset() == 0 ? 0 : context_offset() - header()->head_length() ) );
    if ( t_dataptr_after_context_pad < t_dataptr_after_filename ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:97:context_pad", t_dataptr_after_filename - t_begin_of_data,  ( context_offset() == 0 ? 0 : context_offset() - header()->head_length() ) );
        t_dataptr_after_context_pad = t_dataptr_after_filename;
    }
    if ( t_dataptr_after_context_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_create_request:context_pad",
        	( ( context_offset() == 0 ? 0 : context_offset() - header()->head_length() ) ), 
        	(t_end_of_data) - (t_dataptr_after_context_pad));
    }
    // Parse "contexts"
    int t_contexts__size;
    t_contexts__size = context_len();
    // Checking out-of-bound for "SMB2_create_request:contexts"
    if ( t_dataptr_after_context_pad + (t_contexts__size) > t_end_of_data || t_dataptr_after_context_pad + (t_contexts__size) < t_dataptr_after_context_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_request:contexts",
        	((t_dataptr_after_context_pad - t_begin_of_data)) + (t_contexts__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_context_pad + t_contexts__size;
        int t_contexts_string_length;
        t_contexts_string_length = context_len();
        // check for negative sizes
        if ( t_contexts_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:103", t_contexts_string_length);
        contexts_.init(t_dataptr_after_context_pad, t_contexts_string_length);
    }

    int t_SMB2_create_request__size;
    const_byteptr const t_dataptr_after_contexts = t_dataptr_after_context_pad + (t_contexts__size);
    BINPAC_ASSERT(t_dataptr_after_contexts <= t_end_of_data);
    t_SMB2_create_request__size = t_dataptr_after_contexts - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_create_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_create_request__size) <= t_end_of_data);
    return t_SMB2_create_request__size;
}

SMB2_create_response::SMB2_create_response(SMB2_Header* header) {
    structure_size_ = 0;
    oplock_ = 0;
    reserved_ = 0;
    create_action_ = 0;
    creation_time_ = 0;
    last_access_time_ = 0;
    last_write_time_ = 0;
    change_time_ = 0;
    alloc_size_ = 0;
    eof_ = 0;
    file_attrs_ = nullptr;
    reserved2_ = 0;
    file_id_ = nullptr;
    context_offset_ = 0;
    context_len_ = 0;
    header_ = header;
    proc_ = false;
}

SMB2_create_response::~SMB2_create_response() {
    delete file_attrs_;
    file_attrs_ = nullptr;
    delete file_id_;
    file_id_ = nullptr;
}

int SMB2_create_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_create_response:context_len"
    if ( (t_begin_of_data + 84) + (4) > t_end_of_data || (t_begin_of_data + 84) + (4) < (t_begin_of_data + 84) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_response:context_len",
        	(84) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "oplock"
    oplock_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "create_action"
    create_action_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "creation_time"
    creation_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "last_access_time"
    last_access_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 16))));

    // Parse "last_write_time"
    last_write_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 24))));

    // Parse "change_time"
    change_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 32))));

    // Parse "alloc_size"
    alloc_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 40))));

    // Parse "eof"
    eof_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 48))));

    // Parse "file_attrs"
    file_attrs_ = new SMB2_file_attributes();
    file_attrs_->Parse((t_begin_of_data + 56), t_end_of_data, t_byteorder);

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 60))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 64), t_end_of_data, t_byteorder);

    // Parse "context_offset"
    context_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 80))));

    // Parse "context_len"
    context_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 84))));


    const_byteptr t_dataptr_after_context_pad = t_begin_of_data + ( ( context_offset() == 0 ? 0 : context_offset() - header()->head_length() ) );
    if ( t_dataptr_after_context_pad < (t_begin_of_data + 88) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:128:context_pad", (t_begin_of_data + 88) - t_begin_of_data,  ( context_offset() == 0 ? 0 : context_offset() - header()->head_length() ) );
        t_dataptr_after_context_pad = (t_begin_of_data + 88);
    }
    if ( t_dataptr_after_context_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_create_response:context_pad",
        	( ( context_offset() == 0 ? 0 : context_offset() - header()->head_length() ) ), 
        	(t_end_of_data) - (t_dataptr_after_context_pad));
    }
    // Parse "contexts"
    int t_contexts__size;
    t_contexts__size = context_len();
    // Checking out-of-bound for "SMB2_create_response:contexts"
    if ( t_dataptr_after_context_pad + (t_contexts__size) > t_end_of_data || t_dataptr_after_context_pad + (t_contexts__size) < t_dataptr_after_context_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_create_response:contexts",
        	((t_dataptr_after_context_pad - t_begin_of_data)) + (t_contexts__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_context_pad + t_contexts__size;
        int t_contexts_string_length;
        t_contexts_string_length = context_len();
        // check for negative sizes
        if ( t_contexts_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-create.pac:134", t_contexts_string_length);
        contexts_.init(t_dataptr_after_context_pad, t_contexts_string_length);
    }

    int t_SMB2_create_response__size;
    const_byteptr const t_dataptr_after_contexts = t_dataptr_after_context_pad + (t_contexts__size);
    BINPAC_ASSERT(t_dataptr_after_contexts <= t_end_of_data);
    t_SMB2_create_response__size = t_dataptr_after_contexts - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_create_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_create_response__size) <= t_end_of_data);
    return t_SMB2_create_response__size;
}

SMB2_ioctl_request::SMB2_ioctl_request(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    ctl_code_ = 0;
    file_id_ = nullptr;
    input_offset_ = 0;
    input_count_ = 0;
    max_input_resp_ = 0;
    output_offset_ = 0;
    output_count_ = 0;
    max_output_resp_ = 0;
    flags_ = 0;
    reserved2_ = 0;
    header_ = header;
    is_pipe_ = false;
    fid_ = 0;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
    proc_ = false;
}

SMB2_ioctl_request::~SMB2_ioctl_request() {
    delete file_id_;
    file_id_ = nullptr;
    input_buffer_.free();
    output_buffer_.free();
}

int SMB2_ioctl_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_ioctl_request:reserved2"
    if ( (t_begin_of_data + 52) + (4) > t_end_of_data || (t_begin_of_data + 52) + (4) < (t_begin_of_data + 52) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_request:reserved2",
        	(52) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "ctl_code"
    ctl_code_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "input_offset"
    input_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));

    // Parse "input_count"
    input_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));

    // Parse "max_input_resp"
    max_input_resp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "output_offset"
    output_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 36))));

    // Parse "output_count"
    output_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 40))));

    // Parse "max_output_resp"
    max_output_resp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 44))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 48))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 52))));

    // Parse "pad1"
    int t_pad1__size;
    t_pad1__size =  (  ( input_offset() == 0 )  ? 0 :  ( 56 + header()->head_length() - input_offset() )  ) ;
    // Checking out-of-bound for "SMB2_ioctl_request:pad1"
    if ( (t_begin_of_data + 56) + (t_pad1__size) > t_end_of_data || (t_begin_of_data + 56) + (t_pad1__size) < (t_begin_of_data + 56) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_request:pad1",
        	(56) + (t_pad1__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 56) + t_pad1__size;
        int t_pad1_string_length;
        t_pad1_string_length =  (  ( input_offset() == 0 )  ? 0 :  ( 56 + header()->head_length() - input_offset() )  ) ;
        // check for negative sizes
        if ( t_pad1_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:50", t_pad1_string_length);
        pad1_.init((t_begin_of_data + 56), t_pad1_string_length);
    }

    const_byteptr const t_dataptr_after_pad1 = (t_begin_of_data + 56) + (t_pad1__size);
    BINPAC_ASSERT(t_dataptr_after_pad1 <= t_end_of_data);
    // Parse "input_buffer"
    int t_input_buffer__size;
    t_input_buffer__size = input_count();
    // Checking out-of-bound for "SMB2_ioctl_request:input_buffer"
    if ( t_dataptr_after_pad1 + (t_input_buffer__size) > t_end_of_data || t_dataptr_after_pad1 + (t_input_buffer__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_request:input_buffer",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_input_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_input_buffer__size;
        int t_input_buffer_string_length;
        t_input_buffer_string_length = input_count();
        // check for negative sizes
        if ( t_input_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:51", t_input_buffer_string_length);
        input_buffer_.init(t_dataptr_after_pad1, t_input_buffer_string_length);
    }

    const_byteptr const t_dataptr_after_input_buffer = t_dataptr_after_pad1 + (t_input_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_input_buffer <= t_end_of_data);
    // Parse "pad2"
    int t_pad2__size;
    t_pad2__size =  (  ( output_offset() == 0 || output_offset() == input_offset() )  ? 0 :  ( (t_dataptr_after_input_buffer - t_begin_of_data) + header()->head_length() - output_offset() )  ) ;
    // Checking out-of-bound for "SMB2_ioctl_request:pad2"
    if ( t_dataptr_after_input_buffer + (t_pad2__size) > t_end_of_data || t_dataptr_after_input_buffer + (t_pad2__size) < t_dataptr_after_input_buffer ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_request:pad2",
        	((t_dataptr_after_input_buffer - t_begin_of_data)) + (t_pad2__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_input_buffer + t_pad2__size;
        int t_pad2_string_length;
        t_pad2_string_length =  (  ( output_offset() == 0 || output_offset() == input_offset() )  ? 0 :  ( (t_dataptr_after_input_buffer - t_begin_of_data) + header()->head_length() - output_offset() )  ) ;
        // check for negative sizes
        if ( t_pad2_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:52", t_pad2_string_length);
        pad2_.init(t_dataptr_after_input_buffer, t_pad2_string_length);
    }

    const_byteptr const t_dataptr_after_pad2 = t_dataptr_after_input_buffer + (t_pad2__size);
    BINPAC_ASSERT(t_dataptr_after_pad2 <= t_end_of_data);
    // Parse "output_buffer"
    int t_output_buffer__size;
    t_output_buffer__size = output_count();
    // Checking out-of-bound for "SMB2_ioctl_request:output_buffer"
    if ( t_dataptr_after_pad2 + (t_output_buffer__size) > t_end_of_data || t_dataptr_after_pad2 + (t_output_buffer__size) < t_dataptr_after_pad2 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_request:output_buffer",
        	((t_dataptr_after_pad2 - t_begin_of_data)) + (t_output_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad2 + t_output_buffer__size;
        int t_output_buffer_string_length;
        t_output_buffer_string_length = output_count();
        // check for negative sizes
        if ( t_output_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:53", t_output_buffer_string_length);
        output_buffer_.init(t_dataptr_after_pad2, t_output_buffer_string_length);
    }

    int t_SMB2_ioctl_request__size;
    const_byteptr const t_dataptr_after_output_buffer = t_dataptr_after_pad2 + (t_output_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_output_buffer <= t_end_of_data);
    t_SMB2_ioctl_request__size = t_dataptr_after_output_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    is_pipe_ =  ( ctl_code() == 0x0011C017 ) ;
    fid_ = file_id()->persistent() + file_id()->_volatile();
    has_pipe_proc_ =  ( is_pipe() ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(input_buffer(), fid(), true);
    }
    proc_ = t_context->connection()->proc_smb2_ioctl_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_ioctl_request__size) <= t_end_of_data);
    return t_SMB2_ioctl_request__size;
}

SMB2_ioctl_response::SMB2_ioctl_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    ctl_code_ = 0;
    file_id_ = nullptr;
    input_offset_ = 0;
    input_count_ = 0;
    output_offset_ = 0;
    output_count_ = 0;
    flags_ = 0;
    reserved2_ = 0;
    header_ = header;
    is_pipe_ = false;
    fid_ = 0;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
}

SMB2_ioctl_response::~SMB2_ioctl_response() {
    delete file_id_;
    file_id_ = nullptr;
    input_buffer_.free();
    output_buffer_.free();
}

int SMB2_ioctl_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_ioctl_response:reserved2"
    if ( (t_begin_of_data + 44) + (4) > t_end_of_data || (t_begin_of_data + 44) + (4) < (t_begin_of_data + 44) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_response:reserved2",
        	(44) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "ctl_code"
    ctl_code_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "input_offset"
    input_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));

    // Parse "input_count"
    input_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));

    // Parse "output_offset"
    output_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "output_count"
    output_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 36))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 40))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 44))));

    // Parse "pad1"
    int t_pad1__size;
    t_pad1__size =  (  ( input_offset() == 0 )  ? 0 :  ( 48 + header()->head_length() - input_offset() )  ) ;
    // Checking out-of-bound for "SMB2_ioctl_response:pad1"
    if ( (t_begin_of_data + 48) + (t_pad1__size) > t_end_of_data || (t_begin_of_data + 48) + (t_pad1__size) < (t_begin_of_data + 48) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_response:pad1",
        	(48) + (t_pad1__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 48) + t_pad1__size;
        int t_pad1_string_length;
        t_pad1_string_length =  (  ( input_offset() == 0 )  ? 0 :  ( 48 + header()->head_length() - input_offset() )  ) ;
        // check for negative sizes
        if ( t_pad1_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:73", t_pad1_string_length);
        pad1_.init((t_begin_of_data + 48), t_pad1_string_length);
    }

    const_byteptr const t_dataptr_after_pad1 = (t_begin_of_data + 48) + (t_pad1__size);
    BINPAC_ASSERT(t_dataptr_after_pad1 <= t_end_of_data);
    // Parse "input_buffer"
    int t_input_buffer__size;
    t_input_buffer__size = input_count();
    // Checking out-of-bound for "SMB2_ioctl_response:input_buffer"
    if ( t_dataptr_after_pad1 + (t_input_buffer__size) > t_end_of_data || t_dataptr_after_pad1 + (t_input_buffer__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_response:input_buffer",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_input_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_input_buffer__size;
        int t_input_buffer_string_length;
        t_input_buffer_string_length = input_count();
        // check for negative sizes
        if ( t_input_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:74", t_input_buffer_string_length);
        input_buffer_.init(t_dataptr_after_pad1, t_input_buffer_string_length);
    }

    const_byteptr const t_dataptr_after_input_buffer = t_dataptr_after_pad1 + (t_input_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_input_buffer <= t_end_of_data);
    // Parse "pad2"
    int t_pad2__size;
    t_pad2__size =  (  ( output_offset() == 0 || output_offset() == input_offset() )  ? 0 :  ( (t_dataptr_after_input_buffer - t_begin_of_data) + header()->head_length() - output_offset() )  ) ;
    // Checking out-of-bound for "SMB2_ioctl_response:pad2"
    if ( t_dataptr_after_input_buffer + (t_pad2__size) > t_end_of_data || t_dataptr_after_input_buffer + (t_pad2__size) < t_dataptr_after_input_buffer ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_response:pad2",
        	((t_dataptr_after_input_buffer - t_begin_of_data)) + (t_pad2__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_input_buffer + t_pad2__size;
        int t_pad2_string_length;
        t_pad2_string_length =  (  ( output_offset() == 0 || output_offset() == input_offset() )  ? 0 :  ( (t_dataptr_after_input_buffer - t_begin_of_data) + header()->head_length() - output_offset() )  ) ;
        // check for negative sizes
        if ( t_pad2_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:75", t_pad2_string_length);
        pad2_.init(t_dataptr_after_input_buffer, t_pad2_string_length);
    }

    const_byteptr const t_dataptr_after_pad2 = t_dataptr_after_input_buffer + (t_pad2__size);
    BINPAC_ASSERT(t_dataptr_after_pad2 <= t_end_of_data);
    // Parse "output_buffer"
    int t_output_buffer__size;
    t_output_buffer__size = output_count();
    // Checking out-of-bound for "SMB2_ioctl_response:output_buffer"
    if ( t_dataptr_after_pad2 + (t_output_buffer__size) > t_end_of_data || t_dataptr_after_pad2 + (t_output_buffer__size) < t_dataptr_after_pad2 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_ioctl_response:output_buffer",
        	((t_dataptr_after_pad2 - t_begin_of_data)) + (t_output_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad2 + t_output_buffer__size;
        int t_output_buffer_string_length;
        t_output_buffer_string_length = output_count();
        // check for negative sizes
        if ( t_output_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-ioctl.pac:76", t_output_buffer_string_length);
        output_buffer_.init(t_dataptr_after_pad2, t_output_buffer_string_length);
    }

    int t_SMB2_ioctl_response__size;
    const_byteptr const t_dataptr_after_output_buffer = t_dataptr_after_pad2 + (t_output_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_output_buffer <= t_end_of_data);
    t_SMB2_ioctl_response__size = t_dataptr_after_output_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    is_pipe_ =  ( ctl_code() == 0x0011C017 ) ;
    fid_ = t_context->connection()->get_ioctl_fid(header()->message_id());
    has_pipe_proc_ =  ( is_pipe() ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(output_buffer(), fid(), false);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_ioctl_response__size) <= t_end_of_data);
    return t_SMB2_ioctl_response__size;
}

SMB2_lock::SMB2_lock() {
    offset_ = 0;
    len_ = 0;
    flags_ = 0;
}

SMB2_lock::~SMB2_lock() {
}

int SMB2_lock::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB2_lock"
    if ( t_begin_of_data + (20) > t_end_of_data || t_begin_of_data + (20) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_lock",
        	(0) + (20), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "offset"
    offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_begin_of_data)));

    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (20) <= t_end_of_data);
    return 20;
}

SMB2_lock_request::SMB2_lock_request(SMB2_Header* header) {
    structure_size_ = 0;
    lock_count_ = 0;
    lock_seq_ = 0;
    file_id_ = nullptr;
    locks_ = nullptr;
    locks__elem_ = nullptr;
    header_ = header;
}

SMB2_lock_request::~SMB2_lock_request() {
    delete file_id_;
    file_id_ = nullptr;
    delete locks__elem_;
    locks__elem_ = nullptr;
    if ( locks() ) {
        for ( auto* locks__elem_ : *locks() ) {
            delete locks__elem_;
            locks__elem_ = nullptr;
        }
    }
    delete locks_;
}

int SMB2_lock_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_lock_request:file_id"
    if ( (t_begin_of_data + 8) + (16) > t_end_of_data || (t_begin_of_data + 8) + (16) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_lock_request:file_id",
        	(8) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "lock_count"
    lock_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "lock_seq"
    lock_seq_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "locks"
    int t_locks__arraylength;
    t_locks__arraylength = lock_count();
    if ( t_locks__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB2_lock_request:locks",
          t_locks__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB2_lock_request:locks
    if ( t_locks__arraylength > ((t_end_of_data - (t_begin_of_data + 24)) / 20) )
        throw binpac::ExceptionOutOfBound("SMB2_lock_request:locks",
          t_locks__arraylength, (t_end_of_data) - ((t_begin_of_data + 24)));
    locks__elem_ = nullptr;
    int t_locks__elem__it;
    t_locks__elem__it = 0;
    int t_locks__size;
    locks_ = new vector<SMB2_lock*>;
    locks_->reserve(t_locks__arraylength);
    const_byteptr t_locks__elem__dataptr = (t_begin_of_data + 24);
    for (; t_locks__elem__it < t_locks__arraylength; ++t_locks__elem__it) {
        locks__elem_ = new SMB2_lock();
        locks__elem_->Parse(t_locks__elem__dataptr, t_end_of_data, t_byteorder);
        locks_->push_back(locks__elem_);
        t_locks__elem__dataptr += 20;
        BINPAC_ASSERT(t_locks__elem__dataptr <= t_end_of_data);
        locks__elem_ = nullptr;
    }
end_of_locks: ;
    t_locks__size = t_locks__elem__dataptr - ((t_begin_of_data + 24));
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_lock_request__size;
    const_byteptr const t_dataptr_after_locks = (t_begin_of_data + 24) + (t_locks__size);
    BINPAC_ASSERT(t_dataptr_after_locks <= t_end_of_data);
    t_SMB2_lock_request__size = t_dataptr_after_locks - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_lock_request__size) <= t_end_of_data);
    return t_SMB2_lock_request__size;
}

SMB2_lock_response::SMB2_lock_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_lock_response::~SMB2_lock_response() {
}

int SMB2_lock_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_lock_response"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_lock_response",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB3_preauth_integrity_capabilities::SMB3_preauth_integrity_capabilities() {
    hash_alg_count_ = 0;
    salt_length_ = 0;
    hash_alg_ = nullptr;
    hash_alg__elem_ = 0;
}

SMB3_preauth_integrity_capabilities::~SMB3_preauth_integrity_capabilities() {
    delete hash_alg_;
    salt_.free();
}

int SMB3_preauth_integrity_capabilities::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB3_preauth_integrity_capabilities:salt_length"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB3_preauth_integrity_capabilities:salt_length",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "hash_alg_count"
    hash_alg_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "salt_length"
    salt_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "hash_alg"
    int t_hash_alg__arraylength;
    t_hash_alg__arraylength = hash_alg_count();
    if ( t_hash_alg__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB3_preauth_integrity_capabilities:hash_alg",
          t_hash_alg__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB3_preauth_integrity_capabilities:hash_alg
    if ( t_hash_alg__arraylength > ((t_end_of_data - (t_begin_of_data + 4)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB3_preauth_integrity_capabilities:hash_alg",
          t_hash_alg__arraylength, (t_end_of_data) - ((t_begin_of_data + 4)));
    hash_alg__elem_ = 0;
    int t_hash_alg__elem__it;
    t_hash_alg__elem__it = 0;
    int t_hash_alg__size;
    hash_alg_ = new vector<uint16>;
    hash_alg_->reserve(t_hash_alg__arraylength);
    const_byteptr t_hash_alg__elem__dataptr = (t_begin_of_data + 4);
    for (; t_hash_alg__elem__it < t_hash_alg__arraylength; ++t_hash_alg__elem__it) {
        hash_alg__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_hash_alg__elem__dataptr)));
        hash_alg_->push_back(hash_alg__elem_);
        t_hash_alg__elem__dataptr += 2;
        BINPAC_ASSERT(t_hash_alg__elem__dataptr <= t_end_of_data);
    }
end_of_hash_alg: ;
    t_hash_alg__size = t_hash_alg__elem__dataptr - ((t_begin_of_data + 4));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_hash_alg = (t_begin_of_data + 4) + (t_hash_alg__size);
    BINPAC_ASSERT(t_dataptr_after_hash_alg <= t_end_of_data);
    // Parse "salt"
    int t_salt__size;
    t_salt__size = salt_length();
    // Checking out-of-bound for "SMB3_preauth_integrity_capabilities:salt"
    if ( t_dataptr_after_hash_alg + (t_salt__size) > t_end_of_data || t_dataptr_after_hash_alg + (t_salt__size) < t_dataptr_after_hash_alg ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB3_preauth_integrity_capabilities:salt",
        	((t_dataptr_after_hash_alg - t_begin_of_data)) + (t_salt__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_hash_alg + t_salt__size;
        int t_salt_string_length;
        t_salt_string_length = salt_length();
        // check for negative sizes
        if ( t_salt_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:76", t_salt_string_length);
        salt_.init(t_dataptr_after_hash_alg, t_salt_string_length);
    }

    int t_SMB3_preauth_integrity_capabilities__size;
    const_byteptr const t_dataptr_after_salt = t_dataptr_after_hash_alg + (t_salt__size);
    BINPAC_ASSERT(t_dataptr_after_salt <= t_end_of_data);
    t_SMB3_preauth_integrity_capabilities__size = t_dataptr_after_salt - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB3_preauth_integrity_capabilities__size) <= t_end_of_data);
    return t_SMB3_preauth_integrity_capabilities__size;
}

SMB3_encryption_capabilities::SMB3_encryption_capabilities() {
    cipher_count_ = 0;
    ciphers_ = nullptr;
    ciphers__elem_ = 0;
}

SMB3_encryption_capabilities::~SMB3_encryption_capabilities() {
    delete ciphers_;
}

int SMB3_encryption_capabilities::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB3_encryption_capabilities:cipher_count"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB3_encryption_capabilities:cipher_count",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cipher_count"
    cipher_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "ciphers"
    int t_ciphers__arraylength;
    t_ciphers__arraylength = cipher_count();
    if ( t_ciphers__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB3_encryption_capabilities:ciphers",
          t_ciphers__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB3_encryption_capabilities:ciphers
    if ( t_ciphers__arraylength > ((t_end_of_data - (t_begin_of_data + 2)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB3_encryption_capabilities:ciphers",
          t_ciphers__arraylength, (t_end_of_data) - ((t_begin_of_data + 2)));
    ciphers__elem_ = 0;
    int t_ciphers__elem__it;
    t_ciphers__elem__it = 0;
    int t_ciphers__size;
    ciphers_ = new vector<uint16>;
    ciphers_->reserve(t_ciphers__arraylength);
    const_byteptr t_ciphers__elem__dataptr = (t_begin_of_data + 2);
    for (; t_ciphers__elem__it < t_ciphers__arraylength; ++t_ciphers__elem__it) {
        ciphers__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_ciphers__elem__dataptr)));
        ciphers_->push_back(ciphers__elem_);
        t_ciphers__elem__dataptr += 2;
        BINPAC_ASSERT(t_ciphers__elem__dataptr <= t_end_of_data);
    }
end_of_ciphers: ;
    t_ciphers__size = t_ciphers__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    int t_SMB3_encryption_capabilities__size;
    const_byteptr const t_dataptr_after_ciphers = (t_begin_of_data + 2) + (t_ciphers__size);
    BINPAC_ASSERT(t_dataptr_after_ciphers <= t_end_of_data);
    t_SMB3_encryption_capabilities__size = t_dataptr_after_ciphers - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB3_encryption_capabilities__size) <= t_end_of_data);
    return t_SMB3_encryption_capabilities__size;
}

SMB3_compression_capabilities::SMB3_compression_capabilities() {
    alg_count_ = 0;
    pad_ = 0;
    reserved_ = 0;
    algs_ = nullptr;
    algs__elem_ = 0;
}

SMB3_compression_capabilities::~SMB3_compression_capabilities() {
    delete algs_;
}

int SMB3_compression_capabilities::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB3_compression_capabilities:reserved"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB3_compression_capabilities:reserved",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "alg_count"
    alg_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "pad"
    pad_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "algs"
    int t_algs__arraylength;
    t_algs__arraylength = alg_count();
    if ( t_algs__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB3_compression_capabilities:algs",
          t_algs__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB3_compression_capabilities:algs
    if ( t_algs__arraylength > ((t_end_of_data - (t_begin_of_data + 8)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB3_compression_capabilities:algs",
          t_algs__arraylength, (t_end_of_data) - ((t_begin_of_data + 8)));
    algs__elem_ = 0;
    int t_algs__elem__it;
    t_algs__elem__it = 0;
    int t_algs__size;
    algs_ = new vector<uint16>;
    algs_->reserve(t_algs__arraylength);
    const_byteptr t_algs__elem__dataptr = (t_begin_of_data + 8);
    for (; t_algs__elem__it < t_algs__arraylength; ++t_algs__elem__it) {
        algs__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_algs__elem__dataptr)));
        algs_->push_back(algs__elem_);
        t_algs__elem__dataptr += 2;
        BINPAC_ASSERT(t_algs__elem__dataptr <= t_end_of_data);
    }
end_of_algs: ;
    t_algs__size = t_algs__elem__dataptr - ((t_begin_of_data + 8));
    // Evaluate 'let' and 'withinput' fields

    int t_SMB3_compression_capabilities__size;
    const_byteptr const t_dataptr_after_algs = (t_begin_of_data + 8) + (t_algs__size);
    BINPAC_ASSERT(t_dataptr_after_algs <= t_end_of_data);
    t_SMB3_compression_capabilities__size = t_dataptr_after_algs - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB3_compression_capabilities__size) <= t_end_of_data);
    return t_SMB3_compression_capabilities__size;
}

SMB3_netname_negotiate_context_id::SMB3_netname_negotiate_context_id(uint16 len) {
    len_ = len;
}

SMB3_netname_negotiate_context_id::~SMB3_netname_negotiate_context_id() {
    net_name_.free();
}

int SMB3_netname_negotiate_context_id::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Parse "net_name"
    int t_net_name__size;
    t_net_name__size = len();
    // Checking out-of-bound for "SMB3_netname_negotiate_context_id:net_name"
    if ( t_begin_of_data + (t_net_name__size) > t_end_of_data || t_begin_of_data + (t_net_name__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB3_netname_negotiate_context_id:net_name",
        	(0) + (t_net_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_net_name__size;
        int t_net_name_string_length;
        t_net_name_string_length = len();
        // check for negative sizes
        if ( t_net_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:92", t_net_name_string_length);
        net_name_.init(t_begin_of_data, t_net_name_string_length);
    }

    int t_SMB3_netname_negotiate_context_id__size;
    const_byteptr const t_dataptr_after_net_name = t_begin_of_data + (t_net_name__size);
    BINPAC_ASSERT(t_dataptr_after_net_name <= t_end_of_data);
    t_SMB3_netname_negotiate_context_id__size = t_dataptr_after_net_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB3_netname_negotiate_context_id__size) <= t_end_of_data);
    return t_SMB3_netname_negotiate_context_id__size;
}

SMB3_negotiate_context_value::SMB3_negotiate_context_value() {
    context_type_ = 0;
    data_length_ = 0;
    reserved_ = 0;
    data_case_index_ = -1;
    preauth_integrity_capabilities_ = nullptr;
    encryption_capabilities_ = nullptr;
    compression_capabilities_ = nullptr;
    netname_negotiate_context_id_ = nullptr;
}

SMB3_negotiate_context_value::~SMB3_negotiate_context_value() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)1):
            // Clean up "preauth_integrity_capabilities"
            {
                delete preauth_integrity_capabilities_;
                preauth_integrity_capabilities_ = nullptr;
            }
            break;
        case ((uint16)2):
            // Clean up "encryption_capabilities"
            {
                delete encryption_capabilities_;
                encryption_capabilities_ = nullptr;
            }
            break;
        case ((uint16)3):
            // Clean up "compression_capabilities"
            {
                delete compression_capabilities_;
                compression_capabilities_ = nullptr;
            }
            break;
        case ((uint16)5):
            // Clean up "netname_negotiate_context_id"
            {
                delete netname_negotiate_context_id_;
                netname_negotiate_context_id_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_context_data"
            {
                unknown_context_data_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB3_negotiate_context_value::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB3_negotiate_context_value:reserved"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB3_negotiate_context_value:reserved",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "context_type"
    context_type_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "data_length"
    data_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "data"
    int t_data__size;
    data_case_index_ = context_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint16)1):
            // Parse "preauth_integrity_capabilities"
            {
                preauth_integrity_capabilities_ = new SMB3_preauth_integrity_capabilities();
                int t_preauth_integrity_capabilities__size;
                t_preauth_integrity_capabilities__size = preauth_integrity_capabilities_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);
                t_data__size = t_preauth_integrity_capabilities__size;
            }
            break;
        case ((uint16)2):
            // Parse "encryption_capabilities"
            {
                encryption_capabilities_ = new SMB3_encryption_capabilities();
                int t_encryption_capabilities__size;
                t_encryption_capabilities__size = encryption_capabilities_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);
                t_data__size = t_encryption_capabilities__size;
            }
            break;
        case ((uint16)3):
            // Parse "compression_capabilities"
            {
                compression_capabilities_ = new SMB3_compression_capabilities();
                int t_compression_capabilities__size;
                t_compression_capabilities__size = compression_capabilities_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);
                t_data__size = t_compression_capabilities__size;
            }
            break;
        case ((uint16)5):
            // Parse "netname_negotiate_context_id"
            {
                netname_negotiate_context_id_ = new SMB3_netname_negotiate_context_id(data_length());
                int t_netname_negotiate_context_id__size;
                t_netname_negotiate_context_id__size = netname_negotiate_context_id_->Parse((t_begin_of_data + 8), t_end_of_data);
                t_data__size = t_netname_negotiate_context_id__size;
            }
            break;
        default:
            // Parse "unknown_context_data"
            {
                int t_unknown_context_data__size;
                t_unknown_context_data__size = data_length();
                // Checking out-of-bound for "SMB3_negotiate_context_value:unknown_context_data"
                if ( (t_begin_of_data + 8) + (t_unknown_context_data__size) > t_end_of_data || (t_begin_of_data + 8) + (t_unknown_context_data__size) < (t_begin_of_data + 8) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB3_negotiate_context_value:unknown_context_data",
                    	(8) + (t_unknown_context_data__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_unknown_context_data__size;
                    int t_unknown_context_data_string_length;
                    t_unknown_context_data_string_length = data_length();
                    // check for negative sizes
                    if ( t_unknown_context_data_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:104", t_unknown_context_data_string_length);
                    unknown_context_data_.init((t_begin_of_data + 8), t_unknown_context_data_string_length);
                }
                t_data__size = t_unknown_context_data__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB3_negotiate_context_value__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 8) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB3_negotiate_context_value__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB3_negotiate_context_value__size) <= t_end_of_data);
    return t_SMB3_negotiate_context_value__size;
}

Padded_SMB3_negotiate_context_value::Padded_SMB3_negotiate_context_value() {
    ncv_ = nullptr;
}

Padded_SMB3_negotiate_context_value::~Padded_SMB3_negotiate_context_value() {
    delete ncv_;
    ncv_ = nullptr;
}

int Padded_SMB3_negotiate_context_value::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "ncv"
    ncv_ = new SMB3_negotiate_context_value();
    int t_ncv__size;
    t_ncv__size = ncv_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);


    int t_Padded_SMB3_negotiate_context_value__size;
    const_byteptr const t_dataptr_after_ncv = t_begin_of_data + (t_ncv__size);
    BINPAC_ASSERT(t_dataptr_after_ncv <= t_end_of_data);
    int pad__size = (t_dataptr_after_ncv - t_begin_of_data) % 8;
    pad__size = (pad__size == 0) ? 0 : 8 - pad__size;
    const_byteptr const t_dataptr_after_pad = t_dataptr_after_ncv + pad__size;
    t_Padded_SMB3_negotiate_context_value__size = t_dataptr_after_pad - t_begin_of_data;
    // Checking out-of-bound for "Padded_SMB3_negotiate_context_value"
    if ( t_begin_of_data + (t_Padded_SMB3_negotiate_context_value__size) > t_end_of_data || t_begin_of_data + (t_Padded_SMB3_negotiate_context_value__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Padded_SMB3_negotiate_context_value",
        	(0) + (t_Padded_SMB3_negotiate_context_value__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Padded_SMB3_negotiate_context_value__size) <= t_end_of_data);
    return t_Padded_SMB3_negotiate_context_value__size;
}

SMB2_negotiate_request::SMB2_negotiate_request(SMB2_Header* header) {
    structure_size_ = 0;
    dialect_count_ = 0;
    security_mode_ = 0;
    capabilities_ = 0;
    client_guid_ = nullptr;
    client_start_time_ = 0;
    dialects_ = nullptr;
    dialects__elem_ = 0;
    header_ = header;
    byteorder_ = littleendian;
    proc_ = false;
}

SMB2_negotiate_request::~SMB2_negotiate_request() {
    delete client_guid_;
    client_guid_ = nullptr;
    delete dialects_;
}

int SMB2_negotiate_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB2_negotiate_request:client_start_time"
    if ( (t_begin_of_data + 28) + (8) > t_end_of_data || (t_begin_of_data + 28) + (8) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_negotiate_request:client_start_time",
        	(28) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "dialect_count"
    dialect_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "security_mode"
    security_mode_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));


    // Parse "capabilities"
    capabilities_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "client_guid"
    client_guid_ = new SMB2_guid();
    client_guid_->Parse((t_begin_of_data + 12), t_end_of_data, byteorder());

    // Parse "client_start_time"
    client_start_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 28))));

    // Parse "dialects"
    int t_dialects__arraylength;
    t_dialects__arraylength = dialect_count();
    if ( t_dialects__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB2_negotiate_request:dialects",
          t_dialects__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB2_negotiate_request:dialects
    if ( t_dialects__arraylength > ((t_end_of_data - (t_begin_of_data + 36)) / 2) )
        throw binpac::ExceptionOutOfBound("SMB2_negotiate_request:dialects",
          t_dialects__arraylength, (t_end_of_data) - ((t_begin_of_data + 36)));
    dialects__elem_ = 0;
    int t_dialects__elem__it;
    t_dialects__elem__it = 0;
    int t_dialects__size;
    dialects_ = new vector<uint16>;
    dialects_->reserve(t_dialects__arraylength);
    const_byteptr t_dialects__elem__dataptr = (t_begin_of_data + 36);
    for (; t_dialects__elem__it < t_dialects__arraylength; ++t_dialects__elem__it) {
        dialects__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dialects__elem__dataptr)));
        dialects_->push_back(dialects__elem_);
        t_dialects__elem__dataptr += 2;
        BINPAC_ASSERT(t_dialects__elem__dataptr <= t_end_of_data);
    }
end_of_dialects: ;
    t_dialects__size = t_dialects__elem__dataptr - ((t_begin_of_data + 36));
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_negotiate_request__size;
    const_byteptr const t_dataptr_after_dialects = (t_begin_of_data + 36) + (t_dialects__size);
    BINPAC_ASSERT(t_dataptr_after_dialects <= t_end_of_data);
    t_SMB2_negotiate_request__size = t_dataptr_after_dialects - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_negotiate_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_negotiate_request__size) <= t_end_of_data);
    return t_SMB2_negotiate_request__size;
}

NegotiateContextList::NegotiateContextList(uint16 len) {
    vals_ = nullptr;
    vals__elem_ = nullptr;
    last_val_ = nullptr;
    len_ = len;
}

NegotiateContextList::~NegotiateContextList() {
    delete vals__elem_;
    vals__elem_ = nullptr;
    if ( vals() ) {
        for ( auto* vals__elem_ : *vals() ) {
            delete vals__elem_;
            vals__elem_ = nullptr;
        }
    }
    delete vals_;
    delete last_val_;
    last_val_ = nullptr;
}

int NegotiateContextList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "vals"
    int t_vals__arraylength;
    t_vals__arraylength = len() - 1;
    if ( t_vals__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("NegotiateContextList:vals",
          t_vals__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check array element quantity: NegotiateContextList:vals
    if ( t_vals__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
        throw binpac::ExceptionOutOfBound("NegotiateContextList:vals",
          t_vals__arraylength, (t_end_of_data) - (t_begin_of_data));
    vals__elem_ = nullptr;
    int t_vals__elem__it;
    t_vals__elem__it = 0;
    int t_vals__size;
    vals_ = new vector<Padded_SMB3_negotiate_context_value*>;
    vals_->reserve(t_vals__arraylength);
    const_byteptr t_vals__elem__dataptr = t_begin_of_data;
    for (; t_vals__elem__it < t_vals__arraylength; ++t_vals__elem__it) {
        vals__elem_ = new Padded_SMB3_negotiate_context_value();
        int t_vals__elem__size;
        t_vals__elem__size = vals__elem_->Parse(t_vals__elem__dataptr, t_end_of_data, t_byteorder);
        vals_->push_back(vals__elem_);
        t_vals__elem__dataptr += t_vals__elem__size;
        BINPAC_ASSERT(t_vals__elem__dataptr <= t_end_of_data);
        vals__elem_ = nullptr;
    }
end_of_vals: ;
    t_vals__size = t_vals__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_vals = t_begin_of_data + (t_vals__size);
    BINPAC_ASSERT(t_dataptr_after_vals <= t_end_of_data);
    // Parse "last_val"
    last_val_ = new SMB3_negotiate_context_value();
    int t_last_val__size;
    t_last_val__size = last_val_->Parse(t_dataptr_after_vals, t_end_of_data, t_byteorder);

    int t_NegotiateContextList__size;
    const_byteptr const t_dataptr_after_last_val = t_dataptr_after_vals + (t_last_val__size);
    BINPAC_ASSERT(t_dataptr_after_last_val <= t_end_of_data);
    t_NegotiateContextList__size = t_dataptr_after_last_val - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_NegotiateContextList__size) <= t_end_of_data);
    return t_NegotiateContextList__size;
}

OptNegotiateContextList::OptNegotiateContextList(uint16 len) {
    opt_case_index_ = -1;
    list_ = nullptr;
    len_ = len;
}

OptNegotiateContextList::~OptNegotiateContextList() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( opt_case_index() ) {
        case ((uint16)0):
            // Clean up "nil"
            {
            }
            break;
        default:
            // Clean up "list"
            {
                delete list_;
                list_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int OptNegotiateContextList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "opt"
    int t_opt__size;
    opt_case_index_ = len();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( opt_case_index() ) {
        case ((uint16)0):
            // Parse "nil"
            {
                t_opt__size = 0;
            }
            break;
        default:
            // Parse "list"
            {
                list_ = new NegotiateContextList(len());
                int t_list__size;
                t_list__size = list_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_opt__size = t_list__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_OptNegotiateContextList__size;
    const_byteptr const t_dataptr_after_opt = t_begin_of_data + (t_opt__size);
    BINPAC_ASSERT(t_dataptr_after_opt <= t_end_of_data);
    t_OptNegotiateContextList__size = t_dataptr_after_opt - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_OptNegotiateContextList__size) <= t_end_of_data);
    return t_OptNegotiateContextList__size;
}

SMB2_negotiate_response::SMB2_negotiate_response(SMB2_Header* header) {
    structure_size_ = 0;
    security_mode_ = 0;
    dialect_revision_ = 0;
    negotiate_context_count_ = 0;
    server_guid_ = nullptr;
    capabilities_ = 0;
    max_transact_size_ = 0;
    max_read_size_ = 0;
    max_write_size_ = 0;
    system_time_ = 0;
    server_start_time_ = 0;
    security_offset_ = 0;
    security_length_ = 0;
    negotiate_context_offset_ = 0;
    negotiate_context_list_case_index_ = -1;
    smb3_ncl_ = nullptr;
    header_ = header;
    byteorder_ = littleendian;
    proc_ = false;
    gssapi_proc_ = false;
}

SMB2_negotiate_response::~SMB2_negotiate_response() {
    delete server_guid_;
    server_guid_ = nullptr;
    security_blob_.free();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( negotiate_context_list_case_index() ) {
        case ((uint16)785):
            // Clean up "smb3_ncl"
            {
                delete smb3_ncl_;
                smb3_ncl_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_negotiate_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB2_negotiate_response:negotiate_context_offset"
    if ( (t_begin_of_data + 60) + (4) > t_end_of_data || (t_begin_of_data + 60) + (4) < (t_begin_of_data + 60) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_negotiate_response:negotiate_context_offset",
        	(60) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "security_mode"
    security_mode_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "dialect_revision"
    dialect_revision_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "negotiate_context_count"
    negotiate_context_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "server_guid"
    server_guid_ = new SMB2_guid();
    server_guid_->Parse((t_begin_of_data + 8), t_end_of_data, byteorder());

    // Parse "capabilities"
    capabilities_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));

    // Parse "max_transact_size"
    max_transact_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));

    // Parse "max_read_size"
    max_read_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "max_write_size"
    max_write_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 36))));

    // Parse "system_time"
    system_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 40))));

    // Parse "server_start_time"
    server_start_time_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 48))));

    // Parse "security_offset"
    security_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 56))));

    // Parse "security_length"
    security_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 58))));

    // Parse "negotiate_context_offset"
    negotiate_context_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 60))));

    // Parse "security_blob"
    int t_security_blob__size;
    t_security_blob__size = security_length();
    // Checking out-of-bound for "SMB2_negotiate_response:security_blob"
    if ( (t_begin_of_data + 64) + (t_security_blob__size) > t_end_of_data || (t_begin_of_data + 64) + (t_security_blob__size) < (t_begin_of_data + 64) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_negotiate_response:security_blob",
        	(64) + (t_security_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 64) + t_security_blob__size;
        int t_security_blob_string_length;
        t_security_blob_string_length = security_length();
        // check for negative sizes
        if ( t_security_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:153", t_security_blob_string_length);
        security_blob_.init((t_begin_of_data + 64), t_security_blob_string_length);
    }


    const_byteptr const t_dataptr_after_security_blob = (t_begin_of_data + 64) + (t_security_blob__size);
    BINPAC_ASSERT(t_dataptr_after_security_blob <= t_end_of_data);
    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + ( ( dialect_revision() == 0x0311 ? negotiate_context_offset() - header()->head_length() : 0 ) );
    if ( t_dataptr_after_pad1 < t_dataptr_after_security_blob ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-negotiate.pac:154:pad1", t_dataptr_after_security_blob - t_begin_of_data,  ( dialect_revision() == 0x0311 ? negotiate_context_offset() - header()->head_length() : 0 ) );
        t_dataptr_after_pad1 = t_dataptr_after_security_blob;
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_negotiate_response:pad1",
        	( ( dialect_revision() == 0x0311 ? negotiate_context_offset() - header()->head_length() : 0 ) ), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "negotiate_context_list"
    int t_negotiate_context_list__size;
    negotiate_context_list_case_index_ = dialect_revision();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( negotiate_context_list_case_index() ) {
        case ((uint16)785):
            // Parse "smb3_ncl"
            {
                smb3_ncl_ = new OptNegotiateContextList(negotiate_context_count());
                int t_smb3_ncl__size;
                t_smb3_ncl__size = smb3_ncl_->Parse(t_dataptr_after_pad1, t_end_of_data, byteorder());
                t_negotiate_context_list__size = t_smb3_ncl__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                t_negotiate_context_list__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_negotiate_response__size;
    const_byteptr const t_dataptr_after_negotiate_context_list = t_dataptr_after_pad1 + (t_negotiate_context_list__size);
    BINPAC_ASSERT(t_dataptr_after_negotiate_context_list <= t_end_of_data);
    t_SMB2_negotiate_response__size = t_dataptr_after_negotiate_context_list - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_negotiate_response(header(), this);
    gssapi_proc_ = t_context->connection()->forward_gssapi(security_blob(), false);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_negotiate_response__size) <= t_end_of_data);
    return t_SMB2_negotiate_response__size;
}

SMB2_read_request::SMB2_read_request(SMB2_Header* header) {
    structure_size_ = 0;
    pad_ = 0;
    reserved_ = 0;
    read_len_ = 0;
    offset_ = 0;
    file_id_ = nullptr;
    minimum_count_ = 0;
    channel_ = 0;
    remaining_bytes_ = 0;
    channel_info_offset_ = 0;
    channel_info_len_ = 0;
    header_ = header;
    proc_ = false;
}

SMB2_read_request::~SMB2_read_request() {
    delete file_id_;
    file_id_ = nullptr;
    buffer_.free();
}

int SMB2_read_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_read_request:channel_info_len"
    if ( (t_begin_of_data + 46) + (2) > t_end_of_data || (t_begin_of_data + 46) + (2) < (t_begin_of_data + 46) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_read_request:channel_info_len",
        	(46) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "pad"
    pad_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "read_len"
    read_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "offset"
    offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 16), t_end_of_data, t_byteorder);

    // Parse "minimum_count"
    minimum_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "channel"
    channel_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 36))));

    // Parse "remaining_bytes"
    remaining_bytes_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 40))));

    // Parse "channel_info_offset"
    channel_info_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 44))));

    // Parse "channel_info_len"
    channel_info_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 46))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (channel_info_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 48) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-read.pac:88:pad", (t_begin_of_data + 48) - t_begin_of_data, channel_info_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 48);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_read_request:pad",
        	(channel_info_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "buffer"
    int t_buffer__size;
    t_buffer__size = channel_info_len();
    // Checking out-of-bound for "SMB2_read_request:buffer"
    if ( t_dataptr_after_pad + (t_buffer__size) > t_end_of_data || t_dataptr_after_pad + (t_buffer__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_read_request:buffer",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_buffer__size;
        int t_buffer_string_length;
        t_buffer_string_length = channel_info_len();
        // check for negative sizes
        if ( t_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-read.pac:89", t_buffer_string_length);
        buffer_.init(t_dataptr_after_pad, t_buffer_string_length);
    }

    int t_SMB2_read_request__size;
    const_byteptr const t_dataptr_after_buffer = t_dataptr_after_pad + (t_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_buffer <= t_end_of_data);
    t_SMB2_read_request__size = t_dataptr_after_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_read_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_read_request__size) <= t_end_of_data);
    return t_SMB2_read_request__size;
}

SMB2_read_response::SMB2_read_response(SMB2_Header* header) {
    structure_size_ = 0;
    data_offset_ = 0;
    reserved1_ = 0;
    data_len_ = 0;
    data_remaining_ = 0;
    reserved2_ = 0;
    header_ = header;
    fid_ = 0;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
    proc_ = false;
}

SMB2_read_response::~SMB2_read_response() {
    data_.free();
}

int SMB2_read_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_read_response:reserved2"
    if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_read_response:reserved2",
        	(12) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "data_offset"
    data_offset_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "reserved1"
    reserved1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "data_len"
    data_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "data_remaining"
    data_remaining_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (data_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 16) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-read.pac:101:pad", (t_begin_of_data + 16) - t_begin_of_data, data_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 16);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_read_response:pad",
        	(data_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "data"
    int t_data__size;
    t_data__size = data_len();
    // Checking out-of-bound for "SMB2_read_response:data"
    if ( t_dataptr_after_pad + (t_data__size) > t_end_of_data || t_dataptr_after_pad + (t_data__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_read_response:data",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_data__size;
        int t_data_string_length;
        t_data_string_length = data_len();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-read.pac:102", t_data_string_length);
        data_.init(t_dataptr_after_pad, t_data_string_length);
    }

    int t_SMB2_read_response__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB2_read_response__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    fid_ = t_context->connection()->get_file_id(header()->message_id(), header()->status() != 0x00000103);
    has_pipe_proc_ =  ( header()->is_pipe() ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(data(), fid(), false);
    }
    proc_ = t_context->connection()->proc_smb2_read_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_read_response__size) <= t_end_of_data);
    return t_SMB2_read_response__size;
}

SMB2_session_setup_request::SMB2_session_setup_request(SMB2_Header* header) {
    structure_size_ = 0;
    vc_number_ = 0;
    security_mode_ = 0;
    capabilities_ = 0;
    channel_ = 0;
    security_offset_ = 0;
    security_length_ = 0;
    header_ = header;
    proc_ = false;
    gssapi_proc_ = false;
}

SMB2_session_setup_request::~SMB2_session_setup_request() {
    security_blob_.free();
}

int SMB2_session_setup_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_session_setup_request:security_length"
    if ( (t_begin_of_data + 14) + (2) > t_end_of_data || (t_begin_of_data + 14) + (2) < (t_begin_of_data + 14) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_session_setup_request:security_length",
        	(14) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "vc_number"
    vc_number_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "security_mode"
    security_mode_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "capabilities"
    capabilities_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "channel"
    channel_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "security_offset"
    security_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 12))));

    // Parse "security_length"
    security_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));


    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (security_offset() - header()->head_length());
    if ( t_dataptr_after_pad1 < (t_begin_of_data + 16) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-session-setup.pac:50:pad1", (t_begin_of_data + 16) - t_begin_of_data, security_offset() - header()->head_length());
        t_dataptr_after_pad1 = (t_begin_of_data + 16);
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_session_setup_request:pad1",
        	(security_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "security_blob"
    int t_security_blob__size;
    t_security_blob__size = security_length();
    // Checking out-of-bound for "SMB2_session_setup_request:security_blob"
    if ( t_dataptr_after_pad1 + (t_security_blob__size) > t_end_of_data || t_dataptr_after_pad1 + (t_security_blob__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_session_setup_request:security_blob",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_security_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_security_blob__size;
        int t_security_blob_string_length;
        t_security_blob_string_length = security_length();
        // check for negative sizes
        if ( t_security_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-session-setup.pac:51", t_security_blob_string_length);
        security_blob_.init(t_dataptr_after_pad1, t_security_blob_string_length);
    }

    int t_SMB2_session_setup_request__size;
    const_byteptr const t_dataptr_after_security_blob = t_dataptr_after_pad1 + (t_security_blob__size);
    BINPAC_ASSERT(t_dataptr_after_security_blob <= t_end_of_data);
    t_SMB2_session_setup_request__size = t_dataptr_after_security_blob - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_session_setup_request(header(), this);
    gssapi_proc_ = t_context->connection()->forward_gssapi(security_blob(), true);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_session_setup_request__size) <= t_end_of_data);
    return t_SMB2_session_setup_request__size;
}

SMB2_session_setup_response::SMB2_session_setup_response(SMB2_Header* header) {
    structure_size_ = 0;
    session_flags_ = 0;
    security_offset_ = 0;
    security_length_ = 0;
    header_ = header;
    flag_guest_ = 0;
    flag_anonymous_ = 0;
    flag_encrypt_ = 0;
    proc_ = false;
    gssapi_proc_ = false;
}

SMB2_session_setup_response::~SMB2_session_setup_response() {
    security_blob_.free();
}

int SMB2_session_setup_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_session_setup_response:security_length"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_session_setup_response:security_length",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "session_flags"
    session_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "security_offset"
    security_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "security_length"
    security_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));


    const_byteptr t_dataptr_after_pad1 = t_begin_of_data + (security_offset() - header()->head_length());
    if ( t_dataptr_after_pad1 < (t_begin_of_data + 8) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-session-setup.pac:62:pad1", (t_begin_of_data + 8) - t_begin_of_data, security_offset() - header()->head_length());
        t_dataptr_after_pad1 = (t_begin_of_data + 8);
    }
    if ( t_dataptr_after_pad1 > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_session_setup_response:pad1",
        	(security_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad1));
    }
    // Parse "security_blob"
    int t_security_blob__size;
    t_security_blob__size = security_length();
    // Checking out-of-bound for "SMB2_session_setup_response:security_blob"
    if ( t_dataptr_after_pad1 + (t_security_blob__size) > t_end_of_data || t_dataptr_after_pad1 + (t_security_blob__size) < t_dataptr_after_pad1 ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_session_setup_response:security_blob",
        	((t_dataptr_after_pad1 - t_begin_of_data)) + (t_security_blob__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad1 + t_security_blob__size;
        int t_security_blob_string_length;
        t_security_blob_string_length = security_length();
        // check for negative sizes
        if ( t_security_blob_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-session-setup.pac:63", t_security_blob_string_length);
        security_blob_.init(t_dataptr_after_pad1, t_security_blob_string_length);
    }

    int t_SMB2_session_setup_response__size;
    const_byteptr const t_dataptr_after_security_blob = t_dataptr_after_pad1 + (t_security_blob__size);
    BINPAC_ASSERT(t_dataptr_after_security_blob <= t_end_of_data);
    t_SMB2_session_setup_response__size = t_dataptr_after_security_blob - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    flag_guest_ =  ( session_flags() & 0x1 )  > 0;
    flag_anonymous_ =  ( session_flags() & 0x2 )  > 0;
    flag_encrypt_ =  ( session_flags() & 0x4 )  > 0;
    proc_ = t_context->connection()->proc_smb2_session_setup_response(header(), this);
    gssapi_proc_ = t_context->connection()->forward_gssapi(security_blob(), false);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_session_setup_response__size) <= t_end_of_data);
    return t_SMB2_session_setup_response__size;
}

SMB2_file_basic_info::SMB2_file_basic_info(SMB2_set_info_request* sir) {
    creation_time_ = 0;
    last_access_time_ = 0;
    last_write_time_ = 0;
    change_time_ = 0;
    file_attrs_ = nullptr;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_basic_info::~SMB2_file_basic_info() {
    delete file_attrs_;
    file_attrs_ = nullptr;
}

int SMB2_file_basic_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_basic_info"
    if ( t_begin_of_data + (36) > t_end_of_data || t_begin_of_data + (36) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_basic_info",
        	(0) + (36), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "creation_time"
    creation_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_begin_of_data)));

    // Parse "last_access_time"
    last_access_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "last_write_time"
    last_write_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 16))));

    // Parse "change_time"
    change_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 24))));

    // Parse "file_attrs"
    file_attrs_ = new SMB2_file_attributes();
    file_attrs_->Parse((t_begin_of_data + 32), t_end_of_data, t_byteorder);

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file(this);
    BINPAC_ASSERT(t_begin_of_data + (36) <= t_end_of_data);
    return 36;
}

SMB2_file_rename_info::SMB2_file_rename_info(SMB2_set_info_request* sir) {
    replace_if_exists_ = 0;
    reserved_ = nullptr;
    reserved__elem_ = 0;
    root_directory_ = 0;
    filename_len_ = 0;
    filename_ = nullptr;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_rename_info::~SMB2_file_rename_info() {
    delete reserved_;
    delete filename_;
    filename_ = nullptr;
}

int SMB2_file_rename_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_rename_info:filename_len"
    if ( (t_begin_of_data + 16) + (4) > t_end_of_data || (t_begin_of_data + 16) + (4) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_rename_info:filename_len",
        	(16) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "replace_if_exists"
    replace_if_exists_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "reserved"
    int t_reserved__arraylength;
    t_reserved__arraylength = 7;
    if ( t_reserved__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB2_file_rename_info:reserved",
          t_reserved__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB2_file_rename_info:reserved
    if ( t_reserved__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("SMB2_file_rename_info:reserved",
          t_reserved__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
    reserved__elem_ = 0;
    int t_reserved__elem__it;
    t_reserved__elem__it = 0;
    reserved_ = new vector<uint8>;
    reserved_->reserve(t_reserved__arraylength);
    const_byteptr t_reserved__elem__dataptr = (t_begin_of_data + 1);
    for (; t_reserved__elem__it < t_reserved__arraylength; ++t_reserved__elem__it) {
        reserved__elem_ = *(reinterpret_cast<uint8 const*>(t_reserved__elem__dataptr));
        reserved_->push_back(reserved__elem_);
        t_reserved__elem__dataptr += 1;
        BINPAC_ASSERT(t_reserved__elem__dataptr <= t_end_of_data);
    }
end_of_reserved: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "root_directory"
    root_directory_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "filename_len"
    filename_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "filename"
    filename_ = new SMB2_string(filename_len());
    int t_filename__size;
    t_filename__size = filename_->Parse((t_begin_of_data + 20), t_end_of_data);

    int t_SMB2_file_rename_info__size;
    const_byteptr const t_dataptr_after_filename = (t_begin_of_data + 20) + (t_filename__size);
    BINPAC_ASSERT(t_dataptr_after_filename <= t_end_of_data);
    t_SMB2_file_rename_info__size = t_dataptr_after_filename - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_rename(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_file_rename_info__size) <= t_end_of_data);
    return t_SMB2_file_rename_info__size;
}

SMB2_file_disposition_info::SMB2_file_disposition_info(SMB2_set_info_request* sir) {
    delete_pending_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_disposition_info::~SMB2_file_disposition_info() {
}

int SMB2_file_disposition_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB2_file_disposition_info"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_disposition_info",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "delete_pending"
    delete_pending_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_delete(this);
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

SMB2_file_allocation_info::SMB2_file_allocation_info(SMB2_set_info_request* sir) {
    allocation_size_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_allocation_info::~SMB2_file_allocation_info() {
}

int SMB2_file_allocation_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_allocation_info"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_allocation_info",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "allocation_size"
    allocation_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_allocation(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SMB2_file_endoffile_info::SMB2_file_endoffile_info(SMB2_set_info_request* sir) {
    endoffile_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_endoffile_info::~SMB2_file_endoffile_info() {
}

int SMB2_file_endoffile_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_endoffile_info"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_endoffile_info",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "endoffile"
    endoffile_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_endoffile(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SMB2_file_fullea_info_element::SMB2_file_fullea_info_element() {
    next_entry_offset_ = 0;
    flags_ = 0;
    ea_name_length_ = 0;
    ea_value_length_ = 0;
    ea_name_ = nullptr;
    ea_value_ = nullptr;
    next_offset_ = 0;
}

SMB2_file_fullea_info_element::~SMB2_file_fullea_info_element() {
    delete ea_name_;
    ea_name_ = nullptr;
    delete ea_value_;
    ea_value_ = nullptr;
}

int SMB2_file_fullea_info_element::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_fullea_info_element:ea_value_length"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_fullea_info_element:ea_value_length",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "next_entry_offset"
    next_entry_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "ea_name_length"
    ea_name_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Parse "ea_value_length"
    ea_value_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "ea_name"
    ea_name_ = new SMB2_string(ea_name_length());
    int t_ea_name__size;
    t_ea_name__size = ea_name_->Parse((t_begin_of_data + 8), t_end_of_data);

    const_byteptr const t_dataptr_after_ea_name = (t_begin_of_data + 8) + (t_ea_name__size);
    BINPAC_ASSERT(t_dataptr_after_ea_name <= t_end_of_data);
    // Parse "ea_value"
    ea_value_ = new SMB2_string(ea_value_length());
    int t_ea_value__size;
    t_ea_value__size = ea_value_->Parse(t_dataptr_after_ea_name, t_end_of_data);


    int t_SMB2_file_fullea_info_element__size;
    const_byteptr const t_dataptr_after_ea_value = t_dataptr_after_ea_name + (t_ea_value__size);
    BINPAC_ASSERT(t_dataptr_after_ea_value <= t_end_of_data);
    const_byteptr t_dataptr_after_pad_to_next = t_begin_of_data + (next_entry_offset());
    if ( t_dataptr_after_pad_to_next < t_dataptr_after_ea_value ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:273:pad_to_next", t_dataptr_after_ea_value - t_begin_of_data, next_entry_offset());
        t_dataptr_after_pad_to_next = t_dataptr_after_ea_value;
    }
    if ( t_dataptr_after_pad_to_next > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_file_fullea_info_element:pad_to_next",
        	(next_entry_offset()), 
        	(t_end_of_data) - (t_dataptr_after_pad_to_next));
    }
    t_SMB2_file_fullea_info_element__size = t_dataptr_after_pad_to_next - t_begin_of_data;
    // Checking out-of-bound for "SMB2_file_fullea_info_element"
    if ( t_begin_of_data + (t_SMB2_file_fullea_info_element__size) > t_end_of_data || t_begin_of_data + (t_SMB2_file_fullea_info_element__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_fullea_info_element",
        	(0) + (t_SMB2_file_fullea_info_element__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    next_offset_ = next_entry_offset();
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_file_fullea_info_element__size) <= t_end_of_data);
    return t_SMB2_file_fullea_info_element__size;
}

SMB2_file_fullea_info::SMB2_file_fullea_info(SMB2_set_info_request* sir) {
    ea_vector_ = nullptr;
    ea_vector__elem_ = nullptr;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_fullea_info::~SMB2_file_fullea_info() {
    delete ea_vector__elem_;
    ea_vector__elem_ = nullptr;
    if ( ea_vector() ) {
        for ( auto* ea_vector__elem_ : *ea_vector() ) {
            delete ea_vector__elem_;
            ea_vector__elem_ = nullptr;
        }
    }
    delete ea_vector_;
}

int SMB2_file_fullea_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Parse "ea_vector"
    int t_ea_vector__arraylength;
    t_ea_vector__arraylength = 0;
    ea_vector__elem_ = nullptr;
    int t_ea_vector__elem__it;
    t_ea_vector__elem__it = 0;
    int t_ea_vector__size;
    ea_vector_ = new vector<SMB2_file_fullea_info_element*>;
    const_byteptr t_ea_vector__elem__dataptr = t_begin_of_data;
    for (; /* forever */; ++t_ea_vector__elem__it) {
        // Check &until(ea_vector__elem__dataptr >= end_of_data)
        if ( t_ea_vector__elem__dataptr >= t_end_of_data ) {
            ea_vector__elem_ = nullptr;
            goto end_of_ea_vector;
        }
        ea_vector__elem_ = new SMB2_file_fullea_info_element();
        int t_ea_vector__elem__size;
        t_ea_vector__elem__size = ea_vector__elem_->Parse(t_ea_vector__elem__dataptr, t_end_of_data, t_byteorder);
        ea_vector_->push_back(ea_vector__elem_);
        t_ea_vector__elem__dataptr += t_ea_vector__elem__size;
        BINPAC_ASSERT(t_ea_vector__elem__dataptr <= t_end_of_data);
        // Check &until( ( @$element->next_offset@ == ((int) 0) ) )
        if (  ( ea_vector__elem_->next_offset() == 0 )  ) {
            ea_vector__elem_ = nullptr;
            goto end_of_ea_vector;
        }
        ea_vector__elem_ = nullptr;
    }
end_of_ea_vector: ;
    t_ea_vector__size = t_ea_vector__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_file_fullea_info__size;
    const_byteptr const t_dataptr_after_ea_vector = t_begin_of_data + (t_ea_vector__size);
    BINPAC_ASSERT(t_dataptr_after_ea_vector <= t_end_of_data);
    t_SMB2_file_fullea_info__size = t_dataptr_after_ea_vector - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_fullea(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_file_fullea_info__size) <= t_end_of_data);
    return t_SMB2_file_fullea_info__size;
}

SMB2_file_link_info::SMB2_file_link_info(SMB2_set_info_request* sir) {
    replace_if_exists_ = 0;
    reserved_ = nullptr;
    reserved__elem_ = 0;
    root_directory_ = 0;
    file_name_length_ = 0;
    file_name_ = nullptr;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_link_info::~SMB2_file_link_info() {
    delete reserved_;
    delete file_name_;
    file_name_ = nullptr;
}

int SMB2_file_link_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_link_info:file_name_length"
    if ( (t_begin_of_data + 16) + (4) > t_end_of_data || (t_begin_of_data + 16) + (4) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_link_info:file_name_length",
        	(16) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "replace_if_exists"
    replace_if_exists_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "reserved"
    int t_reserved__arraylength;
    t_reserved__arraylength = 7;
    if ( t_reserved__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB2_file_link_info:reserved",
          t_reserved__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB2_file_link_info:reserved
    if ( t_reserved__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("SMB2_file_link_info:reserved",
          t_reserved__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
    reserved__elem_ = 0;
    int t_reserved__elem__it;
    t_reserved__elem__it = 0;
    reserved_ = new vector<uint8>;
    reserved_->reserve(t_reserved__arraylength);
    const_byteptr t_reserved__elem__dataptr = (t_begin_of_data + 1);
    for (; t_reserved__elem__it < t_reserved__arraylength; ++t_reserved__elem__it) {
        reserved__elem_ = *(reinterpret_cast<uint8 const*>(t_reserved__elem__dataptr));
        reserved_->push_back(reserved__elem_);
        t_reserved__elem__dataptr += 1;
        BINPAC_ASSERT(t_reserved__elem__dataptr <= t_end_of_data);
    }
end_of_reserved: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "root_directory"
    root_directory_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "file_name_length"
    file_name_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "file_name"
    file_name_ = new SMB2_string(file_name_length());
    int t_file_name__size;
    t_file_name__size = file_name_->Parse((t_begin_of_data + 20), t_end_of_data);

    int t_SMB2_file_link_info__size;
    const_byteptr const t_dataptr_after_file_name = (t_begin_of_data + 20) + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    t_SMB2_file_link_info__size = t_dataptr_after_file_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_link(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_file_link_info__size) <= t_end_of_data);
    return t_SMB2_file_link_info__size;
}

SMB2_file_mode_info::SMB2_file_mode_info(SMB2_set_info_request* sir) {
    mode_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_mode_info::~SMB2_file_mode_info() {
}

int SMB2_file_mode_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_mode_info"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_mode_info",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "mode"
    mode_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_mode(this);
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_file_pipe_info::SMB2_file_pipe_info(SMB2_set_info_request* sir) {
    read_mode_ = 0;
    completion_mode_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_pipe_info::~SMB2_file_pipe_info() {
}

int SMB2_file_pipe_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_pipe_info"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_pipe_info",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "read_mode"
    read_mode_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "completion_mode"
    completion_mode_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_pipe(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SMB2_file_position_info::SMB2_file_position_info(SMB2_set_info_request* sir) {
    current_byte_offset_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_position_info::~SMB2_file_position_info() {
}

int SMB2_file_position_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_position_info"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_position_info",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "current_byte_offset"
    current_byte_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_position(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SMB2_file_shortname_info::SMB2_file_shortname_info(SMB2_set_info_request* sir) {
    filename_length_ = 0;
    filename_ = nullptr;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_shortname_info::~SMB2_file_shortname_info() {
    delete filename_;
    filename_ = nullptr;
}

int SMB2_file_shortname_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_shortname_info:filename_length"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_shortname_info:filename_length",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "filename_length"
    filename_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "filename"
    filename_ = new SMB2_string(filename_length());
    int t_filename__size;
    t_filename__size = filename_->Parse((t_begin_of_data + 4), t_end_of_data);

    int t_SMB2_file_shortname_info__size;
    const_byteptr const t_dataptr_after_filename = (t_begin_of_data + 4) + (t_filename__size);
    BINPAC_ASSERT(t_dataptr_after_filename <= t_end_of_data);
    t_SMB2_file_shortname_info__size = t_dataptr_after_filename - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_shortname(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_file_shortname_info__size) <= t_end_of_data);
    return t_SMB2_file_shortname_info__size;
}

SMB2_file_validdatalength_info::SMB2_file_validdatalength_info(SMB2_set_info_request* sir) {
    validdatalength_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_validdatalength_info::~SMB2_file_validdatalength_info() {
}

int SMB2_file_validdatalength_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_validdatalength_info"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_validdatalength_info",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "validdatalength"
    validdatalength_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_validdatalength(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SMB2_file_fscontrol_info::SMB2_file_fscontrol_info(SMB2_set_info_request* sir) {
    free_space_start_filtering_ = 0;
    free_space_start_threshold_ = 0;
    free_space_stop_filtering_ = 0;
    default_quota_threshold_ = 0;
    default_quota_limit_ = 0;
    file_system_control_flags_ = 0;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_fscontrol_info::~SMB2_file_fscontrol_info() {
}

int SMB2_file_fscontrol_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_fscontrol_info"
    if ( t_begin_of_data + (48) > t_end_of_data || t_begin_of_data + (48) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_fscontrol_info",
        	(0) + (48), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "free_space_start_filtering"
    free_space_start_filtering_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>(t_begin_of_data)));

    // Parse "free_space_start_threshold"
    free_space_start_threshold_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>((t_begin_of_data + 8))));

    // Parse "free_space_stop_filtering"
    free_space_stop_filtering_ = FixByteOrder(t_byteorder, *(reinterpret_cast<int64 const*>((t_begin_of_data + 16))));

    // Parse "default_quota_threshold"
    default_quota_threshold_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 24))));

    // Parse "default_quota_limit"
    default_quota_limit_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 32))));

    // Parse "file_system_control_flags"
    file_system_control_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 40))));


    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_fscontrol(this);
    BINPAC_ASSERT(t_begin_of_data + (48) <= t_end_of_data);
    return 48;
}

SMB2_file_fsobjectid_info::SMB2_file_fsobjectid_info(SMB2_set_info_request* sir) {
    object_id_ = nullptr;
    extended_info_ = nullptr;
    sir_ = sir;
    proc_ = false;
}

SMB2_file_fsobjectid_info::~SMB2_file_fsobjectid_info() {
    delete object_id_;
    object_id_ = nullptr;
    delete extended_info_;
    extended_info_ = nullptr;
}

int SMB2_file_fsobjectid_info::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_fsobjectid_info:object_id"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_fsobjectid_info:object_id",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "object_id"
    object_id_ = new SMB2_guid();
    object_id_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    // Parse "extended_info"
    extended_info_ = new SMB2_string(48);
    int t_extended_info__size;
    t_extended_info__size = extended_info_->Parse((t_begin_of_data + 16), t_end_of_data);

    int t_SMB2_file_fsobjectid_info__size;
    const_byteptr const t_dataptr_after_extended_info = (t_begin_of_data + 16) + (t_extended_info__size);
    BINPAC_ASSERT(t_dataptr_after_extended_info <= t_end_of_data);
    t_SMB2_file_fsobjectid_info__size = t_dataptr_after_extended_info - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_set_info_request_file_fsobjectid(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_file_fsobjectid_info__size) <= t_end_of_data);
    return t_SMB2_file_fsobjectid_info__size;
}

SMB2_set_info_file_class::SMB2_set_info_file_class(SMB2_set_info_request* sir) {
    val_case_index_ = -1;
    file_basic_ = nullptr;
    file_rename_ = nullptr;
    file_disposition_ = nullptr;
    file_allocation_ = nullptr;
    file_endoffile_ = nullptr;
    file_fullea_ = nullptr;
    file_link_ = nullptr;
    file_mode_ = nullptr;
    file_pipe_ = nullptr;
    file_position_ = nullptr;
    file_shortname_ = nullptr;
    file_validdatalength_ = nullptr;
    sir_ = sir;
}

SMB2_set_info_file_class::~SMB2_set_info_file_class() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)4):
            // Clean up "file_basic"
            {
                delete file_basic_;
                file_basic_ = nullptr;
            }
            break;
        case ((uint8)10):
            // Clean up "file_rename"
            {
                delete file_rename_;
                file_rename_ = nullptr;
            }
            break;
        case ((uint8)13):
            // Clean up "file_disposition"
            {
                delete file_disposition_;
                file_disposition_ = nullptr;
            }
            break;
        case ((uint8)19):
            // Clean up "file_allocation"
            {
                delete file_allocation_;
                file_allocation_ = nullptr;
            }
            break;
        case ((uint8)20):
            // Clean up "file_endoffile"
            {
                delete file_endoffile_;
                file_endoffile_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "file_fullea"
            {
                delete file_fullea_;
                file_fullea_ = nullptr;
            }
            break;
        case ((uint8)11):
            // Clean up "file_link"
            {
                delete file_link_;
                file_link_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "file_mode"
            {
                delete file_mode_;
                file_mode_ = nullptr;
            }
            break;
        case ((uint8)24):
            // Clean up "file_pipe"
            {
                delete file_pipe_;
                file_pipe_ = nullptr;
            }
            break;
        case ((uint8)14):
            // Clean up "file_position"
            {
                delete file_position_;
                file_position_ = nullptr;
            }
            break;
        case ((uint8)40):
            // Clean up "file_shortname"
            {
                delete file_shortname_;
                file_shortname_ = nullptr;
            }
            break;
        case ((uint8)39):
            // Clean up "file_validdatalength"
            {
                delete file_validdatalength_;
                file_validdatalength_ = nullptr;
            }
            break;
        default:
            // Clean up "info_file_unhandled"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_set_info_file_class::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = sir()->info_level();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)4):
            // Parse "file_basic"
            {
                file_basic_ = new SMB2_file_basic_info(sir());
                file_basic_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 36;
            }
            break;
        case ((uint8)10):
            // Parse "file_rename"
            {
                file_rename_ = new SMB2_file_rename_info(sir());
                int t_file_rename__size;
                t_file_rename__size = file_rename_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_file_rename__size;
            }
            break;
        case ((uint8)13):
            // Parse "file_disposition"
            {
                file_disposition_ = new SMB2_file_disposition_info(sir());
                file_disposition_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
        case ((uint8)19):
            // Parse "file_allocation"
            {
                file_allocation_ = new SMB2_file_allocation_info(sir());
                file_allocation_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 8;
            }
            break;
        case ((uint8)20):
            // Parse "file_endoffile"
            {
                file_endoffile_ = new SMB2_file_endoffile_info(sir());
                file_endoffile_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 8;
            }
            break;
        case ((uint8)15):
            // Parse "file_fullea"
            {
                file_fullea_ = new SMB2_file_fullea_info(sir());
                int t_file_fullea__size;
                t_file_fullea__size = file_fullea_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_file_fullea__size;
            }
            break;
        case ((uint8)11):
            // Parse "file_link"
            {
                file_link_ = new SMB2_file_link_info(sir());
                int t_file_link__size;
                t_file_link__size = file_link_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_file_link__size;
            }
            break;
        case ((uint8)16):
            // Parse "file_mode"
            {
                file_mode_ = new SMB2_file_mode_info(sir());
                file_mode_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 4;
            }
            break;
        case ((uint8)24):
            // Parse "file_pipe"
            {
                file_pipe_ = new SMB2_file_pipe_info(sir());
                file_pipe_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 8;
            }
            break;
        case ((uint8)14):
            // Parse "file_position"
            {
                file_position_ = new SMB2_file_position_info(sir());
                file_position_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 8;
            }
            break;
        case ((uint8)40):
            // Parse "file_shortname"
            {
                file_shortname_ = new SMB2_file_shortname_info(sir());
                int t_file_shortname__size;
                t_file_shortname__size = file_shortname_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_file_shortname__size;
            }
            break;
        case ((uint8)39):
            // Parse "file_validdatalength"
            {
                file_validdatalength_ = new SMB2_file_validdatalength_info(sir());
                file_validdatalength_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 8;
            }
            break;
        default:
            // Parse "info_file_unhandled"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_set_info_filesystem_class::SMB2_set_info_filesystem_class(SMB2_set_info_request* sir) {
    val_case_index_ = -1;
    file_fscontrol_ = nullptr;
    file_fsobjectid_ = nullptr;
    sir_ = sir;
}

SMB2_set_info_filesystem_class::~SMB2_set_info_filesystem_class() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)6):
            // Clean up "file_fscontrol"
            {
                delete file_fscontrol_;
                file_fscontrol_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "file_fsobjectid"
            {
                delete file_fsobjectid_;
                file_fsobjectid_ = nullptr;
            }
            break;
        default:
            // Clean up "info_file_unhandled"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_set_info_filesystem_class::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = sir()->info_level();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)6):
            // Parse "file_fscontrol"
            {
                file_fscontrol_ = new SMB2_file_fscontrol_info(sir());
                file_fscontrol_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 48;
            }
            break;
        case ((uint8)8):
            // Parse "file_fsobjectid"
            {
                file_fsobjectid_ = new SMB2_file_fsobjectid_info(sir());
                int t_file_fsobjectid__size;
                t_file_fsobjectid__size = file_fsobjectid_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_file_fsobjectid__size;
            }
            break;
        default:
            // Parse "info_file_unhandled"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_set_info_request::SMB2_set_info_request(SMB2_Header* header) {
    structure_size_ = 0;
    info_class_ = 0;
    info_level_ = 0;
    buffer_len_ = 0;
    buffer_offset_ = 0;
    reserved_ = 0;
    additional_info_ = 0;
    file_id_ = nullptr;
    data_case_index_ = -1;
    file_info_ = nullptr;
    filesystem_info_ = nullptr;
    header_ = header;
}

SMB2_set_info_request::~SMB2_set_info_request() {
    delete file_id_;
    file_id_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)1):
            // Clean up "file_info"
            {
                delete file_info_;
                file_info_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "filesystem_info"
            {
                delete filesystem_info_;
                filesystem_info_ = nullptr;
            }
            break;
        default:
            // Clean up "class_unhandled"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_set_info_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_set_info_request:file_id"
    if ( (t_begin_of_data + 16) + (16) > t_end_of_data || (t_begin_of_data + 16) + (16) < (t_begin_of_data + 16) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_set_info_request:file_id",
        	(16) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "info_class"
    info_class_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "info_level"
    info_level_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "buffer_len"
    buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "buffer_offset"
    buffer_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "additional_info"
    additional_info_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 16), t_end_of_data, t_byteorder);


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (buffer_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 32) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-set-info.pac:378:pad", (t_begin_of_data + 32) - t_begin_of_data, buffer_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 32);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_set_info_request:pad",
        	(buffer_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "data"
    int t_data__size;
    data_case_index_ = info_class();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( data_case_index() ) {
        case ((uint8)1):
            // Parse "file_info"
            {
                file_info_ = new SMB2_set_info_file_class(this);
                int t_file_info__size;
                t_file_info__size = file_info_->Parse(t_dataptr_after_pad, t_end_of_data, t_context, t_byteorder);
                t_data__size = t_file_info__size;
            }
            break;
        case ((uint8)2):
            // Parse "filesystem_info"
            {
                filesystem_info_ = new SMB2_set_info_filesystem_class(this);
                int t_filesystem_info__size;
                t_filesystem_info__size = filesystem_info_->Parse(t_dataptr_after_pad, t_end_of_data, t_context, t_byteorder);
                t_data__size = t_filesystem_info__size;
            }
            break;
        default:
            // Parse "class_unhandled"
            {
                t_data__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_set_info_request__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB2_set_info_request__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_set_info_request__size) <= t_end_of_data);
    return t_SMB2_set_info_request__size;
}

SMB2_set_info_response::SMB2_set_info_response(SMB2_Header* header) {
    structure_size_ = 0;
    header_ = header;
}

SMB2_set_info_response::~SMB2_set_info_response() {
}

int SMB2_set_info_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_set_info_response"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_set_info_response",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

SMB2_tree_connect_request::SMB2_tree_connect_request(SMB2_Header* header) {
    structure_size_ = 0;
    path_offset_ = 0;
    path_length_ = 0;
    path_ = nullptr;
    header_ = header;
    proc_ = false;
}

SMB2_tree_connect_request::~SMB2_tree_connect_request() {
    delete path_;
    path_ = nullptr;
}

int SMB2_tree_connect_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_tree_connect_request:path_length"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_tree_connect_request:path_length",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));


    // Parse "path_offset"
    path_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "path_length"
    path_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (path_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 8) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-tree-connect.pac:41:pad", (t_begin_of_data + 8) - t_begin_of_data, path_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 8);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_tree_connect_request:pad",
        	(path_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "path"
    path_ = new SMB2_string(path_length());
    int t_path__size;
    t_path__size = path_->Parse(t_dataptr_after_pad, t_end_of_data);

    int t_SMB2_tree_connect_request__size;
    const_byteptr const t_dataptr_after_path = t_dataptr_after_pad + (t_path__size);
    BINPAC_ASSERT(t_dataptr_after_path <= t_end_of_data);
    t_SMB2_tree_connect_request__size = t_dataptr_after_path - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_tree_connect_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_tree_connect_request__size) <= t_end_of_data);
    return t_SMB2_tree_connect_request__size;
}

SMB2_tree_connect_response::SMB2_tree_connect_response(SMB2_Header* header) {
    structure_size_ = 0;
    share_type_ = 0;
    share_flags_ = 0;
    capabilities_ = 0;
    maximal_access_ = 0;
    header_ = header;
    proc_ = false;
}

SMB2_tree_connect_response::~SMB2_tree_connect_response() {
}

int SMB2_tree_connect_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_tree_connect_response"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_tree_connect_response",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "share_type"
    share_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));


    // Parse "share_flags"
    share_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "capabilities"
    capabilities_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "maximal_access"
    maximal_access_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_tree_connect_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (16) <= t_end_of_data);
    return 16;
}

SMB2_tree_disconnect_request::SMB2_tree_disconnect_request(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
    proc_ = false;
}

SMB2_tree_disconnect_request::~SMB2_tree_disconnect_request() {
}

int SMB2_tree_disconnect_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_tree_disconnect_request"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_tree_disconnect_request",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_tree_disconnect_request(header());
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_tree_disconnect_response::SMB2_tree_disconnect_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
    proc_ = false;
}

SMB2_tree_disconnect_response::~SMB2_tree_disconnect_response() {
}

int SMB2_tree_disconnect_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_tree_disconnect_response"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_tree_disconnect_response",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_tree_disconnect_response(header());
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_write_request::SMB2_write_request(SMB2_Header* header) {
    structure_size_ = 0;
    data_offset_ = 0;
    data_len_ = 0;
    offset_ = 0;
    file_id_ = nullptr;
    channel_ = 0;
    data_remaining_ = 0;
    channel_info_offset_ = 0;
    channel_info_len_ = 0;
    flags_ = 0;
    header_ = header;
    pipe_proc_ = false;
    has_pipe_proc_ = false;
    proc_ = false;
}

SMB2_write_request::~SMB2_write_request() {
    delete file_id_;
    file_id_ = nullptr;
    data_.free();
}

int SMB2_write_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_write_request:flags"
    if ( (t_begin_of_data + 44) + (4) > t_end_of_data || (t_begin_of_data + 44) + (4) < (t_begin_of_data + 44) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_write_request:flags",
        	(44) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "data_offset"
    data_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "data_len"
    data_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "offset"
    offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 16), t_end_of_data, t_byteorder);

    // Parse "channel"
    channel_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "data_remaining"
    data_remaining_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 36))));

    // Parse "channel_info_offset"
    channel_info_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 40))));

    // Parse "channel_info_len"
    channel_info_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 42))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 44))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (data_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 48) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-write.pac:53:pad", (t_begin_of_data + 48) - t_begin_of_data, data_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 48);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_write_request:pad",
        	(data_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "data"
    int t_data__size;
    t_data__size = data_len();
    // Checking out-of-bound for "SMB2_write_request:data"
    if ( t_dataptr_after_pad + (t_data__size) > t_end_of_data || t_dataptr_after_pad + (t_data__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_write_request:data",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_data__size;
        int t_data_string_length;
        t_data_string_length = data_len();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-com-write.pac:54", t_data_string_length);
        data_.init(t_dataptr_after_pad, t_data_string_length);
    }

    int t_SMB2_write_request__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_pad + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SMB2_write_request__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    has_pipe_proc_ =  ( header()->is_pipe() ) ;
    if ( has_pipe_proc() ) {
        pipe_proc_ = t_context->connection()->forward_dce_rpc(data(), file_id()->persistent() + file_id()->_volatile(), true);
    }
    proc_ = t_context->connection()->proc_smb2_write_request(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_write_request__size) <= t_end_of_data);
    return t_SMB2_write_request__size;
}

SMB2_write_response::SMB2_write_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    write_count_ = 0;
    remaining_ = 0;
    channel_info_offset_ = 0;
    channel_info_len_ = 0;
    header_ = header;
    proc_ = false;
}

SMB2_write_response::~SMB2_write_response() {
}

int SMB2_write_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_write_response"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_write_response",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "write_count"
    write_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "remaining"
    remaining_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "channel_info_offset"
    channel_info_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 12))));

    // Parse "channel_info_len"
    channel_info_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_write_response(header(), this);
    BINPAC_ASSERT(t_begin_of_data + (16) <= t_end_of_data);
    return 16;
}

SMB2_transform_header::SMB2_transform_header() {
    orig_msg_size_ = 0;
    reserved_ = 0;
    flags_ = 0;
    session_id_ = 0;
    byteorder_ = littleendian;
    proc_ = false;
}

SMB2_transform_header::~SMB2_transform_header() {
    signature_.free();
    nonce_.free();
}

int SMB2_transform_header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Parse "signature"
    // Checking out-of-bound for "SMB2_transform_header:signature"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_transform_header:signature",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 16;
        int t_signature_string_length;
        t_signature_string_length = 16;
        int t_signature__size;
        t_signature__size = t_signature_string_length;
        signature_.init(t_begin_of_data, t_signature_string_length);
    }

    const_byteptr const t_dataptr_after_signature = t_begin_of_data + (16);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    // Parse "nonce"
    // Checking out-of-bound for "SMB2_transform_header:nonce"
    if ( t_dataptr_after_signature + (16) > t_end_of_data || t_dataptr_after_signature + (16) < t_dataptr_after_signature ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_transform_header:nonce",
        	((t_dataptr_after_signature - t_begin_of_data)) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_signature + 16;
        int t_nonce_string_length;
        t_nonce_string_length = 16;
        int t_nonce__size;
        t_nonce__size = t_nonce_string_length;
        nonce_.init(t_dataptr_after_signature, t_nonce_string_length);
    }

    const_byteptr const t_dataptr_after_nonce = t_dataptr_after_signature + (16);
    BINPAC_ASSERT(t_dataptr_after_nonce <= t_end_of_data);
    // Checking out-of-bound for "SMB2_transform_header:session_id"
    if ( (t_dataptr_after_nonce + 8) + (8) > t_end_of_data || (t_dataptr_after_nonce + 8) + (8) < (t_dataptr_after_nonce + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_transform_header:session_id",
        	(((t_dataptr_after_nonce + 8) - t_begin_of_data)) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "orig_msg_size"
    orig_msg_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_dataptr_after_nonce)));

    // Parse "reserved"
    reserved_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_nonce + 4))));

    // Parse "flags"
    flags_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_dataptr_after_nonce + 6))));

    // Parse "session_id"
    session_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_dataptr_after_nonce + 8))));

    int t_SMB2_transform_header__size;
    t_SMB2_transform_header__size = (t_dataptr_after_nonce + 16) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb2_transform_header(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_transform_header__size) <= t_end_of_data);
    return t_SMB2_transform_header__size;
}

uint24::uint24() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
}

uint24::~uint24() {
}

int uint24::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint24"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint24",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

uint32 to_int(uint24* num) {

	return (num->byte1() << 16) | (num->byte2() << 8) | num->byte3();
	
}

SMB_TCP::SMB_TCP(bool is_orig) {
    message_type_ = 0;
    len24_ = nullptr;
    body_case_index_ = -1;
    nbss_ = nullptr;
    nbss__elem_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
    len_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

SMB_TCP::~SMB_TCP() {
    delete len24_;
    len24_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( body_case_index() ) {
        case ((uint8)0):
            // Clean up "nbss"
            {
                delete nbss__elem_;
                nbss__elem_ = nullptr;
                if ( nbss() ) {
                    for ( auto* nbss__elem_ : *nbss() ) {
                        delete nbss__elem_;
                        nbss__elem_ = nullptr;
                    }
                }
                delete nbss_;
            }
            break;
        default:
            // Clean up "skip"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool SMB_TCP::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSMB* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "len24"
            len24_ = new uint24();
            len24_->Parse((t_begin_of_data + 1), t_end_of_data);
            len_ = to_int(len24());
            t_flow_buffer->GrowFrame(len() + 4);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "message_type"
                // Checking out-of-bound for "SMB_TCP:message_type"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB_TCP:message_type",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                message_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));


                // Parse "body"
                int t_body__size;
                body_case_index_ = message_type();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( body_case_index() ) {
                    case ((uint8)0):
                        // Parse "nbss"
                        {
                            int t_nbss__arraylength;
                            t_nbss__arraylength = 0;
                            nbss__elem_ = nullptr;
                            int t_nbss__elem__it;
                            t_nbss__elem__it = 0;
                            int t_nbss__size;
                            nbss_ = new vector<SMB_Protocol_Identifier*>;
                            const_byteptr t_nbss__elem__dataptr = (t_begin_of_data + 4);
                            for (; /* forever */; ++t_nbss__elem__it) {
                                // Check &until(nbss__elem__dataptr >= end_of_data)
                                if ( t_nbss__elem__dataptr >= t_end_of_data ) {
                                    nbss__elem_ = nullptr;
                                    goto end_of_nbss;
                                }
                                nbss__elem_ = new SMB_Protocol_Identifier(is_orig(), len());
                                int t_nbss__elem__size;
                                t_nbss__elem__size = nbss__elem_->Parse(t_nbss__elem__dataptr, t_end_of_data, t_context);
                                nbss_->push_back(nbss__elem_);
                                t_nbss__elem__dataptr += t_nbss__elem__size;
                                BINPAC_ASSERT(t_nbss__elem__dataptr <= t_end_of_data);
                                // Check &until( ( @$element->end_of_chain@ ) )
                                if (  ( nbss__elem_->end_of_chain() )  ) {
                                    nbss__elem_ = nullptr;
                                    goto end_of_nbss;
                                }
                                nbss__elem_ = nullptr;
                            }
                        end_of_nbss: ;
                            t_nbss__size = t_nbss__elem__dataptr - ((t_begin_of_data + 4));
                            // Evaluate 'let' and 'withinput' fields
                            t_body__size = t_nbss__size;
                        }
                        break;
                    default:
                        // Parse "skip"
                        {
                            int t_skip_string_length;
                            t_skip_string_length = (t_end_of_data) - ((t_begin_of_data + 4));
                            int t_skip__size;
                            t_skip__size = t_skip_string_length;
                            // check for negative sizes
                            if ( t_skip_string_length < 0 )
                            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb.pac:121", t_skip_string_length);
                            skip_.init((t_begin_of_data + 4), t_skip_string_length);
                            t_body__size = t_skip__size;
                        }
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

SMB_Protocol_Identifier::SMB_Protocol_Identifier(bool is_orig, uint32 msg_len) {
    protocol_ = 0;
    smb_1_or_2_case_index_ = -1;
    smb1_ = nullptr;
    smb2_ = nullptr;
    smb3_ = nullptr;
    is_orig_ = is_orig;
    msg_len_ = msg_len;
    end_of_chain_ = false;
}

SMB_Protocol_Identifier::~SMB_Protocol_Identifier() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( smb_1_or_2_case_index() ) {
        case ((int32)-11317950):
            // Clean up "smb1"
            {
                delete smb1_;
                smb1_ = nullptr;
            }
            break;
        case ((int32)-28095166):
            // Clean up "smb2"
            {
                delete smb2_;
                smb2_ = nullptr;
            }
            break;
        case ((int32)-44872382):
            // Clean up "smb3"
            {
                delete smb3_;
                smb3_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_Protocol_Identifier::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_Protocol_Identifier:protocol"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_Protocol_Identifier:protocol",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "protocol"
    protocol_ = FixByteOrder(bigendian, *(reinterpret_cast<int32 const*>(t_begin_of_data)));

    // Parse "smb_1_or_2"
    int t_smb_1_or_2__size;
    smb_1_or_2_case_index_ = protocol();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( smb_1_or_2_case_index() ) {
        case ((int32)-11317950):
            // Parse "smb1"
            {
                smb1_ = new SMB_PDU(is_orig(), msg_len());
                int t_smb1__size;
                t_smb1__size = smb1_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                t_smb_1_or_2__size = t_smb1__size;
            }
            break;
        case ((int32)-28095166):
            // Parse "smb2"
            {
                smb2_ = new SMB2_PDU(is_orig());
                int t_smb2__size;
                t_smb2__size = smb2_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                t_smb_1_or_2__size = t_smb2__size;
            }
            break;
        case ((int32)-44872382):
            // Parse "smb3"
            {
                smb3_ = new SMB2_transform_header();
                int t_smb3__size;
                t_smb3__size = smb3_->Parse((t_begin_of_data + 4), t_end_of_data, t_context);
                t_smb_1_or_2__size = t_smb3__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                t_smb_1_or_2__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB_Protocol_Identifier__size;
    const_byteptr const t_dataptr_after_smb_1_or_2 = (t_begin_of_data + 4) + (t_smb_1_or_2__size);
    BINPAC_ASSERT(t_dataptr_after_smb_1_or_2 <= t_end_of_data);
    t_SMB_Protocol_Identifier__size = t_dataptr_after_smb_1_or_2 - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    end_of_chain_ =  ( protocol() == SMB2 )  ? smb2()->end_of_chain() : true;
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_Protocol_Identifier__size) <= t_end_of_data);
    return t_SMB_Protocol_Identifier__size;
}


	zeek::RecordValPtr SMBHeaderVal(SMB_Header* hdr)
		{
		auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB1::Header);

		//unsigned int status = 0;
		//
		//try
		//	{
		//	// FIXME: does this work?  We need to catch exceptions :-(
		//	// or use guard functions.
		//	status = ${hdr.status.error} ||
		//	         ${hdr.status.dos_error.error_class} << 24 ||
		//	         ${hdr.status.dos_error.error_class};
		//	}
		//catch ( const binpac::Exception& )
		//	{ // do nothing
		//	}

		r->Assign(0, hdr->command());
		r->Assign(1, hdr->status());
		r->Assign(2, hdr->flags());
		r->Assign(3, hdr->flags2());
		r->Assign(4, hdr->tid());
		r->Assign(5, hdr->pid());
		r->Assign(6, hdr->uid());
		r->Assign(7, hdr->mid());

		return r;
		}

SMB_dos_error::SMB_dos_error() {
    error_class_ = 0;
    reserved_ = 0;
    error_ = 0;
}

SMB_dos_error::~SMB_dos_error() {
}

int SMB_dos_error::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB_dos_error"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_dos_error",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "error_class"
    error_class_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "error"
    error_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB_error::SMB_error(int err_status_type) {
    val_case_index_ = -1;
    dos_error_ = nullptr;
    error_ = 0;
    err_status_type_ = err_status_type;
}

SMB_error::~SMB_error() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "dos_error"
            {
                delete dos_error_;
                dos_error_ = nullptr;
            }
            break;
        default:
            // Clean up "error"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_error::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB_error:val"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_error:val",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    val_case_index_ = err_status_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "dos_error"
            {
                dos_error_ = new SMB_dos_error();
                dos_error_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
            }
            break;
        default:
            // Parse "error"
            {
                error_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB_andx::SMB_andx() {
    command_ = 0;
    reserved_ = 0;
    offset_ = 0;
    byteorder_ = littleendian;
}

SMB_andx::~SMB_andx() {
}

int SMB_andx::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SMB_andx"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_andx",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "command"
    command_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "offset"
    offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB_PDU::SMB_PDU(bool is_orig, uint32 msg_len) {
    header_ = nullptr;
    message_case_index_ = -1;
    no_msg_ = nullptr;
    msg_ = nullptr;
    is_orig_ = is_orig;
    msg_len_ = msg_len;
}

SMB_PDU::~SMB_PDU() {
    delete header_;
    header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( message_case_index() ) {
        case ((uint32)35):
            // Clean up "no_msg"
            {
                delete no_msg_;
                no_msg_ = nullptr;
            }
            break;
        default:
            // Clean up "msg"
            {
                delete msg_;
                msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_PDU:header"
    if ( t_begin_of_data + (28) > t_end_of_data || t_begin_of_data + (28) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_PDU:header",
        	(0) + (28), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "header"
    header_ = new SMB_Header(is_orig());
    header_->Parse(t_begin_of_data, t_end_of_data, t_context);

    // Parse "message"
    int t_message__size;
    message_case_index_ = msg_len();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( message_case_index() ) {
        case ((uint32)35):
            // Parse "no_msg"
            {
                no_msg_ = new SMB_No_Message(header(), is_orig());
                int t_no_msg__size;
                t_no_msg__size = no_msg_->Parse((t_begin_of_data + 28), t_end_of_data, t_context);
                t_message__size = t_no_msg__size;
            }
            break;
        default:
            // Parse "msg"
            {
                msg_ = new SMB_Message(header(), SMB_Header_length, header()->command(), is_orig());
                int t_msg__size;
                t_msg__size = msg_->Parse((t_begin_of_data + 28), t_end_of_data, t_context);
                t_message__size = t_msg__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB_PDU__size;
    const_byteptr const t_dataptr_after_message = (t_begin_of_data + 28) + (t_message__size);
    BINPAC_ASSERT(t_dataptr_after_message <= t_end_of_data);
    t_SMB_PDU__size = t_dataptr_after_message - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_PDU__size) <= t_end_of_data);
    return t_SMB_PDU__size;
}

SMB_No_Message::SMB_No_Message(SMB_Header* header, bool is_orig) {
    header_ = header;
    is_orig_ = is_orig;
    proc_ = false;
}

SMB_No_Message::~SMB_No_Message() {
}

int SMB_No_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Parse "x"
    // Checking out-of-bound for "SMB_No_Message:x"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_No_Message:x",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 3;
        int t_x_string_length;
        t_x_string_length = 3;
        int t_x__size;
        t_x__size = t_x_string_length;
        x_.init(t_begin_of_data, t_x_string_length);
    }

    int t_SMB_No_Message__size;
    const_byteptr const t_dataptr_after_x = t_begin_of_data + (3);
    BINPAC_ASSERT(t_dataptr_after_x <= t_end_of_data);
    t_SMB_No_Message__size = t_dataptr_after_x - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb_no_msg(header(), is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_SMB_No_Message__size) <= t_end_of_data);
    return t_SMB_No_Message__size;
}

SMB_empty_response::SMB_empty_response(SMB_Header* header) {
    word_count_ = 0;
    byte_count_ = 0;
    header_ = header;
    proc_ = false;
}

SMB_empty_response::~SMB_empty_response() {
}

int SMB_empty_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB_empty_response"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_empty_response",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "word_count"
    word_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte_count"
    byte_count_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_smb_empty_response(header());
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

SMB_Message::SMB_Message(SMB_Header* header, uint16 offset, uint8 command, bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    response_ = nullptr;
    header_ = header;
    offset_ = offset;
    command_ = command;
    is_orig_ = is_orig;
}

SMB_Message::~SMB_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                request_ = new SMB_Message_Request(header(), offset(), command(), is_orig());
                int t_request__size;
                t_request__size = request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_request__size;
            }
            break;
        case false:
            // Parse "response"
            {
                response_ = new SMB_Message_Response(header(), offset(), command(), is_orig());
                int t_response__size;
                t_response__size = response_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_response__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB_andx_command::SMB_andx_command(SMB_Header* header, bool is_orig, uint16 offset, uint8 command) {
    val_case_index_ = -1;
    message_ = nullptr;
    header_ = header;
    is_orig_ = is_orig;
    offset_ = offset;
    command_ = command;
}

SMB_andx_command::~SMB_andx_command() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)255):
            // Clean up "no_further_commands"
            {
            }
            break;
        default:
            // Clean up "message"
            {
                delete message_;
                message_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_andx_command::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = command();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)255):
            // Parse "no_further_commands"
            {
                t_val__size = 0;
            }
            break;
        default:
            // Parse "message"
            {
                message_ = new SMB_Message(header(), offset(), command(), is_orig());
                int t_message__size;
                t_message__size = message_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_message__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB_Message_Request::SMB_Message_Request(SMB_Header* header, uint16 offset, uint8 command, bool is_orig) {
    val_case_index_ = -1;
    read_andx_ = nullptr;
    write_andx_ = nullptr;
    transaction2_ = nullptr;
    negotiate_ = nullptr;
    session_setup_andx_ = nullptr;
    tree_connect_andx_ = nullptr;
    nt_transact_ = nullptr;
    nt_create_andx_ = nullptr;
    close_ = nullptr;
    query_information_ = nullptr;
    check_directory_ = nullptr;
    locking_andx_ = nullptr;
    transaction_ = nullptr;
    transaction_secondary_ = nullptr;
    echo_ = nullptr;
    transaction2_secondary_ = nullptr;
    tree_disconnect_ = nullptr;
    logoff_andx_ = nullptr;
    nt_cancel_ = nullptr;
    header_ = header;
    offset_ = offset;
    command_ = command;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
}

SMB_Message_Request::~SMB_Message_Request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)46):
            // Clean up "read_andx"
            {
                delete read_andx_;
                read_andx_ = nullptr;
            }
            break;
        case ((uint8)47):
            // Clean up "write_andx"
            {
                delete write_andx_;
                write_andx_ = nullptr;
            }
            break;
        case ((uint8)50):
            // Clean up "transaction2"
            {
                delete transaction2_;
                transaction2_ = nullptr;
            }
            break;
        case ((uint8)114):
            // Clean up "negotiate"
            {
                delete negotiate_;
                negotiate_ = nullptr;
            }
            break;
        case ((uint8)115):
            // Clean up "session_setup_andx"
            {
                delete session_setup_andx_;
                session_setup_andx_ = nullptr;
            }
            break;
        case ((uint8)117):
            // Clean up "tree_connect_andx"
            {
                delete tree_connect_andx_;
                tree_connect_andx_ = nullptr;
            }
            break;
        case ((uint8)160):
            // Clean up "nt_transact"
            {
                delete nt_transact_;
                nt_transact_ = nullptr;
            }
            break;
        case ((uint8)162):
            // Clean up "nt_create_andx"
            {
                delete nt_create_andx_;
                nt_create_andx_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "close"
            {
                delete close_;
                close_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "query_information"
            {
                delete query_information_;
                query_information_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "check_directory"
            {
                delete check_directory_;
                check_directory_ = nullptr;
            }
            break;
        case ((uint8)36):
            // Clean up "locking_andx"
            {
                delete locking_andx_;
                locking_andx_ = nullptr;
            }
            break;
        case ((uint8)37):
            // Clean up "transaction"
            {
                delete transaction_;
                transaction_ = nullptr;
            }
            break;
        case ((uint8)38):
            // Clean up "transaction_secondary"
            {
                delete transaction_secondary_;
                transaction_secondary_ = nullptr;
            }
            break;
        case ((uint8)43):
            // Clean up "echo"
            {
                delete echo_;
                echo_ = nullptr;
            }
            break;
        case ((uint8)51):
            // Clean up "transaction2_secondary"
            {
                delete transaction2_secondary_;
                transaction2_secondary_ = nullptr;
            }
            break;
        case ((uint8)113):
            // Clean up "tree_disconnect"
            {
                delete tree_disconnect_;
                tree_disconnect_ = nullptr;
            }
            break;
        case ((uint8)116):
            // Clean up "logoff_andx"
            {
                delete logoff_andx_;
                logoff_andx_ = nullptr;
            }
            break;
        case ((uint8)164):
            // Clean up "nt_cancel"
            {
                delete nt_cancel_;
                nt_cancel_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_msg"
            {
                unknown_msg_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_Message_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = command();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)46):
            // Parse "read_andx"
            {
                read_andx_ = new SMB1_read_andx_request(header(), offset());
                int t_read_andx__size;
                t_read_andx__size = read_andx_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_read_andx__size;
            }
            break;
        case ((uint8)47):
            // Parse "write_andx"
            {
                write_andx_ = new SMB1_write_andx_request(header(), offset());
                int t_write_andx__size;
                t_write_andx__size = write_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_write_andx__size;
            }
            break;
        case ((uint8)50):
            // Parse "transaction2"
            {
                transaction2_ = new SMB1_transaction2_request(header());
                int t_transaction2__size;
                t_transaction2__size = transaction2_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_transaction2__size;
            }
            break;
        case ((uint8)114):
            // Parse "negotiate"
            {
                negotiate_ = new SMB1_negotiate_request(header());
                int t_negotiate__size;
                t_negotiate__size = negotiate_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_negotiate__size;
            }
            break;
        case ((uint8)115):
            // Parse "session_setup_andx"
            {
                session_setup_andx_ = new SMB1_session_setup_andx_request(header(), offset());
                int t_session_setup_andx__size;
                t_session_setup_andx__size = session_setup_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_session_setup_andx__size;
            }
            break;
        case ((uint8)117):
            // Parse "tree_connect_andx"
            {
                tree_connect_andx_ = new SMB1_tree_connect_andx_request(header(), offset());
                int t_tree_connect_andx__size;
                t_tree_connect_andx__size = tree_connect_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_tree_connect_andx__size;
            }
            break;
        case ((uint8)160):
            // Parse "nt_transact"
            {
                nt_transact_ = new SMB1_nt_transact_request(header());
                nt_transact_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
        case ((uint8)162):
            // Parse "nt_create_andx"
            {
                nt_create_andx_ = new SMB1_nt_create_andx_request(header(), offset());
                int t_nt_create_andx__size;
                t_nt_create_andx__size = nt_create_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_nt_create_andx__size;
            }
            break;
        case ((uint8)4):
            // Parse "close"
            {
                close_ = new SMB1_close_request(header());
                close_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 9;
            }
            break;
        case ((uint8)8):
            // Parse "query_information"
            {
                query_information_ = new SMB1_query_information_request(header());
                int t_query_information__size;
                t_query_information__size = query_information_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_query_information__size;
            }
            break;
        case ((uint8)16):
            // Parse "check_directory"
            {
                check_directory_ = new SMB1_check_directory_request(header());
                int t_check_directory__size;
                t_check_directory__size = check_directory_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_check_directory__size;
            }
            break;
        case ((uint8)36):
            // Parse "locking_andx"
            {
                locking_andx_ = new SMB1_locking_andx_request(header(), offset());
                int t_locking_andx__size;
                t_locking_andx__size = locking_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_locking_andx__size;
            }
            break;
        case ((uint8)37):
            // Parse "transaction"
            {
                transaction_ = new SMB1_transaction_request(header());
                int t_transaction__size;
                t_transaction__size = transaction_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_transaction__size;
            }
            break;
        case ((uint8)38):
            // Parse "transaction_secondary"
            {
                transaction_secondary_ = new SMB1_transaction_secondary_request(header());
                int t_transaction_secondary__size;
                t_transaction_secondary__size = transaction_secondary_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_transaction_secondary__size;
            }
            break;
        case ((uint8)43):
            // Parse "echo"
            {
                echo_ = new SMB1_echo_request(header());
                int t_echo__size;
                t_echo__size = echo_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_echo__size;
            }
            break;
        case ((uint8)51):
            // Parse "transaction2_secondary"
            {
                transaction2_secondary_ = new SMB1_transaction2_secondary_request(header());
                int t_transaction2_secondary__size;
                t_transaction2_secondary__size = transaction2_secondary_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_transaction2_secondary__size;
            }
            break;
        case ((uint8)113):
            // Parse "tree_disconnect"
            {
                tree_disconnect_ = new SMB1_tree_disconnect(header(), is_orig());
                tree_disconnect_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 3;
            }
            break;
        case ((uint8)116):
            // Parse "logoff_andx"
            {
                logoff_andx_ = new SMB1_logoff_andx(header(), offset(), is_orig());
                int t_logoff_andx__size;
                t_logoff_andx__size = logoff_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_logoff_andx__size;
            }
            break;
        case ((uint8)164):
            // Parse "nt_cancel"
            {
                nt_cancel_ = new SMB1_nt_cancel_request(header());
                nt_cancel_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 3;
            }
            break;
        default:
            // Parse "unknown_msg"
            {
                int t_unknown_msg_string_length;
                t_unknown_msg_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown_msg__size;
                t_unknown_msg__size = t_unknown_msg_string_length;
                // check for negative sizes
                if ( t_unknown_msg_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:217", t_unknown_msg_string_length);
                unknown_msg_.init(t_begin_of_data, t_unknown_msg_string_length);
                t_val__size = t_unknown_msg__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB_Message_Response::SMB_Message_Response(SMB_Header* header, uint16 offset, uint8 command, bool is_orig) {
    val_case_index_ = -1;
    read_andx_ = nullptr;
    write_andx_ = nullptr;
    transaction2_ = nullptr;
    negotiate_ = nullptr;
    session_setup_andx_ = nullptr;
    tree_connect_andx_ = nullptr;
    nt_transact_ = nullptr;
    nt_create_andx_ = nullptr;
    close_ = nullptr;
    query_information_ = nullptr;
    check_directory_ = nullptr;
    locking_andx_ = nullptr;
    transaction_ = nullptr;
    echo_ = nullptr;
    tree_disconnect_ = nullptr;
    logoff_andx_ = nullptr;
    header_ = header;
    offset_ = offset;
    command_ = command;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
}

SMB_Message_Response::~SMB_Message_Response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)46):
            // Clean up "read_andx"
            {
                delete read_andx_;
                read_andx_ = nullptr;
            }
            break;
        case ((uint8)47):
            // Clean up "write_andx"
            {
                delete write_andx_;
                write_andx_ = nullptr;
            }
            break;
        case ((uint8)50):
            // Clean up "transaction2"
            {
                delete transaction2_;
                transaction2_ = nullptr;
            }
            break;
        case ((uint8)114):
            // Clean up "negotiate"
            {
                delete negotiate_;
                negotiate_ = nullptr;
            }
            break;
        case ((uint8)115):
            // Clean up "session_setup_andx"
            {
                delete session_setup_andx_;
                session_setup_andx_ = nullptr;
            }
            break;
        case ((uint8)117):
            // Clean up "tree_connect_andx"
            {
                delete tree_connect_andx_;
                tree_connect_andx_ = nullptr;
            }
            break;
        case ((uint8)160):
            // Clean up "nt_transact"
            {
                delete nt_transact_;
                nt_transact_ = nullptr;
            }
            break;
        case ((uint8)162):
            // Clean up "nt_create_andx"
            {
                delete nt_create_andx_;
                nt_create_andx_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "close"
            {
                delete close_;
                close_ = nullptr;
            }
            break;
        case ((uint8)8):
            // Clean up "query_information"
            {
                delete query_information_;
                query_information_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "check_directory"
            {
                delete check_directory_;
                check_directory_ = nullptr;
            }
            break;
        case ((uint8)36):
            // Clean up "locking_andx"
            {
                delete locking_andx_;
                locking_andx_ = nullptr;
            }
            break;
        case ((uint8)37):
            // Clean up "transaction"
            {
                delete transaction_;
                transaction_ = nullptr;
            }
            break;
        case ((uint8)43):
            // Clean up "echo"
            {
                delete echo_;
                echo_ = nullptr;
            }
            break;
        case ((uint8)113):
            // Clean up "tree_disconnect"
            {
                delete tree_disconnect_;
                tree_disconnect_ = nullptr;
            }
            break;
        case ((uint8)116):
            // Clean up "logoff_andx"
            {
                delete logoff_andx_;
                logoff_andx_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_msg"
            {
                unknown_msg_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB_Message_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = command();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)46):
            // Parse "read_andx"
            {
                read_andx_ = new SMB1_read_andx_response(header(), offset());
                int t_read_andx__size;
                t_read_andx__size = read_andx_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_read_andx__size;
            }
            break;
        case ((uint8)47):
            // Parse "write_andx"
            {
                write_andx_ = new SMB1_write_andx_response(header(), offset());
                int t_write_andx__size;
                t_write_andx__size = write_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_write_andx__size;
            }
            break;
        case ((uint8)50):
            // Parse "transaction2"
            {
                transaction2_ = new SMB1_transaction2_response(header());
                int t_transaction2__size;
                t_transaction2__size = transaction2_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_transaction2__size;
            }
            break;
        case ((uint8)114):
            // Parse "negotiate"
            {
                negotiate_ = new SMB1_negotiate_response(header());
                int t_negotiate__size;
                t_negotiate__size = negotiate_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_negotiate__size;
            }
            break;
        case ((uint8)115):
            // Parse "session_setup_andx"
            {
                session_setup_andx_ = new SMB1_session_setup_andx_response(header(), offset());
                int t_session_setup_andx__size;
                t_session_setup_andx__size = session_setup_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_session_setup_andx__size;
            }
            break;
        case ((uint8)117):
            // Parse "tree_connect_andx"
            {
                tree_connect_andx_ = new SMB1_tree_connect_andx_response(header(), offset());
                int t_tree_connect_andx__size;
                t_tree_connect_andx__size = tree_connect_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_tree_connect_andx__size;
            }
            break;
        case ((uint8)160):
            // Parse "nt_transact"
            {
                nt_transact_ = new SMB1_nt_transact_response(header());
                nt_transact_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
        case ((uint8)162):
            // Parse "nt_create_andx"
            {
                nt_create_andx_ = new SMB1_nt_create_andx_response(header(), offset());
                int t_nt_create_andx__size;
                t_nt_create_andx__size = nt_create_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_nt_create_andx__size;
            }
            break;
        case ((uint8)4):
            // Parse "close"
            {
                close_ = new SMB_empty_response(header());
                close_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 3;
            }
            break;
        case ((uint8)8):
            // Parse "query_information"
            {
                query_information_ = new SMB1_query_information_response(header());
                query_information_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 23;
            }
            break;
        case ((uint8)16):
            // Parse "check_directory"
            {
                check_directory_ = new SMB1_check_directory_response(header());
                check_directory_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 3;
            }
            break;
        case ((uint8)36):
            // Parse "locking_andx"
            {
                locking_andx_ = new SMB1_locking_andx_response(header());
                locking_andx_->Parse(nullptr, nullptr, t_context);
                t_val__size = 0;
            }
            break;
        case ((uint8)37):
            // Parse "transaction"
            {
                transaction_ = new SMB1_transaction_response(header());
                int t_transaction__size;
                t_transaction__size = transaction_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_transaction__size;
            }
            break;
        case ((uint8)43):
            // Parse "echo"
            {
                echo_ = new SMB1_echo_response(header());
                int t_echo__size;
                t_echo__size = echo_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_echo__size;
            }
            break;
        case ((uint8)113):
            // Parse "tree_disconnect"
            {
                tree_disconnect_ = new SMB1_tree_disconnect(header(), is_orig());
                tree_disconnect_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 3;
            }
            break;
        case ((uint8)116):
            // Parse "logoff_andx"
            {
                logoff_andx_ = new SMB1_logoff_andx(header(), offset(), is_orig());
                int t_logoff_andx__size;
                t_logoff_andx__size = logoff_andx_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_logoff_andx__size;
            }
            break;
        default:
            // Parse "unknown_msg"
            {
                int t_unknown_msg_string_length;
                t_unknown_msg_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_unknown_msg__size;
                t_unknown_msg__size = t_unknown_msg_string_length;
                // check for negative sizes
                if ( t_unknown_msg_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb1-protocol.pac:294", t_unknown_msg_string_length);
                unknown_msg_.init(t_begin_of_data, t_unknown_msg_string_length);
                t_val__size = t_unknown_msg__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB_Header::SMB_Header(bool is_orig) {
    command_ = 0;
    status_ = 0;
    flags_ = 0;
    flags2_ = 0;
    pid_high_ = 0;
    security_features_ = nullptr;
    security_features__elem_ = 0;
    reserved_ = 0;
    tid_ = 0;
    pid_low_ = 0;
    uid_ = 0;
    mid_ = 0;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
    err_status_type_ = 0;
    unicode_ = 0;
    pid_ = 0;
    is_pipe_ = false;
    proc_ = false;
}

SMB_Header::~SMB_Header() {
    delete security_features_;
}

int SMB_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB_Header"
    if ( t_begin_of_data + (28) > t_end_of_data || t_begin_of_data + (28) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB_Header",
        	(0) + (28), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "command"
    command_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));

    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Parse "flags2"
    flags2_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "pid_high"
    pid_high_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "security_features"
    int t_security_features__arraylength;
    t_security_features__arraylength = 8;
    if ( t_security_features__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SMB_Header:security_features",
          t_security_features__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SMB_Header:security_features
    if ( t_security_features__arraylength > ((t_end_of_data - (t_begin_of_data + 10)) / 1) )
        throw binpac::ExceptionOutOfBound("SMB_Header:security_features",
          t_security_features__arraylength, (t_end_of_data) - ((t_begin_of_data + 10)));
    security_features__elem_ = 0;
    int t_security_features__elem__it;
    t_security_features__elem__it = 0;
    security_features_ = new vector<uint8>;
    security_features_->reserve(t_security_features__arraylength);
    const_byteptr t_security_features__elem__dataptr = (t_begin_of_data + 10);
    for (; t_security_features__elem__it < t_security_features__arraylength; ++t_security_features__elem__it) {
        security_features__elem_ = *(reinterpret_cast<uint8 const*>(t_security_features__elem__dataptr));
        security_features_->push_back(security_features__elem_);
        t_security_features__elem__dataptr += 1;
        BINPAC_ASSERT(t_security_features__elem__dataptr <= t_end_of_data);
    }
end_of_security_features: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "reserved"
    reserved_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 18))));

    // Parse "tid"
    tid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 20))));

    // Parse "pid_low"
    pid_low_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 22))));

    // Parse "uid"
    uid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 24))));

    // Parse "mid"
    mid_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 26))));

    // Evaluate 'let' and 'withinput' fields
    err_status_type_ =  ( flags2() >> 14 )  & 1;
    unicode_ =  ( flags2() >> 15 )  & 1;
    pid_ = t_context->connection()->join_pid_bits(pid_high(), pid_low());
    is_pipe_ = t_context->connection()->get_tree_is_pipe(tid());
    proc_ = t_context->connection()->proc_smb_message(this, is_orig());
    BINPAC_ASSERT(t_begin_of_data + (28) <= t_end_of_data);
    return 28;
}

int const SMB_Header_length = 32;

zeek::RecordValPtr BuildSMB2HeaderVal(SMB2_Header* hdr)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::Header);
	r->Assign(0, hdr->credit_charge());
	r->Assign(1, hdr->status());
	r->Assign(2, hdr->command());
	r->Assign(3, hdr->credits());
	r->Assign(4, hdr->flags());
	r->Assign(5, hdr->message_id());
	r->Assign(6, hdr->process_id());
	r->Assign(7, hdr->tree_id());
	r->Assign(8, hdr->session_id());
	r->Assign(9, to_stringval(hdr->signature()));
	return r;
	}

zeek::RecordValPtr BuildSMB2GUID(SMB2_guid* file_id)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::GUID);
	r->Assign(0, file_id->persistent());
	r->Assign(1, file_id->_volatile());
	return r;
	}

zeek::RecordValPtr smb2_file_attrs_to_zeek(SMB2_file_attributes* val)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::FileAttrs);
	r->Assign(0, val->read_only());
	r->Assign(1, val->hidden());
	r->Assign(2, val->system());
	r->Assign(3, val->directory());
	r->Assign(4, val->archive());
	r->Assign(5, val->normal());
	r->Assign(6, val->temporary());
	r->Assign(7, val->sparse_file());
	r->Assign(8, val->reparse_point());
	r->Assign(9, val->compressed());
	r->Assign(10, val->offline());
	r->Assign(11, val->not_content_indexed());
	r->Assign(12, val->encrypted());
	r->Assign(13, val->integrity_stream());
	r->Assign(14, val->no_scrub_data());
	return r;
	}

zeek::RecordValPtr BuildSMB2ContextVal(SMB3_negotiate_context_value* ncv)
	{
	auto r = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::NegotiateContextValue);

	r->Assign(0, ncv->context_type());
	r->Assign(1, ncv->data_length());

	switch ( ncv->context_type() ) {
	case SMB2_PREAUTH_INTEGRITY_CAPABILITIES:
		{
		auto rpreauth = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::PreAuthIntegrityCapabilities);
		rpreauth->Assign(0, ncv->preauth_integrity_capabilities()->hash_alg_count());
		rpreauth->Assign(1, ncv->preauth_integrity_capabilities()->salt_length());

		auto ha = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		for ( int i = 0; i < ncv->preauth_integrity_capabilities()->hash_alg_count(); ++i )
			{
			const auto& vec = *ncv->preauth_integrity_capabilities()->hash_alg();
			ha->Assign(i, zeek::val_mgr->Count(vec[i]));
			}

		rpreauth->Assign(2, std::move(ha));
		rpreauth->Assign(3, to_stringval(ncv->preauth_integrity_capabilities()->salt()));
		r->Assign(2, std::move(rpreauth));
		}
		break;

	case SMB2_ENCRYPTION_CAPABILITIES:
		{
		auto rencr = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::EncryptionCapabilities);
		rencr->Assign(0, ncv->encryption_capabilities()->cipher_count());

		auto c = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		for ( int i = 0; i < ncv->encryption_capabilities()->cipher_count(); ++i )
			{
			const auto& vec = *ncv->encryption_capabilities()->ciphers();
			c->Assign(i, zeek::val_mgr->Count(vec[i]));
			}

		rencr->Assign(1, std::move(c));
		r->Assign(3, std::move(rencr));
		}
		break;

	case SMB2_COMPRESSION_CAPABILITIES:
		{
		auto rcomp = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SMB2::CompressionCapabilities);
		rcomp->Assign(0, ncv->compression_capabilities()->alg_count());

		auto c = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		for ( int i = 0; i < ncv->compression_capabilities()->alg_count(); ++i )
			{
			const auto& vec = *ncv->compression_capabilities()->algs();
			c->Assign(i, zeek::val_mgr->Count(vec[i]));
			}

		rcomp->Assign(1, std::move(c));
		r->Assign(4, std::move(rcomp));
		}
		break;

	case SMB2_NETNAME_NEGOTIATE_CONTEXT_ID:
		{
		r->Assign(5, to_stringval(ncv->netname_negotiate_context_id()->net_name()));
		}
		break;

	default:
		break;
	}

	return r;
	}

SMB2_PDU::SMB2_PDU(bool is_orig) {
    header_ = nullptr;
    message_case_index_ = -1;
    err_ = nullptr;
    msg_ = nullptr;
    pad_case_index_ = -1;
    is_orig_ = is_orig;
    end_of_chain_ = false;
}

SMB2_PDU::~SMB2_PDU() {
    delete header_;
    header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( message_case_index() ) {
        case true:
            // Clean up "err"
            {
                delete err_;
                err_ = nullptr;
            }
            break;
        case false:
            // Clean up "msg"
            {
                delete msg_;
                msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pad_case_index() ) {
        case ((uint32)0):
            // Clean up "none"
            {
            }
            break;
        default:
            // Clean up "chain_pad"
            {
                chain_pad_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_PDU::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Parse "header"
    header_ = new SMB2_Header(is_orig());
    int t_header__size;
    t_header__size = header_->Parse(t_begin_of_data, t_end_of_data, t_context);

    const_byteptr const t_dataptr_after_header = t_begin_of_data + (t_header__size);
    BINPAC_ASSERT(t_dataptr_after_header <= t_end_of_data);
    // Parse "message"
    int t_message__size;
    message_case_index_ = t_context->connection()->is_error_response(header(), is_orig());
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( message_case_index() ) {
        case true:
            // Parse "err"
            {
                err_ = new SMB2_error_response(header());
                int t_err__size;
                t_err__size = err_->Parse(t_dataptr_after_header, t_end_of_data, t_context);
                t_message__size = t_err__size;
            }
            break;
        case false:
            // Parse "msg"
            {
                msg_ = new SMB2_Message(header(), is_orig());
                int t_msg__size;
                t_msg__size = msg_->Parse(t_dataptr_after_header, t_end_of_data, t_context);
                t_message__size = t_msg__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB2_PDU", (int64)message_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_message = t_dataptr_after_header + (t_message__size);
    BINPAC_ASSERT(t_dataptr_after_message <= t_end_of_data);
    // Parse "pad"
    int t_pad__size;
    pad_case_index_ = header()->next_command();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( pad_case_index() ) {
        case ((uint32)0):
            // Parse "none"
            {
                t_pad__size = 0;
            }
            break;
        default:
            // Parse "chain_pad"
            {
                int t_chain_pad__size;
                t_chain_pad__size = header()->next_command() - header()->head_length() - (t_dataptr_after_message - t_dataptr_after_header);
                // Checking out-of-bound for "SMB2_PDU:chain_pad"
                if ( t_dataptr_after_message + (t_chain_pad__size) > t_end_of_data || t_dataptr_after_message + (t_chain_pad__size) < t_dataptr_after_message ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SMB2_PDU:chain_pad",
                    	((t_dataptr_after_message - t_begin_of_data)) + (t_chain_pad__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_message + t_chain_pad__size;
                    int t_chain_pad_string_length;
                    t_chain_pad_string_length = header()->next_command() - header()->head_length() - (t_dataptr_after_message - t_dataptr_after_header);
                    // check for negative sizes
                    if ( t_chain_pad_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:171", t_chain_pad_string_length);
                    chain_pad_.init(t_dataptr_after_message, t_chain_pad_string_length);
                }
                t_pad__size = t_chain_pad__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SMB2_PDU__size;
    const_byteptr const t_dataptr_after_pad = t_dataptr_after_message + (t_pad__size);
    BINPAC_ASSERT(t_dataptr_after_pad <= t_end_of_data);
    t_SMB2_PDU__size = t_dataptr_after_pad - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    end_of_chain_ = header()->next_command() == 0;
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_PDU__size) <= t_end_of_data);
    return t_SMB2_PDU__size;
}

SMB2_Message::SMB2_Message(SMB2_Header* header, bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    response_ = nullptr;
    header_ = header;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
}

SMB2_Message::~SMB2_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "response"
            {
                delete response_;
                response_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                request_ = new SMB2_Message_Request(header());
                int t_request__size;
                t_request__size = request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_request__size;
            }
            break;
        case false:
            // Parse "response"
            {
                response_ = new SMB2_Message_Response(header());
                int t_response__size;
                t_response__size = response_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_response__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SMB2_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_Message_Request::SMB2_Message_Request(SMB2_Header* header) {
    val_case_index_ = -1;
    negotiate_protocol_ = nullptr;
    session_setup_ = nullptr;
    tree_connect_ = nullptr;
    tree_disconnect_ = nullptr;
    create_ = nullptr;
    close_ = nullptr;
    flush_ = nullptr;
    read_ = nullptr;
    write_ = nullptr;
    lock_ = nullptr;
    ioctl_ = nullptr;
    cancel_ = nullptr;
    echo_ = nullptr;
    query_directory_ = nullptr;
    change_notify_ = nullptr;
    query_info_ = nullptr;
    set_info_ = nullptr;
    oplock_break_ = nullptr;
    header_ = header;
    byteorder_ = littleendian;
}

SMB2_Message_Request::~SMB2_Message_Request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Clean up "negotiate_protocol"
            {
                delete negotiate_protocol_;
                negotiate_protocol_ = nullptr;
            }
            break;
        case ((uint16)1):
            // Clean up "session_setup"
            {
                delete session_setup_;
                session_setup_ = nullptr;
            }
            break;
        case ((uint16)3):
            // Clean up "tree_connect"
            {
                delete tree_connect_;
                tree_connect_ = nullptr;
            }
            break;
        case ((uint16)4):
            // Clean up "tree_disconnect"
            {
                delete tree_disconnect_;
                tree_disconnect_ = nullptr;
            }
            break;
        case ((uint16)5):
            // Clean up "create"
            {
                delete create_;
                create_ = nullptr;
            }
            break;
        case ((uint16)6):
            // Clean up "close"
            {
                delete close_;
                close_ = nullptr;
            }
            break;
        case ((uint16)7):
            // Clean up "flush"
            {
                delete flush_;
                flush_ = nullptr;
            }
            break;
        case ((uint16)8):
            // Clean up "read"
            {
                delete read_;
                read_ = nullptr;
            }
            break;
        case ((uint16)9):
            // Clean up "write"
            {
                delete write_;
                write_ = nullptr;
            }
            break;
        case ((uint16)10):
            // Clean up "lock"
            {
                delete lock_;
                lock_ = nullptr;
            }
            break;
        case ((uint16)11):
            // Clean up "ioctl"
            {
                delete ioctl_;
                ioctl_ = nullptr;
            }
            break;
        case ((uint16)12):
            // Clean up "cancel"
            {
                delete cancel_;
                cancel_ = nullptr;
            }
            break;
        case ((uint16)13):
            // Clean up "echo"
            {
                delete echo_;
                echo_ = nullptr;
            }
            break;
        case ((uint16)14):
            // Clean up "query_directory"
            {
                delete query_directory_;
                query_directory_ = nullptr;
            }
            break;
        case ((uint16)15):
            // Clean up "change_notify"
            {
                delete change_notify_;
                change_notify_ = nullptr;
            }
            break;
        case ((uint16)16):
            // Clean up "query_info"
            {
                delete query_info_;
                query_info_ = nullptr;
            }
            break;
        case ((uint16)17):
            // Clean up "set_info"
            {
                delete set_info_;
                set_info_ = nullptr;
            }
            break;
        case ((uint16)18):
            // Clean up "oplock_break"
            {
                delete oplock_break_;
                oplock_break_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_msg"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_Message_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = header()->command();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Parse "negotiate_protocol"
            {
                negotiate_protocol_ = new SMB2_negotiate_request(header());
                int t_negotiate_protocol__size;
                t_negotiate_protocol__size = negotiate_protocol_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_negotiate_protocol__size;
            }
            break;
        case ((uint16)1):
            // Parse "session_setup"
            {
                session_setup_ = new SMB2_session_setup_request(header());
                int t_session_setup__size;
                t_session_setup__size = session_setup_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_session_setup__size;
            }
            break;
        case ((uint16)3):
            // Parse "tree_connect"
            {
                tree_connect_ = new SMB2_tree_connect_request(header());
                int t_tree_connect__size;
                t_tree_connect__size = tree_connect_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_tree_connect__size;
            }
            break;
        case ((uint16)4):
            // Parse "tree_disconnect"
            {
                tree_disconnect_ = new SMB2_tree_disconnect_request(header());
                tree_disconnect_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)5):
            // Parse "create"
            {
                create_ = new SMB2_create_request(header());
                int t_create__size;
                t_create__size = create_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_create__size;
            }
            break;
        case ((uint16)6):
            // Parse "close"
            {
                close_ = new SMB2_close_request(header());
                close_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 24;
            }
            break;
        case ((uint16)7):
            // Parse "flush"
            {
                flush_ = new SMB2_flush_request(header());
                flush_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 24;
            }
            break;
        case ((uint16)8):
            // Parse "read"
            {
                read_ = new SMB2_read_request(header());
                int t_read__size;
                t_read__size = read_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_read__size;
            }
            break;
        case ((uint16)9):
            // Parse "write"
            {
                write_ = new SMB2_write_request(header());
                int t_write__size;
                t_write__size = write_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_write__size;
            }
            break;
        case ((uint16)10):
            // Parse "lock"
            {
                lock_ = new SMB2_lock_request(header());
                int t_lock__size;
                t_lock__size = lock_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_lock__size;
            }
            break;
        case ((uint16)11):
            // Parse "ioctl"
            {
                ioctl_ = new SMB2_ioctl_request(header());
                int t_ioctl__size;
                t_ioctl__size = ioctl_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_ioctl__size;
            }
            break;
        case ((uint16)12):
            // Parse "cancel"
            {
                cancel_ = new SMB2_cancel_request(header());
                cancel_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)13):
            // Parse "echo"
            {
                echo_ = new SMB2_echo_request(header());
                echo_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)14):
            // Parse "query_directory"
            {
                query_directory_ = new SMB2_query_directory_request(header());
                int t_query_directory__size;
                t_query_directory__size = query_directory_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_query_directory__size;
            }
            break;
        case ((uint16)15):
            // Parse "change_notify"
            {
                change_notify_ = new SMB2_change_notify_request(header());
                change_notify_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 32;
            }
            break;
        case ((uint16)16):
            // Parse "query_info"
            {
                query_info_ = new SMB2_query_info_request(header());
                int t_query_info__size;
                t_query_info__size = query_info_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_query_info__size;
            }
            break;
        case ((uint16)17):
            // Parse "set_info"
            {
                set_info_ = new SMB2_set_info_request(header());
                int t_set_info__size;
                t_set_info__size = set_info_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_set_info__size;
            }
            break;
        case ((uint16)18):
            // Parse "oplock_break"
            {
                oplock_break_ = new SMB2_oplock_break(header());
                oplock_break_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 24;
            }
            break;
        default:
            // Parse "unknown_msg"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_Message_Response::SMB2_Message_Response(SMB2_Header* header) {
    val_case_index_ = -1;
    negotiate_protocol_ = nullptr;
    session_setup_ = nullptr;
    tree_connect_ = nullptr;
    tree_disconnect_ = nullptr;
    create_ = nullptr;
    close_ = nullptr;
    flush_ = nullptr;
    read_ = nullptr;
    write_ = nullptr;
    lock_ = nullptr;
    ioctl_ = nullptr;
    echo_ = nullptr;
    query_directory_ = nullptr;
    change_notify_ = nullptr;
    query_info_ = nullptr;
    set_info_ = nullptr;
    oplock_break_ = nullptr;
    header_ = header;
    byteorder_ = littleendian;
}

SMB2_Message_Response::~SMB2_Message_Response() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Clean up "negotiate_protocol"
            {
                delete negotiate_protocol_;
                negotiate_protocol_ = nullptr;
            }
            break;
        case ((uint16)1):
            // Clean up "session_setup"
            {
                delete session_setup_;
                session_setup_ = nullptr;
            }
            break;
        case ((uint16)3):
            // Clean up "tree_connect"
            {
                delete tree_connect_;
                tree_connect_ = nullptr;
            }
            break;
        case ((uint16)4):
            // Clean up "tree_disconnect"
            {
                delete tree_disconnect_;
                tree_disconnect_ = nullptr;
            }
            break;
        case ((uint16)5):
            // Clean up "create"
            {
                delete create_;
                create_ = nullptr;
            }
            break;
        case ((uint16)6):
            // Clean up "close"
            {
                delete close_;
                close_ = nullptr;
            }
            break;
        case ((uint16)7):
            // Clean up "flush"
            {
                delete flush_;
                flush_ = nullptr;
            }
            break;
        case ((uint16)8):
            // Clean up "read"
            {
                delete read_;
                read_ = nullptr;
            }
            break;
        case ((uint16)9):
            // Clean up "write"
            {
                delete write_;
                write_ = nullptr;
            }
            break;
        case ((uint16)10):
            // Clean up "lock"
            {
                delete lock_;
                lock_ = nullptr;
            }
            break;
        case ((uint16)11):
            // Clean up "ioctl"
            {
                delete ioctl_;
                ioctl_ = nullptr;
            }
            break;
        case ((uint16)13):
            // Clean up "echo"
            {
                delete echo_;
                echo_ = nullptr;
            }
            break;
        case ((uint16)14):
            // Clean up "query_directory"
            {
                delete query_directory_;
                query_directory_ = nullptr;
            }
            break;
        case ((uint16)15):
            // Clean up "change_notify"
            {
                delete change_notify_;
                change_notify_ = nullptr;
            }
            break;
        case ((uint16)16):
            // Clean up "query_info"
            {
                delete query_info_;
                query_info_ = nullptr;
            }
            break;
        case ((uint16)17):
            // Clean up "set_info"
            {
                delete set_info_;
                set_info_ = nullptr;
            }
            break;
        case ((uint16)18):
            // Clean up "oplock_break"
            {
                delete oplock_break_;
                oplock_break_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_msg"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_Message_Response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = header()->command();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)0):
            // Parse "negotiate_protocol"
            {
                negotiate_protocol_ = new SMB2_negotiate_response(header());
                int t_negotiate_protocol__size;
                t_negotiate_protocol__size = negotiate_protocol_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_negotiate_protocol__size;
            }
            break;
        case ((uint16)1):
            // Parse "session_setup"
            {
                session_setup_ = new SMB2_session_setup_response(header());
                int t_session_setup__size;
                t_session_setup__size = session_setup_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_session_setup__size;
            }
            break;
        case ((uint16)3):
            // Parse "tree_connect"
            {
                tree_connect_ = new SMB2_tree_connect_response(header());
                tree_connect_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 16;
            }
            break;
        case ((uint16)4):
            // Parse "tree_disconnect"
            {
                tree_disconnect_ = new SMB2_tree_disconnect_response(header());
                tree_disconnect_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)5):
            // Parse "create"
            {
                create_ = new SMB2_create_response(header());
                int t_create__size;
                t_create__size = create_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_create__size;
            }
            break;
        case ((uint16)6):
            // Parse "close"
            {
                close_ = new SMB2_close_response(header());
                close_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 60;
            }
            break;
        case ((uint16)7):
            // Parse "flush"
            {
                flush_ = new SMB2_flush_response(header());
                flush_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)8):
            // Parse "read"
            {
                read_ = new SMB2_read_response(header());
                int t_read__size;
                t_read__size = read_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_read__size;
            }
            break;
        case ((uint16)9):
            // Parse "write"
            {
                write_ = new SMB2_write_response(header());
                write_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 16;
            }
            break;
        case ((uint16)10):
            // Parse "lock"
            {
                lock_ = new SMB2_lock_response(header());
                lock_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)11):
            // Parse "ioctl"
            {
                ioctl_ = new SMB2_ioctl_response(header());
                int t_ioctl__size;
                t_ioctl__size = ioctl_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_ioctl__size;
            }
            break;
        case ((uint16)13):
            // Parse "echo"
            {
                echo_ = new SMB2_echo_response(header());
                echo_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 4;
            }
            break;
        case ((uint16)14):
            // Parse "query_directory"
            {
                query_directory_ = new SMB2_query_directory_response(header());
                int t_query_directory__size;
                t_query_directory__size = query_directory_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_query_directory__size;
            }
            break;
        case ((uint16)15):
            // Parse "change_notify"
            {
                change_notify_ = new SMB2_change_notify_response(header());
                int t_change_notify__size;
                t_change_notify__size = change_notify_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_change_notify__size;
            }
            break;
        case ((uint16)16):
            // Parse "query_info"
            {
                query_info_ = new SMB2_query_info_response(header());
                int t_query_info__size;
                t_query_info__size = query_info_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = t_query_info__size;
            }
            break;
        case ((uint16)17):
            // Parse "set_info"
            {
                set_info_ = new SMB2_set_info_response(header());
                set_info_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 2;
            }
            break;
        case ((uint16)18):
            // Parse "oplock_break"
            {
                oplock_break_ = new SMB2_oplock_break(header());
                oplock_break_->Parse(t_begin_of_data, t_end_of_data, t_context, byteorder());
                t_val__size = 24;
            }
            break;
        default:
            // Parse "unknown_msg"
            {
                t_val__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_file_attributes::SMB2_file_attributes() {
    flags_ = 0;
    read_only_ = false;
    hidden_ = false;
    system_ = false;
    directory_ = false;
    archive_ = false;
    normal_ = false;
    temporary_ = false;
    sparse_file_ = false;
    reparse_point_ = false;
    compressed_ = false;
    offline_ = false;
    not_content_indexed_ = false;
    encrypted_ = false;
    integrity_stream_ = false;
    no_scrub_data_ = false;
}

SMB2_file_attributes::~SMB2_file_attributes() {
}

int SMB2_file_attributes::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB2_file_attributes"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_file_attributes",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    read_only_ =  ( flags() & 0x00000001 )  > 0;
    hidden_ =  ( flags() & 0x00000002 )  > 0;
    system_ =  ( flags() & 0x00000004 )  > 0;
    directory_ =  ( flags() & 0x00000010 )  > 0;
    archive_ =  ( flags() & 0x00000020 )  > 0;
    normal_ =  ( flags() & 0x00000080 )  > 0;
    temporary_ =  ( flags() & 0x00000100 )  > 0;
    sparse_file_ =  ( flags() & 0x00000200 )  > 0;
    reparse_point_ =  ( flags() & 0x00000400 )  > 0;
    compressed_ =  ( flags() & 0x00000800 )  > 0;
    offline_ =  ( flags() & 0x00001000 )  > 0;
    not_content_indexed_ =  ( flags() & 0x00002000 )  > 0;
    encrypted_ =  ( flags() & 0x00004000 )  > 0;
    integrity_stream_ =  ( flags() & 0x00008000 )  > 0;
    no_scrub_data_ =  ( flags() & 0x00020000 )  > 0;
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_Header::SMB2_Header(bool is_orig) {
    head_length_ = 0;
    credit_charge_ = 0;
    status_ = 0;
    command_ = 0;
    credits_ = 0;
    flags_ = 0;
    next_command_ = 0;
    message_id_ = 0;
    process_id_ = 0;
    tree_id_ = 0;
    session_id_ = 0;
    is_orig_ = is_orig;
    byteorder_ = littleendian;
    response_ = 0;
    async_ = 0;
    related_ = 0;
    msigned_ = 0;
    dfs_ = 0;
    request_tree_id_ = 0;
    is_pipe_ = false;
    proc_ = false;
}

SMB2_Header::~SMB2_Header() {
    signature_.free();
}

int SMB2_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB2_Header:session_id"
    if ( (t_begin_of_data + 36) + (8) > t_end_of_data || (t_begin_of_data + 36) + (8) < (t_begin_of_data + 36) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_Header:session_id",
        	(36) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "head_length"
    head_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "credit_charge"
    credit_charge_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "status"
    status_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "command"
    command_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "credits"
    credits_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "flags"
    flags_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "next_command"
    next_command_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "message_id"
    message_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 20))));

    // Parse "process_id"
    process_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));

    // Parse "tree_id"
    tree_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 32))));

    // Parse "session_id"
    session_id_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 36))));

    // Parse "signature"
    // Checking out-of-bound for "SMB2_Header:signature"
    if ( (t_begin_of_data + 44) + (16) > t_end_of_data || (t_begin_of_data + 44) + (16) < (t_begin_of_data + 44) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_Header:signature",
        	(44) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 44) + 16;
        int t_signature_string_length;
        t_signature_string_length = 16;
        int t_signature__size;
        t_signature__size = t_signature_string_length;
        signature_.init((t_begin_of_data + 44), t_signature_string_length);
    }

    int t_SMB2_Header__size;
    const_byteptr const t_dataptr_after_signature = (t_begin_of_data + 44) + (16);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    t_SMB2_Header__size = t_dataptr_after_signature - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    response_ =  ( flags() >> 24 )  & 1;
    async_ =  ( flags() >> 25 )  & 1;
    related_ =  ( flags() >> 26 )  & 1;
    msigned_ =  ( flags() >> 27 )  & 1;
    dfs_ =  ( flags() )  & 1;
    request_tree_id_ = t_context->connection()->get_request_tree_id(message_id());
    is_pipe_ = t_context->connection()->get_tree_is_pipe(is_orig() ? tree_id() : request_tree_id());
    proc_ = t_context->connection()->proc_smb2_message(this, is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_Header__size) <= t_end_of_data);
    return t_SMB2_Header__size;
}

SMB2_guid::SMB2_guid() {
    persistent_ = 0;
    _volatile_ = 0;
}

SMB2_guid::~SMB2_guid() {
}

int SMB2_guid::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB2_guid"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_guid",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "persistent"
    persistent_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_begin_of_data)));

    // Parse "_volatile"
    _volatile_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (16) <= t_end_of_data);
    return 16;
}

SMB2_File_Notify_Information::SMB2_File_Notify_Information() {
    next_entry_offset_ = 0;
    action_ = 0;
    filename_len_ = 0;
    filename_ = nullptr;
}

SMB2_File_Notify_Information::~SMB2_File_Notify_Information() {
    delete filename_;
    filename_ = nullptr;
}

int SMB2_File_Notify_Information::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SMB2_File_Notify_Information:filename_len"
    if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_File_Notify_Information:filename_len",
        	(8) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "next_entry_offset"
    next_entry_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "action"
    action_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "filename_len"
    filename_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "filename"
    filename_ = new SMB2_string(filename_len());
    int t_filename__size;
    t_filename__size = filename_->Parse((t_begin_of_data + 12), t_end_of_data);

    int t_SMB2_File_Notify_Information__size;
    const_byteptr const t_dataptr_after_filename = (t_begin_of_data + 12) + (t_filename__size);
    BINPAC_ASSERT(t_dataptr_after_filename <= t_end_of_data);
    t_SMB2_File_Notify_Information__size = t_dataptr_after_filename - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_File_Notify_Information__size) <= t_end_of_data);
    return t_SMB2_File_Notify_Information__size;
}

SMB2_symlink_error::SMB2_symlink_error(uint32 byte_count) {
    sym_link_length_ = 0;
    sym_link_err_tag_ = 0;
    reparse_tag_ = 0;
    reparse_data_len_ = 0;
    unparsed_path_len_ = 0;
    sub_name_offset_ = 0;
    sub_name_length_ = 0;
    print_name_offset_ = 0;
    print_name_length_ = 0;
    flags_ = 0;
    byte_count_ = byte_count;
    byteorder_ = littleendian;
    absolute_target_path_ = 0;
    symlink_flag_relative_ = 0;
}

SMB2_symlink_error::~SMB2_symlink_error() {
    path_buffer_.free();
}

int SMB2_symlink_error::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SMB2_symlink_error:flags"
    if ( (t_begin_of_data + 24) + (4) > t_end_of_data || (t_begin_of_data + 24) + (4) < (t_begin_of_data + 24) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_symlink_error:flags",
        	(24) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "sym_link_length"
    sym_link_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "sym_link_err_tag"
    sym_link_err_tag_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "reparse_tag"
    reparse_tag_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "reparse_data_len"
    reparse_data_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 12))));

    // Parse "unparsed_path_len"
    unparsed_path_len_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 14))));

    // Parse "sub_name_offset"
    sub_name_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 16))));

    // Parse "sub_name_length"
    sub_name_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 18))));

    // Parse "print_name_offset"
    print_name_offset_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 20))));

    // Parse "print_name_length"
    print_name_length_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 22))));

    // Parse "flags"
    flags_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));

    // Parse "path_buffer"
    int t_path_buffer__size;
    t_path_buffer__size = sub_name_length() + print_name_length();
    // Checking out-of-bound for "SMB2_symlink_error:path_buffer"
    if ( (t_begin_of_data + 28) + (t_path_buffer__size) > t_end_of_data || (t_begin_of_data + 28) + (t_path_buffer__size) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_symlink_error:path_buffer",
        	(28) + (t_path_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 28) + t_path_buffer__size;
        int t_path_buffer_string_length;
        t_path_buffer_string_length = sub_name_length() + print_name_length();
        // check for negative sizes
        if ( t_path_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:399", t_path_buffer_string_length);
        path_buffer_.init((t_begin_of_data + 28), t_path_buffer_string_length);
    }

    int t_SMB2_symlink_error__size;
    const_byteptr const t_dataptr_after_path_buffer = (t_begin_of_data + 28) + (t_path_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_path_buffer <= t_end_of_data);
    t_SMB2_symlink_error__size = t_dataptr_after_path_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    absolute_target_path_ =  ( flags() == 0x00000000 ) ;
    symlink_flag_relative_ =  ( flags() == 0x00000001 ) ;
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_symlink_error__size) <= t_end_of_data);
    return t_SMB2_symlink_error__size;
}

SMB2_error_data::SMB2_error_data(SMB2_Header* header, uint32 byte_count) {
    val_case_index_ = -1;
    error_ = nullptr;
    header_ = header;
    byte_count_ = byte_count;
    byteorder_ = littleendian;
}

SMB2_error_data::~SMB2_error_data() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint32)0):
            // Clean up "empty"
            {
            }
            break;
        default:
            // Clean up "error"
            {
                delete error_;
                error_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SMB2_error_data::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    int t_val__size;
    val_case_index_ = byte_count();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint32)0):
            // Parse "empty"
            {
                t_val__size = 0;
            }
            break;
        default:
            // Parse "error"
            {
                error_ = new SMB2_symlink_error(byte_count());
                int t_error__size;
                t_error__size = error_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_error__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SMB2_error_response::SMB2_error_response(SMB2_Header* header) {
    structure_size_ = 0;
    byte_count_ = 0;
    header_ = header;
    byteorder_ = littleendian;
}

SMB2_error_response::~SMB2_error_response() {
}

int SMB2_error_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context) {
    // Checking out-of-bound for "SMB2_error_response:byte_count"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_error_response:byte_count",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_begin_of_data)));


    // Parse "byte_count"
    byte_count_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "stuff"
    int t_stuff__size;
    t_stuff__size = byte_count();
    // Checking out-of-bound for "SMB2_error_response:stuff"
    if ( (t_begin_of_data + 8) + (t_stuff__size) > t_end_of_data || (t_begin_of_data + 8) + (t_stuff__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_error_response:stuff",
        	(8) + (t_stuff__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_stuff__size;
        int t_stuff_string_length;
        t_stuff_string_length = byte_count();
        // check for negative sizes
        if ( t_stuff_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:416", t_stuff_string_length);
        stuff_.init((t_begin_of_data + 8), t_stuff_string_length);
    }

    int t_SMB2_error_response__size;
    const_byteptr const t_dataptr_after_stuff = (t_begin_of_data + 8) + (t_stuff__size);
    BINPAC_ASSERT(t_dataptr_after_stuff <= t_end_of_data);
    t_SMB2_error_response__size = t_dataptr_after_stuff - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_error_response__size) <= t_end_of_data);
    return t_SMB2_error_response__size;
}

SMB2_logoff_request::SMB2_logoff_request(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_logoff_request::~SMB2_logoff_request() {
}

int SMB2_logoff_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_logoff_request"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_logoff_request",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_logoff_response::SMB2_logoff_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_logoff_response::~SMB2_logoff_response() {
}

int SMB2_logoff_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_logoff_response"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_logoff_response",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_flush_request::SMB2_flush_request(SMB2_Header* header) {
    structure_size_ = 0;
    reserved1_ = 0;
    reserved2_ = 0;
    file_id_ = nullptr;
    header_ = header;
}

SMB2_flush_request::~SMB2_flush_request() {
    delete file_id_;
    file_id_ = nullptr;
}

int SMB2_flush_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_flush_request"
    if ( t_begin_of_data + (24) > t_end_of_data || t_begin_of_data + (24) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_flush_request",
        	(0) + (24), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved1"
    reserved1_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (24) <= t_end_of_data);
    return 24;
}

SMB2_flush_response::SMB2_flush_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved1_ = 0;
    header_ = header;
}

SMB2_flush_response::~SMB2_flush_response() {
}

int SMB2_flush_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_flush_response"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_flush_response",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved1"
    reserved1_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_cancel_request::SMB2_cancel_request(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_cancel_request::~SMB2_cancel_request() {
}

int SMB2_cancel_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_cancel_request"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_cancel_request",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_echo_request::SMB2_echo_request(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_echo_request::~SMB2_echo_request() {
}

int SMB2_echo_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_echo_request"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_echo_request",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_echo_response::SMB2_echo_response(SMB2_Header* header) {
    structure_size_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_echo_response::~SMB2_echo_response() {
}

int SMB2_echo_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_echo_response"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_echo_response",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SMB2_query_directory_request::SMB2_query_directory_request(SMB2_Header* header) {
    structure_size_ = 0;
    _class_ = 0;
    flags_ = 0;
    file_index_ = 0;
    file_id_ = nullptr;
    file_name_offset_ = 0;
    file_name_len_ = 0;
    output_buffer_len_ = 0;
    header_ = header;
}

SMB2_query_directory_request::~SMB2_query_directory_request() {
    delete file_id_;
    file_id_ = nullptr;
    file_name_.free();
}

int SMB2_query_directory_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_query_directory_request:output_buffer_len"
    if ( (t_begin_of_data + 28) + (4) > t_end_of_data || (t_begin_of_data + 28) + (4) < (t_begin_of_data + 28) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_directory_request:output_buffer_len",
        	(28) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "_class"
    _class_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "flags"
    flags_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "file_index"
    file_index_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "file_name_offset"
    file_name_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 24))));

    // Parse "file_name_len"
    file_name_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 26))));

    // Parse "output_buffer_len"
    output_buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (file_name_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 32) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:465:pad", (t_begin_of_data + 32) - t_begin_of_data, file_name_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 32);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_query_directory_request:pad",
        	(file_name_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "file_name"
    int t_file_name__size;
    t_file_name__size = file_name_len();
    // Checking out-of-bound for "SMB2_query_directory_request:file_name"
    if ( t_dataptr_after_pad + (t_file_name__size) > t_end_of_data || t_dataptr_after_pad + (t_file_name__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_directory_request:file_name",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_file_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_file_name__size;
        int t_file_name_string_length;
        t_file_name_string_length = file_name_len();
        // check for negative sizes
        if ( t_file_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:466", t_file_name_string_length);
        file_name_.init(t_dataptr_after_pad, t_file_name_string_length);
    }

    int t_SMB2_query_directory_request__size;
    const_byteptr const t_dataptr_after_file_name = t_dataptr_after_pad + (t_file_name__size);
    BINPAC_ASSERT(t_dataptr_after_file_name <= t_end_of_data);
    t_SMB2_query_directory_request__size = t_dataptr_after_file_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_query_directory_request__size) <= t_end_of_data);
    return t_SMB2_query_directory_request__size;
}

SMB2_query_directory_response::SMB2_query_directory_response(SMB2_Header* header) {
    structure_size_ = 0;
    buffer_offset_ = 0;
    buffer_len_ = 0;
    header_ = header;
}

SMB2_query_directory_response::~SMB2_query_directory_response() {
    buffer_.free();
}

int SMB2_query_directory_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_query_directory_response:buffer_len"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_directory_response:buffer_len",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "buffer_offset"
    buffer_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "buffer_len"
    buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (buffer_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 8) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:473:pad", (t_begin_of_data + 8) - t_begin_of_data, buffer_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 8);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_query_directory_response:pad",
        	(buffer_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "buffer"
    int t_buffer__size;
    t_buffer__size = buffer_len();
    // Checking out-of-bound for "SMB2_query_directory_response:buffer"
    if ( t_dataptr_after_pad + (t_buffer__size) > t_end_of_data || t_dataptr_after_pad + (t_buffer__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_directory_response:buffer",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_buffer__size;
        int t_buffer_string_length;
        t_buffer_string_length = buffer_len();
        // check for negative sizes
        if ( t_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:474", t_buffer_string_length);
        buffer_.init(t_dataptr_after_pad, t_buffer_string_length);
    }

    int t_SMB2_query_directory_response__size;
    const_byteptr const t_dataptr_after_buffer = t_dataptr_after_pad + (t_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_buffer <= t_end_of_data);
    t_SMB2_query_directory_response__size = t_dataptr_after_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_query_directory_response__size) <= t_end_of_data);
    return t_SMB2_query_directory_response__size;
}

SMB2_change_notify_request::SMB2_change_notify_request(SMB2_Header* header) {
    structure_size_ = 0;
    flags_ = 0;
    output_buffer_len_ = 0;
    file_id_ = nullptr;
    completion_filter_ = 0;
    reserved_ = 0;
    header_ = header;
}

SMB2_change_notify_request::~SMB2_change_notify_request() {
    delete file_id_;
    file_id_ = nullptr;
}

int SMB2_change_notify_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_change_notify_request"
    if ( t_begin_of_data + (32) > t_end_of_data || t_begin_of_data + (32) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_change_notify_request",
        	(0) + (32), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "output_buffer_len"
    output_buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Parse "completion_filter"
    completion_filter_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 28))));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (32) <= t_end_of_data);
    return 32;
}

SMB2_change_notify_response::SMB2_change_notify_response(SMB2_Header* header) {
    structure_size_ = 0;
    output_buffer_offset_ = 0;
    output_buffer_len_ = 0;
    buffer_ = nullptr;
    buffer__elem_ = nullptr;
    header_ = header;
}

SMB2_change_notify_response::~SMB2_change_notify_response() {
    delete buffer__elem_;
    buffer__elem_ = nullptr;
    if ( buffer() ) {
        for ( auto* buffer__elem_ : *buffer() ) {
            delete buffer__elem_;
            buffer__elem_ = nullptr;
        }
    }
    delete buffer_;
}

int SMB2_change_notify_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_change_notify_response:output_buffer_len"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_change_notify_response:output_buffer_len",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "output_buffer_offset"
    output_buffer_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "output_buffer_len"
    output_buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (output_buffer_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 8) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:490:pad", (t_begin_of_data + 8) - t_begin_of_data, output_buffer_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 8);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_change_notify_response:pad",
        	(output_buffer_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "buffer"
    int t_buffer__size;
    t_buffer__size = output_buffer_len();
    // Checking out-of-bound for "SMB2_change_notify_response:buffer"
    if ( t_dataptr_after_pad + (t_buffer__size) > t_end_of_data || t_dataptr_after_pad + (t_buffer__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_change_notify_response:buffer",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_buffer__size;
        int t_buffer__arraylength;
        t_buffer__arraylength = 0;
        buffer__elem_ = nullptr;
        int t_buffer__elem__it;
        t_buffer__elem__it = 0;
        buffer_ = new vector<SMB2_File_Notify_Information*>;
        const_byteptr t_buffer__elem__dataptr = t_dataptr_after_pad;
        for (; /* forever */; ++t_buffer__elem__it) {
            // Check &until(buffer__elem__dataptr >= end_of_data)
            if ( t_buffer__elem__dataptr >= t_end_of_data ) {
                buffer__elem_ = nullptr;
                goto end_of_buffer;
            }
            buffer__elem_ = new SMB2_File_Notify_Information();
            int t_buffer__elem__size;
            t_buffer__elem__size = buffer__elem_->Parse(t_buffer__elem__dataptr, t_end_of_data, t_byteorder);
            buffer_->push_back(buffer__elem_);
            t_buffer__elem__dataptr += t_buffer__elem__size;
            BINPAC_ASSERT(t_buffer__elem__dataptr <= t_end_of_data);
            buffer__elem_ = nullptr;
        }
    end_of_buffer: ;
        // Evaluate 'let' and 'withinput' fields
    }

    int t_SMB2_change_notify_response__size;
    const_byteptr const t_dataptr_after_buffer = t_dataptr_after_pad + (t_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_buffer <= t_end_of_data);
    t_SMB2_change_notify_response__size = t_dataptr_after_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_change_notify_response__size) <= t_end_of_data);
    return t_SMB2_change_notify_response__size;
}

SMB2_query_info_request::SMB2_query_info_request(SMB2_Header* header) {
    structure_size_ = 0;
    info_type_ = 0;
    file_info_class_ = 0;
    output_buffer_len_ = 0;
    input_buffer_offset_ = 0;
    reserved_ = 0;
    input_buffer_len_ = 0;
    additional_info_ = 0;
    flags_ = 0;
    file_id_ = nullptr;
    header_ = header;
}

SMB2_query_info_request::~SMB2_query_info_request() {
    delete file_id_;
    file_id_ = nullptr;
    buffer_.free();
}

int SMB2_query_info_request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_query_info_request:file_id"
    if ( (t_begin_of_data + 24) + (16) > t_end_of_data || (t_begin_of_data + 24) + (16) < (t_begin_of_data + 24) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_info_request:file_id",
        	(24) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "info_type"
    info_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "file_info_class"
    file_info_class_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "output_buffer_len"
    output_buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "input_buffer_offset"
    input_buffer_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 8))));

    // Parse "reserved"
    reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 10))));

    // Parse "input_buffer_len"
    input_buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "additional_info"
    additional_info_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "flags"
    flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 20))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 24), t_end_of_data, t_byteorder);


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (input_buffer_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 40) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:505:pad", (t_begin_of_data + 40) - t_begin_of_data, input_buffer_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 40);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_query_info_request:pad",
        	(input_buffer_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "buffer"
    int t_buffer__size;
    t_buffer__size = input_buffer_len();
    // Checking out-of-bound for "SMB2_query_info_request:buffer"
    if ( t_dataptr_after_pad + (t_buffer__size) > t_end_of_data || t_dataptr_after_pad + (t_buffer__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_info_request:buffer",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_buffer__size;
        int t_buffer_string_length;
        t_buffer_string_length = input_buffer_len();
        // check for negative sizes
        if ( t_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:506", t_buffer_string_length);
        buffer_.init(t_dataptr_after_pad, t_buffer_string_length);
    }

    int t_SMB2_query_info_request__size;
    const_byteptr const t_dataptr_after_buffer = t_dataptr_after_pad + (t_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_buffer <= t_end_of_data);
    t_SMB2_query_info_request__size = t_dataptr_after_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_query_info_request__size) <= t_end_of_data);
    return t_SMB2_query_info_request__size;
}

SMB2_query_info_response::SMB2_query_info_response(SMB2_Header* header) {
    structure_size_ = 0;
    buffer_offset_ = 0;
    buffer_len_ = 0;
    header_ = header;
}

SMB2_query_info_response::~SMB2_query_info_response() {
    buffer_.free();
}

int SMB2_query_info_response::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_query_info_response:buffer_len"
    if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_info_response:buffer_len",
        	(4) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "buffer_offset"
    buffer_offset_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "buffer_len"
    buffer_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));


    const_byteptr t_dataptr_after_pad = t_begin_of_data + (buffer_offset() - header()->head_length());
    if ( t_dataptr_after_pad < (t_begin_of_data + 8) ) {
        // throw binpac::ExceptionInvalidOffset("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:513:pad", (t_begin_of_data + 8) - t_begin_of_data, buffer_offset() - header()->head_length());
        t_dataptr_after_pad = (t_begin_of_data + 8);
    }
    if ( t_dataptr_after_pad > t_end_of_data ) {
        throw binpac::ExceptionOutOfBound("SMB2_query_info_response:pad",
        	(buffer_offset() - header()->head_length()), 
        	(t_end_of_data) - (t_dataptr_after_pad));
    }
    // Parse "buffer"
    int t_buffer__size;
    t_buffer__size = buffer_len();
    // Checking out-of-bound for "SMB2_query_info_response:buffer"
    if ( t_dataptr_after_pad + (t_buffer__size) > t_end_of_data || t_dataptr_after_pad + (t_buffer__size) < t_dataptr_after_pad ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_query_info_response:buffer",
        	((t_dataptr_after_pad - t_begin_of_data)) + (t_buffer__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_pad + t_buffer__size;
        int t_buffer_string_length;
        t_buffer_string_length = buffer_len();
        // check for negative sizes
        if ( t_buffer_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/smb/smb2-protocol.pac:515", t_buffer_string_length);
        buffer_.init(t_dataptr_after_pad, t_buffer_string_length);
    }

    int t_SMB2_query_info_response__size;
    const_byteptr const t_dataptr_after_buffer = t_dataptr_after_pad + (t_buffer__size);
    BINPAC_ASSERT(t_dataptr_after_buffer <= t_end_of_data);
    t_SMB2_query_info_response__size = t_dataptr_after_buffer - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SMB2_query_info_response__size) <= t_end_of_data);
    return t_SMB2_query_info_response__size;
}

SMB2_oplock_break::SMB2_oplock_break(SMB2_Header* header) {
    structure_size_ = 0;
    oplock_level_ = 0;
    reserved_ = 0;
    reserved2_ = 0;
    file_id_ = nullptr;
    header_ = header;
}

SMB2_oplock_break::~SMB2_oplock_break() {
    delete file_id_;
    file_id_ = nullptr;
}

int SMB2_oplock_break::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSMB* t_context, int t_byteorder) {
    // Checking out-of-bound for "SMB2_oplock_break"
    if ( t_begin_of_data + (24) > t_end_of_data || t_begin_of_data + (24) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SMB2_oplock_break",
        	(0) + (24), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "structure_size"
    structure_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "oplock_level"
    oplock_level_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "reserved2"
    reserved2_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "file_id"
    file_id_ = new SMB2_guid();
    file_id_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (24) <= t_end_of_data);
    return 24;
}

SMB_Flow::SMB_Flow(SMB_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

SMB_Flow::~SMB_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void SMB_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new SMB_TCP(is_orig());
                flow_buffer_->NewFrame(0, false);
                context_ = new ContextSMB(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            while ( ! t_dataunit_parsing_complete && flow_buffer_->ready() ) {
                const_byteptr t_begin_of_data = flow_buffer()->begin();
                const_byteptr t_end_of_data = flow_buffer()->end();
                t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
                if ( t_dataunit_parsing_complete ) {
                }
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void SMB_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void SMB_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
} // namespace SMB
}  // namespace binpac
