// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/socks/socks.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/socks/socks_pac.h"

namespace binpac {






namespace SOCKS {
ContextSOCKS::ContextSOCKS(SOCKS_Conn* connection, SOCKS_Flow* flow) {
    connection_ = connection;
    flow_ = flow;
}

ContextSOCKS::~ContextSOCKS() {
}

SOCKS_Conn::SOCKS_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new SOCKS_Flow(this, true);
    downflow_ = new SOCKS_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		v5_in_auth_sub_negotiation_ = false;
		v5_authenticated_ = false;
		selected_auth_method_ = 255;
	
}

SOCKS_Conn::~SOCKS_Conn() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SOCKS_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SOCKS_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SOCKS_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool SOCKS_Conn::v5_in_auth_sub_negotiation() {

		return v5_in_auth_sub_negotiation_;
		
}

bool SOCKS_Conn::set_v5_in_auth_sub_negotiation(bool b) {

		v5_in_auth_sub_negotiation_ = b;
		return true;
		
}

bool SOCKS_Conn::v5_past_authentication() {

		return v5_authenticated_;
		
}

bool SOCKS_Conn::set_v5_past_authentication() {

		v5_authenticated_ = true;
		return true;
		
}

bool SOCKS_Conn::set_v5_auth_method(uint8 method) {

		selected_auth_method_ = method;
		return true;
		
}

uint8 SOCKS_Conn::v5_auth_method() {

		return selected_auth_method_;
		
}

bool SOCKS_Conn::socks4_request(SOCKS4_Request* request) {

		if ( socks_request )
			{
			static auto socks_address = zeek::id::find_type<zeek::RecordType>("SOCKS::Address");
			auto sa = zeek::make_intrusive<zeek::RecordVal>(socks_address);
			sa->Assign(0, zeek::make_intrusive<zeek::AddrVal>(htonl(request->addr())));

			if ( request->v4a() )
				sa->Assign(1, array_to_string(request->name()));

			zeek::BifEvent::enqueue_socks_request(zeek_analyzer(),
			                                zeek_analyzer()->Conn(),
			                                4,
			                                request->command(),
			                                std::move(sa),
			                                zeek::val_mgr->Port(request->port(), TRANSPORT_TCP),
			                                array_to_string(request->user()));
			}

		static_cast<zeek::analyzer::socks::SOCKS_Analyzer*>(zeek_analyzer())->EndpointDone(true);

		return true;
		
}

bool SOCKS_Conn::socks4_reply(SOCKS4_Reply* reply) {

		if ( socks_reply )
			{
			static auto socks_address = zeek::id::find_type<zeek::RecordType>("SOCKS::Address");
			auto sa = zeek::make_intrusive<zeek::RecordVal>(socks_address);
			sa->Assign(0, zeek::make_intrusive<zeek::AddrVal>(htonl(reply->addr())));

			zeek::BifEvent::enqueue_socks_reply(zeek_analyzer(),
			                              zeek_analyzer()->Conn(),
			                              4,
			                              reply->status(),
			                              std::move(sa),
			                              zeek::val_mgr->Port(reply->port(), TRANSPORT_TCP));
			}

		zeek_analyzer()->AnalyzerConfirmation();
		static_cast<zeek::analyzer::socks::SOCKS_Analyzer*>(zeek_analyzer())->EndpointDone(false);
		return true;
		
}

bool SOCKS_Conn::socks5_request(SOCKS5_Request* request) {

		if ( request->reserved() != 0 )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid value in reserved field: %d", request->reserved()));
			zeek_analyzer()->SetSkip(true);
			return false;
			}

		if ( (request->command() == 0) || (request->command() > 3) )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("undefined value in command field: %d", request->command()));
			zeek_analyzer()->SetSkip(true);
			return false;
			}

		static auto socks_address = zeek::id::find_type<zeek::RecordType>("SOCKS::Address");
		auto sa = zeek::make_intrusive<zeek::RecordVal>(socks_address);

		// This is dumb and there must be a better way (checking for presence of a field)...
		switch ( request->remote_name()->addr_type() )
			{
			case 1:
				sa->Assign(0, zeek::make_intrusive<zeek::AddrVal>(htonl(request->remote_name()->ipv4())));
				break;

			case 3:
				sa->Assign(1, zeek::make_intrusive<zeek::StringVal>(request->remote_name()->domain_name()->name().length(),
				                         reinterpret_cast<const char*>(request->remote_name()->domain_name()->name().data())));
				break;

			case 4:
				sa->Assign(0, zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv6, reinterpret_cast<const uint32_t*>(request->remote_name()->ipv6()), zeek::IPAddr::Network)));
				break;

			default:
				zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid SOCKSv5 addr type: %d", request->remote_name()->addr_type()));
				return false;
			}

		if ( socks_request )
			zeek::BifEvent::enqueue_socks_request(zeek_analyzer(),
			                                zeek_analyzer()->Conn(),
			                                5,
			                                request->command(),
			                                std::move(sa),
			                                zeek::val_mgr->Port(request->port(), TRANSPORT_TCP),
			                                zeek::val_mgr->EmptyString());

		static_cast<zeek::analyzer::socks::SOCKS_Analyzer*>(zeek_analyzer())->EndpointDone(true);

		return true;
		
}

bool SOCKS_Conn::socks5_reply(SOCKS5_Reply* reply) {

		static auto socks_address = zeek::id::find_type<zeek::RecordType>("SOCKS::Address");
		auto sa = zeek::make_intrusive<zeek::RecordVal>(socks_address);

		// This is dumb and there must be a better way (checking for presence of a field)...
		switch ( reply->bound()->addr_type() )
			{
			case 1:
				sa->Assign(0, zeek::make_intrusive<zeek::AddrVal>(htonl(reply->bound()->ipv4())));
				break;

			case 3:
				sa->Assign(1, zeek::make_intrusive<zeek::StringVal>(reply->bound()->domain_name()->name().length(),
				                         reinterpret_cast<const char*>(reply->bound()->domain_name()->name().data())));
				break;

			case 4:
				sa->Assign(0, zeek::make_intrusive<zeek::AddrVal>(zeek::IPAddr(IPv6, reinterpret_cast<const uint32_t*>(reply->bound()->ipv6()), zeek::IPAddr::Network)));
				break;

			default:
				zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("invalid SOCKSv5 addr type: %d", reply->bound()->addr_type()));
				return false;
			}

		if ( socks_reply )
			zeek::BifEvent::enqueue_socks_reply(zeek_analyzer(),
			                              zeek_analyzer()->Conn(),
			                              5,
			                              reply->reply(),
			                              std::move(sa),
			                              zeek::val_mgr->Port(reply->port(), TRANSPORT_TCP));

		zeek_analyzer()->AnalyzerConfirmation();
		static_cast<zeek::analyzer::socks::SOCKS_Analyzer*>(zeek_analyzer())->EndpointDone(false);
		return true;
		
}

bool SOCKS_Conn::socks5_auth_request_userpass(SOCKS5_Auth_Request_UserPass_v1* request) {

		if ( ! socks_login_userpass_request )
			return true;

		auto user = zeek::make_intrusive<zeek::StringVal>(request->username().length(), reinterpret_cast<const char*>(request->username().begin()));
		auto pass = zeek::make_intrusive<zeek::StringVal>(request->password().length(), reinterpret_cast<const char*>(request->password().begin()));

		zeek::BifEvent::enqueue_socks_login_userpass_request(zeek_analyzer(),
		                                               zeek_analyzer()->Conn(),
		                                               std::move(user), std::move(pass));
		return true;
		
}

bool SOCKS_Conn::socks5_unsupported_authentication_method(uint8 auth_method) {

		zeek_analyzer()->Weird("socks5_unsupported_authentication_method", zeek::util::fmt("%d", auth_method));
		return true;
		
}

bool SOCKS_Conn::socks5_unsupported_authentication_version(uint8 auth_method, uint8 version) {

		zeek_analyzer()->Weird("socks5_unsupported_authentication", zeek::util::fmt("method %d, version %d", auth_method, version));
		return true;
		
}

bool SOCKS_Conn::socks5_auth_reply_userpass(SOCKS5_Auth_Reply_UserPass_v1* reply) {

		if ( socks_login_userpass_reply )
			zeek::BifEvent::enqueue_socks_login_userpass_reply(zeek_analyzer(),
			                                             zeek_analyzer()->Conn(),
			                                             reply->code());
		return true;
		
}

bool SOCKS_Conn::version_error(uint8 version) {

		zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unsupported/unknown SOCKS version %d", version));
		return true;
		
}

SOCKS_Message::SOCKS_Message(bool is_orig) {
    val_case_index_ = -1;
    auth_ = nullptr;
    msg_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS_Message::~SOCKS_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "auth"
            {
                delete auth_;
                auth_ = nullptr;
            }
            break;
        case false:
            // Clean up "msg"
            {
                delete msg_;
                msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = t_context->connection()->v5_in_auth_sub_negotiation();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "auth"
            {
                auth_ = new SOCKS5_Auth_Message(is_orig());
                int t_auth__size;
                t_auth__size = auth_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_auth__size;
            }
            break;
        case false:
            // Parse "msg"
            {
                msg_ = new SOCKS_Version(is_orig());
                int t_msg__size;
                t_msg__size = msg_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_msg__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS_Version::SOCKS_Version(bool is_orig) {
    version_ = 0;
    msg_case_index_ = -1;
    socks4_msg_ = nullptr;
    socks5_msg_ = nullptr;
    socks_msg_fail_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS_Version::~SOCKS_Version() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)4):
            // Clean up "socks4_msg"
            {
                delete socks4_msg_;
                socks4_msg_ = nullptr;
            }
            break;
        case ((uint8)5):
            // Clean up "socks5_msg"
            {
                delete socks5_msg_;
                socks5_msg_ = nullptr;
            }
            break;
        default:
            // Clean up "socks_msg_fail"
            {
                delete socks_msg_fail_;
                socks_msg_fail_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS_Version::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS_Version:version"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS_Version:version",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "msg"
    int t_msg__size;
    msg_case_index_ = version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)4):
            // Parse "socks4_msg"
            {
                socks4_msg_ = new SOCKS4_Message(is_orig());
                int t_socks4_msg__size;
                t_socks4_msg__size = socks4_msg_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_msg__size = t_socks4_msg__size;
            }
            break;
        case ((uint8)5):
            // Parse "socks5_msg"
            {
                socks5_msg_ = new SOCKS5_Message(is_orig());
                int t_socks5_msg__size;
                t_socks5_msg__size = socks5_msg_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_msg__size = t_socks5_msg__size;
            }
            break;
        default:
            // Parse "socks_msg_fail"
            {
                socks_msg_fail_ = new SOCKS_Version_Error(version());
                socks_msg_fail_->Parse(nullptr, nullptr, t_context);
                t_msg__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SOCKS_Version__size;
    const_byteptr const t_dataptr_after_msg = (t_begin_of_data + 1) + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_SOCKS_Version__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS_Version__size) <= t_end_of_data);
    return t_SOCKS_Version__size;
}

SOCKS_Version_Error::SOCKS_Version_Error(uint8 version) {
    version_ = version;
    proc_ = false;
}

SOCKS_Version_Error::~SOCKS_Version_Error() {
}

int SOCKS_Version_Error::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS_Version_Error"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS_Version_Error",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "nothing"

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->version_error(version());
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

SOCKS5_Message::SOCKS5_Message(bool is_orig) {
    val_case_index_ = -1;
    auth_ = nullptr;
    msg_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS5_Message::~SOCKS5_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case false:
            // Clean up "auth"
            {
                delete auth_;
                auth_ = nullptr;
            }
            break;
        case true:
            // Clean up "msg"
            {
                delete msg_;
                msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = t_context->connection()->v5_past_authentication();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case false:
            // Parse "auth"
            {
                auth_ = new SOCKS5_Auth_Negotiation(is_orig());
                int t_auth__size;
                t_auth__size = auth_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_auth__size;
            }
            break;
        case true:
            // Parse "msg"
            {
                msg_ = new SOCKS5_Real_Message(is_orig());
                int t_msg__size;
                t_msg__size = msg_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_msg__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS5_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS5_Auth_Negotiation::SOCKS5_Auth_Negotiation(bool is_orig) {
    val_case_index_ = -1;
    req_ = nullptr;
    rep_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS5_Auth_Negotiation::~SOCKS5_Auth_Negotiation() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "req"
            {
                delete req_;
                req_ = nullptr;
            }
            break;
        case false:
            // Clean up "rep"
            {
                delete rep_;
                rep_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Auth_Negotiation::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "req"
            {
                req_ = new SOCKS5_Auth_Negotiation_Request();
                int t_req__size;
                t_req__size = req_->Parse(t_begin_of_data, t_end_of_data);
                t_val__size = t_req__size;
            }
            break;
        case false:
            // Parse "rep"
            {
                rep_ = new SOCKS5_Auth_Negotiation_Reply();
                rep_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS5_Auth_Negotiation", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS5_Auth_Negotiation_Request::SOCKS5_Auth_Negotiation_Request() {
    method_count_ = 0;
    methods_ = nullptr;
    methods__elem_ = 0;
}

SOCKS5_Auth_Negotiation_Request::~SOCKS5_Auth_Negotiation_Request() {
    delete methods_;
}

int SOCKS5_Auth_Negotiation_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SOCKS5_Auth_Negotiation_Request:method_count"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Negotiation_Request:method_count",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "method_count"
    method_count_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "methods"
    int t_methods__arraylength;
    t_methods__arraylength = method_count();
    if ( t_methods__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Negotiation_Request:methods",
          t_methods__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: SOCKS5_Auth_Negotiation_Request:methods
    if ( t_methods__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Negotiation_Request:methods",
          t_methods__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
    methods__elem_ = 0;
    int t_methods__elem__it;
    t_methods__elem__it = 0;
    int t_methods__size;
    methods_ = new vector<uint8>;
    methods_->reserve(t_methods__arraylength);
    const_byteptr t_methods__elem__dataptr = (t_begin_of_data + 1);
    for (; t_methods__elem__it < t_methods__arraylength; ++t_methods__elem__it) {
        methods__elem_ = *(reinterpret_cast<uint8 const*>(t_methods__elem__dataptr));
        methods_->push_back(methods__elem_);
        t_methods__elem__dataptr += 1;
        BINPAC_ASSERT(t_methods__elem__dataptr <= t_end_of_data);
    }
end_of_methods: ;
    t_methods__size = t_methods__elem__dataptr - ((t_begin_of_data + 1));
    // Evaluate 'let' and 'withinput' fields

    int t_SOCKS5_Auth_Negotiation_Request__size;
    const_byteptr const t_dataptr_after_methods = (t_begin_of_data + 1) + (t_methods__size);
    BINPAC_ASSERT(t_dataptr_after_methods <= t_end_of_data);
    t_SOCKS5_Auth_Negotiation_Request__size = t_dataptr_after_methods - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Auth_Negotiation_Request__size) <= t_end_of_data);
    return t_SOCKS5_Auth_Negotiation_Request__size;
}

SOCKS5_Auth_Negotiation_Reply::SOCKS5_Auth_Negotiation_Reply() {
    selected_auth_method_ = 0;
    in_auth_sub_neg_ = 0;
    past_auth_ = 0;
    set_auth_ = 0;
}

SOCKS5_Auth_Negotiation_Reply::~SOCKS5_Auth_Negotiation_Reply() {
}

int SOCKS5_Auth_Negotiation_Reply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Auth_Negotiation_Reply"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Negotiation_Reply",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "selected_auth_method"
    selected_auth_method_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    in_auth_sub_neg_ = t_context->connection()->set_v5_in_auth_sub_negotiation(selected_auth_method() == 0 || selected_auth_method() == 0xff ? false : true);
    past_auth_ = t_context->connection()->set_v5_past_authentication();
    set_auth_ = t_context->connection()->set_v5_auth_method(selected_auth_method());
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

SOCKS5_Auth_Message::SOCKS5_Auth_Message(bool is_orig) {
    val_case_index_ = -1;
    req_ = nullptr;
    rep_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS5_Auth_Message::~SOCKS5_Auth_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "req"
            {
                delete req_;
                req_ = nullptr;
            }
            break;
        case false:
            // Clean up "rep"
            {
                delete rep_;
                rep_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Auth_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "req"
            {
                req_ = new SOCKS5_Auth_Request();
                int t_req__size;
                t_req__size = req_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_req__size;
            }
            break;
        case false:
            // Parse "rep"
            {
                rep_ = new SOCKS5_Auth_Reply();
                int t_rep__size;
                t_rep__size = rep_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_rep__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS5_Auth_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS5_Auth_Request::SOCKS5_Auth_Request() {
    val_case_index_ = -1;
    userpass_ = nullptr;
    unsupported_ = nullptr;
}

SOCKS5_Auth_Request::~SOCKS5_Auth_Request() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)2):
            // Clean up "userpass"
            {
                delete userpass_;
                userpass_ = nullptr;
            }
            break;
        default:
            // Clean up "unsupported"
            {
                delete unsupported_;
                unsupported_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Auth_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = t_context->connection()->v5_auth_method();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)2):
            // Parse "userpass"
            {
                userpass_ = new SOCKS5_Auth_Request_UserPass();
                int t_userpass__size;
                t_userpass__size = userpass_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_userpass__size;
            }
            break;
        default:
            // Parse "unsupported"
            {
                unsupported_ = new SOCKS5_Unsupported_Authentication_Method();
                int t_unsupported__size;
                t_unsupported__size = unsupported_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unsupported__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS5_Unsupported_Authentication_Method::SOCKS5_Unsupported_Authentication_Method() {
    proc_ = false;
}

SOCKS5_Unsupported_Authentication_Method::~SOCKS5_Unsupported_Authentication_Method() {
    crap_.free();
}

int SOCKS5_Unsupported_Authentication_Method::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Parse "crap"
    int t_crap_string_length;
    t_crap_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_crap__size;
    t_crap__size = t_crap_string_length;
    // check for negative sizes
    if ( t_crap_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/socks/socks-protocol.pac:56", t_crap_string_length);
    crap_.init(t_begin_of_data, t_crap_string_length);

    int t_SOCKS5_Unsupported_Authentication_Method__size;
    const_byteptr const t_dataptr_after_crap = t_begin_of_data + (t_crap__size);
    BINPAC_ASSERT(t_dataptr_after_crap <= t_end_of_data);
    t_SOCKS5_Unsupported_Authentication_Method__size = t_dataptr_after_crap - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks5_unsupported_authentication_method(t_context->connection()->v5_auth_method());
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Unsupported_Authentication_Method__size) <= t_end_of_data);
    return t_SOCKS5_Unsupported_Authentication_Method__size;
}

SOCKS5_Unsupported_Authentication_Version::SOCKS5_Unsupported_Authentication_Version(uint8 version) {
    version_ = version;
    proc_ = false;
}

SOCKS5_Unsupported_Authentication_Version::~SOCKS5_Unsupported_Authentication_Version() {
    crap_.free();
}

int SOCKS5_Unsupported_Authentication_Version::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Parse "crap"
    int t_crap_string_length;
    t_crap_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_crap__size;
    t_crap__size = t_crap_string_length;
    // check for negative sizes
    if ( t_crap_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/socks/socks-protocol.pac:60", t_crap_string_length);
    crap_.init(t_begin_of_data, t_crap_string_length);

    int t_SOCKS5_Unsupported_Authentication_Version__size;
    const_byteptr const t_dataptr_after_crap = t_begin_of_data + (t_crap__size);
    BINPAC_ASSERT(t_dataptr_after_crap <= t_end_of_data);
    t_SOCKS5_Unsupported_Authentication_Version__size = t_dataptr_after_crap - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks5_unsupported_authentication_version(t_context->connection()->v5_auth_method(), version());
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Unsupported_Authentication_Version__size) <= t_end_of_data);
    return t_SOCKS5_Unsupported_Authentication_Version__size;
}

SOCKS5_Auth_Request_UserPass::SOCKS5_Auth_Request_UserPass() {
    version_ = 0;
    msg_case_index_ = -1;
    v1_ = nullptr;
    unsupported_ = nullptr;
}

SOCKS5_Auth_Request_UserPass::~SOCKS5_Auth_Request_UserPass() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)1):
            // Clean up "v1"
            {
                delete v1_;
                v1_ = nullptr;
            }
            break;
        default:
            // Clean up "unsupported"
            {
                delete unsupported_;
                unsupported_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Auth_Request_UserPass::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Auth_Request_UserPass:version"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Request_UserPass:version",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "msg"
    int t_msg__size;
    msg_case_index_ = version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)1):
            // Parse "v1"
            {
                v1_ = new SOCKS5_Auth_Request_UserPass_v1();
                int t_v1__size;
                t_v1__size = v1_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_msg__size = t_v1__size;
            }
            break;
        default:
            // Parse "unsupported"
            {
                unsupported_ = new SOCKS5_Unsupported_Authentication_Version(version());
                int t_unsupported__size;
                t_unsupported__size = unsupported_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_msg__size = t_unsupported__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SOCKS5_Auth_Request_UserPass__size;
    const_byteptr const t_dataptr_after_msg = (t_begin_of_data + 1) + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_SOCKS5_Auth_Request_UserPass__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Auth_Request_UserPass__size) <= t_end_of_data);
    return t_SOCKS5_Auth_Request_UserPass__size;
}

SOCKS5_Auth_Request_UserPass_v1::SOCKS5_Auth_Request_UserPass_v1() {
    ulen_ = 0;
    plen_ = 0;
    proc_ = false;
}

SOCKS5_Auth_Request_UserPass_v1::~SOCKS5_Auth_Request_UserPass_v1() {
    username_.free();
    password_.free();
}

int SOCKS5_Auth_Request_UserPass_v1::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Auth_Request_UserPass_v1:ulen"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Request_UserPass_v1:ulen",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ulen"
    ulen_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "username"
    int t_username__size;
    t_username__size = ulen();
    // Checking out-of-bound for "SOCKS5_Auth_Request_UserPass_v1:username"
    if ( (t_begin_of_data + 1) + (t_username__size) > t_end_of_data || (t_begin_of_data + 1) + (t_username__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Request_UserPass_v1:username",
        	(1) + (t_username__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_username__size;
        int t_username_string_length;
        t_username_string_length = ulen();
        // check for negative sizes
        if ( t_username_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/socks/socks-protocol.pac:73", t_username_string_length);
        username_.init((t_begin_of_data + 1), t_username_string_length);
    }

    const_byteptr const t_dataptr_after_username = (t_begin_of_data + 1) + (t_username__size);
    BINPAC_ASSERT(t_dataptr_after_username <= t_end_of_data);
    // Checking out-of-bound for "SOCKS5_Auth_Request_UserPass_v1:plen"
    if ( t_dataptr_after_username + (1) > t_end_of_data || t_dataptr_after_username + (1) < t_dataptr_after_username ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Request_UserPass_v1:plen",
        	((t_dataptr_after_username - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "plen"
    plen_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_username));

    // Parse "password"
    int t_password__size;
    t_password__size = plen();
    // Checking out-of-bound for "SOCKS5_Auth_Request_UserPass_v1:password"
    if ( (t_dataptr_after_username + 1) + (t_password__size) > t_end_of_data || (t_dataptr_after_username + 1) + (t_password__size) < (t_dataptr_after_username + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Request_UserPass_v1:password",
        	(((t_dataptr_after_username + 1) - t_begin_of_data)) + (t_password__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_username + 1) + t_password__size;
        int t_password_string_length;
        t_password_string_length = plen();
        // check for negative sizes
        if ( t_password_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/socks/socks-protocol.pac:75", t_password_string_length);
        password_.init((t_dataptr_after_username + 1), t_password_string_length);
    }

    int t_SOCKS5_Auth_Request_UserPass_v1__size;
    const_byteptr const t_dataptr_after_password = (t_dataptr_after_username + 1) + (t_password__size);
    BINPAC_ASSERT(t_dataptr_after_password <= t_end_of_data);
    t_SOCKS5_Auth_Request_UserPass_v1__size = t_dataptr_after_password - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks5_auth_request_userpass(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Auth_Request_UserPass_v1__size) <= t_end_of_data);
    return t_SOCKS5_Auth_Request_UserPass_v1__size;
}

SOCKS5_Auth_Reply::SOCKS5_Auth_Reply() {
    val_case_index_ = -1;
    userpass_ = nullptr;
    unsupported_ = nullptr;
    in_auth_sub_neg_ = 0;
}

SOCKS5_Auth_Reply::~SOCKS5_Auth_Reply() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)2):
            // Clean up "userpass"
            {
                delete userpass_;
                userpass_ = nullptr;
            }
            break;
        default:
            // Clean up "unsupported"
            {
                delete unsupported_;
                unsupported_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Auth_Reply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = t_context->connection()->v5_auth_method();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)2):
            // Parse "userpass"
            {
                userpass_ = new SOCKS5_Auth_Reply_UserPass();
                int t_userpass__size;
                t_userpass__size = userpass_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_userpass__size;
            }
            break;
        default:
            // Parse "unsupported"
            {
                unsupported_ = new SOCKS5_Unsupported_Authentication_Method();
                int t_unsupported__size;
                t_unsupported__size = unsupported_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unsupported__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    in_auth_sub_neg_ = t_context->connection()->set_v5_in_auth_sub_negotiation(false);
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS5_Auth_Reply_UserPass::SOCKS5_Auth_Reply_UserPass() {
    version_ = 0;
    msg_case_index_ = -1;
    v1_ = nullptr;
    unsupported_ = nullptr;
}

SOCKS5_Auth_Reply_UserPass::~SOCKS5_Auth_Reply_UserPass() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)1):
            // Clean up "v1"
            {
                delete v1_;
                v1_ = nullptr;
            }
            break;
        default:
            // Clean up "unsupported"
            {
                delete unsupported_;
                unsupported_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Auth_Reply_UserPass::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Auth_Reply_UserPass:version"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Reply_UserPass:version",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "msg"
    int t_msg__size;
    msg_case_index_ = version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( msg_case_index() ) {
        case ((uint8)1):
            // Parse "v1"
            {
                v1_ = new SOCKS5_Auth_Reply_UserPass_v1();
                v1_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_msg__size = 1;
            }
            break;
        default:
            // Parse "unsupported"
            {
                unsupported_ = new SOCKS5_Unsupported_Authentication_Version(version());
                int t_unsupported__size;
                t_unsupported__size = unsupported_->Parse((t_begin_of_data + 1), t_end_of_data, t_context);
                t_msg__size = t_unsupported__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SOCKS5_Auth_Reply_UserPass__size;
    const_byteptr const t_dataptr_after_msg = (t_begin_of_data + 1) + (t_msg__size);
    BINPAC_ASSERT(t_dataptr_after_msg <= t_end_of_data);
    t_SOCKS5_Auth_Reply_UserPass__size = t_dataptr_after_msg - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Auth_Reply_UserPass__size) <= t_end_of_data);
    return t_SOCKS5_Auth_Reply_UserPass__size;
}

SOCKS5_Auth_Reply_UserPass_v1::SOCKS5_Auth_Reply_UserPass_v1() {
    code_ = 0;
    proc_ = false;
}

SOCKS5_Auth_Reply_UserPass_v1::~SOCKS5_Auth_Reply_UserPass_v1() {
}

int SOCKS5_Auth_Reply_UserPass_v1::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Auth_Reply_UserPass_v1"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Auth_Reply_UserPass_v1",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "code"
    code_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks5_auth_reply_userpass(this);
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

SOCKS5_Real_Message::SOCKS5_Real_Message(bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    reply_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS5_Real_Message::~SOCKS5_Real_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Real_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                request_ = new SOCKS5_Request();
                int t_request__size;
                t_request__size = request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_request__size;
            }
            break;
        case false:
            // Parse "reply"
            {
                reply_ = new SOCKS5_Reply();
                int t_reply__size;
                t_reply__size = reply_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_reply__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS5_Real_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Domain_Name::Domain_Name() {
    len_ = 0;
    byteorder_ = bigendian;
}

Domain_Name::~Domain_Name() {
    name_.free();
}

int Domain_Name::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Domain_Name:len"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Domain_Name:len",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "name"
    int t_name__size;
    t_name__size = len();
    // Checking out-of-bound for "Domain_Name:name"
    if ( (t_begin_of_data + 1) + (t_name__size) > t_end_of_data || (t_begin_of_data + 1) + (t_name__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Domain_Name:name",
        	(1) + (t_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_name__size;
        int t_name_string_length;
        t_name_string_length = len();
        // check for negative sizes
        if ( t_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/socks/socks-protocol.pac:104", t_name_string_length);
        name_.init((t_begin_of_data + 1), t_name_string_length);
    }

    int t_Domain_Name__size;
    const_byteptr const t_dataptr_after_name = (t_begin_of_data + 1) + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    t_Domain_Name__size = t_dataptr_after_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Domain_Name__size) <= t_end_of_data);
    return t_Domain_Name__size;
}

SOCKS5_Address::SOCKS5_Address() {
    addr_type_ = 0;
    addr_case_index_ = -1;
    ipv4_ = 0;
    domain_name_ = nullptr;
    ipv6_ = nullptr;
    ipv6__elem_ = 0;
    byteorder_ = bigendian;
}

SOCKS5_Address::~SOCKS5_Address() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( addr_case_index() ) {
        case ((uint8)1):
            // Clean up "ipv4"
            {
            }
            break;
        case ((uint8)3):
            // Clean up "domain_name"
            {
                delete domain_name_;
                domain_name_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "ipv6"
            {
                delete ipv6_;
            }
            break;
        default:
            // Clean up "err"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS5_Address::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SOCKS5_Address:addr_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Address:addr_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "addr_type"
    addr_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "addr"
    int t_addr__size;
    addr_case_index_ = addr_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( addr_case_index() ) {
        case ((uint8)1):
            // Parse "ipv4"
            {
                // Checking out-of-bound for "SOCKS5_Address:ipv4"
                if ( (t_begin_of_data + 1) + (4) > t_end_of_data || (t_begin_of_data + 1) + (4) < (t_begin_of_data + 1) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SOCKS5_Address:ipv4",
                    	(1) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                ipv4_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 1))));
                t_addr__size = 4;
            }
            break;
        case ((uint8)3):
            // Parse "domain_name"
            {
                domain_name_ = new Domain_Name();
                int t_domain_name__size;
                t_domain_name__size = domain_name_->Parse((t_begin_of_data + 1), t_end_of_data);
                t_addr__size = t_domain_name__size;
            }
            break;
        case ((uint8)4):
            // Parse "ipv6"
            {
                int t_ipv6__arraylength;
                t_ipv6__arraylength = 4;
                if ( t_ipv6__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("SOCKS5_Address:ipv6",
                      t_ipv6__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: SOCKS5_Address:ipv6
                if ( t_ipv6__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 4) )
                    throw binpac::ExceptionOutOfBound("SOCKS5_Address:ipv6",
                      t_ipv6__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
                ipv6__elem_ = 0;
                int t_ipv6__elem__it;
                t_ipv6__elem__it = 0;
                ipv6_ = new vector<uint32>;
                ipv6_->reserve(t_ipv6__arraylength);
                const_byteptr t_ipv6__elem__dataptr = (t_begin_of_data + 1);
                for (; t_ipv6__elem__it < t_ipv6__arraylength; ++t_ipv6__elem__it) {
                    ipv6__elem_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_ipv6__elem__dataptr)));
                    ipv6_->push_back(ipv6__elem_);
                    t_ipv6__elem__dataptr += 4;
                    BINPAC_ASSERT(t_ipv6__elem__dataptr <= t_end_of_data);
                }
            end_of_ipv6: ;
                // Evaluate 'let' and 'withinput' fields
                t_addr__size = 16;
            }
            break;
        default:
            // Parse "err"
            {
                int t_err_string_length;
                t_err_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
                int t_err__size;
                t_err__size = t_err_string_length;
                // check for negative sizes
                if ( t_err_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/socks/socks-protocol.pac:113", t_err_string_length);
                err_.init((t_begin_of_data + 1), t_err_string_length);
                t_addr__size = t_err__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SOCKS5_Address__size;
    const_byteptr const t_dataptr_after_addr = (t_begin_of_data + 1) + (t_addr__size);
    BINPAC_ASSERT(t_dataptr_after_addr <= t_end_of_data);
    t_SOCKS5_Address__size = t_dataptr_after_addr - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Address__size) <= t_end_of_data);
    return t_SOCKS5_Address__size;
}

SOCKS5_Request::SOCKS5_Request() {
    command_ = 0;
    reserved_ = 0;
    remote_name_ = nullptr;
    port_ = 0;
    byteorder_ = bigendian;
    proc_ = false;
}

SOCKS5_Request::~SOCKS5_Request() {
    delete remote_name_;
    remote_name_ = nullptr;
}

int SOCKS5_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Request:reserved"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Request:reserved",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "command"
    command_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "remote_name"
    remote_name_ = new SOCKS5_Address();
    int t_remote_name__size;
    t_remote_name__size = remote_name_->Parse((t_begin_of_data + 2), t_end_of_data);

    const_byteptr const t_dataptr_after_remote_name = (t_begin_of_data + 2) + (t_remote_name__size);
    BINPAC_ASSERT(t_dataptr_after_remote_name <= t_end_of_data);
    // Checking out-of-bound for "SOCKS5_Request:port"
    if ( t_dataptr_after_remote_name + (2) > t_end_of_data || t_dataptr_after_remote_name + (2) < t_dataptr_after_remote_name ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Request:port",
        	((t_dataptr_after_remote_name - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "port"
    port_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_remote_name)));

    int t_SOCKS5_Request__size;
    t_SOCKS5_Request__size = (t_dataptr_after_remote_name + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks5_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Request__size) <= t_end_of_data);
    return t_SOCKS5_Request__size;
}

SOCKS5_Reply::SOCKS5_Reply() {
    reply_ = 0;
    reserved_ = 0;
    bound_ = nullptr;
    port_ = 0;
    byteorder_ = bigendian;
    proc_ = false;
}

SOCKS5_Reply::~SOCKS5_Reply() {
    delete bound_;
    bound_ = nullptr;
}

int SOCKS5_Reply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS5_Reply:reserved"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Reply:reserved",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "reply"
    reply_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "reserved"
    reserved_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "bound"
    bound_ = new SOCKS5_Address();
    int t_bound__size;
    t_bound__size = bound_->Parse((t_begin_of_data + 2), t_end_of_data);

    const_byteptr const t_dataptr_after_bound = (t_begin_of_data + 2) + (t_bound__size);
    BINPAC_ASSERT(t_dataptr_after_bound <= t_end_of_data);
    // Checking out-of-bound for "SOCKS5_Reply:port"
    if ( t_dataptr_after_bound + (2) > t_end_of_data || t_dataptr_after_bound + (2) < t_dataptr_after_bound ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS5_Reply:port",
        	((t_dataptr_after_bound - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "port"
    port_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>(t_dataptr_after_bound)));

    int t_SOCKS5_Reply__size;
    t_SOCKS5_Reply__size = (t_dataptr_after_bound + 2) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks5_reply(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS5_Reply__size) <= t_end_of_data);
    return t_SOCKS5_Reply__size;
}

SOCKS4_Message::SOCKS4_Message(bool is_orig) {
    val_case_index_ = -1;
    request_ = nullptr;
    reply_ = nullptr;
    is_orig_ = is_orig;
}

SOCKS4_Message::~SOCKS4_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case false:
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS4_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    int t_val__size;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "request"
            {
                request_ = new SOCKS4_Request();
                int t_request__size;
                t_request__size = request_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_request__size;
            }
            break;
        case false:
            // Parse "reply"
            {
                reply_ = new SOCKS4_Reply();
                reply_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 8;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS4_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SOCKS4_Request::SOCKS4_Request() {
    command_ = 0;
    port_ = 0;
    addr_ = 0;
    user_ = nullptr;
    user__elem_ = 0;
    host_case_index_ = -1;
    name_ = nullptr;
    name__elem_ = 0;
    empty_ = nullptr;
    empty__elem_ = 0;
    byteorder_ = bigendian;
    v4a_ = false;
    proc_ = false;
}

SOCKS4_Request::~SOCKS4_Request() {
    delete user_;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( host_case_index() ) {
        case true:
            // Clean up "name"
            {
                delete name_;
            }
            break;
        case false:
            // Clean up "empty"
            {
                delete empty_;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SOCKS4_Request::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS4_Request:addr"
    if ( (t_begin_of_data + 3) + (4) > t_end_of_data || (t_begin_of_data + 3) + (4) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS4_Request:addr",
        	(3) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "command"
    command_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "port"
    port_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "addr"
    addr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 3))));

    // Parse "user"
    int t_user__arraylength;
    t_user__arraylength = 0;
    user__elem_ = 0;
    int t_user__elem__it;
    t_user__elem__it = 0;
    int t_user__size;
    user_ = new vector<uint8>;
    const_byteptr t_user__elem__dataptr = (t_begin_of_data + 7);
    for (; /* forever */; ++t_user__elem__it) {
        // Check &until(user__elem__dataptr >= end_of_data)
        if ( t_user__elem__dataptr >= t_end_of_data ) {
            goto end_of_user;
        }
        // Checking out-of-bound for "SOCKS4_Request:user__elem"
        if ( t_user__elem__dataptr + (1) > t_end_of_data || t_user__elem__dataptr + (1) < t_user__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SOCKS4_Request:user__elem",
            	((t_user__elem__dataptr - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        user__elem_ = *(reinterpret_cast<uint8 const*>(t_user__elem__dataptr));
        user_->push_back(user__elem_);
        t_user__elem__dataptr += 1;
        BINPAC_ASSERT(t_user__elem__dataptr <= t_end_of_data);
        // Check &until( ( $element == ((int) 0) ) )
        if (  ( user__elem_ == 0 )  ) {
            goto end_of_user;
        }
    }
end_of_user: ;
    t_user__size = t_user__elem__dataptr - ((t_begin_of_data + 7));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_user = (t_begin_of_data + 7) + (t_user__size);
    BINPAC_ASSERT(t_dataptr_after_user <= t_end_of_data);
    // Parse "host"
    v4a_ =  ( addr() <= 0x000000ff ) ;
    int t_host__size;
    host_case_index_ = v4a();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( host_case_index() ) {
        case true:
            // Parse "name"
            {
                int t_name__arraylength;
                t_name__arraylength = 0;
                name__elem_ = 0;
                int t_name__elem__it;
                t_name__elem__it = 0;
                int t_name__size;
                name_ = new vector<uint8>;
                const_byteptr t_name__elem__dataptr = t_dataptr_after_user;
                for (; /* forever */; ++t_name__elem__it) {
                    // Check &until(name__elem__dataptr >= end_of_data)
                    if ( t_name__elem__dataptr >= t_end_of_data ) {
                        goto end_of_name;
                    }
                    // Checking out-of-bound for "SOCKS4_Request:name__elem"
                    if ( t_name__elem__dataptr + (1) > t_end_of_data || t_name__elem__dataptr + (1) < t_name__elem__dataptr ) {
                        // Handle out-of-bound condition
                        throw binpac::ExceptionOutOfBound("SOCKS4_Request:name__elem",
                        	((t_name__elem__dataptr - t_begin_of_data)) + (1), 
                        	(t_end_of_data) - (t_begin_of_data));
                    }
                    name__elem_ = *(reinterpret_cast<uint8 const*>(t_name__elem__dataptr));
                    name_->push_back(name__elem_);
                    t_name__elem__dataptr += 1;
                    BINPAC_ASSERT(t_name__elem__dataptr <= t_end_of_data);
                    // Check &until( ( $element == ((int) 0) ) )
                    if (  ( name__elem_ == 0 )  ) {
                        goto end_of_name;
                    }
                }
            end_of_name: ;
                t_name__size = t_name__elem__dataptr - (t_dataptr_after_user);
                // Evaluate 'let' and 'withinput' fields
                t_host__size = t_name__size;
            }
            break;
        case false:
            // Parse "empty"
            {
                // Checking out-of-bound for "SOCKS4_Request:empty"
                if ( t_dataptr_after_user + (0) > t_end_of_data || t_dataptr_after_user + (0) < t_dataptr_after_user ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SOCKS4_Request:empty",
                    	((t_dataptr_after_user - t_begin_of_data)) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_user + 0;
                    int t_empty__arraylength;
                    t_empty__arraylength = 0;
                    empty__elem_ = 0;
                    int t_empty__elem__it;
                    t_empty__elem__it = 0;
                    int t_empty__size;
                    empty_ = new vector<uint8>;
                    const_byteptr t_empty__elem__dataptr = t_dataptr_after_user;
                    for (; /* forever */; ++t_empty__elem__it) {
                        // Check &until(empty__elem__dataptr >= end_of_data)
                        if ( t_empty__elem__dataptr >= t_end_of_data ) {
                            goto end_of_empty;
                        }
                        empty__elem_ = *(reinterpret_cast<uint8 const*>(t_empty__elem__dataptr));
                        empty_->push_back(empty__elem_);
                        t_empty__elem__dataptr += 1;
                        BINPAC_ASSERT(t_empty__elem__dataptr <= t_end_of_data);
                    }
                end_of_empty: ;
                    t_empty__size = t_empty__elem__dataptr - (t_dataptr_after_user);
                    // Evaluate 'let' and 'withinput' fields
                }
                t_host__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SOCKS4_Request", (int64)host_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_SOCKS4_Request__size;
    const_byteptr const t_dataptr_after_host = t_dataptr_after_user + (t_host__size);
    BINPAC_ASSERT(t_dataptr_after_host <= t_end_of_data);
    t_SOCKS4_Request__size = t_dataptr_after_host - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks4_request(this);
    BINPAC_ASSERT(t_begin_of_data + (t_SOCKS4_Request__size) <= t_end_of_data);
    return t_SOCKS4_Request__size;
}

SOCKS4_Reply::SOCKS4_Reply() {
    zero_ = 0;
    status_ = 0;
    port_ = 0;
    addr_ = 0;
    byteorder_ = bigendian;
    proc_ = false;
}

SOCKS4_Reply::~SOCKS4_Reply() {
}

int SOCKS4_Reply::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSOCKS* t_context) {
    // Checking out-of-bound for "SOCKS4_Reply"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SOCKS4_Reply",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "zero"
    zero_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "status"
    status_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "port"
    port_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "addr"
    addr_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->socks4_reply(this);
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

SOCKS_Flow::SOCKS_Flow(SOCKS_Conn* connection, bool is_orig) {
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
}

SOCKS_Flow::~SOCKS_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
}

void SOCKS_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        dataunit_ = new SOCKS_Message(is_orig());
        context_ = new ContextSOCKS(connection(), this);
        int t_dataunit__size;
        t_dataunit__size = dataunit_->Parse(t_begin_of_data, t_end_of_data, context_);
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        throw e;
    }
}

void SOCKS_Flow::NewGap(int gap_length) {
}
void SOCKS_Flow::FlowEOF() {
}

zeek::StringValPtr array_to_string(vector<uint8> *a)
	{
	int len = a->size();
	auto tmp = std::make_unique<char[]>(len);
	char *s = tmp.get();
	for ( vector<uint8>::iterator i = a->begin(); i != a->end(); *s++ = *i++ );

	while ( len > 0 && tmp[len-1] == '\0' )
		--len;

	return zeek::make_intrusive<zeek::StringVal>(len, tmp.get());
	}

} // namespace SOCKS
}  // namespace binpac
