// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/ssh/ssh_pac.h"

namespace binpac {






namespace SSH {
ContextSSH::ContextSSH(SSH_Conn* connection, SSH_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextSSH::~ContextSSH() {
}

SSH_Conn::SSH_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new SSH_Flow(this, true);
    downflow_ = new SSH_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		state_up_   = VERSION_EXCHANGE;
		state_down_ = VERSION_EXCHANGE;
		version_    = UNK;
		version_client_    = UNK;
		version_server_    = UNK;
		encrypted_bytes_in_current_segment_ = 0;

		kex_seen_ = false;
		kex_orig_ = false;
		kex_algs_cache_ = bytestring();
		kex_algorithm_ = bytestring();
	
}

SSH_Conn::~SSH_Conn() {

		kex_algorithm_.free();
		kex_algs_cache_.free();
	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SSH_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SSH_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SSH_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool SSH_Conn::clear_encrypted_byte_count_in_current_segment() {

		encrypted_bytes_in_current_segment_ = 0;
		return true;
		
}

bool SSH_Conn::inc_encrypted_byte_count_in_current_segment() {

		++encrypted_bytes_in_current_segment_;
		return true;
		
}

int SSH_Conn::get_encrypted_bytes_in_current_segment() {

		return encrypted_bytes_in_current_segment_;
		
}

int SSH_Conn::get_state(bool is_orig) {

		if ( is_orig )
			{
			return state_up_;
			}
		else
			{
			return state_down_;
			}
		
}

bool SSH_Conn::update_state(state s, bool is_orig) {

		if ( is_orig )
			state_up_ = s;
		else
			state_down_ = s;
		return true;
		
}

int SSH_Conn::get_version() {

		return version_;
		
}

bool SSH_Conn::update_version(bytestring const& v, bool is_orig) {

		if ( v.length() >= 5 )
			{
			if ( v[4] == '2' )
				{
				if ( is_orig )
					version_client_ = SSH2;
				else
					version_server_ = SSH2;
				}
			if ( v[4] == '1' )
				{
				if ( v.length() >= 8 && v[6] == '9' && v[7] == '9' )
					{
					if ( is_orig )
						version_client_ = SSH199;
					else
						version_server_ = SSH199;
					}
				else
					{
					if ( is_orig)
						version_client_ = SSH1;
					else
						version_server_ = SSH1;
					}
				}
			}

		if ( version_server_ == version_client_ )
			{
			// SSH199 vs SSH199 -> 2
			if (version_server_ == SSH199 )
				version_ = SSH2;
			else
				version_ = version_server_;
			}
		// SSH1 vs SSH2 -> Undefined
		// NOLINTBEGIN(bugprone-branch-clone)
		else if ( version_client_ == SSH1 && version_server_ == SSH2 )
			version_ = UNK;
		// SSH2 vs SSH1 -> Undefined
		else if ( version_client_ == SSH2 && version_server_ == SSH1 )
			version_ = UNK;
		// SSH199 vs SSH2 -> 2
		else if ( version_client_ == SSH199 && version_server_ == SSH2 )
			version_ = version_server_;
		// SSH2 vs SSH199 -> 2
		else if ( version_client_ == SSH2 && version_server_ == SSH199 )
			version_ = version_client_;
		// SSH1 vs SSH199 -> 1
		else if ( version_client_ == SSH1 && version_server_ == SSH199 )
			version_ = version_client_;
		// SSH199 vs SSH1 -> 1
		else if ( version_client_ == SSH199 && version_server_ == SSH1 )
			version_ = version_server_;
		// NOLINTEND(bugprone-branch-clone)
		return true;
		
}

bool SSH_Conn::update_kex_state_if_equal(string const& s, state to_state) {

		if ( std_str(kex_algorithm_).compare(s) == 0 )
			{
			update_state(to_state, true);
			update_state(to_state, false);
			return true;
			}
		return false;
		
}

bool SSH_Conn::update_kex_state_if_startswith(string const& s, state to_state) {

		if ( (uint) kex_algorithm_.length() < s.length() )
			return false;

		if ( std_str(kex_algorithm_).substr(0, s.length()).compare(s) == 0 )
			{
			update_state(to_state, true);
			update_state(to_state, false);
			return true;
			}
		return false;
		
}

bool SSH_Conn::update_kex(bytestring const& algs, bool orig) {

		if ( !kex_seen_ )
			{
			kex_seen_ = true;
			kex_orig_ = orig;
			kex_algs_cache_.init(algs.data(), algs.length());

			return false;
			}
		else if ( kex_orig_ == orig )
			return false;

		auto client_list = name_list_to_vector(orig ? algs             : kex_algs_cache_);
		auto server_list = name_list_to_vector(orig ? kex_algs_cache_  : algs);

		for ( unsigned int i = 0; i < client_list->Size(); ++i )
			{
			for ( unsigned int j = 0; j < server_list->Size(); ++j )
				{
				if ( *(client_list->StringAt(i)) == *(server_list->StringAt(j)) )
					{
					kex_algorithm_.free();
					kex_algorithm_.init((const uint8 *) client_list->StringAt(i)->Bytes(),
						client_list->StringAt(i)->Len());

					// UNTESTED
					if ( update_kex_state_if_equal("rsa1024-sha1", KEX_RSA) )
						return true;
					// UNTESTED
					if ( update_kex_state_if_equal("rsa2048-sha256", KEX_RSA) )
						return true;

					// UNTESTED
					if ( update_kex_state_if_equal("diffie-hellman-group1-sha1", KEX_DH) )
						return true;
					// UNTESTED
					if ( update_kex_state_if_equal("diffie-hellman-group14-sha1", KEX_DH) )
						return true;
					// UNTESTED
					if ( update_kex_state_if_equal("diffie-hellman-group14-sha256", KEX_DH) )
						return true;
					// UNTESTED
					if ( update_kex_state_if_equal("diffie-hellman-group16-sha512", KEX_DH) )
						return true;
					// UNTESTED
					if ( update_kex_state_if_equal("diffie-hellman-group16-sha512", KEX_DH) )
						return true;

					if ( update_kex_state_if_equal("diffie-hellman-group-exchange-sha1", KEX_DH_GEX) )
						return true;
					if ( update_kex_state_if_equal("diffie-hellman-group-exchange-sha256", KEX_DH_GEX) )
						return true;

					if ( update_kex_state_if_startswith("gss-group1-sha1-", KEX_GSS) )
						return true;
					if ( update_kex_state_if_startswith("gss-group14-sha1-", KEX_GSS) )
						return true;
					if ( update_kex_state_if_startswith("gss-gex-sha1-", KEX_GSS) )
						return true;
					if ( update_kex_state_if_startswith("gss-", KEX_GSS) )
						return true;

					if ( update_kex_state_if_startswith("ecdh-sha2-", KEX_ECC) )
						return true;
					if ( update_kex_state_if_equal("ecmqv-sha2", KEX_ECC) )
						return true;
					if ( update_kex_state_if_startswith("curve25519-sha256", KEX_ECC) )
						return true;
					// UNTESTED
					if ( update_kex_state_if_startswith("sntrup761x25519-sha512", KEX_ECC) )
						return true;

					zeek_analyzer()->Weird("ssh_unknown_kex_algorithm", c_str(kex_algorithm_));
					return true;

					}
				}
			}

		return true;
		
}

EncryptedByte::EncryptedByte(bool is_orig) {
    buffering_state_ = 0;
    buffering_state_ = 0;
    is_orig_ = is_orig;
    proc_ = false;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

EncryptedByte::~EncryptedByte() {
}

bool EncryptedByte::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "encrypted"
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->NewFrame(0, false);
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_encrypted_parsing_complete;
        t_encrypted_parsing_complete = false;
        while ( ! t_encrypted_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            // NOLINTBEGIN(bugprone-branch-clone)
            switch ( buffering_state_ ) {
                case 0:
                    if ( buffering_state_ == 0 ) {
                        t_flow_buffer->NewFrame(0, false);
                        buffering_state_ = 1;
                    }
                    buffering_state_ = 1;
                    break;
                case 1:
                {
                    buffering_state_ = 2;
                    t_flow_buffer->GrowFrame(1);
                }
                break;
                case 2:
                    BINPAC_ASSERT(t_flow_buffer->ready());
                    if ( t_flow_buffer->ready() ) {
                        int t_encrypted_string_length;
                        t_encrypted_string_length = 1;
                        encrypted_.init(t_begin_of_data, t_encrypted_string_length);
                        t_encrypted_parsing_complete = true;
                        if ( t_encrypted_parsing_complete ) {
                            // Evaluate 'let' and 'withinput' fields
                        }
                        BINPAC_ASSERT(t_encrypted_parsing_complete);
                        buffering_state_ = 0;
                    }
                    break;
                default:
                    BINPAC_ASSERT(buffering_state_ <= 2);
                    break;
            }
            // NOLINTEND(bugprone-branch-clone)
        }
        if ( ! (t_encrypted_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->inc_encrypted_byte_count_in_current_segment();
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

SSH_PDU::SSH_PDU(bool is_orig) {
    val_case_index_ = -1;
    version_ = nullptr;
    encrypted_ = nullptr;
    kex_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
}

SSH_PDU::~SSH_PDU() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Clean up "version"
            {
                delete version_;
                version_ = nullptr;
            }
            break;
        case ((int)7):
            // Clean up "encrypted"
            {
                delete encrypted_;
                encrypted_ = nullptr;
            }
            break;
        default:
            // Clean up "kex"
            {
                delete kex_;
                kex_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool SSH_PDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = t_context->connection()->get_state(is_orig());
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)0):
            // Parse "version"
            {
                if ( ! version_ ) {
                    version_ = new SSH_Version_Switch(is_orig());
                }
                bool t_version_parsing_complete;
                t_version_parsing_complete = false;
                t_version_parsing_complete = version_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_version_parsing_complete ) {
                }
                t_val_parsing_complete = t_version_parsing_complete;
            }
            break;
        case ((int)7):
            // Parse "encrypted"
            {
                if ( ! encrypted_ ) {
                    encrypted_ = new EncryptedByte(is_orig());
                }
                bool t_encrypted_parsing_complete;
                t_encrypted_parsing_complete = false;
                t_encrypted_parsing_complete = encrypted_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_encrypted_parsing_complete ) {
                }
                t_val_parsing_complete = t_encrypted_parsing_complete;
            }
            break;
        default:
            // Parse "kex"
            {
                if ( ! kex_ ) {
                    kex_ = new SSH_Key_Exchange(is_orig());
                }
                bool t_kex_parsing_complete;
                t_kex_parsing_complete = false;
                while ( ! t_kex_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_kex_parsing_complete = kex_->ParseBuffer(t_flow_buffer, t_context, byteorder());
                    if ( t_kex_parsing_complete ) {
                    }
                }
                t_val_parsing_complete = t_kex_parsing_complete;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

SSH_Version_Switch::SSH_Version_Switch(bool is_orig) {
    val_case_index_ = -1;
    client_version_ = nullptr;
    server_version_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
    is_orig_ = is_orig;
}

SSH_Version_Switch::~SSH_Version_Switch() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Clean up "client_version"
            {
                delete client_version_;
                client_version_ = nullptr;
            }
            break;
        case false:
            // Clean up "server_version"
            {
                delete server_version_;
                server_version_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool SSH_Version_Switch::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = is_orig();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case true:
            // Parse "client_version"
            {
                if ( ! client_version_ ) {
                    client_version_ = new SSH_Version_Client();
                }
                bool t_client_version_parsing_complete;
                t_client_version_parsing_complete = false;
                t_client_version_parsing_complete = client_version_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_client_version_parsing_complete ) {
                }
                t_val_parsing_complete = t_client_version_parsing_complete;
            }
            break;
        case false:
            // Parse "server_version"
            {
                if ( ! server_version_ ) {
                    server_version_ = new SSH_Version_Server();
                }
                if ( buffering_state_ == 0 ) {
                    t_flow_buffer->UnsetLineBreaker();
                    t_flow_buffer->NewLine();
                    buffering_state_ = 1;
                }
                bool t_server_version_parsing_complete;
                t_server_version_parsing_complete = false;
                while ( ! t_server_version_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    t_server_version_parsing_complete = server_version_->ParseBuffer(t_flow_buffer, t_context);
                    if ( t_server_version_parsing_complete ) {
                        // Evaluate 'let' and 'withinput' fields
                    }
                    buffering_state_ = 0;
                }
                t_val_parsing_complete = t_server_version_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSH_Version_Switch", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

RegExMatcher SSH_Version_Server_re_001("(SSH-.*)?");

RegExMatcher SSH_Version_Server_re_002("([^[\\xC0-\\xC1]|[\\xF5-\\xFF]])*");

SSH_Version_Server::SSH_Version_Server() {
    update_state_ = false;
    has_update_state_ = false;
    update_version_ = false;
    has_update_version_ = false;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

SSH_Version_Server::~SSH_Version_Server() {
    version_.free();
    nonversiondata_.free();
}

bool SSH_Version_Server::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // Parse "version"
    int t_version_string_length;
    t_version_string_length = 
        SSH_Version_Server_re_001.MatchPrefix(
            t_begin_of_data,
            t_end_of_data - t_begin_of_data);
    if ( t_version_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:35", "(SSH-.*)?", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_version__size;
    t_version__size = t_version_string_length;
    // check for negative sizes
    if ( t_version_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:35", t_version_string_length);
    version_.init(t_begin_of_data, t_version_string_length);

    const_byteptr const t_dataptr_after_version = t_begin_of_data + (t_version__size);
    BINPAC_ASSERT(t_dataptr_after_version <= t_end_of_data);
    // Parse "nonversiondata"
    int t_nonversiondata_string_length;
    t_nonversiondata_string_length = 
        SSH_Version_Server_re_002.MatchPrefix(
            t_dataptr_after_version,
            t_end_of_data - t_dataptr_after_version);
    if ( t_nonversiondata_string_length < 0 ) {
        throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:37", "([^[\\xC0-\\xC1]|[\\xF5-\\xFF]])*", string(reinterpret_cast<const char*>(t_dataptr_after_version), reinterpret_cast<const char*>(t_end_of_data)).c_str());
    }
    int t_nonversiondata__size;
    t_nonversiondata__size = t_nonversiondata_string_length;
    // check for negative sizes
    if ( t_nonversiondata_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:37", t_nonversiondata_string_length);
    nonversiondata_.init(t_dataptr_after_version, t_nonversiondata_string_length);

    t_val_parsing_complete = true;
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        has_update_state_ =  ( (t_dataptr_after_version - t_begin_of_data) > 0 ) ;
        if ( has_update_state() ) {
            update_state_ = t_context->connection()->update_state(KEX_INIT, false);
        }
        has_update_version_ =  ( (t_dataptr_after_version - t_begin_of_data) > 0 ) ;
        if ( has_update_version() ) {
            update_version_ = t_context->connection()->update_version(version(), false);
        }
        proc_ = t_context->flow()->proc_ssh_version_server(this);
    }
    buffering_state_ = 0;
    return t_val_parsing_complete;
}

RegExMatcher SSH_Version_Client_re_003("SSH-.*");

SSH_Version_Client::SSH_Version_Client() {
    buffering_state_ = 0;
    buffering_state_ = 0;
    update_state_ = false;
    update_version_ = false;
    proc_ = false;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

SSH_Version_Client::~SSH_Version_Client() {
    version_.free();
}

bool SSH_Version_Client::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "version"
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->UnsetLineBreaker();
            t_flow_buffer->NewLine();
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_version_parsing_complete;
        t_version_parsing_complete = false;
        while ( ! t_version_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            int t_version_string_length;
            t_version_string_length = 
                SSH_Version_Client_re_003.MatchPrefix(
                    t_begin_of_data,
                    t_end_of_data - t_begin_of_data);
            if ( t_version_string_length < 0 ) {
                throw binpac::ExceptionStringMismatch("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:45", "SSH-.*", string(reinterpret_cast<const char*>(t_begin_of_data), reinterpret_cast<const char*>(t_end_of_data)).c_str());
            }
            // check for negative sizes
            if ( t_version_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:45", t_version_string_length);
            version_.init(t_begin_of_data, t_version_string_length);
            t_version_parsing_complete = true;
            if ( t_version_parsing_complete ) {
                // Evaluate 'let' and 'withinput' fields
            }
            buffering_state_ = 0;
        }
        if ( ! (t_version_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        update_state_ = t_context->connection()->update_state(KEX_INIT, true);
        update_version_ = t_context->connection()->update_version(version(), true);
        proc_ = t_context->flow()->proc_ssh_version_client(this);
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

SSH_Key_Exchange::SSH_Key_Exchange(bool is_orig) {
    packet_length_ = 0;
    key_ex_case_index_ = -1;
    ssh1_msg_ = nullptr;
    ssh2_msg_ = nullptr;
    is_orig_ = is_orig;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

SSH_Key_Exchange::~SSH_Key_Exchange() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( key_ex_case_index() ) {
        case ((int)1):
            // Clean up "ssh1_msg"
            {
                delete ssh1_msg_;
                ssh1_msg_ = nullptr;
            }
            break;
        case ((int)2):
            // Clean up "ssh2_msg"
            {
                delete ssh2_msg_;
                ssh2_msg_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool SSH_Key_Exchange::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSH* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "packet_length"
            // Checking out-of-bound for "SSH_Key_Exchange:packet_length"
            if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SSH_Key_Exchange:packet_length",
                	(0) + (4), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            packet_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
            t_flow_buffer->GrowFrame(t_context->flow()->get_kex_length(t_context->connection()->get_version(), packet_length()));
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "key_ex"
                int t_key_ex__size;
                key_ex_case_index_ = t_context->connection()->get_version();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( key_ex_case_index() ) {
                    case ((int)1):
                        // Parse "ssh1_msg"
                        {
                            ssh1_msg_ = new SSH1_Key_Exchange(is_orig(), packet_length());
                            int t_ssh1_msg__size;
                            t_ssh1_msg__size = ssh1_msg_->Parse((t_begin_of_data + 4), t_end_of_data, t_context, t_byteorder);
                            t_key_ex__size = t_ssh1_msg__size;
                        }
                        break;
                    case ((int)2):
                        // Parse "ssh2_msg"
                        {
                            ssh2_msg_ = new SSH2_Key_Exchange(is_orig(), packet_length());
                            int t_ssh2_msg__size;
                            t_ssh2_msg__size = ssh2_msg_->Parse((t_begin_of_data + 4), t_end_of_data, t_context, t_byteorder);
                            t_key_ex__size = t_ssh2_msg__size;
                        }
                        break;
                    default:
                        throw binpac::ExceptionInvalidCaseIndex("SSH_Key_Exchange", (int64)key_ex_case_index());
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

SSH1_Key_Exchange::SSH1_Key_Exchange(bool is_orig, uint32 packet_length) {
    msg_type_ = 0;
    message_ = nullptr;
    crc_ = 0;
    is_orig_ = is_orig;
    packet_length_ = packet_length;
}

SSH1_Key_Exchange::~SSH1_Key_Exchange() {
    pad_fill_.free();
    delete message_;
    message_ = nullptr;
}

int SSH1_Key_Exchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH1_Key_Exchange__size;
    t_SSH1_Key_Exchange__size = t_context->flow()->get_kex_length(t_context->connection()->get_version(), packet_length()) - 4;
    // Checking out-of-bound for "SSH1_Key_Exchange"
    if ( t_begin_of_data + (t_SSH1_Key_Exchange__size) > t_end_of_data || t_begin_of_data + (t_SSH1_Key_Exchange__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH1_Key_Exchange",
        	(0) + (t_SSH1_Key_Exchange__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH1_Key_Exchange__size;
        // Parse "pad_fill"
        int t_pad_fill__size;
        t_pad_fill__size = 8 -  ( packet_length() % 8 ) ;
        // Checking out-of-bound for "SSH1_Key_Exchange:pad_fill"
        if ( t_begin_of_data + (t_pad_fill__size) > t_end_of_data || t_begin_of_data + (t_pad_fill__size) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_Key_Exchange:pad_fill",
            	(0) + (t_pad_fill__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + t_pad_fill__size;
            int t_pad_fill_string_length;
            t_pad_fill_string_length = 8 -  ( packet_length() % 8 ) ;
            // check for negative sizes
            if ( t_pad_fill_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:63", t_pad_fill_string_length);
            pad_fill_.init(t_begin_of_data, t_pad_fill_string_length);
        }

        const_byteptr const t_dataptr_after_pad_fill = t_begin_of_data + (t_pad_fill__size);
        BINPAC_ASSERT(t_dataptr_after_pad_fill <= t_end_of_data);
        // Checking out-of-bound for "SSH1_Key_Exchange:msg_type"
        if ( t_dataptr_after_pad_fill + (1) > t_end_of_data || t_dataptr_after_pad_fill + (1) < t_dataptr_after_pad_fill ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_Key_Exchange:msg_type",
            	((t_dataptr_after_pad_fill - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "msg_type"
        msg_type_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_pad_fill));

        // Parse "message"
        message_ = new SSH1_Message(is_orig(), msg_type(), packet_length() - 5);
        int t_message__size;
        t_message__size = message_->Parse((t_dataptr_after_pad_fill + 1), t_end_of_data, t_context, t_byteorder);

        const_byteptr const t_dataptr_after_message = (t_dataptr_after_pad_fill + 1) + (t_message__size);
        BINPAC_ASSERT(t_dataptr_after_message <= t_end_of_data);
        // Checking out-of-bound for "SSH1_Key_Exchange:crc"
        if ( t_dataptr_after_message + (4) > t_end_of_data || t_dataptr_after_message + (4) < t_dataptr_after_message ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_Key_Exchange:crc",
            	((t_dataptr_after_message - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "crc"
        crc_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_message)));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH1_Key_Exchange__size) <= t_end_of_data);
    return t_SSH1_Key_Exchange__size;
}

SSH1_Message::SSH1_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    public_key_ = nullptr;
    session_key_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
    detach_ = false;
    proc_newkeys_ = false;
    has_proc_newkeys_ = false;
}

SSH1_Message::~SSH1_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)2):
            // Clean up "public_key"
            {
                delete public_key_;
                public_key_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "session_key"
            {
                delete session_key_;
                session_key_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH1_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)2):
            // Parse "public_key"
            {
                public_key_ = new SSH1_PUBLIC_KEY(length());
                int t_public_key__size;
                t_public_key__size = public_key_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_public_key__size;
            }
            break;
        case ((uint8)3):
            // Parse "session_key"
            {
                session_key_ = new SSH1_SESSION_KEY(length());
                int t_session_key__size;
                t_session_key__size = session_key_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_session_key__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSH1_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    detach_ = t_context->connection()->update_state(ENCRYPTED, is_orig());
    has_proc_newkeys_ =  ( msg_type() == SSH_CMSG_SESSION_KEY ) ;
    if ( has_proc_newkeys() ) {
        proc_newkeys_ = t_context->flow()->proc_newkeys();
    }
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH1_PUBLIC_KEY::SSH1_PUBLIC_KEY(uint32 length) {
    server_key_ = 0;
    server_key_exp_ = nullptr;
    server_key_mod_ = nullptr;
    host_key_ = 0;
    host_key_exp_ = nullptr;
    host_key_mod_ = nullptr;
    flags_ = 0;
    supported_ciphers_ = 0;
    supported_auths_ = 0;
    length_ = length;
    proc_ = false;
}

SSH1_PUBLIC_KEY::~SSH1_PUBLIC_KEY() {
    cookie_.free();
    delete server_key_exp_;
    server_key_exp_ = nullptr;
    delete server_key_mod_;
    server_key_mod_ = nullptr;
    delete host_key_exp_;
    host_key_exp_ = nullptr;
    delete host_key_mod_;
    host_key_mod_ = nullptr;
}

int SSH1_PUBLIC_KEY::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH1_PUBLIC_KEY__size;
    t_SSH1_PUBLIC_KEY__size = length();
    // Checking out-of-bound for "SSH1_PUBLIC_KEY"
    if ( t_begin_of_data + (t_SSH1_PUBLIC_KEY__size) > t_end_of_data || t_begin_of_data + (t_SSH1_PUBLIC_KEY__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH1_PUBLIC_KEY",
        	(0) + (t_SSH1_PUBLIC_KEY__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH1_PUBLIC_KEY__size;
        // Parse "cookie"
        // Checking out-of-bound for "SSH1_PUBLIC_KEY:cookie"
        if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_PUBLIC_KEY:cookie",
            	(0) + (8), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + 8;
            int t_cookie_string_length;
            t_cookie_string_length = 8;
            int t_cookie__size;
            t_cookie__size = t_cookie_string_length;
            cookie_.init(t_begin_of_data, t_cookie_string_length);
        }

        const_byteptr const t_dataptr_after_cookie = t_begin_of_data + (8);
        BINPAC_ASSERT(t_dataptr_after_cookie <= t_end_of_data);
        // Checking out-of-bound for "SSH1_PUBLIC_KEY:server_key"
        if ( t_dataptr_after_cookie + (4) > t_end_of_data || t_dataptr_after_cookie + (4) < t_dataptr_after_cookie ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_PUBLIC_KEY:server_key",
            	((t_dataptr_after_cookie - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "server_key"
        server_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_cookie)));

        // Parse "server_key_exp"
        server_key_exp_ = new ssh1_mp_int();
        int t_server_key_exp__size;
        t_server_key_exp__size = server_key_exp_->Parse((t_dataptr_after_cookie + 4), t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_server_key_exp = (t_dataptr_after_cookie + 4) + (t_server_key_exp__size);
        BINPAC_ASSERT(t_dataptr_after_server_key_exp <= t_end_of_data);
        // Parse "server_key_mod"
        server_key_mod_ = new ssh1_mp_int();
        int t_server_key_mod__size;
        t_server_key_mod__size = server_key_mod_->Parse(t_dataptr_after_server_key_exp, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_server_key_mod = t_dataptr_after_server_key_exp + (t_server_key_mod__size);
        BINPAC_ASSERT(t_dataptr_after_server_key_mod <= t_end_of_data);
        // Checking out-of-bound for "SSH1_PUBLIC_KEY:host_key"
        if ( t_dataptr_after_server_key_mod + (4) > t_end_of_data || t_dataptr_after_server_key_mod + (4) < t_dataptr_after_server_key_mod ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_PUBLIC_KEY:host_key",
            	((t_dataptr_after_server_key_mod - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "host_key"
        host_key_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_server_key_mod)));

        // Parse "host_key_exp"
        host_key_exp_ = new ssh1_mp_int();
        int t_host_key_exp__size;
        t_host_key_exp__size = host_key_exp_->Parse((t_dataptr_after_server_key_mod + 4), t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_host_key_exp = (t_dataptr_after_server_key_mod + 4) + (t_host_key_exp__size);
        BINPAC_ASSERT(t_dataptr_after_host_key_exp <= t_end_of_data);
        // Parse "host_key_mod"
        host_key_mod_ = new ssh1_mp_int();
        int t_host_key_mod__size;
        t_host_key_mod__size = host_key_mod_->Parse(t_dataptr_after_host_key_exp, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_host_key_mod = t_dataptr_after_host_key_exp + (t_host_key_mod__size);
        BINPAC_ASSERT(t_dataptr_after_host_key_mod <= t_end_of_data);
        // Checking out-of-bound for "SSH1_PUBLIC_KEY:supported_auths"
        if ( (t_dataptr_after_host_key_mod + 8) + (4) > t_end_of_data || (t_dataptr_after_host_key_mod + 8) + (4) < (t_dataptr_after_host_key_mod + 8) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_PUBLIC_KEY:supported_auths",
            	(((t_dataptr_after_host_key_mod + 8) - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "flags"
        flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_host_key_mod)));

        // Parse "supported_ciphers"
        supported_ciphers_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_host_key_mod + 4))));

        // Parse "supported_auths"
        supported_auths_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_host_key_mod + 8))));

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_ssh1_server_host_key(host_key_exp()->val(), host_key_mod()->val());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH1_PUBLIC_KEY__size) <= t_end_of_data);
    return t_SSH1_PUBLIC_KEY__size;
}

SSH1_SESSION_KEY::SSH1_SESSION_KEY(uint32 length) {
    cipher_ = 0;
    session_key_ = nullptr;
    flags_ = 0;
    length_ = length;
}

SSH1_SESSION_KEY::~SSH1_SESSION_KEY() {
    cookie_.free();
    delete session_key_;
    session_key_ = nullptr;
}

int SSH1_SESSION_KEY::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_SSH1_SESSION_KEY__size;
    t_SSH1_SESSION_KEY__size = length();
    // Checking out-of-bound for "SSH1_SESSION_KEY"
    if ( t_begin_of_data + (t_SSH1_SESSION_KEY__size) > t_end_of_data || t_begin_of_data + (t_SSH1_SESSION_KEY__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH1_SESSION_KEY",
        	(0) + (t_SSH1_SESSION_KEY__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH1_SESSION_KEY__size;
        // Checking out-of-bound for "SSH1_SESSION_KEY:cipher"
        if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_SESSION_KEY:cipher",
            	(0) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "cipher"
        cipher_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

        // Parse "cookie"
        // Checking out-of-bound for "SSH1_SESSION_KEY:cookie"
        if ( (t_begin_of_data + 1) + (8) > t_end_of_data || (t_begin_of_data + 1) + (8) < (t_begin_of_data + 1) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_SESSION_KEY:cookie",
            	(1) + (8), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 1) + 8;
            int t_cookie_string_length;
            t_cookie_string_length = 8;
            int t_cookie__size;
            t_cookie__size = t_cookie_string_length;
            cookie_.init((t_begin_of_data + 1), t_cookie_string_length);
        }

        const_byteptr const t_dataptr_after_cookie = (t_begin_of_data + 1) + (8);
        BINPAC_ASSERT(t_dataptr_after_cookie <= t_end_of_data);
        // Parse "session_key"
        session_key_ = new ssh1_mp_int();
        int t_session_key__size;
        t_session_key__size = session_key_->Parse(t_dataptr_after_cookie, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_session_key = t_dataptr_after_cookie + (t_session_key__size);
        BINPAC_ASSERT(t_dataptr_after_session_key <= t_end_of_data);
        // Checking out-of-bound for "SSH1_SESSION_KEY:flags"
        if ( t_dataptr_after_session_key + (4) > t_end_of_data || t_dataptr_after_session_key + (4) < t_dataptr_after_session_key ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH1_SESSION_KEY:flags",
            	((t_dataptr_after_session_key - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "flags"
        flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_session_key)));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH1_SESSION_KEY__size) <= t_end_of_data);
    return t_SSH1_SESSION_KEY__size;
}

ssh1_mp_int::ssh1_mp_int() {
    len_ = 0;
}

ssh1_mp_int::~ssh1_mp_int() {
    val_.free();
}

int ssh1_mp_int::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ssh1_mp_int:len"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ssh1_mp_int:len",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "val"
    int t_val__size;
    t_val__size =  ( len() + 7 )  / 8;
    // Checking out-of-bound for "ssh1_mp_int:val"
    if ( (t_begin_of_data + 2) + (t_val__size) > t_end_of_data || (t_begin_of_data + 2) + (t_val__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ssh1_mp_int:val",
        	(2) + (t_val__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_val__size;
        int t_val_string_length;
        t_val_string_length =  ( len() + 7 )  / 8;
        // check for negative sizes
        if ( t_val_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:98", t_val_string_length);
        val_.init((t_begin_of_data + 2), t_val_string_length);
    }

    int t_ssh1_mp_int__size;
    const_byteptr const t_dataptr_after_val = (t_begin_of_data + 2) + (t_val__size);
    BINPAC_ASSERT(t_dataptr_after_val <= t_end_of_data);
    t_ssh1_mp_int__size = t_dataptr_after_val - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ssh1_mp_int__size) <= t_end_of_data);
    return t_ssh1_mp_int__size;
}

SSH2_Header::SSH2_Header(bool is_orig, uint32 packet_length) {
    padding_length_ = 0;
    msg_type_ = 0;
    is_orig_ = is_orig;
    packet_length_ = packet_length;
    payload_length_ = 0;
    detach_ = false;
    has_detach_ = false;
}

SSH2_Header::~SSH2_Header() {
}

int SSH2_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context) {
    // Checking out-of-bound for "SSH2_Header"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_Header",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "padding_length"
    padding_length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "msg_type"
    msg_type_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    payload_length_ = packet_length() - padding_length() - 2;
    has_detach_ =  ( msg_type() == MSG_NEWKEYS ) ;
    if ( has_detach() ) {
        detach_ = t_context->connection()->update_state(ENCRYPTED, is_orig());
    }
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

SSH2_Key_Exchange::SSH2_Key_Exchange(bool is_orig, uint32 packet_length) {
    header_ = nullptr;
    payload_ = nullptr;
    is_orig_ = is_orig;
    packet_length_ = packet_length;
}

SSH2_Key_Exchange::~SSH2_Key_Exchange() {
    delete header_;
    header_ = nullptr;
    delete payload_;
    payload_ = nullptr;
    pad_.free();
}

int SSH2_Key_Exchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_Key_Exchange__size;
    t_SSH2_Key_Exchange__size = packet_length();
    // Checking out-of-bound for "SSH2_Key_Exchange"
    if ( t_begin_of_data + (t_SSH2_Key_Exchange__size) > t_end_of_data || t_begin_of_data + (t_SSH2_Key_Exchange__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_Key_Exchange",
        	(0) + (t_SSH2_Key_Exchange__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_Key_Exchange__size;
        // Checking out-of-bound for "SSH2_Key_Exchange:header"
        if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_Key_Exchange:header",
            	(0) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "header"
        header_ = new SSH2_Header(is_orig(), packet_length());
        header_->Parse(t_begin_of_data, t_end_of_data, t_context);

        // Parse "payload"
        payload_ = new SSH2_Message(is_orig(), header()->msg_type(), header()->payload_length());
        int t_payload__size;
        t_payload__size = payload_->Parse((t_begin_of_data + 2), t_end_of_data, t_context, t_byteorder);

        const_byteptr const t_dataptr_after_payload = (t_begin_of_data + 2) + (t_payload__size);
        BINPAC_ASSERT(t_dataptr_after_payload <= t_end_of_data);
        // Parse "pad"
        int t_pad__size;
        t_pad__size = header()->padding_length();
        // Checking out-of-bound for "SSH2_Key_Exchange:pad"
        if ( t_dataptr_after_payload + (t_pad__size) > t_end_of_data || t_dataptr_after_payload + (t_pad__size) < t_dataptr_after_payload ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_Key_Exchange:pad",
            	((t_dataptr_after_payload - t_begin_of_data)) + (t_pad__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_dataptr_after_payload + t_pad__size;
            int t_pad_string_length;
            t_pad_string_length = header()->padding_length();
            // check for negative sizes
            if ( t_pad_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:115", t_pad_string_length);
            pad_.init(t_dataptr_after_payload, t_pad_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_Key_Exchange__size) <= t_end_of_data);
    return t_SSH2_Key_Exchange__size;
}

SSH2_Message::SSH2_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    kex_ = nullptr;
    kex_dh_gex_ = nullptr;
    kex_dh_ = nullptr;
    kex_ecc_ = nullptr;
    kex_gss_ = nullptr;
    kex_rsa_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
    proc_newkeys_ = false;
    has_proc_newkeys_ = false;
}

SSH2_Message::~SSH2_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Clean up "kex"
            {
                delete kex_;
                kex_ = nullptr;
            }
            break;
        case ((int)2):
            // Clean up "kex_dh_gex"
            {
                delete kex_dh_gex_;
                kex_dh_gex_ = nullptr;
            }
            break;
        case ((int)3):
            // Clean up "kex_dh"
            {
                delete kex_dh_;
                kex_dh_ = nullptr;
            }
            break;
        case ((int)4):
            // Clean up "kex_ecc"
            {
                delete kex_ecc_;
                kex_ecc_ = nullptr;
            }
            break;
        case ((int)5):
            // Clean up "kex_gss"
            {
                delete kex_gss_;
                kex_gss_ = nullptr;
            }
            break;
        case ((int)6):
            // Clean up "kex_rsa"
            {
                delete kex_rsa_;
                kex_rsa_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
                unknown_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->get_state(is_orig());
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Parse "kex"
            {
                kex_ = new SSH2_KEXINIT(length(), is_orig());
                int t_kex__size;
                t_kex__size = kex_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_kex__size;
            }
            break;
        case ((int)2):
            // Parse "kex_dh_gex"
            {
                kex_dh_gex_ = new SSH2_Key_Exchange_DH_GEX_Message(is_orig(), msg_type(), length());
                int t_kex_dh_gex__size;
                t_kex_dh_gex__size = kex_dh_gex_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_kex_dh_gex__size;
            }
            break;
        case ((int)3):
            // Parse "kex_dh"
            {
                kex_dh_ = new SSH2_Key_Exchange_DH_Message(is_orig(), msg_type(), length());
                int t_kex_dh__size;
                t_kex_dh__size = kex_dh_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_kex_dh__size;
            }
            break;
        case ((int)4):
            // Parse "kex_ecc"
            {
                kex_ecc_ = new SSH2_Key_Exchange_ECC_Message(is_orig(), msg_type(), length());
                int t_kex_ecc__size;
                t_kex_ecc__size = kex_ecc_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_kex_ecc__size;
            }
            break;
        case ((int)5):
            // Parse "kex_gss"
            {
                kex_gss_ = new SSH2_Key_Exchange_GSS_Message(is_orig(), msg_type(), length());
                int t_kex_gss__size;
                t_kex_gss__size = kex_gss_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_kex_gss__size;
            }
            break;
        case ((int)6):
            // Parse "kex_rsa"
            {
                kex_rsa_ = new SSH2_Key_Exchange_RSA_Message(is_orig(), msg_type(), length());
                int t_kex_rsa__size;
                t_kex_rsa__size = kex_rsa_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_kex_rsa__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown__size;
                t_unknown__size = length();
                // Checking out-of-bound for "SSH2_Message:unknown"
                if ( t_begin_of_data + (t_unknown__size) > t_end_of_data || t_begin_of_data + (t_unknown__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SSH2_Message:unknown",
                    	(0) + (t_unknown__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_unknown__size;
                    int t_unknown_string_length;
                    t_unknown_string_length = length();
                    // check for negative sizes
                    if ( t_unknown_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:125", t_unknown_string_length);
                    unknown_.init(t_begin_of_data, t_unknown_string_length);
                }
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    has_proc_newkeys_ =  ( msg_type() == MSG_NEWKEYS ) ;
    if ( has_proc_newkeys() ) {
        proc_newkeys_ = t_context->flow()->proc_newkeys();
    }
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH2_KEXINIT::SSH2_KEXINIT(uint32 length, bool is_orig) {
    kex_algorithms_ = nullptr;
    server_host_key_algorithms_ = nullptr;
    encryption_algorithms_client_to_server_ = nullptr;
    encryption_algorithms_server_to_client_ = nullptr;
    mac_algorithms_client_to_server_ = nullptr;
    mac_algorithms_server_to_client_ = nullptr;
    compression_algorithms_client_to_server_ = nullptr;
    compression_algorithms_server_to_client_ = nullptr;
    languages_client_to_server_ = nullptr;
    languages_server_to_client_ = nullptr;
    first_kex_packet_follows_ = 0;
    reserved_ = 0;
    length_ = length;
    is_orig_ = is_orig;
    proc_kex_ = false;
    proc_ = false;
}

SSH2_KEXINIT::~SSH2_KEXINIT() {
    cookie_.free();
    delete kex_algorithms_;
    kex_algorithms_ = nullptr;
    delete server_host_key_algorithms_;
    server_host_key_algorithms_ = nullptr;
    delete encryption_algorithms_client_to_server_;
    encryption_algorithms_client_to_server_ = nullptr;
    delete encryption_algorithms_server_to_client_;
    encryption_algorithms_server_to_client_ = nullptr;
    delete mac_algorithms_client_to_server_;
    mac_algorithms_client_to_server_ = nullptr;
    delete mac_algorithms_server_to_client_;
    mac_algorithms_server_to_client_ = nullptr;
    delete compression_algorithms_client_to_server_;
    compression_algorithms_client_to_server_ = nullptr;
    delete compression_algorithms_server_to_client_;
    compression_algorithms_server_to_client_ = nullptr;
    delete languages_client_to_server_;
    languages_client_to_server_ = nullptr;
    delete languages_server_to_client_;
    languages_server_to_client_ = nullptr;
}

int SSH2_KEXINIT::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_KEXINIT__size;
    t_SSH2_KEXINIT__size = length();
    // Checking out-of-bound for "SSH2_KEXINIT"
    if ( t_begin_of_data + (t_SSH2_KEXINIT__size) > t_end_of_data || t_begin_of_data + (t_SSH2_KEXINIT__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_KEXINIT",
        	(0) + (t_SSH2_KEXINIT__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_KEXINIT__size;
        // Parse "cookie"
        // Checking out-of-bound for "SSH2_KEXINIT:cookie"
        if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_KEXINIT:cookie",
            	(0) + (16), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + 16;
            int t_cookie_string_length;
            t_cookie_string_length = 16;
            int t_cookie__size;
            t_cookie__size = t_cookie_string_length;
            cookie_.init(t_begin_of_data, t_cookie_string_length);
        }

        const_byteptr const t_dataptr_after_cookie = t_begin_of_data + (16);
        BINPAC_ASSERT(t_dataptr_after_cookie <= t_end_of_data);
        // Parse "kex_algorithms"
        kex_algorithms_ = new ssh_string();
        int t_kex_algorithms__size;
        t_kex_algorithms__size = kex_algorithms_->Parse(t_dataptr_after_cookie, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_kex_algorithms = t_dataptr_after_cookie + (t_kex_algorithms__size);
        BINPAC_ASSERT(t_dataptr_after_kex_algorithms <= t_end_of_data);
        // Parse "server_host_key_algorithms"
        server_host_key_algorithms_ = new ssh_string();
        int t_server_host_key_algorithms__size;
        t_server_host_key_algorithms__size = server_host_key_algorithms_->Parse(t_dataptr_after_kex_algorithms, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_server_host_key_algorithms = t_dataptr_after_kex_algorithms + (t_server_host_key_algorithms__size);
        BINPAC_ASSERT(t_dataptr_after_server_host_key_algorithms <= t_end_of_data);
        // Parse "encryption_algorithms_client_to_server"
        encryption_algorithms_client_to_server_ = new ssh_string();
        int t_encryption_algorithms_client_to_server__size;
        t_encryption_algorithms_client_to_server__size = encryption_algorithms_client_to_server_->Parse(t_dataptr_after_server_host_key_algorithms, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_encryption_algorithms_client_to_server = t_dataptr_after_server_host_key_algorithms + (t_encryption_algorithms_client_to_server__size);
        BINPAC_ASSERT(t_dataptr_after_encryption_algorithms_client_to_server <= t_end_of_data);
        // Parse "encryption_algorithms_server_to_client"
        encryption_algorithms_server_to_client_ = new ssh_string();
        int t_encryption_algorithms_server_to_client__size;
        t_encryption_algorithms_server_to_client__size = encryption_algorithms_server_to_client_->Parse(t_dataptr_after_encryption_algorithms_client_to_server, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_encryption_algorithms_server_to_client = t_dataptr_after_encryption_algorithms_client_to_server + (t_encryption_algorithms_server_to_client__size);
        BINPAC_ASSERT(t_dataptr_after_encryption_algorithms_server_to_client <= t_end_of_data);
        // Parse "mac_algorithms_client_to_server"
        mac_algorithms_client_to_server_ = new ssh_string();
        int t_mac_algorithms_client_to_server__size;
        t_mac_algorithms_client_to_server__size = mac_algorithms_client_to_server_->Parse(t_dataptr_after_encryption_algorithms_server_to_client, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_mac_algorithms_client_to_server = t_dataptr_after_encryption_algorithms_server_to_client + (t_mac_algorithms_client_to_server__size);
        BINPAC_ASSERT(t_dataptr_after_mac_algorithms_client_to_server <= t_end_of_data);
        // Parse "mac_algorithms_server_to_client"
        mac_algorithms_server_to_client_ = new ssh_string();
        int t_mac_algorithms_server_to_client__size;
        t_mac_algorithms_server_to_client__size = mac_algorithms_server_to_client_->Parse(t_dataptr_after_mac_algorithms_client_to_server, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_mac_algorithms_server_to_client = t_dataptr_after_mac_algorithms_client_to_server + (t_mac_algorithms_server_to_client__size);
        BINPAC_ASSERT(t_dataptr_after_mac_algorithms_server_to_client <= t_end_of_data);
        // Parse "compression_algorithms_client_to_server"
        compression_algorithms_client_to_server_ = new ssh_string();
        int t_compression_algorithms_client_to_server__size;
        t_compression_algorithms_client_to_server__size = compression_algorithms_client_to_server_->Parse(t_dataptr_after_mac_algorithms_server_to_client, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_compression_algorithms_client_to_server = t_dataptr_after_mac_algorithms_server_to_client + (t_compression_algorithms_client_to_server__size);
        BINPAC_ASSERT(t_dataptr_after_compression_algorithms_client_to_server <= t_end_of_data);
        // Parse "compression_algorithms_server_to_client"
        compression_algorithms_server_to_client_ = new ssh_string();
        int t_compression_algorithms_server_to_client__size;
        t_compression_algorithms_server_to_client__size = compression_algorithms_server_to_client_->Parse(t_dataptr_after_compression_algorithms_client_to_server, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_compression_algorithms_server_to_client = t_dataptr_after_compression_algorithms_client_to_server + (t_compression_algorithms_server_to_client__size);
        BINPAC_ASSERT(t_dataptr_after_compression_algorithms_server_to_client <= t_end_of_data);
        // Parse "languages_client_to_server"
        languages_client_to_server_ = new ssh_string();
        int t_languages_client_to_server__size;
        t_languages_client_to_server__size = languages_client_to_server_->Parse(t_dataptr_after_compression_algorithms_server_to_client, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_languages_client_to_server = t_dataptr_after_compression_algorithms_server_to_client + (t_languages_client_to_server__size);
        BINPAC_ASSERT(t_dataptr_after_languages_client_to_server <= t_end_of_data);
        // Parse "languages_server_to_client"
        languages_server_to_client_ = new ssh_string();
        int t_languages_server_to_client__size;
        t_languages_server_to_client__size = languages_server_to_client_->Parse(t_dataptr_after_languages_client_to_server, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_languages_server_to_client = t_dataptr_after_languages_client_to_server + (t_languages_server_to_client__size);
        BINPAC_ASSERT(t_dataptr_after_languages_server_to_client <= t_end_of_data);
        // Checking out-of-bound for "SSH2_KEXINIT:reserved"
        if ( (t_dataptr_after_languages_server_to_client + 1) + (4) > t_end_of_data || (t_dataptr_after_languages_server_to_client + 1) + (4) < (t_dataptr_after_languages_server_to_client + 1) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_KEXINIT:reserved",
            	(((t_dataptr_after_languages_server_to_client + 1) - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "first_kex_packet_follows"
        first_kex_packet_follows_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_languages_server_to_client));

        // Parse "reserved"
        reserved_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_languages_server_to_client + 1))));

        // Evaluate 'let' and 'withinput' fields
        proc_kex_ = t_context->connection()->update_kex(kex_algorithms()->val(), is_orig());
        proc_ = t_context->flow()->proc_ssh2_kexinit(this);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_KEXINIT__size) <= t_end_of_data);
    return t_SSH2_KEXINIT__size;
}

SSH2_Key_Exchange_DH_Message::SSH2_Key_Exchange_DH_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    init_ = nullptr;
    reply_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
}

SSH2_Key_Exchange_DH_Message::~SSH2_Key_Exchange_DH_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Clean up "init"
            {
                delete init_;
                init_ = nullptr;
            }
            break;
        case ((uint8)31):
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_Key_Exchange_DH_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Parse "init"
            {
                init_ = new SSH2_DH_GEX_INIT(length(), is_orig());
                int t_init__size;
                t_init__size = init_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_init__size;
            }
            break;
        case ((uint8)31):
            // Parse "reply"
            {
                reply_ = new SSH2_DH_GEX_REPLY(length());
                int t_reply__size;
                t_reply__size = reply_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_reply__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown__size;
                t_unknown__size = length();
                // Checking out-of-bound for "SSH2_Key_Exchange_DH_Message:unknown"
                if ( t_begin_of_data + (t_unknown__size) > t_end_of_data || t_begin_of_data + (t_unknown__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SSH2_Key_Exchange_DH_Message:unknown",
                    	(0) + (t_unknown__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_unknown__size;
                    int t_unknown_string_length;
                    t_unknown_string_length = length();
                    // check for negative sizes
                    if ( t_unknown_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:151", t_unknown_string_length);
                    unknown_.init(t_begin_of_data, t_unknown_string_length);
                }
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH2_Key_Exchange_DH_GEX_Message::SSH2_Key_Exchange_DH_GEX_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    request_old_ = nullptr;
    request_ = nullptr;
    group_ = nullptr;
    init_ = nullptr;
    reply_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
}

SSH2_Key_Exchange_DH_GEX_Message::~SSH2_Key_Exchange_DH_GEX_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Clean up "request_old"
            {
                delete request_old_;
                request_old_ = nullptr;
            }
            break;
        case ((uint8)34):
            // Clean up "request"
            {
                delete request_;
                request_ = nullptr;
            }
            break;
        case ((uint8)31):
            // Clean up "group"
            {
                delete group_;
                group_ = nullptr;
            }
            break;
        case ((uint8)32):
            // Clean up "init"
            {
                delete init_;
                init_ = nullptr;
            }
            break;
        case ((uint8)33):
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_Key_Exchange_DH_GEX_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Parse "request_old"
            {
                request_old_ = new SSH2_DH_GEX_REQUEST_OLD();
                request_old_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = 4;
            }
            break;
        case ((uint8)34):
            // Parse "request"
            {
                request_ = new SSH2_DH_GEX_REQUEST();
                request_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = 12;
            }
            break;
        case ((uint8)31):
            // Parse "group"
            {
                group_ = new SSH2_DH_GEX_GROUP(length());
                int t_group__size;
                t_group__size = group_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_group__size;
            }
            break;
        case ((uint8)32):
            // Parse "init"
            {
                init_ = new SSH2_DH_GEX_INIT(length(), is_orig());
                int t_init__size;
                t_init__size = init_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_init__size;
            }
            break;
        case ((uint8)33):
            // Parse "reply"
            {
                reply_ = new SSH2_DH_GEX_REPLY(length());
                int t_reply__size;
                t_reply__size = reply_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_reply__size;
            }
            break;
        default:
            // Parse "unknown"
            {
                int t_unknown__size;
                t_unknown__size = length();
                // Checking out-of-bound for "SSH2_Key_Exchange_DH_GEX_Message:unknown"
                if ( t_begin_of_data + (t_unknown__size) > t_end_of_data || t_begin_of_data + (t_unknown__size) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SSH2_Key_Exchange_DH_GEX_Message:unknown",
                    	(0) + (t_unknown__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + t_unknown__size;
                    int t_unknown_string_length;
                    t_unknown_string_length = length();
                    // check for negative sizes
                    if ( t_unknown_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:162", t_unknown_string_length);
                    unknown_.init(t_begin_of_data, t_unknown_string_length);
                }
                t_val__size = t_unknown__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH2_DH_GEX_REQUEST::SSH2_DH_GEX_REQUEST() {
    min_ = 0;
    n_ = 0;
    max_ = 0;
}

SSH2_DH_GEX_REQUEST::~SSH2_DH_GEX_REQUEST() {
}

int SSH2_DH_GEX_REQUEST::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SSH2_DH_GEX_REQUEST"
    if ( t_begin_of_data + (12) > t_end_of_data || t_begin_of_data + (12) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_REQUEST",
        	(0) + (12), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 12;
        // Checking out-of-bound for "SSH2_DH_GEX_REQUEST:max"
        if ( (t_begin_of_data + 8) + (4) > t_end_of_data || (t_begin_of_data + 8) + (4) < (t_begin_of_data + 8) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_REQUEST:max",
            	(8) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "min"
        min_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "n"
        n_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

        // Parse "max"
        max_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (12) <= t_end_of_data);
    return 12;
}

SSH2_DH_GEX_REQUEST_OLD::SSH2_DH_GEX_REQUEST_OLD() {
    n_ = 0;
}

SSH2_DH_GEX_REQUEST_OLD::~SSH2_DH_GEX_REQUEST_OLD() {
}

int SSH2_DH_GEX_REQUEST_OLD::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "SSH2_DH_GEX_REQUEST_OLD"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_REQUEST_OLD",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 4;
        // Checking out-of-bound for "SSH2_DH_GEX_REQUEST_OLD:n"
        if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_REQUEST_OLD:n",
            	(0) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "n"
        n_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (4) <= t_end_of_data);
    return 4;
}

SSH2_DH_GEX_GROUP::SSH2_DH_GEX_GROUP(uint32 length) {
    p_ = nullptr;
    g_ = nullptr;
    length_ = length;
    proc_ = false;
}

SSH2_DH_GEX_GROUP::~SSH2_DH_GEX_GROUP() {
    delete p_;
    p_ = nullptr;
    delete g_;
    g_ = nullptr;
}

int SSH2_DH_GEX_GROUP::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_DH_GEX_GROUP__size;
    t_SSH2_DH_GEX_GROUP__size = length();
    // Checking out-of-bound for "SSH2_DH_GEX_GROUP"
    if ( t_begin_of_data + (t_SSH2_DH_GEX_GROUP__size) > t_end_of_data || t_begin_of_data + (t_SSH2_DH_GEX_GROUP__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_GROUP",
        	(0) + (t_SSH2_DH_GEX_GROUP__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_DH_GEX_GROUP__size;
        // Parse "p"
        p_ = new ssh_string();
        int t_p__size;
        t_p__size = p_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_p = t_begin_of_data + (t_p__size);
        BINPAC_ASSERT(t_dataptr_after_p <= t_end_of_data);
        // Parse "g"
        g_ = new ssh_string();
        int t_g__size;
        t_g__size = g_->Parse(t_dataptr_after_p, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_ssh2_dh_gex_group(this);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_DH_GEX_GROUP__size) <= t_end_of_data);
    return t_SSH2_DH_GEX_GROUP__size;
}

SSH2_DH_GEX_INIT::SSH2_DH_GEX_INIT(uint32 length, bool is_orig) {
    e_ = nullptr;
    length_ = length;
    is_orig_ = is_orig;
    proc_init_ = false;
}

SSH2_DH_GEX_INIT::~SSH2_DH_GEX_INIT() {
    delete e_;
    e_ = nullptr;
}

int SSH2_DH_GEX_INIT::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_DH_GEX_INIT__size;
    t_SSH2_DH_GEX_INIT__size = length();
    // Checking out-of-bound for "SSH2_DH_GEX_INIT"
    if ( t_begin_of_data + (t_SSH2_DH_GEX_INIT__size) > t_end_of_data || t_begin_of_data + (t_SSH2_DH_GEX_INIT__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_INIT",
        	(0) + (t_SSH2_DH_GEX_INIT__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_DH_GEX_INIT__size;
        // Parse "e"
        e_ = new ssh_string();
        int t_e__size;
        t_e__size = e_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_init_ = t_context->flow()->proc_ssh2_dh_gex_init(is_orig());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_DH_GEX_INIT__size) <= t_end_of_data);
    return t_SSH2_DH_GEX_INIT__size;
}

SSH2_DH_GEX_REPLY::SSH2_DH_GEX_REPLY(uint32 length) {
    k_s_ = nullptr;
    f_ = nullptr;
    signature_ = nullptr;
    length_ = length;
    proc_ = false;
}

SSH2_DH_GEX_REPLY::~SSH2_DH_GEX_REPLY() {
    delete k_s_;
    k_s_ = nullptr;
    delete f_;
    f_ = nullptr;
    delete signature_;
    signature_ = nullptr;
}

int SSH2_DH_GEX_REPLY::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_DH_GEX_REPLY__size;
    t_SSH2_DH_GEX_REPLY__size = length();
    // Checking out-of-bound for "SSH2_DH_GEX_REPLY"
    if ( t_begin_of_data + (t_SSH2_DH_GEX_REPLY__size) > t_end_of_data || t_begin_of_data + (t_SSH2_DH_GEX_REPLY__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_DH_GEX_REPLY",
        	(0) + (t_SSH2_DH_GEX_REPLY__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_DH_GEX_REPLY__size;
        // Parse "k_s"
        k_s_ = new ssh_string();
        int t_k_s__size;
        t_k_s__size = k_s_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_k_s = t_begin_of_data + (t_k_s__size);
        BINPAC_ASSERT(t_dataptr_after_k_s <= t_end_of_data);
        // Parse "f"
        f_ = new ssh_string();
        int t_f__size;
        t_f__size = f_->Parse(t_dataptr_after_k_s, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_f = t_dataptr_after_k_s + (t_f__size);
        BINPAC_ASSERT(t_dataptr_after_f <= t_end_of_data);
        // Parse "signature"
        signature_ = new ssh_string();
        int t_signature__size;
        t_signature__size = signature_->Parse(t_dataptr_after_f, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_ssh2_server_host_key(k_s()->val());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_DH_GEX_REPLY__size) <= t_end_of_data);
    return t_SSH2_DH_GEX_REPLY__size;
}

SSH2_Key_Exchange_RSA_Message::SSH2_Key_Exchange_RSA_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    pubkey_ = nullptr;
    secret_ = nullptr;
    done_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
}

SSH2_Key_Exchange_RSA_Message::~SSH2_Key_Exchange_RSA_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Clean up "pubkey"
            {
                delete pubkey_;
                pubkey_ = nullptr;
            }
            break;
        case ((uint8)31):
            // Clean up "secret"
            {
                delete secret_;
                secret_ = nullptr;
            }
            break;
        case ((uint8)32):
            // Clean up "done"
            {
                delete done_;
                done_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_Key_Exchange_RSA_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Parse "pubkey"
            {
                pubkey_ = new SSH2_RSA_PUBKEY(length());
                int t_pubkey__size;
                t_pubkey__size = pubkey_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_pubkey__size;
            }
            break;
        case ((uint8)31):
            // Parse "secret"
            {
                secret_ = new SSH2_RSA_SECRET(length(), is_orig());
                int t_secret__size;
                t_secret__size = secret_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_secret__size;
            }
            break;
        case ((uint8)32):
            // Parse "done"
            {
                done_ = new SSH2_RSA_DONE(length());
                int t_done__size;
                t_done__size = done_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_done__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSH2_Key_Exchange_RSA_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH2_RSA_PUBKEY::SSH2_RSA_PUBKEY(uint32 length) {
    k_s_ = nullptr;
    k_t_ = nullptr;
    length_ = length;
}

SSH2_RSA_PUBKEY::~SSH2_RSA_PUBKEY() {
    delete k_s_;
    k_s_ = nullptr;
    delete k_t_;
    k_t_ = nullptr;
}

int SSH2_RSA_PUBKEY::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_SSH2_RSA_PUBKEY__size;
    t_SSH2_RSA_PUBKEY__size = length();
    // Checking out-of-bound for "SSH2_RSA_PUBKEY"
    if ( t_begin_of_data + (t_SSH2_RSA_PUBKEY__size) > t_end_of_data || t_begin_of_data + (t_SSH2_RSA_PUBKEY__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_RSA_PUBKEY",
        	(0) + (t_SSH2_RSA_PUBKEY__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_RSA_PUBKEY__size;
        // Parse "k_s"
        k_s_ = new ssh_string();
        int t_k_s__size;
        t_k_s__size = k_s_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_k_s = t_begin_of_data + (t_k_s__size);
        BINPAC_ASSERT(t_dataptr_after_k_s <= t_end_of_data);
        // Parse "k_t"
        k_t_ = new ssh_string();
        int t_k_t__size;
        t_k_t__size = k_t_->Parse(t_dataptr_after_k_s, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_RSA_PUBKEY__size) <= t_end_of_data);
    return t_SSH2_RSA_PUBKEY__size;
}

SSH2_RSA_SECRET::SSH2_RSA_SECRET(uint32 length, bool is_orig) {
    encrypted_payload_ = nullptr;
    length_ = length;
    is_orig_ = is_orig;
    proc_init_ = false;
}

SSH2_RSA_SECRET::~SSH2_RSA_SECRET() {
    delete encrypted_payload_;
    encrypted_payload_ = nullptr;
}

int SSH2_RSA_SECRET::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_RSA_SECRET__size;
    t_SSH2_RSA_SECRET__size = length();
    // Checking out-of-bound for "SSH2_RSA_SECRET"
    if ( t_begin_of_data + (t_SSH2_RSA_SECRET__size) > t_end_of_data || t_begin_of_data + (t_SSH2_RSA_SECRET__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_RSA_SECRET",
        	(0) + (t_SSH2_RSA_SECRET__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_RSA_SECRET__size;
        // Parse "encrypted_payload"
        encrypted_payload_ = new ssh_string();
        int t_encrypted_payload__size;
        t_encrypted_payload__size = encrypted_payload_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_init_ = t_context->flow()->proc_ssh2_rsa_secret(is_orig());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_RSA_SECRET__size) <= t_end_of_data);
    return t_SSH2_RSA_SECRET__size;
}

SSH2_RSA_DONE::SSH2_RSA_DONE(uint32 length) {
    signature_ = nullptr;
    length_ = length;
}

SSH2_RSA_DONE::~SSH2_RSA_DONE() {
    delete signature_;
    signature_ = nullptr;
}

int SSH2_RSA_DONE::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_SSH2_RSA_DONE__size;
    t_SSH2_RSA_DONE__size = length();
    // Checking out-of-bound for "SSH2_RSA_DONE"
    if ( t_begin_of_data + (t_SSH2_RSA_DONE__size) > t_end_of_data || t_begin_of_data + (t_SSH2_RSA_DONE__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_RSA_DONE",
        	(0) + (t_SSH2_RSA_DONE__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_RSA_DONE__size;
        // Parse "signature"
        signature_ = new ssh_string();
        int t_signature__size;
        t_signature__size = signature_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_RSA_DONE__size) <= t_end_of_data);
    return t_SSH2_RSA_DONE__size;
}

SSH2_Key_Exchange_GSS_Message::SSH2_Key_Exchange_GSS_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    init_ = nullptr;
    cont_ = nullptr;
    complete_ = nullptr;
    hostkey_ = nullptr;
    error_ = nullptr;
    groupreq_ = nullptr;
    group_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
}

SSH2_Key_Exchange_GSS_Message::~SSH2_Key_Exchange_GSS_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Clean up "init"
            {
                delete init_;
                init_ = nullptr;
            }
            break;
        case ((uint8)31):
            // Clean up "cont"
            {
                delete cont_;
                cont_ = nullptr;
            }
            break;
        case ((uint8)32):
            // Clean up "complete"
            {
                delete complete_;
                complete_ = nullptr;
            }
            break;
        case ((uint8)33):
            // Clean up "hostkey"
            {
                delete hostkey_;
                hostkey_ = nullptr;
            }
            break;
        case ((uint8)34):
            // Clean up "error"
            {
                delete error_;
                error_ = nullptr;
            }
            break;
        case ((uint8)40):
            // Clean up "groupreq"
            {
                delete groupreq_;
                groupreq_ = nullptr;
            }
            break;
        case ((uint8)41):
            // Clean up "group"
            {
                delete group_;
                group_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_Key_Exchange_GSS_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Parse "init"
            {
                init_ = new SSH2_GSS_INIT(length(), is_orig());
                int t_init__size;
                t_init__size = init_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_init__size;
            }
            break;
        case ((uint8)31):
            // Parse "cont"
            {
                cont_ = new SSH2_GSS_CONTINUE(length());
                int t_cont__size;
                t_cont__size = cont_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_cont__size;
            }
            break;
        case ((uint8)32):
            // Parse "complete"
            {
                complete_ = new SSH2_GSS_COMPLETE(length());
                int t_complete__size;
                t_complete__size = complete_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = t_complete__size;
            }
            break;
        case ((uint8)33):
            // Parse "hostkey"
            {
                hostkey_ = new SSH2_GSS_HOSTKEY(length());
                int t_hostkey__size;
                t_hostkey__size = hostkey_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_hostkey__size;
            }
            break;
        case ((uint8)34):
            // Parse "error"
            {
                error_ = new SSH2_GSS_ERROR(length());
                int t_error__size;
                t_error__size = error_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_error__size;
            }
            break;
        case ((uint8)40):
            // Parse "groupreq"
            {
                groupreq_ = new SSH2_DH_GEX_REQUEST();
                groupreq_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);
                t_val__size = 12;
            }
            break;
        case ((uint8)41):
            // Parse "group"
            {
                group_ = new SSH2_DH_GEX_GROUP(length());
                int t_group__size;
                t_group__size = group_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_group__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSH2_Key_Exchange_GSS_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH2_GSS_INIT::SSH2_GSS_INIT(uint32 length, bool is_orig) {
    output_token_ = nullptr;
    e_ = nullptr;
    length_ = length;
    is_orig_ = is_orig;
    proc_init_ = false;
}

SSH2_GSS_INIT::~SSH2_GSS_INIT() {
    delete output_token_;
    output_token_ = nullptr;
    delete e_;
    e_ = nullptr;
}

int SSH2_GSS_INIT::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_GSS_INIT__size;
    t_SSH2_GSS_INIT__size = length();
    // Checking out-of-bound for "SSH2_GSS_INIT"
    if ( t_begin_of_data + (t_SSH2_GSS_INIT__size) > t_end_of_data || t_begin_of_data + (t_SSH2_GSS_INIT__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_GSS_INIT",
        	(0) + (t_SSH2_GSS_INIT__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_GSS_INIT__size;
        // Parse "output_token"
        output_token_ = new ssh_string();
        int t_output_token__size;
        t_output_token__size = output_token_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_output_token = t_begin_of_data + (t_output_token__size);
        BINPAC_ASSERT(t_dataptr_after_output_token <= t_end_of_data);
        // Parse "e"
        e_ = new ssh_string();
        int t_e__size;
        t_e__size = e_->Parse(t_dataptr_after_output_token, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_init_ = t_context->flow()->proc_ssh2_gss_init(is_orig());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_GSS_INIT__size) <= t_end_of_data);
    return t_SSH2_GSS_INIT__size;
}

SSH2_GSS_CONTINUE::SSH2_GSS_CONTINUE(uint32 length) {
    output_token_ = nullptr;
    length_ = length;
}

SSH2_GSS_CONTINUE::~SSH2_GSS_CONTINUE() {
    delete output_token_;
    output_token_ = nullptr;
}

int SSH2_GSS_CONTINUE::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_SSH2_GSS_CONTINUE__size;
    t_SSH2_GSS_CONTINUE__size = length();
    // Checking out-of-bound for "SSH2_GSS_CONTINUE"
    if ( t_begin_of_data + (t_SSH2_GSS_CONTINUE__size) > t_end_of_data || t_begin_of_data + (t_SSH2_GSS_CONTINUE__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_GSS_CONTINUE",
        	(0) + (t_SSH2_GSS_CONTINUE__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_GSS_CONTINUE__size;
        // Parse "output_token"
        output_token_ = new ssh_string();
        int t_output_token__size;
        t_output_token__size = output_token_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_GSS_CONTINUE__size) <= t_end_of_data);
    return t_SSH2_GSS_CONTINUE__size;
}

SSH2_GSS_COMPLETE::SSH2_GSS_COMPLETE(uint32 length) {
    f_ = nullptr;
    per_msg_token_ = nullptr;
    have_token_ = 0;
    parse_token_case_index_ = -1;
    token_ = nullptr;
    length_ = length;
}

SSH2_GSS_COMPLETE::~SSH2_GSS_COMPLETE() {
    delete f_;
    f_ = nullptr;
    delete per_msg_token_;
    per_msg_token_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parse_token_case_index() ) {
        case ((uint8)0):
            // Clean up "no_token"
            {
            }
            break;
        default:
            // Clean up "token"
            {
                delete token_;
                token_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_GSS_COMPLETE::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_SSH2_GSS_COMPLETE__size;
    t_SSH2_GSS_COMPLETE__size = length();
    // Checking out-of-bound for "SSH2_GSS_COMPLETE"
    if ( t_begin_of_data + (t_SSH2_GSS_COMPLETE__size) > t_end_of_data || t_begin_of_data + (t_SSH2_GSS_COMPLETE__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_GSS_COMPLETE",
        	(0) + (t_SSH2_GSS_COMPLETE__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_GSS_COMPLETE__size;
        // Parse "f"
        f_ = new ssh_string();
        int t_f__size;
        t_f__size = f_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_f = t_begin_of_data + (t_f__size);
        BINPAC_ASSERT(t_dataptr_after_f <= t_end_of_data);
        // Parse "per_msg_token"
        per_msg_token_ = new ssh_string();
        int t_per_msg_token__size;
        t_per_msg_token__size = per_msg_token_->Parse(t_dataptr_after_f, t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_per_msg_token = t_dataptr_after_f + (t_per_msg_token__size);
        BINPAC_ASSERT(t_dataptr_after_per_msg_token <= t_end_of_data);
        // Checking out-of-bound for "SSH2_GSS_COMPLETE:have_token"
        if ( t_dataptr_after_per_msg_token + (1) > t_end_of_data || t_dataptr_after_per_msg_token + (1) < t_dataptr_after_per_msg_token ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_GSS_COMPLETE:have_token",
            	((t_dataptr_after_per_msg_token - t_begin_of_data)) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "have_token"
        have_token_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_per_msg_token));

        // Parse "parse_token"
        int t_parse_token__size;
        parse_token_case_index_ = have_token();
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( parse_token_case_index() ) {
            case ((uint8)0):
                // Parse "no_token"
                {
                    t_parse_token__size = 0;
                }
                break;
            default:
                // Parse "token"
                {
                    token_ = new ssh_string();
                    int t_token__size;
                    t_token__size = token_->Parse((t_dataptr_after_per_msg_token + 1), t_end_of_data, t_byteorder);
                    t_parse_token__size = t_token__size;
                }
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_GSS_COMPLETE__size) <= t_end_of_data);
    return t_SSH2_GSS_COMPLETE__size;
}

SSH2_GSS_HOSTKEY::SSH2_GSS_HOSTKEY(uint32 length) {
    k_s_ = nullptr;
    length_ = length;
    proc_ = false;
}

SSH2_GSS_HOSTKEY::~SSH2_GSS_HOSTKEY() {
    delete k_s_;
    k_s_ = nullptr;
}

int SSH2_GSS_HOSTKEY::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_GSS_HOSTKEY__size;
    t_SSH2_GSS_HOSTKEY__size = length();
    // Checking out-of-bound for "SSH2_GSS_HOSTKEY"
    if ( t_begin_of_data + (t_SSH2_GSS_HOSTKEY__size) > t_end_of_data || t_begin_of_data + (t_SSH2_GSS_HOSTKEY__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_GSS_HOSTKEY",
        	(0) + (t_SSH2_GSS_HOSTKEY__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_GSS_HOSTKEY__size;
        // Parse "k_s"
        k_s_ = new ssh_string();
        int t_k_s__size;
        t_k_s__size = k_s_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_ssh2_server_host_key(k_s()->val());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_GSS_HOSTKEY__size) <= t_end_of_data);
    return t_SSH2_GSS_HOSTKEY__size;
}

SSH2_GSS_ERROR::SSH2_GSS_ERROR(uint32 length) {
    major_status_ = 0;
    minor_status_ = 0;
    message_ = nullptr;
    language_ = nullptr;
    length_ = length;
    proc_ = false;
}

SSH2_GSS_ERROR::~SSH2_GSS_ERROR() {
    delete message_;
    message_ = nullptr;
    delete language_;
    language_ = nullptr;
}

int SSH2_GSS_ERROR::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_SSH2_GSS_ERROR__size;
    t_SSH2_GSS_ERROR__size = length();
    // Checking out-of-bound for "SSH2_GSS_ERROR"
    if ( t_begin_of_data + (t_SSH2_GSS_ERROR__size) > t_end_of_data || t_begin_of_data + (t_SSH2_GSS_ERROR__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSH2_GSS_ERROR",
        	(0) + (t_SSH2_GSS_ERROR__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSH2_GSS_ERROR__size;
        // Checking out-of-bound for "SSH2_GSS_ERROR:minor_status"
        if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SSH2_GSS_ERROR:minor_status",
            	(4) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "major_status"
        major_status_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "minor_status"
        minor_status_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

        // Parse "message"
        message_ = new ssh_string();
        int t_message__size;
        t_message__size = message_->Parse((t_begin_of_data + 8), t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_message = (t_begin_of_data + 8) + (t_message__size);
        BINPAC_ASSERT(t_dataptr_after_message <= t_end_of_data);
        // Parse "language"
        language_ = new ssh_string();
        int t_language__size;
        t_language__size = language_->Parse(t_dataptr_after_message, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_ssh2_gss_error(this);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_GSS_ERROR__size) <= t_end_of_data);
    return t_SSH2_GSS_ERROR__size;
}

SSH2_Key_Exchange_ECC_Message::SSH2_Key_Exchange_ECC_Message(bool is_orig, uint8 msg_type, uint32 length) {
    val_case_index_ = -1;
    init_ = nullptr;
    reply_ = nullptr;
    is_orig_ = is_orig;
    msg_type_ = msg_type;
    length_ = length;
}

SSH2_Key_Exchange_ECC_Message::~SSH2_Key_Exchange_ECC_Message() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Clean up "init"
            {
                delete init_;
                init_ = nullptr;
            }
            break;
        case ((uint8)31):
            // Clean up "reply"
            {
                delete reply_;
                reply_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSH2_Key_Exchange_ECC_Message::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)30):
            // Parse "init"
            {
                init_ = new SSH2_ECC_INIT(length(), is_orig());
                int t_init__size;
                t_init__size = init_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_init__size;
            }
            break;
        case ((uint8)31):
            // Parse "reply"
            {
                reply_ = new SSH2_ECC_REPLY(length(), is_orig());
                int t_reply__size;
                t_reply__size = reply_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_reply__size;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SSH2_Key_Exchange_ECC_Message", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SSH2_ECC_INIT::SSH2_ECC_INIT(uint32 length, bool is_orig) {
    q_c_ = nullptr;
    length_ = length;
    is_orig_ = is_orig;
    proc_ = false;
    proc_init_ = false;
}

SSH2_ECC_INIT::~SSH2_ECC_INIT() {
    delete q_c_;
    q_c_ = nullptr;
}

int SSH2_ECC_INIT::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    // Parse "q_c"
    q_c_ = new ssh_string();
    int t_q_c__size;
    t_q_c__size = q_c_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    int t_SSH2_ECC_INIT__size;
    const_byteptr const t_dataptr_after_q_c = t_begin_of_data + (t_q_c__size);
    BINPAC_ASSERT(t_dataptr_after_q_c <= t_end_of_data);
    t_SSH2_ECC_INIT__size = t_dataptr_after_q_c - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_ssh2_ecc_key(q_c()->val(), is_orig());
    proc_init_ = t_context->flow()->proc_ssh2_ecc_init(is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_ECC_INIT__size) <= t_end_of_data);
    return t_SSH2_ECC_INIT__size;
}

SSH2_ECC_REPLY::SSH2_ECC_REPLY(uint32 length, bool is_orig) {
    k_s_ = nullptr;
    q_s_ = nullptr;
    signature_ = nullptr;
    length_ = length;
    is_orig_ = is_orig;
    proc_k_ = false;
    proc_q_ = false;
}

SSH2_ECC_REPLY::~SSH2_ECC_REPLY() {
    delete k_s_;
    k_s_ = nullptr;
    delete q_s_;
    q_s_ = nullptr;
    delete signature_;
    signature_ = nullptr;
}

int SSH2_ECC_REPLY::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSH* t_context, int t_byteorder) {
    // Parse "k_s"
    k_s_ = new ssh_string();
    int t_k_s__size;
    t_k_s__size = k_s_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_k_s = t_begin_of_data + (t_k_s__size);
    BINPAC_ASSERT(t_dataptr_after_k_s <= t_end_of_data);
    // Parse "q_s"
    q_s_ = new ssh_string();
    int t_q_s__size;
    t_q_s__size = q_s_->Parse(t_dataptr_after_k_s, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_q_s = t_dataptr_after_k_s + (t_q_s__size);
    BINPAC_ASSERT(t_dataptr_after_q_s <= t_end_of_data);
    // Parse "signature"
    signature_ = new ssh_string();
    int t_signature__size;
    t_signature__size = signature_->Parse(t_dataptr_after_q_s, t_end_of_data, t_byteorder);

    int t_SSH2_ECC_REPLY__size;
    const_byteptr const t_dataptr_after_signature = t_dataptr_after_q_s + (t_signature__size);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    t_SSH2_ECC_REPLY__size = t_dataptr_after_signature - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_k_ = t_context->flow()->proc_ssh2_server_host_key(k_s()->val());
    proc_q_ = t_context->flow()->proc_ssh2_ecc_key(q_s()->val(), is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_SSH2_ECC_REPLY__size) <= t_end_of_data);
    return t_SSH2_ECC_REPLY__size;
}

ssh_string::ssh_string() {
    len_ = 0;
}

ssh_string::~ssh_string() {
    val_.free();
}

int ssh_string::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ssh_string:len"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ssh_string:len",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "val"
    int t_val__size;
    t_val__size = len();
    // Checking out-of-bound for "ssh_string:val"
    if ( (t_begin_of_data + 4) + (t_val__size) > t_end_of_data || (t_begin_of_data + 4) + (t_val__size) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ssh_string:val",
        	(4) + (t_val__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_val__size;
        int t_val_string_length;
        t_val_string_length = len();
        // check for negative sizes
        if ( t_val_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssh/ssh-protocol.pac:278", t_val_string_length);
        val_.init((t_begin_of_data + 4), t_val_string_length);
    }

    int t_ssh_string__size;
    const_byteptr const t_dataptr_after_val = (t_begin_of_data + 4) + (t_val__size);
    BINPAC_ASSERT(t_dataptr_after_val <= t_end_of_data);
    t_ssh_string__size = t_dataptr_after_val - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ssh_string__size) <= t_end_of_data);
    return t_ssh_string__size;
}

ssh_host_key::ssh_host_key() {
    len_ = 0;
    key_type_ = nullptr;
    key_ = nullptr;
}

ssh_host_key::~ssh_host_key() {
    delete key_type_;
    key_type_ = nullptr;
    delete key_;
    key_ = nullptr;
}

int ssh_host_key::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_ssh_host_key__size;
    // Checking out-of-bound for "ssh_host_key:len"
    if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ssh_host_key:len",
        	(0) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "len"
    len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));
    t_ssh_host_key__size =  ( len() + 4 ) ;
    // Checking out-of-bound for "ssh_host_key"
    if ( t_begin_of_data + (t_ssh_host_key__size) > t_end_of_data || t_begin_of_data + (t_ssh_host_key__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ssh_host_key",
        	(0) + (t_ssh_host_key__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_ssh_host_key__size;

        // Parse "key_type"
        key_type_ = new ssh_string();
        int t_key_type__size;
        t_key_type__size = key_type_->Parse((t_begin_of_data + 4), t_end_of_data, t_byteorder);

        const_byteptr const t_dataptr_after_key_type = (t_begin_of_data + 4) + (t_key_type__size);
        BINPAC_ASSERT(t_dataptr_after_key_type <= t_end_of_data);
        // Parse "key"
        key_ = new ssh_string();
        int t_key__size;
        t_key__size = key_->Parse(t_dataptr_after_key_type, t_end_of_data, t_byteorder);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_ssh_host_key__size) <= t_end_of_data);
    return t_ssh_host_key__size;
}

SSH_Flow::SSH_Flow(SSH_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

SSH_Flow::~SSH_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void SSH_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new SSH_PDU(is_orig());
                context_ = new ContextSSH(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void SSH_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void SSH_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool SSH_Flow::proc_ssh_version_client(SSH_Version_Client* msg) {

		if ( ssh_client_version )
			zeek::BifEvent::enqueue_ssh_client_version(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				to_stringval(msg->version()));
		return true;
		
}

bool SSH_Flow::proc_ssh_version_server(SSH_Version_Server* msg) {

		if ( ssh_server_version && msg->version().length() > 0 )
			{
			zeek::BifEvent::enqueue_ssh_server_version(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				to_stringval(msg->version()));
			}
		else if ( ssh_server_pre_banner_data )
			{
				zeek::BifEvent::enqueue_ssh_server_pre_banner_data(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(), to_stringval(msg->nonversiondata()));
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_kexinit(SSH2_KEXINIT* msg) {

		if ( ! ssh_capabilities )
			return false;

		auto result = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSH::Capabilities);
		result->Assign(0, name_list_to_vector(msg->kex_algorithms()->val()));
		result->Assign(1, name_list_to_vector(msg->server_host_key_algorithms()->val()));

		auto encryption_algs = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSH::Algorithm_Prefs);
		encryption_algs->Assign(0, name_list_to_vector(msg->encryption_algorithms_client_to_server()->val()));
		encryption_algs->Assign(1, name_list_to_vector(msg->encryption_algorithms_server_to_client()->val()));
		result->Assign(2, std::move(encryption_algs));

		auto mac_algs = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSH::Algorithm_Prefs);
		mac_algs->Assign(0, name_list_to_vector(msg->mac_algorithms_client_to_server()->val()));
		mac_algs->Assign(1, name_list_to_vector(msg->mac_algorithms_server_to_client()->val()));
		result->Assign(3, std::move(mac_algs));

		auto compression_algs = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSH::Algorithm_Prefs);
		compression_algs->Assign(0, name_list_to_vector(msg->compression_algorithms_client_to_server()->val()));
		compression_algs->Assign(1, name_list_to_vector(msg->compression_algorithms_server_to_client()->val()));
		result->Assign(4, std::move(compression_algs));

		if ( msg->languages_client_to_server()->len() || msg->languages_server_to_client()->len() )
			{
			auto languages = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSH::Algorithm_Prefs);
			if ( msg->languages_client_to_server()->len() )
				languages->Assign(0, name_list_to_vector(msg->languages_client_to_server()->val()));
			if ( msg->languages_server_to_client()->len() )
				languages->Assign(1, name_list_to_vector(msg->languages_server_to_client()->val()));

			result->Assign(5, std::move(languages));
			}


		result->Assign(6, !msg->is_orig());

		zeek::BifEvent::enqueue_ssh_capabilities(connection()->zeek_analyzer(),
			connection()->zeek_analyzer()->Conn(), to_stringval(msg->cookie()),
			result);

		return true;
		
}

bool SSH_Flow::proc_ssh2_ecc_init(bool is_orig) {

		if ( ssh2_ecc_init )
			{
			zeek::BifEvent::enqueue_ssh2_ecc_init(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig);
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_dh_gex_init(bool is_orig) {

		if ( ssh2_dh_gex_init )
			{
			zeek::BifEvent::enqueue_ssh2_dh_gex_init(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig);
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_gss_init(bool is_orig) {

		if ( ssh2_gss_init )
			{
			zeek::BifEvent::enqueue_ssh2_gss_init(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig);
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_rsa_secret(bool is_orig) {

		if ( ssh2_rsa_secret )
			{
			zeek::BifEvent::enqueue_ssh2_rsa_secret(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig);
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_dh_gex_group(SSH2_DH_GEX_GROUP* msg) {

		if ( ssh2_dh_server_params )
			{
			zeek::BifEvent::enqueue_ssh2_dh_server_params(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				to_stringval(msg->p()->val()), to_stringval(msg->g()->val()));
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_ecc_key(bytestring const& q, bool is_orig) {

		if ( ssh2_ecc_key )
			{
			zeek::BifEvent::enqueue_ssh2_ecc_key(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				is_orig, to_stringval(q));
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_gss_error(SSH2_GSS_ERROR* msg) {

		if ( ssh2_gss_error )
			{
			zeek::BifEvent::enqueue_ssh2_gss_error(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				msg->major_status(), msg->minor_status(),
				to_stringval(msg->message()->val()));
			}
		return true;
		
}

bool SSH_Flow::proc_ssh2_server_host_key(bytestring const& key) {

		if ( ssh_server_host_key )
			{
			unsigned char digest[ZEEK_MD5_DIGEST_LENGTH];
			zeek::detail::internal_md5(key.data(), key.length(), digest);

			zeek::BifEvent::enqueue_ssh_server_host_key(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				zeek::make_intrusive<zeek::StringVal>(fingerprint_md5(digest)));
			}

		if ( ssh2_server_host_key )
			{
			zeek::BifEvent::enqueue_ssh2_server_host_key(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				to_stringval(key));
			}

		return true;
		
}

bool SSH_Flow::proc_ssh1_server_host_key(bytestring const& exp, bytestring const& mod) {

		if ( ssh_server_host_key )
			{
			unsigned char digest[ZEEK_MD5_DIGEST_LENGTH];
			auto ctx = zeek::detail::hash_init(zeek::detail::Hash_MD5);
			// Fingerprint is calculated over concatenation of modulus + exponent.
			zeek::detail::hash_update(ctx, mod.data(), mod.length());
			zeek::detail::hash_update(ctx, exp.data(), exp.length());
			zeek::detail::hash_final(ctx, digest);

			zeek::BifEvent::enqueue_ssh_server_host_key(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				zeek::make_intrusive<zeek::StringVal>(fingerprint_md5(digest)));
			}

		if ( ssh1_server_host_key )
			{
			zeek::BifEvent::enqueue_ssh1_server_host_key(connection()->zeek_analyzer(),
				connection()->zeek_analyzer()->Conn(),
				to_stringval(mod),
				to_stringval(exp));
			}

		return true;
		
}

bool SSH_Flow::proc_newkeys() {

		connection()->zeek_analyzer()->AnalyzerConfirmation();
		return true;
		
}

int SSH_Flow::get_kex_length(int v, uint32 packet_length) {

		switch (v) {
			case SSH1:
				return packet_length + 4 + 8 - (packet_length % 8);
			case SSH2:
				return packet_length + 4;
			default:
				return 1; //currently causes the rest of the packet to dump
		}
		
}


// Copied from IRC_Analyzer::SplitWords
zeek::VectorValPtr name_list_to_vector(const bytestring& nl)
	{
	auto vv = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

	string name_list = std_str(nl);
	if ( name_list.size() < 1 )
		return vv;

	unsigned int start = 0;
	unsigned int split_pos = 0;

	while ( name_list[start] == ',' )
		{
		++start;
		++split_pos;
		}

	string word;
	while ( (split_pos = name_list.find(',', start)) < name_list.size() )
		{
		word = name_list.substr(start, split_pos - start);
		if ( word.size() > 0 && word[0] != ',' )
			vv->Assign(vv->Size(), zeek::make_intrusive<zeek::StringVal>(word));

		start = split_pos + 1;
		}

	// Add line end if needed.
	if ( start < name_list.size() )
		{
		word = name_list.substr(start, name_list.size() - start);
		vv->Assign(vv->Size(), zeek::make_intrusive<zeek::StringVal>(word));
		}
	return vv;
	}

const char* fingerprint_md5(const unsigned char* d)
	{
	return zeek::util::fmt("%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x:"
	                       "%02x:%02x:%02x:%02x:%02x:%02x:%02x:%02x",
	                       d[0], d[1], d[2], d[3], d[4], d[5], d[6], d[7],
	                       d[8], d[9], d[10], d[11], d[12], d[13], d[14], d[15]);
	}

} // namespace SSH
}  // namespace binpac
