// This file was automatically generated by bifcl from /build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif (plugin mode).


#include "functions.bif.h"
#include "zeek/Func.h"


#line 2 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#include <openssl/x509.h>
#include "zeek/Reporter.h"
#include "zeek/zeek-config.h"

#ifndef ENABLE_SPICY_SSL
#include "zeek/analyzer/protocol/ssl/SSL.h"
#endif

#line 18 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
zeek::ValPtr zeek::BifFunc::set_ssl_established_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 19 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("set_ssl_established() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Connection* c = (zeek::Connection*) ((*BiF_ARGS)[0].get()->AsRecordVal()->GetOrigin()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 19 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#ifndef ENABLE_SPICY_SSL
/* not implemented for Spicy ssl */
	zeek::analyzer::Analyzer* sa = c->FindAnalyzer("SSL");

	if ( sa )
		{
		static_cast<zeek::analyzer::ssl::SSL_Analyzer*>(sa)->StartEncryption();
		return zeek::val_mgr->True();
		}
#endif

	return zeek::val_mgr->False();
	} // end of BifFunc::set_ssl_established

#line 32 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#line 42 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
zeek::ValPtr zeek::BifFunc::set_secret_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 43 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
{
	if ( BiF_ARGS->size() != 2 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("set_secret() takes exactly 2 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Connection* c = (zeek::Connection*) ((*BiF_ARGS)[0].get()->AsRecordVal()->GetOrigin()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek::StringVal* secret = (zeek::StringVal*) ((*BiF_ARGS)[1].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 43 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#ifndef ENABLE_SPICY_SSL
/* not implemented for Spicy ssl */
	analyzer::Analyzer* sa = c->FindAnalyzer("SSL");

	if ( sa )
		{
		static_cast<zeek::analyzer::ssl::SSL_Analyzer*>(sa)->SetSecret(*secret);
		return zeek::val_mgr->True();
		}
#endif

	return zeek::val_mgr->False();
	} // end of BifFunc::set_secret

#line 56 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#line 66 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
zeek::ValPtr zeek::BifFunc::set_keys_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 67 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
{
	if ( BiF_ARGS->size() != 2 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("set_keys() takes exactly 2 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Connection* c = (zeek::Connection*) ((*BiF_ARGS)[0].get()->AsRecordVal()->GetOrigin()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek::StringVal* keys = (zeek::StringVal*) ((*BiF_ARGS)[1].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 67 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#ifndef ENABLE_SPICY_SSL
/* not implemented for Spicy ssl */
	analyzer::Analyzer* sa = c->FindAnalyzer("SSL");

	if ( sa )
		{
		static_cast<zeek::analyzer::ssl::SSL_Analyzer*>(sa)->SetKeys(*keys);
		return zeek::val_mgr->True();
		}
#endif

	return zeek::val_mgr->False();
	} // end of BifFunc::set_keys

#line 80 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

#line 90 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
zeek::ValPtr zeek::BifFunc::parse_distinguished_name_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 91 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("parse_distinguished_name() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::StringVal* dn = (zeek::StringVal*) ((*BiF_ARGS)[0].get()->AsStringVal()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 91 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"

	const unsigned char* in = dn->Bytes();

	X509_NAME* dn_x509 = d2i_X509_NAME(nullptr, &in, dn->Len());
	if ( ! dn_x509 )
		{
		// we were not able to parse. Let's return an empty string.
		return zeek::make_intrusive<zeek::StringVal>("");
		}

	char buf[256];
	memset(buf, 0, sizeof(buf));
	BIO* bio = BIO_new(BIO_s_mem());

	X509_NAME_print_ex(bio, dn_x509, 0, XN_FLAG_RFC2253);
	int len = BIO_gets(bio, buf, sizeof(buf));
	auto out = zeek::make_intrusive<zeek::StringVal>(len, buf);
	BIO_free(bio);
	X509_NAME_free(dn_x509);
	return out;
	} // end of BifFunc::parse_distinguished_name

#line 111 "/build/zeek/src/zeek/src/analyzer/protocol/ssl/functions.bif"
