// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/ssl/ssl_pac.h"

namespace binpac {






namespace SSL {
ContextSSL::ContextSSL(SSL_Conn* connection, SSL_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextSSL::~ContextSSL() {
}

SSL_Conn::SSL_Conn(SSLAnalyzer const& zeek_analyzer) {
    upflow_ = new SSL_Flow(this, true);
    downflow_ = new SSL_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		server_state_ = STATE_CLEAR;
		client_state_ = STATE_CLEAR;
		record_layer_version_ = UNKNOWN_VERSION;
	

		established_ = false;
		decryption_failed_ = false;
	
}

SSL_Conn::~SSL_Conn() {

	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void SSL_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void SSL_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void SSL_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

int SSL_Conn::client_state() {
 return client_state_; 
}

int SSL_Conn::server_state() {
 return client_state_; 
}

int SSL_Conn::state(bool is_orig) {

		if ( is_orig )
			return client_state_;
		else
			return server_state_;
		
}

bool SSL_Conn::startEncryption(bool is_orig) {

		if ( is_orig )
			client_state_ = STATE_ENCRYPTED;
		else
			server_state_ = STATE_ENCRYPTED;
		return true;
		
}

int SSL_Conn::determine_tls13() {

		// let's be conservative and only return yes if it has a valid TLS 1.3 version number here.
		uint16_t negotiated_version = zeek_analyzer()->GetNegotiatedVersion();
		if ( negotiated_version == TLSv13 || negotiated_version/0xFF == 0x7F )
			return 1;

		return 0;
		
}

int SSL_Conn::cap_alert_messages_length(int record_length) {

		int alert_length = record_length;
		int max_length = zeek::BifConst::SSL::max_alerts_per_record * 2;

		// With TLS 1.3, enforce a single alert.
		//
		// From https://datatracker.ietf.org/doc/html/rfc8446//section-5.1
		//
		//    Alert messages (Section 6) MUST NOT be fragmented across records, and
		//    multiple alert messages MUST NOT be coalesced into a single
		//    record.  In other words, a record with an Alert type MUST contain
		//    exactly one message.
		if ( determine_tls13() )
			max_length = 2;

		if ( alert_length > max_length )
			{
			zeek_analyzer()->Weird("SSL_excessive_alerts_in_record", zeek::util::fmt("%d", alert_length / 2));
			alert_length = max_length;
			}

		return alert_length;
		
}

int SSL_Conn::determine_state(bool is_orig, int content_type) {

		int current_state = state(is_orig);
		if ( current_state == STATE_ENCRYPTED || content_type != APPLICATION_DATA )
			return current_state;

		// state = STATE_CLEAR && content_type == APPLICATION_DATA
		uint16_t negotiated_version = zeek_analyzer()->GetNegotiatedVersion();

		// in theory, we should check for TLS13 or draft-TLS13 instead of doing the reverse.
		// But - people use weird version numbers. And all of those weird version numbers are
		// some sort of TLS1.3. So - let's do it this way round instead.
		if ( negotiated_version != SSLv20 && negotiated_version != SSLv30 && negotiated_version != TLSv10 && negotiated_version != TLSv11 && negotiated_version != TLSv12 )
			{
			// well, it seems like this is a TLS 1.3 (or equivalent) application data packet. Let's enable encryption
			// and handle it as encrypted.
			startEncryption(is_orig);
			return STATE_ENCRYPTED;
			}

		return current_state; // has to be STATE_CLEAR
		
}

int SSL_Conn::determine_ssl_record_layer(uint8 head0, uint8 head1, uint8 head2, uint8 head3, uint8 head4, bool is_orig) {

		// stop processing if we already had a protocol violation or otherwise
		// decided that we do not want to parse anymore. Just setting skip is not
		// enough for the data that is already in the pipe.
		if ( zeek_analyzer()->Skipping() )
			return UNKNOWN_VERSION;

		// re-check record layer version to be sure that we still are synchronized with
		// the data stream
		if ( record_layer_version_ != UNKNOWN_VERSION && record_layer_version_ != SSLv20 )
			{
			uint16 version = (head1<<8) | head2;
			if ( version != SSLv30 && version != TLSv10 &&
			     version != TLSv11 && version != TLSv12 )
				{
				zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid version late in TLS connection. Packet reported version: %d", version));
				zeek_analyzer()->SetSkip(true);
				return UNKNOWN_VERSION;
				}
			}

		if ( record_layer_version_ != UNKNOWN_VERSION )
			return record_layer_version_;

		if ( head0 & 0x80 )
			{
			if ( head2 == 0x01 && is_orig ) // SSLv2 client hello.
				{
				uint16 version = (head3 << 8) | head4;
				if ( version != SSLv20 && version != SSLv30 && version != TLSv10 &&
				     version != TLSv11 && version != TLSv12 )
					{
					zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid version in SSL client hello. Version: %d", version));
					zeek_analyzer()->SetSkip(true);
					return UNKNOWN_VERSION;
					}

				else
					return SSLv20;
				}

			else if ( head2 == 0x04 && head4 < 2 && ! is_orig ) // SSLv2 server hello. This connection will continue using SSLv2.
				{
				record_layer_version_ = SSLv20;
				return SSLv20;
				}

			else // this is not SSL or TLS.
				{
				zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid headers in SSL connection. Head1: %d, head2: %d, head3: %d", head1, head2, head3));
				zeek_analyzer()->SetSkip(true);
				return UNKNOWN_VERSION;
				}
			}

		uint16 version = (head1<<8) | head2;
		if ( version != SSLv30 && version != TLSv10 &&
		     version != TLSv11 && version != TLSv12 )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid version in TLS connection. Version: %d", version));
			zeek_analyzer()->SetSkip(true);
			return UNKNOWN_VERSION;
			}

		if ( head0 >=20 && head0 <= 30 )
			{ // ok, set record layer version, this never can be downgraded to v2
			record_layer_version_ = version;
			return version;
			}

		zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid type in TLS connection. Version: %d, Type: %d", version, head0));
		zeek_analyzer()->SetSkip(true);
		return UNKNOWN_VERSION;
		
}

uint16 SSL_Conn::record_version() {
 return 0; 
}

bool SSL_Conn::setEstablished() {

		established_ = true;
		return true;
		
}

bool SSL_Conn::proc_alert(SSLRecord* rec, int level, int desc) {

		if ( ssl_alert )
			zeek::BifEvent::enqueue_ssl_alert(zeek_analyzer(), zeek_analyzer()->Conn(),
							rec->is_orig() ^ zeek_analyzer()->GetFlipped(), level, desc);
		return true;
		
}

bool SSL_Conn::proc_unknown_record(SSLRecord* rec) {

		zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unknown SSL record type (%d) from %s",
				rec->content_type(),
				orig_label(rec->is_orig()).c_str()));
		return true;
		
}

bool SSL_Conn::proc_ciphertext_record(SSLRecord* rec, const_bytestring const& cont) {

		if ( established_ == false && determine_tls13() == 1 )
			{
			if ( ssl_probable_encrypted_handshake_message )
				zeek::BifEvent::enqueue_ssl_probable_encrypted_handshake_message(zeek_analyzer(),
					zeek_analyzer()->Conn(), rec->is_orig(), rec->length());
			}

		if ( client_state_ == STATE_ENCRYPTED &&
		     server_state_ == STATE_ENCRYPTED &&
		     established_ == false )
			{
			established_ = true;
			if ( ssl_established )
				zeek::BifEvent::enqueue_ssl_established(zeek_analyzer(), zeek_analyzer()->Conn());
			}

		if ( ssl_encrypted_data )
			{
			zeek::BifEvent::enqueue_ssl_encrypted_data(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->raw_tls_version(), rec->content_type(), rec->length());
			}

		if ( rec->content_type() == APPLICATION_DATA && decryption_failed_ == false )
			{
			// If decryption of one packet fails, do not try to decrypt future packets.
			if ( ! zeek_analyzer()->TryDecryptApplicationData(cont.length(), cont.begin(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->content_type(), rec->raw_tls_version()) )
				decryption_failed_ = true;
			}

		return true;
		
}

bool SSL_Conn::proc_plaintext_record(SSLRecord* rec) {

		if ( ssl_plaintext_data )
			zeek::BifEvent::enqueue_ssl_plaintext_data(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->raw_tls_version(), rec->content_type(), rec->length());

		return true;
		
}

bool SSL_Conn::proc_heartbeat(SSLRecord* rec, uint8 type, uint16 payload_length, bytestring const& data) {

		if ( ssl_heartbeat )
			zeek::BifEvent::enqueue_ssl_heartbeat(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped(), rec->length(), type, payload_length,
				zeek::make_intrusive<zeek::StringVal>(data.length(), reinterpret_cast<const char*>(data.data())));
		return true;
		
}

bool SSL_Conn::proc_check_v2_server_hello_version(uint16 version) {

		if ( version != SSLv20 )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Invalid version in SSL server hello. Version: %d", version));
			zeek_analyzer()->SetSkip(true);
			return false;
			}

		return true;
		
}

bool SSL_Conn::proc_ccs(SSLRecord* rec) {

		if ( ssl_change_cipher_spec )
			zeek::BifEvent::enqueue_ssl_change_cipher_spec(zeek_analyzer(),
				zeek_analyzer()->Conn(), rec->is_orig() ^ zeek_analyzer()->GetFlipped());

		return true;
		
}

bool SSL_Conn::proc_certificate(bool is_orig, bool is_flipped, vector<bytestring>* certificates) {

	if ( certificates->size() == 0 )
		return true;

	zeek::ODesc common;
	common.AddRaw("Analyzer::ANALYZER_SSL");
	common.Add(zeek_analyzer()->Conn()->StartTime());
	common.AddRaw(is_orig ^ is_flipped ? "T" : "F", 1);
	zeek_analyzer()->Conn()->IDString(&common);

	static const string user_mime = "application/x-x509-user-cert";
	static const string ca_mime = "application/x-x509-ca-cert";

	for ( unsigned int i = 0; i < certificates->size(); ++i )
		{
		const bytestring& cert = (*certificates)[i];

		if ( cert.length() <= 0 )
			{
			zeek::reporter->Weird(zeek_analyzer()->Conn(), "zero_length_certificate", "",
			                      zeek_analyzer()->GetAnalyzerName());
			continue;
			}

		zeek::ODesc file_handle;
		file_handle.Add(common.Description());
		file_handle.Add(i);

		string file_id = zeek::file_mgr->HashHandle(file_handle.Description());

		zeek::file_mgr->DataIn(reinterpret_cast<const u_char*>(cert.data()),
		                       cert.length(), zeek_analyzer()->GetAnalyzerTag(),
		                       zeek_analyzer()->Conn(), is_orig ^ is_flipped,
		                       file_id, i == 0 ? user_mime : ca_mime);
		zeek::file_mgr->EndOfFile(file_id);
		}
	return true;
	
}

bool SSL_Conn::proc_client_hello(uint16 version, double ts, bytestring const& client_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, vector<uint8>* compression_methods) {

		if ( ! version_ok(version) )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unsupported client SSL version 0x%04x", version));
			zeek_analyzer()->SetSkip(true);
			}
		else
			zeek_analyzer()->AnalyzerConfirmation();

		if ( ssl_client_hello )
			{
			auto cipher_vec = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

			if ( cipher_suites16 )
				{
				cipher_vec->Reserve(cipher_suites16->size());
				for ( uint32_t cipher : *cipher_suites16 )
					cipher_vec->Append(zeek::val_mgr->Count(cipher));
				}
			else
				{
				cipher_vec->Reserve(cipher_suites24->size());
				for ( auto cipher : *cipher_suites24 )
					cipher_vec->Append(zeek::val_mgr->Count(to_int()(cipher)));
				}

			auto comp_vec = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

			if ( compression_methods )
				{
				comp_vec->Reserve(compression_methods->size());
				for ( auto method : *compression_methods )
					comp_vec->Append(zeek::val_mgr->Count(method));
				}

			zeek::BifEvent::enqueue_ssl_client_hello(zeek_analyzer(), zeek_analyzer()->Conn(),
							version, record_version(), ts,
							zeek::make_intrusive<zeek::StringVal>(client_random.length(),
							                                      reinterpret_cast<const char*>(client_random.data())),
							{zeek::AdoptRef{}, to_string_val(session_id)},
							std::move(cipher_vec), std::move(comp_vec));
			}

		return true;
		
}

bool SSL_Conn::proc_server_hello(uint16 version, bool v2, bytestring const& server_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, uint8 comp_method) {

		if ( ! version_ok(version) )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unsupported server SSL version 0x%04x", version));
			zeek_analyzer()->SetSkip(true);
			}

		if ( ssl_server_hello )
			{
			int first_cipher = 0;
			if ( cipher_suites16 && ! cipher_suites16->empty() )
				first_cipher = cipher_suites16->front();
			else if ( cipher_suites24 && ! cipher_suites24->empty() )
				first_cipher = to_int()(cipher_suites24->front());

			uint32 ts = 0;
			if ( v2 == 0 && server_random.length() >= 4 )
				ts = ntohl(*(reinterpret_cast<uint32*>(server_random.data())));

			zeek::BifEvent::enqueue_ssl_server_hello(zeek_analyzer(),
							zeek_analyzer()->Conn(),
							version, record_version(), ts,
							zeek::make_intrusive<zeek::StringVal>(server_random.length(),
							                                      reinterpret_cast<const char*>(server_random.data())),
							{zeek::AdoptRef{}, to_string_val(session_id)},
							first_cipher, comp_method);
			}

		return true;
		
}

bool SSL_Conn::proc_v2_certificate(bool is_orig, bytestring const& cert) {

		vector<bytestring>* cert_list = new vector<bytestring>(1,cert);
		bool ret = proc_certificate(is_orig, zeek_analyzer()->GetFlipped(), cert_list);
		delete cert_list;
		return ret;
		
}

bool SSL_Conn::proc_v2_client_master_key(SSLRecord* rec, int cipher_kind) {

		if ( ssl_established )
			zeek::BifEvent::enqueue_ssl_established(zeek_analyzer(), zeek_analyzer()->Conn());

		return true;
		
}

bool SSL_Conn::proc_handshake(SSLRecord* rec, bytestring const& data, bool is_orig) {

		zeek_analyzer()->SendHandshake(rec->raw_tls_version(), data.begin(), data.end(), is_orig);
		return true;
		
}

PlaintextRecord::PlaintextRecord(SSLRecord* rec) {
    val_case_index_ = -1;
    ch_cipher_ = nullptr;
    alerts_ = nullptr;
    heartbeat_ = nullptr;
    app_data_ = nullptr;
    unknown_record_ = nullptr;
    handshake_ = nullptr;
    v2_error_ = nullptr;
    v2_client_hello_ = nullptr;
    v2_client_master_key_ = nullptr;
    v2_server_hello_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

PlaintextRecord::~PlaintextRecord() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)20):
            // Clean up "ch_cipher"
            {
                delete ch_cipher_;
                ch_cipher_ = nullptr;
            }
            break;
        case ((int)21):
            // Clean up "alerts"
            {
                delete alerts_;
                alerts_ = nullptr;
            }
            break;
        case ((int)24):
            // Clean up "heartbeat"
            {
                delete heartbeat_;
                heartbeat_ = nullptr;
            }
            break;
        case ((int)23):
            // Clean up "app_data"
            {
                delete app_data_;
                app_data_ = nullptr;
            }
            break;
        case ((int)22):
            // Clean up "handshake"
            {
                delete handshake_;
                handshake_ = nullptr;
            }
            break;
        case ((int)300):
            // Clean up "v2_error"
            {
                delete v2_error_;
                v2_error_ = nullptr;
            }
            break;
        case ((int)301):
            // Clean up "v2_client_hello"
            {
                delete v2_client_hello_;
                v2_client_hello_ = nullptr;
            }
            break;
        case ((int)302):
            // Clean up "v2_client_master_key"
            {
                delete v2_client_master_key_;
                v2_client_master_key_ = nullptr;
            }
            break;
        case ((int)304):
            // Clean up "v2_server_hello"
            {
                delete v2_server_hello_;
                v2_server_hello_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_record"
            {
                delete unknown_record_;
                unknown_record_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int PlaintextRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = rec()->content_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)20):
            // Parse "ch_cipher"
            {
                ch_cipher_ = new ChangeCipherSpec(rec());
                ch_cipher_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = 1;
            }
            break;
        case ((int)21):
            // Parse "alerts"
            {
                alerts_ = new Alerts(rec());
                int t_alerts__size;
                t_alerts__size = alerts_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_alerts__size;
            }
            break;
        case ((int)24):
            // Parse "heartbeat"
            {
                heartbeat_ = new Heartbeat(rec());
                int t_heartbeat__size;
                t_heartbeat__size = heartbeat_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_heartbeat__size;
            }
            break;
        case ((int)23):
            // Parse "app_data"
            {
                app_data_ = new ApplicationData(rec());
                int t_app_data__size;
                t_app_data__size = app_data_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_app_data__size;
            }
            break;
        case ((int)22):
            // Parse "handshake"
            {
                handshake_ = new Handshake(rec());
                int t_handshake__size;
                t_handshake__size = handshake_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_handshake__size;
            }
            break;
        case ((int)300):
            // Parse "v2_error"
            {
                v2_error_ = new V2Error(rec());
                int t_v2_error__size;
                t_v2_error__size = v2_error_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_v2_error__size;
            }
            break;
        case ((int)301):
            // Parse "v2_client_hello"
            {
                v2_client_hello_ = new V2ClientHello(rec());
                int t_v2_client_hello__size;
                t_v2_client_hello__size = v2_client_hello_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_v2_client_hello__size;
            }
            break;
        case ((int)302):
            // Parse "v2_client_master_key"
            {
                v2_client_master_key_ = new V2ClientMasterKey(rec());
                int t_v2_client_master_key__size;
                t_v2_client_master_key__size = v2_client_master_key_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_v2_client_master_key__size;
            }
            break;
        case ((int)304):
            // Parse "v2_server_hello"
            {
                v2_server_hello_ = new V2ServerHello(rec());
                int t_v2_server_hello__size;
                t_v2_server_hello__size = v2_server_hello_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_v2_server_hello__size;
            }
            break;
        default:
            // Parse "unknown_record"
            {
                unknown_record_ = new UnknownRecord(rec());
                int t_unknown_record__size;
                t_unknown_record__size = unknown_record_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unknown_record__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_plaintext_record(rec());
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ChangeCipherSpec::ChangeCipherSpec(SSLRecord* rec) {
    type_ = 0;
    rec_ = rec;
    state_changed_ = false;
    proc_ = false;
}

ChangeCipherSpec::~ChangeCipherSpec() {
}

int ChangeCipherSpec::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Checking out-of-bound for "ChangeCipherSpec"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ChangeCipherSpec",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 1;
        // Checking out-of-bound for "ChangeCipherSpec:type"
        if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("ChangeCipherSpec:type",
            	(0) + (1), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "type"
        type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

        // Evaluate 'let' and 'withinput' fields
        int t_t_var_001;
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( t_context->connection()->determine_tls13() ) {
            case ((int)1):
                t_t_var_001 = false;
                break;
            case ((int)0):
                t_t_var_001 = t_context->connection()->startEncryption(rec()->is_orig());
                break;
            default:
                throw binpac::ExceptionInvalidCaseIndex("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:39", (int64)t_context->connection()->determine_tls13());
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        state_changed_ = t_t_var_001;
        proc_ = t_context->connection()->proc_ccs(rec());
    }
    BINPAC_ASSERT(t_begin_of_data + (1) <= t_end_of_data);
    return 1;
}

Alerts::Alerts(SSLRecord* rec) {
    alerts_ = nullptr;
    alerts__elem_ = nullptr;
    rec_ = rec;
}

Alerts::~Alerts() {
    delete alerts__elem_;
    alerts__elem_ = nullptr;
    if ( alerts() ) {
        for ( auto* alerts__elem_ : *alerts() ) {
            delete alerts__elem_;
            alerts__elem_ = nullptr;
        }
    }
    delete alerts_;
}

int Alerts::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    int t_Alerts__size;
    t_Alerts__size = rec()->length();
    // Checking out-of-bound for "Alerts"
    if ( t_begin_of_data + (t_Alerts__size) > t_end_of_data || t_begin_of_data + (t_Alerts__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Alerts",
        	(0) + (t_Alerts__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_Alerts__size;
        // Parse "alerts"
        int t_alerts__size;
        t_alerts__size = t_context->connection()->cap_alert_messages_length(rec()->length());
        // Checking out-of-bound for "Alerts:alerts"
        if ( t_begin_of_data + (t_alerts__size) > t_end_of_data || t_begin_of_data + (t_alerts__size) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Alerts:alerts",
            	(0) + (t_alerts__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + t_alerts__size;
            int t_alerts__arraylength;
            t_alerts__arraylength = 0;
            alerts__elem_ = nullptr;
            int t_alerts__elem__it;
            t_alerts__elem__it = 0;
            alerts_ = new vector<Alert*>;
            const_byteptr t_alerts__elem__dataptr = t_begin_of_data;
            for (; /* forever */; ++t_alerts__elem__it) {
                // Check &until(alerts__elem__dataptr >= end_of_data)
                if ( t_alerts__elem__dataptr >= t_end_of_data ) {
                    alerts__elem_ = nullptr;
                    goto end_of_alerts;
                }
                alerts__elem_ = new Alert(rec());
                alerts__elem_->Parse(t_alerts__elem__dataptr, t_end_of_data, t_context);
                alerts_->push_back(alerts__elem_);
                t_alerts__elem__dataptr += 2;
                BINPAC_ASSERT(t_alerts__elem__dataptr <= t_end_of_data);
                alerts__elem_ = nullptr;
            }
        end_of_alerts: ;
            // Evaluate 'let' and 'withinput' fields
        }

        const_byteptr const t_dataptr_after_alerts = t_begin_of_data + (t_alerts__size);
        BINPAC_ASSERT(t_dataptr_after_alerts <= t_end_of_data);
        // Parse "rest"
        int t_rest_string_length;
        t_rest_string_length = (t_end_of_data) - (t_dataptr_after_alerts);
        int t_rest__size;
        t_rest__size = t_rest_string_length;
        // check for negative sizes
        if ( t_rest_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:49", t_rest_string_length);
        rest_.init(t_dataptr_after_alerts, t_rest_string_length);

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Alerts__size) <= t_end_of_data);
    return t_Alerts__size;
}

Alert::Alert(SSLRecord* rec) {
    level_ = 0;
    description_ = 0;
    rec_ = rec;
    proc_ = false;
}

Alert::~Alert() {
}

int Alert::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Checking out-of-bound for "Alert"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Alert",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "level"
    level_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "description"
    description_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_alert(rec(), level(), description());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

ApplicationData::ApplicationData(SSLRecord* rec) {
    rec_ = rec;
}

ApplicationData::~ApplicationData() {
}

int ApplicationData::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:65", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_ApplicationData__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_ApplicationData__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ApplicationData__size) <= t_end_of_data);
    return t_ApplicationData__size;
}

Heartbeat::Heartbeat(SSLRecord* rec) {
    type_ = 0;
    payload_length_ = 0;
    rec_ = rec;
    proc_ = false;
}

Heartbeat::~Heartbeat() {
    data_.free();
}

int Heartbeat::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder) {
    // Checking out-of-bound for "Heartbeat:payload_length"
    if ( (t_begin_of_data + 1) + (2) > t_end_of_data || (t_begin_of_data + 1) + (2) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Heartbeat:payload_length",
        	(1) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "type"
    type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "payload_length"
    payload_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));

    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 3));
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:75", t_data_string_length);
    data_.init((t_begin_of_data + 3), t_data_string_length);

    int t_Heartbeat__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 3) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Heartbeat__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_heartbeat(rec(), type(), payload_length(), data());
    BINPAC_ASSERT(t_begin_of_data + (t_Heartbeat__size) <= t_end_of_data);
    return t_Heartbeat__size;
}

UnknownRecord::UnknownRecord(SSLRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

UnknownRecord::~UnknownRecord() {
}

int UnknownRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:84", t_cont_string_length);
    cont_.init(t_begin_of_data, t_cont_string_length);

    int t_UnknownRecord__size;
    const_byteptr const t_dataptr_after_cont = t_begin_of_data + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_UnknownRecord__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_unknown_record(rec());
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownRecord__size) <= t_end_of_data);
    return t_UnknownRecord__size;
}

CiphertextRecord::CiphertextRecord(SSLRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

CiphertextRecord::~CiphertextRecord() {
}

int CiphertextRecord::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:88", t_cont_string_length);
    cont_.init(t_begin_of_data, t_cont_string_length);

    int t_CiphertextRecord__size;
    const_byteptr const t_dataptr_after_cont = t_begin_of_data + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_CiphertextRecord__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_ciphertext_record(rec(), cont_);
    BINPAC_ASSERT(t_begin_of_data + (t_CiphertextRecord__size) <= t_end_of_data);
    return t_CiphertextRecord__size;
}

SSLRecord::SSLRecord(bool is_orig) {
    head0_ = 0;
    head1_ = 0;
    head2_ = 0;
    head3_ = 0;
    head4_ = 0;
    rec_ = nullptr;
    rec__elem_ = nullptr;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    record_layer_version_ = 0;
    raw_tls_version_ = 0;
    content_type_ = 0;
    length_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

SSLRecord::~SSLRecord() {
    delete rec__elem_;
    rec__elem_ = nullptr;
    if ( rec() ) {
        for ( auto* rec__elem_ : *rec() ) {
            delete rec__elem_;
            rec__elem_ = nullptr;
        }
    }
    delete rec_;
}

bool SSLRecord::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSL* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(5, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            int t_t_var_002;
            // Parse "head0"
            // Checking out-of-bound for "SSLRecord:head0"
            if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SSLRecord:head0",
                	(0) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            head0_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
            // Parse "head1"
            // Checking out-of-bound for "SSLRecord:head1"
            if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SSLRecord:head1",
                	(1) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            head1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));
            // Parse "head2"
            // Checking out-of-bound for "SSLRecord:head2"
            if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SSLRecord:head2",
                	(2) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            head2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));
            // Parse "head3"
            // Checking out-of-bound for "SSLRecord:head3"
            if ( (t_begin_of_data + 3) + (1) > t_end_of_data || (t_begin_of_data + 3) + (1) < (t_begin_of_data + 3) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SSLRecord:head3",
                	(3) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            head3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));
            // Parse "head4"
            // Checking out-of-bound for "SSLRecord:head4"
            if ( (t_begin_of_data + 4) + (1) > t_end_of_data || (t_begin_of_data + 4) + (1) < (t_begin_of_data + 4) ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SSLRecord:head4",
                	(4) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            head4_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));
            record_layer_version_ = t_context->connection()->determine_ssl_record_layer(head0(), head1(), head2(), head3(), head4(), is_orig());
            // NOLINTBEGIN(bugprone-branch-clone)
            switch ( record_layer_version() ) {
                case ((int)0):
                    t_t_var_002 = 0;
                    break;
                case ((int)2):
                    t_t_var_002 =  (  (  ( head0() & 0x7f )  << 8 )  | head1() )  - 3;
                    break;
                default:
                    t_t_var_002 =  ( head3() << 8 )  | head4();
                    break;
            }
            // NOLINTEND(bugprone-branch-clone)
            length_ = t_t_var_002;
            t_flow_buffer->GrowFrame(length() + 5);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {





                // Parse "rec"
                int t_rec__size;
                t_rec__size = length();
                // Checking out-of-bound for "SSLRecord:rec"
                if ( (t_begin_of_data + 5) + (t_rec__size) > t_end_of_data || (t_begin_of_data + 5) + (t_rec__size) < (t_begin_of_data + 5) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("SSLRecord:rec",
                    	(5) + (t_rec__size), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = (t_begin_of_data + 5) + t_rec__size;
                    int t_t_var_003;
                    // NOLINTBEGIN(bugprone-branch-clone)
                    switch ( record_layer_version() ) {
                        case ((int)2):
                            t_t_var_003 = head2() + 300;
                            break;
                        default:
                            t_t_var_003 = head0();
                            break;
                    }
                    // NOLINTEND(bugprone-branch-clone)
                    content_type_ = t_t_var_003;
                    int t_t_var_004;
                    // NOLINTBEGIN(bugprone-branch-clone)
                    switch ( record_layer_version() ) {
                        case ((int)2):
                            t_t_var_004 = 0;
                            break;
                        default:
                            t_t_var_004 =  ( head1() << 8 )  | head2();
                            break;
                    }
                    // NOLINTEND(bugprone-branch-clone)
                    raw_tls_version_ = t_t_var_004;
                    int t_rec__arraylength;
                    t_rec__arraylength = 0;
                    rec__elem_ = nullptr;
                    int t_rec__elem__it;
                    t_rec__elem__it = 0;
                    rec_ = new vector<RecordText*>;
                    const_byteptr t_rec__elem__dataptr = (t_begin_of_data + 5);
                    for (; /* forever */; ++t_rec__elem__it) {
                        // Check &until(rec__elem__dataptr >= end_of_data)
                        if ( t_rec__elem__dataptr >= t_end_of_data ) {
                            rec__elem_ = nullptr;
                            goto end_of_rec;
                        }
                        rec__elem_ = new RecordText(this);
                        int t_rec__elem__size;
                        t_rec__elem__size = rec__elem_->Parse(t_rec__elem__dataptr, t_end_of_data, t_context, byteorder());
                        rec_->push_back(rec__elem_);
                        t_rec__elem__dataptr += t_rec__elem__size;
                        BINPAC_ASSERT(t_rec__elem__dataptr <= t_end_of_data);
                        rec__elem_ = nullptr;
                    }
                end_of_rec: ;
                    // Evaluate 'let' and 'withinput' fields
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

RecordText::RecordText(SSLRecord* rec) {
    val_case_index_ = -1;
    ciphertext_ = nullptr;
    plaintext_ = nullptr;
    rec_ = rec;
}

RecordText::~RecordText() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Clean up "ciphertext"
            {
                delete ciphertext_;
                ciphertext_ = nullptr;
            }
            break;
        default:
            // Clean up "plaintext"
            {
                delete plaintext_;
                plaintext_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int RecordText::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->determine_state(rec()->is_orig(), rec()->content_type());
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Parse "ciphertext"
            {
                ciphertext_ = new CiphertextRecord(rec());
                int t_ciphertext__size;
                t_ciphertext__size = ciphertext_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_ciphertext__size;
            }
            break;
        default:
            // Parse "plaintext"
            {
                plaintext_ = new PlaintextRecord(rec());
                int t_plaintext__size;
                t_plaintext__size = plaintext_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_plaintext__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

Handshake::Handshake(SSLRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

Handshake::~Handshake() {
    data_.free();
}

int Handshake::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:53", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_Handshake__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_Handshake__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_handshake(rec(), data(), rec()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_Handshake__size) <= t_end_of_data);
    return t_Handshake__size;
}

V2Error::V2Error(SSLRecord* rec) {
    rec_ = rec;
    error_code_ = 0;
    proc_ = false;
}

V2Error::~V2Error() {
}

int V2Error::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:61", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_V2Error__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_V2Error__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    error_code_ =  (  ( rec()->head3() << 8 )  | rec()->head4() ) ;
    proc_ = t_context->connection()->proc_alert(rec(), -1, error_code());
    BINPAC_ASSERT(t_begin_of_data + (t_V2Error__size) <= t_end_of_data);
    return t_V2Error__size;
}

V2ClientHello::V2ClientHello(SSLRecord* rec) {
    csuit_len_ = 0;
    session_len_ = 0;
    chal_len_ = 0;
    ciphers_ = nullptr;
    ciphers__elem_ = nullptr;
    session_id_ = nullptr;
    session_id__elem_ = 0;
    rec_ = rec;
    client_version_ = 0;
    proc_ = false;
}

V2ClientHello::~V2ClientHello() {
    delete ciphers__elem_;
    ciphers__elem_ = nullptr;
    if ( ciphers() ) {
        for ( auto* ciphers__elem_ : *ciphers() ) {
            delete ciphers__elem_;
            ciphers__elem_ = nullptr;
        }
    }
    delete ciphers_;
    delete session_id_;
    challenge_.free();
}

int V2ClientHello::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder) {
    int t_V2ClientHello__size;
    // Checking out-of-bound for "V2ClientHello:chal_len"
    if ( (t_begin_of_data + 4) + (2) > t_end_of_data || (t_begin_of_data + 4) + (2) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ClientHello:chal_len",
        	(4) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "csuit_len"
    csuit_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    // Parse "session_len"
    session_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
    // Parse "chal_len"
    chal_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));
    t_V2ClientHello__size = 6 + csuit_len() + session_len() + chal_len();
    // Checking out-of-bound for "V2ClientHello"
    if ( t_begin_of_data + (t_V2ClientHello__size) > t_end_of_data || t_begin_of_data + (t_V2ClientHello__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ClientHello",
        	(0) + (t_V2ClientHello__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_V2ClientHello__size;



        // Parse "ciphers"
        int t_ciphers__arraylength;
        t_ciphers__arraylength = csuit_len() / 3;
        if ( t_ciphers__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("V2ClientHello:ciphers",
              t_ciphers__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: V2ClientHello:ciphers
        if ( t_ciphers__arraylength > ((t_end_of_data - (t_begin_of_data + 6)) / 3) )
            throw binpac::ExceptionOutOfBound("V2ClientHello:ciphers",
              t_ciphers__arraylength, (t_end_of_data) - ((t_begin_of_data + 6)));
        ciphers__elem_ = nullptr;
        int t_ciphers__elem__it;
        t_ciphers__elem__it = 0;
        int t_ciphers__size;
        ciphers_ = new vector<uint24*>;
        ciphers_->reserve(t_ciphers__arraylength);
        const_byteptr t_ciphers__elem__dataptr = (t_begin_of_data + 6);
        for (; t_ciphers__elem__it < t_ciphers__arraylength; ++t_ciphers__elem__it) {
            ciphers__elem_ = new uint24();
            ciphers__elem_->Parse(t_ciphers__elem__dataptr, t_end_of_data);
            ciphers_->push_back(ciphers__elem_);
            t_ciphers__elem__dataptr += 3;
            BINPAC_ASSERT(t_ciphers__elem__dataptr <= t_end_of_data);
            ciphers__elem_ = nullptr;
        }
    end_of_ciphers: ;
        t_ciphers__size = t_ciphers__elem__dataptr - ((t_begin_of_data + 6));
        // Evaluate 'let' and 'withinput' fields

        const_byteptr const t_dataptr_after_ciphers = (t_begin_of_data + 6) + (t_ciphers__size);
        BINPAC_ASSERT(t_dataptr_after_ciphers <= t_end_of_data);
        // Parse "session_id"
        int t_session_id__arraylength;
        t_session_id__arraylength = session_len();
        if ( t_session_id__arraylength < 0 ) {
            throw binpac::ExceptionOutOfBound("V2ClientHello:session_id",
              t_session_id__arraylength, (t_end_of_data) - (t_begin_of_data));
        }
        // Check bounds for static-size array: V2ClientHello:session_id
        if ( t_session_id__arraylength > ((t_end_of_data - t_dataptr_after_ciphers) / 1) )
            throw binpac::ExceptionOutOfBound("V2ClientHello:session_id",
              t_session_id__arraylength, (t_end_of_data) - (t_dataptr_after_ciphers));
        session_id__elem_ = 0;
        int t_session_id__elem__it;
        t_session_id__elem__it = 0;
        int t_session_id__size;
        session_id_ = new vector<uint8>;
        session_id_->reserve(t_session_id__arraylength);
        const_byteptr t_session_id__elem__dataptr = t_dataptr_after_ciphers;
        for (; t_session_id__elem__it < t_session_id__arraylength; ++t_session_id__elem__it) {
            session_id__elem_ = *(reinterpret_cast<uint8 const*>(t_session_id__elem__dataptr));
            session_id_->push_back(session_id__elem_);
            t_session_id__elem__dataptr += 1;
            BINPAC_ASSERT(t_session_id__elem__dataptr <= t_end_of_data);
        }
    end_of_session_id: ;
        t_session_id__size = t_session_id__elem__dataptr - (t_dataptr_after_ciphers);
        // Evaluate 'let' and 'withinput' fields

        const_byteptr const t_dataptr_after_session_id = t_dataptr_after_ciphers + (t_session_id__size);
        BINPAC_ASSERT(t_dataptr_after_session_id <= t_end_of_data);
        // Parse "challenge"
        int t_challenge__size;
        t_challenge__size = chal_len();
        // Checking out-of-bound for "V2ClientHello:challenge"
        if ( t_dataptr_after_session_id + (t_challenge__size) > t_end_of_data || t_dataptr_after_session_id + (t_challenge__size) < t_dataptr_after_session_id ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("V2ClientHello:challenge",
            	((t_dataptr_after_session_id - t_begin_of_data)) + (t_challenge__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_dataptr_after_session_id + t_challenge__size;
            int t_challenge_string_length;
            t_challenge_string_length = chal_len();
            // check for negative sizes
            if ( t_challenge_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:78", t_challenge_string_length);
            challenge_.init(t_dataptr_after_session_id, t_challenge_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
        client_version_ =  ( rec()->head3() << 8 )  | rec()->head4();
        proc_ = t_context->connection()->proc_client_hello(client_version(), 0, challenge(), session_id(), nullptr, ciphers(), nullptr);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_V2ClientHello__size) <= t_end_of_data);
    return t_V2ClientHello__size;
}

V2ServerHello::V2ServerHello(SSLRecord* rec) {
    server_version_ = 0;
    cert_len_ = 0;
    ciphers_len_ = 0;
    conn_id_len_ = 0;
    ciphers_ = nullptr;
    ciphers__elem_ = nullptr;
    rec_ = rec;
    session_id_hit_ = 0;
    cert_type_ = 0;
    check_v2_ = false;
    proc_ = false;
    has_proc_ = false;
    cert_ = false;
    has_cert_ = false;
}

V2ServerHello::~V2ServerHello() {
    cert_data_.free();
    delete ciphers__elem_;
    ciphers__elem_ = nullptr;
    if ( ciphers() ) {
        for ( auto* ciphers__elem_ : *ciphers() ) {
            delete ciphers__elem_;
            ciphers__elem_ = nullptr;
        }
    }
    delete ciphers_;
    conn_id_data_.free();
}

int V2ServerHello::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder) {
    // Checking out-of-bound for "V2ServerHello:conn_id_len"
    if ( (t_begin_of_data + 6) + (2) > t_end_of_data || (t_begin_of_data + 6) + (2) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ServerHello:conn_id_len",
        	(6) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "server_version"
    server_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "cert_len"
    cert_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "ciphers_len"
    ciphers_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "conn_id_len"
    conn_id_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 6))));

    // Parse "cert_data"
    int t_cert_data__size;
    t_cert_data__size = cert_len();
    // Checking out-of-bound for "V2ServerHello:cert_data"
    if ( (t_begin_of_data + 8) + (t_cert_data__size) > t_end_of_data || (t_begin_of_data + 8) + (t_cert_data__size) < (t_begin_of_data + 8) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ServerHello:cert_data",
        	(8) + (t_cert_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 8) + t_cert_data__size;
        int t_cert_data_string_length;
        t_cert_data_string_length = cert_len();
        // check for negative sizes
        if ( t_cert_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:96", t_cert_data_string_length);
        cert_data_.init((t_begin_of_data + 8), t_cert_data_string_length);
    }

    const_byteptr const t_dataptr_after_cert_data = (t_begin_of_data + 8) + (t_cert_data__size);
    BINPAC_ASSERT(t_dataptr_after_cert_data <= t_end_of_data);
    // Parse "ciphers"
    int t_ciphers__arraylength;
    t_ciphers__arraylength = ciphers_len() / 3;
    if ( t_ciphers__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("V2ServerHello:ciphers",
          t_ciphers__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: V2ServerHello:ciphers
    if ( t_ciphers__arraylength > ((t_end_of_data - t_dataptr_after_cert_data) / 3) )
        throw binpac::ExceptionOutOfBound("V2ServerHello:ciphers",
          t_ciphers__arraylength, (t_end_of_data) - (t_dataptr_after_cert_data));
    ciphers__elem_ = nullptr;
    int t_ciphers__elem__it;
    t_ciphers__elem__it = 0;
    int t_ciphers__size;
    ciphers_ = new vector<uint24*>;
    ciphers_->reserve(t_ciphers__arraylength);
    const_byteptr t_ciphers__elem__dataptr = t_dataptr_after_cert_data;
    for (; t_ciphers__elem__it < t_ciphers__arraylength; ++t_ciphers__elem__it) {
        ciphers__elem_ = new uint24();
        ciphers__elem_->Parse(t_ciphers__elem__dataptr, t_end_of_data);
        ciphers_->push_back(ciphers__elem_);
        t_ciphers__elem__dataptr += 3;
        BINPAC_ASSERT(t_ciphers__elem__dataptr <= t_end_of_data);
        ciphers__elem_ = nullptr;
    }
end_of_ciphers: ;
    t_ciphers__size = t_ciphers__elem__dataptr - (t_dataptr_after_cert_data);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_ciphers = t_dataptr_after_cert_data + (t_ciphers__size);
    BINPAC_ASSERT(t_dataptr_after_ciphers <= t_end_of_data);
    // Parse "conn_id_data"
    int t_conn_id_data__size;
    t_conn_id_data__size = conn_id_len();
    // Checking out-of-bound for "V2ServerHello:conn_id_data"
    if ( t_dataptr_after_ciphers + (t_conn_id_data__size) > t_end_of_data || t_dataptr_after_ciphers + (t_conn_id_data__size) < t_dataptr_after_ciphers ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ServerHello:conn_id_data",
        	((t_dataptr_after_ciphers - t_begin_of_data)) + (t_conn_id_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_dataptr_after_ciphers + t_conn_id_data__size;
        int t_conn_id_data_string_length;
        t_conn_id_data_string_length = conn_id_len();
        // check for negative sizes
        if ( t_conn_id_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:98", t_conn_id_data_string_length);
        conn_id_data_.init(t_dataptr_after_ciphers, t_conn_id_data_string_length);
    }

    int t_V2ServerHello__size;
    const_byteptr const t_dataptr_after_conn_id_data = t_dataptr_after_ciphers + (t_conn_id_data__size);
    BINPAC_ASSERT(t_dataptr_after_conn_id_data <= t_end_of_data);
    t_V2ServerHello__size = t_dataptr_after_conn_id_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    session_id_hit_ = rec()->head3();
    cert_type_ = rec()->head4();
    check_v2_ = t_context->connection()->proc_check_v2_server_hello_version(server_version());
    has_proc_ =  ( check_v2() == true ) ;
    if ( has_proc() ) {
        proc_ = t_context->connection()->proc_server_hello(server_version(), true, conn_id_data(), nullptr, nullptr, ciphers(), 0);
    }
    has_cert_ =  ( check_v2() == true ) ;
    if ( has_cert() ) {
        cert_ = t_context->connection()->proc_v2_certificate(rec()->is_orig(), cert_data());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_V2ServerHello__size) <= t_end_of_data);
    return t_V2ServerHello__size;
}

V2ClientMasterKey::V2ClientMasterKey(SSLRecord* rec) {
    cipher_kind_8_ = 0;
    cl_key_len_ = 0;
    en_key_len_ = 0;
    key_arg_len_ = 0;
    rec_ = rec;
    cipher_kind_ = 0;
    state_changed_client_ = false;
    state_changed_server_ = false;
    proc_ = false;
}

V2ClientMasterKey::~V2ClientMasterKey() {
}

int V2ClientMasterKey::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder) {
    int t_V2ClientMasterKey__size;
    // Checking out-of-bound for "V2ClientMasterKey:key_arg_len"
    if ( (t_begin_of_data + 5) + (2) > t_end_of_data || (t_begin_of_data + 5) + (2) < (t_begin_of_data + 5) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ClientMasterKey:key_arg_len",
        	(5) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cl_key_len"
    cl_key_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 1))));
    // Parse "en_key_len"
    en_key_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 3))));
    // Parse "key_arg_len"
    key_arg_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 5))));
    t_V2ClientMasterKey__size = 7 + cl_key_len() + en_key_len() + key_arg_len();
    // Checking out-of-bound for "V2ClientMasterKey"
    if ( t_begin_of_data + (t_V2ClientMasterKey__size) > t_end_of_data || t_begin_of_data + (t_V2ClientMasterKey__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("V2ClientMasterKey",
        	(0) + (t_V2ClientMasterKey__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_V2ClientMasterKey__size;
        // Parse "cipher_kind_8"
        cipher_kind_8_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));




        // Parse "cl_key_data"
        int t_cl_key_data__size;
        t_cl_key_data__size = cl_key_len();
        // Checking out-of-bound for "V2ClientMasterKey:cl_key_data"
        if ( (t_begin_of_data + 7) + (t_cl_key_data__size) > t_end_of_data || (t_begin_of_data + 7) + (t_cl_key_data__size) < (t_begin_of_data + 7) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("V2ClientMasterKey:cl_key_data",
            	(7) + (t_cl_key_data__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 7) + t_cl_key_data__size;
            int t_cl_key_data_string_length;
            t_cl_key_data_string_length = cl_key_len();
            // check for negative sizes
            if ( t_cl_key_data_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:114", t_cl_key_data_string_length);
            cl_key_data_.init((t_begin_of_data + 7), t_cl_key_data_string_length);
        }

        const_byteptr const t_dataptr_after_cl_key_data = (t_begin_of_data + 7) + (t_cl_key_data__size);
        BINPAC_ASSERT(t_dataptr_after_cl_key_data <= t_end_of_data);
        // Parse "en_key_data"
        int t_en_key_data__size;
        t_en_key_data__size = en_key_len();
        // Checking out-of-bound for "V2ClientMasterKey:en_key_data"
        if ( t_dataptr_after_cl_key_data + (t_en_key_data__size) > t_end_of_data || t_dataptr_after_cl_key_data + (t_en_key_data__size) < t_dataptr_after_cl_key_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("V2ClientMasterKey:en_key_data",
            	((t_dataptr_after_cl_key_data - t_begin_of_data)) + (t_en_key_data__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_dataptr_after_cl_key_data + t_en_key_data__size;
            int t_en_key_data_string_length;
            t_en_key_data_string_length = en_key_len();
            // check for negative sizes
            if ( t_en_key_data_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:115", t_en_key_data_string_length);
            en_key_data_.init(t_dataptr_after_cl_key_data, t_en_key_data_string_length);
        }

        const_byteptr const t_dataptr_after_en_key_data = t_dataptr_after_cl_key_data + (t_en_key_data__size);
        BINPAC_ASSERT(t_dataptr_after_en_key_data <= t_end_of_data);
        // Parse "key_arg_data"
        int t_key_arg_data__size;
        t_key_arg_data__size = key_arg_len();
        // Checking out-of-bound for "V2ClientMasterKey:key_arg_data"
        if ( t_dataptr_after_en_key_data + (t_key_arg_data__size) > t_end_of_data || t_dataptr_after_en_key_data + (t_key_arg_data__size) < t_dataptr_after_en_key_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("V2ClientMasterKey:key_arg_data",
            	((t_dataptr_after_en_key_data - t_begin_of_data)) + (t_key_arg_data__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_dataptr_after_en_key_data + t_key_arg_data__size;
            int t_key_arg_data_string_length;
            t_key_arg_data_string_length = key_arg_len();
            // check for negative sizes
            if ( t_key_arg_data_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:116", t_key_arg_data_string_length);
            key_arg_data_.init(t_dataptr_after_en_key_data, t_key_arg_data_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
        cipher_kind_ =  (  (  ( rec()->head3() << 16 )  |  ( rec()->head4() << 8 )  )  | cipher_kind_8() ) ;
        state_changed_client_ = t_context->connection()->startEncryption(true);
        state_changed_server_ = t_context->connection()->startEncryption(false);
        proc_ = t_context->connection()->proc_v2_client_master_key(rec(), cipher_kind());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_V2ClientMasterKey__size) <= t_end_of_data);
    return t_V2ClientMasterKey__size;
}

SSLPDU::SSLPDU(bool is_orig) {
    records_ = nullptr;
    records__elem_ = nullptr;
    records__arraylength_ = 0;
    records__elem__it_ = 0;
    records__elem__it_ = -1;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

SSLPDU::~SSLPDU() {
    delete records__elem_;
    records__elem_ = nullptr;
    if ( records_ ) {
        for ( auto* records__elem_ : *records_ ) {
            delete records__elem_;
            records__elem_ = nullptr;
        }
    }
    delete records_;
}

bool SSLPDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSL* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "records"
        if ( ! records_ ) {
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_records_parsing_complete;
        t_records_parsing_complete = false;
        if ( records__elem__it_ < 0 ) {
            // Initialize only once
            records__elem__it_ = 0;
            records_ = new vector<SSLRecord*>;
        }
        for (; /* forever */; ++records__elem__it_) {
            if ( ! records__elem_ ) {
                records__elem_ = new SSLRecord(is_orig());
            }
            bool t_records__elem_parsing_complete;
            t_records__elem_parsing_complete = false;
            while ( ! t_records__elem_parsing_complete && t_flow_buffer->ready() ) {
                const_byteptr t_begin_of_data = t_flow_buffer->begin();
                const_byteptr t_end_of_data = t_flow_buffer->end();
                t_records__elem_parsing_complete = records__elem_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_records__elem_parsing_complete ) {
                }
            }
            if ( ! t_records__elem_parsing_complete )
                goto need_more_data;
            delete records__elem_;
            records__elem_ = nullptr;
        }
    end_of_records: ;
        if ( t_records_parsing_complete ) {
            // Evaluate 'let' and 'withinput' fields
        }
        if ( ! (t_records_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

SSL_Flow::SSL_Flow(SSL_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

SSL_Flow::~SSL_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void SSL_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new SSLPDU(is_orig());
                context_ = new ContextSSL(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void SSL_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void SSL_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
uint24::uint24() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
}

uint24::~uint24() {
}

int uint24::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint24"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint24",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

uint48::uint48() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
    byte4_ = 0;
    byte5_ = 0;
    byte6_ = 0;
}

uint48::~uint48() {
}

int uint48::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint48"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint48",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "byte4"
    byte4_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "byte5"
    byte5_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "byte6"
    byte6_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}


string orig_label(bool is_orig)
		{
		return is_orig ? "originator" :"responder";
		}

zeek::StringVal* to_string_val(vector<uint8>* data) {

	char tmp[32];
	memset(tmp, 0, sizeof(tmp));

	// Just return an empty string if the string is longer than 32 bytes
	if ( data && data->size() <= 32 )
		{
		for ( unsigned int i = data->size(); i > 0; --i )
			tmp[i-1] = (*data)[i-1];
		}

	return new zeek::StringVal(32, tmp);
	
}

bool version_ok(uint16 vers) {

	if ( vers >> 8 == 0x7F ) // 1.3 draft
		return true;

	switch ( vers ) {
	case SSLv20:
	case SSLv30:
	case TLSv10:
	case TLSv11:
	case TLSv12:
	case TLSv13:
	case DTLSv10:
	case DTLSv12:
	case DTLSv13:
		return true;

	default:
		return false;
	}
	
}

uint32 const MAX_DTLS_HANDSHAKE_RECORD = 100000;
} // namespace SSL
}  // namespace binpac
