// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/analyzer/protocol/ssl/tls-handshake_pac.h"

namespace binpac {






namespace TLSHandshake {
ContextTLSHandshake::ContextTLSHandshake(Handshake_Conn* connection, Handshake_Flow* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextTLSHandshake::~ContextTLSHandshake() {
}

Handshake_Conn::Handshake_Conn(ZeekAnalyzer const& zeek_analyzer) {
    upflow_ = new Handshake_Flow(this, true);
    downflow_ = new Handshake_Flow(this, false);
    zeek_analyzer_ = zeek_analyzer;

		flipped_ = false;
		already_alerted_ = false;
		chosen_cipher_ = NO_CHOSEN_CIPHER;
		chosen_version_ = UNKNOWN_VERSION;

		record_version_ = 0;
		gmt_unix_time_ = 0;
	
}

Handshake_Conn::~Handshake_Conn() {

		client_random_.free();
		server_random_.free();
	
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void Handshake_Conn::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void Handshake_Conn::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void Handshake_Conn::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

int Handshake_Conn::chosen_cipher() {
 return chosen_cipher_; 
}

bool Handshake_Conn::set_cipher(uint32 cipher) {

		chosen_cipher_ = cipher;
		return true;
		
}

uint16 Handshake_Conn::chosen_version() {
 return chosen_version_; 
}

bool Handshake_Conn::set_version(uint16 version) {

		if ( chosen_version_ != UNKNOWN_VERSION )
			return false;

		chosen_version_ = version;
		return true;
		
}

bool Handshake_Conn::check_flipped(bool desired, bool is_orig) {

		if ( flipped_ )
			{
			if ( desired == is_orig )
				{
				// well, I guess we get to flip it back - and alert on this
				flipped_ = false;
				zeek::BifEvent::enqueue_ssl_connection_flipped(zeek_analyzer(), zeek_analyzer()->Conn());
				if ( ! already_alerted_ )
					{
					already_alerted_ = true;
					zeek_analyzer()->Weird("SSL_unclear_connection_direction");
					}
				}
			}
			else
			{
			if ( desired != is_orig )
				{
				flipped_ = true;
				zeek::BifEvent::enqueue_ssl_connection_flipped(zeek_analyzer(), zeek_analyzer()->Conn());
				}
			}

		return true;
		
}

bool Handshake_Conn::flipped() {

		return flipped_;
		
}

uint16 Handshake_Conn::record_version() {
 return record_version_; 
}

bool Handshake_Conn::set_record_version(uint16 version) {

		record_version_ = version;
		return true;
		
}

bytestring Handshake_Conn::client_random() {
 return client_random_; 
}

bool Handshake_Conn::set_client_random(bytestring const& client_random) {

		client_random_.free();
		client_random_.init(client_random.data(), client_random.length());
		return true;
		
}

bytestring Handshake_Conn::server_random() {
 return server_random_; 
}

bool Handshake_Conn::set_server_random(bytestring const& server_random) {

		server_random_.free();
		server_random_.init(server_random.data(), server_random.length());
		return true;
		
}

uint32 Handshake_Conn::gmt_unix_time() {
 return gmt_unix_time_; 
}

bool Handshake_Conn::set_gmt_unix_time(uint32 ts) {

		gmt_unix_time_ = ts;
		return true;
		
}

bool Handshake_Conn::proc_certificate(bool is_orig, bool is_flipped, vector<bytestring>* certificates) {

	if ( certificates->size() == 0 )
		return true;

	zeek::ODesc common;
	common.AddRaw("Analyzer::ANALYZER_SSL");
	common.Add(zeek_analyzer()->Conn()->StartTime());
	common.AddRaw(is_orig ^ is_flipped ? "T" : "F", 1);
	zeek_analyzer()->Conn()->IDString(&common);

	static const string user_mime = "application/x-x509-user-cert";
	static const string ca_mime = "application/x-x509-ca-cert";

	for ( unsigned int i = 0; i < certificates->size(); ++i )
		{
		const bytestring& cert = (*certificates)[i];

		if ( cert.length() <= 0 )
			{
			zeek::reporter->Weird(zeek_analyzer()->Conn(), "zero_length_certificate", "",
			                      zeek_analyzer()->GetAnalyzerName());
			continue;
			}

		zeek::ODesc file_handle;
		file_handle.Add(common.Description());
		file_handle.Add(i);

		string file_id = zeek::file_mgr->HashHandle(file_handle.Description());

		zeek::file_mgr->DataIn(reinterpret_cast<const u_char*>(cert.data()),
		                       cert.length(), zeek_analyzer()->GetAnalyzerTag(),
		                       zeek_analyzer()->Conn(), is_orig ^ is_flipped,
		                       file_id, i == 0 ? user_mime : ca_mime);
		zeek::file_mgr->EndOfFile(file_id);
		}
	return true;
	
}

bool Handshake_Conn::proc_client_hello(uint16 version, double ts, bytestring const& client_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, vector<uint8>* compression_methods) {

		if ( ! version_ok(version) )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unsupported client SSL version 0x%04x", version));
			zeek_analyzer()->SetSkip(true);
			}
		else
			zeek_analyzer()->AnalyzerConfirmation();

		if ( ssl_client_hello )
			{
			vector<int> cipher_suites;

			if ( cipher_suites16 )
				std::ranges::copy(*cipher_suites16, std::back_inserter(cipher_suites));
			else
				std::ranges::transform(*cipher_suites24, std::back_inserter(cipher_suites), to_int());

			auto cipher_vec = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

			for ( unsigned int i = 0; i < cipher_suites.size(); ++i )
				{
				auto cipher = zeek::val_mgr->Count(cipher_suites[i]);
				cipher_vec->Assign(i, std::move(cipher));
				}

			auto comp_vec = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

			if ( compression_methods )
				{
				for ( unsigned int i = 0; i < compression_methods->size(); ++i )
					{
					auto comp = zeek::val_mgr->Count((*compression_methods)[i]);
					comp_vec->Assign(i, comp);
					}
				}

			set_client_random(client_random);
			set_gmt_unix_time(ts);
			zeek::BifEvent::enqueue_ssl_client_hello(zeek_analyzer(), zeek_analyzer()->Conn(),
							version, record_version(), ts,
							zeek::make_intrusive<zeek::StringVal>(client_random.length(),
							                                      reinterpret_cast<const char*>(client_random.data())),
							{zeek::AdoptRef{}, to_string_val(session_id)},
							std::move(cipher_vec), std::move(comp_vec));
			}

		return true;
		
}

bool Handshake_Conn::proc_server_hello(uint16 version, bool v2, bytestring const& server_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, uint8 comp_method) {

		if ( ! version_ok(version) )
			{
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unsupported server SSL version 0x%04x", version));
			zeek_analyzer()->SetSkip(true);
			}

		if ( ssl_server_hello )
			{
			vector<int>* ciphers = new vector<int>();

			if ( cipher_suites16 )
				std::ranges::copy(*cipher_suites16, std::back_inserter(*ciphers));
			else
				std::ranges::transform(*cipher_suites24, std::back_inserter(*ciphers), to_int());

			uint32 ts = 0;
			if ( v2 == 0 && server_random.length() >= 4 )
				ts = ntohl(*(reinterpret_cast<uint32*>(server_random.data())));

			set_server_random(server_random);
			zeek::BifEvent::enqueue_ssl_server_hello(zeek_analyzer(),
							zeek_analyzer()->Conn(),
							version, record_version(), ts,
							zeek::make_intrusive<zeek::StringVal>(server_random.length(),
							                                      reinterpret_cast<const char*>(server_random.data())),
							{zeek::AdoptRef{}, to_string_val(session_id)},
							ciphers->size()==0 ? 0 : ciphers->at(0), comp_method);

			delete ciphers;
			}

		return true;
		
}

bool Handshake_Conn::proc_session_ticket_handshake(SessionTicketHandshake* rec, bool is_orig) {

		if ( ssl_session_ticket_handshake )
			{
			zeek::BifEvent::enqueue_ssl_session_ticket_handshake(zeek_analyzer(),
							zeek_analyzer()->Conn(),
							rec->ticket_lifetime_hint(),
							zeek::make_intrusive<zeek::StringVal>(rec->data().length(), reinterpret_cast<const char*>(rec->data().data())));
			}
		return true;
		
}

bool Handshake_Conn::proc_ssl_extension(HandshakeRecord* rec, int type, const_bytestring const& sourcedata) {

		// We cheat a little bit here. We want to throw this event
		// for every extension we encounter, even those that are
		// handled by more specialized events later. To access the
		// parsed data, we use sourcedata, which contains the whole
		// data blob of the extension, including headers. We skip
		// over those (4 bytes).
		size_t length = sourcedata.length();
		if ( length < 4 )
			{
			// This should be impossible due to the binpac parser
			// and protocol description
			zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("Impossible extension length: %zu", length));
			zeek_analyzer()->SetSkip(true);
			return true;
			}

		length -= 4;
		const unsigned char* data = sourcedata.begin() + 4;

		if ( ssl_extension )
			zeek::BifEvent::enqueue_ssl_extension(zeek_analyzer(),
						zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, type,
						zeek::make_intrusive<zeek::StringVal>(length, reinterpret_cast<const char*>(data)));
		return true;
		
}

bool Handshake_Conn::proc_ec_point_formats(HandshakeRecord* rec, vector<uint8>* point_format_list) {

		if ( ! ssl_extension_ec_point_formats )
			return true;

		auto points = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		if ( point_format_list )
			{
			for ( unsigned int i = 0; i < point_format_list->size(); ++i )
				points->Assign(i, zeek::val_mgr->Count((*point_format_list)[i]));
			}

		zeek::BifEvent::enqueue_ssl_extension_ec_point_formats(zeek_analyzer(), zeek_analyzer()->Conn(),
		   rec->is_orig() ^ flipped_, std::move(points));

		return true;
		
}

bool Handshake_Conn::proc_elliptic_curves(HandshakeRecord* rec, vector<uint16>* list) {

		if ( ! ssl_extension_elliptic_curves )
			return true;

		auto curves = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		if ( list )
			{
			for ( unsigned int i = 0; i < list->size(); ++i )
				curves->Assign(i, zeek::val_mgr->Count((*list)[i]));
			}

		zeek::BifEvent::enqueue_ssl_extension_elliptic_curves(zeek_analyzer(), zeek_analyzer()->Conn(),
		   rec->is_orig() ^ flipped_, std::move(curves));

		return true;
		
}

bool Handshake_Conn::proc_client_key_share(HandshakeRecord* rec, vector<KeyShareEntry*>* keyshare) {

		if ( ! ssl_extension_key_share )
			return true;

		auto nglist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		if ( keyshare )
			{
			for ( unsigned int i = 0; i < keyshare->size(); ++i )
				nglist->Assign(i, zeek::val_mgr->Count((*keyshare)[i]->namedgroup()));
			}

		zeek::BifEvent::enqueue_ssl_extension_key_share(zeek_analyzer(), zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, std::move(nglist));

		return true;
		
}

bool Handshake_Conn::proc_server_key_share(HandshakeRecord* rec, KeyShareEntry* keyshare) {

		if ( ! ssl_extension_key_share )
			return true;

		auto nglist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		nglist->Assign(0u, zeek::val_mgr->Count(keyshare->namedgroup()));
		zeek::BifEvent::enqueue_ssl_extension_key_share(zeek_analyzer(), zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, std::move(nglist));
		return true;
		
}

bool Handshake_Conn::proc_hello_retry_request_key_share(HandshakeRecord* rec, uint16 namedgroup) {

		if ( ! ssl_extension_key_share )
			return true;

		auto nglist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		nglist->Assign(0u, zeek::val_mgr->Count(namedgroup));
		zeek::BifEvent::enqueue_ssl_extension_key_share(zeek_analyzer(), zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, std::move(nglist));
		return true;
		
}

bool Handshake_Conn::proc_signature_algorithm(HandshakeRecord* rec, vector<SignatureAndHashAlgorithm*>* supported_signature_algorithms) {

		if ( ! ssl_extension_signature_algorithm )
			return true;

		auto slist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::find_type<zeek::VectorType>("signature_and_hashalgorithm_vec"));

		if ( supported_signature_algorithms )
			{
			for ( unsigned int i = 0; i < supported_signature_algorithms->size(); ++i )
				{
				auto el = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSL::SignatureAndHashAlgorithm);
				el->Assign(0, (*supported_signature_algorithms)[i]->HashAlgorithm());
				el->Assign(1, (*supported_signature_algorithms)[i]->SignatureAlgorithm());
				slist->Assign(i, std::move(el));
				}
			}

		zeek::BifEvent::enqueue_ssl_extension_signature_algorithm(zeek_analyzer(), zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, std::move(slist));

		return true;
		
}

bool Handshake_Conn::proc_apnl(HandshakeRecord* rec, vector<ProtocolName*>* protocols) {

		if ( ! ssl_extension_application_layer_protocol_negotiation )
			return true;

		auto plist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

		if ( protocols )
			{
			for ( unsigned int i = 0; i < protocols->size(); ++i )
				plist->Assign(i, zeek::make_intrusive<zeek::StringVal>((*protocols)[i]->name().length(), reinterpret_cast<const char*>((*protocols)[i]->name().data())));
			}

		zeek::BifEvent::enqueue_ssl_extension_application_layer_protocol_negotiation(zeek_analyzer(), zeek_analyzer()->Conn(),
											rec->is_orig() ^ flipped_, std::move(plist));

		return true;
		
}

bool Handshake_Conn::proc_server_name(HandshakeRecord* rec, vector<ServerName*>* list) {

		auto servers = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

		if ( list )
			{
			for ( unsigned int i = 0, j = 0; i < list->size(); ++i )
				{
				ServerName* servername = (*list)[i];
				if ( servername->name_type() != 0 )
					{
					zeek_analyzer()->Weird("ssl_ext_unknown_server_name_type", zeek::util::fmt("%d", servername->name_type()));
					continue;
					}

				if ( servername->host_name() )
					servers->Assign(j++, zeek::make_intrusive<zeek::StringVal>(servername->host_name()->host_name().length(), reinterpret_cast<const char*>(servername->host_name()->host_name().data())));
				else
					zeek_analyzer()->Weird("Empty server_name extension in ssl connection");
				}
			}

		if ( ssl_extension_server_name )
			zeek::BifEvent::enqueue_ssl_extension_server_name(zeek_analyzer(), zeek_analyzer()->Conn(),
		   	   rec->is_orig() ^ flipped_, std::move(servers));

		return true;
		
}

bool Handshake_Conn::proc_supported_versions(HandshakeRecord* rec, vector<uint16>* versions_list) {

		if ( ! ssl_extension_supported_versions )
			return true;

		auto versions = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		if ( versions_list )
			{
			for ( unsigned int i = 0; i < versions_list->size(); ++i )
				versions->Assign(i, zeek::val_mgr->Count((*versions_list)[i]));
			}

		zeek::BifEvent::enqueue_ssl_extension_supported_versions(zeek_analyzer(), zeek_analyzer()->Conn(),
			rec->is_orig() ^ flipped_, std::move(versions));

		return true;
		
}

bool Handshake_Conn::proc_one_supported_version(HandshakeRecord* rec, uint16 version) {

		if ( ! ssl_extension_supported_versions )
			return true;

		auto versions = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);
		versions->Assign(0u, zeek::val_mgr->Count(version));

		zeek::BifEvent::enqueue_ssl_extension_supported_versions(zeek_analyzer(), zeek_analyzer()->Conn(),
			rec->is_orig() ^ flipped_, std::move(versions));

		return true;
		
}

bool Handshake_Conn::proc_psk_key_exchange_modes(HandshakeRecord* rec, vector<uint8>* mode_list) {

		if ( ! ssl_extension_psk_key_exchange_modes )
			return true;

		auto modes = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

		if ( mode_list )
			{
			for ( unsigned int i = 0; i < mode_list->size(); ++i )
				modes->Assign(i, zeek::val_mgr->Count((*mode_list)[i]));
			}

		zeek::BifEvent::enqueue_ssl_extension_psk_key_exchange_modes(zeek_analyzer(), zeek_analyzer()->Conn(),
			rec->is_orig() ^ flipped_, std::move(modes));

		return true;
		
}

bool Handshake_Conn::proc_v3_certificate(bool is_orig, vector<X509Certificate*>* cl) {

		vector<X509Certificate*>* certs = cl;
		vector<bytestring>* cert_list = new vector<bytestring>();

		std::ranges::transform(*certs, std::back_inserter(*cert_list), extract_certs());

		bool ret = proc_certificate(is_orig, flipped_, cert_list);
		delete cert_list;
		return ret;
		
}

bool Handshake_Conn::proc_unknown_handshake(HandshakeRecord* hs, bool is_orig) {

		zeek_analyzer()->AnalyzerViolation(zeek::util::fmt("unknown handshake message (%d) from %s",
			hs->msg_type(), orig_label(is_orig).c_str()));
		return true;
		
}

bool Handshake_Conn::proc_certificate_status(HandshakeRecord* rec, uint8 status_type, bytestring const& response) {

		zeek::ODesc common;
		common.AddRaw("Analyzer::ANALYZER_SSL");
		common.Add(zeek_analyzer()->Conn()->StartTime());
		common.AddRaw("F");
		zeek_analyzer()->Conn()->IDString(&common);

		if ( status_type == 1 && response.length() > 0 ) // ocsp
			{
			zeek::ODesc file_handle;
			file_handle.Add(common.Description());
			file_handle.Add("ocsp");

			string file_id = zeek::file_mgr->HashHandle(file_handle.Description());

			zeek::file_mgr->DataIn(reinterpret_cast<const u_char*>(response.data()),
			                       response.length(), zeek_analyzer()->GetAnalyzerTag(),
			                       zeek_analyzer()->Conn(), false, file_id, "application/ocsp-response");

			if ( ssl_stapled_ocsp )
				zeek::BifEvent::enqueue_ssl_stapled_ocsp(zeek_analyzer(),
				        zeek_analyzer()->Conn(),
				        rec->is_orig() ^ flipped_,
				        zeek::make_intrusive<zeek::StringVal>(response.length(), reinterpret_cast<const char*>(response.data())));

			zeek::file_mgr->EndOfFile(file_id);
			}
		else if ( response.length() == 0 )
			{
			zeek_analyzer()->Weird("SSL_zero_length_stapled_OCSP_message");
			}

		return true;
		
}

bool Handshake_Conn::proc_ecdhe_server_key_exchange(EcdheServerKeyExchange* kex) {

		if ( kex->curve_type() != NAMED_CURVE )
			return true;

		if ( ssl_ecdh_server_params )
			zeek::BifEvent::enqueue_ssl_ecdh_server_params(zeek_analyzer(),
			                                         zeek_analyzer()->Conn(),
			                                         kex->params()->curve(),
			                                         zeek::make_intrusive<zeek::StringVal>(kex->params()->point().length(), reinterpret_cast<const char*>(kex->params()->point().data())));

		if ( ssl_server_signature )
			{
			auto ha = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSL::SignatureAndHashAlgorithm);

			if ( kex->signed_params()->uses_signature_and_hashalgorithm() )
				{
				ha->Assign(0, kex->signed_params()->algorithm()->HashAlgorithm());
				ha->Assign(1, kex->signed_params()->algorithm()->SignatureAlgorithm());
				}
			else
				{
				// set to impossible value
				ha->Assign(0, 256);
				ha->Assign(1, 256);
				}

			zeek::BifEvent::enqueue_ssl_server_signature(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       std::move(ha),
			                                       zeek::make_intrusive<zeek::StringVal>(kex->signed_params()->signature().length(), reinterpret_cast<const char*>(kex->signed_params()->signature().data())));
			}

		return true;
		
}

bool Handshake_Conn::proc_ecdh_anon_server_key_exchange(EcdhAnonServerKeyExchange* kex) {

		if ( kex->curve_type() != NAMED_CURVE )
			return true;

		if ( ssl_ecdh_server_params )
			zeek::BifEvent::enqueue_ssl_ecdh_server_params(zeek_analyzer(),
			                                         zeek_analyzer()->Conn(),
			                                         kex->params()->curve(),
			                                         zeek::make_intrusive<zeek::StringVal>(kex->params()->point().length(), reinterpret_cast<const char*>(kex->params()->point().data())));

		return true;
		
}

bool Handshake_Conn::proc_rsa_client_key_exchange(HandshakeRecord* rec, bytestring const& rsa_pms) {

		if ( ssl_rsa_client_pms )
			zeek::BifEvent::enqueue_ssl_rsa_client_pms(zeek_analyzer(),
			                                     zeek_analyzer()->Conn(),
			                                     zeek::make_intrusive<zeek::StringVal>(rsa_pms.length(), reinterpret_cast<const char*>(rsa_pms.data())));

		return true;
		
}

bool Handshake_Conn::proc_dh_client_key_exchange(HandshakeRecord* rec, bytestring const& Yc) {

		if ( ssl_dh_client_params )
			zeek::BifEvent::enqueue_ssl_dh_client_params(zeek_analyzer(),
			                                       zeek_analyzer()->Conn(),
			                                       zeek::make_intrusive<zeek::StringVal>(Yc.length(), reinterpret_cast<const char*>(Yc.data())));

		return true;
		
}

bool Handshake_Conn::proc_ecdh_client_key_exchange(HandshakeRecord* rec, bytestring const& point) {

		if ( ssl_ecdh_client_params )
			zeek::BifEvent::enqueue_ssl_ecdh_client_params(zeek_analyzer(),
			                                         zeek_analyzer()->Conn(),
			                                         zeek::make_intrusive<zeek::StringVal>(point.length(), reinterpret_cast<const char*>(point.data())));

		return true;
		
}

bool Handshake_Conn::proc_signedcertificatetimestamp(HandshakeRecord* rec, uint8 version, const_bytestring const& logid, uint64 timestamp, SignatureAndHashAlgorithm* digitally_signed_algorithms, const_bytestring const& digitally_signed_signature) {

		if ( ! ssl_extension_signed_certificate_timestamp )
			return true;

		auto ha = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSL::SignatureAndHashAlgorithm);
		ha->Assign(0, digitally_signed_algorithms->HashAlgorithm());
		ha->Assign(1, digitally_signed_algorithms->SignatureAlgorithm());

		zeek::BifEvent::enqueue_ssl_extension_signed_certificate_timestamp(zeek_analyzer(),
			zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_,
			version,
			zeek::make_intrusive<zeek::StringVal>(logid.length(), reinterpret_cast<const char*>(logid.begin())),
			timestamp,
			std::move(ha),
			zeek::make_intrusive<zeek::StringVal>(digitally_signed_signature.length(), reinterpret_cast<const char*>(digitally_signed_signature.begin()))
		);

		return true;
		
}

bool Handshake_Conn::proc_dhe_server_key_exchange(HandshakeRecord* rec, bytestring const& p, bytestring const& g, bytestring const& Ys, ServerKeyExchangeSignature* signed_params) {

		if ( ssl_ecdh_server_params )
			zeek::BifEvent::enqueue_ssl_dh_server_params(zeek_analyzer(),
			  zeek_analyzer()->Conn(),
			  zeek::make_intrusive<zeek::StringVal>(p.length(), reinterpret_cast<const char*>(p.data())),
			  zeek::make_intrusive<zeek::StringVal>(g.length(), reinterpret_cast<const char*>(g.data())),
			  zeek::make_intrusive<zeek::StringVal>(Ys.length(), reinterpret_cast<const char*>(Ys.data()))
			  );

		if ( ssl_server_signature )
			{
			auto ha = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSL::SignatureAndHashAlgorithm);

			if ( signed_params->uses_signature_and_hashalgorithm() )
				{
				ha->Assign(0, signed_params->algorithm()->HashAlgorithm());
				ha->Assign(1, signed_params->algorithm()->SignatureAlgorithm());
				}
				else
				{
				// set to impossible value
				ha->Assign(0, 256);
				ha->Assign(1, 256);
				}

			zeek::BifEvent::enqueue_ssl_server_signature(zeek_analyzer(),
			  zeek_analyzer()->Conn(), std::move(ha),
			  zeek::make_intrusive<zeek::StringVal>(signed_params->signature().length(), reinterpret_cast<const char*>(signed_params->signature().data()))
			  );
			}

		return true;
		
}

bool Handshake_Conn::proc_dh_anon_server_key_exchange(HandshakeRecord* rec, bytestring const& p, bytestring const& g, bytestring const& Ys) {

		if ( ssl_dh_server_params )
			zeek::BifEvent::enqueue_ssl_dh_server_params(zeek_analyzer(),
			  zeek_analyzer()->Conn(),
			  zeek::make_intrusive<zeek::StringVal>(p.length(), reinterpret_cast<const char*>(p.data())),
			  zeek::make_intrusive<zeek::StringVal>(g.length(), reinterpret_cast<const char*>(g.data())),
			  zeek::make_intrusive<zeek::StringVal>(Ys.length(), reinterpret_cast<const char*>(Ys.data()))
			  );

		return true;
		
}

bool Handshake_Conn::proc_handshake(bool is_orig, uint8 msg_type, uint24* length) {

		if ( ssl_handshake_message )
			zeek::BifEvent::enqueue_ssl_handshake_message(zeek_analyzer(),
				zeek_analyzer()->Conn(), is_orig ^ flipped_, msg_type, to_int()(length));

		return true;
		
}

bool Handshake_Conn::proc_pre_shared_key_server_hello(HandshakeRecord* rec, PSKIdentitiesList* identities, PSKBindersList* binders) {

		if ( ! ssl_extension_pre_shared_key_server_hello )
			return true;

		auto slist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::find_type<zeek::VectorType>("psk_identity_vec"));

		if ( identities && identities->identities() )
			{
			for ( auto&& identity : *(identities->identities()) )
				{
				auto el = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSL::PSKIdentity);
				el->Assign(0, zeek::make_intrusive<zeek::StringVal>(identity->identity().length(), reinterpret_cast<const char*>(identity->identity().data())));
				el->Assign(1, identity->obfuscated_ticket_age());
				slist->Assign(slist->Size(), std::move(el));
				}
			}

		auto blist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);

		if ( binders && binders->binders() )
			{
			for ( auto&& binder : *(binders->binders()) )
				blist->Assign(blist->Size(), zeek::make_intrusive<zeek::StringVal>(binder->binder().length(), reinterpret_cast<const char*>(binder->binder().data())));
			}

		zeek::BifEvent::enqueue_ssl_extension_pre_shared_key_client_hello(zeek_analyzer(), zeek_analyzer()->Conn(),
			rec->is_orig() ^ flipped_, std::move(slist), std::move(blist));

		return true;
		
}

bool Handshake_Conn::proc_pre_shared_key_client_hello(HandshakeRecord* rec, uint16 selected_identity) {

		if ( ! ssl_extension_pre_shared_key_client_hello )
			return true;

		zeek::BifEvent::enqueue_ssl_extension_pre_shared_key_server_hello(zeek_analyzer(),
			zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, selected_identity);

		return true;
		
}

bool Handshake_Conn::proc_certificate_request(HandshakeRecord* rec, CertificateRequest* req) {

		if ( ! ssl_certificate_request )
			return true;

		auto ctlist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);
		auto ctypes = req->certificate_types();

		if ( ctypes )
			for ( unsigned int i = 0; i < ctypes->size(); ++i)
				ctlist->Assign(i, zeek::val_mgr->Count((*ctypes)[i]));

		auto slist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::find_type<zeek::VectorType>("signature_and_hashalgorithm_vec"));
		if ( req->uses_signature_and_hashalgorithm() )
			{
			auto sigalgs = req->supported_signature_algorithms()->supported_signature_algorithms();

			if ( sigalgs )
				{
				for ( unsigned int i = 0; i < sigalgs->size(); ++i )
					{
					auto el = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::SSL::SignatureAndHashAlgorithm);
					el->Assign(0, (*sigalgs)[i]->HashAlgorithm());
					el->Assign(1, (*sigalgs)[i]->SignatureAlgorithm());
					slist->Assign(i, std::move(el));
					}
				}
			}


		auto calist = zeek::make_intrusive<zeek::VectorVal>(zeek::id::string_vec);
		auto certificate_authorities = req->certificate_authorities()->certificate_authorities();
		if ( certificate_authorities )
			for ( unsigned int i = 0; i < certificate_authorities->size(); ++i )
				{
				auto ca = (*certificate_authorities)[i]->certificate_authority();
				calist->Assign(i, zeek::make_intrusive<zeek::StringVal>(ca.length(), reinterpret_cast<const char*>(ca.data())));
				}

		zeek::BifEvent::enqueue_ssl_certificate_request(zeek_analyzer(), zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, ctlist, slist, calist);

		return true;
		
}

bool Handshake_Conn::proc_connection_id(HandshakeRecord* rec, bytestring const& cid) {

		if ( ! ssl_extension_connection_id )
			return true;

		auto cid_string = zeek::make_intrusive<zeek::StringVal>(cid.length(), reinterpret_cast<const char*>(cid.data()));
		zeek::BifEvent::enqueue_ssl_extension_connection_id(zeek_analyzer(), zeek_analyzer()->Conn(), rec->is_orig() ^ flipped_, std::move(cid_string));

		return true;
		
}

uint24::uint24() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
}

uint24::~uint24() {
}

int uint24::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint24"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint24",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (3) <= t_end_of_data);
    return 3;
}

uint48::uint48() {
    byte1_ = 0;
    byte2_ = 0;
    byte3_ = 0;
    byte4_ = 0;
    byte5_ = 0;
    byte6_ = 0;
}

uint48::~uint48() {
}

int uint48::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "uint48"
    if ( t_begin_of_data + (6) > t_end_of_data || t_begin_of_data + (6) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("uint48",
        	(0) + (6), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "byte1"
    byte1_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "byte2"
    byte2_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "byte3"
    byte3_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "byte4"
    byte4_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "byte5"
    byte5_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 4)));

    // Parse "byte6"
    byte6_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 5)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (6) <= t_end_of_data);
    return 6;
}


string orig_label(bool is_orig)
		{
		return is_orig ? "originator" :"responder";
		}

zeek::StringVal* to_string_val(vector<uint8>* data) {

	char tmp[32];
	memset(tmp, 0, sizeof(tmp));

	// Just return an empty string if the string is longer than 32 bytes
	if ( data && data->size() <= 32 )
		{
		for ( unsigned int i = data->size(); i > 0; --i )
			tmp[i-1] = (*data)[i-1];
		}

	return new zeek::StringVal(32, tmp);
	
}

bool version_ok(uint16 vers) {

	if ( vers >> 8 == 0x7F ) // 1.3 draft
		return true;

	switch ( vers ) {
	case SSLv20:
	case SSLv30:
	case TLSv10:
	case TLSv11:
	case TLSv12:
	case TLSv13:
	case DTLSv10:
	case DTLSv12:
	case DTLSv13:
		return true;

	default:
		return false;
	}
	
}

uint32 const MAX_DTLS_HANDSHAKE_RECORD = 100000;
HandshakeRecord::HandshakeRecord(bool is_orig) {
    msg_type_ = 0;
    msg_length_ = nullptr;
    rec_ = nullptr;
    is_orig_ = is_orig;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

HandshakeRecord::~HandshakeRecord() {
    delete msg_length_;
    msg_length_ = nullptr;
    delete rec_;
    rec_ = nullptr;
}

bool HandshakeRecord::ParseBuffer(flow_buffer_t t_flow_buffer, ContextTLSHandshake* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(4, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "msg_length"
            msg_length_ = new uint24();
            msg_length_->Parse((t_begin_of_data + 1), t_end_of_data);
            t_flow_buffer->GrowFrame( ( to_int()(msg_length()) + 4 ) );
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "msg_type"
                // Checking out-of-bound for "HandshakeRecord:msg_type"
                if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("HandshakeRecord:msg_type",
                    	(0) + (1), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                msg_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));


                // Parse "rec"
                rec_ = new Handshake(this);
                int t_rec__size;
                t_rec__size = rec_->Parse((t_begin_of_data + 4), t_end_of_data, t_context, t_byteorder);

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

Handshake::Handshake(HandshakeRecord* rec) {
    val_case_index_ = -1;
    hello_request_ = nullptr;
    client_hello_ = nullptr;
    server_hello_ = nullptr;
    hello_verify_request_ = nullptr;
    session_ticket_ = nullptr;
    certificate_ = nullptr;
    server_key_exchange_ = nullptr;
    certificate_request_ = nullptr;
    server_hello_done_ = nullptr;
    certificate_verify_ = nullptr;
    client_key_exchange_ = nullptr;
    finished_ = nullptr;
    certificate_status_ = nullptr;
    unknown_handshake_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

Handshake::~Handshake() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Clean up "hello_request"
            {
                delete hello_request_;
                hello_request_ = nullptr;
            }
            break;
        case ((uint8)1):
            // Clean up "client_hello"
            {
                delete client_hello_;
                client_hello_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "server_hello"
            {
                delete server_hello_;
                server_hello_ = nullptr;
            }
            break;
        case ((uint8)3):
            // Clean up "hello_verify_request"
            {
                delete hello_verify_request_;
                hello_verify_request_ = nullptr;
            }
            break;
        case ((uint8)4):
            // Clean up "session_ticket"
            {
                delete session_ticket_;
                session_ticket_ = nullptr;
            }
            break;
        case ((uint8)11):
            // Clean up "certificate"
            {
                delete certificate_;
                certificate_ = nullptr;
            }
            break;
        case ((uint8)12):
            // Clean up "server_key_exchange"
            {
                delete server_key_exchange_;
                server_key_exchange_ = nullptr;
            }
            break;
        case ((uint8)13):
            // Clean up "certificate_request"
            {
                delete certificate_request_;
                certificate_request_ = nullptr;
            }
            break;
        case ((uint8)14):
            // Clean up "server_hello_done"
            {
                delete server_hello_done_;
                server_hello_done_ = nullptr;
            }
            break;
        case ((uint8)15):
            // Clean up "certificate_verify"
            {
                delete certificate_verify_;
                certificate_verify_ = nullptr;
            }
            break;
        case ((uint8)16):
            // Clean up "client_key_exchange"
            {
                delete client_key_exchange_;
                client_key_exchange_ = nullptr;
            }
            break;
        case ((uint8)20):
            // Clean up "finished"
            {
                delete finished_;
                finished_ = nullptr;
            }
            break;
        case ((uint8)21):
            // Clean up "certificate_url"
            {
            }
            break;
        case ((uint8)22):
            // Clean up "certificate_status"
            {
                delete certificate_status_;
                certificate_status_ = nullptr;
            }
            break;
        default:
            // Clean up "unknown_handshake"
            {
                delete unknown_handshake_;
                unknown_handshake_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int Handshake::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = rec()->msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)0):
            // Parse "hello_request"
            {
                hello_request_ = new HelloRequest(rec());
                hello_request_->Parse(nullptr, nullptr, t_context);
                t_val__size = 0;
            }
            break;
        case ((uint8)1):
            // Parse "client_hello"
            {
                client_hello_ = new ClientHello(rec());
                int t_client_hello__size;
                t_client_hello__size = client_hello_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_client_hello__size;
            }
            break;
        case ((uint8)2):
            // Parse "server_hello"
            {
                server_hello_ = new ServerHelloChoice(rec());
                int t_server_hello__size;
                t_server_hello__size = server_hello_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_server_hello__size;
            }
            break;
        case ((uint8)3):
            // Parse "hello_verify_request"
            {
                hello_verify_request_ = new HelloVerifyRequest(rec());
                int t_hello_verify_request__size;
                t_hello_verify_request__size = hello_verify_request_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_hello_verify_request__size;
            }
            break;
        case ((uint8)4):
            // Parse "session_ticket"
            {
                session_ticket_ = new SessionTicketHandshake(rec());
                int t_session_ticket__size;
                t_session_ticket__size = session_ticket_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_session_ticket__size;
            }
            break;
        case ((uint8)11):
            // Parse "certificate"
            {
                certificate_ = new Certificate(rec());
                int t_certificate__size;
                t_certificate__size = certificate_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_certificate__size;
            }
            break;
        case ((uint8)12):
            // Parse "server_key_exchange"
            {
                server_key_exchange_ = new ServerKeyExchange(rec());
                int t_server_key_exchange__size;
                t_server_key_exchange__size = server_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_server_key_exchange__size;
            }
            break;
        case ((uint8)13):
            // Parse "certificate_request"
            {
                certificate_request_ = new CertificateRequest(rec());
                int t_certificate_request__size;
                t_certificate_request__size = certificate_request_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_certificate_request__size;
            }
            break;
        case ((uint8)14):
            // Parse "server_hello_done"
            {
                server_hello_done_ = new ServerHelloDone(rec());
                server_hello_done_->Parse(nullptr, nullptr, t_context);
                t_val__size = 0;
            }
            break;
        case ((uint8)15):
            // Parse "certificate_verify"
            {
                certificate_verify_ = new CertificateVerify(rec());
                int t_certificate_verify__size;
                t_certificate_verify__size = certificate_verify_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_certificate_verify__size;
            }
            break;
        case ((uint8)16):
            // Parse "client_key_exchange"
            {
                client_key_exchange_ = new ClientKeyExchange(rec());
                int t_client_key_exchange__size;
                t_client_key_exchange__size = client_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_client_key_exchange__size;
            }
            break;
        case ((uint8)20):
            // Parse "finished"
            {
                finished_ = new Finished(rec());
                int t_finished__size;
                t_finished__size = finished_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_finished__size;
            }
            break;
        case ((uint8)21):
            // Parse "certificate_url"
            {
                int t_certificate_url_string_length;
                t_certificate_url_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_certificate_url__size;
                t_certificate_url__size = t_certificate_url_string_length;
                // check for negative sizes
                if ( t_certificate_url_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:46", t_certificate_url_string_length);
                certificate_url_.init(t_begin_of_data, t_certificate_url_string_length);
                t_val__size = t_certificate_url__size;
            }
            break;
        case ((uint8)22):
            // Parse "certificate_status"
            {
                certificate_status_ = new CertificateStatus(rec());
                int t_certificate_status__size;
                t_certificate_status__size = certificate_status_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_certificate_status__size;
            }
            break;
        default:
            // Parse "unknown_handshake"
            {
                unknown_handshake_ = new UnknownHandshake(rec(), rec()->is_orig());
                int t_unknown_handshake__size;
                t_unknown_handshake__size = unknown_handshake_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_unknown_handshake__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_handshake(rec()->is_orig(), rec()->msg_type(), rec()->msg_length());
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

HandshakePDU::HandshakePDU(bool is_orig) {
    records_ = nullptr;
    records__elem_ = nullptr;
    records__arraylength_ = 0;
    records__elem__it_ = 0;
    records__elem__it_ = -1;
    is_orig_ = is_orig;
    byteorder_ = bigendian;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

HandshakePDU::~HandshakePDU() {
    delete records__elem_;
    records__elem_ = nullptr;
    if ( records_ ) {
        for ( auto* records__elem_ : *records_ ) {
            delete records__elem_;
            records__elem_ = nullptr;
        }
    }
    delete records_;
}

bool HandshakePDU::ParseBuffer(flow_buffer_t t_flow_buffer, ContextTLSHandshake* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "records"
        if ( ! records_ ) {
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_records_parsing_complete;
        t_records_parsing_complete = false;
        if ( records__elem__it_ < 0 ) {
            // Initialize only once
            records__elem__it_ = 0;
            records_ = new vector<HandshakeRecord*>;
        }
        for (; /* forever */; ++records__elem__it_) {
            if ( ! records__elem_ ) {
                records__elem_ = new HandshakeRecord(is_orig());
            }
            bool t_records__elem_parsing_complete;
            t_records__elem_parsing_complete = false;
            while ( ! t_records__elem_parsing_complete && t_flow_buffer->ready() ) {
                const_byteptr t_begin_of_data = t_flow_buffer->begin();
                const_byteptr t_end_of_data = t_flow_buffer->end();
                t_records__elem_parsing_complete = records__elem_->ParseBuffer(t_flow_buffer, t_context, byteorder());
                if ( t_records__elem_parsing_complete ) {
                }
            }
            if ( ! t_records__elem_parsing_complete )
                goto need_more_data;
            delete records__elem_;
            records__elem_ = nullptr;
        }
    end_of_records: ;
        if ( t_records_parsing_complete ) {
            // Evaluate 'let' and 'withinput' fields
        }
        if ( ! (t_records_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

UnknownHandshake::UnknownHandshake(HandshakeRecord* hs, bool is_orig) {
    hs_ = hs;
    is_orig_ = is_orig;
    proc_ = false;
}

UnknownHandshake::~UnknownHandshake() {
}

int UnknownHandshake::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:56", t_data_string_length);
    data_.init(t_begin_of_data, t_data_string_length);

    int t_UnknownHandshake__size;
    const_byteptr const t_dataptr_after_data = t_begin_of_data + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_UnknownHandshake__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_unknown_handshake(hs(), is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_UnknownHandshake__size) <= t_end_of_data);
    return t_UnknownHandshake__size;
}

HelloRequest::HelloRequest(HandshakeRecord* rec) {
    direction_check_ = nullptr;
    rec_ = rec;
}

HelloRequest::~HelloRequest() {
    delete direction_check_;
    direction_check_ = nullptr;
}

int HelloRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Checking out-of-bound for "HelloRequest"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("HelloRequest",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "direction_check"
    direction_check_ = new DirectionCheck(false, rec());
    direction_check_->Parse(nullptr, nullptr, t_context);

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

ClientHello::ClientHello(HandshakeRecord* rec) {
    direction_check_ = nullptr;
    client_version_ = 0;
    gmt_unix_time_ = 0;
    session_len_ = 0;
    session_id_ = nullptr;
    session_id__elem_ = 0;
    dtls_cookie_case_index_ = -1;
    cookie_ = nullptr;
    csuit_len_ = 0;
    csuits_ = nullptr;
    csuits__elem_ = 0;
    cmeth_len_ = 0;
    cmeths_ = nullptr;
    cmeths__elem_ = 0;
    ext_len_ = nullptr;
    ext_len__elem_ = 0;
    extensions_ = nullptr;
    extensions__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

ClientHello::~ClientHello() {
    delete direction_check_;
    direction_check_ = nullptr;
    random_bytes_.free();
    delete session_id_;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( dtls_cookie_case_index() ) {
        case ((uint16)65279):
        case ((uint16)65277):
            // Clean up "cookie"
            {
                delete cookie_;
                cookie_ = nullptr;
            }
            break;
        default:
            // Clean up "nothing"
            {
                nothing_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete csuits_;
    delete cmeths_;
    delete ext_len_;
    delete extensions__elem_;
    extensions__elem_ = nullptr;
    if ( extensions() ) {
        for ( auto* extensions__elem_ : *extensions() ) {
            delete extensions__elem_;
            extensions__elem_ = nullptr;
        }
    }
    delete extensions_;
}

int ClientHello::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "ClientHello:gmt_unix_time"
    if ( (t_begin_of_data + 2) + (4) > t_end_of_data || (t_begin_of_data + 2) + (4) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHello:gmt_unix_time",
        	(2) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "direction_check"
    direction_check_ = new DirectionCheck(true, rec());
    direction_check_->Parse(nullptr, nullptr, t_context);

    // Parse "client_version"
    client_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "gmt_unix_time"
    gmt_unix_time_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 2))));

    // Parse "random_bytes"
    // Checking out-of-bound for "ClientHello:random_bytes"
    if ( (t_begin_of_data + 6) + (28) > t_end_of_data || (t_begin_of_data + 6) + (28) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHello:random_bytes",
        	(6) + (28), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 6) + 28;
        int t_random_bytes_string_length;
        t_random_bytes_string_length = 28;
        int t_random_bytes__size;
        t_random_bytes__size = t_random_bytes_string_length;
        random_bytes_.init((t_begin_of_data + 6), t_random_bytes_string_length);
    }

    const_byteptr const t_dataptr_after_random_bytes = (t_begin_of_data + 6) + (28);
    BINPAC_ASSERT(t_dataptr_after_random_bytes <= t_end_of_data);
    // Checking out-of-bound for "ClientHello:session_len"
    if ( t_dataptr_after_random_bytes + (1) > t_end_of_data || t_dataptr_after_random_bytes + (1) < t_dataptr_after_random_bytes ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHello:session_len",
        	((t_dataptr_after_random_bytes - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "session_len"
    session_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_random_bytes));

    // Parse "session_id"
    int t_session_id__arraylength;
    t_session_id__arraylength = session_len();
    if ( t_session_id__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ClientHello:session_id",
          t_session_id__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ClientHello:session_id
    if ( t_session_id__arraylength > ((t_end_of_data - (t_dataptr_after_random_bytes + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("ClientHello:session_id",
          t_session_id__arraylength, (t_end_of_data) - ((t_dataptr_after_random_bytes + 1)));
    session_id__elem_ = 0;
    int t_session_id__elem__it;
    t_session_id__elem__it = 0;
    int t_session_id__size;
    session_id_ = new vector<uint8>;
    session_id_->reserve(t_session_id__arraylength);
    const_byteptr t_session_id__elem__dataptr = (t_dataptr_after_random_bytes + 1);
    for (; t_session_id__elem__it < t_session_id__arraylength; ++t_session_id__elem__it) {
        session_id__elem_ = *(reinterpret_cast<uint8 const*>(t_session_id__elem__dataptr));
        session_id_->push_back(session_id__elem_);
        t_session_id__elem__dataptr += 1;
        BINPAC_ASSERT(t_session_id__elem__dataptr <= t_end_of_data);
    }
end_of_session_id: ;
    t_session_id__size = t_session_id__elem__dataptr - ((t_dataptr_after_random_bytes + 1));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_session_id = (t_dataptr_after_random_bytes + 1) + (t_session_id__size);
    BINPAC_ASSERT(t_dataptr_after_session_id <= t_end_of_data);
    // Parse "dtls_cookie"
    int t_dtls_cookie__size;
    dtls_cookie_case_index_ = client_version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( dtls_cookie_case_index() ) {
        case ((uint16)65279):
        case ((uint16)65277):
            // Parse "cookie"
            {
                cookie_ = new ClientHelloCookie(rec());
                int t_cookie__size;
                t_cookie__size = cookie_->Parse(t_dataptr_after_session_id, t_end_of_data, t_context);
                t_dtls_cookie__size = t_cookie__size;
            }
            break;
        default:
            // Parse "nothing"
            {
                // Checking out-of-bound for "ClientHello:nothing"
                if ( t_dataptr_after_session_id + (0) > t_end_of_data || t_dataptr_after_session_id + (0) < t_dataptr_after_session_id ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ClientHello:nothing",
                    	((t_dataptr_after_session_id - t_begin_of_data)) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_session_id + 0;
                    int t_nothing_string_length;
                    t_nothing_string_length = 0;
                    int t_nothing__size;
                    t_nothing__size = t_nothing_string_length;
                    nothing_.init(t_dataptr_after_session_id, t_nothing_string_length);
                }
                t_dtls_cookie__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_dtls_cookie = t_dataptr_after_session_id + (t_dtls_cookie__size);
    BINPAC_ASSERT(t_dataptr_after_dtls_cookie <= t_end_of_data);
    // Checking out-of-bound for "ClientHello:csuit_len"
    if ( t_dataptr_after_dtls_cookie + (2) > t_end_of_data || t_dataptr_after_dtls_cookie + (2) < t_dataptr_after_dtls_cookie ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHello:csuit_len",
        	((t_dataptr_after_dtls_cookie - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "csuit_len"
    csuit_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_dtls_cookie)));

    // Parse "csuits"
    int t_csuits__arraylength;
    t_csuits__arraylength = csuit_len() / 2;
    if ( t_csuits__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ClientHello:csuits",
          t_csuits__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ClientHello:csuits
    if ( t_csuits__arraylength > ((t_end_of_data - (t_dataptr_after_dtls_cookie + 2)) / 2) )
        throw binpac::ExceptionOutOfBound("ClientHello:csuits",
          t_csuits__arraylength, (t_end_of_data) - ((t_dataptr_after_dtls_cookie + 2)));
    csuits__elem_ = 0;
    int t_csuits__elem__it;
    t_csuits__elem__it = 0;
    int t_csuits__size;
    csuits_ = new vector<uint16>;
    csuits_->reserve(t_csuits__arraylength);
    const_byteptr t_csuits__elem__dataptr = (t_dataptr_after_dtls_cookie + 2);
    for (; t_csuits__elem__it < t_csuits__arraylength; ++t_csuits__elem__it) {
        csuits__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_csuits__elem__dataptr)));
        csuits_->push_back(csuits__elem_);
        t_csuits__elem__dataptr += 2;
        BINPAC_ASSERT(t_csuits__elem__dataptr <= t_end_of_data);
    }
end_of_csuits: ;
    t_csuits__size = t_csuits__elem__dataptr - ((t_dataptr_after_dtls_cookie + 2));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_csuits = (t_dataptr_after_dtls_cookie + 2) + (t_csuits__size);
    BINPAC_ASSERT(t_dataptr_after_csuits <= t_end_of_data);
    // Checking out-of-bound for "ClientHello:cmeth_len"
    if ( t_dataptr_after_csuits + (1) > t_end_of_data || t_dataptr_after_csuits + (1) < t_dataptr_after_csuits ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHello:cmeth_len",
        	((t_dataptr_after_csuits - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cmeth_len"
    cmeth_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_csuits));

    // Parse "cmeths"
    int t_cmeths__arraylength;
    t_cmeths__arraylength = cmeth_len();
    if ( t_cmeths__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ClientHello:cmeths",
          t_cmeths__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ClientHello:cmeths
    if ( t_cmeths__arraylength > ((t_end_of_data - (t_dataptr_after_csuits + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("ClientHello:cmeths",
          t_cmeths__arraylength, (t_end_of_data) - ((t_dataptr_after_csuits + 1)));
    cmeths__elem_ = 0;
    int t_cmeths__elem__it;
    t_cmeths__elem__it = 0;
    int t_cmeths__size;
    cmeths_ = new vector<uint8>;
    cmeths_->reserve(t_cmeths__arraylength);
    const_byteptr t_cmeths__elem__dataptr = (t_dataptr_after_csuits + 1);
    for (; t_cmeths__elem__it < t_cmeths__arraylength; ++t_cmeths__elem__it) {
        cmeths__elem_ = *(reinterpret_cast<uint8 const*>(t_cmeths__elem__dataptr));
        cmeths_->push_back(cmeths__elem_);
        t_cmeths__elem__dataptr += 1;
        BINPAC_ASSERT(t_cmeths__elem__dataptr <= t_end_of_data);
    }
end_of_cmeths: ;
    t_cmeths__size = t_cmeths__elem__dataptr - ((t_dataptr_after_csuits + 1));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_cmeths = (t_dataptr_after_csuits + 1) + (t_cmeths__size);
    BINPAC_ASSERT(t_dataptr_after_cmeths <= t_end_of_data);
    // Parse "ext_len"
    int t_ext_len__arraylength;
    t_ext_len__arraylength = 0;
    ext_len__elem_ = 0;
    int t_ext_len__elem__it;
    t_ext_len__elem__it = 0;
    int t_ext_len__size;
    ext_len_ = new vector<uint16>;
    const_byteptr t_ext_len__elem__dataptr = t_dataptr_after_cmeths;
    for (; /* forever */; ++t_ext_len__elem__it) {
        // Check &until(ext_len__elem__dataptr >= end_of_data)
        if ( t_ext_len__elem__dataptr >= t_end_of_data ) {
            goto end_of_ext_len;
        }
        // Checking out-of-bound for "ClientHello:ext_len__elem"
        if ( t_ext_len__elem__dataptr + (2) > t_end_of_data || t_ext_len__elem__dataptr + (2) < t_ext_len__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("ClientHello:ext_len__elem",
            	((t_ext_len__elem__dataptr - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        ext_len__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_ext_len__elem__dataptr)));
        ext_len_->push_back(ext_len__elem_);
        t_ext_len__elem__dataptr += 2;
        BINPAC_ASSERT(t_ext_len__elem__dataptr <= t_end_of_data);
        // Check &until( ( $element == ((int) 0) || $element != ((int) 0) ) )
        if (  ( ext_len__elem_ == 0 || ext_len__elem_ != 0 )  ) {
            goto end_of_ext_len;
        }
    }
end_of_ext_len: ;
    t_ext_len__size = t_ext_len__elem__dataptr - (t_dataptr_after_cmeths);
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_ext_len = t_dataptr_after_cmeths + (t_ext_len__size);
    BINPAC_ASSERT(t_dataptr_after_ext_len <= t_end_of_data);
    // Parse "extensions"
    int t_extensions__arraylength;
    t_extensions__arraylength = 0;
    extensions__elem_ = nullptr;
    int t_extensions__elem__it;
    t_extensions__elem__it = 0;
    int t_extensions__size;
    extensions_ = new vector<SSLExtension*>;
    const_byteptr t_extensions__elem__dataptr = t_dataptr_after_ext_len;
    for (; /* forever */; ++t_extensions__elem__it) {
        // Check &until(extensions__elem__dataptr >= end_of_data)
        if ( t_extensions__elem__dataptr >= t_end_of_data ) {
            extensions__elem_ = nullptr;
            goto end_of_extensions;
        }
        extensions__elem_ = new SSLExtension(rec());
        int t_extensions__elem__size;
        t_extensions__elem__size = extensions__elem_->Parse(t_extensions__elem__dataptr, t_end_of_data, t_context, t_byteorder);
        extensions_->push_back(extensions__elem_);
        t_extensions__elem__dataptr += t_extensions__elem__size;
        BINPAC_ASSERT(t_extensions__elem__dataptr <= t_end_of_data);
        extensions__elem_ = nullptr;
    }
end_of_extensions: ;
    t_extensions__size = t_extensions__elem__dataptr - (t_dataptr_after_ext_len);
    // Evaluate 'let' and 'withinput' fields

    int t_ClientHello__size;
    const_byteptr const t_dataptr_after_extensions = t_dataptr_after_ext_len + (t_extensions__size);
    BINPAC_ASSERT(t_dataptr_after_extensions <= t_end_of_data);
    t_ClientHello__size = t_dataptr_after_extensions - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_client_hello(client_version(), gmt_unix_time(), random_bytes(), session_id(), csuits(), nullptr, cmeths());
    BINPAC_ASSERT(t_begin_of_data + (t_ClientHello__size) <= t_end_of_data);
    return t_ClientHello__size;
}

ClientHelloCookie::ClientHelloCookie(HandshakeRecord* rec) {
    cookie_len_ = 0;
    rec_ = rec;
}

ClientHelloCookie::~ClientHelloCookie() {
    cookie_.free();
}

int ClientHelloCookie::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Checking out-of-bound for "ClientHelloCookie:cookie_len"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHelloCookie:cookie_len",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cookie_len"
    cookie_len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "cookie"
    int t_cookie__size;
    t_cookie__size = cookie_len();
    // Checking out-of-bound for "ClientHelloCookie:cookie"
    if ( (t_begin_of_data + 1) + (t_cookie__size) > t_end_of_data || (t_begin_of_data + 1) + (t_cookie__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHelloCookie:cookie",
        	(1) + (t_cookie__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_cookie__size;
        int t_cookie_string_length;
        t_cookie_string_length = cookie_len();
        // check for negative sizes
        if ( t_cookie_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:96", t_cookie_string_length);
        cookie_.init((t_begin_of_data + 1), t_cookie_string_length);
    }

    int t_ClientHelloCookie__size;
    const_byteptr const t_dataptr_after_cookie = (t_begin_of_data + 1) + (t_cookie__size);
    BINPAC_ASSERT(t_dataptr_after_cookie <= t_end_of_data);
    t_ClientHelloCookie__size = t_dataptr_after_cookie - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ClientHelloCookie__size) <= t_end_of_data);
    return t_ClientHelloCookie__size;
}

ServerHelloChoice::ServerHelloChoice(HandshakeRecord* rec) {
    direction_check_ = nullptr;
    server_version0_ = 0;
    server_version1_ = 0;
    hello_case_index_ = -1;
    hello13_ = nullptr;
    helloclassic_ = nullptr;
    rec_ = rec;
    server_version_ = 0;
    parsed_version_ = 0;
    version_set_ = false;
}

ServerHelloChoice::~ServerHelloChoice() {
    delete direction_check_;
    direction_check_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( hello_case_index() ) {
        case ((uint16)772):
        case ((uint16)32512):
            // Clean up "hello13"
            {
                delete hello13_;
                hello13_ = nullptr;
            }
            break;
        default:
            // Clean up "helloclassic"
            {
                delete helloclassic_;
                helloclassic_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ServerHelloChoice::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "ServerHelloChoice:server_version1"
    if ( (t_begin_of_data + 1) + (1) > t_end_of_data || (t_begin_of_data + 1) + (1) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerHelloChoice:server_version1",
        	(1) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "direction_check"
    direction_check_ = new DirectionCheck(false, rec());
    direction_check_->Parse(nullptr, nullptr, t_context);

    // Parse "server_version0"
    server_version0_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "server_version1"
    server_version1_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Parse "hello"
    server_version_ =  ( server_version0() << 8 )  | server_version1();
    int t_t_var_001;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( server_version0() ) {
        case ((uint8)127):
            t_t_var_001 = 0x7F00;
            break;
        default:
            t_t_var_001 = server_version();
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    parsed_version_ = t_t_var_001;
    int t_hello__size;
    hello_case_index_ = parsed_version();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( hello_case_index() ) {
        case ((uint16)772):
        case ((uint16)32512):
            // Parse "hello13"
            {
                hello13_ = new ServerHello13(rec(), server_version());
                int t_hello13__size;
                t_hello13__size = hello13_->Parse((t_begin_of_data + 2), t_end_of_data, t_context, t_byteorder);
                t_hello__size = t_hello13__size;
            }
            break;
        default:
            // Parse "helloclassic"
            {
                helloclassic_ = new ServerHello(rec(), server_version());
                int t_helloclassic__size;
                t_helloclassic__size = helloclassic_->Parse((t_begin_of_data + 2), t_end_of_data, t_context, t_byteorder);
                t_hello__size = t_helloclassic__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ServerHelloChoice__size;
    const_byteptr const t_dataptr_after_hello = (t_begin_of_data + 2) + (t_hello__size);
    BINPAC_ASSERT(t_dataptr_after_hello <= t_end_of_data);
    t_ServerHelloChoice__size = t_dataptr_after_hello - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    version_set_ = t_context->connection()->set_version(server_version());
    BINPAC_ASSERT(t_begin_of_data + (t_ServerHelloChoice__size) <= t_end_of_data);
    return t_ServerHelloChoice__size;
}

ServerHello::ServerHello(HandshakeRecord* rec, uint16 server_version) {
    session_len_ = 0;
    session_id_ = nullptr;
    session_id__elem_ = 0;
    cipher_suite_ = nullptr;
    cipher_suite__elem_ = 0;
    compression_method_ = 0;
    ext_len_ = nullptr;
    ext_len__elem_ = 0;
    extensions_ = nullptr;
    extensions__elem_ = nullptr;
    rec_ = rec;
    server_version_ = server_version;
    cipher_set_ = false;
    proc_ = false;
}

ServerHello::~ServerHello() {
    random_bytes_.free();
    delete session_id_;
    delete cipher_suite_;
    delete ext_len_;
    delete extensions__elem_;
    extensions__elem_ = nullptr;
    if ( extensions() ) {
        for ( auto* extensions__elem_ : *extensions() ) {
            delete extensions__elem_;
            extensions__elem_ = nullptr;
        }
    }
    delete extensions_;
}

int ServerHello::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Parse "random_bytes"
    // Checking out-of-bound for "ServerHello:random_bytes"
    if ( t_begin_of_data + (32) > t_end_of_data || t_begin_of_data + (32) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerHello:random_bytes",
        	(0) + (32), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 32;
        int t_random_bytes_string_length;
        t_random_bytes_string_length = 32;
        int t_random_bytes__size;
        t_random_bytes__size = t_random_bytes_string_length;
        random_bytes_.init(t_begin_of_data, t_random_bytes_string_length);
    }

    const_byteptr const t_dataptr_after_random_bytes = t_begin_of_data + (32);
    BINPAC_ASSERT(t_dataptr_after_random_bytes <= t_end_of_data);
    // Checking out-of-bound for "ServerHello:session_len"
    if ( t_dataptr_after_random_bytes + (1) > t_end_of_data || t_dataptr_after_random_bytes + (1) < t_dataptr_after_random_bytes ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerHello:session_len",
        	((t_dataptr_after_random_bytes - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "session_len"
    session_len_ = *(reinterpret_cast<uint8 const*>(t_dataptr_after_random_bytes));

    // Parse "session_id"
    int t_session_id__arraylength;
    t_session_id__arraylength = session_len();
    if ( t_session_id__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ServerHello:session_id",
          t_session_id__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ServerHello:session_id
    if ( t_session_id__arraylength > ((t_end_of_data - (t_dataptr_after_random_bytes + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("ServerHello:session_id",
          t_session_id__arraylength, (t_end_of_data) - ((t_dataptr_after_random_bytes + 1)));
    session_id__elem_ = 0;
    int t_session_id__elem__it;
    t_session_id__elem__it = 0;
    int t_session_id__size;
    session_id_ = new vector<uint8>;
    session_id_->reserve(t_session_id__arraylength);
    const_byteptr t_session_id__elem__dataptr = (t_dataptr_after_random_bytes + 1);
    for (; t_session_id__elem__it < t_session_id__arraylength; ++t_session_id__elem__it) {
        session_id__elem_ = *(reinterpret_cast<uint8 const*>(t_session_id__elem__dataptr));
        session_id_->push_back(session_id__elem_);
        t_session_id__elem__dataptr += 1;
        BINPAC_ASSERT(t_session_id__elem__dataptr <= t_end_of_data);
    }
end_of_session_id: ;
    t_session_id__size = t_session_id__elem__dataptr - ((t_dataptr_after_random_bytes + 1));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_session_id = (t_dataptr_after_random_bytes + 1) + (t_session_id__size);
    BINPAC_ASSERT(t_dataptr_after_session_id <= t_end_of_data);
    // Checking out-of-bound for "ServerHello:compression_method"
    if ( (t_dataptr_after_session_id + 2) + (1) > t_end_of_data || (t_dataptr_after_session_id + 2) + (1) < (t_dataptr_after_session_id + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerHello:compression_method",
        	(((t_dataptr_after_session_id + 2) - t_begin_of_data)) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cipher_suite"
    int t_cipher_suite__arraylength;
    t_cipher_suite__arraylength = 1;
    if ( t_cipher_suite__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ServerHello:cipher_suite",
          t_cipher_suite__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ServerHello:cipher_suite
    if ( t_cipher_suite__arraylength > ((t_end_of_data - t_dataptr_after_session_id) / 2) )
        throw binpac::ExceptionOutOfBound("ServerHello:cipher_suite",
          t_cipher_suite__arraylength, (t_end_of_data) - (t_dataptr_after_session_id));
    cipher_suite__elem_ = 0;
    int t_cipher_suite__elem__it;
    t_cipher_suite__elem__it = 0;
    cipher_suite_ = new vector<uint16>;
    cipher_suite_->reserve(t_cipher_suite__arraylength);
    const_byteptr t_cipher_suite__elem__dataptr = t_dataptr_after_session_id;
    for (; t_cipher_suite__elem__it < t_cipher_suite__arraylength; ++t_cipher_suite__elem__it) {
        cipher_suite__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_cipher_suite__elem__dataptr)));
        cipher_suite_->push_back(cipher_suite__elem_);
        t_cipher_suite__elem__dataptr += 2;
        BINPAC_ASSERT(t_cipher_suite__elem__dataptr <= t_end_of_data);
    }
end_of_cipher_suite: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "compression_method"
    compression_method_ = *(reinterpret_cast<uint8 const*>((t_dataptr_after_session_id + 2)));

    // Parse "ext_len"
    int t_ext_len__arraylength;
    t_ext_len__arraylength = 0;
    ext_len__elem_ = 0;
    int t_ext_len__elem__it;
    t_ext_len__elem__it = 0;
    int t_ext_len__size;
    ext_len_ = new vector<uint16>;
    const_byteptr t_ext_len__elem__dataptr = (t_dataptr_after_session_id + 3);
    for (; /* forever */; ++t_ext_len__elem__it) {
        // Check &until(ext_len__elem__dataptr >= end_of_data)
        if ( t_ext_len__elem__dataptr >= t_end_of_data ) {
            goto end_of_ext_len;
        }
        // Checking out-of-bound for "ServerHello:ext_len__elem"
        if ( t_ext_len__elem__dataptr + (2) > t_end_of_data || t_ext_len__elem__dataptr + (2) < t_ext_len__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("ServerHello:ext_len__elem",
            	((t_ext_len__elem__dataptr - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        ext_len__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_ext_len__elem__dataptr)));
        ext_len_->push_back(ext_len__elem_);
        t_ext_len__elem__dataptr += 2;
        BINPAC_ASSERT(t_ext_len__elem__dataptr <= t_end_of_data);
        // Check &until( ( $element == ((int) 0) || $element != ((int) 0) ) )
        if (  ( ext_len__elem_ == 0 || ext_len__elem_ != 0 )  ) {
            goto end_of_ext_len;
        }
    }
end_of_ext_len: ;
    t_ext_len__size = t_ext_len__elem__dataptr - ((t_dataptr_after_session_id + 3));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_ext_len = (t_dataptr_after_session_id + 3) + (t_ext_len__size);
    BINPAC_ASSERT(t_dataptr_after_ext_len <= t_end_of_data);
    // Parse "extensions"
    int t_extensions__arraylength;
    t_extensions__arraylength = 0;
    extensions__elem_ = nullptr;
    int t_extensions__elem__it;
    t_extensions__elem__it = 0;
    int t_extensions__size;
    extensions_ = new vector<SSLExtension*>;
    const_byteptr t_extensions__elem__dataptr = t_dataptr_after_ext_len;
    for (; /* forever */; ++t_extensions__elem__it) {
        // Check &until(extensions__elem__dataptr >= end_of_data)
        if ( t_extensions__elem__dataptr >= t_end_of_data ) {
            extensions__elem_ = nullptr;
            goto end_of_extensions;
        }
        extensions__elem_ = new SSLExtension(rec());
        int t_extensions__elem__size;
        t_extensions__elem__size = extensions__elem_->Parse(t_extensions__elem__dataptr, t_end_of_data, t_context, t_byteorder);
        extensions_->push_back(extensions__elem_);
        t_extensions__elem__dataptr += t_extensions__elem__size;
        BINPAC_ASSERT(t_extensions__elem__dataptr <= t_end_of_data);
        extensions__elem_ = nullptr;
    }
end_of_extensions: ;
    t_extensions__size = t_extensions__elem__dataptr - (t_dataptr_after_ext_len);
    // Evaluate 'let' and 'withinput' fields

    int t_ServerHello__size;
    const_byteptr const t_dataptr_after_extensions = t_dataptr_after_ext_len + (t_extensions__size);
    BINPAC_ASSERT(t_dataptr_after_extensions <= t_end_of_data);
    t_ServerHello__size = t_dataptr_after_extensions - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    cipher_set_ = t_context->connection()->set_cipher((*(cipher_suite()))[0]);
    proc_ = t_context->connection()->proc_server_hello(server_version(), false, random_bytes(), session_id(), cipher_suite(), nullptr, compression_method());
    BINPAC_ASSERT(t_begin_of_data + (t_ServerHello__size) <= t_end_of_data);
    return t_ServerHello__size;
}

ServerHello13::ServerHello13(HandshakeRecord* rec, uint16 server_version) {
    cipher_suite_ = nullptr;
    cipher_suite__elem_ = 0;
    ext_len_ = nullptr;
    ext_len__elem_ = 0;
    extensions_ = nullptr;
    extensions__elem_ = nullptr;
    rec_ = rec;
    server_version_ = server_version;
    cipher_set_ = false;
    proc_ = false;
}

ServerHello13::~ServerHello13() {
    random_.free();
    delete cipher_suite_;
    delete ext_len_;
    delete extensions__elem_;
    extensions__elem_ = nullptr;
    if ( extensions() ) {
        for ( auto* extensions__elem_ : *extensions() ) {
            delete extensions__elem_;
            extensions__elem_ = nullptr;
        }
    }
    delete extensions_;
}

int ServerHello13::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Parse "random"
    // Checking out-of-bound for "ServerHello13:random"
    if ( t_begin_of_data + (32) > t_end_of_data || t_begin_of_data + (32) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerHello13:random",
        	(0) + (32), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 32;
        int t_random_string_length;
        t_random_string_length = 32;
        int t_random__size;
        t_random__size = t_random_string_length;
        random_.init(t_begin_of_data, t_random_string_length);
    }

    const_byteptr const t_dataptr_after_random = t_begin_of_data + (32);
    BINPAC_ASSERT(t_dataptr_after_random <= t_end_of_data);
    // Checking out-of-bound for "ServerHello13:cipher_suite"
    if ( t_dataptr_after_random + (2) > t_end_of_data || t_dataptr_after_random + (2) < t_dataptr_after_random ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerHello13:cipher_suite",
        	((t_dataptr_after_random - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "cipher_suite"
    int t_cipher_suite__arraylength;
    t_cipher_suite__arraylength = 1;
    if ( t_cipher_suite__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("ServerHello13:cipher_suite",
          t_cipher_suite__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: ServerHello13:cipher_suite
    if ( t_cipher_suite__arraylength > ((t_end_of_data - t_dataptr_after_random) / 2) )
        throw binpac::ExceptionOutOfBound("ServerHello13:cipher_suite",
          t_cipher_suite__arraylength, (t_end_of_data) - (t_dataptr_after_random));
    cipher_suite__elem_ = 0;
    int t_cipher_suite__elem__it;
    t_cipher_suite__elem__it = 0;
    cipher_suite_ = new vector<uint16>;
    cipher_suite_->reserve(t_cipher_suite__arraylength);
    const_byteptr t_cipher_suite__elem__dataptr = t_dataptr_after_random;
    for (; t_cipher_suite__elem__it < t_cipher_suite__arraylength; ++t_cipher_suite__elem__it) {
        cipher_suite__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_cipher_suite__elem__dataptr)));
        cipher_suite_->push_back(cipher_suite__elem_);
        t_cipher_suite__elem__dataptr += 2;
        BINPAC_ASSERT(t_cipher_suite__elem__dataptr <= t_end_of_data);
    }
end_of_cipher_suite: ;
    // Evaluate 'let' and 'withinput' fields

    // Parse "ext_len"
    int t_ext_len__arraylength;
    t_ext_len__arraylength = 0;
    ext_len__elem_ = 0;
    int t_ext_len__elem__it;
    t_ext_len__elem__it = 0;
    int t_ext_len__size;
    ext_len_ = new vector<uint16>;
    const_byteptr t_ext_len__elem__dataptr = (t_dataptr_after_random + 2);
    for (; /* forever */; ++t_ext_len__elem__it) {
        // Check &until(ext_len__elem__dataptr >= end_of_data)
        if ( t_ext_len__elem__dataptr >= t_end_of_data ) {
            goto end_of_ext_len;
        }
        // Checking out-of-bound for "ServerHello13:ext_len__elem"
        if ( t_ext_len__elem__dataptr + (2) > t_end_of_data || t_ext_len__elem__dataptr + (2) < t_ext_len__elem__dataptr ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("ServerHello13:ext_len__elem",
            	((t_ext_len__elem__dataptr - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        ext_len__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_ext_len__elem__dataptr)));
        ext_len_->push_back(ext_len__elem_);
        t_ext_len__elem__dataptr += 2;
        BINPAC_ASSERT(t_ext_len__elem__dataptr <= t_end_of_data);
        // Check &until( ( $element == ((int) 0) || $element != ((int) 0) ) )
        if (  ( ext_len__elem_ == 0 || ext_len__elem_ != 0 )  ) {
            goto end_of_ext_len;
        }
    }
end_of_ext_len: ;
    t_ext_len__size = t_ext_len__elem__dataptr - ((t_dataptr_after_random + 2));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_ext_len = (t_dataptr_after_random + 2) + (t_ext_len__size);
    BINPAC_ASSERT(t_dataptr_after_ext_len <= t_end_of_data);
    // Parse "extensions"
    int t_extensions__arraylength;
    t_extensions__arraylength = 0;
    extensions__elem_ = nullptr;
    int t_extensions__elem__it;
    t_extensions__elem__it = 0;
    int t_extensions__size;
    extensions_ = new vector<SSLExtension*>;
    const_byteptr t_extensions__elem__dataptr = t_dataptr_after_ext_len;
    for (; /* forever */; ++t_extensions__elem__it) {
        // Check &until(extensions__elem__dataptr >= end_of_data)
        if ( t_extensions__elem__dataptr >= t_end_of_data ) {
            extensions__elem_ = nullptr;
            goto end_of_extensions;
        }
        extensions__elem_ = new SSLExtension(rec());
        int t_extensions__elem__size;
        t_extensions__elem__size = extensions__elem_->Parse(t_extensions__elem__dataptr, t_end_of_data, t_context, t_byteorder);
        extensions_->push_back(extensions__elem_);
        t_extensions__elem__dataptr += t_extensions__elem__size;
        BINPAC_ASSERT(t_extensions__elem__dataptr <= t_end_of_data);
        extensions__elem_ = nullptr;
    }
end_of_extensions: ;
    t_extensions__size = t_extensions__elem__dataptr - (t_dataptr_after_ext_len);
    // Evaluate 'let' and 'withinput' fields

    int t_ServerHello13__size;
    const_byteptr const t_dataptr_after_extensions = t_dataptr_after_ext_len + (t_extensions__size);
    BINPAC_ASSERT(t_dataptr_after_extensions <= t_end_of_data);
    t_ServerHello13__size = t_dataptr_after_extensions - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    cipher_set_ = t_context->connection()->set_cipher((*(cipher_suite()))[0]);
    proc_ = t_context->connection()->proc_server_hello(server_version(), false, random(), nullptr, cipher_suite(), nullptr, 0);
    BINPAC_ASSERT(t_begin_of_data + (t_ServerHello13__size) <= t_end_of_data);
    return t_ServerHello13__size;
}

DirectionCheck::DirectionCheck(bool desired, HandshakeRecord* rec) {
    desired_ = desired;
    rec_ = rec;
    proc_ = false;
}

DirectionCheck::~DirectionCheck() {
}

int DirectionCheck::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Checking out-of-bound for "DirectionCheck"
    if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DirectionCheck",
        	(0) + (0), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->check_flipped(desired(), rec()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

HelloVerifyRequest::HelloVerifyRequest(HandshakeRecord* rec) {
    version_ = 0;
    cookie_length_ = 0;
    rec_ = rec;
}

HelloVerifyRequest::~HelloVerifyRequest() {
    cookie_.free();
}

int HelloVerifyRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "HelloVerifyRequest:cookie_length"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("HelloVerifyRequest:cookie_length",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "cookie_length"
    cookie_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "cookie"
    int t_cookie__size;
    t_cookie__size = cookie_length();
    // Checking out-of-bound for "HelloVerifyRequest:cookie"
    if ( (t_begin_of_data + 3) + (t_cookie__size) > t_end_of_data || (t_begin_of_data + 3) + (t_cookie__size) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("HelloVerifyRequest:cookie",
        	(3) + (t_cookie__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + t_cookie__size;
        int t_cookie_string_length;
        t_cookie_string_length = cookie_length();
        // check for negative sizes
        if ( t_cookie_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:161", t_cookie_string_length);
        cookie_.init((t_begin_of_data + 3), t_cookie_string_length);
    }

    int t_HelloVerifyRequest__size;
    const_byteptr const t_dataptr_after_cookie = (t_begin_of_data + 3) + (t_cookie__size);
    BINPAC_ASSERT(t_dataptr_after_cookie <= t_end_of_data);
    t_HelloVerifyRequest__size = t_dataptr_after_cookie - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_HelloVerifyRequest__size) <= t_end_of_data);
    return t_HelloVerifyRequest__size;
}

X509Certificate::X509Certificate() {
    length_ = nullptr;
}

X509Certificate::~X509Certificate() {
    delete length_;
    length_ = nullptr;
    certificate_.free();
}

int X509Certificate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "X509Certificate:length"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("X509Certificate:length",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = new uint24();
    length_->Parse(t_begin_of_data, t_end_of_data);

    // Parse "certificate"
    int t_certificate__size;
    t_certificate__size = to_int()(length());
    // Checking out-of-bound for "X509Certificate:certificate"
    if ( (t_begin_of_data + 3) + (t_certificate__size) > t_end_of_data || (t_begin_of_data + 3) + (t_certificate__size) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("X509Certificate:certificate",
        	(3) + (t_certificate__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + t_certificate__size;
        int t_certificate_string_length;
        t_certificate_string_length = to_int()(length());
        // check for negative sizes
        if ( t_certificate_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:170", t_certificate_string_length);
        certificate_.init((t_begin_of_data + 3), t_certificate_string_length);
    }

    int t_X509Certificate__size;
    const_byteptr const t_dataptr_after_certificate = (t_begin_of_data + 3) + (t_certificate__size);
    BINPAC_ASSERT(t_dataptr_after_certificate <= t_end_of_data);
    t_X509Certificate__size = t_dataptr_after_certificate - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_X509Certificate__size) <= t_end_of_data);
    return t_X509Certificate__size;
}

Certificate::Certificate(HandshakeRecord* rec) {
    length_ = nullptr;
    certificates_ = nullptr;
    certificates__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

Certificate::~Certificate() {
    delete length_;
    length_ = nullptr;
    delete certificates__elem_;
    certificates__elem_ = nullptr;
    if ( certificates() ) {
        for ( auto* certificates__elem_ : *certificates() ) {
            delete certificates__elem_;
            certificates__elem_ = nullptr;
        }
    }
    delete certificates_;
}

int Certificate::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    int t_Certificate__size;
    // Checking out-of-bound for "Certificate:length"
    if ( t_begin_of_data + (3) > t_end_of_data || t_begin_of_data + (3) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Certificate:length",
        	(0) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = new uint24();
    length_->Parse(t_begin_of_data, t_end_of_data);
    t_Certificate__size = to_int()(length()) + 3;
    // Checking out-of-bound for "Certificate"
    if ( t_begin_of_data + (t_Certificate__size) > t_end_of_data || t_begin_of_data + (t_Certificate__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Certificate",
        	(0) + (t_Certificate__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_Certificate__size;

        // Parse "certificates"
        int t_certificates__arraylength;
        t_certificates__arraylength = 0;
        certificates__elem_ = nullptr;
        int t_certificates__elem__it;
        t_certificates__elem__it = 0;
        int t_certificates__size;
        certificates_ = new vector<X509Certificate*>;
        const_byteptr t_certificates__elem__dataptr = (t_begin_of_data + 3);
        for (; /* forever */; ++t_certificates__elem__it) {
            // Check &until(certificates__elem__dataptr >= end_of_data)
            if ( t_certificates__elem__dataptr >= t_end_of_data ) {
                certificates__elem_ = nullptr;
                goto end_of_certificates;
            }
            certificates__elem_ = new X509Certificate();
            int t_certificates__elem__size;
            t_certificates__elem__size = certificates__elem_->Parse(t_certificates__elem__dataptr, t_end_of_data);
            certificates_->push_back(certificates__elem_);
            t_certificates__elem__dataptr += t_certificates__elem__size;
            BINPAC_ASSERT(t_certificates__elem__dataptr <= t_end_of_data);
            certificates__elem_ = nullptr;
        }
    end_of_certificates: ;
        t_certificates__size = t_certificates__elem__dataptr - ((t_begin_of_data + 3));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_v3_certificate(rec()->is_orig(), certificates());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_Certificate__size) <= t_end_of_data);
    return t_Certificate__size;
}

CertificateStatus::CertificateStatus(HandshakeRecord* rec) {
    status_type_ = 0;
    length_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

CertificateStatus::~CertificateStatus() {
    delete length_;
    length_ = nullptr;
    response_.free();
}

int CertificateStatus::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Checking out-of-bound for "CertificateStatus:length"
    if ( (t_begin_of_data + 1) + (3) > t_end_of_data || (t_begin_of_data + 1) + (3) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CertificateStatus:length",
        	(1) + (3), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "status_type"
    status_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "length"
    length_ = new uint24();
    length_->Parse((t_begin_of_data + 1), t_end_of_data);

    // Parse "response"
    int t_response_string_length;
    t_response_string_length = (t_end_of_data) - ((t_begin_of_data + 4));
    int t_response__size;
    t_response__size = t_response_string_length;
    // check for negative sizes
    if ( t_response_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:183", t_response_string_length);
    response_.init((t_begin_of_data + 4), t_response_string_length);

    int t_CertificateStatus__size;
    const_byteptr const t_dataptr_after_response = (t_begin_of_data + 4) + (t_response__size);
    BINPAC_ASSERT(t_dataptr_after_response <= t_end_of_data);
    t_CertificateStatus__size = t_dataptr_after_response - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_certificate_status(rec(), status_type(), response());
    BINPAC_ASSERT(t_begin_of_data + (t_CertificateStatus__size) <= t_end_of_data);
    return t_CertificateStatus__size;
}

ServerKeyExchange::ServerKeyExchange(HandshakeRecord* rec) {
    val_case_index_ = -1;
    ecdhe_server_key_exchange_ = nullptr;
    ecdh_anon_server_key_exchange_ = nullptr;
    dhe_server_key_exchange_ = nullptr;
    dh_anon_server_key_exchange_ = nullptr;
    rec_ = rec;
}

ServerKeyExchange::~ServerKeyExchange() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)49158):
        case ((int)49159):
        case ((int)49160):
        case ((int)49161):
        case ((int)49162):
        case ((int)49168):
        case ((int)49169):
        case ((int)49170):
        case ((int)49171):
        case ((int)49172):
        case ((int)49187):
        case ((int)49188):
        case ((int)49191):
        case ((int)49192):
        case ((int)49195):
        case ((int)49196):
        case ((int)49199):
        case ((int)49200):
        case ((int)49203):
        case ((int)49204):
        case ((int)49205):
        case ((int)49206):
        case ((int)49207):
        case ((int)49208):
        case ((int)49209):
        case ((int)49210):
        case ((int)49211):
        case ((int)49224):
        case ((int)49225):
        case ((int)49228):
        case ((int)49229):
        case ((int)49244):
        case ((int)49245):
        case ((int)49248):
        case ((int)49249):
        case ((int)49264):
        case ((int)49265):
        case ((int)49266):
        case ((int)49267):
        case ((int)49270):
        case ((int)49271):
        case ((int)49286):
        case ((int)49287):
        case ((int)49290):
        case ((int)49291):
        case ((int)49306):
        case ((int)49307):
        case ((int)49324):
        case ((int)49325):
        case ((int)49326):
        case ((int)49327):
        case ((int)52243):
        case ((int)52244):
        case ((int)52392):
        case ((int)52393):
        case ((int)53249):
        case ((int)53250):
        case ((int)53251):
        case ((int)53253):
            // Clean up "ecdhe_server_key_exchange"
            {
                delete ecdhe_server_key_exchange_;
                ecdhe_server_key_exchange_ = nullptr;
            }
            break;
        case ((int)49173):
        case ((int)49174):
        case ((int)49175):
        case ((int)49176):
        case ((int)49177):
            // Clean up "ecdh_anon_server_key_exchange"
            {
                delete ecdh_anon_server_key_exchange_;
                ecdh_anon_server_key_exchange_ = nullptr;
            }
            break;
        case ((int)17):
        case ((int)18):
        case ((int)19):
        case ((int)20):
        case ((int)21):
        case ((int)22):
        case ((int)50):
        case ((int)51):
        case ((int)56):
        case ((int)57):
        case ((int)64):
        case ((int)68):
        case ((int)69):
        case ((int)99):
        case ((int)101):
        case ((int)102):
        case ((int)103):
        case ((int)106):
        case ((int)107):
        case ((int)114):
        case ((int)115):
        case ((int)116):
        case ((int)119):
        case ((int)120):
        case ((int)121):
        case ((int)135):
        case ((int)136):
        case ((int)142):
        case ((int)143):
        case ((int)144):
        case ((int)145):
        case ((int)153):
        case ((int)154):
        case ((int)158):
        case ((int)159):
        case ((int)162):
        case ((int)163):
        case ((int)170):
        case ((int)171):
        case ((int)178):
        case ((int)179):
        case ((int)180):
        case ((int)181):
        case ((int)189):
        case ((int)190):
        case ((int)195):
        case ((int)196):
        case ((int)49218):
        case ((int)49219):
        case ((int)49220):
        case ((int)49221):
        case ((int)49234):
        case ((int)49235):
        case ((int)49238):
        case ((int)49239):
        case ((int)49254):
        case ((int)49255):
        case ((int)49260):
        case ((int)49261):
        case ((int)49276):
        case ((int)49277):
        case ((int)49280):
        case ((int)49281):
        case ((int)49296):
        case ((int)49297):
        case ((int)49302):
        case ((int)49303):
        case ((int)49310):
        case ((int)49311):
        case ((int)49314):
        case ((int)49315):
        case ((int)49318):
        case ((int)49319):
        case ((int)49322):
        case ((int)49323):
        case ((int)52245):
        case ((int)52394):
        case ((int)52397):
            // Clean up "dhe_server_key_exchange"
            {
                delete dhe_server_key_exchange_;
                dhe_server_key_exchange_ = nullptr;
            }
            break;
        case ((int)23):
        case ((int)24):
        case ((int)25):
        case ((int)26):
        case ((int)27):
        case ((int)52):
        case ((int)58):
        case ((int)70):
        case ((int)108):
        case ((int)109):
        case ((int)137):
        case ((int)155):
        case ((int)166):
        case ((int)167):
        case ((int)191):
        case ((int)197):
        case ((int)49222):
        case ((int)49223):
        case ((int)49242):
        case ((int)49243):
        case ((int)49284):
        case ((int)49285):
            // Clean up "dh_anon_server_key_exchange"
            {
                delete dh_anon_server_key_exchange_;
                dh_anon_server_key_exchange_ = nullptr;
            }
            break;
        default:
            // Clean up "key"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ServerKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = t_context->connection()->chosen_cipher();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)49158):
        case ((int)49159):
        case ((int)49160):
        case ((int)49161):
        case ((int)49162):
        case ((int)49168):
        case ((int)49169):
        case ((int)49170):
        case ((int)49171):
        case ((int)49172):
        case ((int)49187):
        case ((int)49188):
        case ((int)49191):
        case ((int)49192):
        case ((int)49195):
        case ((int)49196):
        case ((int)49199):
        case ((int)49200):
        case ((int)49203):
        case ((int)49204):
        case ((int)49205):
        case ((int)49206):
        case ((int)49207):
        case ((int)49208):
        case ((int)49209):
        case ((int)49210):
        case ((int)49211):
        case ((int)49224):
        case ((int)49225):
        case ((int)49228):
        case ((int)49229):
        case ((int)49244):
        case ((int)49245):
        case ((int)49248):
        case ((int)49249):
        case ((int)49264):
        case ((int)49265):
        case ((int)49266):
        case ((int)49267):
        case ((int)49270):
        case ((int)49271):
        case ((int)49286):
        case ((int)49287):
        case ((int)49290):
        case ((int)49291):
        case ((int)49306):
        case ((int)49307):
        case ((int)49324):
        case ((int)49325):
        case ((int)49326):
        case ((int)49327):
        case ((int)52243):
        case ((int)52244):
        case ((int)52392):
        case ((int)52393):
        case ((int)53249):
        case ((int)53250):
        case ((int)53251):
        case ((int)53253):
            // Parse "ecdhe_server_key_exchange"
            {
                ecdhe_server_key_exchange_ = new EcdheServerKeyExchange(rec());
                int t_ecdhe_server_key_exchange__size;
                t_ecdhe_server_key_exchange__size = ecdhe_server_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_ecdhe_server_key_exchange__size;
            }
            break;
        case ((int)49173):
        case ((int)49174):
        case ((int)49175):
        case ((int)49176):
        case ((int)49177):
            // Parse "ecdh_anon_server_key_exchange"
            {
                ecdh_anon_server_key_exchange_ = new EcdhAnonServerKeyExchange(rec());
                int t_ecdh_anon_server_key_exchange__size;
                t_ecdh_anon_server_key_exchange__size = ecdh_anon_server_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_ecdh_anon_server_key_exchange__size;
            }
            break;
        case ((int)17):
        case ((int)18):
        case ((int)19):
        case ((int)20):
        case ((int)21):
        case ((int)22):
        case ((int)50):
        case ((int)51):
        case ((int)56):
        case ((int)57):
        case ((int)64):
        case ((int)68):
        case ((int)69):
        case ((int)99):
        case ((int)101):
        case ((int)102):
        case ((int)103):
        case ((int)106):
        case ((int)107):
        case ((int)114):
        case ((int)115):
        case ((int)116):
        case ((int)119):
        case ((int)120):
        case ((int)121):
        case ((int)135):
        case ((int)136):
        case ((int)142):
        case ((int)143):
        case ((int)144):
        case ((int)145):
        case ((int)153):
        case ((int)154):
        case ((int)158):
        case ((int)159):
        case ((int)162):
        case ((int)163):
        case ((int)170):
        case ((int)171):
        case ((int)178):
        case ((int)179):
        case ((int)180):
        case ((int)181):
        case ((int)189):
        case ((int)190):
        case ((int)195):
        case ((int)196):
        case ((int)49218):
        case ((int)49219):
        case ((int)49220):
        case ((int)49221):
        case ((int)49234):
        case ((int)49235):
        case ((int)49238):
        case ((int)49239):
        case ((int)49254):
        case ((int)49255):
        case ((int)49260):
        case ((int)49261):
        case ((int)49276):
        case ((int)49277):
        case ((int)49280):
        case ((int)49281):
        case ((int)49296):
        case ((int)49297):
        case ((int)49302):
        case ((int)49303):
        case ((int)49310):
        case ((int)49311):
        case ((int)49314):
        case ((int)49315):
        case ((int)49318):
        case ((int)49319):
        case ((int)49322):
        case ((int)49323):
        case ((int)52245):
        case ((int)52394):
        case ((int)52397):
            // Parse "dhe_server_key_exchange"
            {
                dhe_server_key_exchange_ = new DheServerKeyExchange(rec());
                int t_dhe_server_key_exchange__size;
                t_dhe_server_key_exchange__size = dhe_server_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_dhe_server_key_exchange__size;
            }
            break;
        case ((int)23):
        case ((int)24):
        case ((int)25):
        case ((int)26):
        case ((int)27):
        case ((int)52):
        case ((int)58):
        case ((int)70):
        case ((int)108):
        case ((int)109):
        case ((int)137):
        case ((int)155):
        case ((int)166):
        case ((int)167):
        case ((int)191):
        case ((int)197):
        case ((int)49222):
        case ((int)49223):
        case ((int)49242):
        case ((int)49243):
        case ((int)49284):
        case ((int)49285):
            // Parse "dh_anon_server_key_exchange"
            {
                dh_anon_server_key_exchange_ = new DhAnonServerKeyExchange(rec());
                int t_dh_anon_server_key_exchange__size;
                t_dh_anon_server_key_exchange__size = dh_anon_server_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_dh_anon_server_key_exchange__size;
            }
            break;
        default:
            // Parse "key"
            {
                int t_key_string_length;
                t_key_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_key__size;
                t_key__size = t_key_string_length;
                // check for negative sizes
                if ( t_key_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:374", t_key_string_length);
                key_.init(t_begin_of_data, t_key_string_length);
                t_val__size = t_key__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

EcdheServerKeyExchange::EcdheServerKeyExchange(HandshakeRecord* rec) {
    curve_type_ = 0;
    named_curve_case_index_ = -1;
    params_ = nullptr;
    signature_case_index_ = -1;
    signed_params_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

EcdheServerKeyExchange::~EcdheServerKeyExchange() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( named_curve_case_index() ) {
        case ((uint8)3):
            // Clean up "params"
            {
                delete params_;
                params_ = nullptr;
            }
            break;
        default:
            // Clean up "data"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( signature_case_index() ) {
        case ((uint8)3):
            // Clean up "signed_params"
            {
                delete signed_params_;
                signed_params_ = nullptr;
            }
            break;
        default:
            // Clean up "nothing"
            {
                nothing_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int EcdheServerKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "EcdheServerKeyExchange:curve_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EcdheServerKeyExchange:curve_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "curve_type"
    curve_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "named_curve"
    int t_named_curve__size;
    named_curve_case_index_ = curve_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( named_curve_case_index() ) {
        case ((uint8)3):
            // Parse "params"
            {
                params_ = new ServerECDHParamsAndSignature();
                int t_params__size;
                t_params__size = params_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_named_curve__size = t_params__size;
            }
            break;
        default:
            // Parse "data"
            {
                int t_data_string_length;
                t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
                int t_data__size;
                t_data__size = t_data_string_length;
                // check for negative sizes
                if ( t_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:384", t_data_string_length);
                data_.init((t_begin_of_data + 1), t_data_string_length);
                t_named_curve__size = t_data__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_named_curve = (t_begin_of_data + 1) + (t_named_curve__size);
    BINPAC_ASSERT(t_dataptr_after_named_curve <= t_end_of_data);
    // Parse "signature"
    int t_signature__size;
    signature_case_index_ = curve_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( signature_case_index() ) {
        case ((uint8)3):
            // Parse "signed_params"
            {
                signed_params_ = new ServerKeyExchangeSignature();
                int t_signed_params__size;
                t_signed_params__size = signed_params_->Parse(t_dataptr_after_named_curve, t_end_of_data, t_context, t_byteorder);
                t_signature__size = t_signed_params__size;
            }
            break;
        default:
            // Parse "nothing"
            {
                // Checking out-of-bound for "EcdheServerKeyExchange:nothing"
                if ( t_dataptr_after_named_curve + (0) > t_end_of_data || t_dataptr_after_named_curve + (0) < t_dataptr_after_named_curve ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("EcdheServerKeyExchange:nothing",
                    	((t_dataptr_after_named_curve - t_begin_of_data)) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_named_curve + 0;
                    int t_nothing_string_length;
                    t_nothing_string_length = 0;
                    int t_nothing__size;
                    t_nothing__size = t_nothing_string_length;
                    nothing_.init(t_dataptr_after_named_curve, t_nothing_string_length);
                }
                t_signature__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_EcdheServerKeyExchange__size;
    const_byteptr const t_dataptr_after_signature = t_dataptr_after_named_curve + (t_signature__size);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    t_EcdheServerKeyExchange__size = t_dataptr_after_signature - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_ecdhe_server_key_exchange(this);
    BINPAC_ASSERT(t_begin_of_data + (t_EcdheServerKeyExchange__size) <= t_end_of_data);
    return t_EcdheServerKeyExchange__size;
}

ServerKeyExchangeSignature::ServerKeyExchangeSignature() {
    alg_case_index_ = -1;
    algorithm_ = nullptr;
    signature_length_ = 0;
    uses_signature_and_hashalgorithm_ = false;
}

ServerKeyExchangeSignature::~ServerKeyExchangeSignature() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( alg_case_index() ) {
        case true:
            // Clean up "algorithm"
            {
                delete algorithm_;
                algorithm_ = nullptr;
            }
            break;
        case false:
            // Clean up "nothing"
            {
                nothing_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    signature_.free();
}

int ServerKeyExchangeSignature::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Parse "alg"
    uses_signature_and_hashalgorithm_ =  ( t_context->connection()->chosen_version() > TLSv11 )  &&  ( t_context->connection()->chosen_version() != DTLSv10 ) ;
    int t_alg__size;
    alg_case_index_ = uses_signature_and_hashalgorithm();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( alg_case_index() ) {
        case true:
            // Parse "algorithm"
            {
                algorithm_ = new SignatureAndHashAlgorithm();
                algorithm_->Parse(t_begin_of_data, t_end_of_data);
                t_alg__size = 2;
            }
            break;
        case false:
            // Parse "nothing"
            {
                // Checking out-of-bound for "ServerKeyExchangeSignature:nothing"
                if ( t_begin_of_data + (0) > t_end_of_data || t_begin_of_data + (0) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("ServerKeyExchangeSignature:nothing",
                    	(0) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 0;
                    int t_nothing_string_length;
                    t_nothing_string_length = 0;
                    int t_nothing__size;
                    t_nothing__size = t_nothing_string_length;
                    nothing_.init(t_begin_of_data, t_nothing_string_length);
                }
                t_alg__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("ServerKeyExchangeSignature", (int64)alg_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_alg = t_begin_of_data + (t_alg__size);
    BINPAC_ASSERT(t_dataptr_after_alg <= t_end_of_data);
    // Checking out-of-bound for "ServerKeyExchangeSignature:signature_length"
    if ( t_dataptr_after_alg + (2) > t_end_of_data || t_dataptr_after_alg + (2) < t_dataptr_after_alg ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerKeyExchangeSignature:signature_length",
        	((t_dataptr_after_alg - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "signature_length"
    signature_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_alg)));

    // Parse "signature"
    int t_signature__size;
    t_signature__size = signature_length();
    // Checking out-of-bound for "ServerKeyExchangeSignature:signature"
    if ( (t_dataptr_after_alg + 2) + (t_signature__size) > t_end_of_data || (t_dataptr_after_alg + 2) + (t_signature__size) < (t_dataptr_after_alg + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerKeyExchangeSignature:signature",
        	(((t_dataptr_after_alg + 2) - t_begin_of_data)) + (t_signature__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_alg + 2) + t_signature__size;
        int t_signature_string_length;
        t_signature_string_length = signature_length();
        // check for negative sizes
        if ( t_signature_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:398", t_signature_string_length);
        signature_.init((t_dataptr_after_alg + 2), t_signature_string_length);
    }

    int t_ServerKeyExchangeSignature__size;
    const_byteptr const t_dataptr_after_signature = (t_dataptr_after_alg + 2) + (t_signature__size);
    BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
    t_ServerKeyExchangeSignature__size = t_dataptr_after_signature - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ServerKeyExchangeSignature__size) <= t_end_of_data);
    return t_ServerKeyExchangeSignature__size;
}

EcdhAnonServerKeyExchange::EcdhAnonServerKeyExchange(HandshakeRecord* rec) {
    curve_type_ = 0;
    named_curve_case_index_ = -1;
    params_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

EcdhAnonServerKeyExchange::~EcdhAnonServerKeyExchange() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( named_curve_case_index() ) {
        case ((uint8)3):
            // Clean up "params"
            {
                delete params_;
                params_ = nullptr;
            }
            break;
        default:
            // Clean up "data"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int EcdhAnonServerKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "EcdhAnonServerKeyExchange:curve_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EcdhAnonServerKeyExchange:curve_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "curve_type"
    curve_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "named_curve"
    int t_named_curve__size;
    named_curve_case_index_ = curve_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( named_curve_case_index() ) {
        case ((uint8)3):
            // Parse "params"
            {
                params_ = new ServerECDHParamsAndSignature();
                int t_params__size;
                t_params__size = params_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_named_curve__size = t_params__size;
            }
            break;
        default:
            // Parse "data"
            {
                int t_data_string_length;
                t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
                int t_data__size;
                t_data__size = t_data_string_length;
                // check for negative sizes
                if ( t_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:412", t_data_string_length);
                data_.init((t_begin_of_data + 1), t_data_string_length);
                t_named_curve__size = t_data__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_EcdhAnonServerKeyExchange__size;
    const_byteptr const t_dataptr_after_named_curve = (t_begin_of_data + 1) + (t_named_curve__size);
    BINPAC_ASSERT(t_dataptr_after_named_curve <= t_end_of_data);
    t_EcdhAnonServerKeyExchange__size = t_dataptr_after_named_curve - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_ecdh_anon_server_key_exchange(this);
    BINPAC_ASSERT(t_begin_of_data + (t_EcdhAnonServerKeyExchange__size) <= t_end_of_data);
    return t_EcdhAnonServerKeyExchange__size;
}

ServerECDHParamsAndSignature::ServerECDHParamsAndSignature() {
    curve_ = 0;
    point_length_ = 0;
}

ServerECDHParamsAndSignature::~ServerECDHParamsAndSignature() {
    point_.free();
}

int ServerECDHParamsAndSignature::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ServerECDHParamsAndSignature:point_length"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerECDHParamsAndSignature:point_length",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "curve"
    curve_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "point_length"
    point_length_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "point"
    int t_point__size;
    t_point__size = point_length();
    // Checking out-of-bound for "ServerECDHParamsAndSignature:point"
    if ( (t_begin_of_data + 3) + (t_point__size) > t_end_of_data || (t_begin_of_data + 3) + (t_point__size) < (t_begin_of_data + 3) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerECDHParamsAndSignature:point",
        	(3) + (t_point__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 3) + t_point__size;
        int t_point_string_length;
        t_point_string_length = point_length();
        // check for negative sizes
        if ( t_point_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:419", t_point_string_length);
        point_.init((t_begin_of_data + 3), t_point_string_length);
    }

    int t_ServerECDHParamsAndSignature__size;
    const_byteptr const t_dataptr_after_point = (t_begin_of_data + 3) + (t_point__size);
    BINPAC_ASSERT(t_dataptr_after_point <= t_end_of_data);
    t_ServerECDHParamsAndSignature__size = t_dataptr_after_point - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ServerECDHParamsAndSignature__size) <= t_end_of_data);
    return t_ServerECDHParamsAndSignature__size;
}

DheServerKeyExchange::DheServerKeyExchange(HandshakeRecord* rec) {
    dh_p_length_ = 0;
    dh_g_length_ = 0;
    dh_Ys_length_ = 0;
    signed_params_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

DheServerKeyExchange::~DheServerKeyExchange() {
    dh_p_.free();
    dh_g_.free();
    dh_Ys_.free();
    delete signed_params_;
    signed_params_ = nullptr;
}

int DheServerKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "DheServerKeyExchange:dh_p_length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DheServerKeyExchange:dh_p_length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dh_p_length"
    dh_p_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "dh_p"
    int t_dh_p__size;
    t_dh_p__size = dh_p_length();
    // Checking out-of-bound for "DheServerKeyExchange:dh_p"
    if ( (t_begin_of_data + 2) + (t_dh_p__size) > t_end_of_data || (t_begin_of_data + 2) + (t_dh_p__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DheServerKeyExchange:dh_p",
        	(2) + (t_dh_p__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_dh_p__size;
        int t_dh_p_string_length;
        t_dh_p_string_length = dh_p_length();
        // check for negative sizes
        if ( t_dh_p_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:426", t_dh_p_string_length);
        dh_p_.init((t_begin_of_data + 2), t_dh_p_string_length);
    }

    const_byteptr const t_dataptr_after_dh_p = (t_begin_of_data + 2) + (t_dh_p__size);
    BINPAC_ASSERT(t_dataptr_after_dh_p <= t_end_of_data);
    // Checking out-of-bound for "DheServerKeyExchange:dh_g_length"
    if ( t_dataptr_after_dh_p + (2) > t_end_of_data || t_dataptr_after_dh_p + (2) < t_dataptr_after_dh_p ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DheServerKeyExchange:dh_g_length",
        	((t_dataptr_after_dh_p - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dh_g_length"
    dh_g_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_dh_p)));

    // Parse "dh_g"
    int t_dh_g__size;
    t_dh_g__size = dh_g_length();
    // Checking out-of-bound for "DheServerKeyExchange:dh_g"
    if ( (t_dataptr_after_dh_p + 2) + (t_dh_g__size) > t_end_of_data || (t_dataptr_after_dh_p + 2) + (t_dh_g__size) < (t_dataptr_after_dh_p + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DheServerKeyExchange:dh_g",
        	(((t_dataptr_after_dh_p + 2) - t_begin_of_data)) + (t_dh_g__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_dh_p + 2) + t_dh_g__size;
        int t_dh_g_string_length;
        t_dh_g_string_length = dh_g_length();
        // check for negative sizes
        if ( t_dh_g_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:428", t_dh_g_string_length);
        dh_g_.init((t_dataptr_after_dh_p + 2), t_dh_g_string_length);
    }

    const_byteptr const t_dataptr_after_dh_g = (t_dataptr_after_dh_p + 2) + (t_dh_g__size);
    BINPAC_ASSERT(t_dataptr_after_dh_g <= t_end_of_data);
    // Checking out-of-bound for "DheServerKeyExchange:dh_Ys_length"
    if ( t_dataptr_after_dh_g + (2) > t_end_of_data || t_dataptr_after_dh_g + (2) < t_dataptr_after_dh_g ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DheServerKeyExchange:dh_Ys_length",
        	((t_dataptr_after_dh_g - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dh_Ys_length"
    dh_Ys_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_dh_g)));

    // Parse "dh_Ys"
    int t_dh_Ys__size;
    t_dh_Ys__size = dh_Ys_length();
    // Checking out-of-bound for "DheServerKeyExchange:dh_Ys"
    if ( (t_dataptr_after_dh_g + 2) + (t_dh_Ys__size) > t_end_of_data || (t_dataptr_after_dh_g + 2) + (t_dh_Ys__size) < (t_dataptr_after_dh_g + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DheServerKeyExchange:dh_Ys",
        	(((t_dataptr_after_dh_g + 2) - t_begin_of_data)) + (t_dh_Ys__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_dh_g + 2) + t_dh_Ys__size;
        int t_dh_Ys_string_length;
        t_dh_Ys_string_length = dh_Ys_length();
        // check for negative sizes
        if ( t_dh_Ys_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:430", t_dh_Ys_string_length);
        dh_Ys_.init((t_dataptr_after_dh_g + 2), t_dh_Ys_string_length);
    }

    const_byteptr const t_dataptr_after_dh_Ys = (t_dataptr_after_dh_g + 2) + (t_dh_Ys__size);
    BINPAC_ASSERT(t_dataptr_after_dh_Ys <= t_end_of_data);
    // Parse "signed_params"
    signed_params_ = new ServerKeyExchangeSignature();
    int t_signed_params__size;
    t_signed_params__size = signed_params_->Parse(t_dataptr_after_dh_Ys, t_end_of_data, t_context, t_byteorder);

    int t_DheServerKeyExchange__size;
    const_byteptr const t_dataptr_after_signed_params = t_dataptr_after_dh_Ys + (t_signed_params__size);
    BINPAC_ASSERT(t_dataptr_after_signed_params <= t_end_of_data);
    t_DheServerKeyExchange__size = t_dataptr_after_signed_params - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_dhe_server_key_exchange(rec(), dh_p(), dh_g(), dh_Ys(), signed_params());
    BINPAC_ASSERT(t_begin_of_data + (t_DheServerKeyExchange__size) <= t_end_of_data);
    return t_DheServerKeyExchange__size;
}

DhAnonServerKeyExchange::DhAnonServerKeyExchange(HandshakeRecord* rec) {
    dh_p_length_ = 0;
    dh_g_length_ = 0;
    dh_Ys_length_ = 0;
    rec_ = rec;
    proc_ = false;
}

DhAnonServerKeyExchange::~DhAnonServerKeyExchange() {
    dh_p_.free();
    dh_g_.free();
    dh_Ys_.free();
}

int DhAnonServerKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "DhAnonServerKeyExchange:dh_p_length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DhAnonServerKeyExchange:dh_p_length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dh_p_length"
    dh_p_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "dh_p"
    int t_dh_p__size;
    t_dh_p__size = dh_p_length();
    // Checking out-of-bound for "DhAnonServerKeyExchange:dh_p"
    if ( (t_begin_of_data + 2) + (t_dh_p__size) > t_end_of_data || (t_begin_of_data + 2) + (t_dh_p__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DhAnonServerKeyExchange:dh_p",
        	(2) + (t_dh_p__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_dh_p__size;
        int t_dh_p_string_length;
        t_dh_p_string_length = dh_p_length();
        // check for negative sizes
        if ( t_dh_p_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:438", t_dh_p_string_length);
        dh_p_.init((t_begin_of_data + 2), t_dh_p_string_length);
    }

    const_byteptr const t_dataptr_after_dh_p = (t_begin_of_data + 2) + (t_dh_p__size);
    BINPAC_ASSERT(t_dataptr_after_dh_p <= t_end_of_data);
    // Checking out-of-bound for "DhAnonServerKeyExchange:dh_g_length"
    if ( t_dataptr_after_dh_p + (2) > t_end_of_data || t_dataptr_after_dh_p + (2) < t_dataptr_after_dh_p ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DhAnonServerKeyExchange:dh_g_length",
        	((t_dataptr_after_dh_p - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dh_g_length"
    dh_g_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_dh_p)));

    // Parse "dh_g"
    int t_dh_g__size;
    t_dh_g__size = dh_g_length();
    // Checking out-of-bound for "DhAnonServerKeyExchange:dh_g"
    if ( (t_dataptr_after_dh_p + 2) + (t_dh_g__size) > t_end_of_data || (t_dataptr_after_dh_p + 2) + (t_dh_g__size) < (t_dataptr_after_dh_p + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DhAnonServerKeyExchange:dh_g",
        	(((t_dataptr_after_dh_p + 2) - t_begin_of_data)) + (t_dh_g__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_dh_p + 2) + t_dh_g__size;
        int t_dh_g_string_length;
        t_dh_g_string_length = dh_g_length();
        // check for negative sizes
        if ( t_dh_g_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:440", t_dh_g_string_length);
        dh_g_.init((t_dataptr_after_dh_p + 2), t_dh_g_string_length);
    }

    const_byteptr const t_dataptr_after_dh_g = (t_dataptr_after_dh_p + 2) + (t_dh_g__size);
    BINPAC_ASSERT(t_dataptr_after_dh_g <= t_end_of_data);
    // Checking out-of-bound for "DhAnonServerKeyExchange:dh_Ys_length"
    if ( t_dataptr_after_dh_g + (2) > t_end_of_data || t_dataptr_after_dh_g + (2) < t_dataptr_after_dh_g ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DhAnonServerKeyExchange:dh_Ys_length",
        	((t_dataptr_after_dh_g - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "dh_Ys_length"
    dh_Ys_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_dh_g)));

    // Parse "dh_Ys"
    int t_dh_Ys__size;
    t_dh_Ys__size = dh_Ys_length();
    // Checking out-of-bound for "DhAnonServerKeyExchange:dh_Ys"
    if ( (t_dataptr_after_dh_g + 2) + (t_dh_Ys__size) > t_end_of_data || (t_dataptr_after_dh_g + 2) + (t_dh_Ys__size) < (t_dataptr_after_dh_g + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("DhAnonServerKeyExchange:dh_Ys",
        	(((t_dataptr_after_dh_g + 2) - t_begin_of_data)) + (t_dh_Ys__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_dh_g + 2) + t_dh_Ys__size;
        int t_dh_Ys_string_length;
        t_dh_Ys_string_length = dh_Ys_length();
        // check for negative sizes
        if ( t_dh_Ys_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:442", t_dh_Ys_string_length);
        dh_Ys_.init((t_dataptr_after_dh_g + 2), t_dh_Ys_string_length);
    }

    const_byteptr const t_dataptr_after_dh_Ys = (t_dataptr_after_dh_g + 2) + (t_dh_Ys__size);
    BINPAC_ASSERT(t_dataptr_after_dh_Ys <= t_end_of_data);
    // Parse "data"
    int t_data_string_length;
    t_data_string_length = (t_end_of_data) - (t_dataptr_after_dh_Ys);
    int t_data__size;
    t_data__size = t_data_string_length;
    // check for negative sizes
    if ( t_data_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:443", t_data_string_length);
    data_.init(t_dataptr_after_dh_Ys, t_data_string_length);

    int t_DhAnonServerKeyExchange__size;
    const_byteptr const t_dataptr_after_data = t_dataptr_after_dh_Ys + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_DhAnonServerKeyExchange__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_dh_anon_server_key_exchange(rec(), dh_p(), dh_g(), dh_Ys());
    BINPAC_ASSERT(t_begin_of_data + (t_DhAnonServerKeyExchange__size) <= t_end_of_data);
    return t_DhAnonServerKeyExchange__size;
}

CertificateAuthorities::CertificateAuthorities() {
    certificate_authority_len_ = 0;
}

CertificateAuthorities::~CertificateAuthorities() {
    certificate_authority_.free();
}

int CertificateAuthorities::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "CertificateAuthorities:certificate_authority_len"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CertificateAuthorities:certificate_authority_len",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "certificate_authority_len"
    certificate_authority_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "certificate_authority"
    int t_certificate_authority__size;
    t_certificate_authority__size = certificate_authority_len();
    // Checking out-of-bound for "CertificateAuthorities:certificate_authority"
    if ( (t_begin_of_data + 2) + (t_certificate_authority__size) > t_end_of_data || (t_begin_of_data + 2) + (t_certificate_authority__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CertificateAuthorities:certificate_authority",
        	(2) + (t_certificate_authority__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_certificate_authority__size;
        int t_certificate_authority_string_length;
        t_certificate_authority_string_length = certificate_authority_len();
        // check for negative sizes
        if ( t_certificate_authority_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:452", t_certificate_authority_string_length);
        certificate_authority_.init((t_begin_of_data + 2), t_certificate_authority_string_length);
    }

    int t_CertificateAuthorities__size;
    const_byteptr const t_dataptr_after_certificate_authority = (t_begin_of_data + 2) + (t_certificate_authority__size);
    BINPAC_ASSERT(t_dataptr_after_certificate_authority <= t_end_of_data);
    t_CertificateAuthorities__size = t_dataptr_after_certificate_authority - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_CertificateAuthorities__size) <= t_end_of_data);
    return t_CertificateAuthorities__size;
}

CertificateAuthoritiesContainer::CertificateAuthoritiesContainer() {
    certificate_authorities_ = nullptr;
    certificate_authorities__elem_ = nullptr;
}

CertificateAuthoritiesContainer::~CertificateAuthoritiesContainer() {
    delete certificate_authorities__elem_;
    certificate_authorities__elem_ = nullptr;
    if ( certificate_authorities() ) {
        for ( auto* certificate_authorities__elem_ : *certificate_authorities() ) {
            delete certificate_authorities__elem_;
            certificate_authorities__elem_ = nullptr;
        }
    }
    delete certificate_authorities_;
}

int CertificateAuthoritiesContainer::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "certificate_authorities"
    int t_certificate_authorities__arraylength;
    t_certificate_authorities__arraylength = 0;
    certificate_authorities__elem_ = nullptr;
    int t_certificate_authorities__elem__it;
    t_certificate_authorities__elem__it = 0;
    int t_certificate_authorities__size;
    certificate_authorities_ = new vector<CertificateAuthorities*>;
    const_byteptr t_certificate_authorities__elem__dataptr = t_begin_of_data;
    for (; /* forever */; ++t_certificate_authorities__elem__it) {
        // Check &until(certificate_authorities__elem__dataptr >= end_of_data)
        if ( t_certificate_authorities__elem__dataptr >= t_end_of_data ) {
            certificate_authorities__elem_ = nullptr;
            goto end_of_certificate_authorities;
        }
        certificate_authorities__elem_ = new CertificateAuthorities();
        int t_certificate_authorities__elem__size;
        t_certificate_authorities__elem__size = certificate_authorities__elem_->Parse(t_certificate_authorities__elem__dataptr, t_end_of_data, t_byteorder);
        certificate_authorities_->push_back(certificate_authorities__elem_);
        t_certificate_authorities__elem__dataptr += t_certificate_authorities__elem__size;
        BINPAC_ASSERT(t_certificate_authorities__elem__dataptr <= t_end_of_data);
        certificate_authorities__elem_ = nullptr;
    }
end_of_certificate_authorities: ;
    t_certificate_authorities__size = t_certificate_authorities__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_CertificateAuthoritiesContainer__size;
    const_byteptr const t_dataptr_after_certificate_authorities = t_begin_of_data + (t_certificate_authorities__size);
    BINPAC_ASSERT(t_dataptr_after_certificate_authorities <= t_end_of_data);
    t_CertificateAuthoritiesContainer__size = t_dataptr_after_certificate_authorities - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_CertificateAuthoritiesContainer__size) <= t_end_of_data);
    return t_CertificateAuthoritiesContainer__size;
}

CertificateRequest::CertificateRequest(HandshakeRecord* rec) {
    certificate_types_len_ = 0;
    certificate_types_ = nullptr;
    certificate_types__elem_ = 0;
    alg_case_index_ = -1;
    supported_signature_algorithms_ = nullptr;
    certificate_authorities_len_ = 0;
    certificate_authorities_ = nullptr;
    rec_ = rec;
    uses_signature_and_hashalgorithm_ = false;
    proc_ = false;
}

CertificateRequest::~CertificateRequest() {
    delete certificate_types_;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( alg_case_index() ) {
        case true:
            // Clean up "supported_signature_algorithms"
            {
                delete supported_signature_algorithms_;
                supported_signature_algorithms_ = nullptr;
            }
            break;
        case false:
            // Clean up "nothing"
            {
                nothing_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete certificate_authorities_;
    certificate_authorities_ = nullptr;
}

int CertificateRequest::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "CertificateRequest:certificate_types_len"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CertificateRequest:certificate_types_len",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "certificate_types_len"
    certificate_types_len_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "certificate_types"
    int t_certificate_types__arraylength;
    t_certificate_types__arraylength = certificate_types_len();
    if ( t_certificate_types__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("CertificateRequest:certificate_types",
          t_certificate_types__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: CertificateRequest:certificate_types
    if ( t_certificate_types__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("CertificateRequest:certificate_types",
          t_certificate_types__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
    certificate_types__elem_ = 0;
    int t_certificate_types__elem__it;
    t_certificate_types__elem__it = 0;
    int t_certificate_types__size;
    certificate_types_ = new vector<uint8>;
    certificate_types_->reserve(t_certificate_types__arraylength);
    const_byteptr t_certificate_types__elem__dataptr = (t_begin_of_data + 1);
    for (; t_certificate_types__elem__it < t_certificate_types__arraylength; ++t_certificate_types__elem__it) {
        certificate_types__elem_ = *(reinterpret_cast<uint8 const*>(t_certificate_types__elem__dataptr));
        certificate_types_->push_back(certificate_types__elem_);
        t_certificate_types__elem__dataptr += 1;
        BINPAC_ASSERT(t_certificate_types__elem__dataptr <= t_end_of_data);
    }
end_of_certificate_types: ;
    t_certificate_types__size = t_certificate_types__elem__dataptr - ((t_begin_of_data + 1));
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_certificate_types = (t_begin_of_data + 1) + (t_certificate_types__size);
    BINPAC_ASSERT(t_dataptr_after_certificate_types <= t_end_of_data);
    // Parse "alg"
    uses_signature_and_hashalgorithm_ =  ( t_context->connection()->chosen_version() > TLSv11 )  &&  ( t_context->connection()->chosen_version() != DTLSv10 ) ;
    int t_alg__size;
    alg_case_index_ = uses_signature_and_hashalgorithm();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( alg_case_index() ) {
        case true:
            // Parse "supported_signature_algorithms"
            {
                supported_signature_algorithms_ = new SignatureAlgorithm(rec());
                int t_supported_signature_algorithms__size;
                t_supported_signature_algorithms__size = supported_signature_algorithms_->Parse(t_dataptr_after_certificate_types, t_end_of_data, t_context, t_byteorder);
                t_alg__size = t_supported_signature_algorithms__size;
            }
            break;
        case false:
            // Parse "nothing"
            {
                // Checking out-of-bound for "CertificateRequest:nothing"
                if ( t_dataptr_after_certificate_types + (0) > t_end_of_data || t_dataptr_after_certificate_types + (0) < t_dataptr_after_certificate_types ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("CertificateRequest:nothing",
                    	((t_dataptr_after_certificate_types - t_begin_of_data)) + (0), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_dataptr_after_certificate_types + 0;
                    int t_nothing_string_length;
                    t_nothing_string_length = 0;
                    int t_nothing__size;
                    t_nothing__size = t_nothing_string_length;
                    nothing_.init(t_dataptr_after_certificate_types, t_nothing_string_length);
                }
                t_alg__size = 0;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("CertificateRequest", (int64)alg_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_alg = t_dataptr_after_certificate_types + (t_alg__size);
    BINPAC_ASSERT(t_dataptr_after_alg <= t_end_of_data);
    // Checking out-of-bound for "CertificateRequest:certificate_authorities_len"
    if ( t_dataptr_after_alg + (2) > t_end_of_data || t_dataptr_after_alg + (2) < t_dataptr_after_alg ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CertificateRequest:certificate_authorities_len",
        	((t_dataptr_after_alg - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "certificate_authorities_len"
    certificate_authorities_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_alg)));

    // Parse "certificate_authorities"
    certificate_authorities_ = new CertificateAuthoritiesContainer();
    int t_certificate_authorities__size;
    t_certificate_authorities__size = certificate_authorities_len();
    // Checking out-of-bound for "CertificateRequest:certificate_authorities"
    if ( (t_dataptr_after_alg + 2) + (t_certificate_authorities__size) > t_end_of_data || (t_dataptr_after_alg + 2) + (t_certificate_authorities__size) < (t_dataptr_after_alg + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("CertificateRequest:certificate_authorities",
        	(((t_dataptr_after_alg + 2) - t_begin_of_data)) + (t_certificate_authorities__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_dataptr_after_alg + 2) + t_certificate_authorities__size;
        certificate_authorities_->Parse((t_dataptr_after_alg + 2), t_end_of_data, t_byteorder);
    }

    const_byteptr const t_dataptr_after_certificate_authorities = (t_dataptr_after_alg + 2) + (t_certificate_authorities__size);
    BINPAC_ASSERT(t_dataptr_after_certificate_authorities <= t_end_of_data);
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_dataptr_after_certificate_authorities);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:469", t_cont_string_length);
    cont_.init(t_dataptr_after_certificate_authorities, t_cont_string_length);

    int t_CertificateRequest__size;
    const_byteptr const t_dataptr_after_cont = t_dataptr_after_certificate_authorities + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_CertificateRequest__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_certificate_request(rec(), this);
    BINPAC_ASSERT(t_begin_of_data + (t_CertificateRequest__size) <= t_end_of_data);
    return t_CertificateRequest__size;
}

ServerHelloDone::ServerHelloDone(HandshakeRecord* rec) {
    rec_ = rec;
}

ServerHelloDone::~ServerHelloDone() {
}

int ServerHelloDone::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (0) <= t_end_of_data);
    return 0;
}

ClientKeyExchange::ClientKeyExchange(HandshakeRecord* rec) {
    val_case_index_ = -1;
    rsa_client_key_exchange_ = nullptr;
    ecdh_client_key_exchange_ = nullptr;
    dh_server_key_exchange_ = nullptr;
    rec_ = rec;
}

ClientKeyExchange::~ClientKeyExchange() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
        case ((int)2):
        case ((int)3):
        case ((int)4):
        case ((int)5):
        case ((int)6):
        case ((int)7):
        case ((int)8):
        case ((int)9):
        case ((int)10):
        case ((int)47):
        case ((int)53):
        case ((int)59):
        case ((int)60):
        case ((int)61):
        case ((int)65):
        case ((int)96):
        case ((int)97):
        case ((int)98):
        case ((int)100):
        case ((int)124):
        case ((int)125):
        case ((int)126):
        case ((int)132):
        case ((int)146):
        case ((int)147):
        case ((int)148):
        case ((int)149):
        case ((int)150):
        case ((int)156):
        case ((int)157):
        case ((int)182):
        case ((int)183):
        case ((int)184):
        case ((int)185):
        case ((int)186):
        case ((int)192):
        case ((int)49212):
        case ((int)49213):
        case ((int)49232):
        case ((int)49233):
        case ((int)49256):
        case ((int)49257):
        case ((int)49262):
        case ((int)49263):
        case ((int)49274):
        case ((int)49275):
        case ((int)49298):
        case ((int)49299):
        case ((int)49304):
        case ((int)49305):
        case ((int)49308):
        case ((int)49309):
        case ((int)49312):
        case ((int)49313):
            // Clean up "rsa_client_key_exchange"
            {
                delete rsa_client_key_exchange_;
                rsa_client_key_exchange_ = nullptr;
            }
            break;
        case ((int)49153):
        case ((int)49154):
        case ((int)49155):
        case ((int)49156):
        case ((int)49157):
        case ((int)49158):
        case ((int)49159):
        case ((int)49160):
        case ((int)49161):
        case ((int)49162):
        case ((int)49163):
        case ((int)49164):
        case ((int)49165):
        case ((int)49166):
        case ((int)49167):
        case ((int)49168):
        case ((int)49169):
        case ((int)49170):
        case ((int)49171):
        case ((int)49172):
        case ((int)49173):
        case ((int)49174):
        case ((int)49175):
        case ((int)49176):
        case ((int)49177):
        case ((int)49187):
        case ((int)49188):
        case ((int)49189):
        case ((int)49190):
        case ((int)49191):
        case ((int)49192):
        case ((int)49193):
        case ((int)49194):
        case ((int)49195):
        case ((int)49196):
        case ((int)49197):
        case ((int)49198):
        case ((int)49199):
        case ((int)49200):
        case ((int)49201):
        case ((int)49202):
        case ((int)49203):
        case ((int)49204):
        case ((int)49205):
        case ((int)49206):
        case ((int)49207):
        case ((int)49208):
        case ((int)49209):
        case ((int)49210):
        case ((int)49211):
        case ((int)49224):
        case ((int)49225):
        case ((int)49226):
        case ((int)49227):
        case ((int)49228):
        case ((int)49229):
        case ((int)49230):
        case ((int)49231):
        case ((int)49244):
        case ((int)49245):
        case ((int)49246):
        case ((int)49247):
        case ((int)49248):
        case ((int)49249):
        case ((int)49250):
        case ((int)49251):
        case ((int)49264):
        case ((int)49265):
        case ((int)49266):
        case ((int)49267):
        case ((int)49268):
        case ((int)49269):
        case ((int)49270):
        case ((int)49271):
        case ((int)49272):
        case ((int)49273):
        case ((int)49286):
        case ((int)49287):
        case ((int)49288):
        case ((int)49289):
        case ((int)49290):
        case ((int)49291):
        case ((int)49292):
        case ((int)49293):
        case ((int)49306):
        case ((int)49307):
        case ((int)49324):
        case ((int)49325):
        case ((int)49326):
        case ((int)49327):
        case ((int)52392):
        case ((int)52393):
            // Clean up "ecdh_client_key_exchange"
            {
                delete ecdh_client_key_exchange_;
                ecdh_client_key_exchange_ = nullptr;
            }
            break;
        case ((int)17):
        case ((int)18):
        case ((int)19):
        case ((int)20):
        case ((int)21):
        case ((int)22):
        case ((int)50):
        case ((int)51):
        case ((int)56):
        case ((int)57):
        case ((int)64):
        case ((int)68):
        case ((int)69):
        case ((int)99):
        case ((int)101):
        case ((int)102):
        case ((int)103):
        case ((int)106):
        case ((int)107):
        case ((int)114):
        case ((int)115):
        case ((int)116):
        case ((int)119):
        case ((int)120):
        case ((int)121):
        case ((int)135):
        case ((int)136):
        case ((int)142):
        case ((int)143):
        case ((int)144):
        case ((int)145):
        case ((int)153):
        case ((int)154):
        case ((int)158):
        case ((int)159):
        case ((int)162):
        case ((int)163):
        case ((int)170):
        case ((int)171):
        case ((int)178):
        case ((int)179):
        case ((int)180):
        case ((int)181):
        case ((int)189):
        case ((int)190):
        case ((int)195):
        case ((int)196):
        case ((int)49218):
        case ((int)49219):
        case ((int)49220):
        case ((int)49221):
        case ((int)49234):
        case ((int)49235):
        case ((int)49238):
        case ((int)49239):
        case ((int)49254):
        case ((int)49255):
        case ((int)49260):
        case ((int)49261):
        case ((int)49276):
        case ((int)49277):
        case ((int)49280):
        case ((int)49281):
        case ((int)49296):
        case ((int)49297):
        case ((int)49302):
        case ((int)49303):
        case ((int)49310):
        case ((int)49311):
        case ((int)49314):
        case ((int)49315):
        case ((int)49318):
        case ((int)49319):
        case ((int)49322):
        case ((int)49323):
        case ((int)52394):
        case ((int)23):
        case ((int)24):
        case ((int)25):
        case ((int)26):
        case ((int)27):
        case ((int)52):
        case ((int)58):
        case ((int)70):
        case ((int)108):
        case ((int)109):
        case ((int)137):
        case ((int)155):
        case ((int)166):
        case ((int)167):
        case ((int)191):
        case ((int)197):
        case ((int)49222):
        case ((int)49223):
        case ((int)49242):
        case ((int)49243):
        case ((int)49284):
        case ((int)49285):
            // Clean up "dh_server_key_exchange"
            {
                delete dh_server_key_exchange_;
                dh_server_key_exchange_ = nullptr;
            }
            break;
        default:
            // Clean up "key"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ClientKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    int t_val__size;
    val_case_index_ = t_context->connection()->chosen_cipher();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
        case ((int)2):
        case ((int)3):
        case ((int)4):
        case ((int)5):
        case ((int)6):
        case ((int)7):
        case ((int)8):
        case ((int)9):
        case ((int)10):
        case ((int)47):
        case ((int)53):
        case ((int)59):
        case ((int)60):
        case ((int)61):
        case ((int)65):
        case ((int)96):
        case ((int)97):
        case ((int)98):
        case ((int)100):
        case ((int)124):
        case ((int)125):
        case ((int)126):
        case ((int)132):
        case ((int)146):
        case ((int)147):
        case ((int)148):
        case ((int)149):
        case ((int)150):
        case ((int)156):
        case ((int)157):
        case ((int)182):
        case ((int)183):
        case ((int)184):
        case ((int)185):
        case ((int)186):
        case ((int)192):
        case ((int)49212):
        case ((int)49213):
        case ((int)49232):
        case ((int)49233):
        case ((int)49256):
        case ((int)49257):
        case ((int)49262):
        case ((int)49263):
        case ((int)49274):
        case ((int)49275):
        case ((int)49298):
        case ((int)49299):
        case ((int)49304):
        case ((int)49305):
        case ((int)49308):
        case ((int)49309):
        case ((int)49312):
        case ((int)49313):
            // Parse "rsa_client_key_exchange"
            {
                rsa_client_key_exchange_ = new RsaClientKeyExchange(rec());
                int t_rsa_client_key_exchange__size;
                t_rsa_client_key_exchange__size = rsa_client_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_rsa_client_key_exchange__size;
            }
            break;
        case ((int)49153):
        case ((int)49154):
        case ((int)49155):
        case ((int)49156):
        case ((int)49157):
        case ((int)49158):
        case ((int)49159):
        case ((int)49160):
        case ((int)49161):
        case ((int)49162):
        case ((int)49163):
        case ((int)49164):
        case ((int)49165):
        case ((int)49166):
        case ((int)49167):
        case ((int)49168):
        case ((int)49169):
        case ((int)49170):
        case ((int)49171):
        case ((int)49172):
        case ((int)49173):
        case ((int)49174):
        case ((int)49175):
        case ((int)49176):
        case ((int)49177):
        case ((int)49187):
        case ((int)49188):
        case ((int)49189):
        case ((int)49190):
        case ((int)49191):
        case ((int)49192):
        case ((int)49193):
        case ((int)49194):
        case ((int)49195):
        case ((int)49196):
        case ((int)49197):
        case ((int)49198):
        case ((int)49199):
        case ((int)49200):
        case ((int)49201):
        case ((int)49202):
        case ((int)49203):
        case ((int)49204):
        case ((int)49205):
        case ((int)49206):
        case ((int)49207):
        case ((int)49208):
        case ((int)49209):
        case ((int)49210):
        case ((int)49211):
        case ((int)49224):
        case ((int)49225):
        case ((int)49226):
        case ((int)49227):
        case ((int)49228):
        case ((int)49229):
        case ((int)49230):
        case ((int)49231):
        case ((int)49244):
        case ((int)49245):
        case ((int)49246):
        case ((int)49247):
        case ((int)49248):
        case ((int)49249):
        case ((int)49250):
        case ((int)49251):
        case ((int)49264):
        case ((int)49265):
        case ((int)49266):
        case ((int)49267):
        case ((int)49268):
        case ((int)49269):
        case ((int)49270):
        case ((int)49271):
        case ((int)49272):
        case ((int)49273):
        case ((int)49286):
        case ((int)49287):
        case ((int)49288):
        case ((int)49289):
        case ((int)49290):
        case ((int)49291):
        case ((int)49292):
        case ((int)49293):
        case ((int)49306):
        case ((int)49307):
        case ((int)49324):
        case ((int)49325):
        case ((int)49326):
        case ((int)49327):
        case ((int)52392):
        case ((int)52393):
            // Parse "ecdh_client_key_exchange"
            {
                ecdh_client_key_exchange_ = new EcdhClientKeyExchange(rec());
                int t_ecdh_client_key_exchange__size;
                t_ecdh_client_key_exchange__size = ecdh_client_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_ecdh_client_key_exchange__size;
            }
            break;
        case ((int)17):
        case ((int)18):
        case ((int)19):
        case ((int)20):
        case ((int)21):
        case ((int)22):
        case ((int)50):
        case ((int)51):
        case ((int)56):
        case ((int)57):
        case ((int)64):
        case ((int)68):
        case ((int)69):
        case ((int)99):
        case ((int)101):
        case ((int)102):
        case ((int)103):
        case ((int)106):
        case ((int)107):
        case ((int)114):
        case ((int)115):
        case ((int)116):
        case ((int)119):
        case ((int)120):
        case ((int)121):
        case ((int)135):
        case ((int)136):
        case ((int)142):
        case ((int)143):
        case ((int)144):
        case ((int)145):
        case ((int)153):
        case ((int)154):
        case ((int)158):
        case ((int)159):
        case ((int)162):
        case ((int)163):
        case ((int)170):
        case ((int)171):
        case ((int)178):
        case ((int)179):
        case ((int)180):
        case ((int)181):
        case ((int)189):
        case ((int)190):
        case ((int)195):
        case ((int)196):
        case ((int)49218):
        case ((int)49219):
        case ((int)49220):
        case ((int)49221):
        case ((int)49234):
        case ((int)49235):
        case ((int)49238):
        case ((int)49239):
        case ((int)49254):
        case ((int)49255):
        case ((int)49260):
        case ((int)49261):
        case ((int)49276):
        case ((int)49277):
        case ((int)49280):
        case ((int)49281):
        case ((int)49296):
        case ((int)49297):
        case ((int)49302):
        case ((int)49303):
        case ((int)49310):
        case ((int)49311):
        case ((int)49314):
        case ((int)49315):
        case ((int)49318):
        case ((int)49319):
        case ((int)49322):
        case ((int)49323):
        case ((int)52394):
        case ((int)23):
        case ((int)24):
        case ((int)25):
        case ((int)26):
        case ((int)27):
        case ((int)52):
        case ((int)58):
        case ((int)70):
        case ((int)108):
        case ((int)109):
        case ((int)137):
        case ((int)155):
        case ((int)166):
        case ((int)167):
        case ((int)191):
        case ((int)197):
        case ((int)49222):
        case ((int)49223):
        case ((int)49242):
        case ((int)49243):
        case ((int)49284):
        case ((int)49285):
            // Parse "dh_server_key_exchange"
            {
                dh_server_key_exchange_ = new DhClientKeyExchange(rec());
                int t_dh_server_key_exchange__size;
                t_dh_server_key_exchange__size = dh_server_key_exchange_->Parse(t_begin_of_data, t_end_of_data, t_context);
                t_val__size = t_dh_server_key_exchange__size;
            }
            break;
        default:
            // Parse "key"
            {
                int t_key_string_length;
                t_key_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_key__size;
                t_key__size = t_key_string_length;
                // check for negative sizes
                if ( t_key_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:759", t_key_string_length);
                key_.init(t_begin_of_data, t_key_string_length);
                t_val__size = t_key__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

RsaClientKeyExchange::RsaClientKeyExchange(HandshakeRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

RsaClientKeyExchange::~RsaClientKeyExchange() {
    rsa_pms_.free();
}

int RsaClientKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Parse "rsa_pms"
    int t_rsa_pms_string_length;
    t_rsa_pms_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_rsa_pms__size;
    t_rsa_pms__size = t_rsa_pms_string_length;
    // check for negative sizes
    if ( t_rsa_pms_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:763", t_rsa_pms_string_length);
    rsa_pms_.init(t_begin_of_data, t_rsa_pms_string_length);

    int t_RsaClientKeyExchange__size;
    const_byteptr const t_dataptr_after_rsa_pms = t_begin_of_data + (t_rsa_pms__size);
    BINPAC_ASSERT(t_dataptr_after_rsa_pms <= t_end_of_data);
    t_RsaClientKeyExchange__size = t_dataptr_after_rsa_pms - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_rsa_client_key_exchange(rec(), rsa_pms());
    BINPAC_ASSERT(t_begin_of_data + (t_RsaClientKeyExchange__size) <= t_end_of_data);
    return t_RsaClientKeyExchange__size;
}

DhClientKeyExchange::DhClientKeyExchange(HandshakeRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

DhClientKeyExchange::~DhClientKeyExchange() {
    dh_Yc_.free();
}

int DhClientKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Parse "dh_Yc"
    int t_dh_Yc_string_length;
    t_dh_Yc_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_dh_Yc__size;
    t_dh_Yc__size = t_dh_Yc_string_length;
    // check for negative sizes
    if ( t_dh_Yc_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:767", t_dh_Yc_string_length);
    dh_Yc_.init(t_begin_of_data, t_dh_Yc_string_length);

    int t_DhClientKeyExchange__size;
    const_byteptr const t_dataptr_after_dh_Yc = t_begin_of_data + (t_dh_Yc__size);
    BINPAC_ASSERT(t_dataptr_after_dh_Yc <= t_end_of_data);
    t_DhClientKeyExchange__size = t_dataptr_after_dh_Yc - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_dh_client_key_exchange(rec(), dh_Yc());
    BINPAC_ASSERT(t_begin_of_data + (t_DhClientKeyExchange__size) <= t_end_of_data);
    return t_DhClientKeyExchange__size;
}

EcdhClientKeyExchange::EcdhClientKeyExchange(HandshakeRecord* rec) {
    rec_ = rec;
    proc_ = false;
}

EcdhClientKeyExchange::~EcdhClientKeyExchange() {
    point_.free();
}

int EcdhClientKeyExchange::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Parse "point"
    int t_point_string_length;
    t_point_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_point__size;
    t_point__size = t_point_string_length;
    // check for negative sizes
    if ( t_point_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:771", t_point_string_length);
    point_.init(t_begin_of_data, t_point_string_length);

    int t_EcdhClientKeyExchange__size;
    const_byteptr const t_dataptr_after_point = t_begin_of_data + (t_point__size);
    BINPAC_ASSERT(t_dataptr_after_point <= t_end_of_data);
    t_EcdhClientKeyExchange__size = t_dataptr_after_point - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_ecdh_client_key_exchange(rec(), point());
    BINPAC_ASSERT(t_begin_of_data + (t_EcdhClientKeyExchange__size) <= t_end_of_data);
    return t_EcdhClientKeyExchange__size;
}

CertificateVerify::CertificateVerify(HandshakeRecord* rec) {
    rec_ = rec;
}

CertificateVerify::~CertificateVerify() {
}

int CertificateVerify::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:780", t_cont_string_length);
    cont_.init(t_begin_of_data, t_cont_string_length);

    int t_CertificateVerify__size;
    const_byteptr const t_dataptr_after_cont = t_begin_of_data + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_CertificateVerify__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_CertificateVerify__size) <= t_end_of_data);
    return t_CertificateVerify__size;
}

Finished::Finished(HandshakeRecord* rec) {
    rec_ = rec;
}

Finished::~Finished() {
}

int Finished::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Parse "cont"
    int t_cont_string_length;
    t_cont_string_length = (t_end_of_data) - (t_begin_of_data);
    int t_cont__size;
    t_cont__size = t_cont_string_length;
    // check for negative sizes
    if ( t_cont_string_length < 0 )
    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:791", t_cont_string_length);
    cont_.init(t_begin_of_data, t_cont_string_length);

    int t_Finished__size;
    const_byteptr const t_dataptr_after_cont = t_begin_of_data + (t_cont__size);
    BINPAC_ASSERT(t_dataptr_after_cont <= t_end_of_data);
    t_Finished__size = t_dataptr_after_cont - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_Finished__size) <= t_end_of_data);
    return t_Finished__size;
}

SessionTicketHandshake::SessionTicketHandshake(HandshakeRecord* rec) {
    ticket_lifetime_hint_ = 0;
    length_ = 0;
    rec_ = rec;
    proc_ = false;
}

SessionTicketHandshake::~SessionTicketHandshake() {
    data_.free();
}

int SessionTicketHandshake::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "SessionTicketHandshake:length"
    if ( (t_begin_of_data + 4) + (2) > t_end_of_data || (t_begin_of_data + 4) + (2) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SessionTicketHandshake:length",
        	(4) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "ticket_lifetime_hint"
    ticket_lifetime_hint_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 4))));

    // Parse "data"
    int t_data__size;
    t_data__size = length();
    // Checking out-of-bound for "SessionTicketHandshake:data"
    if ( (t_begin_of_data + 6) + (t_data__size) > t_end_of_data || (t_begin_of_data + 6) + (t_data__size) < (t_begin_of_data + 6) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SessionTicketHandshake:data",
        	(6) + (t_data__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 6) + t_data__size;
        int t_data_string_length;
        t_data_string_length = length();
        // check for negative sizes
        if ( t_data_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:797", t_data_string_length);
        data_.init((t_begin_of_data + 6), t_data_string_length);
    }

    int t_SessionTicketHandshake__size;
    const_byteptr const t_dataptr_after_data = (t_begin_of_data + 6) + (t_data__size);
    BINPAC_ASSERT(t_dataptr_after_data <= t_end_of_data);
    t_SessionTicketHandshake__size = t_dataptr_after_data - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_session_ticket_handshake(this, rec()->is_orig());
    BINPAC_ASSERT(t_begin_of_data + (t_SessionTicketHandshake__size) <= t_end_of_data);
    return t_SessionTicketHandshake__size;
}

SSLExtension::SSLExtension(HandshakeRecord* rec) {
    type_ = 0;
    data_len_ = 0;
    ext_case_index_ = -1;
    apnl_ = nullptr;
    apnl__elem_ = nullptr;
    elliptic_curves_ = nullptr;
    elliptic_curves__elem_ = nullptr;
    ec_point_formats_ = nullptr;
    ec_point_formats__elem_ = nullptr;
    server_name_ = nullptr;
    server_name__elem_ = nullptr;
    signature_algorithm_ = nullptr;
    signature_algorithm__elem_ = nullptr;
    certificate_timestamp_ = nullptr;
    certificate_timestamp__elem_ = nullptr;
    key_share_ = nullptr;
    key_share__elem_ = nullptr;
    key_share_old_ = nullptr;
    key_share_old__elem_ = nullptr;
    supported_versions_selector_ = nullptr;
    supported_versions_selector__elem_ = nullptr;
    psk_key_exchange_modes_ = nullptr;
    psk_key_exchange_modes__elem_ = nullptr;
    pre_shared_key_ = nullptr;
    pre_shared_key__elem_ = nullptr;
    connection_id_ = nullptr;
    connection_id__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

SSLExtension::~SSLExtension() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( ext_case_index() ) {
        case ((uint16)16):
            // Clean up "apnl"
            {
                delete apnl__elem_;
                apnl__elem_ = nullptr;
                if ( apnl() ) {
                    for ( auto* apnl__elem_ : *apnl() ) {
                        delete apnl__elem_;
                        apnl__elem_ = nullptr;
                    }
                }
                delete apnl_;
            }
            break;
        case ((uint16)10):
            // Clean up "elliptic_curves"
            {
                delete elliptic_curves__elem_;
                elliptic_curves__elem_ = nullptr;
                if ( elliptic_curves() ) {
                    for ( auto* elliptic_curves__elem_ : *elliptic_curves() ) {
                        delete elliptic_curves__elem_;
                        elliptic_curves__elem_ = nullptr;
                    }
                }
                delete elliptic_curves_;
            }
            break;
        case ((uint16)11):
            // Clean up "ec_point_formats"
            {
                delete ec_point_formats__elem_;
                ec_point_formats__elem_ = nullptr;
                if ( ec_point_formats() ) {
                    for ( auto* ec_point_formats__elem_ : *ec_point_formats() ) {
                        delete ec_point_formats__elem_;
                        ec_point_formats__elem_ = nullptr;
                    }
                }
                delete ec_point_formats_;
            }
            break;
        case ((uint16)0):
            // Clean up "server_name"
            {
                delete server_name__elem_;
                server_name__elem_ = nullptr;
                if ( server_name() ) {
                    for ( auto* server_name__elem_ : *server_name() ) {
                        delete server_name__elem_;
                        server_name__elem_ = nullptr;
                    }
                }
                delete server_name_;
            }
            break;
        case ((uint16)13):
            // Clean up "signature_algorithm"
            {
                delete signature_algorithm__elem_;
                signature_algorithm__elem_ = nullptr;
                if ( signature_algorithm() ) {
                    for ( auto* signature_algorithm__elem_ : *signature_algorithm() ) {
                        delete signature_algorithm__elem_;
                        signature_algorithm__elem_ = nullptr;
                    }
                }
                delete signature_algorithm_;
            }
            break;
        case ((uint16)18):
            // Clean up "certificate_timestamp"
            {
                delete certificate_timestamp__elem_;
                certificate_timestamp__elem_ = nullptr;
                if ( certificate_timestamp() ) {
                    for ( auto* certificate_timestamp__elem_ : *certificate_timestamp() ) {
                        delete certificate_timestamp__elem_;
                        certificate_timestamp__elem_ = nullptr;
                    }
                }
                delete certificate_timestamp_;
            }
            break;
        case ((uint16)51):
            // Clean up "key_share"
            {
                delete key_share__elem_;
                key_share__elem_ = nullptr;
                if ( key_share() ) {
                    for ( auto* key_share__elem_ : *key_share() ) {
                        delete key_share__elem_;
                        key_share__elem_ = nullptr;
                    }
                }
                delete key_share_;
            }
            break;
        case ((uint16)40):
            // Clean up "key_share_old"
            {
                delete key_share_old__elem_;
                key_share_old__elem_ = nullptr;
                if ( key_share_old() ) {
                    for ( auto* key_share_old__elem_ : *key_share_old() ) {
                        delete key_share_old__elem_;
                        key_share_old__elem_ = nullptr;
                    }
                }
                delete key_share_old_;
            }
            break;
        case ((uint16)43):
            // Clean up "supported_versions_selector"
            {
                delete supported_versions_selector__elem_;
                supported_versions_selector__elem_ = nullptr;
                if ( supported_versions_selector() ) {
                    for ( auto* supported_versions_selector__elem_ : *supported_versions_selector() ) {
                        delete supported_versions_selector__elem_;
                        supported_versions_selector__elem_ = nullptr;
                    }
                }
                delete supported_versions_selector_;
            }
            break;
        case ((uint16)45):
            // Clean up "psk_key_exchange_modes"
            {
                delete psk_key_exchange_modes__elem_;
                psk_key_exchange_modes__elem_ = nullptr;
                if ( psk_key_exchange_modes() ) {
                    for ( auto* psk_key_exchange_modes__elem_ : *psk_key_exchange_modes() ) {
                        delete psk_key_exchange_modes__elem_;
                        psk_key_exchange_modes__elem_ = nullptr;
                    }
                }
                delete psk_key_exchange_modes_;
            }
            break;
        case ((uint16)41):
            // Clean up "pre_shared_key"
            {
                delete pre_shared_key__elem_;
                pre_shared_key__elem_ = nullptr;
                if ( pre_shared_key() ) {
                    for ( auto* pre_shared_key__elem_ : *pre_shared_key() ) {
                        delete pre_shared_key__elem_;
                        pre_shared_key__elem_ = nullptr;
                    }
                }
                delete pre_shared_key_;
            }
            break;
        case ((uint16)54):
            // Clean up "connection_id"
            {
                delete connection_id__elem_;
                connection_id__elem_ = nullptr;
                if ( connection_id() ) {
                    for ( auto* connection_id__elem_ : *connection_id() ) {
                        delete connection_id__elem_;
                        connection_id__elem_ = nullptr;
                    }
                }
                delete connection_id_;
            }
            break;
        default:
            // Clean up "data"
            {
                data_.free();
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SSLExtension::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_SSLExtension__size;
    // Checking out-of-bound for "SSLExtension:data_len"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSLExtension:data_len",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "data_len"
    data_len_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));
    t_SSLExtension__size = data_len() + 4;
    // Checking out-of-bound for "SSLExtension"
    if ( t_begin_of_data + (t_SSLExtension__size) > t_end_of_data || t_begin_of_data + (t_SSLExtension__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SSLExtension",
        	(0) + (t_SSLExtension__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SSLExtension__size;
        sourcedata_ = const_bytestring(t_begin_of_data, t_end_of_data);
        // Parse "type"
        type_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));


        // Parse "ext"
        int t_ext__size;
        ext_case_index_ = type();
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case ((uint16)16):
                // Parse "apnl"
                {
                    int t_apnl__arraylength;
                    t_apnl__arraylength = 0;
                    apnl__elem_ = nullptr;
                    int t_apnl__elem__it;
                    t_apnl__elem__it = 0;
                    int t_apnl__size;
                    apnl_ = new vector<ApplicationLayerProtocolNegotiationExtension*>;
                    const_byteptr t_apnl__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_apnl__elem__it) {
                        // Check &until(apnl__elem__dataptr >= end_of_data)
                        if ( t_apnl__elem__dataptr >= t_end_of_data ) {
                            apnl__elem_ = nullptr;
                            goto end_of_apnl;
                        }
                        apnl__elem_ = new ApplicationLayerProtocolNegotiationExtension(rec());
                        int t_apnl__elem__size;
                        t_apnl__elem__size = apnl__elem_->Parse(t_apnl__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        apnl_->push_back(apnl__elem_);
                        t_apnl__elem__dataptr += t_apnl__elem__size;
                        BINPAC_ASSERT(t_apnl__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( apnl__elem_ == nullptr || apnl__elem_ != nullptr )  ) {
                            apnl__elem_ = nullptr;
                            goto end_of_apnl;
                        }
                        apnl__elem_ = nullptr;
                    }
                end_of_apnl: ;
                    t_apnl__size = t_apnl__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_apnl__size;
                }
                break;
            case ((uint16)10):
                // Parse "elliptic_curves"
                {
                    int t_elliptic_curves__arraylength;
                    t_elliptic_curves__arraylength = 0;
                    elliptic_curves__elem_ = nullptr;
                    int t_elliptic_curves__elem__it;
                    t_elliptic_curves__elem__it = 0;
                    int t_elliptic_curves__size;
                    elliptic_curves_ = new vector<EllipticCurves*>;
                    const_byteptr t_elliptic_curves__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_elliptic_curves__elem__it) {
                        // Check &until(elliptic_curves__elem__dataptr >= end_of_data)
                        if ( t_elliptic_curves__elem__dataptr >= t_end_of_data ) {
                            elliptic_curves__elem_ = nullptr;
                            goto end_of_elliptic_curves;
                        }
                        elliptic_curves__elem_ = new EllipticCurves(rec());
                        int t_elliptic_curves__elem__size;
                        t_elliptic_curves__elem__size = elliptic_curves__elem_->Parse(t_elliptic_curves__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        elliptic_curves_->push_back(elliptic_curves__elem_);
                        t_elliptic_curves__elem__dataptr += t_elliptic_curves__elem__size;
                        BINPAC_ASSERT(t_elliptic_curves__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( elliptic_curves__elem_ == nullptr || elliptic_curves__elem_ != nullptr )  ) {
                            elliptic_curves__elem_ = nullptr;
                            goto end_of_elliptic_curves;
                        }
                        elliptic_curves__elem_ = nullptr;
                    }
                end_of_elliptic_curves: ;
                    t_elliptic_curves__size = t_elliptic_curves__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_elliptic_curves__size;
                }
                break;
            case ((uint16)11):
                // Parse "ec_point_formats"
                {
                    int t_ec_point_formats__arraylength;
                    t_ec_point_formats__arraylength = 0;
                    ec_point_formats__elem_ = nullptr;
                    int t_ec_point_formats__elem__it;
                    t_ec_point_formats__elem__it = 0;
                    int t_ec_point_formats__size;
                    ec_point_formats_ = new vector<EcPointFormats*>;
                    const_byteptr t_ec_point_formats__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_ec_point_formats__elem__it) {
                        // Check &until(ec_point_formats__elem__dataptr >= end_of_data)
                        if ( t_ec_point_formats__elem__dataptr >= t_end_of_data ) {
                            ec_point_formats__elem_ = nullptr;
                            goto end_of_ec_point_formats;
                        }
                        ec_point_formats__elem_ = new EcPointFormats(rec());
                        int t_ec_point_formats__elem__size;
                        t_ec_point_formats__elem__size = ec_point_formats__elem_->Parse(t_ec_point_formats__elem__dataptr, t_end_of_data, t_context);
                        ec_point_formats_->push_back(ec_point_formats__elem_);
                        t_ec_point_formats__elem__dataptr += t_ec_point_formats__elem__size;
                        BINPAC_ASSERT(t_ec_point_formats__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( ec_point_formats__elem_ == nullptr || ec_point_formats__elem_ != nullptr )  ) {
                            ec_point_formats__elem_ = nullptr;
                            goto end_of_ec_point_formats;
                        }
                        ec_point_formats__elem_ = nullptr;
                    }
                end_of_ec_point_formats: ;
                    t_ec_point_formats__size = t_ec_point_formats__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_ec_point_formats__size;
                }
                break;
            case ((uint16)0):
                // Parse "server_name"
                {
                    int t_server_name__arraylength;
                    t_server_name__arraylength = 0;
                    server_name__elem_ = nullptr;
                    int t_server_name__elem__it;
                    t_server_name__elem__it = 0;
                    int t_server_name__size;
                    server_name_ = new vector<ServerNameExt*>;
                    const_byteptr t_server_name__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_server_name__elem__it) {
                        // Check &until(server_name__elem__dataptr >= end_of_data)
                        if ( t_server_name__elem__dataptr >= t_end_of_data ) {
                            server_name__elem_ = nullptr;
                            goto end_of_server_name;
                        }
                        server_name__elem_ = new ServerNameExt(rec());
                        int t_server_name__elem__size;
                        t_server_name__elem__size = server_name__elem_->Parse(t_server_name__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        server_name_->push_back(server_name__elem_);
                        t_server_name__elem__dataptr += t_server_name__elem__size;
                        BINPAC_ASSERT(t_server_name__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( server_name__elem_ == nullptr || server_name__elem_ != nullptr )  ) {
                            server_name__elem_ = nullptr;
                            goto end_of_server_name;
                        }
                        server_name__elem_ = nullptr;
                    }
                end_of_server_name: ;
                    t_server_name__size = t_server_name__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_server_name__size;
                }
                break;
            case ((uint16)13):
                // Parse "signature_algorithm"
                {
                    int t_signature_algorithm__arraylength;
                    t_signature_algorithm__arraylength = 0;
                    signature_algorithm__elem_ = nullptr;
                    int t_signature_algorithm__elem__it;
                    t_signature_algorithm__elem__it = 0;
                    int t_signature_algorithm__size;
                    signature_algorithm_ = new vector<SignatureAlgorithm*>;
                    const_byteptr t_signature_algorithm__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_signature_algorithm__elem__it) {
                        // Check &until(signature_algorithm__elem__dataptr >= end_of_data)
                        if ( t_signature_algorithm__elem__dataptr >= t_end_of_data ) {
                            signature_algorithm__elem_ = nullptr;
                            goto end_of_signature_algorithm;
                        }
                        signature_algorithm__elem_ = new SignatureAlgorithm(rec());
                        int t_signature_algorithm__elem__size;
                        t_signature_algorithm__elem__size = signature_algorithm__elem_->Parse(t_signature_algorithm__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        signature_algorithm_->push_back(signature_algorithm__elem_);
                        t_signature_algorithm__elem__dataptr += t_signature_algorithm__elem__size;
                        BINPAC_ASSERT(t_signature_algorithm__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( signature_algorithm__elem_ == nullptr || signature_algorithm__elem_ != nullptr )  ) {
                            signature_algorithm__elem_ = nullptr;
                            goto end_of_signature_algorithm;
                        }
                        signature_algorithm__elem_ = nullptr;
                    }
                end_of_signature_algorithm: ;
                    t_signature_algorithm__size = t_signature_algorithm__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_signature_algorithm__size;
                }
                break;
            case ((uint16)18):
                // Parse "certificate_timestamp"
                {
                    int t_certificate_timestamp__arraylength;
                    t_certificate_timestamp__arraylength = 0;
                    certificate_timestamp__elem_ = nullptr;
                    int t_certificate_timestamp__elem__it;
                    t_certificate_timestamp__elem__it = 0;
                    int t_certificate_timestamp__size;
                    certificate_timestamp_ = new vector<SignedCertificateTimestampList*>;
                    const_byteptr t_certificate_timestamp__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_certificate_timestamp__elem__it) {
                        // Check &until(certificate_timestamp__elem__dataptr >= end_of_data)
                        if ( t_certificate_timestamp__elem__dataptr >= t_end_of_data ) {
                            certificate_timestamp__elem_ = nullptr;
                            goto end_of_certificate_timestamp;
                        }
                        certificate_timestamp__elem_ = new SignedCertificateTimestampList(rec());
                        int t_certificate_timestamp__elem__size;
                        t_certificate_timestamp__elem__size = certificate_timestamp__elem_->Parse(t_certificate_timestamp__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        certificate_timestamp_->push_back(certificate_timestamp__elem_);
                        t_certificate_timestamp__elem__dataptr += t_certificate_timestamp__elem__size;
                        BINPAC_ASSERT(t_certificate_timestamp__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( certificate_timestamp__elem_ == nullptr || certificate_timestamp__elem_ != nullptr )  ) {
                            certificate_timestamp__elem_ = nullptr;
                            goto end_of_certificate_timestamp;
                        }
                        certificate_timestamp__elem_ = nullptr;
                    }
                end_of_certificate_timestamp: ;
                    t_certificate_timestamp__size = t_certificate_timestamp__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_certificate_timestamp__size;
                }
                break;
            case ((uint16)51):
                // Parse "key_share"
                {
                    int t_key_share__arraylength;
                    t_key_share__arraylength = 0;
                    key_share__elem_ = nullptr;
                    int t_key_share__elem__it;
                    t_key_share__elem__it = 0;
                    int t_key_share__size;
                    key_share_ = new vector<KeyShare*>;
                    const_byteptr t_key_share__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_key_share__elem__it) {
                        // Check &until(key_share__elem__dataptr >= end_of_data)
                        if ( t_key_share__elem__dataptr >= t_end_of_data ) {
                            key_share__elem_ = nullptr;
                            goto end_of_key_share;
                        }
                        key_share__elem_ = new KeyShare(rec(), this);
                        int t_key_share__elem__size;
                        t_key_share__elem__size = key_share__elem_->Parse(t_key_share__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        key_share_->push_back(key_share__elem_);
                        t_key_share__elem__dataptr += t_key_share__elem__size;
                        BINPAC_ASSERT(t_key_share__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( key_share__elem_ == nullptr || key_share__elem_ != nullptr )  ) {
                            key_share__elem_ = nullptr;
                            goto end_of_key_share;
                        }
                        key_share__elem_ = nullptr;
                    }
                end_of_key_share: ;
                    t_key_share__size = t_key_share__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_key_share__size;
                }
                break;
            case ((uint16)40):
                // Parse "key_share_old"
                {
                    int t_key_share_old__arraylength;
                    t_key_share_old__arraylength = 0;
                    key_share_old__elem_ = nullptr;
                    int t_key_share_old__elem__it;
                    t_key_share_old__elem__it = 0;
                    int t_key_share_old__size;
                    key_share_old_ = new vector<KeyShare*>;
                    const_byteptr t_key_share_old__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_key_share_old__elem__it) {
                        // Check &until(key_share_old__elem__dataptr >= end_of_data)
                        if ( t_key_share_old__elem__dataptr >= t_end_of_data ) {
                            key_share_old__elem_ = nullptr;
                            goto end_of_key_share_old;
                        }
                        key_share_old__elem_ = new KeyShare(rec(), this);
                        int t_key_share_old__elem__size;
                        t_key_share_old__elem__size = key_share_old__elem_->Parse(t_key_share_old__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        key_share_old_->push_back(key_share_old__elem_);
                        t_key_share_old__elem__dataptr += t_key_share_old__elem__size;
                        BINPAC_ASSERT(t_key_share_old__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( key_share_old__elem_ == nullptr || key_share_old__elem_ != nullptr )  ) {
                            key_share_old__elem_ = nullptr;
                            goto end_of_key_share_old;
                        }
                        key_share_old__elem_ = nullptr;
                    }
                end_of_key_share_old: ;
                    t_key_share_old__size = t_key_share_old__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_key_share_old__size;
                }
                break;
            case ((uint16)43):
                // Parse "supported_versions_selector"
                {
                    int t_supported_versions_selector__arraylength;
                    t_supported_versions_selector__arraylength = 0;
                    supported_versions_selector__elem_ = nullptr;
                    int t_supported_versions_selector__elem__it;
                    t_supported_versions_selector__elem__it = 0;
                    int t_supported_versions_selector__size;
                    supported_versions_selector_ = new vector<SupportedVersionsSelector*>;
                    const_byteptr t_supported_versions_selector__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_supported_versions_selector__elem__it) {
                        // Check &until(supported_versions_selector__elem__dataptr >= end_of_data)
                        if ( t_supported_versions_selector__elem__dataptr >= t_end_of_data ) {
                            supported_versions_selector__elem_ = nullptr;
                            goto end_of_supported_versions_selector;
                        }
                        supported_versions_selector__elem_ = new SupportedVersionsSelector(rec(), data_len());
                        int t_supported_versions_selector__elem__size;
                        t_supported_versions_selector__elem__size = supported_versions_selector__elem_->Parse(t_supported_versions_selector__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        supported_versions_selector_->push_back(supported_versions_selector__elem_);
                        t_supported_versions_selector__elem__dataptr += t_supported_versions_selector__elem__size;
                        BINPAC_ASSERT(t_supported_versions_selector__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( supported_versions_selector__elem_ == nullptr || supported_versions_selector__elem_ != nullptr )  ) {
                            supported_versions_selector__elem_ = nullptr;
                            goto end_of_supported_versions_selector;
                        }
                        supported_versions_selector__elem_ = nullptr;
                    }
                end_of_supported_versions_selector: ;
                    t_supported_versions_selector__size = t_supported_versions_selector__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_supported_versions_selector__size;
                }
                break;
            case ((uint16)45):
                // Parse "psk_key_exchange_modes"
                {
                    int t_psk_key_exchange_modes__arraylength;
                    t_psk_key_exchange_modes__arraylength = 0;
                    psk_key_exchange_modes__elem_ = nullptr;
                    int t_psk_key_exchange_modes__elem__it;
                    t_psk_key_exchange_modes__elem__it = 0;
                    int t_psk_key_exchange_modes__size;
                    psk_key_exchange_modes_ = new vector<PSKKeyExchangeModes*>;
                    const_byteptr t_psk_key_exchange_modes__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_psk_key_exchange_modes__elem__it) {
                        // Check &until(psk_key_exchange_modes__elem__dataptr >= end_of_data)
                        if ( t_psk_key_exchange_modes__elem__dataptr >= t_end_of_data ) {
                            psk_key_exchange_modes__elem_ = nullptr;
                            goto end_of_psk_key_exchange_modes;
                        }
                        psk_key_exchange_modes__elem_ = new PSKKeyExchangeModes(rec());
                        int t_psk_key_exchange_modes__elem__size;
                        t_psk_key_exchange_modes__elem__size = psk_key_exchange_modes__elem_->Parse(t_psk_key_exchange_modes__elem__dataptr, t_end_of_data, t_context);
                        psk_key_exchange_modes_->push_back(psk_key_exchange_modes__elem_);
                        t_psk_key_exchange_modes__elem__dataptr += t_psk_key_exchange_modes__elem__size;
                        BINPAC_ASSERT(t_psk_key_exchange_modes__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( psk_key_exchange_modes__elem_ == nullptr || psk_key_exchange_modes__elem_ != nullptr )  ) {
                            psk_key_exchange_modes__elem_ = nullptr;
                            goto end_of_psk_key_exchange_modes;
                        }
                        psk_key_exchange_modes__elem_ = nullptr;
                    }
                end_of_psk_key_exchange_modes: ;
                    t_psk_key_exchange_modes__size = t_psk_key_exchange_modes__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_psk_key_exchange_modes__size;
                }
                break;
            case ((uint16)41):
                // Parse "pre_shared_key"
                {
                    int t_pre_shared_key__arraylength;
                    t_pre_shared_key__arraylength = 0;
                    pre_shared_key__elem_ = nullptr;
                    int t_pre_shared_key__elem__it;
                    t_pre_shared_key__elem__it = 0;
                    int t_pre_shared_key__size;
                    pre_shared_key_ = new vector<PreSharedKey*>;
                    const_byteptr t_pre_shared_key__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_pre_shared_key__elem__it) {
                        // Check &until(pre_shared_key__elem__dataptr >= end_of_data)
                        if ( t_pre_shared_key__elem__dataptr >= t_end_of_data ) {
                            pre_shared_key__elem_ = nullptr;
                            goto end_of_pre_shared_key;
                        }
                        pre_shared_key__elem_ = new PreSharedKey(rec());
                        int t_pre_shared_key__elem__size;
                        t_pre_shared_key__elem__size = pre_shared_key__elem_->Parse(t_pre_shared_key__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                        pre_shared_key_->push_back(pre_shared_key__elem_);
                        t_pre_shared_key__elem__dataptr += t_pre_shared_key__elem__size;
                        BINPAC_ASSERT(t_pre_shared_key__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( pre_shared_key__elem_ == nullptr || pre_shared_key__elem_ != nullptr )  ) {
                            pre_shared_key__elem_ = nullptr;
                            goto end_of_pre_shared_key;
                        }
                        pre_shared_key__elem_ = nullptr;
                    }
                end_of_pre_shared_key: ;
                    t_pre_shared_key__size = t_pre_shared_key__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_pre_shared_key__size;
                }
                break;
            case ((uint16)54):
                // Parse "connection_id"
                {
                    int t_connection_id__arraylength;
                    t_connection_id__arraylength = 0;
                    connection_id__elem_ = nullptr;
                    int t_connection_id__elem__it;
                    t_connection_id__elem__it = 0;
                    int t_connection_id__size;
                    connection_id_ = new vector<ConnectionId*>;
                    const_byteptr t_connection_id__elem__dataptr = (t_begin_of_data + 4);
                    for (; /* forever */; ++t_connection_id__elem__it) {
                        // Check &until(connection_id__elem__dataptr >= end_of_data)
                        if ( t_connection_id__elem__dataptr >= t_end_of_data ) {
                            connection_id__elem_ = nullptr;
                            goto end_of_connection_id;
                        }
                        connection_id__elem_ = new ConnectionId(rec());
                        int t_connection_id__elem__size;
                        t_connection_id__elem__size = connection_id__elem_->Parse(t_connection_id__elem__dataptr, t_end_of_data, t_context);
                        connection_id_->push_back(connection_id__elem_);
                        t_connection_id__elem__dataptr += t_connection_id__elem__size;
                        BINPAC_ASSERT(t_connection_id__elem__dataptr <= t_end_of_data);
                        // Check &until( ( $element == nullptr || $element != nullptr ) )
                        if (  ( connection_id__elem_ == nullptr || connection_id__elem_ != nullptr )  ) {
                            connection_id__elem_ = nullptr;
                            goto end_of_connection_id;
                        }
                        connection_id__elem_ = nullptr;
                    }
                end_of_connection_id: ;
                    t_connection_id__size = t_connection_id__elem__dataptr - ((t_begin_of_data + 4));
                    // Evaluate 'let' and 'withinput' fields
                    t_ext__size = t_connection_id__size;
                }
                break;
            default:
                // Parse "data"
                {
                    int t_data_string_length;
                    t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 4));
                    int t_data__size;
                    t_data__size = t_data_string_length;
                    // check for negative sizes
                    if ( t_data_string_length < 0 )
                    throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:824", t_data_string_length);
                    data_.init((t_begin_of_data + 4), t_data_string_length);
                    t_ext__size = t_data__size;
                }
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_ssl_extension(rec(), type(), sourcedata());
        sourcedata_.set_end(t_begin_of_data + t_SSLExtension__size);
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SSLExtension__size) <= t_end_of_data);
    return t_SSLExtension__size;
}

SignatureAndHashAlgorithm::SignatureAndHashAlgorithm() {
    HashAlgorithm_ = 0;
    SignatureAlgorithm_ = 0;
}

SignatureAndHashAlgorithm::~SignatureAndHashAlgorithm() {
}

int SignatureAndHashAlgorithm::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SignatureAndHashAlgorithm"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignatureAndHashAlgorithm",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "HashAlgorithm"
    HashAlgorithm_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "SignatureAlgorithm"
    SignatureAlgorithm_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

SignedCertificateTimestampList::SignedCertificateTimestampList(HandshakeRecord* rec) {
    length_ = 0;
    SCTs_ = nullptr;
    SCTs__elem_ = nullptr;
    rec_ = rec;
}

SignedCertificateTimestampList::~SignedCertificateTimestampList() {
    delete SCTs__elem_;
    SCTs__elem_ = nullptr;
    if ( SCTs() ) {
        for ( auto* SCTs__elem_ : *SCTs() ) {
            delete SCTs__elem_;
            SCTs__elem_ = nullptr;
        }
    }
    delete SCTs_;
}

int SignedCertificateTimestampList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_SignedCertificateTimestampList__size;
    // Checking out-of-bound for "SignedCertificateTimestampList:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignedCertificateTimestampList:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_SignedCertificateTimestampList__size = length() + 2;
    // Checking out-of-bound for "SignedCertificateTimestampList"
    if ( t_begin_of_data + (t_SignedCertificateTimestampList__size) > t_end_of_data || t_begin_of_data + (t_SignedCertificateTimestampList__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignedCertificateTimestampList",
        	(0) + (t_SignedCertificateTimestampList__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SignedCertificateTimestampList__size;

        // Parse "SCTs"
        int t_SCTs__arraylength;
        t_SCTs__arraylength = 0;
        SCTs__elem_ = nullptr;
        int t_SCTs__elem__it;
        t_SCTs__elem__it = 0;
        int t_SCTs__size;
        SCTs_ = new vector<SignedCertificateTimestamp*>;
        const_byteptr t_SCTs__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_SCTs__elem__it) {
            // Check &until(SCTs__elem__dataptr >= end_of_data)
            if ( t_SCTs__elem__dataptr >= t_end_of_data ) {
                SCTs__elem_ = nullptr;
                goto end_of_SCTs;
            }
            SCTs__elem_ = new SignedCertificateTimestamp(rec());
            int t_SCTs__elem__size;
            t_SCTs__elem__size = SCTs__elem_->Parse(t_SCTs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
            SCTs_->push_back(SCTs__elem_);
            t_SCTs__elem__dataptr += t_SCTs__elem__size;
            BINPAC_ASSERT(t_SCTs__elem__dataptr <= t_end_of_data);
            SCTs__elem_ = nullptr;
        }
    end_of_SCTs: ;
        t_SCTs__size = t_SCTs__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SignedCertificateTimestampList__size) <= t_end_of_data);
    return t_SignedCertificateTimestampList__size;
}

SignedCertificateTimestamp::SignedCertificateTimestamp(HandshakeRecord* rec) {
    length_ = 0;
    version_ = 0;
    timestamp_ = 0;
    extensions_length_ = 0;
    digitally_signed_algorithms_ = nullptr;
    digitally_signed_signature_length_ = 0;
    rec_ = rec;
    proc_ = false;
}

SignedCertificateTimestamp::~SignedCertificateTimestamp() {
    logid_.free();
    extensions_.free();
    delete digitally_signed_algorithms_;
    digitally_signed_algorithms_ = nullptr;
    digitally_signed_signature_.free();
}

int SignedCertificateTimestamp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_SignedCertificateTimestamp__size;
    // Checking out-of-bound for "SignedCertificateTimestamp:version"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:version",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_SignedCertificateTimestamp__size = length() + 2;
    // Checking out-of-bound for "SignedCertificateTimestamp"
    if ( t_begin_of_data + (t_SignedCertificateTimestamp__size) > t_end_of_data || t_begin_of_data + (t_SignedCertificateTimestamp__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp",
        	(0) + (t_SignedCertificateTimestamp__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SignedCertificateTimestamp__size;

        // Parse "version"
        version_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

        // Parse "logid"
        // Checking out-of-bound for "SignedCertificateTimestamp:logid"
        if ( (t_begin_of_data + 3) + (32) > t_end_of_data || (t_begin_of_data + 3) + (32) < (t_begin_of_data + 3) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:logid",
            	(3) + (32), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 3) + 32;
            int t_logid_string_length;
            t_logid_string_length = 32;
            int t_logid__size;
            t_logid__size = t_logid_string_length;
            logid_.init((t_begin_of_data + 3), t_logid_string_length);
        }

        const_byteptr const t_dataptr_after_logid = (t_begin_of_data + 3) + (32);
        BINPAC_ASSERT(t_dataptr_after_logid <= t_end_of_data);
        // Checking out-of-bound for "SignedCertificateTimestamp:extensions_length"
        if ( (t_dataptr_after_logid + 8) + (2) > t_end_of_data || (t_dataptr_after_logid + 8) + (2) < (t_dataptr_after_logid + 8) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:extensions_length",
            	(((t_dataptr_after_logid + 8) - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "timestamp"
        timestamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_dataptr_after_logid)));

        // Parse "extensions_length"
        extensions_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_logid + 8))));

        // Parse "extensions"
        int t_extensions__size;
        t_extensions__size = extensions_length();
        // Checking out-of-bound for "SignedCertificateTimestamp:extensions"
        if ( (t_dataptr_after_logid + 10) + (t_extensions__size) > t_end_of_data || (t_dataptr_after_logid + 10) + (t_extensions__size) < (t_dataptr_after_logid + 10) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:extensions",
            	(((t_dataptr_after_logid + 10) - t_begin_of_data)) + (t_extensions__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_dataptr_after_logid + 10) + t_extensions__size;
            int t_extensions_string_length;
            t_extensions_string_length = extensions_length();
            // check for negative sizes
            if ( t_extensions_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-signed_certificate_timestamp.pac:23", t_extensions_string_length);
            extensions_.init((t_dataptr_after_logid + 10), t_extensions_string_length);
        }

        const_byteptr const t_dataptr_after_extensions = (t_dataptr_after_logid + 10) + (t_extensions__size);
        BINPAC_ASSERT(t_dataptr_after_extensions <= t_end_of_data);
        // Checking out-of-bound for "SignedCertificateTimestamp:digitally_signed_signature_length"
        if ( (t_dataptr_after_extensions + 2) + (2) > t_end_of_data || (t_dataptr_after_extensions + 2) + (2) < (t_dataptr_after_extensions + 2) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:digitally_signed_signature_length",
            	(((t_dataptr_after_extensions + 2) - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "digitally_signed_algorithms"
        digitally_signed_algorithms_ = new SignatureAndHashAlgorithm();
        digitally_signed_algorithms_->Parse(t_dataptr_after_extensions, t_end_of_data);

        // Parse "digitally_signed_signature_length"
        digitally_signed_signature_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_extensions + 2))));

        // Parse "digitally_signed_signature"
        int t_digitally_signed_signature__size;
        t_digitally_signed_signature__size = digitally_signed_signature_length();
        // Checking out-of-bound for "SignedCertificateTimestamp:digitally_signed_signature"
        if ( (t_dataptr_after_extensions + 4) + (t_digitally_signed_signature__size) > t_end_of_data || (t_dataptr_after_extensions + 4) + (t_digitally_signed_signature__size) < (t_dataptr_after_extensions + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:digitally_signed_signature",
            	(((t_dataptr_after_extensions + 4) - t_begin_of_data)) + (t_digitally_signed_signature__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_dataptr_after_extensions + 4) + t_digitally_signed_signature__size;
            int t_digitally_signed_signature_string_length;
            t_digitally_signed_signature_string_length = digitally_signed_signature_length();
            // check for negative sizes
            if ( t_digitally_signed_signature_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-signed_certificate_timestamp.pac:26", t_digitally_signed_signature_string_length);
            digitally_signed_signature_.init((t_dataptr_after_extensions + 4), t_digitally_signed_signature_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_signedcertificatetimestamp(rec(), version(), logid(), timestamp(), digitally_signed_algorithms(), digitally_signed_signature());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SignedCertificateTimestamp__size) <= t_end_of_data);
    return t_SignedCertificateTimestamp__size;
}

ConnectionId::ConnectionId(HandshakeRecord* rec) {
    length_ = 0;
    rec_ = rec;
    proc_ = false;
}

ConnectionId::~ConnectionId() {
    cid_.free();
}

int ConnectionId::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Checking out-of-bound for "ConnectionId:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ConnectionId:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "cid"
    int t_cid__size;
    t_cid__size = length();
    // Checking out-of-bound for "ConnectionId:cid"
    if ( (t_begin_of_data + 1) + (t_cid__size) > t_end_of_data || (t_begin_of_data + 1) + (t_cid__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ConnectionId:cid",
        	(1) + (t_cid__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_cid__size;
        int t_cid_string_length;
        t_cid_string_length = length();
        // check for negative sizes
        if ( t_cid_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:832", t_cid_string_length);
        cid_.init((t_begin_of_data + 1), t_cid_string_length);
    }

    int t_ConnectionId__size;
    const_byteptr const t_dataptr_after_cid = (t_begin_of_data + 1) + (t_cid__size);
    BINPAC_ASSERT(t_dataptr_after_cid <= t_end_of_data);
    t_ConnectionId__size = t_dataptr_after_cid - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_connection_id(rec(), cid());
    BINPAC_ASSERT(t_begin_of_data + (t_ConnectionId__size) <= t_end_of_data);
    return t_ConnectionId__size;
}

SupportedVersionsSelector::SupportedVersionsSelector(HandshakeRecord* rec, uint16 data_len) {
    val_case_index_ = -1;
    a_ = nullptr;
    b_ = nullptr;
    rec_ = rec;
    data_len_ = data_len;
}

SupportedVersionsSelector::~SupportedVersionsSelector() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Clean up "a"
            {
                delete a_;
                a_ = nullptr;
            }
            break;
        case ((int)0):
            // Clean up "b"
            {
                delete b_;
                b_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int SupportedVersionsSelector::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ =  ( rec()->is_orig() ^ t_context->connection()->flipped() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((int)1):
            // Parse "a"
            {
                a_ = new SupportedVersions(rec());
                int t_a__size;
                t_a__size = a_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_a__size;
            }
            break;
        case ((int)0):
            // Parse "b"
            {
                b_ = new OneSupportedVersion(rec());
                b_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("SupportedVersionsSelector", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SupportedVersions::SupportedVersions(HandshakeRecord* rec) {
    length_ = 0;
    versions_ = nullptr;
    versions__elem_ = 0;
    rec_ = rec;
    proc_ = false;
}

SupportedVersions::~SupportedVersions() {
    delete versions_;
}

int SupportedVersions::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_SupportedVersions__size;
    // Checking out-of-bound for "SupportedVersions:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SupportedVersions:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    t_SupportedVersions__size = length() + 1;
    // Checking out-of-bound for "SupportedVersions"
    if ( t_begin_of_data + (t_SupportedVersions__size) > t_end_of_data || t_begin_of_data + (t_SupportedVersions__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SupportedVersions",
        	(0) + (t_SupportedVersions__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SupportedVersions__size;

        // Parse "versions"
        int t_versions__arraylength;
        t_versions__arraylength = 0;
        versions__elem_ = 0;
        int t_versions__elem__it;
        t_versions__elem__it = 0;
        int t_versions__size;
        versions_ = new vector<uint16>;
        const_byteptr t_versions__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_versions__elem__it) {
            // Check &until(versions__elem__dataptr >= end_of_data)
            if ( t_versions__elem__dataptr >= t_end_of_data ) {
                goto end_of_versions;
            }
            // Checking out-of-bound for "SupportedVersions:versions__elem"
            if ( t_versions__elem__dataptr + (2) > t_end_of_data || t_versions__elem__dataptr + (2) < t_versions__elem__dataptr ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SupportedVersions:versions__elem",
                	((t_versions__elem__dataptr - t_begin_of_data)) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            versions__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_versions__elem__dataptr)));
            versions_->push_back(versions__elem_);
            t_versions__elem__dataptr += 2;
            BINPAC_ASSERT(t_versions__elem__dataptr <= t_end_of_data);
        }
    end_of_versions: ;
        t_versions__size = t_versions__elem__dataptr - ((t_begin_of_data + 1));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_supported_versions(rec(), versions());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SupportedVersions__size) <= t_end_of_data);
    return t_SupportedVersions__size;
}

OneSupportedVersion::OneSupportedVersion(HandshakeRecord* rec) {
    version_ = 0;
    rec_ = rec;
    version_set_ = false;
    proc_ = false;
}

OneSupportedVersion::~OneSupportedVersion() {
}

int OneSupportedVersion::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "OneSupportedVersion"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("OneSupportedVersion",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "version"
    version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    version_set_ = t_context->connection()->set_version(version());
    proc_ = t_context->connection()->proc_one_supported_version(rec(), version());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

PSKKeyExchangeModes::PSKKeyExchangeModes(HandshakeRecord* rec) {
    length_ = 0;
    modes_ = nullptr;
    modes__elem_ = 0;
    rec_ = rec;
    proc_ = false;
}

PSKKeyExchangeModes::~PSKKeyExchangeModes() {
    delete modes_;
}

int PSKKeyExchangeModes::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    int t_PSKKeyExchangeModes__size;
    // Checking out-of-bound for "PSKKeyExchangeModes:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKKeyExchangeModes:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));
    t_PSKKeyExchangeModes__size = length() + 1;
    // Checking out-of-bound for "PSKKeyExchangeModes"
    if ( t_begin_of_data + (t_PSKKeyExchangeModes__size) > t_end_of_data || t_begin_of_data + (t_PSKKeyExchangeModes__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKKeyExchangeModes",
        	(0) + (t_PSKKeyExchangeModes__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PSKKeyExchangeModes__size;

        // Parse "modes"
        int t_modes__arraylength;
        t_modes__arraylength = 0;
        modes__elem_ = 0;
        int t_modes__elem__it;
        t_modes__elem__it = 0;
        int t_modes__size;
        modes_ = new vector<uint8>;
        const_byteptr t_modes__elem__dataptr = (t_begin_of_data + 1);
        for (; /* forever */; ++t_modes__elem__it) {
            // Check &until(modes__elem__dataptr >= end_of_data)
            if ( t_modes__elem__dataptr >= t_end_of_data ) {
                goto end_of_modes;
            }
            // Checking out-of-bound for "PSKKeyExchangeModes:modes__elem"
            if ( t_modes__elem__dataptr + (1) > t_end_of_data || t_modes__elem__dataptr + (1) < t_modes__elem__dataptr ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("PSKKeyExchangeModes:modes__elem",
                	((t_modes__elem__dataptr - t_begin_of_data)) + (1), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            modes__elem_ = *(reinterpret_cast<uint8 const*>(t_modes__elem__dataptr));
            modes_->push_back(modes__elem_);
            t_modes__elem__dataptr += 1;
            BINPAC_ASSERT(t_modes__elem__dataptr <= t_end_of_data);
        }
    end_of_modes: ;
        t_modes__size = t_modes__elem__dataptr - ((t_begin_of_data + 1));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_psk_key_exchange_modes(rec(), modes());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PSKKeyExchangeModes__size) <= t_end_of_data);
    return t_PSKKeyExchangeModes__size;
}

ServerNameHostName::ServerNameHostName() {
    length_ = 0;
}

ServerNameHostName::~ServerNameHostName() {
    host_name_.free();
}

int ServerNameHostName::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ServerNameHostName:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerNameHostName:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "host_name"
    int t_host_name__size;
    t_host_name__size = length();
    // Checking out-of-bound for "ServerNameHostName:host_name"
    if ( (t_begin_of_data + 2) + (t_host_name__size) > t_end_of_data || (t_begin_of_data + 2) + (t_host_name__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerNameHostName:host_name",
        	(2) + (t_host_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_host_name__size;
        int t_host_name_string_length;
        t_host_name_string_length = length();
        // check for negative sizes
        if ( t_host_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:860", t_host_name_string_length);
        host_name_.init((t_begin_of_data + 2), t_host_name_string_length);
    }

    int t_ServerNameHostName__size;
    const_byteptr const t_dataptr_after_host_name = (t_begin_of_data + 2) + (t_host_name__size);
    BINPAC_ASSERT(t_dataptr_after_host_name <= t_end_of_data);
    t_ServerNameHostName__size = t_dataptr_after_host_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ServerNameHostName__size) <= t_end_of_data);
    return t_ServerNameHostName__size;
}

ServerName::ServerName() {
    name_type_ = 0;
    name_case_index_ = -1;
    host_name_ = nullptr;
}

ServerName::~ServerName() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( name_case_index() ) {
        case ((uint8)0):
            // Clean up "host_name"
            {
                delete host_name_;
                host_name_ = nullptr;
            }
            break;
        default:
            // Clean up "data"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ServerName::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "ServerName:name_type"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerName:name_type",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "name_type"
    name_type_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "name"
    int t_name__size;
    name_case_index_ = name_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( name_case_index() ) {
        case ((uint8)0):
            // Parse "host_name"
            {
                host_name_ = new ServerNameHostName();
                int t_host_name__size;
                t_host_name__size = host_name_->Parse((t_begin_of_data + 1), t_end_of_data, t_byteorder);
                t_name__size = t_host_name__size;
            }
            break;
        default:
            // Parse "data"
            {
                int t_data_string_length;
                t_data_string_length = (t_end_of_data) - ((t_begin_of_data + 1));
                int t_data__size;
                t_data__size = t_data_string_length;
                // check for negative sizes
                if ( t_data_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:867", t_data_string_length);
                data_.init((t_begin_of_data + 1), t_data_string_length);
                t_name__size = t_data__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    int t_ServerName__size;
    const_byteptr const t_dataptr_after_name = (t_begin_of_data + 1) + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    t_ServerName__size = t_dataptr_after_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ServerName__size) <= t_end_of_data);
    return t_ServerName__size;
}

ServerNameExt::ServerNameExt(HandshakeRecord* rec) {
    length_ = 0;
    server_names_ = nullptr;
    server_names__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

ServerNameExt::~ServerNameExt() {
    delete server_names__elem_;
    server_names__elem_ = nullptr;
    if ( server_names() ) {
        for ( auto* server_names__elem_ : *server_names() ) {
            delete server_names__elem_;
            server_names__elem_ = nullptr;
        }
    }
    delete server_names_;
}

int ServerNameExt::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_ServerNameExt__size;
    // Checking out-of-bound for "ServerNameExt:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerNameExt:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_ServerNameExt__size = length() + 2;
    // Checking out-of-bound for "ServerNameExt"
    if ( t_begin_of_data + (t_ServerNameExt__size) > t_end_of_data || t_begin_of_data + (t_ServerNameExt__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ServerNameExt",
        	(0) + (t_ServerNameExt__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_ServerNameExt__size;

        // Parse "server_names"
        int t_server_names__arraylength;
        t_server_names__arraylength = 0;
        server_names__elem_ = nullptr;
        int t_server_names__elem__it;
        t_server_names__elem__it = 0;
        int t_server_names__size;
        server_names_ = new vector<ServerName*>;
        const_byteptr t_server_names__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_server_names__elem__it) {
            // Check &until(server_names__elem__dataptr >= end_of_data)
            if ( t_server_names__elem__dataptr >= t_end_of_data ) {
                server_names__elem_ = nullptr;
                goto end_of_server_names;
            }
            server_names__elem_ = new ServerName();
            int t_server_names__elem__size;
            t_server_names__elem__size = server_names__elem_->Parse(t_server_names__elem__dataptr, t_end_of_data, t_byteorder);
            server_names_->push_back(server_names__elem_);
            t_server_names__elem__dataptr += t_server_names__elem__size;
            BINPAC_ASSERT(t_server_names__elem__dataptr <= t_end_of_data);
            server_names__elem_ = nullptr;
        }
    end_of_server_names: ;
        t_server_names__size = t_server_names__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_server_name(rec(), server_names());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_ServerNameExt__size) <= t_end_of_data);
    return t_ServerNameExt__size;
}

EcPointFormats::EcPointFormats(HandshakeRecord* rec) {
    length_ = 0;
    point_format_list_ = nullptr;
    point_format_list__elem_ = 0;
    rec_ = rec;
    proc_ = false;
}

EcPointFormats::~EcPointFormats() {
    delete point_format_list_;
}

int EcPointFormats::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context) {
    // Checking out-of-bound for "EcPointFormats:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EcPointFormats:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "point_format_list"
    int t_point_format_list__arraylength;
    t_point_format_list__arraylength = length();
    if ( t_point_format_list__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("EcPointFormats:point_format_list",
          t_point_format_list__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: EcPointFormats:point_format_list
    if ( t_point_format_list__arraylength > ((t_end_of_data - (t_begin_of_data + 1)) / 1) )
        throw binpac::ExceptionOutOfBound("EcPointFormats:point_format_list",
          t_point_format_list__arraylength, (t_end_of_data) - ((t_begin_of_data + 1)));
    point_format_list__elem_ = 0;
    int t_point_format_list__elem__it;
    t_point_format_list__elem__it = 0;
    int t_point_format_list__size;
    point_format_list_ = new vector<uint8>;
    point_format_list_->reserve(t_point_format_list__arraylength);
    const_byteptr t_point_format_list__elem__dataptr = (t_begin_of_data + 1);
    for (; t_point_format_list__elem__it < t_point_format_list__arraylength; ++t_point_format_list__elem__it) {
        point_format_list__elem_ = *(reinterpret_cast<uint8 const*>(t_point_format_list__elem__dataptr));
        point_format_list_->push_back(point_format_list__elem_);
        t_point_format_list__elem__dataptr += 1;
        BINPAC_ASSERT(t_point_format_list__elem__dataptr <= t_end_of_data);
    }
end_of_point_format_list: ;
    t_point_format_list__size = t_point_format_list__elem__dataptr - ((t_begin_of_data + 1));
    // Evaluate 'let' and 'withinput' fields

    int t_EcPointFormats__size;
    const_byteptr const t_dataptr_after_point_format_list = (t_begin_of_data + 1) + (t_point_format_list__size);
    BINPAC_ASSERT(t_dataptr_after_point_format_list <= t_end_of_data);
    t_EcPointFormats__size = t_dataptr_after_point_format_list - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_ec_point_formats(rec(), point_format_list());
    BINPAC_ASSERT(t_begin_of_data + (t_EcPointFormats__size) <= t_end_of_data);
    return t_EcPointFormats__size;
}

KeyShareEntry::KeyShareEntry() {
    namedgroup_ = 0;
    key_exchange_length_ = 0;
}

KeyShareEntry::~KeyShareEntry() {
}

int KeyShareEntry::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "KeyShareEntry:key_exchange_length"
    if ( (t_begin_of_data + 2) + (2) > t_end_of_data || (t_begin_of_data + 2) + (2) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KeyShareEntry:key_exchange_length",
        	(2) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "namedgroup"
    namedgroup_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "key_exchange_length"
    key_exchange_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "key_exchange"
    int t_key_exchange__size;
    t_key_exchange__size = key_exchange_length();
    // Checking out-of-bound for "KeyShareEntry:key_exchange"
    if ( (t_begin_of_data + 4) + (t_key_exchange__size) > t_end_of_data || (t_begin_of_data + 4) + (t_key_exchange__size) < (t_begin_of_data + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("KeyShareEntry:key_exchange",
        	(4) + (t_key_exchange__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 4) + t_key_exchange__size;
        int t_key_exchange_string_length;
        t_key_exchange_string_length = key_exchange_length();
        // check for negative sizes
        if ( t_key_exchange_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:900", t_key_exchange_string_length);
        key_exchange_.init((t_begin_of_data + 4), t_key_exchange_string_length);
    }

    int t_KeyShareEntry__size;
    const_byteptr const t_dataptr_after_key_exchange = (t_begin_of_data + 4) + (t_key_exchange__size);
    BINPAC_ASSERT(t_dataptr_after_key_exchange <= t_end_of_data);
    t_KeyShareEntry__size = t_dataptr_after_key_exchange - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_KeyShareEntry__size) <= t_end_of_data);
    return t_KeyShareEntry__size;
}

ServerHelloKeyShare::ServerHelloKeyShare(HandshakeRecord* rec) {
    keyshare_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

ServerHelloKeyShare::~ServerHelloKeyShare() {
    delete keyshare_;
    keyshare_ = nullptr;
}

int ServerHelloKeyShare::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Parse "keyshare"
    keyshare_ = new KeyShareEntry();
    int t_keyshare__size;
    t_keyshare__size = keyshare_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    int t_ServerHelloKeyShare__size;
    const_byteptr const t_dataptr_after_keyshare = t_begin_of_data + (t_keyshare__size);
    BINPAC_ASSERT(t_dataptr_after_keyshare <= t_end_of_data);
    t_ServerHelloKeyShare__size = t_dataptr_after_keyshare - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_server_key_share(rec(), keyshare());
    BINPAC_ASSERT(t_begin_of_data + (t_ServerHelloKeyShare__size) <= t_end_of_data);
    return t_ServerHelloKeyShare__size;
}

HelloRetryRequestKeyShare::HelloRetryRequestKeyShare(HandshakeRecord* rec) {
    namedgroup_ = 0;
    rec_ = rec;
    proc_ = false;
}

HelloRetryRequestKeyShare::~HelloRetryRequestKeyShare() {
}

int HelloRetryRequestKeyShare::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "HelloRetryRequestKeyShare"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("HelloRetryRequestKeyShare",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "namedgroup"
    namedgroup_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_hello_retry_request_key_share(rec(), namedgroup());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

ServerHelloKeyShareChoice::ServerHelloKeyShareChoice(HandshakeRecord* rec, SSLExtension* ext) {
    val_case_index_ = -1;
    hrr_ = nullptr;
    server_ = nullptr;
    rec_ = rec;
    ext_ = ext;
}

ServerHelloKeyShareChoice::~ServerHelloKeyShareChoice() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)2):
            // Clean up "hrr"
            {
                delete hrr_;
                hrr_ = nullptr;
            }
            break;
        default:
            // Clean up "server"
            {
                delete server_;
                server_ = nullptr;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int ServerHelloKeyShareChoice::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ =  ( ext()->data_len() ) ;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint16)2):
            // Parse "hrr"
            {
                hrr_ = new HelloRetryRequestKeyShare(rec());
                hrr_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        default:
            // Parse "server"
            {
                server_ = new ServerHelloKeyShare(rec());
                int t_server__size;
                t_server__size = server_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_server__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

ClientHelloKeyShare::ClientHelloKeyShare(HandshakeRecord* rec) {
    length_ = 0;
    keyshares_ = nullptr;
    keyshares__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

ClientHelloKeyShare::~ClientHelloKeyShare() {
    delete keyshares__elem_;
    keyshares__elem_ = nullptr;
    if ( keyshares() ) {
        for ( auto* keyshares__elem_ : *keyshares() ) {
            delete keyshares__elem_;
            keyshares__elem_ = nullptr;
        }
    }
    delete keyshares_;
}

int ClientHelloKeyShare::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_ClientHelloKeyShare__size;
    // Checking out-of-bound for "ClientHelloKeyShare:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHelloKeyShare:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_ClientHelloKeyShare__size =  ( length() + 2 ) ;
    // Checking out-of-bound for "ClientHelloKeyShare"
    if ( t_begin_of_data + (t_ClientHelloKeyShare__size) > t_end_of_data || t_begin_of_data + (t_ClientHelloKeyShare__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ClientHelloKeyShare",
        	(0) + (t_ClientHelloKeyShare__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_ClientHelloKeyShare__size;

        // Parse "keyshares"
        int t_keyshares__arraylength;
        t_keyshares__arraylength = 0;
        keyshares__elem_ = nullptr;
        int t_keyshares__elem__it;
        t_keyshares__elem__it = 0;
        int t_keyshares__size;
        keyshares_ = new vector<KeyShareEntry*>;
        const_byteptr t_keyshares__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_keyshares__elem__it) {
            // Check &until(keyshares__elem__dataptr >= end_of_data)
            if ( t_keyshares__elem__dataptr >= t_end_of_data ) {
                keyshares__elem_ = nullptr;
                goto end_of_keyshares;
            }
            keyshares__elem_ = new KeyShareEntry();
            int t_keyshares__elem__size;
            t_keyshares__elem__size = keyshares__elem_->Parse(t_keyshares__elem__dataptr, t_end_of_data, t_byteorder);
            keyshares_->push_back(keyshares__elem_);
            t_keyshares__elem__dataptr += t_keyshares__elem__size;
            BINPAC_ASSERT(t_keyshares__elem__dataptr <= t_end_of_data);
            keyshares__elem_ = nullptr;
        }
    end_of_keyshares: ;
        t_keyshares__size = t_keyshares__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_client_key_share(rec(), keyshares());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_ClientHelloKeyShare__size) <= t_end_of_data);
    return t_ClientHelloKeyShare__size;
}

KeyShare::KeyShare(HandshakeRecord* rec, SSLExtension* ext) {
    val_case_index_ = -1;
    client_hello_keyshare_ = nullptr;
    server_hello_keyshare_ = nullptr;
    rec_ = rec;
    ext_ = ext;
}

KeyShare::~KeyShare() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Clean up "client_hello_keyshare"
            {
                delete client_hello_keyshare_;
                client_hello_keyshare_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "server_hello_keyshare"
            {
                delete server_hello_keyshare_;
                server_hello_keyshare_ = nullptr;
            }
            break;
        default:
            // Clean up "other"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int KeyShare::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = rec()->msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Parse "client_hello_keyshare"
            {
                client_hello_keyshare_ = new ClientHelloKeyShare(rec());
                int t_client_hello_keyshare__size;
                t_client_hello_keyshare__size = client_hello_keyshare_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_client_hello_keyshare__size;
            }
            break;
        case ((uint8)2):
            // Parse "server_hello_keyshare"
            {
                server_hello_keyshare_ = new ServerHelloKeyShareChoice(rec(), ext());
                int t_server_hello_keyshare__size;
                t_server_hello_keyshare__size = server_hello_keyshare_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_server_hello_keyshare__size;
            }
            break;
        default:
            // Parse "other"
            {
                int t_other_string_length;
                t_other_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_other__size;
                t_other__size = t_other_string_length;
                // check for negative sizes
                if ( t_other_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:927", t_other_string_length);
                other_.init(t_begin_of_data, t_other_string_length);
                t_val__size = t_other__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SelectedPreSharedKeyIdentity::SelectedPreSharedKeyIdentity(HandshakeRecord* rec) {
    selected_identity_ = 0;
    rec_ = rec;
    proc_ = false;
}

SelectedPreSharedKeyIdentity::~SelectedPreSharedKeyIdentity() {
}

int SelectedPreSharedKeyIdentity::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "SelectedPreSharedKeyIdentity"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SelectedPreSharedKeyIdentity",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "selected_identity"
    selected_identity_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_pre_shared_key_client_hello(rec(), selected_identity());
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

PSKIdentity::PSKIdentity() {
    length_ = 0;
    obfuscated_ticket_age_ = 0;
}

PSKIdentity::~PSKIdentity() {
    identity_.free();
}

int PSKIdentity::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "PSKIdentity:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKIdentity:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "identity"
    int t_identity__size;
    t_identity__size = length();
    // Checking out-of-bound for "PSKIdentity:identity"
    if ( (t_begin_of_data + 2) + (t_identity__size) > t_end_of_data || (t_begin_of_data + 2) + (t_identity__size) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKIdentity:identity",
        	(2) + (t_identity__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 2) + t_identity__size;
        int t_identity_string_length;
        t_identity_string_length = length();
        // check for negative sizes
        if ( t_identity_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:936", t_identity_string_length);
        identity_.init((t_begin_of_data + 2), t_identity_string_length);
    }

    const_byteptr const t_dataptr_after_identity = (t_begin_of_data + 2) + (t_identity__size);
    BINPAC_ASSERT(t_dataptr_after_identity <= t_end_of_data);
    // Checking out-of-bound for "PSKIdentity:obfuscated_ticket_age"
    if ( t_dataptr_after_identity + (4) > t_end_of_data || t_dataptr_after_identity + (4) < t_dataptr_after_identity ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKIdentity:obfuscated_ticket_age",
        	((t_dataptr_after_identity - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "obfuscated_ticket_age"
    obfuscated_ticket_age_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_identity)));

    int t_PSKIdentity__size;
    t_PSKIdentity__size = (t_dataptr_after_identity + 4) - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PSKIdentity__size) <= t_end_of_data);
    return t_PSKIdentity__size;
}

PSKIdentitiesList::PSKIdentitiesList() {
    length_ = 0;
    identities_ = nullptr;
    identities__elem_ = nullptr;
}

PSKIdentitiesList::~PSKIdentitiesList() {
    delete identities__elem_;
    identities__elem_ = nullptr;
    if ( identities() ) {
        for ( auto* identities__elem_ : *identities() ) {
            delete identities__elem_;
            identities__elem_ = nullptr;
        }
    }
    delete identities_;
}

int PSKIdentitiesList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_PSKIdentitiesList__size;
    // Checking out-of-bound for "PSKIdentitiesList:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKIdentitiesList:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_PSKIdentitiesList__size = length() + 2;
    // Checking out-of-bound for "PSKIdentitiesList"
    if ( t_begin_of_data + (t_PSKIdentitiesList__size) > t_end_of_data || t_begin_of_data + (t_PSKIdentitiesList__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKIdentitiesList",
        	(0) + (t_PSKIdentitiesList__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PSKIdentitiesList__size;

        // Parse "identities"
        int t_identities__arraylength;
        t_identities__arraylength = 0;
        identities__elem_ = nullptr;
        int t_identities__elem__it;
        t_identities__elem__it = 0;
        int t_identities__size;
        identities_ = new vector<PSKIdentity*>;
        const_byteptr t_identities__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_identities__elem__it) {
            // Check &until(identities__elem__dataptr >= end_of_data)
            if ( t_identities__elem__dataptr >= t_end_of_data ) {
                identities__elem_ = nullptr;
                goto end_of_identities;
            }
            identities__elem_ = new PSKIdentity();
            int t_identities__elem__size;
            t_identities__elem__size = identities__elem_->Parse(t_identities__elem__dataptr, t_end_of_data, t_byteorder);
            identities_->push_back(identities__elem_);
            t_identities__elem__dataptr += t_identities__elem__size;
            BINPAC_ASSERT(t_identities__elem__dataptr <= t_end_of_data);
            identities__elem_ = nullptr;
        }
    end_of_identities: ;
        t_identities__size = t_identities__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PSKIdentitiesList__size) <= t_end_of_data);
    return t_PSKIdentitiesList__size;
}

PSKBinder::PSKBinder() {
    length_ = 0;
}

PSKBinder::~PSKBinder() {
    binder_.free();
}

int PSKBinder::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "PSKBinder:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKBinder:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "binder"
    int t_binder__size;
    t_binder__size = length();
    // Checking out-of-bound for "PSKBinder:binder"
    if ( (t_begin_of_data + 1) + (t_binder__size) > t_end_of_data || (t_begin_of_data + 1) + (t_binder__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKBinder:binder",
        	(1) + (t_binder__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_binder__size;
        int t_binder_string_length;
        t_binder_string_length = length();
        // check for negative sizes
        if ( t_binder_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:947", t_binder_string_length);
        binder_.init((t_begin_of_data + 1), t_binder_string_length);
    }

    int t_PSKBinder__size;
    const_byteptr const t_dataptr_after_binder = (t_begin_of_data + 1) + (t_binder__size);
    BINPAC_ASSERT(t_dataptr_after_binder <= t_end_of_data);
    t_PSKBinder__size = t_dataptr_after_binder - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_PSKBinder__size) <= t_end_of_data);
    return t_PSKBinder__size;
}

PSKBindersList::PSKBindersList() {
    length_ = 0;
    binders_ = nullptr;
    binders__elem_ = nullptr;
}

PSKBindersList::~PSKBindersList() {
    delete binders__elem_;
    binders__elem_ = nullptr;
    if ( binders() ) {
        for ( auto* binders__elem_ : *binders() ) {
            delete binders__elem_;
            binders__elem_ = nullptr;
        }
    }
    delete binders_;
}

int PSKBindersList::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    int t_PSKBindersList__size;
    // Checking out-of-bound for "PSKBindersList:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKBindersList:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_PSKBindersList__size = length() + 2;
    // Checking out-of-bound for "PSKBindersList"
    if ( t_begin_of_data + (t_PSKBindersList__size) > t_end_of_data || t_begin_of_data + (t_PSKBindersList__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("PSKBindersList",
        	(0) + (t_PSKBindersList__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_PSKBindersList__size;

        // Parse "binders"
        int t_binders__arraylength;
        t_binders__arraylength = 0;
        binders__elem_ = nullptr;
        int t_binders__elem__it;
        t_binders__elem__it = 0;
        int t_binders__size;
        binders_ = new vector<PSKBinder*>;
        const_byteptr t_binders__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_binders__elem__it) {
            // Check &until(binders__elem__dataptr >= end_of_data)
            if ( t_binders__elem__dataptr >= t_end_of_data ) {
                binders__elem_ = nullptr;
                goto end_of_binders;
            }
            binders__elem_ = new PSKBinder();
            int t_binders__elem__size;
            t_binders__elem__size = binders__elem_->Parse(t_binders__elem__dataptr, t_end_of_data);
            binders_->push_back(binders__elem_);
            t_binders__elem__dataptr += t_binders__elem__size;
            BINPAC_ASSERT(t_binders__elem__dataptr <= t_end_of_data);
            binders__elem_ = nullptr;
        }
    end_of_binders: ;
        t_binders__size = t_binders__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (t_PSKBindersList__size) <= t_end_of_data);
    return t_PSKBindersList__size;
}

OfferedPsks::OfferedPsks(HandshakeRecord* rec) {
    identities_ = nullptr;
    binders_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

OfferedPsks::~OfferedPsks() {
    delete identities_;
    identities_ = nullptr;
    delete binders_;
    binders_ = nullptr;
}

int OfferedPsks::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Parse "identities"
    identities_ = new PSKIdentitiesList();
    int t_identities__size;
    t_identities__size = identities_->Parse(t_begin_of_data, t_end_of_data, t_byteorder);

    const_byteptr const t_dataptr_after_identities = t_begin_of_data + (t_identities__size);
    BINPAC_ASSERT(t_dataptr_after_identities <= t_end_of_data);
    // Parse "binders"
    binders_ = new PSKBindersList();
    int t_binders__size;
    t_binders__size = binders_->Parse(t_dataptr_after_identities, t_end_of_data, t_byteorder);

    int t_OfferedPsks__size;
    const_byteptr const t_dataptr_after_binders = t_dataptr_after_identities + (t_binders__size);
    BINPAC_ASSERT(t_dataptr_after_binders <= t_end_of_data);
    t_OfferedPsks__size = t_dataptr_after_binders - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_pre_shared_key_server_hello(rec(), identities(), binders());
    BINPAC_ASSERT(t_begin_of_data + (t_OfferedPsks__size) <= t_end_of_data);
    return t_OfferedPsks__size;
}

PreSharedKey::PreSharedKey(HandshakeRecord* rec) {
    val_case_index_ = -1;
    offered_psks_ = nullptr;
    selected_identity_ = nullptr;
    rec_ = rec;
}

PreSharedKey::~PreSharedKey() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Clean up "offered_psks"
            {
                delete offered_psks_;
                offered_psks_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "selected_identity"
            {
                delete selected_identity_;
                selected_identity_ = nullptr;
            }
            break;
        default:
            // Clean up "other"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

int PreSharedKey::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_val__size;
    val_case_index_ = rec()->msg_type();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case ((uint8)1):
            // Parse "offered_psks"
            {
                offered_psks_ = new OfferedPsks(rec());
                int t_offered_psks__size;
                t_offered_psks__size = offered_psks_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = t_offered_psks__size;
            }
            break;
        case ((uint8)2):
            // Parse "selected_identity"
            {
                selected_identity_ = new SelectedPreSharedKeyIdentity(rec());
                selected_identity_->Parse(t_begin_of_data, t_end_of_data, t_context, t_byteorder);
                t_val__size = 2;
            }
            break;
        default:
            // Parse "other"
            {
                int t_other_string_length;
                t_other_string_length = (t_end_of_data) - (t_begin_of_data);
                int t_other__size;
                t_other__size = t_other_string_length;
                // check for negative sizes
                if ( t_other_string_length < 0 )
                throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:964", t_other_string_length);
                other_.init(t_begin_of_data, t_other_string_length);
                t_val__size = t_other__size;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_val__size) <= t_end_of_data);
    return t_val__size;
}

SignatureAlgorithm::SignatureAlgorithm(HandshakeRecord* rec) {
    length_ = 0;
    supported_signature_algorithms_ = nullptr;
    supported_signature_algorithms__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

SignatureAlgorithm::~SignatureAlgorithm() {
    delete supported_signature_algorithms__elem_;
    supported_signature_algorithms__elem_ = nullptr;
    if ( supported_signature_algorithms() ) {
        for ( auto* supported_signature_algorithms__elem_ : *supported_signature_algorithms() ) {
            delete supported_signature_algorithms__elem_;
            supported_signature_algorithms__elem_ = nullptr;
        }
    }
    delete supported_signature_algorithms_;
}

int SignatureAlgorithm::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_SignatureAlgorithm__size;
    // Checking out-of-bound for "SignatureAlgorithm:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignatureAlgorithm:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_SignatureAlgorithm__size = length() + 2;
    // Checking out-of-bound for "SignatureAlgorithm"
    if ( t_begin_of_data + (t_SignatureAlgorithm__size) > t_end_of_data || t_begin_of_data + (t_SignatureAlgorithm__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignatureAlgorithm",
        	(0) + (t_SignatureAlgorithm__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SignatureAlgorithm__size;

        // Parse "supported_signature_algorithms"
        int t_supported_signature_algorithms__arraylength;
        t_supported_signature_algorithms__arraylength = 0;
        supported_signature_algorithms__elem_ = nullptr;
        int t_supported_signature_algorithms__elem__it;
        t_supported_signature_algorithms__elem__it = 0;
        int t_supported_signature_algorithms__size;
        supported_signature_algorithms_ = new vector<SignatureAndHashAlgorithm*>;
        const_byteptr t_supported_signature_algorithms__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_supported_signature_algorithms__elem__it) {
            // Check &until(supported_signature_algorithms__elem__dataptr >= end_of_data)
            if ( t_supported_signature_algorithms__elem__dataptr >= t_end_of_data ) {
                supported_signature_algorithms__elem_ = nullptr;
                goto end_of_supported_signature_algorithms;
            }
            supported_signature_algorithms__elem_ = new SignatureAndHashAlgorithm();
            supported_signature_algorithms__elem_->Parse(t_supported_signature_algorithms__elem__dataptr, t_end_of_data);
            supported_signature_algorithms_->push_back(supported_signature_algorithms__elem_);
            t_supported_signature_algorithms__elem__dataptr += 2;
            BINPAC_ASSERT(t_supported_signature_algorithms__elem__dataptr <= t_end_of_data);
            supported_signature_algorithms__elem_ = nullptr;
        }
    end_of_supported_signature_algorithms: ;
        t_supported_signature_algorithms__size = t_supported_signature_algorithms__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_signature_algorithm(rec(), supported_signature_algorithms());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SignatureAlgorithm__size) <= t_end_of_data);
    return t_SignatureAlgorithm__size;
}

EllipticCurves::EllipticCurves(HandshakeRecord* rec) {
    length_ = 0;
    elliptic_curve_list_ = nullptr;
    elliptic_curve_list__elem_ = 0;
    rec_ = rec;
    proc_ = false;
}

EllipticCurves::~EllipticCurves() {
    delete elliptic_curve_list_;
}

int EllipticCurves::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    // Checking out-of-bound for "EllipticCurves:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("EllipticCurves:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "elliptic_curve_list"
    int t_elliptic_curve_list__arraylength;
    t_elliptic_curve_list__arraylength = length() / 2;
    if ( t_elliptic_curve_list__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("EllipticCurves:elliptic_curve_list",
          t_elliptic_curve_list__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: EllipticCurves:elliptic_curve_list
    if ( t_elliptic_curve_list__arraylength > ((t_end_of_data - (t_begin_of_data + 2)) / 2) )
        throw binpac::ExceptionOutOfBound("EllipticCurves:elliptic_curve_list",
          t_elliptic_curve_list__arraylength, (t_end_of_data) - ((t_begin_of_data + 2)));
    elliptic_curve_list__elem_ = 0;
    int t_elliptic_curve_list__elem__it;
    t_elliptic_curve_list__elem__it = 0;
    int t_elliptic_curve_list__size;
    elliptic_curve_list_ = new vector<uint16>;
    elliptic_curve_list_->reserve(t_elliptic_curve_list__arraylength);
    const_byteptr t_elliptic_curve_list__elem__dataptr = (t_begin_of_data + 2);
    for (; t_elliptic_curve_list__elem__it < t_elliptic_curve_list__arraylength; ++t_elliptic_curve_list__elem__it) {
        elliptic_curve_list__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_elliptic_curve_list__elem__dataptr)));
        elliptic_curve_list_->push_back(elliptic_curve_list__elem_);
        t_elliptic_curve_list__elem__dataptr += 2;
        BINPAC_ASSERT(t_elliptic_curve_list__elem__dataptr <= t_end_of_data);
    }
end_of_elliptic_curve_list: ;
    t_elliptic_curve_list__size = t_elliptic_curve_list__elem__dataptr - ((t_begin_of_data + 2));
    // Evaluate 'let' and 'withinput' fields

    int t_EllipticCurves__size;
    const_byteptr const t_dataptr_after_elliptic_curve_list = (t_begin_of_data + 2) + (t_elliptic_curve_list__size);
    BINPAC_ASSERT(t_dataptr_after_elliptic_curve_list <= t_end_of_data);
    t_EllipticCurves__size = t_dataptr_after_elliptic_curve_list - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->connection()->proc_elliptic_curves(rec(), elliptic_curve_list());
    BINPAC_ASSERT(t_begin_of_data + (t_EllipticCurves__size) <= t_end_of_data);
    return t_EllipticCurves__size;
}

ProtocolName::ProtocolName() {
    length_ = 0;
}

ProtocolName::~ProtocolName() {
    name_.free();
}

int ProtocolName::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "ProtocolName:length"
    if ( t_begin_of_data + (1) > t_end_of_data || t_begin_of_data + (1) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ProtocolName:length",
        	(0) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "name"
    int t_name__size;
    t_name__size = length();
    // Checking out-of-bound for "ProtocolName:name"
    if ( (t_begin_of_data + 1) + (t_name__size) > t_end_of_data || (t_begin_of_data + 1) + (t_name__size) < (t_begin_of_data + 1) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ProtocolName:name",
        	(1) + (t_name__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = (t_begin_of_data + 1) + t_name__size;
        int t_name_string_length;
        t_name_string_length = length();
        // check for negative sizes
        if ( t_name_string_length < 0 )
        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/analyzer/protocol/ssl/tls-handshake-protocol.pac:979", t_name_string_length);
        name_.init((t_begin_of_data + 1), t_name_string_length);
    }

    int t_ProtocolName__size;
    const_byteptr const t_dataptr_after_name = (t_begin_of_data + 1) + (t_name__size);
    BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
    t_ProtocolName__size = t_dataptr_after_name - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_ProtocolName__size) <= t_end_of_data);
    return t_ProtocolName__size;
}

ApplicationLayerProtocolNegotiationExtension::ApplicationLayerProtocolNegotiationExtension(HandshakeRecord* rec) {
    length_ = 0;
    protocol_name_list_ = nullptr;
    protocol_name_list__elem_ = nullptr;
    rec_ = rec;
    proc_ = false;
}

ApplicationLayerProtocolNegotiationExtension::~ApplicationLayerProtocolNegotiationExtension() {
    delete protocol_name_list__elem_;
    protocol_name_list__elem_ = nullptr;
    if ( protocol_name_list() ) {
        for ( auto* protocol_name_list__elem_ : *protocol_name_list() ) {
            delete protocol_name_list__elem_;
            protocol_name_list__elem_ = nullptr;
        }
    }
    delete protocol_name_list_;
}

int ApplicationLayerProtocolNegotiationExtension::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextTLSHandshake* t_context, int t_byteorder) {
    int t_ApplicationLayerProtocolNegotiationExtension__size;
    // Checking out-of-bound for "ApplicationLayerProtocolNegotiationExtension:length"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ApplicationLayerProtocolNegotiationExtension:length",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_ApplicationLayerProtocolNegotiationExtension__size = length() + 2;
    // Checking out-of-bound for "ApplicationLayerProtocolNegotiationExtension"
    if ( t_begin_of_data + (t_ApplicationLayerProtocolNegotiationExtension__size) > t_end_of_data || t_begin_of_data + (t_ApplicationLayerProtocolNegotiationExtension__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("ApplicationLayerProtocolNegotiationExtension",
        	(0) + (t_ApplicationLayerProtocolNegotiationExtension__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_ApplicationLayerProtocolNegotiationExtension__size;

        // Parse "protocol_name_list"
        int t_protocol_name_list__arraylength;
        t_protocol_name_list__arraylength = 0;
        protocol_name_list__elem_ = nullptr;
        int t_protocol_name_list__elem__it;
        t_protocol_name_list__elem__it = 0;
        int t_protocol_name_list__size;
        protocol_name_list_ = new vector<ProtocolName*>;
        const_byteptr t_protocol_name_list__elem__dataptr = (t_begin_of_data + 2);
        for (; /* forever */; ++t_protocol_name_list__elem__it) {
            // Check &until(protocol_name_list__elem__dataptr >= end_of_data)
            if ( t_protocol_name_list__elem__dataptr >= t_end_of_data ) {
                protocol_name_list__elem_ = nullptr;
                goto end_of_protocol_name_list;
            }
            protocol_name_list__elem_ = new ProtocolName();
            int t_protocol_name_list__elem__size;
            t_protocol_name_list__elem__size = protocol_name_list__elem_->Parse(t_protocol_name_list__elem__dataptr, t_end_of_data);
            protocol_name_list_->push_back(protocol_name_list__elem_);
            t_protocol_name_list__elem__dataptr += t_protocol_name_list__elem__size;
            BINPAC_ASSERT(t_protocol_name_list__elem__dataptr <= t_end_of_data);
            protocol_name_list__elem_ = nullptr;
        }
    end_of_protocol_name_list: ;
        t_protocol_name_list__size = t_protocol_name_list__elem__dataptr - ((t_begin_of_data + 2));
        // Evaluate 'let' and 'withinput' fields

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_apnl(rec(), protocol_name_list());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_ApplicationLayerProtocolNegotiationExtension__size) <= t_end_of_data);
    return t_ApplicationLayerProtocolNegotiationExtension__size;
}

Handshake_Flow::Handshake_Flow(Handshake_Conn* connection, bool is_orig) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    is_orig_ = is_orig;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

Handshake_Flow::~Handshake_Flow() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void Handshake_Flow::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new HandshakePDU(is_orig());
                context_ = new ContextTLSHandshake(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void Handshake_Flow::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void Handshake_Flow::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
} // namespace TLSHandshake
}  // namespace binpac
