// This file was automatically generated by bifcl from /build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif (plugin mode).


#include "functions.bif.h"
#include "zeek/Func.h"


#line 2 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

#include "zeek/File.h"
#include "zeek/session/Manager.h"
#include "zeek/Reporter.h"
#include "zeek/analyzer/protocol/tcp/TCP.h"
#include "zeek/packet_analysis/Manager.h"

#line 20 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
zeek::ValPtr zeek::BifFunc::get_orig_seq_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 21 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("get_orig_seq() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* cid = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 21 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

	zeek::Connection* c = zeek::session_mgr->FindConnection(cid);
	if ( ! c )
		return zeek::val_mgr->Count(0);

	if ( c->ConnTransport() != TRANSPORT_TCP )
		return zeek::val_mgr->Count(0);

	zeek::analyzer::Analyzer* tc = c->FindAnalyzer("TCP");
	if ( tc )
		return zeek::val_mgr->Count(static_cast<zeek::packet_analysis::TCP::TCPSessionAdapter*>(tc)->OrigSeq());
	else
		{
		reporter->Error("connection does not have TCP analyzer");
		return zeek::val_mgr->Count(0);
		}
	} // end of BifFunc::get_orig_seq

#line 37 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

#line 49 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
zeek::ValPtr zeek::BifFunc::get_resp_seq_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 50 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("get_resp_seq() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* cid = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 50 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

	zeek::Connection* c = zeek::session_mgr->FindConnection(cid);
	if ( ! c )
		return zeek::val_mgr->Count(0);

	if ( c->ConnTransport() != TRANSPORT_TCP )
		return zeek::val_mgr->Count(0);

	zeek::analyzer::Analyzer* tc = c->FindAnalyzer("TCP");
	if ( tc )
		return zeek::val_mgr->Count(static_cast<zeek::packet_analysis::TCP::TCPSessionAdapter*>(tc)->RespSeq());
	else
		{
		reporter->Error("connection does not have TCP analyzer");
		return zeek::val_mgr->Count(0);
		}
	} // end of BifFunc::get_resp_seq

#line 66 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

#line 99 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
zeek::ValPtr zeek::BifFunc::set_contents_file_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 100 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
{
	if ( BiF_ARGS->size() != 3 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("set_contents_file() takes exactly 3 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* cid = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek_uint_t direction = (zeek_uint_t) ((*BiF_ARGS)[1].get()->AsCount()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek::File* f = (zeek::File*) ((*BiF_ARGS)[2].get()->AsFile()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 100 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

	zeek::Connection* c = zeek::session_mgr->FindConnection(cid);
	if ( ! c )
		return zeek::val_mgr->False();

	c->GetSessionAdapter()->SetContentsFile(direction, {zeek::NewRef{}, f});
	return zeek::val_mgr->True();
	} // end of BifFunc::set_contents_file

#line 107 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

#line 122 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
zeek::ValPtr zeek::BifFunc::get_contents_file_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 123 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
{
	if ( BiF_ARGS->size() != 2 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("get_contents_file() takes exactly 2 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	zeek::Val* cid = (zeek::Val*) ((*BiF_ARGS)[0].get()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)
	zeek_uint_t direction = (zeek_uint_t) ((*BiF_ARGS)[1].get()->AsCount()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 123 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

	zeek::Connection* c = zeek::session_mgr->FindConnection(cid);

	if ( c )
		{
		auto cf = c->GetSessionAdapter()->GetContentsFile(direction);

		if ( cf )
			return zeek::make_intrusive<zeek::FileVal>(std::move(cf));
		}

	// Return some sort of error value.
	if ( ! c )
		zeek::emit_builtin_error("unknown connection id in get_contents_file()", cid);
	else
		zeek::emit_builtin_error("no contents file for given direction");

	return zeek::make_intrusive<zeek::FileVal>(zeek::make_intrusive<zeek::File>(stderr, "-", "w"));
	} // end of BifFunc::get_contents_file

#line 141 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

#line 152 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
zeek::ValPtr zeek::BifFunc::TCP::raw_options_bif(zeek::detail::Frame* frame, const zeek::Args* BiF_ARGS)
	
#line 153 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
{
	if ( BiF_ARGS->size() != 1 )
		{
		zeek::emit_builtin_error(zeek::util::fmt("TCP::raw_options() takes exactly 1 argument(s), got %lu", BiF_ARGS->size()));
		return nullptr;
		}
	int stop_at_eol = (int) ((*BiF_ARGS)[0].get()->AsBool()); // NOLINT(cppcoreguidelines-pro-type-cstyle-cast)

#line 153 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"

	static auto tcp_option_list = zeek::id::find_type<zeek::VectorType>("TCP::RawOptionList");
	auto result = zeek::make_intrusive<zeek::VectorVal>(tcp_option_list);

	static const auto& analyzer = zeek::packet_mgr->GetAnalyzer("TCP");
	auto spans = zeek::packet_mgr->GetAnalyzerData(analyzer);

	if ( spans.empty() || spans[0].size() < sizeof(struct tcphdr) )
		return result;

	const auto* tcp_hdr = reinterpret_cast<const struct tcphdr*>(spans[0].data());
	size_t tcp_header_size = static_cast<size_t>(tcp_hdr->th_off) * 4;

	if ( ( tcp_header_size < sizeof(struct tcphdr) ) || ( tcp_header_size > spans[0].size() ) )
		return result;

	const auto* options_start = reinterpret_cast<const std::byte*>(tcp_hdr) + sizeof(struct tcphdr);
	const auto* options_end = reinterpret_cast<const std::byte*>(tcp_hdr) + tcp_header_size;

	assert(options_start <= options_end);

	std::span<const std::byte> remaining_options(options_start, options_end);

	static auto tcp_option = zeek::id::find_type<zeek::RecordType>("TCP::RawOption");

	while ( !remaining_options.empty() ) {
		const auto opt = static_cast<uint8_t>(remaining_options[0]);
		std::span<const std::byte> current_option_data = {};

		size_t opt_len;

		if ( opt < 2 )
			opt_len = 1;
		else if ( remaining_options.size() < 2 )
			// We've run off the end, no room for the length.
			break;
		else
			opt_len = static_cast<size_t>(remaining_options[1]);

		if ( opt_len == 0 )
			break; // trashed length field

		if ( opt_len > remaining_options.size()  )
			// No room for rest of option.
			break;

		if ( opt_len > 2 )
			current_option_data = remaining_options.subspan(2, opt_len-2);
		remaining_options = remaining_options.subspan(opt_len);

		auto r = make_intrusive<RecordVal>(tcp_option);
		r->Assign(0, opt);
		if ( ! current_option_data.empty() )
			r->Assign(1, zeek::make_intrusive<zeek::StringVal>(current_option_data.size(), reinterpret_cast<const char*>(current_option_data.data())));
		else
			r->Assign(1, zeek::val_mgr->EmptyString());
		result->Append(r);

		if ( stop_at_eol && opt == TCPOPT_EOL )
			break;
    }

	return result;
	} // end of BifFunc::TCP::raw_options

#line 216 "/build/zeek/src/zeek/src/analyzer/protocol/tcp/functions.bif"
