// This file is automatically generated from /build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/file_analysis/analyzer/pe/pe_pac.h"

namespace binpac {






namespace PE {
ContextPE::ContextPE(MockConnection* connection, File* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextPE::~ContextPE() {
}

MockConnection::MockConnection(ZeekFileAnalyzer* zeek_analyzer) {
    upflow_ = new File(this);
    downflow_ = new File(this);
    zeek_analyzer_ = zeek_analyzer;

		max_file_location_ = 0;
		pe32_format_ = UNKNOWN_VERSION;;
	

		done_ = false;
	
}

MockConnection::~MockConnection() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void MockConnection::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void MockConnection::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void MockConnection::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool MockConnection::add_section(Section_Header* h) {

		if ( h->size_of_raw_data() + h->ptr_to_raw_data() > max_file_location_ )
			max_file_location_ = h->size_of_raw_data() + h->ptr_to_raw_data();

		return true;
		
}

uint8 MockConnection::set_pe32_format(uint16 magic) {

		if ( magic == 0x10b )
			pe32_format_ = PE32;

		if ( magic == 0x20b )
			pe32_format_ = PE32_PLUS;

		return pe32_format_;
		
}

uint64 MockConnection::get_max_file_location() {

		return max_file_location_;
		
}

uint8 MockConnection::get_pe32_format() {

		return pe32_format_;
		
}

bool MockConnection::mark_done() {

		done_ = true;
		return true;
		
}

bool MockConnection::is_done() {

		return done_;
		
}

Mem_Info32::Mem_Info32() {
    size_of_stack_reserve_ = 0;
    size_of_stack_commit_ = 0;
    size_of_heap_reserve_ = 0;
    size_of_heap_commit_ = 0;
    byteorder_ = littleendian;
}

Mem_Info32::~Mem_Info32() {
}

int Mem_Info32::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Mem_Info32"
    if ( t_begin_of_data + (16) > t_end_of_data || t_begin_of_data + (16) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Mem_Info32",
        	(0) + (16), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 16;
        // Checking out-of-bound for "Mem_Info32:size_of_heap_commit"
        if ( (t_begin_of_data + 12) + (4) > t_end_of_data || (t_begin_of_data + 12) + (4) < (t_begin_of_data + 12) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Mem_Info32:size_of_heap_commit",
            	(12) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "size_of_stack_reserve"
        size_of_stack_reserve_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "size_of_stack_commit"
        size_of_stack_commit_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

        // Parse "size_of_heap_reserve"
        size_of_heap_reserve_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

        // Parse "size_of_heap_commit"
        size_of_heap_commit_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (16) <= t_end_of_data);
    return 16;
}

Mem_Info64::Mem_Info64() {
    size_of_stack_reserve_ = 0;
    size_of_stack_commit_ = 0;
    size_of_heap_reserve_ = 0;
    size_of_heap_commit_ = 0;
    byteorder_ = littleendian;
}

Mem_Info64::~Mem_Info64() {
}

int Mem_Info64::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "Mem_Info64"
    if ( t_begin_of_data + (32) > t_end_of_data || t_begin_of_data + (32) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Mem_Info64",
        	(0) + (32), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 32;
        // Checking out-of-bound for "Mem_Info64:size_of_heap_commit"
        if ( (t_begin_of_data + 24) + (8) > t_end_of_data || (t_begin_of_data + 24) + (8) < (t_begin_of_data + 24) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Mem_Info64:size_of_heap_commit",
            	(24) + (8), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "size_of_stack_reserve"
        size_of_stack_reserve_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>(t_begin_of_data)));

        // Parse "size_of_stack_commit"
        size_of_stack_commit_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 8))));

        // Parse "size_of_heap_reserve"
        size_of_heap_reserve_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 16))));

        // Parse "size_of_heap_commit"
        size_of_heap_commit_ = FixByteOrder(byteorder(), *(reinterpret_cast<uint64 const*>((t_begin_of_data + 24))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (32) <= t_end_of_data);
    return 32;
}

RVAS::RVAS(uint32 num) {
    rvas_ = nullptr;
    rvas__elem_ = nullptr;
    num_ = num;
}

RVAS::~RVAS() {
    delete rvas__elem_;
    rvas__elem_ = nullptr;
    if ( rvas() ) {
        for ( auto* rvas__elem_ : *rvas() ) {
            delete rvas__elem_;
            rvas__elem_ = nullptr;
        }
    }
    delete rvas_;
}

int RVAS::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Parse "rvas"
    int t_rvas__arraylength;
    t_rvas__arraylength = num();
    if ( t_rvas__arraylength < 0 ) {
        throw binpac::ExceptionOutOfBound("RVAS:rvas",
          t_rvas__arraylength, (t_end_of_data) - (t_begin_of_data));
    }
    // Check bounds for static-size array: RVAS:rvas
    if ( t_rvas__arraylength > ((t_end_of_data - t_begin_of_data) / 8) )
        throw binpac::ExceptionOutOfBound("RVAS:rvas",
          t_rvas__arraylength, (t_end_of_data) - (t_begin_of_data));
    rvas__elem_ = nullptr;
    int t_rvas__elem__it;
    t_rvas__elem__it = 0;
    int t_rvas__size;
    rvas_ = new vector<RVA*>;
    rvas_->reserve(t_rvas__arraylength);
    const_byteptr t_rvas__elem__dataptr = t_begin_of_data;
    for (; t_rvas__elem__it < t_rvas__arraylength; ++t_rvas__elem__it) {
        rvas__elem_ = new RVA();
        rvas__elem_->Parse(t_rvas__elem__dataptr, t_end_of_data, t_byteorder);
        rvas_->push_back(rvas__elem_);
        t_rvas__elem__dataptr += 8;
        BINPAC_ASSERT(t_rvas__elem__dataptr <= t_end_of_data);
        rvas__elem_ = nullptr;
    }
end_of_rvas: ;
    t_rvas__size = t_rvas__elem__dataptr - (t_begin_of_data);
    // Evaluate 'let' and 'withinput' fields

    int t_RVAS__size;
    const_byteptr const t_dataptr_after_rvas = t_begin_of_data + (t_rvas__size);
    BINPAC_ASSERT(t_dataptr_after_rvas <= t_end_of_data);
    t_RVAS__size = t_dataptr_after_rvas - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (t_RVAS__size) <= t_end_of_data);
    return t_RVAS__size;
}

RVA::RVA() {
    virtual_address_ = 0;
    size_ = 0;
}

RVA::~RVA() {
}

int RVA::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder) {
    // Checking out-of-bound for "RVA"
    if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("RVA",
        	(0) + (8), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 8;
        // Checking out-of-bound for "RVA:size"
        if ( (t_begin_of_data + 4) + (4) > t_end_of_data || (t_begin_of_data + 4) + (4) < (t_begin_of_data + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("RVA:size",
            	(4) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "virtual_address"
        virtual_address_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));

        // Parse "size"
        size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_begin_of_data + (8) <= t_end_of_data);
    return 8;
}

Padding::Padding(uint64 length) {
    buffering_state_ = 0;
    buffering_state_ = 0;
    length_ = length;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

Padding::~Padding() {
}

bool Padding::ParseBuffer(flow_buffer_t t_flow_buffer) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "pad"
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->NewFrame(0, false);
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_pad_parsing_complete;
        t_pad_parsing_complete = false;
        while ( ! t_pad_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            // NOLINTBEGIN(bugprone-branch-clone)
            switch ( buffering_state_ ) {
                case 0:
                    if ( buffering_state_ == 0 ) {
                        t_flow_buffer->NewFrame(0, false);
                        buffering_state_ = 1;
                    }
                    buffering_state_ = 1;
                    break;
                case 1:
                {
                    buffering_state_ = 2;
                    t_flow_buffer->GrowFrame(length());
                }
                break;
                case 2:
                    BINPAC_ASSERT(t_flow_buffer->ready());
                    if ( t_flow_buffer->ready() ) {
                        int t_pad_string_length;
                        t_pad_string_length = length();
                        // check for negative sizes
                        if ( t_pad_string_length < 0 )
                        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-types.pac:34", t_pad_string_length);
                        pad_.init(t_begin_of_data, t_pad_string_length);
                        t_pad_parsing_complete = true;
                        if ( t_pad_parsing_complete ) {
                            // Evaluate 'let' and 'withinput' fields
                        }
                        BINPAC_ASSERT(t_pad_parsing_complete);
                        buffering_state_ = 0;
                    }
                    break;
                default:
                    BINPAC_ASSERT(buffering_state_ <= 2);
                    break;
            }
            // NOLINTEND(bugprone-branch-clone)
        }
        if ( ! (t_pad_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

RegExMatcher null_terminated_string_re_001("[A-Za-z0-9.]+\\x00");

int const MAX_DOS_CODE_LENGTH = 4 * 1024 * 1024;
Headers::Headers() {
    dos_header_ = nullptr;
    dos_code_ = nullptr;
    pe_header_ = nullptr;
    section_headers_ = nullptr;
    dos_code_len_ = 0;
    length_ = 0;
    proc_ = false;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

Headers::~Headers() {
    delete dos_header_;
    dos_header_ = nullptr;
    delete dos_code_;
    dos_code_ = nullptr;
    delete pe_header_;
    pe_header_ = nullptr;
    delete section_headers_;
    section_headers_ = nullptr;
}

bool Headers::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "dos_header"
        if ( ! dos_header_ ) {
            dos_header_ = new DOS_Header();
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_dos_header_parsing_complete;
        t_dos_header_parsing_complete = false;
        while ( ! t_dos_header_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            t_dos_header_parsing_complete = dos_header_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
            if ( t_dos_header_parsing_complete ) {
            }
        }
        if ( ! (t_dos_header_parsing_complete) )
            goto need_more_data;
        }

        // Parse "dos_code"
        if ( ! dos_code_ ) {
            dos_code_len_ = dos_header()->AddressOfNewExeHeader() > 64 ? dos_header()->AddressOfNewExeHeader() - 64 : 0;
            dos_code_ = new DOS_Code(dos_code_len());
        }
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_dos_code_parsing_complete;
        t_dos_code_parsing_complete = false;
        t_dos_code_parsing_complete = dos_code_->ParseBuffer(t_flow_buffer, t_context);
        if ( t_dos_code_parsing_complete ) {
        }
        if ( ! (t_dos_code_parsing_complete) )
            goto need_more_data;
        }

        // Parse "pe_header"
        if ( ! pe_header_ ) {
            pe_header_ = new NT_Headers();
        }
        parsing_state_ = 3;
        /* fall through */
    case 3:
    {
        bool t_pe_header_parsing_complete;
        t_pe_header_parsing_complete = false;
        while ( ! t_pe_header_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            t_pe_header_parsing_complete = pe_header_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
            if ( t_pe_header_parsing_complete ) {
            }
        }
        if ( ! (t_pe_header_parsing_complete) )
            goto need_more_data;
        }

        // Parse "section_headers"
        if ( ! section_headers_ ) {
            section_headers_ = new Section_Headers(pe_header()->file_header()->NumberOfSections());
        }
        parsing_state_ = 4;
        /* fall through */
    case 4:
    {
        bool t_section_headers_parsing_complete;
        t_section_headers_parsing_complete = false;
        while ( ! t_section_headers_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            t_section_headers_parsing_complete = section_headers_->ParseBuffer(t_flow_buffer, t_context, t_byteorder);
            if ( t_section_headers_parsing_complete ) {
            }
        }
        if ( ! (t_section_headers_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        length_ = 64 + dos_code_len() + pe_header()->length() + section_headers()->length();
        proc_ = t_context->connection()->mark_done();
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

DOS_Header::DOS_Header() {
    UsedBytesInTheLastPage_ = 0;
    FileSizeInPages_ = 0;
    NumberOfRelocationItems_ = 0;
    HeaderSizeInParagraphs_ = 0;
    MinimumExtraParagraphs_ = 0;
    MaximumExtraParagraphs_ = 0;
    InitialRelativeSS_ = 0;
    InitialSP_ = 0;
    Checksum_ = 0;
    InitialIP_ = 0;
    InitialRelativeCS_ = 0;
    AddressOfRelocationTable_ = 0;
    OverlayNumber_ = 0;
    Reserved_ = nullptr;
    Reserved__elem_ = 0;
    OEMid_ = 0;
    OEMinfo_ = 0;
    Reserved2_ = nullptr;
    Reserved2__elem_ = 0;
    AddressOfNewExeHeader_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

DOS_Header::~DOS_Header() {
    signature_.free();
    delete Reserved_;
    delete Reserved2_;
}

bool DOS_Header::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            t_flow_buffer->GrowFrame(64);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "signature"
                // Checking out-of-bound for "DOS_Header:signature"
                if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("DOS_Header:signature",
                    	(0) + (2), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                {
                    // Setting t_end_of_data with &length
                    const_byteptr t_end_of_data = t_begin_of_data + 2;
                    int t_signature_string_length;
                    t_signature_string_length = 2;
                    int t_signature__size;
                    t_signature__size = t_signature_string_length;
                    signature_.init(t_begin_of_data, t_signature_string_length);
                }

                const_byteptr const t_dataptr_after_signature = t_begin_of_data + (2);
                BINPAC_ASSERT(t_dataptr_after_signature <= t_end_of_data);
                // Checking out-of-bound for "DOS_Header:AddressOfNewExeHeader"
                if ( (t_dataptr_after_signature + 58) + (4) > t_end_of_data || (t_dataptr_after_signature + 58) + (4) < (t_dataptr_after_signature + 58) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("DOS_Header:AddressOfNewExeHeader",
                    	(((t_dataptr_after_signature + 58) - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                // Parse "UsedBytesInTheLastPage"
                UsedBytesInTheLastPage_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_dataptr_after_signature)));

                // Parse "FileSizeInPages"
                FileSizeInPages_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 2))));

                // Parse "NumberOfRelocationItems"
                NumberOfRelocationItems_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 4))));

                // Parse "HeaderSizeInParagraphs"
                HeaderSizeInParagraphs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 6))));

                // Parse "MinimumExtraParagraphs"
                MinimumExtraParagraphs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 8))));

                // Parse "MaximumExtraParagraphs"
                MaximumExtraParagraphs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 10))));

                // Parse "InitialRelativeSS"
                InitialRelativeSS_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 12))));

                // Parse "InitialSP"
                InitialSP_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 14))));

                // Parse "Checksum"
                Checksum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 16))));

                // Parse "InitialIP"
                InitialIP_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 18))));

                // Parse "InitialRelativeCS"
                InitialRelativeCS_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 20))));

                // Parse "AddressOfRelocationTable"
                AddressOfRelocationTable_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 22))));

                // Parse "OverlayNumber"
                OverlayNumber_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 24))));

                // Parse "Reserved"
                int t_Reserved__arraylength;
                t_Reserved__arraylength = 4;
                if ( t_Reserved__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("DOS_Header:Reserved",
                      t_Reserved__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: DOS_Header:Reserved
                if ( t_Reserved__arraylength > ((t_end_of_data - (t_dataptr_after_signature + 26)) / 2) )
                    throw binpac::ExceptionOutOfBound("DOS_Header:Reserved",
                      t_Reserved__arraylength, (t_end_of_data) - ((t_dataptr_after_signature + 26)));
                Reserved__elem_ = 0;
                int t_Reserved__elem__it;
                t_Reserved__elem__it = 0;
                Reserved_ = new vector<uint16>;
                Reserved_->reserve(t_Reserved__arraylength);
                const_byteptr t_Reserved__elem__dataptr = (t_dataptr_after_signature + 26);
                for (; t_Reserved__elem__it < t_Reserved__arraylength; ++t_Reserved__elem__it) {
                    Reserved__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_Reserved__elem__dataptr)));
                    Reserved_->push_back(Reserved__elem_);
                    t_Reserved__elem__dataptr += 2;
                    BINPAC_ASSERT(t_Reserved__elem__dataptr <= t_end_of_data);
                }
            end_of_Reserved: ;
                // Evaluate 'let' and 'withinput' fields

                // Parse "OEMid"
                OEMid_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 34))));

                // Parse "OEMinfo"
                OEMinfo_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_signature + 36))));

                // Parse "Reserved2"
                int t_Reserved2__arraylength;
                t_Reserved2__arraylength = 10;
                if ( t_Reserved2__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("DOS_Header:Reserved2",
                      t_Reserved2__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check bounds for static-size array: DOS_Header:Reserved2
                if ( t_Reserved2__arraylength > ((t_end_of_data - (t_dataptr_after_signature + 38)) / 2) )
                    throw binpac::ExceptionOutOfBound("DOS_Header:Reserved2",
                      t_Reserved2__arraylength, (t_end_of_data) - ((t_dataptr_after_signature + 38)));
                Reserved2__elem_ = 0;
                int t_Reserved2__elem__it;
                t_Reserved2__elem__it = 0;
                Reserved2_ = new vector<uint16>;
                Reserved2_->reserve(t_Reserved2__arraylength);
                const_byteptr t_Reserved2__elem__dataptr = (t_dataptr_after_signature + 38);
                for (; t_Reserved2__elem__it < t_Reserved2__arraylength; ++t_Reserved2__elem__it) {
                    Reserved2__elem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_Reserved2__elem__dataptr)));
                    Reserved2_->push_back(Reserved2__elem_);
                    t_Reserved2__elem__dataptr += 2;
                    BINPAC_ASSERT(t_Reserved2__elem__dataptr <= t_end_of_data);
                }
            end_of_Reserved2: ;
                // Evaluate 'let' and 'withinput' fields

                // Parse "AddressOfNewExeHeader"
                AddressOfNewExeHeader_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_signature + 58))));
                // Evaluate '&enforce' attribute
                if (! ( AddressOfNewExeHeader() >= 64 &&  ( AddressOfNewExeHeader() - 64 )  < MAX_DOS_CODE_LENGTH ) ) {
                    throw binpac::ExceptionEnforceViolation("DOS_Header:AddressOfNewExeHeader");
                }

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    proc_ = t_context->flow()->proc_dos_header(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

DOS_Code::DOS_Code(uint32 len) {
    buffering_state_ = 0;
    buffering_state_ = 0;
    len_ = len;
    proc_ = false;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

DOS_Code::~DOS_Code() {
    code_.free();
}

bool DOS_Code::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "code"
        if ( buffering_state_ == 0 ) {
            t_flow_buffer->NewFrame(0, false);
            buffering_state_ = 1;
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_code_parsing_complete;
        t_code_parsing_complete = false;
        while ( ! t_code_parsing_complete && t_flow_buffer->ready() ) {
            const_byteptr t_begin_of_data = t_flow_buffer->begin();
            const_byteptr t_end_of_data = t_flow_buffer->end();
            // NOLINTBEGIN(bugprone-branch-clone)
            switch ( buffering_state_ ) {
                case 0:
                    if ( buffering_state_ == 0 ) {
                        t_flow_buffer->NewFrame(0, false);
                        buffering_state_ = 1;
                    }
                    buffering_state_ = 1;
                    break;
                case 1:
                {
                    buffering_state_ = 2;
                    t_flow_buffer->GrowFrame(len());
                }
                break;
                case 2:
                    BINPAC_ASSERT(t_flow_buffer->ready());
                    if ( t_flow_buffer->ready() ) {
                        int t_code_string_length;
                        t_code_string_length = len();
                        // check for negative sizes
                        if ( t_code_string_length < 0 )
                        throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/file_analysis/analyzer/pe/pe-file-headers.pac:43", t_code_string_length);
                        code_.init(t_begin_of_data, t_code_string_length);
                        t_code_parsing_complete = true;
                        if ( t_code_parsing_complete ) {
                            // Evaluate 'let' and 'withinput' fields
                        }
                        BINPAC_ASSERT(t_code_parsing_complete);
                        buffering_state_ = 0;
                    }
                    break;
                default:
                    BINPAC_ASSERT(buffering_state_ <= 2);
                    break;
            }
            // NOLINTEND(bugprone-branch-clone)
        }
        if ( ! (t_code_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->flow()->proc_dos_code(code());
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

NT_Headers::NT_Headers() {
    PESignature_ = 0;
    file_header_ = nullptr;
    have_opt_header_case_index_ = -1;
    optional_header_ = nullptr;
    length_ = 0;
    is_exe_ = false;
    size_of_headers_ = 0;
    proc_ = false;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

NT_Headers::~NT_Headers() {
    delete file_header_;
    file_header_ = nullptr;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_opt_header_case_index() ) {
        case true:
            // Clean up "optional_header"
            {
                delete optional_header_;
                optional_header_ = nullptr;
            }
            break;
        case false:
            // Clean up "none"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool NT_Headers::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(24, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "file_header"
            file_header_ = new File_Header();
            file_header_->Parse((t_begin_of_data + 4), t_end_of_data, t_context, t_byteorder);
            length_ = file_header()->SizeOfOptionalHeader() + 24;
            t_flow_buffer->GrowFrame(length());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "PESignature"
                // Checking out-of-bound for "NT_Headers:PESignature"
                if ( t_begin_of_data + (4) > t_end_of_data || t_begin_of_data + (4) < t_begin_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("NT_Headers:PESignature",
                    	(0) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                PESignature_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_begin_of_data)));


                // Parse "have_opt_header"
                int t_have_opt_header__size;
                is_exe_ = file_header()->SizeOfOptionalHeader() > 0;
                have_opt_header_case_index_ = is_exe();
                // NOLINTBEGIN(bugprone-branch-clone)
                switch ( have_opt_header_case_index() ) {
                    case true:
                        // Parse "optional_header"
                        {
                            optional_header_ = new Optional_Header();
                            int t_optional_header__size;
                            t_optional_header__size = file_header()->SizeOfOptionalHeader();
                            // Checking out-of-bound for "NT_Headers:optional_header"
                            if ( (t_begin_of_data + 24) + (t_optional_header__size) > t_end_of_data || (t_begin_of_data + 24) + (t_optional_header__size) < (t_begin_of_data + 24) ) {
                                // Handle out-of-bound condition
                                throw binpac::ExceptionOutOfBound("NT_Headers:optional_header",
                                	(24) + (t_optional_header__size), 
                                	(t_end_of_data) - (t_begin_of_data));
                            }
                            {
                                // Setting t_end_of_data with &length
                                const_byteptr t_end_of_data = (t_begin_of_data + 24) + t_optional_header__size;
                                optional_header_->Parse((t_begin_of_data + 24), t_end_of_data, t_context, t_byteorder);
                            }
                            t_have_opt_header__size = t_optional_header__size;
                        }
                        break;
                    case false:
                        // Parse "none"
                        {
                            t_have_opt_header__size = 0;
                        }
                        break;
                    default:
                        throw binpac::ExceptionInvalidCaseIndex("NT_Headers", (int64)have_opt_header_case_index());
                        break;
                }
                // NOLINTEND(bugprone-branch-clone)
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                    size_of_headers_ = is_exe() ? optional_header()->size_of_headers() : 0;
                    proc_ = t_context->flow()->proc_nt_headers(this);
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

File_Header::File_Header() {
    Machine_ = 0;
    NumberOfSections_ = 0;
    TimeDateStamp_ = 0;
    PointerToSymbolTable_ = 0;
    NumberOfSymbols_ = 0;
    SizeOfOptionalHeader_ = 0;
    Characteristics_ = 0;
    proc_ = false;
}

File_Header::~File_Header() {
}

int File_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextPE* t_context, int t_byteorder) {
    // Checking out-of-bound for "File_Header"
    if ( t_begin_of_data + (20) > t_end_of_data || t_begin_of_data + (20) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("File_Header",
        	(0) + (20), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "Machine"
    Machine_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "NumberOfSections"
    NumberOfSections_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 2))));

    // Parse "TimeDateStamp"
    TimeDateStamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "PointerToSymbolTable"
    PointerToSymbolTable_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "NumberOfSymbols"
    NumberOfSymbols_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "SizeOfOptionalHeader"
    SizeOfOptionalHeader_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 16))));

    // Parse "Characteristics"
    Characteristics_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_begin_of_data + 18))));

    // Evaluate 'let' and 'withinput' fields
    proc_ = t_context->flow()->proc_file_header(this);
    BINPAC_ASSERT(t_begin_of_data + (20) <= t_end_of_data);
    return 20;
}

Optional_Header::Optional_Header() {
    magic_ = 0;
    major_linker_version_ = 0;
    minor_linker_version_ = 0;
    size_of_code_ = 0;
    size_of_init_data_ = 0;
    size_of_uninit_data_ = 0;
    addr_of_entry_point_ = 0;
    base_of_code_ = 0;
    have_base_of_data_case_index_ = -1;
    base_of_data_ = 0;
    is_pe32_case_index_ = -1;
    image_base_64_ = 0;
    image_base_32_ = 0;
    section_alignment_ = 0;
    file_alignment_ = 0;
    os_version_major_ = 0;
    os_version_minor_ = 0;
    major_image_version_ = 0;
    minor_image_version_ = 0;
    major_subsys_version_ = 0;
    minor_subsys_version_ = 0;
    win32_version_ = 0;
    size_of_image_ = 0;
    size_of_headers_ = 0;
    checksum_ = 0;
    subsystem_ = 0;
    dll_characteristics_ = 0;
    mem_case_index_ = -1;
    i32_ = nullptr;
    i64_ = nullptr;
    loader_flags_ = 0;
    number_of_rva_and_sizes_ = 0;
    rvas_ = nullptr;
    pe_format_ = 0;
    image_base_ = 0;
    proc_ = false;
}

Optional_Header::~Optional_Header() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_base_of_data_case_index() ) {
        case ((uint8)1):
            // Clean up "base_of_data"
            {
            }
            break;
        default:
            // Clean up "not_present"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( is_pe32_case_index() ) {
        case ((uint8)2):
            // Clean up "image_base_64"
            {
            }
            break;
        default:
            // Clean up "image_base_32"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( mem_case_index() ) {
        case ((uint8)1):
            // Clean up "i32"
            {
                delete i32_;
                i32_ = nullptr;
            }
            break;
        case ((uint8)2):
            // Clean up "i64"
            {
                delete i64_;
                i64_ = nullptr;
            }
            break;
        default:
            // Clean up "InvalidPEFile"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    delete rvas_;
    rvas_ = nullptr;
}

int Optional_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextPE* t_context, int t_byteorder) {
    // Checking out-of-bound for "Optional_Header:base_of_code"
    if ( (t_begin_of_data + 20) + (4) > t_end_of_data || (t_begin_of_data + 20) + (4) < (t_begin_of_data + 20) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Optional_Header:base_of_code",
        	(20) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "magic"
    magic_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));

    // Parse "major_linker_version"
    major_linker_version_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

    // Parse "minor_linker_version"
    minor_linker_version_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 3)));

    // Parse "size_of_code"
    size_of_code_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 4))));

    // Parse "size_of_init_data"
    size_of_init_data_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 8))));

    // Parse "size_of_uninit_data"
    size_of_uninit_data_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 12))));

    // Parse "addr_of_entry_point"
    addr_of_entry_point_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 16))));

    // Parse "base_of_code"
    base_of_code_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 20))));

    // Parse "have_base_of_data"
    pe_format_ = t_context->connection()->set_pe32_format(magic());
    int t_have_base_of_data__size;
    have_base_of_data_case_index_ = pe_format();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( have_base_of_data_case_index() ) {
        case ((uint8)1):
            // Parse "base_of_data"
            {
                // Checking out-of-bound for "Optional_Header:base_of_data"
                if ( (t_begin_of_data + 24) + (4) > t_end_of_data || (t_begin_of_data + 24) + (4) < (t_begin_of_data + 24) ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Optional_Header:base_of_data",
                    	(24) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                base_of_data_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_begin_of_data + 24))));
                t_have_base_of_data__size = 4;
            }
            break;
        default:
            // Parse "not_present"
            {
                t_have_base_of_data__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_have_base_of_data = (t_begin_of_data + 24) + (t_have_base_of_data__size);
    BINPAC_ASSERT(t_dataptr_after_have_base_of_data <= t_end_of_data);
    // Parse "is_pe32"
    int t_is_pe32__size;
    is_pe32_case_index_ = pe_format();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( is_pe32_case_index() ) {
        case ((uint8)2):
            // Parse "image_base_64"
            {
                // Checking out-of-bound for "Optional_Header:image_base_64"
                if ( t_dataptr_after_have_base_of_data + (8) > t_end_of_data || t_dataptr_after_have_base_of_data + (8) < t_dataptr_after_have_base_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Optional_Header:image_base_64",
                    	((t_dataptr_after_have_base_of_data - t_begin_of_data)) + (8), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                image_base_64_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_dataptr_after_have_base_of_data)));
                t_is_pe32__size = 8;
            }
            break;
        default:
            // Parse "image_base_32"
            {
                // Checking out-of-bound for "Optional_Header:image_base_32"
                if ( t_dataptr_after_have_base_of_data + (4) > t_end_of_data || t_dataptr_after_have_base_of_data + (4) < t_dataptr_after_have_base_of_data ) {
                    // Handle out-of-bound condition
                    throw binpac::ExceptionOutOfBound("Optional_Header:image_base_32",
                    	((t_dataptr_after_have_base_of_data - t_begin_of_data)) + (4), 
                    	(t_end_of_data) - (t_begin_of_data));
                }
                image_base_32_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_have_base_of_data)));
                t_is_pe32__size = 4;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_is_pe32 = t_dataptr_after_have_base_of_data + (t_is_pe32__size);
    BINPAC_ASSERT(t_dataptr_after_is_pe32 <= t_end_of_data);
    // Checking out-of-bound for "Optional_Header:dll_characteristics"
    if ( (t_dataptr_after_is_pe32 + 38) + (2) > t_end_of_data || (t_dataptr_after_is_pe32 + 38) + (2) < (t_dataptr_after_is_pe32 + 38) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Optional_Header:dll_characteristics",
        	(((t_dataptr_after_is_pe32 + 38) - t_begin_of_data)) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "section_alignment"
    section_alignment_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_is_pe32)));

    // Parse "file_alignment"
    file_alignment_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_is_pe32 + 4))));

    // Parse "os_version_major"
    os_version_major_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 8))));

    // Parse "os_version_minor"
    os_version_minor_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 10))));

    // Parse "major_image_version"
    major_image_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 12))));

    // Parse "minor_image_version"
    minor_image_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 14))));

    // Parse "major_subsys_version"
    major_subsys_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 16))));

    // Parse "minor_subsys_version"
    minor_subsys_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 18))));

    // Parse "win32_version"
    win32_version_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_is_pe32 + 20))));

    // Parse "size_of_image"
    size_of_image_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_is_pe32 + 24))));

    // Parse "size_of_headers"
    size_of_headers_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_is_pe32 + 28))));

    // Parse "checksum"
    checksum_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_is_pe32 + 32))));

    // Parse "subsystem"
    subsystem_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 36))));

    // Parse "dll_characteristics"
    dll_characteristics_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_is_pe32 + 38))));

    // Parse "mem"
    int t_mem__size;
    mem_case_index_ = pe_format();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( mem_case_index() ) {
        case ((uint8)1):
            // Parse "i32"
            {
                i32_ = new Mem_Info32();
                i32_->Parse((t_dataptr_after_is_pe32 + 40), t_end_of_data);
                t_mem__size = 16;
            }
            break;
        case ((uint8)2):
            // Parse "i64"
            {
                i64_ = new Mem_Info64();
                i64_->Parse((t_dataptr_after_is_pe32 + 40), t_end_of_data);
                t_mem__size = 32;
            }
            break;
        default:
            // Parse "InvalidPEFile"
            {
                t_mem__size = 0;
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    // Evaluate 'let' and 'withinput' fields

    const_byteptr const t_dataptr_after_mem = (t_dataptr_after_is_pe32 + 40) + (t_mem__size);
    BINPAC_ASSERT(t_dataptr_after_mem <= t_end_of_data);
    // Checking out-of-bound for "Optional_Header:number_of_rva_and_sizes"
    if ( (t_dataptr_after_mem + 4) + (4) > t_end_of_data || (t_dataptr_after_mem + 4) + (4) < (t_dataptr_after_mem + 4) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Optional_Header:number_of_rva_and_sizes",
        	(((t_dataptr_after_mem + 4) - t_begin_of_data)) + (4), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "loader_flags"
    loader_flags_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_mem)));

    // Parse "number_of_rva_and_sizes"
    number_of_rva_and_sizes_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_mem + 4))));

    // Parse "rvas"
    rvas_ = new RVAS(number_of_rva_and_sizes());
    int t_rvas__size;
    t_rvas__size = rvas_->Parse((t_dataptr_after_mem + 8), t_end_of_data, t_byteorder);

    int t_Optional_Header__size;
    const_byteptr const t_dataptr_after_rvas = (t_dataptr_after_mem + 8) + (t_rvas__size);
    BINPAC_ASSERT(t_dataptr_after_rvas <= t_end_of_data);
    t_Optional_Header__size = t_dataptr_after_rvas - t_begin_of_data;
    // Evaluate 'let' and 'withinput' fields
    image_base_ = pe_format() == PE32_PLUS ? image_base_64() : image_base_32();
    proc_ = t_context->flow()->proc_optional_header(this);
    BINPAC_ASSERT(t_begin_of_data + (t_Optional_Header__size) <= t_end_of_data);
    return t_Optional_Header__size;
}

Section_Headers::Section_Headers(uint16 num) {
    sections_ = nullptr;
    sections__elem_ = nullptr;
    num_ = num;
    length_ = 0;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

Section_Headers::~Section_Headers() {
    delete sections__elem_;
    sections__elem_ = nullptr;
    if ( sections() ) {
        for ( auto* sections__elem_ : *sections() ) {
            delete sections__elem_;
            sections__elem_ = nullptr;
        }
    }
    delete sections_;
}

bool Section_Headers::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(0, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            length_ = num() * 40;
            t_flow_buffer->GrowFrame(length());
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {
                // Parse "sections"
                int t_sections__arraylength;
                t_sections__arraylength = num();
                if ( t_sections__arraylength < 0 ) {
                    throw binpac::ExceptionOutOfBound("Section_Headers:sections",
                      t_sections__arraylength, (t_end_of_data) - (t_begin_of_data));
                }
                // Check array element quantity: Section_Headers:sections
                if ( t_sections__arraylength > ((t_end_of_data - t_begin_of_data) / 1) )
                    throw binpac::ExceptionOutOfBound("Section_Headers:sections",
                      t_sections__arraylength, (t_end_of_data) - (t_begin_of_data));
                sections__elem_ = nullptr;
                int t_sections__elem__it;
                t_sections__elem__it = 0;
                int t_sections__size;
                sections_ = new vector<Section_Header*>;
                sections_->reserve(t_sections__arraylength);
                const_byteptr t_sections__elem__dataptr = t_begin_of_data;
                for (; t_sections__elem__it < t_sections__arraylength; ++t_sections__elem__it) {
                    sections__elem_ = new Section_Header();
                    int t_sections__elem__size;
                    t_sections__elem__size = sections__elem_->Parse(t_sections__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    sections_->push_back(sections__elem_);
                    t_sections__elem__dataptr += t_sections__elem__size;
                    BINPAC_ASSERT(t_sections__elem__dataptr <= t_end_of_data);
                    sections__elem_ = nullptr;
                }
            end_of_sections: ;
                t_sections__size = t_sections__elem__dataptr - (t_begin_of_data);
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

Section_Header::Section_Header() {
    virtual_size_ = 0;
    virtual_addr_ = 0;
    size_of_raw_data_ = 0;
    ptr_to_raw_data_ = 0;
    non_used_ptr_to_relocs_ = 0;
    non_used_ptr_to_line_nums_ = 0;
    non_used_num_of_relocs_ = 0;
    non_used_num_of_line_nums_ = 0;
    characteristics_ = 0;
    add_section_ = false;
    proc_ = false;
}

Section_Header::~Section_Header() {
    name_.free();
}

int Section_Header::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextPE* t_context, int t_byteorder) {
    // Checking out-of-bound for "Section_Header"
    if ( t_begin_of_data + (40) > t_end_of_data || t_begin_of_data + (40) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("Section_Header",
        	(0) + (40), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + 40;
        // Parse "name"
        // Checking out-of-bound for "Section_Header:name"
        if ( t_begin_of_data + (8) > t_end_of_data || t_begin_of_data + (8) < t_begin_of_data ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Section_Header:name",
            	(0) + (8), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = t_begin_of_data + 8;
            int t_name_string_length;
            t_name_string_length = 8;
            int t_name__size;
            t_name__size = t_name_string_length;
            name_.init(t_begin_of_data, t_name_string_length);
        }

        const_byteptr const t_dataptr_after_name = t_begin_of_data + (8);
        BINPAC_ASSERT(t_dataptr_after_name <= t_end_of_data);
        // Checking out-of-bound for "Section_Header:characteristics"
        if ( (t_dataptr_after_name + 28) + (4) > t_end_of_data || (t_dataptr_after_name + 28) + (4) < (t_dataptr_after_name + 28) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("Section_Header:characteristics",
            	(((t_dataptr_after_name + 28) - t_begin_of_data)) + (4), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "virtual_size"
        virtual_size_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>(t_dataptr_after_name)));

        // Parse "virtual_addr"
        virtual_addr_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_name + 4))));

        // Parse "size_of_raw_data"
        size_of_raw_data_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_name + 8))));

        // Parse "ptr_to_raw_data"
        ptr_to_raw_data_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_name + 12))));

        // Parse "non_used_ptr_to_relocs"
        non_used_ptr_to_relocs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_name + 16))));

        // Parse "non_used_ptr_to_line_nums"
        non_used_ptr_to_line_nums_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_name + 20))));

        // Parse "non_used_num_of_relocs"
        non_used_num_of_relocs_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_name + 24))));

        // Parse "non_used_num_of_line_nums"
        non_used_num_of_line_nums_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_name + 26))));

        // Parse "characteristics"
        characteristics_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint32 const*>((t_dataptr_after_name + 28))));

        int t_Section_Header__size;
        t_Section_Header__size = (t_dataptr_after_name + 32) - t_begin_of_data;
        // Evaluate 'let' and 'withinput' fields
        add_section_ = t_context->connection()->add_section(this);
        proc_ = t_context->flow()->proc_section_header(this);
    }
    BINPAC_ASSERT(t_begin_of_data + (40) <= t_end_of_data);
    return 40;
}

PE_File::PE_File() {
    val_case_index_ = -1;
    PE_ = nullptr;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

PE_File::~PE_File() {
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case false:
            // Clean up "PE"
            {
                delete PE_;
                PE_ = nullptr;
            }
            break;
        case true:
            // Clean up "overlay"
            {
            }
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
}

bool PE_File::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    val_case_index_ = t_context->connection()->is_done();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( val_case_index() ) {
        case false:
            // Parse "PE"
            {
                if ( ! PE_ ) {
                    PE_ = new Portable_Executable();
                }
                bool t_PE_parsing_complete;
                t_PE_parsing_complete = false;
                t_PE_parsing_complete = PE_->ParseBuffer(t_flow_buffer, t_context);
                if ( t_PE_parsing_complete ) {
                }
                t_val_parsing_complete = t_PE_parsing_complete;
            }
            break;
        case true:
            // Parse "overlay"
            {
                if ( buffering_state_ == 0 ) {
                    t_flow_buffer->NewFrame(0, false);
                    buffering_state_ = 1;
                }
                bool t_overlay_parsing_complete;
                t_overlay_parsing_complete = false;
                while ( ! t_overlay_parsing_complete && t_flow_buffer->ready() ) {
                    const_byteptr t_begin_of_data = t_flow_buffer->begin();
                    const_byteptr t_end_of_data = t_flow_buffer->end();
                    // NOLINTBEGIN(bugprone-branch-clone)
                    switch ( buffering_state_ ) {
                        case 0:
                            if ( buffering_state_ == 0 ) {
                                t_flow_buffer->NewFrame(0, false);
                                buffering_state_ = 1;
                            }
                            buffering_state_ = 1;
                            break;
                        case 1:
                        {
                            buffering_state_ = 2;
                            t_flow_buffer->GrowFrame(1);
                        }
                        break;
                        case 2:
                            BINPAC_ASSERT(t_flow_buffer->ready());
                            if ( t_flow_buffer->ready() ) {
                                int t_overlay_string_length;
                                t_overlay_string_length = 1;
                                overlay_.init(t_begin_of_data, t_overlay_string_length);
                                t_overlay_parsing_complete = true;
                                if ( t_overlay_parsing_complete ) {
                                    // Evaluate 'let' and 'withinput' fields
                                }
                                BINPAC_ASSERT(t_overlay_parsing_complete);
                                buffering_state_ = 0;
                            }
                            break;
                        default:
                            BINPAC_ASSERT(buffering_state_ <= 2);
                            break;
                    }
                    // NOLINTEND(bugprone-branch-clone)
                }
                t_val_parsing_complete = t_overlay_parsing_complete;
            }
            break;
        default:
            throw binpac::ExceptionInvalidCaseIndex("PE_File", (int64)val_case_index());
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    return t_val_parsing_complete;
}

Portable_Executable::Portable_Executable() {
    headers_ = nullptr;
    pad_ = nullptr;
    byteorder_ = littleendian;
    unparsed_hdr_len_ = 0;
    data_post_hdrs_ = 0;
    restofdata_ = 0;
    proc_ = false;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

Portable_Executable::~Portable_Executable() {
    delete headers_;
    headers_ = nullptr;
    delete pad_;
    pad_ = nullptr;
}

bool Portable_Executable::ParseBuffer(flow_buffer_t t_flow_buffer, ContextPE* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "headers"
        if ( ! headers_ ) {
            headers_ = new Headers();
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_headers_parsing_complete;
        t_headers_parsing_complete = false;
        t_headers_parsing_complete = headers_->ParseBuffer(t_flow_buffer, t_context, byteorder());
        if ( t_headers_parsing_complete ) {
        }
        if ( ! (t_headers_parsing_complete) )
            goto need_more_data;
        }

        // Parse "pad"
        if ( ! pad_ ) {
            unparsed_hdr_len_ = headers()->pe_header()->size_of_headers() - headers()->length();
            data_post_hdrs_ = t_context->connection()->get_max_file_location() - headers()->pe_header()->size_of_headers() + unparsed_hdr_len();
            restofdata_ = headers()->pe_header()->is_exe() ? data_post_hdrs() : 0;
            pad_ = new Padding(restofdata());
        }
        parsing_state_ = 2;
        /* fall through */
    case 2:
    {
        bool t_pad_parsing_complete;
        t_pad_parsing_complete = false;
        t_pad_parsing_complete = pad_->ParseBuffer(t_flow_buffer);
        if ( t_pad_parsing_complete ) {
        }
        if ( ! (t_pad_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->mark_done();
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

File::File(MockConnection* connection) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

File::~File() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void File::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new PE_File();
                context_ = new ContextPE(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void File::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void File::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
bool File::proc_dos_header(DOS_Header* h) {

		if ( pe_dos_header )
			{
			auto dh = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::PE::DOSHeader);
			dh->Assign(0, zeek::make_intrusive<zeek::StringVal>(h->signature().length(), reinterpret_cast<const char*>(h->signature().data())));
			dh->Assign(1, h->UsedBytesInTheLastPage());
			dh->Assign(2, h->FileSizeInPages());
			dh->Assign(3, h->NumberOfRelocationItems());
			dh->Assign(4, h->HeaderSizeInParagraphs());
			dh->Assign(5, h->MinimumExtraParagraphs());
			dh->Assign(6, h->MaximumExtraParagraphs());
			dh->Assign(7, h->InitialRelativeSS());
			dh->Assign(8, h->InitialSP());
			dh->Assign(9, h->Checksum());
			dh->Assign(10, h->InitialIP());
			dh->Assign(11, h->InitialRelativeCS());
			dh->Assign(12, h->AddressOfRelocationTable());
			dh->Assign(13, h->OverlayNumber());
			dh->Assign(14, h->OEMid());
			dh->Assign(15, h->OEMinfo());
			dh->Assign(16, h->AddressOfNewExeHeader());

			zeek::event_mgr.Enqueue(pe_dos_header,
			    connection()->zeek_analyzer()->GetFile()->ToVal(),
			    std::move(dh));
			}
		return true;
		
}

bool File::proc_dos_code(bytestring const& code) {

		if ( pe_dos_code )
			zeek::event_mgr.Enqueue(pe_dos_code,
			    connection()->zeek_analyzer()->GetFile()->ToVal(),
			    zeek::make_intrusive<zeek::StringVal>(code.length(), reinterpret_cast<const char*>(code.data()))
			    );
		return true;
		
}

bool File::proc_nt_headers(NT_Headers* h) {

		if ( h->PESignature() != 17744 ) // Number is uint32 version of "PE\0\0"
			{
			return false;
			// FileViolation("PE Header signature is incorrect.");
			}
		return true;
		
}

bool File::proc_file_header(File_Header* h) {

		if ( pe_file_header )
			{
			auto fh = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::PE::FileHeader);
			fh->Assign(0, h->Machine());
			fh->AssignTime(1, double(h->TimeDateStamp()));
			fh->Assign(2, h->PointerToSymbolTable());
			fh->Assign(3, h->NumberOfSymbols());
			fh->Assign(4, h->SizeOfOptionalHeader());
			fh->Assign(5, characteristics_to_zeek(h->Characteristics(), 16));

			zeek::event_mgr.Enqueue(pe_file_header,
			    connection()->zeek_analyzer()->GetFile()->ToVal(),
			    std::move(fh));
			}

		return true;
		
}

bool File::proc_optional_header(Optional_Header* h) {

		if ( h->magic() != 0x10b &&  // normal pe32 executable
		     h->magic() != 0x107 &&  // rom image
		     h->magic() != 0x20b )   // pe32+ executable
			{
			// FileViolation("PE Optional Header magic is invalid.");
			return false;
			}

		if ( pe_optional_header )
			{
			auto oh = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::PE::OptionalHeader);

			oh->Assign(0, h->magic());
			oh->Assign(1, h->major_linker_version());
			oh->Assign(2, h->minor_linker_version());
			oh->Assign(3, h->size_of_code());
			oh->Assign(4, h->size_of_init_data());
			oh->Assign(5, h->size_of_uninit_data());
			oh->Assign(6, h->addr_of_entry_point());
			oh->Assign(7, h->base_of_code());

			if ( h->pe_format() != PE32_PLUS )
				oh->Assign(8, h->base_of_data());

			oh->Assign(9, h->image_base());
			oh->Assign(10, h->section_alignment());
			oh->Assign(11, h->file_alignment());
			oh->Assign(12, h->os_version_major());
			oh->Assign(13, h->os_version_minor());
			oh->Assign(14, h->major_image_version());
			oh->Assign(15, h->minor_image_version());
			oh->Assign(16, h->major_subsys_version());
			oh->Assign(17, h->minor_subsys_version());
			oh->Assign(18, h->size_of_image());
			oh->Assign(19, h->size_of_headers());
			oh->Assign(20, h->checksum());
			oh->Assign(21, h->subsystem());
			oh->Assign(22, characteristics_to_zeek(h->dll_characteristics(), 16));

			oh->Assign(23, process_rvas(h->rvas()));

			zeek::event_mgr.Enqueue(pe_optional_header,
			    connection()->zeek_analyzer()->GetFile()->ToVal(),
			    std::move(oh));
			}
		return true;
		
}

bool File::proc_section_header(Section_Header* h) {

		if ( pe_section_header )
			{
			auto section_header = zeek::make_intrusive<zeek::RecordVal>(zeek::BifType::Record::PE::SectionHeader);

			// Strip null characters from the end of the section name.
			u_char* first_null = reinterpret_cast<u_char*>(memchr(h->name().data(), 0, h->name().length()));
			uint16 name_len;
			if ( first_null == nullptr )
				name_len = h->name().length();
			else
				name_len = first_null - h->name().data();
			section_header->Assign(0, zeek::make_intrusive<zeek::StringVal>(name_len, reinterpret_cast<const char*>(h->name().data())));

			section_header->Assign(1, h->virtual_size());
			section_header->Assign(2, h->virtual_addr());
			section_header->Assign(3, h->size_of_raw_data());
			section_header->Assign(4, h->ptr_to_raw_data());
			section_header->Assign(5, h->non_used_ptr_to_relocs());
			section_header->Assign(6, h->non_used_ptr_to_line_nums());
			section_header->Assign(7, h->non_used_num_of_relocs());
			section_header->Assign(8, h->non_used_num_of_line_nums());
			section_header->Assign(9, characteristics_to_zeek(h->characteristics(), 32));

			zeek::event_mgr.Enqueue(pe_section_header,
			    connection()->zeek_analyzer()->GetFile()->ToVal(),
			    std::move(section_header)
			    );
			}
		return true;
		
}


zeek::VectorValPtr process_rvas(const RVAS* rva_table)
	{
	auto rvas = zeek::make_intrusive<zeek::VectorVal>(zeek::id::index_vec);

	for ( size_t i=0; i < rva_table->rvas()->size(); ++i )
		rvas->Assign(i, zeek::val_mgr->Count((*rva_table->rvas())[i]->size()));

	return rvas;
	}

zeek::TableValPtr characteristics_to_zeek(uint32_t c, uint8_t len)
	{
	uint64 mask = (len==16) ? 0xFFFF : 0xFFFFFFFF;
	auto char_set = zeek::make_intrusive<zeek::TableVal>(zeek::id::count_set);

	for ( uint16 i=0; i < len; ++i )
		{
		if ( ((c >> i) & 0x1) == 1 )
			{
			auto ch = zeek::val_mgr->Count((1<<i)&mask);
			char_set->Assign(std::move(ch), nullptr);
			}
		}

	return char_set;
	}

} // namespace PE
}  // namespace binpac
