// This file is automatically generated from /build/zeek/src/zeek/src/file_analysis/analyzer/x509/x509-extension.pac.


#ifdef __clang__
#pragma clang diagnostic ignored "-Wparentheses-equality"
#endif

#include "/build/zeek/src/zeek/build/src/file_analysis/analyzer/x509/x509-extension_pac.h"

namespace binpac {






namespace X509Extension {
ContextX509Extension::ContextX509Extension(MockConnection* connection, SignedCertTimestampExt* flow, FlowBuffer* flow_buffer) {
    connection_ = connection;
    flow_ = flow;
    flow_buffer_ = flow_buffer;
}

ContextX509Extension::~ContextX509Extension() {
}

MockConnection::MockConnection(ZeekFileAnalyzer* zeek_analyzer) {
    upflow_ = new SignedCertTimestampExt(this);
    downflow_ = new SignedCertTimestampExt(this);
    zeek_analyzer_ = zeek_analyzer;
}

MockConnection::~MockConnection() {
    delete upflow_;
    upflow_ = nullptr;
    delete downflow_;
    downflow_ = nullptr;
}

void MockConnection::NewData(bool is_orig, const_byteptr begin, const_byteptr end) {
    if ( is_orig )
        upflow_->NewData(begin, end);
    else
        downflow_->NewData(begin, end);
}

void MockConnection::NewGap(bool is_orig, int gap_length) {
    if ( is_orig )
        upflow_->NewGap(gap_length);
    else
        downflow_->NewGap(gap_length);
}

void MockConnection::FlowEOF(bool is_orig) {
    if ( is_orig )
        upflow_->FlowEOF();
    else
        downflow_->FlowEOF();
}

bool MockConnection::proc_signedcertificatetimestamp(HandshakeRecord* rec, uint8 version, const_bytestring const& logid, uint64 timestamp, SignatureAndHashAlgorithm* digitally_signed_algorithms, const_bytestring const& digitally_signed_signature) {

		if ( ! x509_ocsp_ext_signed_certificate_timestamp )
			return true;

		zeek::event_mgr.Enqueue(x509_ocsp_ext_signed_certificate_timestamp,
			zeek_analyzer()->GetFile()->ToVal(),
			zeek::val_mgr->Count(version),
			zeek::make_intrusive<zeek::StringVal>(logid.length(), reinterpret_cast<const char*>(logid.begin())),
			zeek::val_mgr->Count(timestamp),
			zeek::val_mgr->Count(digitally_signed_algorithms->HashAlgorithm()),
			zeek::val_mgr->Count(digitally_signed_algorithms->SignatureAlgorithm()),
			zeek::make_intrusive<zeek::StringVal>(digitally_signed_signature.length(), reinterpret_cast<const char*>(digitally_signed_signature.begin()))
			);

		return true;
		
}

SignatureAndHashAlgorithm::SignatureAndHashAlgorithm() {
    HashAlgorithm_ = 0;
    SignatureAlgorithm_ = 0;
}

SignatureAndHashAlgorithm::~SignatureAndHashAlgorithm() {
}

int SignatureAndHashAlgorithm::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data) {
    // Checking out-of-bound for "SignatureAndHashAlgorithm"
    if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignatureAndHashAlgorithm",
        	(0) + (2), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "HashAlgorithm"
    HashAlgorithm_ = *(reinterpret_cast<uint8 const*>(t_begin_of_data));

    // Parse "SignatureAlgorithm"
    SignatureAlgorithm_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 1)));

    // Evaluate 'let' and 'withinput' fields
    BINPAC_ASSERT(t_begin_of_data + (2) <= t_end_of_data);
    return 2;
}

SignedCertificateTimestampList::SignedCertificateTimestampList(HandshakeRecord* rec) {
    length_ = 0;
    SCTs_ = nullptr;
    SCTs__elem_ = nullptr;
    rec_ = rec;
    buffering_state_ = 0;
    buffering_state_ = 0;
}

SignedCertificateTimestampList::~SignedCertificateTimestampList() {
    delete SCTs__elem_;
    SCTs__elem_ = nullptr;
    if ( SCTs() ) {
        for ( auto* SCTs__elem_ : *SCTs() ) {
            delete SCTs__elem_;
            SCTs__elem_ = nullptr;
        }
    }
    delete SCTs_;
}

bool SignedCertificateTimestampList::ParseBuffer(flow_buffer_t t_flow_buffer, ContextX509Extension* t_context, int t_byteorder) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    const_byteptr t_begin_of_data = t_flow_buffer->begin();
    const_byteptr t_end_of_data = t_flow_buffer->end();
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( buffering_state_ ) {
        case 0:
            if ( buffering_state_ == 0 ) {
                t_flow_buffer->NewFrame(2, false);
                buffering_state_ = 1;
            }
            buffering_state_ = 1;
            break;
        case 1:
        {
            buffering_state_ = 2;
            // Parse "length"
            // Checking out-of-bound for "SignedCertificateTimestampList:length"
            if ( t_begin_of_data + (2) > t_end_of_data || t_begin_of_data + (2) < t_begin_of_data ) {
                // Handle out-of-bound condition
                throw binpac::ExceptionOutOfBound("SignedCertificateTimestampList:length",
                	(0) + (2), 
                	(t_end_of_data) - (t_begin_of_data));
            }
            length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
            t_flow_buffer->GrowFrame(length() + 2);
        }
        break;
        case 2:
            BINPAC_ASSERT(t_flow_buffer->ready());
            if ( t_flow_buffer->ready() ) {

                // Parse "SCTs"
                int t_SCTs__arraylength;
                t_SCTs__arraylength = 0;
                SCTs__elem_ = nullptr;
                int t_SCTs__elem__it;
                t_SCTs__elem__it = 0;
                int t_SCTs__size;
                SCTs_ = new vector<SignedCertificateTimestamp*>;
                const_byteptr t_SCTs__elem__dataptr = (t_begin_of_data + 2);
                for (; /* forever */; ++t_SCTs__elem__it) {
                    // Check &until(SCTs__elem__dataptr >= end_of_data)
                    if ( t_SCTs__elem__dataptr >= t_end_of_data ) {
                        SCTs__elem_ = nullptr;
                        goto end_of_SCTs;
                    }
                    SCTs__elem_ = new SignedCertificateTimestamp(rec());
                    int t_SCTs__elem__size;
                    t_SCTs__elem__size = SCTs__elem_->Parse(t_SCTs__elem__dataptr, t_end_of_data, t_context, t_byteorder);
                    SCTs_->push_back(SCTs__elem_);
                    t_SCTs__elem__dataptr += t_SCTs__elem__size;
                    BINPAC_ASSERT(t_SCTs__elem__dataptr <= t_end_of_data);
                    SCTs__elem_ = nullptr;
                }
            end_of_SCTs: ;
                t_SCTs__size = t_SCTs__elem__dataptr - ((t_begin_of_data + 2));
                // Evaluate 'let' and 'withinput' fields

                t_val_parsing_complete = true;
                if ( t_val_parsing_complete ) {
                    // Evaluate 'let' and 'withinput' fields
                }
                BINPAC_ASSERT(t_val_parsing_complete);
                buffering_state_ = 0;
            }
            break;
        default:
            BINPAC_ASSERT(buffering_state_ <= 2);
            break;
    }
    // NOLINTEND(bugprone-branch-clone)
    return t_val_parsing_complete;
}

SignedCertificateTimestamp::SignedCertificateTimestamp(HandshakeRecord* rec) {
    length_ = 0;
    version_ = 0;
    timestamp_ = 0;
    extensions_length_ = 0;
    digitally_signed_algorithms_ = nullptr;
    digitally_signed_signature_length_ = 0;
    rec_ = rec;
    proc_ = false;
}

SignedCertificateTimestamp::~SignedCertificateTimestamp() {
    logid_.free();
    extensions_.free();
    delete digitally_signed_algorithms_;
    digitally_signed_algorithms_ = nullptr;
    digitally_signed_signature_.free();
}

int SignedCertificateTimestamp::Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextX509Extension* t_context, int t_byteorder) {
    int t_SignedCertificateTimestamp__size;
    // Checking out-of-bound for "SignedCertificateTimestamp:version"
    if ( (t_begin_of_data + 2) + (1) > t_end_of_data || (t_begin_of_data + 2) + (1) < (t_begin_of_data + 2) ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:version",
        	(2) + (1), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    // Parse "length"
    length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>(t_begin_of_data)));
    t_SignedCertificateTimestamp__size = length() + 2;
    // Checking out-of-bound for "SignedCertificateTimestamp"
    if ( t_begin_of_data + (t_SignedCertificateTimestamp__size) > t_end_of_data || t_begin_of_data + (t_SignedCertificateTimestamp__size) < t_begin_of_data ) {
        // Handle out-of-bound condition
        throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp",
        	(0) + (t_SignedCertificateTimestamp__size), 
        	(t_end_of_data) - (t_begin_of_data));
    }
    {
        // Setting t_end_of_data with &length
        const_byteptr t_end_of_data = t_begin_of_data + t_SignedCertificateTimestamp__size;

        // Parse "version"
        version_ = *(reinterpret_cast<uint8 const*>((t_begin_of_data + 2)));

        // Parse "logid"
        // Checking out-of-bound for "SignedCertificateTimestamp:logid"
        if ( (t_begin_of_data + 3) + (32) > t_end_of_data || (t_begin_of_data + 3) + (32) < (t_begin_of_data + 3) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:logid",
            	(3) + (32), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_begin_of_data + 3) + 32;
            int t_logid_string_length;
            t_logid_string_length = 32;
            int t_logid__size;
            t_logid__size = t_logid_string_length;
            logid_.init((t_begin_of_data + 3), t_logid_string_length);
        }

        const_byteptr const t_dataptr_after_logid = (t_begin_of_data + 3) + (32);
        BINPAC_ASSERT(t_dataptr_after_logid <= t_end_of_data);
        // Checking out-of-bound for "SignedCertificateTimestamp:extensions_length"
        if ( (t_dataptr_after_logid + 8) + (2) > t_end_of_data || (t_dataptr_after_logid + 8) + (2) < (t_dataptr_after_logid + 8) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:extensions_length",
            	(((t_dataptr_after_logid + 8) - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "timestamp"
        timestamp_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint64 const*>(t_dataptr_after_logid)));

        // Parse "extensions_length"
        extensions_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_logid + 8))));

        // Parse "extensions"
        int t_extensions__size;
        t_extensions__size = extensions_length();
        // Checking out-of-bound for "SignedCertificateTimestamp:extensions"
        if ( (t_dataptr_after_logid + 10) + (t_extensions__size) > t_end_of_data || (t_dataptr_after_logid + 10) + (t_extensions__size) < (t_dataptr_after_logid + 10) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:extensions",
            	(((t_dataptr_after_logid + 10) - t_begin_of_data)) + (t_extensions__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_dataptr_after_logid + 10) + t_extensions__size;
            int t_extensions_string_length;
            t_extensions_string_length = extensions_length();
            // check for negative sizes
            if ( t_extensions_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/file_analysis/analyzer/x509/../../../analyzer/protocol/ssl/tls-handshake-signed_certificate_timestamp.pac:23", t_extensions_string_length);
            extensions_.init((t_dataptr_after_logid + 10), t_extensions_string_length);
        }

        const_byteptr const t_dataptr_after_extensions = (t_dataptr_after_logid + 10) + (t_extensions__size);
        BINPAC_ASSERT(t_dataptr_after_extensions <= t_end_of_data);
        // Checking out-of-bound for "SignedCertificateTimestamp:digitally_signed_signature_length"
        if ( (t_dataptr_after_extensions + 2) + (2) > t_end_of_data || (t_dataptr_after_extensions + 2) + (2) < (t_dataptr_after_extensions + 2) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:digitally_signed_signature_length",
            	(((t_dataptr_after_extensions + 2) - t_begin_of_data)) + (2), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        // Parse "digitally_signed_algorithms"
        digitally_signed_algorithms_ = new SignatureAndHashAlgorithm();
        digitally_signed_algorithms_->Parse(t_dataptr_after_extensions, t_end_of_data);

        // Parse "digitally_signed_signature_length"
        digitally_signed_signature_length_ = FixByteOrder(t_byteorder, *(reinterpret_cast<uint16 const*>((t_dataptr_after_extensions + 2))));

        // Parse "digitally_signed_signature"
        int t_digitally_signed_signature__size;
        t_digitally_signed_signature__size = digitally_signed_signature_length();
        // Checking out-of-bound for "SignedCertificateTimestamp:digitally_signed_signature"
        if ( (t_dataptr_after_extensions + 4) + (t_digitally_signed_signature__size) > t_end_of_data || (t_dataptr_after_extensions + 4) + (t_digitally_signed_signature__size) < (t_dataptr_after_extensions + 4) ) {
            // Handle out-of-bound condition
            throw binpac::ExceptionOutOfBound("SignedCertificateTimestamp:digitally_signed_signature",
            	(((t_dataptr_after_extensions + 4) - t_begin_of_data)) + (t_digitally_signed_signature__size), 
            	(t_end_of_data) - (t_begin_of_data));
        }
        {
            // Setting t_end_of_data with &length
            const_byteptr t_end_of_data = (t_dataptr_after_extensions + 4) + t_digitally_signed_signature__size;
            int t_digitally_signed_signature_string_length;
            t_digitally_signed_signature_string_length = digitally_signed_signature_length();
            // check for negative sizes
            if ( t_digitally_signed_signature_string_length < 0 )
            throw binpac::ExceptionInvalidStringLength("/build/zeek/src/zeek/src/file_analysis/analyzer/x509/../../../analyzer/protocol/ssl/tls-handshake-signed_certificate_timestamp.pac:26", t_digitally_signed_signature_string_length);
            digitally_signed_signature_.init((t_dataptr_after_extensions + 4), t_digitally_signed_signature_string_length);
        }

        // Evaluate 'let' and 'withinput' fields
        proc_ = t_context->connection()->proc_signedcertificatetimestamp(rec(), version(), logid(), timestamp(), digitally_signed_algorithms(), digitally_signed_signature());
    }
    BINPAC_ASSERT(t_begin_of_data + (t_SignedCertificateTimestamp__size) <= t_end_of_data);
    return t_SignedCertificateTimestamp__size;
}

HandshakeRecord::HandshakeRecord() {
    signed_certificate_timestamp_list_ = nullptr;
    signed_certificate_timestamp_list__elem_ = nullptr;
    signed_certificate_timestamp_list__arraylength_ = 0;
    signed_certificate_timestamp_list__elem__it_ = 0;
    signed_certificate_timestamp_list__elem__it_ = -1;
    byteorder_ = bigendian;
    parsing_state_ = 0;
    parsing_state_ = 0;
}

HandshakeRecord::~HandshakeRecord() {
    delete signed_certificate_timestamp_list__elem_;
    signed_certificate_timestamp_list__elem_ = nullptr;
    if ( signed_certificate_timestamp_list_ ) {
        for ( auto* signed_certificate_timestamp_list__elem_ : *signed_certificate_timestamp_list_ ) {
            delete signed_certificate_timestamp_list__elem_;
            signed_certificate_timestamp_list__elem_ = nullptr;
        }
    }
    delete signed_certificate_timestamp_list_;
}

bool HandshakeRecord::ParseBuffer(flow_buffer_t t_flow_buffer, ContextX509Extension* t_context) {
    bool t_val_parsing_complete;
    t_val_parsing_complete = false;
    // NOLINTBEGIN(bugprone-branch-clone)
    switch ( parsing_state_ ) {
    case 0:
        // Parse "signed_certificate_timestamp_list"
        if ( ! signed_certificate_timestamp_list_ ) {
        }
        parsing_state_ = 1;
        /* fall through */
    case 1:
    {
        bool t_signed_certificate_timestamp_list_parsing_complete;
        t_signed_certificate_timestamp_list_parsing_complete = false;
        if ( signed_certificate_timestamp_list__elem__it_ < 0 ) {
            // Initialize only once
            signed_certificate_timestamp_list__elem__it_ = 0;
            signed_certificate_timestamp_list_ = new vector<SignedCertificateTimestampList*>;
        }
        for (; /* forever */; ++signed_certificate_timestamp_list__elem__it_) {
            if ( ! signed_certificate_timestamp_list__elem_ ) {
                signed_certificate_timestamp_list__elem_ = new SignedCertificateTimestampList(this);
            }
            bool t_signed_certificate_timestamp_list__elem_parsing_complete;
            t_signed_certificate_timestamp_list__elem_parsing_complete = false;
            while ( ! t_signed_certificate_timestamp_list__elem_parsing_complete && t_flow_buffer->ready() ) {
                const_byteptr t_begin_of_data = t_flow_buffer->begin();
                const_byteptr t_end_of_data = t_flow_buffer->end();
                t_signed_certificate_timestamp_list__elem_parsing_complete = signed_certificate_timestamp_list__elem_->ParseBuffer(t_flow_buffer, t_context, byteorder());
                if ( t_signed_certificate_timestamp_list__elem_parsing_complete ) {
                }
            }
            if ( ! t_signed_certificate_timestamp_list__elem_parsing_complete )
                goto need_more_data;
            delete signed_certificate_timestamp_list__elem_;
            signed_certificate_timestamp_list__elem_ = nullptr;
        }
    end_of_signed_certificate_timestamp_list: ;
        if ( t_signed_certificate_timestamp_list_parsing_complete ) {
            // Evaluate 'let' and 'withinput' fields
        }
        if ( ! (t_signed_certificate_timestamp_list_parsing_complete) )
            goto need_more_data;
        }


        t_val_parsing_complete = true;
    }
    // NOLINTEND(bugprone-branch-clone)
    if ( t_val_parsing_complete ) {
        // Evaluate 'let' and 'withinput' fields
    }
    BINPAC_ASSERT(t_val_parsing_complete);
    return t_val_parsing_complete;

need_more_data:
    BINPAC_ASSERT(!(t_val_parsing_complete));
    return false;
}

SignedCertTimestampExt::SignedCertTimestampExt(MockConnection* connection) {
    flow_buffer_ = nullptr;
    connection_ = connection;
    dataunit_ = nullptr;
    context_ = nullptr;
    flow_buffer_ = new FlowBuffer();
}

SignedCertTimestampExt::~SignedCertTimestampExt() {
    delete dataunit_;
    dataunit_ = nullptr;
    delete context_;
    context_ = nullptr;
    delete flow_buffer_;
    flow_buffer_ = nullptr;
}

void SignedCertTimestampExt::NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) {
    try {
        flow_buffer_->NewData(t_begin_of_data, t_end_of_data);
        while ( flow_buffer_->data_available() && 
            ( !flow_buffer_->have_pending_request() || flow_buffer_->ready() ) ) {
            if ( ! dataunit_ ) {
                BINPAC_ASSERT(!context_);
                dataunit_ = new HandshakeRecord();
                context_ = new ContextX509Extension(connection(), this, flow_buffer());
            }
            bool t_dataunit_parsing_complete;
            t_dataunit_parsing_complete = false;
            t_dataunit_parsing_complete = dataunit_->ParseBuffer(flow_buffer(), context_);
            if ( t_dataunit_parsing_complete ) {
            }
            if ( t_dataunit_parsing_complete ) {
                // Clean up the flow unit after parsing
                delete dataunit_;
                dataunit_ = nullptr;
                delete context_;
                context_ = nullptr;
            } else {
                // Resume upon next input segment
                BINPAC_ASSERT(!flow_buffer()->ready());
                break;
            }
        }
    } catch ( binpac::Exception const& e ) {
        delete dataunit_;
        dataunit_ = nullptr;
        delete context_;
        context_ = nullptr;
        flow_buffer_->DiscardData();
        throw e;
    }
}

void SignedCertTimestampExt::NewGap(int gap_length) {
    flow_buffer_->NewGap(gap_length);
}
void SignedCertTimestampExt::FlowEOF() {
    flow_buffer_->set_eof();
    NewData(nullptr, nullptr);
}
} // namespace X509Extension
}  // namespace binpac
