// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_ntlm_ntlm_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_ntlm_ntlm_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/Manager.h"
#include "zeek/analyzer/Analyzer.h"

#include "zeek/analyzer/protocol/ntlm/types.bif.h"
#include "zeek/analyzer/protocol/ntlm/events.bif.h"


#include <cstdlib>

namespace binpac {

namespace NTLM {
class ContextNTLM;
class NTLM_Conn;
class NTLM_SSP_Token;
class NTLM_Negotiate;
class NTLM_Challenge;
class NTLM_Authenticate;
class NTLM_Version;
class NTLM_StringData;
class Fixed_Length_String;
class NTLM_String;
class NTLM_AV_Pair_Sequence;
class NTLM_AV_Pair;
class NTLM_Single_Host;
class LM_Response;
class NTLM_Response;
class NTLMv2_Response;
class NTLMv2_Client_Challenge;
class NTLM_Negotiate_Flags;
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TypeTag {
    ASN1_INTEGER_TAG = 2,
    ASN1_OCTET_STRING_TAG = 4,
    ASN1_NULL_TAG = 5,
    ASN1_OBJECT_IDENTIFIER_TAG = 6,
    ASN1_SEQUENCE_TAG = 48,
    ASN1_APP_TAG_OFFSET = 96,
    ASN1_INDEX_TAG_OFFSET = 160,
};
class ASN1Encoding;
class ASN1EncodingMeta;
class ASN1OptionalEncodingMeta;
class ASN1SequenceMeta;
class ASN1Integer;
class ASN1OctetString;
class ASN1ObjectIdentifier;
class ASN1Boolean;
class ASN1Enumerated;
class SequenceElement;
class Array;
class NTLM_Flow;
} // namespace NTLM

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace NTLM {

class ContextNTLM final {
public:
    ContextNTLM(NTLM_Conn* connection, NTLM_Flow* flow);
    ~ContextNTLM();

    // Member access functions
    NTLM_Conn* connection() const { return connection_; }
    NTLM_Flow* flow() const { return flow_; }

protected:
    NTLM_Conn* connection_;
    NTLM_Flow* flow_;
};


class NTLM_Conn final : public binpac::ConnectionAnalyzer {
public:
    NTLM_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~NTLM_Conn() override;

    // Member access functions
    NTLM_Flow* upflow() const { return upflow_; }
    NTLM_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    ZeekVal build_av_record(NTLM_AV_Pair_Sequence* val, uint16 len);
    bool proc_ntlm_negotiate(NTLM_Negotiate* val);
    bool proc_ntlm_challenge(NTLM_Challenge* val);
    bool proc_ntlm_authenticate(NTLM_Authenticate* val);

protected:
    NTLM_Flow* upflow_;
    NTLM_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};

uint32 min(uint32 v1, uint32 v2);

class NTLM_SSP_Token final {
public:
    NTLM_SSP_Token(bool is_orig);
    ~NTLM_SSP_Token();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context);

    // Member access functions
    bytestring const& signature() const { return signature_; }
    uint32 msg_type() const { return msg_type_; }
    uint32 msg_case_index() const	{ return msg_case_index_; }
    NTLM_Negotiate* negotiate() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint32)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:11:negotiate", (int64)msg_case_index(), "((int) 1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return negotiate_;
    }
    NTLM_Challenge* challenge() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint32)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:12:challenge", (int64)msg_case_index(), "((int) 2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return challenge_;
    }
    NTLM_Authenticate* authenticate() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint32)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:13:authenticate", (int64)msg_case_index(), "((int) 3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return authenticate_;
    }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    bytestring signature_;
    uint32 msg_type_;
    uint32 msg_case_index_;
    NTLM_Negotiate* negotiate_;
    NTLM_Challenge* challenge_;
    NTLM_Authenticate* authenticate_;
    const_bytestring def_;
    bool is_orig_;
    int byteorder_;
};


class NTLM_Negotiate final {
public:
    NTLM_Negotiate(uint16 offset);
    ~NTLM_Negotiate();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context, int t_byteorder);

    // Member access functions
    NTLM_Negotiate_Flags* flags() const { return flags_; }
    NTLM_StringData* domain_name_fields() const { return domain_name_fields_; }
    NTLM_StringData* workstation_fields() const { return workstation_fields_; }
    bytestring const& payload() const { return payload_; }
    uint16 offset() const { return offset_; }
    uint16 absolute_offset() const { return absolute_offset_; }
    NTLM_Version* version() const { BINPAC_ASSERT(has_version()); return version_; }
    bool has_version() const { return has_version_; }
    NTLM_String* domain_name() const { BINPAC_ASSERT(has_domain_name()); return domain_name_; }
    bool has_domain_name() const { return has_domain_name_; }
    NTLM_String* workstation() const { BINPAC_ASSERT(has_workstation()); return workstation_; }
    bool has_workstation() const { return has_workstation_; }
    int proc() const { return proc_; }

protected:
    NTLM_Negotiate_Flags* flags_;
    NTLM_StringData* domain_name_fields_;
    NTLM_StringData* workstation_fields_;
    bytestring payload_;
    uint16 offset_;
    uint16 absolute_offset_;
    NTLM_Version* version_;
    bool has_version_;
    NTLM_String* domain_name_;
    bool has_domain_name_;
    NTLM_String* workstation_;
    bool has_workstation_;
    int proc_;
};


class NTLM_Challenge final {
public:
    NTLM_Challenge(uint16 offset);
    ~NTLM_Challenge();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context, int t_byteorder);

    // Member access functions
    NTLM_StringData* target_name_fields() const { return target_name_fields_; }
    NTLM_Negotiate_Flags* flags() const { return flags_; }
    uint64 challenge() const { return challenge_; }
    NTLM_StringData* target_info_fields() const { return target_info_fields_; }
    bytestring const& payload() const { return payload_; }
    uint16 offset() const { return offset_; }
    uint16 absolute_offset() const { return absolute_offset_; }
    NTLM_Version* version() const { BINPAC_ASSERT(has_version()); return version_; }
    bool has_version() const { return has_version_; }
    NTLM_String* target_name() const { BINPAC_ASSERT(has_target_name()); return target_name_; }
    bool has_target_name() const { return has_target_name_; }
    NTLM_AV_Pair_Sequence* target_info() const { BINPAC_ASSERT(has_target_info()); return target_info_; }
    bool has_target_info() const { return has_target_info_; }
    bool proc() const { return proc_; }

protected:
    NTLM_StringData* target_name_fields_;
    NTLM_Negotiate_Flags* flags_;
    uint64 challenge_;
    NTLM_StringData* target_info_fields_;
    bytestring payload_;
    uint16 offset_;
    uint16 absolute_offset_;
    NTLM_Version* version_;
    bool has_version_;
    NTLM_String* target_name_;
    bool has_target_name_;
    NTLM_AV_Pair_Sequence* target_info_;
    bool has_target_info_;
    bool proc_;
};


class NTLM_Authenticate final {
public:
    NTLM_Authenticate(uint16 offset);
    ~NTLM_Authenticate();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextNTLM* t_context, int t_byteorder);

    // Member access functions
    NTLM_StringData* lm_challenge_response_fields() const { return lm_challenge_response_fields_; }
    NTLM_StringData* nt_challenge_response_fields() const { return nt_challenge_response_fields_; }
    NTLM_StringData* domain_name_fields() const { return domain_name_fields_; }
    NTLM_StringData* user_name_fields() const { return user_name_fields_; }
    NTLM_StringData* workstation_fields() const { return workstation_fields_; }
    NTLM_StringData* encrypted_session_key_fields() const { return encrypted_session_key_fields_; }
    NTLM_Negotiate_Flags* flags() const { return flags_; }
    bytestring const& payload() const { return payload_; }
    uint16 offset() const { return offset_; }
    uint16 absolute_offset() const { return absolute_offset_; }
    NTLM_Version* version() const { BINPAC_ASSERT(has_version()); return version_; }
    bool has_version() const { return has_version_; }
    NTLM_String* response() const { BINPAC_ASSERT(has_response()); return response_; }
    bool has_response() const { return has_response_; }
    NTLM_String* domain_name() const { BINPAC_ASSERT(has_domain_name()); return domain_name_; }
    bool has_domain_name() const { return has_domain_name_; }
    NTLM_String* user_name() const { BINPAC_ASSERT(has_user_name()); return user_name_; }
    bool has_user_name() const { return has_user_name_; }
    NTLM_String* workstation() const { BINPAC_ASSERT(has_workstation()); return workstation_; }
    bool has_workstation() const { return has_workstation_; }
    NTLM_String* encrypted_session_key() const { BINPAC_ASSERT(has_encrypted_session_key()); return encrypted_session_key_; }
    bool has_encrypted_session_key() const { return has_encrypted_session_key_; }
    bool proc() const { return proc_; }

protected:
    NTLM_StringData* lm_challenge_response_fields_;
    NTLM_StringData* nt_challenge_response_fields_;
    NTLM_StringData* domain_name_fields_;
    NTLM_StringData* user_name_fields_;
    NTLM_StringData* workstation_fields_;
    NTLM_StringData* encrypted_session_key_fields_;
    NTLM_Negotiate_Flags* flags_;
    bytestring payload_;
    uint16 offset_;
    uint16 absolute_offset_;
    NTLM_Version* version_;
    bool has_version_;
    NTLM_String* response_;
    bool has_response_;
    NTLM_String* domain_name_;
    bool has_domain_name_;
    NTLM_String* user_name_;
    bool has_user_name_;
    NTLM_String* workstation_;
    bool has_workstation_;
    NTLM_String* encrypted_session_key_;
    bool has_encrypted_session_key_;
    bool proc_;
};


class NTLM_Version final {
public:
    NTLM_Version();
    ~NTLM_Version();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 major_version() const { return major_version_; }
    uint8 minor_version() const { return minor_version_; }
    uint16 build_number() const { return build_number_; }
    uint8 ntlm_revision() const { return ntlm_revision_; }

protected:
    uint8 major_version_;
    uint8 minor_version_;
    uint16 build_number_;
    uint8 ntlm_revision_;
};


class NTLM_StringData final {
public:
    NTLM_StringData();
    ~NTLM_StringData();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 length() const { return length_; }
    uint16 max_length() const { return max_length_; }
    uint32 offset() const { return offset_; }

protected:
    uint16 length_;
    uint16 max_length_;
    uint32 offset_;
};


class Fixed_Length_String final {
public:
    Fixed_Length_String(bool unicode);
    ~Fixed_Length_String();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& data() const { return data_; }
    bool unicode() const { return unicode_; }

protected:
    bytestring data_;
    bool unicode_;
};


class NTLM_String final {
public:
    NTLM_String(NTLM_StringData* fields, uint16 offset, bool unicode);
    ~NTLM_String();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    Fixed_Length_String* string() const { return string_; }
    NTLM_StringData* fields() const { return fields_; }
    uint16 offset() const { return offset_; }
    bool unicode() const { return unicode_; }

protected:
    Fixed_Length_String* string_;
    NTLM_StringData* fields_;
    uint16 offset_;
    bool unicode_;
};


class NTLM_AV_Pair_Sequence final {
public:
    NTLM_AV_Pair_Sequence(uint16 offset);
    ~NTLM_AV_Pair_Sequence();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    vector<NTLM_AV_Pair*>* pairs() const { return pairs_; }
    uint16 offset() const { return offset_; }

protected:
    vector<NTLM_AV_Pair*>* pairs_;
    NTLM_AV_Pair* pairs__elem_;
    uint16 offset_;
};


class NTLM_AV_Pair final {
public:
    NTLM_AV_Pair();
    ~NTLM_AV_Pair();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 id() const { return id_; }
    uint16 length() const { return length_; }
    uint16 value_case_case_index() const	{ return value_case_case_index_; }
    Fixed_Length_String* nb_computer_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:101:nb_computer_name", (int64)value_case_case_index(), "((int) 0x0001)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nb_computer_name_;
    }
    Fixed_Length_String* nb_domain_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:102:nb_domain_name", (int64)value_case_case_index(), "((int) 0x0002)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nb_domain_name_;
    }
    Fixed_Length_String* dns_computer_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:103:dns_computer_name", (int64)value_case_case_index(), "((int) 0x0003)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dns_computer_name_;
    }
    Fixed_Length_String* dns_domain_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:104:dns_domain_name", (int64)value_case_case_index(), "((int) 0x0004)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dns_domain_name_;
    }
    Fixed_Length_String* dns_tree_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:105:dns_tree_name", (int64)value_case_case_index(), "((int) 0x0005)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return dns_tree_name_;
    }
    uint32 av_flags() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)6):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:106:av_flags", (int64)value_case_case_index(), "((int) 0x0006)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return av_flags_;
    }
    uint64 timestamp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)7):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:107:timestamp", (int64)value_case_case_index(), "((int) 0x0007)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return timestamp_;
    }
    NTLM_Single_Host* single_host() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:108:single_host", (int64)value_case_case_index(), "((int) 0x0008)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return single_host_;
    }
    Fixed_Length_String* target_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:109:target_name", (int64)value_case_case_index(), "((int) 0x0009)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return target_name_;
    }
    uint16 channel_bindings() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_case_index() ) {
            case ((uint16)10):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:110:channel_bindings", (int64)value_case_case_index(), "((int) 0x000a)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return channel_bindings_;
    }
    bool last() const { return last_; }
    bool constrained_auth() const { BINPAC_ASSERT(has_constrained_auth()); return constrained_auth_; }
    bool has_constrained_auth() const { return has_constrained_auth_; }
    bool mic_present() const { BINPAC_ASSERT(has_mic_present()); return mic_present_; }
    bool has_mic_present() const { return has_mic_present_; }
    bool untrusted_source() const { BINPAC_ASSERT(has_untrusted_source()); return untrusted_source_; }
    bool has_untrusted_source() const { return has_untrusted_source_; }

protected:
    uint16 id_;
    uint16 length_;
    uint16 value_case_case_index_;
    Fixed_Length_String* nb_computer_name_;
    Fixed_Length_String* nb_domain_name_;
    Fixed_Length_String* dns_computer_name_;
    Fixed_Length_String* dns_domain_name_;
    Fixed_Length_String* dns_tree_name_;
    uint32 av_flags_;
    uint64 timestamp_;
    NTLM_Single_Host* single_host_;
    Fixed_Length_String* target_name_;
    uint16 channel_bindings_;
    bool last_;
    bool constrained_auth_;
    bool has_constrained_auth_;
    bool mic_present_;
    bool has_mic_present_;
    bool untrusted_source_;
    bool has_untrusted_source_;
};


class NTLM_Single_Host final {
public:
    NTLM_Single_Host();
    ~NTLM_Single_Host();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 size() const { return size_; }
    uint32 data_present() const { return data_present_; }
    int optional_case_index() const	{ return optional_case_index_; }
    bytestring const& custom_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( optional_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/ntlm-protocol.pac:125:custom_data", (int64)optional_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return custom_data_;
    }
    uint32 machine_id() const { return machine_id_; }
    bool custom_data_present() const { return custom_data_present_; }

protected:
    uint32 size_;
    uint32 data_present_;
    int optional_case_index_;
    bytestring custom_data_;
    uint32 machine_id_;
    bool custom_data_present_;
};


class LM_Response final {
public:
    LM_Response(uint16 offset);
    ~LM_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& response() const { return response_; }
    uint16 offset() const { return offset_; }

protected:
    bytestring response_;
    uint16 offset_;
};


class NTLM_Response final {
public:
    NTLM_Response(uint16 offset);
    ~NTLM_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& response() const { return response_; }
    uint16 offset() const { return offset_; }

protected:
    bytestring response_;
    uint16 offset_;
};


class NTLMv2_Response final {
public:
    NTLMv2_Response(NTLM_Negotiate_Flags* flags, uint16 offset);
    ~NTLMv2_Response();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    bytestring const& response() const { return response_; }
    NTLMv2_Client_Challenge* client_challenge() const { return client_challenge_; }
    NTLM_Negotiate_Flags* flags() const { return flags_; }
    uint16 offset() const { return offset_; }

protected:
    bytestring response_;
    NTLMv2_Client_Challenge* client_challenge_;
    NTLM_Negotiate_Flags* flags_;
    uint16 offset_;
};


class NTLMv2_Client_Challenge final {
public:
    NTLMv2_Client_Challenge(NTLM_Negotiate_Flags* flags);
    ~NTLMv2_Client_Challenge();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 resp_type() const { return resp_type_; }
    uint8 max_resp_type() const { return max_resp_type_; }
    uint64 timestamp() const { return timestamp_; }
    bytestring const& client_challenge() const { return client_challenge_; }
    NTLM_AV_Pair_Sequence* av_pairs() const { return av_pairs_; }
    NTLM_Negotiate_Flags* flags() const { return flags_; }

protected:
    uint8 resp_type_;
    uint8 max_resp_type_;
    uint64 timestamp_;
    bytestring client_challenge_;
    NTLM_AV_Pair_Sequence* av_pairs_;
    NTLM_Negotiate_Flags* flags_;
};


class NTLM_Negotiate_Flags final {
public:
    NTLM_Negotiate_Flags();
    ~NTLM_Negotiate_Flags();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 flags() const { return flags_; }
    bool negotiate_56() const { return negotiate_56_; }
    bool negotiate_key_exch() const { return negotiate_key_exch_; }
    bool negotiate_128() const { return negotiate_128_; }
    bool negotiate_version() const { return negotiate_version_; }
    bool negotiate_target_info() const { return negotiate_target_info_; }
    bool request_non_nt_session_key() const { return request_non_nt_session_key_; }
    bool negotiate_identify() const { return negotiate_identify_; }
    bool negotiate_extended_sessionsecurity() const { return negotiate_extended_sessionsecurity_; }
    bool target_type_server() const { return target_type_server_; }
    bool target_type_domain() const { return target_type_domain_; }
    bool negotiate_always_sign() const { return negotiate_always_sign_; }
    bool negotiate_oem_workstation_supplied() const { return negotiate_oem_workstation_supplied_; }
    bool negotiate_oem_domain_supplied() const { return negotiate_oem_domain_supplied_; }
    bool negotiate_anonymous_connection() const { return negotiate_anonymous_connection_; }
    bool negotiate_ntlm() const { return negotiate_ntlm_; }
    bool negotiate_lm_key() const { return negotiate_lm_key_; }
    bool negotiate_datagram() const { return negotiate_datagram_; }
    bool negotiate_seal() const { return negotiate_seal_; }
    bool negotiate_sign() const { return negotiate_sign_; }
    bool request_target() const { return request_target_; }
    bool negotiate_oem() const { return negotiate_oem_; }
    bool negotiate_unicode() const { return negotiate_unicode_; }
    bool is_oem() const { return is_oem_; }
    bool is_invalid() const { return is_invalid_; }

protected:
    uint32 flags_;
    bool negotiate_56_;
    bool negotiate_key_exch_;
    bool negotiate_128_;
    bool negotiate_version_;
    bool negotiate_target_info_;
    bool request_non_nt_session_key_;
    bool negotiate_identify_;
    bool negotiate_extended_sessionsecurity_;
    bool target_type_server_;
    bool target_type_domain_;
    bool negotiate_always_sign_;
    bool negotiate_oem_workstation_supplied_;
    bool negotiate_oem_domain_supplied_;
    bool negotiate_anonymous_connection_;
    bool negotiate_ntlm_;
    bool negotiate_lm_key_;
    bool negotiate_datagram_;
    bool negotiate_seal_;
    bool negotiate_sign_;
    bool request_target_;
    bool negotiate_oem_;
    bool negotiate_unicode_;
    bool is_oem_;
    bool is_invalid_;
};


	zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t);
	zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t);
	zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid);
	zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s);


class ASN1Encoding final {
public:
    ASN1Encoding();
    ~ASN1Encoding();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& content() const { return content_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring content_;
};


class ASN1EncodingMeta final {
public:
    ASN1EncodingMeta();
    ~ASN1EncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 tag() const { return tag_; }
    uint8 len() const { return len_; }
    bytestring const& more_len() const { return more_len_; }
    bool long_len() const { return long_len_; }
    uint64 length() const { return length_; }
    uint8 index() const { return index_; }

protected:
    uint8 tag_;
    uint8 len_;
    bytestring more_len_;
    bool long_len_;
    uint64 length_;
    uint8 index_;
};


class ASN1OptionalEncodingMeta final {
public:
    ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata);
    ~ASN1OptionalEncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ASN1EncodingMeta* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/../asn1/asn1.pac:42:data", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    bool is_present() const { return is_present_; }
    ASN1EncodingMeta* previous_metadata() const { return previous_metadata_; }
    uint64 length() const { return length_; }

protected:
    int val_case_index_;
    ASN1EncodingMeta* data_;
    bool is_present_;
    ASN1EncodingMeta* previous_metadata_;
    uint64 length_;
};


class ASN1SequenceMeta final {
public:
    ASN1SequenceMeta();
    ~ASN1SequenceMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* encoding() const { return encoding_; }

protected:
    ASN1EncodingMeta* encoding_;
};


class ASN1Integer final {
public:
    ASN1Integer();
    ~ASN1Integer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1OctetString final {
public:
    ASN1OctetString();
    ~ASN1OctetString();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1ObjectIdentifier final {
public:
    ASN1ObjectIdentifier();
    ~ASN1ObjectIdentifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Boolean final {
public:
    ASN1Boolean();
    ~ASN1Boolean();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Enumerated final {
public:
    ASN1Enumerated();
    ~ASN1Enumerated();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class SequenceElement final {
public:
    SequenceElement(bool grab_content);
    ~SequenceElement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* index_meta() const { return index_meta_; }
    int have_content_case_index() const	{ return have_content_case_index_; }
    ASN1Encoding* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/../asn1/asn1.pac:75:data", (int64)have_content_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    ASN1EncodingMeta* meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ntlm/../asn1/asn1.pac:76:meta", (int64)have_content_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return meta_;
    }
    bool grab_content() const { return grab_content_; }
    uint8 index() const { return index_; }
    uint64 length() const { return length_; }

protected:
    ASN1EncodingMeta* index_meta_;
    int have_content_case_index_;
    ASN1Encoding* data_;
    ASN1EncodingMeta* meta_;
    bool grab_content_;
    uint8 index_;
    uint64 length_;
};


class Array final {
public:
    Array();
    ~Array();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* array_meta() const { return array_meta_; }
    vector<ASN1Encoding*>* data() const { return data_; }

protected:
    ASN1EncodingMeta* array_meta_;
    vector<ASN1Encoding*>* data_;
    ASN1Encoding* data__elem_;
};

int64 binary_to_int64(bytestring const& bs);

class NTLM_Flow final : public binpac::FlowAnalyzer {
public:
    NTLM_Flow(NTLM_Conn* connection, bool is_orig);
    ~NTLM_Flow() override;

    // Member access functions
    NTLM_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    NTLM_SSP_Token* dataunit_;
    ContextNTLM* context_;
    NTLM_Conn* connection_;
    bool is_orig_;
};


	zeek::IntrusivePtr<zeek::TimeVal> filetime2zeektime(uint64_t ts);
	zeek::RecordValPtr build_version_record(NTLM_Version* val);
	zeek::RecordValPtr build_negotiate_flag_record(NTLM_Negotiate_Flags* val);

} // namespace NTLM
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_ntlm_ntlm_pac_h */
