// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_snmp_snmp_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_snmp_snmp_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/analyzer/protocol/snmp/types.bif.h"
#include "zeek/analyzer/protocol/snmp/events.bif.h"


#include <cstdlib>


#include <cstdlib>
#include <vector>
#include <string>

#include "zeek/net_util.h"
#include "zeek/util.h"

namespace binpac {

namespace SNMP {
class ContextSNMP;
class SNMP_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum ASN1TypeTag {
    ASN1_INTEGER_TAG = 2,
    ASN1_OCTET_STRING_TAG = 4,
    ASN1_NULL_TAG = 5,
    ASN1_OBJECT_IDENTIFIER_TAG = 6,
    ASN1_SEQUENCE_TAG = 48,
    ASN1_APP_TAG_OFFSET = 96,
    ASN1_INDEX_TAG_OFFSET = 160,
};
class ASN1Encoding;
class ASN1EncodingMeta;
class ASN1OptionalEncodingMeta;
class ASN1SequenceMeta;
class ASN1Integer;
class ASN1OctetString;
class ASN1ObjectIdentifier;
class ASN1Boolean;
class ASN1Enumerated;
class SequenceElement;
class Array;
class TopLevelMessage;
// NOLINTNEXTLINE(performance-enum-size)
enum SNMP_VersionTag {
    SNMPV1_TAG = 0,
    SNMPV2_TAG = 1,
    SNMPV3_TAG = 3,
};
class Header;
class PDU_Choice;
class PDU;
class v1Header;
class v2Header;
class v3Header;
class v3HeaderData;
class v3ScopedPDU;
class EncryptedPDU;
class UnknownScopedPDU;
class UnknownVersionHeader;
class CommonPDU;
class GetRequestPDU;
class GetNextRequestPDU;
class ResponsePDU;
class SetRequestPDU;
class TrapPDU;
class GetBulkRequestPDU;
class InformRequestPDU;
class v2TrapPDU;
class ReportPDU;
class UnknownPDU;
class VarBindList;
class VarBind;
class ObjectName;
class ObjectSyntax;
class NetworkAddress;
class TimeTicks;
// NOLINTNEXTLINE(performance-enum-size)
enum AppSyntaxTypeTag {
    APP_IPADDRESS_TAG = 64,
    APP_COUNTER32_TAG = 65,
    APP_UNSIGNED32_TAG = 66,
    APP_TIMETICKS_TAG = 67,
    APP_OPAQUE_TAG = 68,
    APP_COUNTER64_TAG = 70,
};
// NOLINTNEXTLINE(performance-enum-size)
enum VarBindNullTag {
    VARBIND_UNSPECIFIED_TAG = 5,
    VARBIND_NOSUCHOBJECT_TAG = 128,
    VARBIND_NOSUCHINSTANCE_TAG = 129,
    VARBIND_ENDOFMIBVIEW_TAG = 130,
};
class SNMP_Flow;
} // namespace SNMP

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace SNMP {

class ContextSNMP final {
public:
    ContextSNMP(SNMP_Conn* connection, SNMP_Flow* flow);
    ~ContextSNMP();

    // Member access functions
    SNMP_Conn* connection() const { return connection_; }
    SNMP_Flow* flow() const { return flow_; }

protected:
    SNMP_Conn* connection_;
    SNMP_Flow* flow_;
};


class SNMP_Conn final : public binpac::ConnectionAnalyzer {
public:
    SNMP_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~SNMP_Conn() override;

    // Member access functions
    SNMP_Flow* upflow() const { return upflow_; }
    SNMP_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool proc_get_request(GetRequestPDU* pdu);
    bool proc_get_next_request(GetNextRequestPDU* pdu);
    bool proc_response(ResponsePDU* pdu);
    bool proc_set_request(SetRequestPDU* pdu);
    bool proc_trap(TrapPDU* pdu);
    bool proc_get_bulk_request(GetBulkRequestPDU* pdu);
    bool proc_inform_request(InformRequestPDU* pdu);
    bool proc_v2_trap(v2TrapPDU* pdu);
    bool proc_report(ReportPDU* pdu);
    bool proc_unknown_version_header(UnknownVersionHeader* rec);
    bool proc_unknown_pdu(UnknownPDU* rec);
    bool proc_unknown_scoped_pdu(UnknownScopedPDU* rec);
    bool proc_encrypted_pdu(EncryptedPDU* rec);
    bool proc_header(Header* rec);
    bool proc_v3_header_data(v3HeaderData* rec);
    bool check_tag(ASN1EncodingMeta* rec, uint8 expect);
    bool check_int_width(ASN1Integer* rec);
    bool check_int(ASN1Integer* rec);

protected:
    SNMP_Flow* upflow_;
    SNMP_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


	zeek::ValPtr asn1_integer_to_val(const ASN1Encoding* i, zeek::TypeTag t);
	zeek::ValPtr asn1_integer_to_val(const ASN1Integer* i, zeek::TypeTag t);
	zeek::StringValPtr asn1_oid_to_val(const ASN1Encoding* oid);
	zeek::StringValPtr asn1_oid_to_val(const ASN1ObjectIdentifier* oid);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1Encoding* s);
	zeek::StringValPtr asn1_octet_string_to_val(const ASN1OctetString* s);


class ASN1Encoding final {
public:
    ASN1Encoding();
    ~ASN1Encoding();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* meta() const { return meta_; }
    bytestring const& content() const { return content_; }

protected:
    ASN1EncodingMeta* meta_;
    bytestring content_;
};


class ASN1EncodingMeta final {
public:
    ASN1EncodingMeta();
    ~ASN1EncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 tag() const { return tag_; }
    uint8 len() const { return len_; }
    bytestring const& more_len() const { return more_len_; }
    bool long_len() const { return long_len_; }
    uint64 length() const { return length_; }
    uint8 index() const { return index_; }

protected:
    uint8 tag_;
    uint8 len_;
    bytestring more_len_;
    bool long_len_;
    uint64 length_;
    uint8 index_;
};


class ASN1OptionalEncodingMeta final {
public:
    ASN1OptionalEncodingMeta(bool is_present, ASN1EncodingMeta* previous_metadata);
    ~ASN1OptionalEncodingMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ASN1EncodingMeta* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/../asn1/asn1.pac:42:data", (int64)val_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    bool is_present() const { return is_present_; }
    ASN1EncodingMeta* previous_metadata() const { return previous_metadata_; }
    uint64 length() const { return length_; }

protected:
    int val_case_index_;
    ASN1EncodingMeta* data_;
    bool is_present_;
    ASN1EncodingMeta* previous_metadata_;
    uint64 length_;
};


class ASN1SequenceMeta final {
public:
    ASN1SequenceMeta();
    ~ASN1SequenceMeta();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1EncodingMeta* encoding() const { return encoding_; }
    bool valid() const { return valid_; }

protected:
    ASN1EncodingMeta* encoding_;
    bool valid_;
};


class ASN1Integer final {
public:
    ASN1Integer();
    ~ASN1Integer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }
    bool valid() const { return valid_; }

protected:
    ASN1Encoding* encoding_;
    bool valid_;
};


class ASN1OctetString final {
public:
    ASN1OctetString();
    ~ASN1OctetString();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }
    bool valid() const { return valid_; }

protected:
    ASN1Encoding* encoding_;
    bool valid_;
};


class ASN1ObjectIdentifier final {
public:
    ASN1ObjectIdentifier();
    ~ASN1ObjectIdentifier();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }
    bool valid() const { return valid_; }

protected:
    ASN1Encoding* encoding_;
    bool valid_;
};


class ASN1Boolean final {
public:
    ASN1Boolean();
    ~ASN1Boolean();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class ASN1Enumerated final {
public:
    ASN1Enumerated();
    ~ASN1Enumerated();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class SequenceElement final {
public:
    SequenceElement(bool grab_content);
    ~SequenceElement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* index_meta() const { return index_meta_; }
    int have_content_case_index() const	{ return have_content_case_index_; }
    ASN1Encoding* data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/../asn1/asn1.pac:75:data", (int64)have_content_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return data_;
    }
    ASN1EncodingMeta* meta() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( have_content_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/../asn1/asn1.pac:76:meta", (int64)have_content_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return meta_;
    }
    bool grab_content() const { return grab_content_; }
    uint8 index() const { return index_; }
    uint64 length() const { return length_; }

protected:
    ASN1EncodingMeta* index_meta_;
    int have_content_case_index_;
    ASN1Encoding* data_;
    ASN1EncodingMeta* meta_;
    bool grab_content_;
    uint8 index_;
    uint64 length_;
};


class Array final {
public:
    Array();
    ~Array();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1EncodingMeta* array_meta() const { return array_meta_; }
    vector<ASN1Encoding*>* data() const { return data_; }

protected:
    ASN1EncodingMeta* array_meta_;
    vector<ASN1Encoding*>* data_;
    ASN1Encoding* data__elem_;
};

int64 binary_to_int64(bytestring const& bs);

class TopLevelMessage final {
public:
    TopLevelMessage(bool is_orig);
    ~TopLevelMessage();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1SequenceMeta* asn1_sequence_meta() const { return asn1_sequence_meta_; }
    ASN1Integer* version() const { return version_; }
    Header* header() const { return header_; }
    int pdu_or_not_case_index() const	{ return pdu_or_not_case_index_; }
    PDU_Choice* pdu() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( pdu_or_not_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:19:pdu", (int64)pdu_or_not_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pdu_;
    }
    bool is_orig() const { return is_orig_; }
    int64 version_value() const { return version_value_; }

protected:
    ASN1SequenceMeta* asn1_sequence_meta_;
    ASN1Integer* version_;
    Header* header_;
    int pdu_or_not_case_index_;
    PDU_Choice* pdu_;
    bool is_orig_;
    int64 version_value_;
};


class Header final {
public:
    Header(int64 version, bool is_orig);
    ~Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    int64 val_case_index() const	{ return val_case_index_; }
    v1Header* v1() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)0):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:34:v1", (int64)val_case_index(), "SNMPV1_TAG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v1_;
    }
    v2Header* v2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:35:v2", (int64)val_case_index(), "SNMPV2_TAG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v2_;
    }
    v3Header* v3() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int64)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:36:v3", (int64)val_case_index(), "SNMPV3_TAG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v3_;
    }
    UnknownVersionHeader* unknown() const {
        return unknown_;
    }
    int64 version() const { return version_; }
    bool is_orig() const { return is_orig_; }
    bool proc() const { return proc_; }

protected:
    int64 val_case_index_;
    v1Header* v1_;
    v2Header* v2_;
    v3Header* v3_;
    UnknownVersionHeader* unknown_;
    int64 version_;
    bool is_orig_;
    bool proc_;
};

bool have_plaintext_pdu(Header* header);

class PDU_Choice final {
public:
    PDU_Choice(Header* header);
    ~PDU_Choice();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1EncodingMeta* choice() const { return choice_; }
    PDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }

protected:
    ASN1EncodingMeta* choice_;
    PDU* pdu_;
    Header* header_;
};


class PDU final {
public:
    PDU(uint8 choice, Header* header);
    ~PDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    uint8 val_case_index() const	{ return val_case_index_; }
    UnknownPDU* unknown() const {
        return unknown_;
    }
    GetRequestPDU* get_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)160):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:59:get_request", (int64)val_case_index(), "((int) 0xa0)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return get_request_;
    }
    GetNextRequestPDU* get_next_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)161):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:60:get_next_request", (int64)val_case_index(), "((int) 0xa1)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return get_next_request_;
    }
    ResponsePDU* response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)162):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:61:response", (int64)val_case_index(), "((int) 0xa2)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return response_;
    }
    SetRequestPDU* set_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)163):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:62:set_request", (int64)val_case_index(), "((int) 0xa3)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return set_request_;
    }
    TrapPDU* trap() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)164):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:63:trap", (int64)val_case_index(), "((int) 0xa4)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return trap_;
    }
    GetBulkRequestPDU* get_bulk_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)165):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:68:get_bulk_request", (int64)val_case_index(), "((int) 0xa5)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return get_bulk_request_;
    }
    InformRequestPDU* inform_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)166):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:69:inform_request", (int64)val_case_index(), "((int) 0xa6)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return inform_request_;
    }
    v2TrapPDU* v2_trap() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)167):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:70:v2_trap", (int64)val_case_index(), "((int) 0xa7)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v2_trap_;
    }
    ReportPDU* report() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((uint8)168):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:71:report", (int64)val_case_index(), "((int) 0xa8)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return report_;
    }
    uint8 choice() const { return choice_; }
    Header* header() const { return header_; }

protected:
    uint8 val_case_index_;
    UnknownPDU* unknown_;
    GetRequestPDU* get_request_;
    GetNextRequestPDU* get_next_request_;
    ResponsePDU* response_;
    SetRequestPDU* set_request_;
    TrapPDU* trap_;
    GetBulkRequestPDU* get_bulk_request_;
    InformRequestPDU* inform_request_;
    v2TrapPDU* v2_trap_;
    ReportPDU* report_;
    uint8 choice_;
    Header* header_;
};


class v1Header final {
public:
    v1Header(Header* header);
    ~v1Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1OctetString* community() const { return community_; }
    Header* header() const { return header_; }

protected:
    ASN1OctetString* community_;
    Header* header_;
};


class v2Header final {
public:
    v2Header(Header* header);
    ~v2Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1OctetString* community() const { return community_; }
    Header* header() const { return header_; }

protected:
    ASN1OctetString* community_;
    Header* header_;
};


class v3Header final {
public:
    v3Header(Header* header);
    ~v3Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    v3HeaderData* global_data() const { return global_data_; }
    ASN1OctetString* security_parameters() const { return security_parameters_; }
    ASN1EncodingMeta* next() const { return next_; }
    uint8 scoped_pdu_data_case_index() const	{ return scoped_pdu_data_case_index_; }
    v3ScopedPDU* plaintext_pdu() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( scoped_pdu_data_case_index() ) {
            case ((uint8)48):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:87:plaintext_pdu", (int64)scoped_pdu_data_case_index(), "ASN1_SEQUENCE_TAG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return plaintext_pdu_;
    }
    EncryptedPDU* encrypted_pdu() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( scoped_pdu_data_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/snmp/snmp-protocol.pac:88:encrypted_pdu", (int64)scoped_pdu_data_case_index(), "ASN1_OCTET_STRING_TAG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return encrypted_pdu_;
    }
    UnknownScopedPDU* unknown_pdu() const {
        return unknown_pdu_;
    }
    Header* header() const { return header_; }

protected:
    v3HeaderData* global_data_;
    ASN1OctetString* security_parameters_;
    ASN1EncodingMeta* next_;
    uint8 scoped_pdu_data_case_index_;
    v3ScopedPDU* plaintext_pdu_;
    EncryptedPDU* encrypted_pdu_;
    UnknownScopedPDU* unknown_pdu_;
    Header* header_;
};


class v3HeaderData final {
public:
    v3HeaderData();
    ~v3HeaderData();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1SequenceMeta* asn1_sequence_meta() const { return asn1_sequence_meta_; }
    ASN1Integer* id() const { return id_; }
    ASN1Integer* max_size() const { return max_size_; }
    ASN1OctetString* flags() const { return flags_; }
    ASN1Integer* security_model() const { return security_model_; }
    bool proc() const { return proc_; }

protected:
    ASN1SequenceMeta* asn1_sequence_meta_;
    ASN1Integer* id_;
    ASN1Integer* max_size_;
    ASN1OctetString* flags_;
    ASN1Integer* security_model_;
    bool proc_;
};


class v3ScopedPDU final {
public:
    v3ScopedPDU();
    ~v3ScopedPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1OctetString* context_engine_id() const { return context_engine_id_; }
    ASN1OctetString* context_name() const { return context_name_; }

protected:
    ASN1OctetString* context_engine_id_;
    ASN1OctetString* context_name_;
};


class EncryptedPDU final {
public:
    EncryptedPDU(Header* header);
    ~EncryptedPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring data_;
    Header* header_;
    bool proc_;
};


class UnknownScopedPDU final {
public:
    UnknownScopedPDU(uint8 tag, Header* header);
    ~UnknownScopedPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    uint8 tag() const { return tag_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring data_;
    uint8 tag_;
    Header* header_;
    bool proc_;
};


class UnknownVersionHeader final {
public:
    UnknownVersionHeader(Header* header);
    ~UnknownVersionHeader();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring data_;
    Header* header_;
    bool proc_;
};


class CommonPDU final {
public:
    CommonPDU(Header* header);
    ~CommonPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Integer* request_id() const { return request_id_; }
    ASN1Integer* error_status() const { return error_status_; }
    ASN1Integer* error_index() const { return error_index_; }
    VarBindList* var_bindings() const { return var_bindings_; }
    Header* header() const { return header_; }

protected:
    ASN1Integer* request_id_;
    ASN1Integer* error_status_;
    ASN1Integer* error_index_;
    VarBindList* var_bindings_;
    Header* header_;
};


class GetRequestPDU final {
public:
    GetRequestPDU(Header* header);
    ~GetRequestPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class GetNextRequestPDU final {
public:
    GetNextRequestPDU(Header* header);
    ~GetNextRequestPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class ResponsePDU final {
public:
    ResponsePDU(Header* header);
    ~ResponsePDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class SetRequestPDU final {
public:
    SetRequestPDU(Header* header);
    ~SetRequestPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class TrapPDU final {
public:
    TrapPDU(Header* header);
    ~TrapPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1ObjectIdentifier* enterprise() const { return enterprise_; }
    NetworkAddress* agent_addr() const { return agent_addr_; }
    ASN1Integer* generic_trap() const { return generic_trap_; }
    ASN1Integer* specific_trap() const { return specific_trap_; }
    TimeTicks* time_stamp() const { return time_stamp_; }
    VarBindList* var_bindings() const { return var_bindings_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    ASN1ObjectIdentifier* enterprise_;
    NetworkAddress* agent_addr_;
    ASN1Integer* generic_trap_;
    ASN1Integer* specific_trap_;
    TimeTicks* time_stamp_;
    VarBindList* var_bindings_;
    Header* header_;
    bool proc_;
};


class GetBulkRequestPDU final {
public:
    GetBulkRequestPDU(Header* header);
    ~GetBulkRequestPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Integer* request_id() const { return request_id_; }
    ASN1Integer* non_repeaters() const { return non_repeaters_; }
    ASN1Integer* max_repetitions() const { return max_repetitions_; }
    VarBindList* var_bindings() const { return var_bindings_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    ASN1Integer* request_id_;
    ASN1Integer* non_repeaters_;
    ASN1Integer* max_repetitions_;
    VarBindList* var_bindings_;
    Header* header_;
    bool proc_;
};


class InformRequestPDU final {
public:
    InformRequestPDU(Header* header);
    ~InformRequestPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class v2TrapPDU final {
public:
    v2TrapPDU(Header* header);
    ~v2TrapPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class ReportPDU final {
public:
    ReportPDU(Header* header);
    ~ReportPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    CommonPDU* pdu() const { return pdu_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    CommonPDU* pdu_;
    Header* header_;
    bool proc_;
};


class UnknownPDU final {
public:
    UnknownPDU(uint8 tag, Header* header);
    ~UnknownPDU();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    uint8 tag() const { return tag_; }
    Header* header() const { return header_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring data_;
    uint8 tag_;
    Header* header_;
    bool proc_;
};


class VarBindList final {
public:
    VarBindList();
    ~VarBindList();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1SequenceMeta* asn1_sequence_meta() const { return asn1_sequence_meta_; }
    vector<VarBind*>* bindings() const { return bindings_; }

protected:
    ASN1SequenceMeta* asn1_sequence_meta_;
    vector<VarBind*>* bindings_;
    VarBind* bindings__elem_;
};


class VarBind final {
public:
    VarBind();
    ~VarBind();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1SequenceMeta* asn1_sequence_meta() const { return asn1_sequence_meta_; }
    ObjectName* name() const { return name_; }
    ObjectSyntax* value() const { return value_; }

protected:
    ASN1SequenceMeta* asn1_sequence_meta_;
    ObjectName* name_;
    ObjectSyntax* value_;
};


class ObjectName final {
public:
    ObjectName();
    ~ObjectName();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1ObjectIdentifier* oid() const { return oid_; }

protected:
    ASN1ObjectIdentifier* oid_;
};


class ObjectSyntax final {
public:
    ObjectSyntax();
    ~ObjectSyntax();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }

protected:
    ASN1Encoding* encoding_;
};


class NetworkAddress final {
public:
    NetworkAddress();
    ~NetworkAddress();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Encoding* encoding() const { return encoding_; }
    bool valid() const { return valid_; }

protected:
    ASN1Encoding* encoding_;
    bool valid_;
};


class TimeTicks final {
public:
    TimeTicks();
    ~TimeTicks();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSNMP* t_context);

    // Member access functions
    ASN1Encoding* asn1_integer() const { return asn1_integer_; }
    bool valid() const { return valid_; }

protected:
    ASN1Encoding* asn1_integer_;
    bool valid_;
};


class SNMP_Flow final : public binpac::FlowAnalyzer {
public:
    SNMP_Flow(SNMP_Conn* connection, bool is_orig);
    ~SNMP_Flow() override;

    // Member access functions
    SNMP_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    TopLevelMessage* dataunit_;
    ContextSNMP* context_;
    SNMP_Conn* connection_;
    bool is_orig_;
};


zeek::AddrValPtr network_address_to_val(const ASN1Encoding* na);
zeek::AddrValPtr network_address_to_val(const NetworkAddress* na);
zeek::RecordValPtr asn1_obj_to_val(const ASN1Encoding* obj);

zeek::RecordValPtr build_hdr(const Header* header);
zeek::RecordValPtr build_hdrV3(const Header* header);
zeek::VectorValPtr build_bindings(const VarBindList* vbl);
zeek::RecordValPtr build_pdu(const CommonPDU* pdu);
zeek::RecordValPtr build_trap_pdu(const TrapPDU* pdu);
zeek::RecordValPtr build_bulk_pdu(const GetBulkRequestPDU* pdu);

} // namespace SNMP
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_snmp_snmp_pac_h */
