// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_ssl_ssl_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_ssl_ssl_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"



namespace zeek::analyzer::ssl { class SSL_Analyzer; }
using SSLAnalyzer = zeek::analyzer::ssl::SSL_Analyzer*;

#include "zeek/Desc.h"
#include "zeek/analyzer/protocol/ssl/SSL.h"

#include "zeek/analyzer/protocol/ssl/events.bif.h"


#include "zeek/analyzer/protocol/ssl/consts.bif.h"


#include <vector>
#include <algorithm>
#include <iostream>
#include <iterator>

#include "zeek/util.h"
#include "zeek/file_analysis/Manager.h"


#include <string>
#include "zeek/analyzer/protocol/ssl/events.bif.h"

using std::string;

namespace binpac {

namespace SSL {
class ContextSSL;
class SSL_Conn;
class PlaintextRecord;
// NOLINTNEXTLINE(performance-enum-size)
enum AnalyzerState {
    STATE_CLEAR,
    STATE_ENCRYPTED,
};
class ChangeCipherSpec;
class Alerts;
class Alert;
class ApplicationData;
class Heartbeat;
class UnknownRecord;
class CiphertextRecord;
class SSLRecord;
class RecordText;
class Handshake;
class V2Error;
class V2ClientHello;
class V2ServerHello;
class V2ClientMasterKey;
class SSLPDU;
class SSL_Flow;
class uint24;
class uint48;
// NOLINTNEXTLINE(performance-enum-size)
enum ContentType {
    CHANGE_CIPHER_SPEC = 20,
    ALERT = 21,
    HANDSHAKE = 22,
    APPLICATION_DATA = 23,
    HEARTBEAT = 24,
    V2_ERROR = 300,
    V2_CLIENT_HELLO = 301,
    V2_CLIENT_MASTER_KEY = 302,
    V2_SERVER_HELLO = 304,
    UNKNOWN_OR_V2_ENCRYPTED = 400,
};
// NOLINTNEXTLINE(performance-enum-size)
enum SSLVersions {
    UNKNOWN_VERSION = 0,
    SSLv20 = 2,
    SSLv30 = 768,
    TLSv10 = 769,
    TLSv11 = 770,
    TLSv12 = 771,
    TLSv13 = 772,
    TLSv13_draft = 32512,
    DTLSv10 = 65279,
    DTLSv12 = 65277,
    DTLSv13 = 65276,
};
// NOLINTNEXTLINE(performance-enum-size)
enum SSLExtensions {
    EXT_SERVER_NAME = 0,
    EXT_MAX_FRAGMENT_LENGTH = 1,
    EXT_CLIENT_CERTIFICATE_URL = 2,
    EXT_TRUSTED_CA_KEYS = 3,
    EXT_TRUNCATED_HMAC = 4,
    EXT_STATUS_REQUEST = 5,
    EXT_USER_MAPPING = 6,
    EXT_CLIENT_AUTHZ = 7,
    EXT_SERVER_AUTHZ = 8,
    EXT_CERT_TYPE = 9,
    EXT_ELLIPTIC_CURVES = 10,
    EXT_EC_POINT_FORMATS = 11,
    EXT_SRP = 12,
    EXT_SIGNATURE_ALGORITHMS = 13,
    EXT_USE_SRTP = 14,
    EXT_HEARTBEAT = 15,
    EXT_APPLICATION_LAYER_PROTOCOL_NEGOTIATION = 16,
    EXT_STATUS_REQUEST_V2 = 17,
    EXT_SIGNED_CERTIFICATE_TIMESTAMP = 18,
    EXT_SESSIONTICKET_TLS = 35,
    EXT_KEY_SHARE_OLD = 40,
    EXT_PRE_SHARED_KEY = 41,
    EXT_EARLY_DATA = 42,
    EXT_SUPPORTED_VERSIONS = 43,
    EXT_COOKIE = 44,
    EXT_PSK_KEY_EXCHANGE_MODES = 45,
    EXT_TICKET_EARLY_DATA_INFO = 46,
    EXT_CERTIFICATE_AUTHORITIES = 47,
    EXT_OID_FILTERS = 48,
    EXT_KEY_SHARE = 51,
    EXT_CONNECTION_ID = 54,
    EXT_NEXT_PROTOCOL_NEGOTIATION = 13172,
    EXT_ORIGIN_BOUND_CERTIFICATES = 13175,
    EXT_ENCRYPTED_CLIENT_CERTIFICATES = 13180,
    EXT_CHANNEL_ID = 30031,
    EXT_CHANNEL_ID_NEW = 30032,
    EXT_PADDING = 35655,
    EXT_RENEGOTIATION_INFO = 65281,
};
// NOLINTNEXTLINE(performance-enum-size)
enum ECCurveType {
    EXPLICIT_PRIME = 1,
    EXPLICIT_CHAR = 2,
    NAMED_CURVE = 3,
};
// NOLINTNEXTLINE(performance-enum-size)
enum TLSCiphers {
    NO_CHOSEN_CIPHER = 16777215,
    TLS_NULL_WITH_NULL_NULL = 0,
    TLS_RSA_WITH_NULL_MD5 = 1,
    TLS_RSA_WITH_NULL_SHA = 2,
    TLS_RSA_EXPORT_WITH_RC4_40_MD5 = 3,
    TLS_RSA_WITH_RC4_128_MD5 = 4,
    TLS_RSA_WITH_RC4_128_SHA = 5,
    TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5 = 6,
    TLS_RSA_WITH_IDEA_CBC_SHA = 7,
    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA = 8,
    TLS_RSA_WITH_DES_CBC_SHA = 9,
    TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10,
    TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA = 11,
    TLS_DH_DSS_WITH_DES_CBC_SHA = 12,
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13,
    TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA = 14,
    TLS_DH_RSA_WITH_DES_CBC_SHA = 15,
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16,
    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA = 17,
    TLS_DHE_DSS_WITH_DES_CBC_SHA = 18,
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19,
    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA = 20,
    TLS_DHE_RSA_WITH_DES_CBC_SHA = 21,
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22,
    TLS_DH_ANON_EXPORT_WITH_RC4_40_MD5 = 23,
    TLS_DH_ANON_WITH_RC4_128_MD5 = 24,
    TLS_DH_ANON_EXPORT_WITH_DES40_CBC_SHA = 25,
    TLS_DH_ANON_WITH_DES_CBC_SHA = 26,
    TLS_DH_ANON_WITH_3DES_EDE_CBC_SHA = 27,
    SSL_FORTEZZA_KEA_WITH_NULL_SHA = 28,
    SSL_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA = 29,
    TLS_KRB5_WITH_DES_CBC_SHA = 30,
    TLS_KRB5_WITH_3DES_EDE_CBC_SHA = 31,
    TLS_KRB5_WITH_RC4_128_SHA = 32,
    TLS_KRB5_WITH_IDEA_CBC_SHA = 33,
    TLS_KRB5_WITH_DES_CBC_MD5 = 34,
    TLS_KRB5_WITH_3DES_EDE_CBC_MD5 = 35,
    TLS_KRB5_WITH_RC4_128_MD5 = 36,
    TLS_KRB5_WITH_IDEA_CBC_MD5 = 37,
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA = 38,
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA = 39,
    TLS_KRB5_EXPORT_WITH_RC4_40_SHA = 40,
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5 = 41,
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5 = 42,
    TLS_KRB5_EXPORT_WITH_RC4_40_MD5 = 43,
    TLS_RSA_WITH_AES_128_CBC_SHA = 47,
    TLS_DH_DSS_WITH_AES_128_CBC_SHA = 48,
    TLS_DH_RSA_WITH_AES_128_CBC_SHA = 49,
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50,
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51,
    TLS_DH_ANON_WITH_AES_128_CBC_SHA = 52,
    TLS_RSA_WITH_AES_256_CBC_SHA = 53,
    TLS_DH_DSS_WITH_AES_256_CBC_SHA = 54,
    TLS_DH_RSA_WITH_AES_256_CBC_SHA = 55,
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56,
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57,
    TLS_DH_ANON_WITH_AES_256_CBC_SHA = 58,
    TLS_RSA_WITH_NULL_SHA256 = 59,
    TLS_RSA_WITH_AES_128_CBC_SHA256 = 60,
    TLS_RSA_WITH_AES_256_CBC_SHA256 = 61,
    TLS_DH_DSS_WITH_AES_128_CBC_SHA256 = 62,
    TLS_DH_RSA_WITH_AES_128_CBC_SHA256 = 63,
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256 = 64,
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA = 65,
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA = 66,
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA = 67,
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA = 68,
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA = 69,
    TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA = 70,
    TLS_RSA_EXPORT1024_WITH_RC4_56_MD5 = 96,
    TLS_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 = 97,
    TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA = 98,
    TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA = 99,
    TLS_RSA_EXPORT1024_WITH_RC4_56_SHA = 100,
    TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA = 101,
    TLS_DHE_DSS_WITH_RC4_128_SHA = 102,
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256 = 103,
    TLS_DH_DSS_WITH_AES_256_CBC_SHA256 = 104,
    TLS_DH_RSA_WITH_AES_256_CBC_SHA256 = 105,
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256 = 106,
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256 = 107,
    TLS_DH_ANON_WITH_AES_128_CBC_SHA256 = 108,
    TLS_DH_ANON_WITH_AES_256_CBC_SHA256 = 109,
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_RMD = 114,
    TLS_DHE_DSS_WITH_AES_128_CBC_RMD = 115,
    TLS_DHE_DSS_WITH_AES_256_CBC_RMD = 116,
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_RMD = 119,
    TLS_DHE_RSA_WITH_AES_128_CBC_RMD = 120,
    TLS_DHE_RSA_WITH_AES_256_CBC_RMD = 121,
    TLS_RSA_WITH_3DES_EDE_CBC_RMD = 124,
    TLS_RSA_WITH_AES_128_CBC_RMD = 125,
    TLS_RSA_WITH_AES_256_CBC_RMD = 126,
    TLS_GOSTR341094_WITH_28147_CNT_IMIT = 128,
    TLS_GOSTR341001_WITH_28147_CNT_IMIT = 129,
    TLS_GOSTR341094_WITH_NULL_GOSTR3411 = 130,
    TLS_GOSTR341001_WITH_NULL_GOSTR3411 = 131,
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA = 132,
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA = 133,
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA = 134,
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA = 135,
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA = 136,
    TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA = 137,
    TLS_PSK_WITH_RC4_128_SHA = 138,
    TLS_PSK_WITH_3DES_EDE_CBC_SHA = 139,
    TLS_PSK_WITH_AES_128_CBC_SHA = 140,
    TLS_PSK_WITH_AES_256_CBC_SHA = 141,
    TLS_DHE_PSK_WITH_RC4_128_SHA = 142,
    TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA = 143,
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA = 144,
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA = 145,
    TLS_RSA_PSK_WITH_RC4_128_SHA = 146,
    TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA = 147,
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA = 148,
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA = 149,
    TLS_RSA_WITH_SEED_CBC_SHA = 150,
    TLS_DH_DSS_WITH_SEED_CBC_SHA = 151,
    TLS_DH_RSA_WITH_SEED_CBC_SHA = 152,
    TLS_DHE_DSS_WITH_SEED_CBC_SHA = 153,
    TLS_DHE_RSA_WITH_SEED_CBC_SHA = 154,
    TLS_DH_ANON_WITH_SEED_CBC_SHA = 155,
    TLS_RSA_WITH_AES_128_GCM_SHA256 = 156,
    TLS_RSA_WITH_AES_256_GCM_SHA384 = 157,
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256 = 158,
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384 = 159,
    TLS_DH_RSA_WITH_AES_128_GCM_SHA256 = 160,
    TLS_DH_RSA_WITH_AES_256_GCM_SHA384 = 161,
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256 = 162,
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384 = 163,
    TLS_DH_DSS_WITH_AES_128_GCM_SHA256 = 164,
    TLS_DH_DSS_WITH_AES_256_GCM_SHA384 = 165,
    TLS_DH_ANON_WITH_AES_128_GCM_SHA256 = 166,
    TLS_DH_ANON_WITH_AES_256_GCM_SHA384 = 167,
    TLS_PSK_WITH_AES_128_GCM_SHA256 = 168,
    TLS_PSK_WITH_AES_256_GCM_SHA384 = 169,
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256 = 170,
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384 = 171,
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256 = 172,
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384 = 173,
    TLS_PSK_WITH_AES_128_CBC_SHA256 = 174,
    TLS_PSK_WITH_AES_256_CBC_SHA384 = 175,
    TLS_PSK_WITH_NULL_SHA256 = 176,
    TLS_PSK_WITH_NULL_SHA384 = 177,
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256 = 178,
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384 = 179,
    TLS_DHE_PSK_WITH_NULL_SHA256 = 180,
    TLS_DHE_PSK_WITH_NULL_SHA384 = 181,
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256 = 182,
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384 = 183,
    TLS_RSA_PSK_WITH_NULL_SHA256 = 184,
    TLS_RSA_PSK_WITH_NULL_SHA384 = 185,
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 186,
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 187,
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 188,
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256 = 189,
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 190,
    TLS_DH_ANON_WITH_CAMELLIA_128_CBC_SHA256 = 191,
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 192,
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 193,
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 194,
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256 = 195,
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256 = 196,
    TLS_DH_ANON_WITH_CAMELLIA_256_CBC_SHA256 = 197,
    TLS_SM4_GCM_SM3 = 198,
    TLS_SM4_CCM_SM3 = 199,
    TLS_AES_128_GCM_SHA256 = 4865,
    TLS_AES_256_GCM_SHA384 = 4866,
    TLS_CHACHA20_POLY1305_SHA256 = 4867,
    TLS_AES_128_CCM_SHA256 = 4868,
    TLS_AES_128_CCM_8_SHA256 = 4869,
    TLS_AEGIS_256_SHA384 = 4870,
    TLS_AEGIS_128L_SHA256 = 4871,
    TLS_CECPQ1_RSA_WITH_CHACHA20_POLY1305_SHA256 = 5815,
    TLS_CECPQ1_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 5816,
    TLS_CECPQ1_RSA_WITH_AES_256_GCM_SHA384 = 5817,
    TLS_CECPQ1_ECDSA_WITH_AES_256_GCM_SHA384 = 5818,
    TLS_FALLBACK_SCSV = 22016,
    TLS_ECDH_ECDSA_WITH_NULL_SHA = 49153,
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA = 49154,
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA = 49155,
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA = 49156,
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA = 49157,
    TLS_ECDHE_ECDSA_WITH_NULL_SHA = 49158,
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA = 49159,
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA = 49160,
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA = 49161,
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA = 49162,
    TLS_ECDH_RSA_WITH_NULL_SHA = 49163,
    TLS_ECDH_RSA_WITH_RC4_128_SHA = 49164,
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA = 49165,
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA = 49166,
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA = 49167,
    TLS_ECDHE_RSA_WITH_NULL_SHA = 49168,
    TLS_ECDHE_RSA_WITH_RC4_128_SHA = 49169,
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA = 49170,
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA = 49171,
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA = 49172,
    TLS_ECDH_ANON_WITH_NULL_SHA = 49173,
    TLS_ECDH_ANON_WITH_RC4_128_SHA = 49174,
    TLS_ECDH_ANON_WITH_3DES_EDE_CBC_SHA = 49175,
    TLS_ECDH_ANON_WITH_AES_128_CBC_SHA = 49176,
    TLS_ECDH_ANON_WITH_AES_256_CBC_SHA = 49177,
    TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 49178,
    TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 49179,
    TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 49180,
    TLS_SRP_SHA_WITH_AES_128_CBC_SHA = 49181,
    TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 49182,
    TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 49183,
    TLS_SRP_SHA_WITH_AES_256_CBC_SHA = 49184,
    TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 49185,
    TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 49186,
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 = 49187,
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384 = 49188,
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256 = 49189,
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384 = 49190,
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 = 49191,
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 = 49192,
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256 = 49193,
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384 = 49194,
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 = 49195,
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 = 49196,
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 = 49197,
    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 = 49198,
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 = 49199,
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 = 49200,
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256 = 49201,
    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384 = 49202,
    TLS_ECDHE_PSK_WITH_RC4_128_SHA = 49203,
    TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA = 49204,
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA = 49205,
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA = 49206,
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256 = 49207,
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384 = 49208,
    TLS_ECDHE_PSK_WITH_NULL_SHA = 49209,
    TLS_ECDHE_PSK_WITH_NULL_SHA256 = 49210,
    TLS_ECDHE_PSK_WITH_NULL_SHA384 = 49211,
    TLS_RSA_WITH_ARIA_128_CBC_SHA256 = 49212,
    TLS_RSA_WITH_ARIA_256_CBC_SHA384 = 49213,
    TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256 = 49214,
    TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384 = 49215,
    TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256 = 49216,
    TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384 = 49217,
    TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256 = 49218,
    TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384 = 49219,
    TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256 = 49220,
    TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384 = 49221,
    TLS_DH_ANON_WITH_ARIA_128_CBC_SHA256 = 49222,
    TLS_DH_ANON_WITH_ARIA_256_CBC_SHA384 = 49223,
    TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256 = 49224,
    TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384 = 49225,
    TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256 = 49226,
    TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384 = 49227,
    TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256 = 49228,
    TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384 = 49229,
    TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256 = 49230,
    TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384 = 49231,
    TLS_RSA_WITH_ARIA_128_GCM_SHA256 = 49232,
    TLS_RSA_WITH_ARIA_256_GCM_SHA384 = 49233,
    TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256 = 49234,
    TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384 = 49235,
    TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256 = 49236,
    TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384 = 49237,
    TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256 = 49238,
    TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384 = 49239,
    TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256 = 49240,
    TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384 = 49241,
    TLS_DH_ANON_WITH_ARIA_128_GCM_SHA256 = 49242,
    TLS_DH_ANON_WITH_ARIA_256_GCM_SHA384 = 49243,
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256 = 49244,
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384 = 49245,
    TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256 = 49246,
    TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384 = 49247,
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256 = 49248,
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384 = 49249,
    TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256 = 49250,
    TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384 = 49251,
    TLS_PSK_WITH_ARIA_128_CBC_SHA256 = 49252,
    TLS_PSK_WITH_ARIA_256_CBC_SHA384 = 49253,
    TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256 = 49254,
    TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384 = 49255,
    TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256 = 49256,
    TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384 = 49257,
    TLS_PSK_WITH_ARIA_128_GCM_SHA256 = 49258,
    TLS_PSK_WITH_ARIA_256_GCM_SHA384 = 49259,
    TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256 = 49260,
    TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384 = 49261,
    TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256 = 49262,
    TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384 = 49263,
    TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256 = 49264,
    TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384 = 49265,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 49266,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 49267,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256 = 49268,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384 = 49269,
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 49270,
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 49271,
    TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256 = 49272,
    TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384 = 49273,
    TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49274,
    TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49275,
    TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49276,
    TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49277,
    TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49278,
    TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49279,
    TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 49280,
    TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 49281,
    TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256 = 49282,
    TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384 = 49283,
    TLS_DH_ANON_WITH_CAMELLIA_128_GCM_SHA256 = 49284,
    TLS_DH_ANON_WITH_CAMELLIA_256_GCM_SHA384 = 49285,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 49286,
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 49287,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256 = 49288,
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384 = 49289,
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49290,
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49291,
    TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256 = 49292,
    TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384 = 49293,
    TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49294,
    TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49295,
    TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49296,
    TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49297,
    TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256 = 49298,
    TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384 = 49299,
    TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49300,
    TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49301,
    TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49302,
    TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49303,
    TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49304,
    TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49305,
    TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256 = 49306,
    TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384 = 49307,
    TLS_RSA_WITH_AES_128_CCM = 49308,
    TLS_RSA_WITH_AES_256_CCM = 49309,
    TLS_DHE_RSA_WITH_AES_128_CCM = 49310,
    TLS_DHE_RSA_WITH_AES_256_CCM = 49311,
    TLS_RSA_WITH_AES_128_CCM_8 = 49312,
    TLS_RSA_WITH_AES_256_CCM_8 = 49313,
    TLS_DHE_RSA_WITH_AES_128_CCM_8 = 49314,
    TLS_DHE_RSA_WITH_AES_256_CCM_8 = 49315,
    TLS_PSK_WITH_AES_128_CCM = 49316,
    TLS_PSK_WITH_AES_256_CCM = 49317,
    TLS_DHE_PSK_WITH_AES_128_CCM = 49318,
    TLS_DHE_PSK_WITH_AES_256_CCM = 49319,
    TLS_PSK_WITH_AES_128_CCM_8 = 49320,
    TLS_PSK_WITH_AES_256_CCM_8 = 49321,
    TLS_PSK_DHE_WITH_AES_128_CCM_8 = 49322,
    TLS_PSK_DHE_WITH_AES_256_CCM_8 = 49323,
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM = 49324,
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM = 49325,
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8 = 49326,
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8 = 49327,
    TLS_ECCPWD_WITH_AES_128_GCM_SHA256 = 49328,
    TLS_ECCPWD_WITH_AES_256_GCM_SHA384 = 49329,
    TLS_ECCPWD_WITH_AES_128_CCM_SHA256 = 49330,
    TLS_ECCPWD_WITH_AES_256_CCM_SHA384 = 49331,
    TLS_SHA256_SHA256 = 49332,
    TLS_SHA384_SHA384 = 49333,
    TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC = 49408,
    TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC = 49409,
    TLS_GOSTR341112_256_WITH_28147_CNT_IMIT = 49410,
    TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L = 49411,
    TLS_GOSTR341112_256_WITH_MAGMA_MGM_L = 49412,
    TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S = 49413,
    TLS_GOSTR341112_256_WITH_MAGMA_MGM_S = 49414,
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256_OLD = 52243,
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256_OLD = 52244,
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256_OLD = 52245,
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52392,
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 52393,
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256 = 52394,
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52395,
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52396,
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52397,
    TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256 = 52398,
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256_OLD = 53252,
    TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256 = 53249,
    TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384 = 53250,
    TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256 = 53251,
    TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256 = 53253,
    SSL_RSA_FIPS_WITH_DES_CBC_SHA = 65278,
    SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA = 65279,
    SSL_RSA_FIPS_WITH_DES_CBC_SHA_2 = 65505,
    SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA_2 = 65504,
    SSL_RSA_WITH_RC2_CBC_MD5 = 65408,
    SSL_RSA_WITH_IDEA_CBC_MD5 = 65409,
    SSL_RSA_WITH_DES_CBC_MD5 = 65410,
    SSL_RSA_WITH_3DES_EDE_CBC_MD5 = 65411,
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV = 255,
};
} // namespace SSL

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace SSL {

class ContextSSL final {
public:
    ContextSSL(SSL_Conn* connection, SSL_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextSSL();

    // Member access functions
    SSL_Conn* connection() const { return connection_; }
    SSL_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    SSL_Conn* connection_;
    SSL_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class SSL_Conn final : public binpac::ConnectionAnalyzer {
public:
    SSL_Conn(SSLAnalyzer const& zeek_analyzer);
    ~SSL_Conn() override;

    // Member access functions
    SSL_Flow* upflow() const { return upflow_; }
    SSL_Flow* downflow() const { return downflow_; }
    SSLAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    int client_state();
    int server_state();
    int state(bool is_orig);
    bool startEncryption(bool is_orig);
    int determine_tls13();
    int cap_alert_messages_length(int record_length);
    int determine_state(bool is_orig, int content_type);
    int determine_ssl_record_layer(uint8 head0, uint8 head1, uint8 head2, uint8 head3, uint8 head4, bool is_orig);
    uint16 record_version();
    bool setEstablished();
    bool proc_alert(SSLRecord* rec, int level, int desc);
    bool proc_unknown_record(SSLRecord* rec);
    bool proc_ciphertext_record(SSLRecord* rec, const_bytestring const& cont);
    bool proc_plaintext_record(SSLRecord* rec);
    bool proc_heartbeat(SSLRecord* rec, uint8 type, uint16 payload_length, bytestring const& data);
    bool proc_check_v2_server_hello_version(uint16 version);
    bool proc_ccs(SSLRecord* rec);
    bool proc_certificate(bool is_orig, bool is_flipped, vector<bytestring>* certificates);
    bool proc_client_hello(uint16 version, double ts, bytestring const& client_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, vector<uint8>* compression_methods);
    bool proc_server_hello(uint16 version, bool v2, bytestring const& server_random, vector<uint8>* session_id, vector<uint16>* cipher_suites16, vector<uint24*>* cipher_suites24, uint8 comp_method);
    bool proc_v2_certificate(bool is_orig, bytestring const& cert);
    bool proc_v2_client_master_key(SSLRecord* rec, int cipher_kind);
    bool proc_handshake(SSLRecord* rec, bytestring const& data, bool is_orig);

protected:

    // Additional members

		int client_state_;
		int server_state_;
		int record_layer_version_;
	

		int established_;
		int decryption_failed_;
	
    SSL_Flow* upflow_;
    SSL_Flow* downflow_;
    SSLAnalyzer zeek_analyzer_;
};


class PlaintextRecord final {
public:
    PlaintextRecord(SSLRecord* rec);
    ~PlaintextRecord();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    ChangeCipherSpec* ch_cipher() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:7:ch_cipher", (int64)val_case_index(), "CHANGE_CIPHER_SPEC");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ch_cipher_;
    }
    Alerts* alerts() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)21):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:8:alerts", (int64)val_case_index(), "ALERT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return alerts_;
    }
    Heartbeat* heartbeat() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)24):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:9:heartbeat", (int64)val_case_index(), "HEARTBEAT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return heartbeat_;
    }
    ApplicationData* app_data() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)23):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-dtls-protocol.pac:10:app_data", (int64)val_case_index(), "APPLICATION_DATA");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return app_data_;
    }
    UnknownRecord* unknown_record() const {
        return unknown_record_;
    }
    Handshake* handshake() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)22):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:44:handshake", (int64)val_case_index(), "HANDSHAKE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return handshake_;
    }
    V2Error* v2_error() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)300):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:45:v2_error", (int64)val_case_index(), "V2_ERROR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v2_error_;
    }
    V2ClientHello* v2_client_hello() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)301):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:46:v2_client_hello", (int64)val_case_index(), "V2_CLIENT_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v2_client_hello_;
    }
    V2ClientMasterKey* v2_client_master_key() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)302):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:47:v2_client_master_key", (int64)val_case_index(), "V2_CLIENT_MASTER_KEY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v2_client_master_key_;
    }
    V2ServerHello* v2_server_hello() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)304):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:48:v2_server_hello", (int64)val_case_index(), "V2_SERVER_HELLO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return v2_server_hello_;
    }
    SSLRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    int val_case_index_;
    ChangeCipherSpec* ch_cipher_;
    Alerts* alerts_;
    Heartbeat* heartbeat_;
    ApplicationData* app_data_;
    UnknownRecord* unknown_record_;
    Handshake* handshake_;
    V2Error* v2_error_;
    V2ClientHello* v2_client_hello_;
    V2ClientMasterKey* v2_client_master_key_;
    V2ServerHello* v2_server_hello_;
    SSLRecord* rec_;
    bool proc_;
};


class ChangeCipherSpec final {
public:
    ChangeCipherSpec(SSLRecord* rec);
    ~ChangeCipherSpec();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    uint8 type() const { return type_; }
    SSLRecord* rec() const { return rec_; }
    bool state_changed() const { return state_changed_; }
    bool proc() const { return proc_; }

protected:
    uint8 type_;
    SSLRecord* rec_;
    bool state_changed_;
    bool proc_;
};


class Alerts final {
public:
    Alerts(SSLRecord* rec);
    ~Alerts();
    int initial_buffer_length() const { return 0; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    vector<Alert*>* alerts() const { return alerts_; }
    SSLRecord* rec() const { return rec_; }

protected:
    vector<Alert*>* alerts_;
    Alert* alerts__elem_;
    const_bytestring rest_;
    SSLRecord* rec_;
};


class Alert final {
public:
    Alert(SSLRecord* rec);
    ~Alert();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    uint8 level() const { return level_; }
    uint8 description() const { return description_; }
    SSLRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 level_;
    uint8 description_;
    SSLRecord* rec_;
    bool proc_;
};


class ApplicationData final {
public:
    ApplicationData(SSLRecord* rec);
    ~ApplicationData();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    SSLRecord* rec() const { return rec_; }

protected:
    const_bytestring data_;
    SSLRecord* rec_;
};


class Heartbeat final {
public:
    Heartbeat(SSLRecord* rec);
    ~Heartbeat();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder);

    // Member access functions
    uint8 type() const { return type_; }
    uint16 payload_length() const { return payload_length_; }
    bytestring const& data() const { return data_; }
    SSLRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    uint8 type_;
    uint16 payload_length_;
    bytestring data_;
    SSLRecord* rec_;
    bool proc_;
};


class UnknownRecord final {
public:
    UnknownRecord(SSLRecord* rec);
    ~UnknownRecord();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    SSLRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring cont_;
    SSLRecord* rec_;
    bool proc_;
};


class CiphertextRecord final {
public:
    CiphertextRecord(SSLRecord* rec);
    ~CiphertextRecord();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    SSLRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring cont_;
    SSLRecord* rec_;
    bool proc_;
};


class SSLRecord final {
public:
    SSLRecord(bool is_orig);
    ~SSLRecord();
    int initial_buffer_length() const { return 5; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSL* t_context);

    // Member access functions
    uint8 head0() const { return head0_; }
    uint8 head1() const { return head1_; }
    uint8 head2() const { return head2_; }
    uint8 head3() const { return head3_; }
    uint8 head4() const { return head4_; }
    vector<RecordText*>* rec() const { return rec_; }
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }
    int record_layer_version() const { return record_layer_version_; }
    uint16 raw_tls_version() const { return raw_tls_version_; }
    int content_type() const { return content_type_; }
    int length() const { return length_; }

protected:
    uint8 head0_;
    uint8 head1_;
    uint8 head2_;
    uint8 head3_;
    uint8 head4_;
    vector<RecordText*>* rec_;
    RecordText* rec__elem_;
    bool is_orig_;
    int byteorder_;
    int record_layer_version_;
    uint16 raw_tls_version_;
    int content_type_;
    int length_;
    int buffering_state_;
};


class RecordText final {
public:
    RecordText(SSLRecord* rec);
    ~RecordText();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder);

    // Member access functions
    int val_case_index() const	{ return val_case_index_; }
    CiphertextRecord* ciphertext() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( val_case_index() ) {
            case ((int)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/ssl/ssl-protocol.pac:38:ciphertext", (int64)val_case_index(), "STATE_ENCRYPTED");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ciphertext_;
    }
    PlaintextRecord* plaintext() const {
        return plaintext_;
    }
    SSLRecord* rec() const { return rec_; }

protected:
    int val_case_index_;
    CiphertextRecord* ciphertext_;
    PlaintextRecord* plaintext_;
    SSLRecord* rec_;
};


class Handshake final {
public:
    Handshake(SSLRecord* rec);
    ~Handshake();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    bytestring const& data() const { return data_; }
    SSLRecord* rec() const { return rec_; }
    bool proc() const { return proc_; }

protected:
    bytestring data_;
    SSLRecord* rec_;
    bool proc_;
};


class V2Error final {
public:
    V2Error(SSLRecord* rec);
    ~V2Error();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context);

    // Member access functions
    SSLRecord* rec() const { return rec_; }
    uint16 error_code() const { return error_code_; }
    bool proc() const { return proc_; }

protected:
    const_bytestring data_;
    SSLRecord* rec_;
    uint16 error_code_;
    bool proc_;
};


class V2ClientHello final {
public:
    V2ClientHello(SSLRecord* rec);
    ~V2ClientHello();
    int initial_buffer_length() const { return 6; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder);

    // Member access functions
    uint16 csuit_len() const { return csuit_len_; }
    uint16 session_len() const { return session_len_; }
    uint16 chal_len() const { return chal_len_; }
    vector<uint24*>* ciphers() const { return ciphers_; }
    vector<uint8>* session_id() const { return session_id_; }
    bytestring const& challenge() const { return challenge_; }
    SSLRecord* rec() const { return rec_; }
    int client_version() const { return client_version_; }
    bool proc() const { return proc_; }

protected:
    uint16 csuit_len_;
    uint16 session_len_;
    uint16 chal_len_;
    vector<uint24*>* ciphers_;
    uint24* ciphers__elem_;
    vector<uint8>* session_id_;
    uint8 session_id__elem_;
    bytestring challenge_;
    SSLRecord* rec_;
    int client_version_;
    bool proc_;
};


class V2ServerHello final {
public:
    V2ServerHello(SSLRecord* rec);
    ~V2ServerHello();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder);

    // Member access functions
    uint16 server_version() const { return server_version_; }
    uint16 cert_len() const { return cert_len_; }
    uint16 ciphers_len() const { return ciphers_len_; }
    uint16 conn_id_len() const { return conn_id_len_; }
    bytestring const& cert_data() const { return cert_data_; }
    vector<uint24*>* ciphers() const { return ciphers_; }
    bytestring const& conn_id_data() const { return conn_id_data_; }
    SSLRecord* rec() const { return rec_; }
    uint8 session_id_hit() const { return session_id_hit_; }
    uint8 cert_type() const { return cert_type_; }
    bool check_v2() const { return check_v2_; }
    bool proc() const { BINPAC_ASSERT(has_proc()); return proc_; }
    bool has_proc() const { return has_proc_; }
    bool cert() const { BINPAC_ASSERT(has_cert()); return cert_; }
    bool has_cert() const { return has_cert_; }

protected:
    uint16 server_version_;
    uint16 cert_len_;
    uint16 ciphers_len_;
    uint16 conn_id_len_;
    bytestring cert_data_;
    vector<uint24*>* ciphers_;
    uint24* ciphers__elem_;
    bytestring conn_id_data_;
    SSLRecord* rec_;
    uint8 session_id_hit_;
    uint8 cert_type_;
    bool check_v2_;
    bool proc_;
    bool has_proc_;
    bool cert_;
    bool has_cert_;
};


class V2ClientMasterKey final {
public:
    V2ClientMasterKey(SSLRecord* rec);
    ~V2ClientMasterKey();
    int initial_buffer_length() const { return 7; }
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextSSL* t_context, int t_byteorder);

    // Member access functions
    uint8 cipher_kind_8() const { return cipher_kind_8_; }
    uint16 cl_key_len() const { return cl_key_len_; }
    uint16 en_key_len() const { return en_key_len_; }
    uint16 key_arg_len() const { return key_arg_len_; }
    SSLRecord* rec() const { return rec_; }
    int cipher_kind() const { return cipher_kind_; }
    bool state_changed_client() const { return state_changed_client_; }
    bool state_changed_server() const { return state_changed_server_; }
    bool proc() const { return proc_; }

protected:
    uint8 cipher_kind_8_;
    uint16 cl_key_len_;
    uint16 en_key_len_;
    uint16 key_arg_len_;
    const_bytestring cl_key_data_;
    const_bytestring en_key_data_;
    const_bytestring key_arg_data_;
    SSLRecord* rec_;
    int cipher_kind_;
    bool state_changed_client_;
    bool state_changed_server_;
    bool proc_;
};


class SSLPDU final {
public:
    SSLPDU(bool is_orig);
    ~SSLPDU();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextSSL* t_context);

    // Member access functions
    bool is_orig() const { return is_orig_; }
    int byteorder() const { return byteorder_; }

protected:
    vector<SSLRecord*>* records_;
    SSLRecord* records__elem_;
    int records__arraylength_;
    int records__elem__it_;
    bool is_orig_;
    int byteorder_;
    int parsing_state_;
};


class SSL_Flow final : public binpac::FlowAnalyzer {
public:
    SSL_Flow(SSL_Conn* connection, bool is_orig);
    ~SSL_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    SSL_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

protected:
    SSLPDU* dataunit_;
    ContextSSL* context_;
    FlowBuffer* flow_buffer_;
    SSL_Conn* connection_;
    bool is_orig_;
};


class uint24 final {
public:
    uint24();
    ~uint24();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 byte1() const { return byte1_; }
    uint8 byte2() const { return byte2_; }
    uint8 byte3() const { return byte3_; }

protected:
    uint8 byte1_;
    uint8 byte2_;
    uint8 byte3_;
};


class uint48 final {
public:
    uint48();
    ~uint48();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 byte1() const { return byte1_; }
    uint8 byte2() const { return byte2_; }
    uint8 byte3() const { return byte3_; }
    uint8 byte4() const { return byte4_; }
    uint8 byte5() const { return byte5_; }
    uint8 byte6() const { return byte6_; }

protected:
    uint8 byte1_;
    uint8 byte2_;
    uint8 byte3_;
    uint8 byte4_;
    uint8 byte5_;
    uint8 byte6_;
};


	string orig_label(bool is_orig);
	

	class to_int {
	public:
		int operator()(uint24 * num) const
		{
		return (num->byte1() << 16) | (num->byte2() << 8) | num->byte3();
		}

		uint64 operator()(uint48 * num) const
		{
		return ((uint64)num->byte1() << 40) | ((uint64)num->byte2() << 32) | ((uint64)num->byte3() << 24) |
		  ((uint64)num->byte4() << 16) | ((uint64)num->byte5() << 8) | (uint64)num->byte6();
		}
	};

zeek::StringVal* to_string_val(vector<uint8>* data);
bool version_ok(uint16 vers);
extern uint32 const MAX_DTLS_HANDSHAKE_RECORD;
} // namespace SSL
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_ssl_ssl_pac_h */
