// This file is automatically generated from /build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket.pac.

#ifndef _build_zeek_src_zeek_src_analyzer_protocol_websocket_websocket_pac_h
#define _build_zeek_src_zeek_src_analyzer_protocol_websocket_websocket_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include <array>

#include "zeek/analyzer/protocol/websocket/consts.bif.h"
#include "zeek/analyzer/protocol/websocket/events.bif.h"

namespace binpac {

namespace WebSocket {
class ContextWebSocket;
class WebSocket_Conn;
// NOLINTNEXTLINE(performance-enum-size)
enum Opcodes {
    OPCODE_CONTINUATION = 0,
    OPCODE_TEXT = 1,
    OPCODE_BINARY = 2,
    OPCODE_CLOSE = 8,
    OPCODE_PING = 9,
    OPCODE_PONG = 10,
};
class WebSocket_FrameHeader;
class WebSocket_FramePayloadClose;
class WebSocket_FramePayloadChunk;
class WebSocket_Frame;
class WebSocket_Message;
class WebSocket_Flow;
} // namespace WebSocket

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace WebSocket {

class ContextWebSocket final {
public:
    ContextWebSocket(WebSocket_Conn* connection, WebSocket_Flow* flow, FlowBuffer* flow_buffer);
    ~ContextWebSocket();

    // Member access functions
    WebSocket_Conn* connection() const { return connection_; }
    WebSocket_Flow* flow() const { return flow_; }
    FlowBuffer* flow_buffer() const { return flow_buffer_; }

protected:
    WebSocket_Conn* connection_;
    WebSocket_Flow* flow_;
    FlowBuffer* flow_buffer_;
};


class WebSocket_Conn final : public binpac::ConnectionAnalyzer {
public:
    WebSocket_Conn(ZeekAnalyzer const& zeek_analyzer);
    ~WebSocket_Conn() override;

    // Member access functions
    WebSocket_Flow* upflow() const { return upflow_; }
    WebSocket_Flow* downflow() const { return downflow_; }
    ZeekAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

protected:
    WebSocket_Flow* upflow_;
    WebSocket_Flow* downflow_;
    ZeekAnalyzer zeek_analyzer_;
};


class WebSocket_FrameHeader final {
public:
    WebSocket_FrameHeader(bool first_frame);
    ~WebSocket_FrameHeader();
    int initial_buffer_length() const { return 2; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context, int t_byteorder);

    // Member access functions
    uint16 first2() const { return first2_; }
    uint8 maybe_more_len_case_index() const	{ return maybe_more_len_case_index_; }
    uint16 payload_len2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( maybe_more_len_case_index() ) {
            case ((uint8)126):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket-protocol.pac:19:payload_len2", (int64)maybe_more_len_case_index(), "((int) 126)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return payload_len2_;
    }
    uint64 payload_len8() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( maybe_more_len_case_index() ) {
            case ((uint8)127):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket-protocol.pac:20:payload_len8", (int64)maybe_more_len_case_index(), "((int) 127)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return payload_len8_;
    }
    int maybe_masking_key_case_index() const	{ return maybe_masking_key_case_index_; }
    bytestring const& masking_key() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( maybe_masking_key_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket-protocol.pac:25:masking_key", (int64)maybe_masking_key_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return masking_key_;
    }
    bool first_frame() const { return first_frame_; }
    bool fin() const { return fin_; }
    uint8 reserved() const { return reserved_; }
    uint8 opcode() const { return opcode_; }
    uint8 payload_len1() const { return payload_len1_; }
    bool has_mask() const { return has_mask_; }
    uint64 rest_header_len() const { return rest_header_len_; }
    uint64 payload_len() const { return payload_len_; }
    int new_frame_payload() const { return new_frame_payload_; }
    int proc_header() const { return proc_header_; }

protected:
    uint16 first2_;
    uint8 maybe_more_len_case_index_;
    uint16 payload_len2_;
    uint64 payload_len8_;
    int maybe_masking_key_case_index_;
    bytestring masking_key_;
    bool first_frame_;
    bool fin_;
    uint8 reserved_;
    uint8 opcode_;
    uint8 payload_len1_;
    bool has_mask_;
    uint64 rest_header_len_;
    uint64 payload_len_;
    int new_frame_payload_;
    int proc_header_;
    int buffering_state_;
};


class WebSocket_FramePayloadClose final {
public:
    WebSocket_FramePayloadClose();
    ~WebSocket_FramePayloadClose();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextWebSocket* t_context);

    // Member access functions
    uint16 status() const { return status_; }
    bytestring const& reason() const { return reason_; }
    int byteorder() const { return byteorder_; }
    int proc_payload_close() const { return proc_payload_close_; }

protected:
    uint16 status_;
    bytestring reason_;
    int byteorder_;
    int proc_payload_close_;
};


class WebSocket_FramePayloadChunk final {
public:
    WebSocket_FramePayloadChunk(uint64 len, WebSocket_FrameHeader* hdr);
    ~WebSocket_FramePayloadChunk();
    int initial_buffer_length() const { return 0; }
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context);

    // Member access functions
    bytestring const& data() const { return data_; }
    uint64 len() const { return len_; }
    WebSocket_FrameHeader* hdr() const { return hdr_; }
    int consumed_payload() const { return consumed_payload_; }
    int payload_chunk() const { return payload_chunk_; }
    WebSocket_FramePayloadClose* close_payload() const { BINPAC_ASSERT(has_close_payload()); return close_payload_; }
    bool has_close_payload() const { return has_close_payload_; }

protected:
    bytestring data_;
    uint64 len_;
    WebSocket_FrameHeader* hdr_;
    int consumed_payload_;
    int payload_chunk_;
    WebSocket_FramePayloadClose* close_payload_;
    bool has_close_payload_;
    int buffering_state_;
};


class WebSocket_Frame final {
public:
    WebSocket_Frame(bool first_frame, WebSocket_Message* msg);
    ~WebSocket_Frame();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context, int t_byteorder);

    // Member access functions
    WebSocket_FrameHeader* hdr() const { return hdr_; }
    bool first_frame() const { return first_frame_; }
    WebSocket_Message* msg() const { return msg_; }
    int empty_close() const { BINPAC_ASSERT(has_empty_close()); return empty_close_; }
    bool has_empty_close() const { return has_empty_close_; }

protected:
    WebSocket_FrameHeader* hdr_;
    vector<WebSocket_FramePayloadChunk*>* chunks_;
    WebSocket_FramePayloadChunk* chunks__elem_;
    int chunks__arraylength_;
    int chunks__elem__it_;
    bool first_frame_;
    WebSocket_Message* msg_;
    int empty_close_;
    bool has_empty_close_;
    int parsing_state_;
};


class WebSocket_Message final {
public:
    WebSocket_Message();
    ~WebSocket_Message();
    bool ParseBuffer(flow_buffer_t t_flow_buffer, ContextWebSocket* t_context);

    // Member access functions
    WebSocket_Frame* first_frame() const { return first_frame_; }
    int optional_more_frames_case_index() const	{ return optional_more_frames_case_index_; }
    vector<WebSocket_Frame*>* more_frames() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( optional_more_frames_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/analyzer/protocol/websocket/websocket-protocol.pac:76:more_frames", (int64)optional_more_frames_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return more_frames_;
    }
    int byteorder() const { return byteorder_; }
    uint8 opcode() const { return opcode_; }
    int proc_message() const { return proc_message_; }

protected:
    WebSocket_Frame* first_frame_;
    int optional_more_frames_case_index_;
    vector<WebSocket_Frame*>* more_frames_;
    WebSocket_Frame* more_frames__elem_;
    int more_frames__arraylength_;
    int more_frames__elem__it_;
    int byteorder_;
    uint8 opcode_;
    int proc_message_;
    int parsing_state_;
};


class WebSocket_Flow final : public binpac::FlowAnalyzer {
public:
    WebSocket_Flow(WebSocket_Conn* connection, bool is_orig);
    ~WebSocket_Flow() override;

    // Member access functions
    FlowBuffer* flow_buffer() const { return flow_buffer_; }
    WebSocket_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    uint64 new_frame_payload(WebSocket_FrameHeader* hdr);
    uint64 remaining_frame_payload_len();
    uint64 consumed_chunk_len(uint64 len);
    uint64 next_chunk_len();
    bool process_message(WebSocket_Message* msg);
    bool process_header(WebSocket_FrameHeader* hdr);
    bool process_payload_close(WebSocket_FramePayloadClose* close);
    bool process_empty_close(WebSocket_FrameHeader* hdr);
    bool process_payload_chunk(WebSocket_FramePayloadChunk* chunk);

protected:
    WebSocket_Message* dataunit_;
    ContextWebSocket* context_;

    // Additional members

		bool has_mask_;
		uint64_t masking_key_idx_;
		uint64_t frame_payload_len_;
		std::array<uint8_t, 4> masking_key_;
		uint8_t effective_opcode_;
	
    FlowBuffer* flow_buffer_;
    WebSocket_Conn* connection_;
    bool is_orig_;
};

} // namespace WebSocket
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_analyzer_protocol_websocket_websocket_pac_h */
