// This file is automatically generated from /build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1.pac.

#ifndef _build_zeek_src_zeek_src_packet_analysis_protocol_gtpv1_gtpv1_pac_h
#define _build_zeek_src_zeek_src_packet_analysis_protocol_gtpv1_gtpv1_pac_h

#include <vector>

#include "binpac.h"


#include "zeek/binpac_zeek.h"


#include "zeek/IP.h"
#include "zeek/TunnelEncapsulation.h"
#include "zeek/Reporter.h"

#include "zeek/packet_analysis/protocol/gtpv1/events.bif.h"


#include "zeek/ZeekString.h"
#include "zeek/packet_analysis/protocol/gtpv1/GTPv1.h"

namespace binpac {

namespace GTPv1 {
class ContextGTPv1;
class GTPv1_Header;
class GTPv1_Opt_Header;
class GTPv1_Ext_Header;
// NOLINTNEXTLINE(performance-enum-size)
enum InfoElementType {
    TYPE_CAUSE = 1,
    TYPE_IMSI = 2,
    TYPE_RAI = 3,
    TYPE_TLLI = 4,
    TYPE_P_TMSI = 5,
    TYPE_REORDER_REQ = 8,
    TYPE_AUTHN_TRIPLET = 9,
    TYPE_MAP_CAUSE = 11,
    TYPE_P_TMSI_SIG = 12,
    TYPE_MS_VALID = 13,
    TYPE_RECOVERY = 14,
    TYPE_SELECTION_MODE = 15,
    TYPE_TEID1 = 16,
    TYPE_TEID_CONTROL_PLANE = 17,
    TYPE_TEID2 = 18,
    TYPE_TEARDOWN_IND = 19,
    TYPE_NSAPI = 20,
    TYPE_RANAP_CAUSE = 21,
    TYPE_RAB_CTX = 22,
    TYPE_RADIO_PRIORITY_SMS = 23,
    TYPE_RADIO_PRIORITY = 24,
    TYPE_PACKET_FLOW_ID = 25,
    TYPE_CHARGING_CHARACTERISTICS = 26,
    TYPE_TRACE_REFERENCE = 27,
    TYPE_TRACE_TYPE = 28,
    TYPE_MS_NOT_REACHABLE_REASON = 29,
    TYPE_CHARGING_ID = 127,
    TYPE_END_USER_ADDR = 128,
    TYPE_MM_CTX = 129,
    TYPE_PDP_CTX = 130,
    TYPE_ACCESS_POINT_NAME = 131,
    TYPE_PROTO_CONFIG_OPTIONS = 132,
    TYPE_GSN_ADDR = 133,
    TYPE_MSISDN = 134,
    TYPE_QOS_PROFILE = 135,
    TYPE_AUTHN_QUINTUPLET = 136,
    TYPE_TRAFFIC_FLOW_TEMPLATE = 137,
    TYPE_TARGET_ID = 138,
    TYPE_UTRAN_TRANSPARENT_CONTAINER = 139,
    TYPE_RAB_SETUP_INFO = 140,
    TYPE_EXT_HEADER_TYPE_LIST = 141,
    TYPE_TRIGGER_ID = 142,
    TYPE_OMC_ID = 143,
    TYPE_CHARGING_GATEWAY_ADDR = 251,
    TYPE_PRIVATE_EXT = 255,
};
class InformationElement;
class Cause;
class IMSI;
class RAI;
class TLLI;
class P_TMSI;
class ReorderReq;
class AuthN_Triplet;
class MAP_Cause;
class P_TMSI_Sig;
class MS_Valid;
class Recovery;
class SelectionMode;
class TEID1;
class TEID_ControlPlane;
class TEID2;
class TeardownInd;
class NSAPI;
class RANAP_Cause;
class RAB_Ctx;
class RadioPrioritySMS;
class RadioPriority;
class PacketFlowID;
class ChargingCharacteristics;
class TraceReference;
class TraceType;
class MS_Not_Reachable_Reason;
class ChargingID;
class EndUserAddr;
class MM_Ctx;
class PDP_Ctx;
class AP_Name;
class ProtoConfigOpts;
class GSN_Addr;
class MSISDN;
class QoS_Profile;
class AuthN_Quintuplet;
class TrafficFlowTemplate;
class TargetID;
class UTRAN_TransparentContainer;
class RAB_SetupInfo;
class ExtHdrTypeList;
class TriggerID;
class OMC_ID;
class ChargingGatewayAddr;
class PrivateExt;
class GTPv1_Conn;
class GTPv1_Flow;
} // namespace GTPv1

int bytestring_to_int(const_bytestring const& s, int base);
double bytestring_to_double(const_bytestring const& s);
int bytestring_casecmp(const_bytestring const& s1, const_charptr const& s2);
bool bytestring_caseprefix(const_bytestring const& s1, const_charptr const& s2);
double network_time();
namespace GTPv1 {

class ContextGTPv1 final {
public:
    ContextGTPv1(GTPv1_Conn* connection, GTPv1_Flow* flow);
    ~ContextGTPv1();

    // Member access functions
    GTPv1_Conn* connection() const { return connection_; }
    GTPv1_Flow* flow() const { return flow_; }

protected:
    GTPv1_Conn* connection_;
    GTPv1_Flow* flow_;
};


class GTPv1_Header final {
public:
    GTPv1_Header();
    ~GTPv1_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, ContextGTPv1* t_context);

    // Member access functions
    uint8 flags() const { return flags_; }
    uint8 msg_type() const { return msg_type_; }
    uint16 length() const { return length_; }
    uint32 teid() const { return teid_; }
    int opt_case_index() const	{ return opt_case_index_; }
    GTPv1_Opt_Header* opt_hdr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( opt_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:9:opt_hdr", (int64)opt_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return opt_hdr_;
    }
    int ext_case_index() const	{ return ext_case_index_; }
    vector<GTPv1_Ext_Header*>* ext_hdrs() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( ext_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:14:ext_hdrs", (int64)ext_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ext_hdrs_;
    }
    uint8 msg_case_index() const	{ return msg_case_index_; }
    vector<InformationElement*>* create_pdp_ctx_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:19:create_pdp_ctx_request", (int64)msg_case_index(), "((int) 16)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return create_pdp_ctx_request_;
    }
    vector<InformationElement*>* create_pdp_ctx_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:20:create_pdp_ctx_response", (int64)msg_case_index(), "((int) 17)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return create_pdp_ctx_response_;
    }
    vector<InformationElement*>* update_pdp_ctx_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)18):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:21:update_pdp_ctx_request", (int64)msg_case_index(), "((int) 18)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return update_pdp_ctx_request_;
    }
    vector<InformationElement*>* update_pdp_ctx_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)19):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:22:update_pdp_ctx_response", (int64)msg_case_index(), "((int) 19)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return update_pdp_ctx_response_;
    }
    vector<InformationElement*>* delete_pdp_ctx_request() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:23:delete_pdp_ctx_request", (int64)msg_case_index(), "((int) 20)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return delete_pdp_ctx_request_;
    }
    vector<InformationElement*>* delete_pdp_ctx_response() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)21):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:24:delete_pdp_ctx_response", (int64)msg_case_index(), "((int) 21)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return delete_pdp_ctx_response_;
    }
    bytestring const& packet() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( msg_case_index() ) {
            case ((uint8)255):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:25:packet", (int64)msg_case_index(), "((int) 255)");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return packet_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    int byteorder() const { return byteorder_; }
    uint8 version() const { return version_; }
    bool pt_flag() const { return pt_flag_; }
    bool rsv() const { return rsv_; }
    bool e_flag() const { return e_flag_; }
    bool s_flag() const { return s_flag_; }
    bool pn_flag() const { return pn_flag_; }
    bool has_opt() const { return has_opt_; }
    int proc_gtpv1() const { return proc_gtpv1_; }
    const_bytestring const& sourcedata() const { return sourcedata_; }

protected:
    uint8 flags_;
    uint8 msg_type_;
    uint16 length_;
    uint32 teid_;
    int opt_case_index_;
    GTPv1_Opt_Header* opt_hdr_;
    int ext_case_index_;
    vector<GTPv1_Ext_Header*>* ext_hdrs_;
    GTPv1_Ext_Header* ext_hdrs__elem_;
    uint8 msg_case_index_;
    vector<InformationElement*>* create_pdp_ctx_request_;
    InformationElement* create_pdp_ctx_request__elem_;
    vector<InformationElement*>* create_pdp_ctx_response_;
    InformationElement* create_pdp_ctx_response__elem_;
    vector<InformationElement*>* update_pdp_ctx_request_;
    InformationElement* update_pdp_ctx_request__elem_;
    vector<InformationElement*>* update_pdp_ctx_response_;
    InformationElement* update_pdp_ctx_response__elem_;
    vector<InformationElement*>* delete_pdp_ctx_request_;
    InformationElement* delete_pdp_ctx_request__elem_;
    vector<InformationElement*>* delete_pdp_ctx_response_;
    InformationElement* delete_pdp_ctx_response__elem_;
    bytestring packet_;
    bytestring unknown_;
    int byteorder_;
    uint8 version_;
    bool pt_flag_;
    bool rsv_;
    bool e_flag_;
    bool s_flag_;
    bool pn_flag_;
    bool has_opt_;
    int proc_gtpv1_;
    const_bytestring sourcedata_;
};


class GTPv1_Opt_Header final {
public:
    GTPv1_Opt_Header();
    ~GTPv1_Opt_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 seq() const { return seq_; }
    uint8 n_pdu() const { return n_pdu_; }
    uint8 next_type() const { return next_type_; }

protected:
    uint16 seq_;
    uint8 n_pdu_;
    uint8 next_type_;
};


class GTPv1_Ext_Header final {
public:
    GTPv1_Ext_Header();
    ~GTPv1_Ext_Header();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 length() const { return length_; }
    bytestring const& contents() const { return contents_; }
    uint8 next_type() const { return next_type_; }

protected:
    uint8 length_;
    bytestring contents_;
    uint8 next_type_;
};


class InformationElement final {
public:
    InformationElement();
    ~InformationElement();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 type() const { return type_; }
    int len_case_index() const	{ return len_case_index_; }
    uint16 tlv_len() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( len_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:103:tlv_len", (int64)len_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tlv_len_;
    }
    uint8 value_case_index() const	{ return value_case_index_; }
    Cause* cause() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)1):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:108:cause", (int64)value_case_index(), "TYPE_CAUSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return cause_;
    }
    IMSI* imsi() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)2):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:109:imsi", (int64)value_case_index(), "TYPE_IMSI");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return imsi_;
    }
    RAI* rai() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)3):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:110:rai", (int64)value_case_index(), "TYPE_RAI");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rai_;
    }
    TLLI* tlli() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)4):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:111:tlli", (int64)value_case_index(), "TYPE_TLLI");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return tlli_;
    }
    P_TMSI* p_tmsi() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)5):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:112:p_tmsi", (int64)value_case_index(), "TYPE_P_TMSI");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return p_tmsi_;
    }
    ReorderReq* reorder_req() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)8):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:113:reorder_req", (int64)value_case_index(), "TYPE_REORDER_REQ");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return reorder_req_;
    }
    AuthN_Triplet* authn_triplet() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)9):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:114:authn_triplet", (int64)value_case_index(), "TYPE_AUTHN_TRIPLET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return authn_triplet_;
    }
    MAP_Cause* map_cause() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)11):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:115:map_cause", (int64)value_case_index(), "TYPE_MAP_CAUSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return map_cause_;
    }
    P_TMSI_Sig* p_tmsi_sig() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)12):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:116:p_tmsi_sig", (int64)value_case_index(), "TYPE_P_TMSI_SIG");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return p_tmsi_sig_;
    }
    MS_Valid* ms_valid() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)13):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:117:ms_valid", (int64)value_case_index(), "TYPE_MS_VALID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ms_valid_;
    }
    Recovery* recovery() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)14):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:118:recovery", (int64)value_case_index(), "TYPE_RECOVERY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return recovery_;
    }
    SelectionMode* selection_mode() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)15):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:119:selection_mode", (int64)value_case_index(), "TYPE_SELECTION_MODE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return selection_mode_;
    }
    TEID1* teid1() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)16):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:120:teid1", (int64)value_case_index(), "TYPE_TEID1");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return teid1_;
    }
    TEID_ControlPlane* teidcp() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)17):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:121:teidcp", (int64)value_case_index(), "TYPE_TEID_CONTROL_PLANE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return teidcp_;
    }
    TEID2* teid2() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)18):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:122:teid2", (int64)value_case_index(), "TYPE_TEID2");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return teid2_;
    }
    TeardownInd* teardown_ind() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)19):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:123:teardown_ind", (int64)value_case_index(), "TYPE_TEARDOWN_IND");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return teardown_ind_;
    }
    NSAPI* nsapi() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)20):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:124:nsapi", (int64)value_case_index(), "TYPE_NSAPI");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return nsapi_;
    }
    RANAP_Cause* ranap_cause() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)21):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:125:ranap_cause", (int64)value_case_index(), "TYPE_RANAP_CAUSE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ranap_cause_;
    }
    RAB_Ctx* rab_ctx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)22):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:126:rab_ctx", (int64)value_case_index(), "TYPE_RAB_CTX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rab_ctx_;
    }
    RadioPrioritySMS* radio_priority_sms() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)23):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:127:radio_priority_sms", (int64)value_case_index(), "TYPE_RADIO_PRIORITY_SMS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return radio_priority_sms_;
    }
    RadioPriority* radio_priority() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)24):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:128:radio_priority", (int64)value_case_index(), "TYPE_RADIO_PRIORITY");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return radio_priority_;
    }
    PacketFlowID* packet_flow_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)25):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:129:packet_flow_id", (int64)value_case_index(), "TYPE_PACKET_FLOW_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return packet_flow_id_;
    }
    ChargingCharacteristics* charging_characteristics() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)26):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:130:charging_characteristics", (int64)value_case_index(), "TYPE_CHARGING_CHARACTERISTICS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return charging_characteristics_;
    }
    TraceReference* trace_reference() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)27):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:131:trace_reference", (int64)value_case_index(), "TYPE_TRACE_REFERENCE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return trace_reference_;
    }
    TraceType* trace_type() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)28):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:132:trace_type", (int64)value_case_index(), "TYPE_TRACE_TYPE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return trace_type_;
    }
    MS_Not_Reachable_Reason* ms_not_reachable_reason() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)29):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:133:ms_not_reachable_reason", (int64)value_case_index(), "TYPE_MS_NOT_REACHABLE_REASON");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ms_not_reachable_reason_;
    }
    ChargingID* charging_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)127):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:134:charging_id", (int64)value_case_index(), "TYPE_CHARGING_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return charging_id_;
    }
    EndUserAddr* end_user_addr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)128):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:135:end_user_addr", (int64)value_case_index(), "TYPE_END_USER_ADDR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return end_user_addr_;
    }
    MM_Ctx* mm_ctx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)129):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:136:mm_ctx", (int64)value_case_index(), "TYPE_MM_CTX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return mm_ctx_;
    }
    PDP_Ctx* pdp_ctx() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)130):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:137:pdp_ctx", (int64)value_case_index(), "TYPE_PDP_CTX");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return pdp_ctx_;
    }
    AP_Name* ap_name() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)131):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:138:ap_name", (int64)value_case_index(), "TYPE_ACCESS_POINT_NAME");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ap_name_;
    }
    ProtoConfigOpts* proto_config_opts() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)132):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:139:proto_config_opts", (int64)value_case_index(), "TYPE_PROTO_CONFIG_OPTIONS");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return proto_config_opts_;
    }
    GSN_Addr* gsn_addr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)133):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:140:gsn_addr", (int64)value_case_index(), "TYPE_GSN_ADDR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return gsn_addr_;
    }
    MSISDN* msisdn() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)134):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:141:msisdn", (int64)value_case_index(), "TYPE_MSISDN");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return msisdn_;
    }
    QoS_Profile* qos_profile() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)135):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:142:qos_profile", (int64)value_case_index(), "TYPE_QOS_PROFILE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return qos_profile_;
    }
    AuthN_Quintuplet* authn_quintuplet() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)136):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:143:authn_quintuplet", (int64)value_case_index(), "TYPE_AUTHN_QUINTUPLET");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return authn_quintuplet_;
    }
    TrafficFlowTemplate* traffic_flow_template() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)137):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:144:traffic_flow_template", (int64)value_case_index(), "TYPE_TRAFFIC_FLOW_TEMPLATE");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return traffic_flow_template_;
    }
    TargetID* target_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)138):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:145:target_id", (int64)value_case_index(), "TYPE_TARGET_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return target_id_;
    }
    UTRAN_TransparentContainer* utran_transparent_container() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)139):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:146:utran_transparent_container", (int64)value_case_index(), "TYPE_UTRAN_TRANSPARENT_CONTAINER");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return utran_transparent_container_;
    }
    RAB_SetupInfo* rab_setup_info() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)140):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:147:rab_setup_info", (int64)value_case_index(), "TYPE_RAB_SETUP_INFO");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return rab_setup_info_;
    }
    ExtHdrTypeList* ext_hdr_type_list() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)141):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:148:ext_hdr_type_list", (int64)value_case_index(), "TYPE_EXT_HEADER_TYPE_LIST");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ext_hdr_type_list_;
    }
    TriggerID* trigger_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)142):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:149:trigger_id", (int64)value_case_index(), "TYPE_TRIGGER_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return trigger_id_;
    }
    OMC_ID* omc_id() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)143):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:150:omc_id", (int64)value_case_index(), "TYPE_OMC_ID");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return omc_id_;
    }
    ChargingGatewayAddr* charging_gateway_addr() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)251):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:151:charging_gateway_addr", (int64)value_case_index(), "TYPE_CHARGING_GATEWAY_ADDR");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return charging_gateway_addr_;
    }
    PrivateExt* private_ext() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( value_case_index() ) {
            case ((uint8)255):
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:152:private_ext", (int64)value_case_index(), "TYPE_PRIVATE_EXT");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return private_ext_;
    }
    bytestring const& unknown() const {
        return unknown_;
    }
    bool is_tlv() const { return is_tlv_; }
    uint16 length() const { return length_; }

protected:
    uint8 type_;
    int len_case_index_;
    uint16 tlv_len_;
    uint8 value_case_index_;
    Cause* cause_;
    IMSI* imsi_;
    RAI* rai_;
    TLLI* tlli_;
    P_TMSI* p_tmsi_;
    ReorderReq* reorder_req_;
    AuthN_Triplet* authn_triplet_;
    MAP_Cause* map_cause_;
    P_TMSI_Sig* p_tmsi_sig_;
    MS_Valid* ms_valid_;
    Recovery* recovery_;
    SelectionMode* selection_mode_;
    TEID1* teid1_;
    TEID_ControlPlane* teidcp_;
    TEID2* teid2_;
    TeardownInd* teardown_ind_;
    NSAPI* nsapi_;
    RANAP_Cause* ranap_cause_;
    RAB_Ctx* rab_ctx_;
    RadioPrioritySMS* radio_priority_sms_;
    RadioPriority* radio_priority_;
    PacketFlowID* packet_flow_id_;
    ChargingCharacteristics* charging_characteristics_;
    TraceReference* trace_reference_;
    TraceType* trace_type_;
    MS_Not_Reachable_Reason* ms_not_reachable_reason_;
    ChargingID* charging_id_;
    EndUserAddr* end_user_addr_;
    MM_Ctx* mm_ctx_;
    PDP_Ctx* pdp_ctx_;
    AP_Name* ap_name_;
    ProtoConfigOpts* proto_config_opts_;
    GSN_Addr* gsn_addr_;
    MSISDN* msisdn_;
    QoS_Profile* qos_profile_;
    AuthN_Quintuplet* authn_quintuplet_;
    TrafficFlowTemplate* traffic_flow_template_;
    TargetID* target_id_;
    UTRAN_TransparentContainer* utran_transparent_container_;
    RAB_SetupInfo* rab_setup_info_;
    ExtHdrTypeList* ext_hdr_type_list_;
    TriggerID* trigger_id_;
    OMC_ID* omc_id_;
    ChargingGatewayAddr* charging_gateway_addr_;
    PrivateExt* private_ext_;
    bytestring unknown_;
    bool is_tlv_;
    uint16 length_;
};


class Cause final {
public:
    Cause();
    ~Cause();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }

protected:
    uint8 value_;
};

uint64 decode_imsi(vector<uint8>* v);

class IMSI final {
public:
    IMSI();
    ~IMSI();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    vector<uint8>* tbcd_encoded_value() const { return tbcd_encoded_value_; }
    uint64 value() const { return value_; }

protected:
    vector<uint8>* tbcd_encoded_value_;
    uint8 tbcd_encoded_value__elem_;
    uint64 value_;
};


class RAI final {
public:
    RAI();
    ~RAI();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 mcc2_mcc1() const { return mcc2_mcc1_; }
    uint8 mnc3_mcc3() const { return mnc3_mcc3_; }
    uint8 mnc2_mnc1() const { return mnc2_mnc1_; }
    uint16 lac() const { return lac_; }
    uint8 rac() const { return rac_; }
    uint8 mcc1() const { return mcc1_; }
    uint8 mcc2() const { return mcc2_; }
    uint8 mcc3() const { return mcc3_; }
    uint16 mcc() const { return mcc_; }
    uint8 mnc1() const { return mnc1_; }
    uint8 mnc2() const { return mnc2_; }
    uint8 mnc3() const { return mnc3_; }
    uint16 mnc() const { return mnc_; }

protected:
    uint8 mcc2_mcc1_;
    uint8 mnc3_mcc3_;
    uint8 mnc2_mnc1_;
    uint16 lac_;
    uint8 rac_;
    uint8 mcc1_;
    uint8 mcc2_;
    uint8 mcc3_;
    uint16 mcc_;
    uint8 mnc1_;
    uint8 mnc2_;
    uint8 mnc3_;
    uint16 mnc_;
};


class TLLI final {
public:
    TLLI();
    ~TLLI();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 value() const { return value_; }

protected:
    uint32 value_;
};


class P_TMSI final {
public:
    P_TMSI();
    ~P_TMSI();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 value() const { return value_; }

protected:
    uint32 value_;
};


class ReorderReq final {
public:
    ReorderReq();
    ~ReorderReq();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }
    bool req() const { return req_; }

protected:
    uint8 value_;
    bool req_;
};


class AuthN_Triplet final {
public:
    AuthN_Triplet();
    ~AuthN_Triplet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    bytestring const& rand() const { return rand_; }
    uint32 sres() const { return sres_; }
    uint64 kc() const { return kc_; }

protected:
    bytestring rand_;
    uint32 sres_;
    uint64 kc_;
};


class MAP_Cause final {
public:
    MAP_Cause();
    ~MAP_Cause();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }

protected:
    uint8 value_;
};


class P_TMSI_Sig final {
public:
    P_TMSI_Sig();
    ~P_TMSI_Sig();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }

protected:
    bytestring value_;
};


class MS_Valid final {
public:
    MS_Valid();
    ~MS_Valid();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }

protected:
    uint8 value_;
};


class Recovery final {
public:
    Recovery();
    ~Recovery();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 restart_counter() const { return restart_counter_; }

protected:
    uint8 restart_counter_;
};


class SelectionMode final {
public:
    SelectionMode();
    ~SelectionMode();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }
    uint8 mode() const { return mode_; }

protected:
    uint8 value_;
    uint8 mode_;
};


class TEID1 final {
public:
    TEID1();
    ~TEID1();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 value() const { return value_; }

protected:
    uint32 value_;
};


class TEID_ControlPlane final {
public:
    TEID_ControlPlane();
    ~TEID_ControlPlane();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 value() const { return value_; }

protected:
    uint32 value_;
};


class TEID2 final {
public:
    TEID2();
    ~TEID2();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 spare_nsapi() const { return spare_nsapi_; }
    uint32 teid2() const { return teid2_; }

protected:
    uint8 spare_nsapi_;
    uint32 teid2_;
};


class TeardownInd final {
public:
    TeardownInd();
    ~TeardownInd();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }
    bool ind() const { return ind_; }

protected:
    uint8 value_;
    bool ind_;
};


class NSAPI final {
public:
    NSAPI();
    ~NSAPI();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 xxxx_nsapi() const { return xxxx_nsapi_; }
    uint8 nsapi() const { return nsapi_; }

protected:
    uint8 xxxx_nsapi_;
    uint8 nsapi_;
};


class RANAP_Cause final {
public:
    RANAP_Cause();
    ~RANAP_Cause();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }

protected:
    uint8 value_;
};


class RAB_Ctx final {
public:
    RAB_Ctx();
    ~RAB_Ctx();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 spare_nsapi() const { return spare_nsapi_; }
    uint16 dl_gtpu_seq_num() const { return dl_gtpu_seq_num_; }
    uint16 ul_gtpu_seq_num() const { return ul_gtpu_seq_num_; }
    uint16 dl_pdcp_seq_num() const { return dl_pdcp_seq_num_; }
    uint16 ul_pdcp_seq_num() const { return ul_pdcp_seq_num_; }

protected:
    uint8 spare_nsapi_;
    uint16 dl_gtpu_seq_num_;
    uint16 ul_gtpu_seq_num_;
    uint16 dl_pdcp_seq_num_;
    uint16 ul_pdcp_seq_num_;
};


class RadioPrioritySMS final {
public:
    RadioPrioritySMS();
    ~RadioPrioritySMS();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }

protected:
    uint8 value_;
};


class RadioPriority final {
public:
    RadioPriority();
    ~RadioPriority();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 nsapi_radio_priority() const { return nsapi_radio_priority_; }

protected:
    uint8 nsapi_radio_priority_;
};


class PacketFlowID final {
public:
    PacketFlowID();
    ~PacketFlowID();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 rsv_nsapi() const { return rsv_nsapi_; }
    uint8 packet_flow_id() const { return packet_flow_id_; }

protected:
    uint8 rsv_nsapi_;
    uint8 packet_flow_id_;
};


class ChargingCharacteristics final {
public:
    ChargingCharacteristics();
    ~ChargingCharacteristics();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 value() const { return value_; }

protected:
    uint16 value_;
};


class TraceReference final {
public:
    TraceReference();
    ~TraceReference();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 value() const { return value_; }

protected:
    uint16 value_;
};


class TraceType final {
public:
    TraceType();
    ~TraceType();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 value() const { return value_; }

protected:
    uint16 value_;
};


class MS_Not_Reachable_Reason final {
public:
    MS_Not_Reachable_Reason();
    ~MS_Not_Reachable_Reason();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 value() const { return value_; }

protected:
    uint8 value_;
};


class ChargingID final {
public:
    ChargingID();
    ~ChargingID();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint32 value() const { return value_; }

protected:
    uint32 value_;
};


class EndUserAddr final {
public:
    EndUserAddr(uint16 n);
    ~EndUserAddr();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 spare_pdp_type_org() const { return spare_pdp_type_org_; }
    uint8 pdp_type_num() const { return pdp_type_num_; }
    bytestring const& pdp_addr() const { return pdp_addr_; }
    uint16 n() const { return n_; }
    uint8 pdp_type_org() const { return pdp_type_org_; }

protected:
    uint8 spare_pdp_type_org_;
    uint8 pdp_type_num_;
    bytestring pdp_addr_;
    uint16 n_;
    uint8 pdp_type_org_;
};


class MM_Ctx final {
public:
    MM_Ctx(uint16 n);
    ~MM_Ctx();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 spare_cksn_ksi() const { return spare_cksn_ksi_; }
    uint8 security_params() const { return security_params_; }
    int keys_case_index() const	{ return keys_case_index_; }
    uint64 kc() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( keys_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:332:kc", (int64)keys_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return kc_;
    }
    bytestring const& ck_ik() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( keys_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:333:ck_ik", (int64)keys_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return ck_ik_;
    }
    int vector_len_case_index() const	{ return vector_len_case_index_; }
    uint16 quint_len() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( vector_len_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:338:quint_len", (int64)vector_len_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return quint_len_;
    }
    int vectors_case_index() const	{ return vectors_case_index_; }
    vector<AuthN_Triplet*>* triplets() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( vectors_case_index() ) {
            case true:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:342:triplets", (int64)vectors_case_index(), "true");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return triplets_;
    }
    vector<AuthN_Quintuplet*>* quintuplets() const {
        // NOLINTBEGIN(bugprone-branch-clone)
        switch ( vectors_case_index() ) {
            case false:
                break;  // OK
            default:
                throw binpac::ExceptionInvalidCase("/build/zeek/src/zeek/src/packet_analysis/protocol/gtpv1/gtpv1-protocol.pac:343:quintuplets", (int64)vectors_case_index(), "false");
                break;
        }
        // NOLINTEND(bugprone-branch-clone)
        return quintuplets_;
    }
    uint16 drx_param() const { return drx_param_; }
    uint8 ms_net_capability_len() const { return ms_net_capability_len_; }
    bytestring const& ms_net_capability() const { return ms_net_capability_; }
    uint16 container_len() const { return container_len_; }
    bytestring const& container() const { return container_; }
    uint16 n() const { return n_; }
    uint8 security_mode() const { return security_mode_; }
    bool gsm_keys() const { return gsm_keys_; }
    bool have_triplets() const { return have_triplets_; }
    uint8 num_vectors() const { return num_vectors_; }

protected:
    uint8 spare_cksn_ksi_;
    uint8 security_params_;
    int keys_case_index_;
    uint64 kc_;
    bytestring ck_ik_;
    int vector_len_case_index_;
    uint16 quint_len_;
    int vectors_case_index_;
    vector<AuthN_Triplet*>* triplets_;
    AuthN_Triplet* triplets__elem_;
    vector<AuthN_Quintuplet*>* quintuplets_;
    AuthN_Quintuplet* quintuplets__elem_;
    uint16 drx_param_;
    uint8 ms_net_capability_len_;
    bytestring ms_net_capability_;
    uint16 container_len_;
    bytestring container_;
    uint16 n_;
    uint8 security_mode_;
    bool gsm_keys_;
    bool have_triplets_;
    uint8 num_vectors_;
};


class PDP_Ctx final {
public:
    PDP_Ctx(uint16 n);
    ~PDP_Ctx();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 rsv_nsapi() const { return rsv_nsapi_; }
    uint8 xxxx_sapi() const { return xxxx_sapi_; }
    uint8 qos_sub_len() const { return qos_sub_len_; }
    QoS_Profile* qos_sub() const { return qos_sub_; }
    uint8 qos_req_len() const { return qos_req_len_; }
    QoS_Profile* qos_req() const { return qos_req_; }
    uint8 qos_neg_len() const { return qos_neg_len_; }
    QoS_Profile* qos_neg() const { return qos_neg_; }
    uint16 snd() const { return snd_; }
    uint16 snu() const { return snu_; }
    uint8 send_npdu_num() const { return send_npdu_num_; }
    uint8 recv_npdu_num() const { return recv_npdu_num_; }
    TEID_ControlPlane* ul_teid_cp() const { return ul_teid_cp_; }
    TEID1* ul_teid_data1() const { return ul_teid_data1_; }
    uint8 pdp_ctx_id() const { return pdp_ctx_id_; }
    uint8 spare_pdp_type_org() const { return spare_pdp_type_org_; }
    uint8 pdp_type_num() const { return pdp_type_num_; }
    uint8 pdp_addr_len() const { return pdp_addr_len_; }
    bytestring const& pdp_addr() const { return pdp_addr_; }
    uint8 ggsn_addr_control_plane_len() const { return ggsn_addr_control_plane_len_; }
    bytestring const& ggsn_addr_control_plane() const { return ggsn_addr_control_plane_; }
    uint8 ggsn_addr_user_traffic_len() const { return ggsn_addr_user_traffic_len_; }
    bytestring const& ggsn_addr_user_traffic() const { return ggsn_addr_user_traffic_; }
    uint8 apn_len() const { return apn_len_; }
    AP_Name* apn() const { return apn_; }
    uint8 spare_transaction_id() const { return spare_transaction_id_; }
    uint8 transaction_id() const { return transaction_id_; }
    uint16 n() const { return n_; }

protected:
    uint8 rsv_nsapi_;
    uint8 xxxx_sapi_;
    uint8 qos_sub_len_;
    QoS_Profile* qos_sub_;
    uint8 qos_req_len_;
    QoS_Profile* qos_req_;
    uint8 qos_neg_len_;
    QoS_Profile* qos_neg_;
    uint16 snd_;
    uint16 snu_;
    uint8 send_npdu_num_;
    uint8 recv_npdu_num_;
    TEID_ControlPlane* ul_teid_cp_;
    TEID1* ul_teid_data1_;
    uint8 pdp_ctx_id_;
    uint8 spare_pdp_type_org_;
    uint8 pdp_type_num_;
    uint8 pdp_addr_len_;
    bytestring pdp_addr_;
    uint8 ggsn_addr_control_plane_len_;
    bytestring ggsn_addr_control_plane_;
    uint8 ggsn_addr_user_traffic_len_;
    bytestring ggsn_addr_user_traffic_;
    uint8 apn_len_;
    AP_Name* apn_;
    uint8 spare_transaction_id_;
    uint8 transaction_id_;
    uint16 n_;
};


class AP_Name final {
public:
    AP_Name(uint16 n);
    ~AP_Name();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class ProtoConfigOpts final {
public:
    ProtoConfigOpts(uint16 n);
    ~ProtoConfigOpts();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class GSN_Addr final {
public:
    GSN_Addr(uint16 n);
    ~GSN_Addr();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class MSISDN final {
public:
    MSISDN(uint16 n);
    ~MSISDN();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class QoS_Profile final {
public:
    QoS_Profile(uint16 n);
    ~QoS_Profile();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    uint8 alloc_retention_priority() const { return alloc_retention_priority_; }
    bytestring const& data() const { return data_; }
    uint16 n() const { return n_; }

protected:
    uint8 alloc_retention_priority_;
    bytestring data_;
    uint16 n_;
};


class AuthN_Quintuplet final {
public:
    AuthN_Quintuplet(uint16 n);
    ~AuthN_Quintuplet();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& rand() const { return rand_; }
    uint8 xres_len() const { return xres_len_; }
    bytestring const& xres() const { return xres_; }
    bytestring const& ck() const { return ck_; }
    bytestring const& ik() const { return ik_; }
    uint8 autn_len() const { return autn_len_; }
    bytestring const& autn() const { return autn_; }
    uint16 n() const { return n_; }

protected:
    bytestring rand_;
    uint8 xres_len_;
    bytestring xres_;
    bytestring ck_;
    bytestring ik_;
    uint8 autn_len_;
    bytestring autn_;
    uint16 n_;
};


class TrafficFlowTemplate final {
public:
    TrafficFlowTemplate(uint16 n);
    ~TrafficFlowTemplate();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class TargetID final {
public:
    TargetID(uint16 n);
    ~TargetID();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class UTRAN_TransparentContainer final {
public:
    UTRAN_TransparentContainer(uint16 n);
    ~UTRAN_TransparentContainer();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class RAB_SetupInfo final {
public:
    RAB_SetupInfo(uint16 n);
    ~RAB_SetupInfo();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint8 xxxx_nsapi() const { return xxxx_nsapi_; }
    uint16 have_teid_case_index() const	{ return have_teid_case_index_; }
    TEID1* teid() const {
        return teid_;
    }
    uint16 have_addr_case_index() const	{ return have_addr_case_index_; }
    bytestring const& rnc_addr() const {
        return rnc_addr_;
    }
    uint16 n() const { return n_; }

protected:
    uint8 xxxx_nsapi_;
    uint16 have_teid_case_index_;
    TEID1* teid_;
    uint16 have_addr_case_index_;
    bytestring rnc_addr_;
    uint16 n_;
};


class ExtHdrTypeList final {
public:
    ExtHdrTypeList(uint16 n);
    ~ExtHdrTypeList();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    vector<uint8>* value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    vector<uint8>* value_;
    uint8 value__elem_;
    uint16 n_;
};


class TriggerID final {
public:
    TriggerID(uint16 n);
    ~TriggerID();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class OMC_ID final {
public:
    OMC_ID(uint16 n);
    ~OMC_ID();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class ChargingGatewayAddr final {
public:
    ChargingGatewayAddr(uint16 n);
    ~ChargingGatewayAddr();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data);

    // Member access functions
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    bytestring value_;
    uint16 n_;
};


class PrivateExt final {
public:
    PrivateExt(uint16 n);
    ~PrivateExt();
    int Parse(const_byteptr const t_begin_of_data, const_byteptr const t_end_of_data, int t_byteorder);

    // Member access functions
    uint16 id() const { return id_; }
    bytestring const& value() const { return value_; }
    uint16 n() const { return n_; }

protected:
    uint16 id_;
    bytestring value_;
    uint16 n_;
};

uint16 Get_IE_Len(uint8 t);

class GTPv1_Conn final : public binpac::ConnectionAnalyzer {
public:
    GTPv1_Conn(ZeekPacketAnalyzer const& zeek_analyzer);
    ~GTPv1_Conn() override;

    // Member access functions
    GTPv1_Flow* upflow() const { return upflow_; }
    GTPv1_Flow* downflow() const { return downflow_; }
    ZeekPacketAnalyzer const& zeek_analyzer() const { return zeek_analyzer_; }

    void NewData(bool is_orig, const_byteptr begin, const_byteptr end) override;
    void NewGap(bool is_orig, int gap_length);
    void FlowEOF(bool is_orig);

    // Functions
    bool valid(bool orig);
    void set_valid(bool orig, bool val);
    void set_raw_packet(ZeekPacket* p);
    ZeekPacket* get_raw_packet();

protected:

    // Additional members

		bool valid_orig;
		bool valid_resp;
		ZeekPacket* packet;
	
    GTPv1_Flow* upflow_;
    GTPv1_Flow* downflow_;
    ZeekPacketAnalyzer zeek_analyzer_;
};


class GTPv1_Flow final : public binpac::FlowAnalyzer {
public:
    GTPv1_Flow(GTPv1_Conn* connection, bool is_orig);
    ~GTPv1_Flow() override;

    // Member access functions
    GTPv1_Conn* connection() const { return connection_; }
    bool is_orig() const { return is_orig_; }

    void NewData(const_byteptr t_begin_of_data, const_byteptr t_end_of_data) override;
    void NewGap(int gap_length);
    void FlowEOF();

    // Functions
    void violate(string const& r, GTPv1_Header* pdu);
    bool process_gtpv1(GTPv1_Header* pdu);
    bool process_g_pdu(GTPv1_Header* pdu);

protected:
    GTPv1_Header* dataunit_;
    ContextGTPv1* context_;
    GTPv1_Conn* connection_;
    bool is_orig_;
};

} // namespace GTPv1
}  // namespace binpac
#endif /* _build_zeek_src_zeek_src_packet_analysis_protocol_gtpv1_gtpv1_pac_h */
